<?php
/**
 * ProcessedBasketLine
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * ProcessedBasketLine Class Doc Comment
 *
 * @category Class
 * @description A line within a basket of products after calculation of any applicable  discounts and promotions.
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ProcessedBasketLine implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ProcessedBasketLine';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'source_line_identifier' => 'string',
        'item_location_detail_id' => 'int',
        'quantity' => 'float',
        'regular_unit_price' => 'float',
        'actual_unit_price' => 'float',
        'sales_tax' => 'float',
        'comment' => 'string',
        'serial_number' => 'string',
        'seat_number' => 'int',
        'line_benefits' => '\Opsuite2\Model\ProcessedBasketLineBenefit[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'source_line_identifier' => null,
        'item_location_detail_id' => 'int32',
        'quantity' => 'double',
        'regular_unit_price' => 'double',
        'actual_unit_price' => 'double',
        'sales_tax' => 'double',
        'comment' => null,
        'serial_number' => null,
        'seat_number' => 'int32',
        'line_benefits' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'source_line_identifier' => true,
        'item_location_detail_id' => false,
        'quantity' => false,
        'regular_unit_price' => false,
        'actual_unit_price' => false,
        'sales_tax' => false,
        'comment' => true,
        'serial_number' => true,
        'seat_number' => true,
        'line_benefits' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'source_line_identifier' => 'sourceLineIdentifier',
        'item_location_detail_id' => 'itemLocationDetailId',
        'quantity' => 'quantity',
        'regular_unit_price' => 'regularUnitPrice',
        'actual_unit_price' => 'actualUnitPrice',
        'sales_tax' => 'salesTax',
        'comment' => 'comment',
        'serial_number' => 'serialNumber',
        'seat_number' => 'seatNumber',
        'line_benefits' => 'lineBenefits'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'source_line_identifier' => 'setSourceLineIdentifier',
        'item_location_detail_id' => 'setItemLocationDetailId',
        'quantity' => 'setQuantity',
        'regular_unit_price' => 'setRegularUnitPrice',
        'actual_unit_price' => 'setActualUnitPrice',
        'sales_tax' => 'setSalesTax',
        'comment' => 'setComment',
        'serial_number' => 'setSerialNumber',
        'seat_number' => 'setSeatNumber',
        'line_benefits' => 'setLineBenefits'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'source_line_identifier' => 'getSourceLineIdentifier',
        'item_location_detail_id' => 'getItemLocationDetailId',
        'quantity' => 'getQuantity',
        'regular_unit_price' => 'getRegularUnitPrice',
        'actual_unit_price' => 'getActualUnitPrice',
        'sales_tax' => 'getSalesTax',
        'comment' => 'getComment',
        'serial_number' => 'getSerialNumber',
        'seat_number' => 'getSeatNumber',
        'line_benefits' => 'getLineBenefits'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('source_line_identifier', $data ?? [], null);
        $this->setIfExists('item_location_detail_id', $data ?? [], null);
        $this->setIfExists('quantity', $data ?? [], null);
        $this->setIfExists('regular_unit_price', $data ?? [], null);
        $this->setIfExists('actual_unit_price', $data ?? [], null);
        $this->setIfExists('sales_tax', $data ?? [], null);
        $this->setIfExists('comment', $data ?? [], null);
        $this->setIfExists('serial_number', $data ?? [], null);
        $this->setIfExists('seat_number', $data ?? [], null);
        $this->setIfExists('line_benefits', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets source_line_identifier
     *
     * @return string|null
     */
    public function getSourceLineIdentifier()
    {
        return $this->container['source_line_identifier'];
    }

    /**
     * Sets source_line_identifier
     *
     * @param string|null $source_line_identifier The identifier of the source line within the submitted basket.  Source lines within the submitted basket may be split into multiple lines in the calculation.
     *
     * @return self
     */
    public function setSourceLineIdentifier($source_line_identifier)
    {
        if (is_null($source_line_identifier)) {
            array_push($this->openAPINullablesSetToNull, 'source_line_identifier');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('source_line_identifier', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['source_line_identifier'] = $source_line_identifier;

        return $this;
    }

    /**
     * Gets item_location_detail_id
     *
     * @return int|null
     */
    public function getItemLocationDetailId()
    {
        return $this->container['item_location_detail_id'];
    }

    /**
     * Sets item_location_detail_id
     *
     * @param int|null $item_location_detail_id The id of the item location detail record.
     *
     * @return self
     */
    public function setItemLocationDetailId($item_location_detail_id)
    {
        if (is_null($item_location_detail_id)) {
            throw new \InvalidArgumentException('non-nullable item_location_detail_id cannot be null');
        }
        $this->container['item_location_detail_id'] = $item_location_detail_id;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param float|null $quantity The quantity of individual products in the line.
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        if (is_null($quantity)) {
            throw new \InvalidArgumentException('non-nullable quantity cannot be null');
        }
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets regular_unit_price
     *
     * @return float|null
     */
    public function getRegularUnitPrice()
    {
        return $this->container['regular_unit_price'];
    }

    /**
     * Sets regular_unit_price
     *
     * @param float|null $regular_unit_price The regular unit price of the product before calculation of discounts and promotions.  Will include tax if the Basket.IsTaxInclusivePrices = true.
     *
     * @return self
     */
    public function setRegularUnitPrice($regular_unit_price)
    {
        if (is_null($regular_unit_price)) {
            throw new \InvalidArgumentException('non-nullable regular_unit_price cannot be null');
        }
        $this->container['regular_unit_price'] = $regular_unit_price;

        return $this;
    }

    /**
     * Gets actual_unit_price
     *
     * @return float|null
     */
    public function getActualUnitPrice()
    {
        return $this->container['actual_unit_price'];
    }

    /**
     * Sets actual_unit_price
     *
     * @param float|null $actual_unit_price The actual unit price of the product after calculation of applicable promotions and discounts.  Will include tax if the Basket.IsTaxInclusivePrices = true.
     *
     * @return self
     */
    public function setActualUnitPrice($actual_unit_price)
    {
        if (is_null($actual_unit_price)) {
            throw new \InvalidArgumentException('non-nullable actual_unit_price cannot be null');
        }
        $this->container['actual_unit_price'] = $actual_unit_price;

        return $this;
    }

    /**
     * Gets sales_tax
     *
     * @return float|null
     */
    public function getSalesTax()
    {
        return $this->container['sales_tax'];
    }

    /**
     * Sets sales_tax
     *
     * @param float|null $sales_tax The sales tax calculated for the line.
     *
     * @return self
     */
    public function setSalesTax($sales_tax)
    {
        if (is_null($sales_tax)) {
            throw new \InvalidArgumentException('non-nullable sales_tax cannot be null');
        }
        $this->container['sales_tax'] = $sales_tax;

        return $this;
    }

    /**
     * Gets comment
     *
     * @return string|null
     */
    public function getComment()
    {
        return $this->container['comment'];
    }

    /**
     * Sets comment
     *
     * @param string|null $comment Any comment associated with this line.
     *
     * @return self
     */
    public function setComment($comment)
    {
        if (is_null($comment)) {
            array_push($this->openAPINullablesSetToNull, 'comment');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('comment', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['comment'] = $comment;

        return $this;
    }

    /**
     * Gets serial_number
     *
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->container['serial_number'];
    }

    /**
     * Sets serial_number
     *
     * @param string|null $serial_number Any serial number associated with this line - e.g. gift card number
     *
     * @return self
     */
    public function setSerialNumber($serial_number)
    {
        if (is_null($serial_number)) {
            array_push($this->openAPINullablesSetToNull, 'serial_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('serial_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['serial_number'] = $serial_number;

        return $this;
    }

    /**
     * Gets seat_number
     *
     * @return int|null
     */
    public function getSeatNumber()
    {
        return $this->container['seat_number'];
    }

    /**
     * Sets seat_number
     *
     * @param int|null $seat_number Any seat number associated with this line
     *
     * @return self
     */
    public function setSeatNumber($seat_number)
    {
        if (is_null($seat_number)) {
            array_push($this->openAPINullablesSetToNull, 'seat_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('seat_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['seat_number'] = $seat_number;

        return $this;
    }

    /**
     * Gets line_benefits
     *
     * @return \Opsuite2\Model\ProcessedBasketLineBenefit[]|null
     */
    public function getLineBenefits()
    {
        return $this->container['line_benefits'];
    }

    /**
     * Sets line_benefits
     *
     * @param \Opsuite2\Model\ProcessedBasketLineBenefit[]|null $line_benefits The benefits (savings) that have accrued for this line after calculation of any applicable promotions.
     *
     * @return self
     */
    public function setLineBenefits($line_benefits)
    {
        if (is_null($line_benefits)) {
            array_push($this->openAPINullablesSetToNull, 'line_benefits');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('line_benefits', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['line_benefits'] = $line_benefits;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


