<?php
/**
 * ProcessedBasketBenefit
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * ProcessedBasketBenefit Class Doc Comment
 *
 * @category Class
 * @description A benefit or saving applicable to a basket, due to the specified promotion.
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ProcessedBasketBenefit implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ProcessedBasketBenefit';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'sequence_no' => 'int',
        'description' => 'string',
        'saving' => 'float',
        'discount_reason_code_id' => 'int',
        'benefit_key' => 'string',
        'benefit_type_id' => 'int',
        'promotion_id' => 'int',
        'promotion_last_updated' => '\DateTime',
        'points_to_be_redeemed' => 'int',
        'loyalty_type_id' => 'int',
        'redeemed_bounce_back_coupon_serial_numbers' => 'string[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'sequence_no' => 'int32',
        'description' => null,
        'saving' => 'double',
        'discount_reason_code_id' => 'int32',
        'benefit_key' => null,
        'benefit_type_id' => 'int32',
        'promotion_id' => 'int32',
        'promotion_last_updated' => 'date-time',
        'points_to_be_redeemed' => 'int32',
        'loyalty_type_id' => 'int32',
        'redeemed_bounce_back_coupon_serial_numbers' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'sequence_no' => false,
        'description' => true,
        'saving' => false,
        'discount_reason_code_id' => true,
        'benefit_key' => true,
        'benefit_type_id' => false,
        'promotion_id' => true,
        'promotion_last_updated' => true,
        'points_to_be_redeemed' => true,
        'loyalty_type_id' => true,
        'redeemed_bounce_back_coupon_serial_numbers' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'sequence_no' => 'sequenceNo',
        'description' => 'description',
        'saving' => 'saving',
        'discount_reason_code_id' => 'discountReasonCodeId',
        'benefit_key' => 'benefitKey',
        'benefit_type_id' => 'benefitTypeId',
        'promotion_id' => 'promotionId',
        'promotion_last_updated' => 'promotionLastUpdated',
        'points_to_be_redeemed' => 'pointsToBeRedeemed',
        'loyalty_type_id' => 'loyaltyTypeId',
        'redeemed_bounce_back_coupon_serial_numbers' => 'redeemedBounceBackCouponSerialNumbers'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'sequence_no' => 'setSequenceNo',
        'description' => 'setDescription',
        'saving' => 'setSaving',
        'discount_reason_code_id' => 'setDiscountReasonCodeId',
        'benefit_key' => 'setBenefitKey',
        'benefit_type_id' => 'setBenefitTypeId',
        'promotion_id' => 'setPromotionId',
        'promotion_last_updated' => 'setPromotionLastUpdated',
        'points_to_be_redeemed' => 'setPointsToBeRedeemed',
        'loyalty_type_id' => 'setLoyaltyTypeId',
        'redeemed_bounce_back_coupon_serial_numbers' => 'setRedeemedBounceBackCouponSerialNumbers'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'sequence_no' => 'getSequenceNo',
        'description' => 'getDescription',
        'saving' => 'getSaving',
        'discount_reason_code_id' => 'getDiscountReasonCodeId',
        'benefit_key' => 'getBenefitKey',
        'benefit_type_id' => 'getBenefitTypeId',
        'promotion_id' => 'getPromotionId',
        'promotion_last_updated' => 'getPromotionLastUpdated',
        'points_to_be_redeemed' => 'getPointsToBeRedeemed',
        'loyalty_type_id' => 'getLoyaltyTypeId',
        'redeemed_bounce_back_coupon_serial_numbers' => 'getRedeemedBounceBackCouponSerialNumbers'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('sequence_no', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('saving', $data ?? [], null);
        $this->setIfExists('discount_reason_code_id', $data ?? [], null);
        $this->setIfExists('benefit_key', $data ?? [], null);
        $this->setIfExists('benefit_type_id', $data ?? [], null);
        $this->setIfExists('promotion_id', $data ?? [], null);
        $this->setIfExists('promotion_last_updated', $data ?? [], null);
        $this->setIfExists('points_to_be_redeemed', $data ?? [], null);
        $this->setIfExists('loyalty_type_id', $data ?? [], null);
        $this->setIfExists('redeemed_bounce_back_coupon_serial_numbers', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets sequence_no
     *
     * @return int|null
     */
    public function getSequenceNo()
    {
        return $this->container['sequence_no'];
    }

    /**
     * Sets sequence_no
     *
     * @param int|null $sequence_no An identifier for this basket benefit.
     *
     * @return self
     */
    public function setSequenceNo($sequence_no)
    {
        if (is_null($sequence_no)) {
            throw new \InvalidArgumentException('non-nullable sequence_no cannot be null');
        }
        $this->container['sequence_no'] = $sequence_no;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description The description of the benefit, usually the promotion description.
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            array_push($this->openAPINullablesSetToNull, 'description');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('description', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets saving
     *
     * @return float|null
     */
    public function getSaving()
    {
        return $this->container['saving'];
    }

    /**
     * Sets saving
     *
     * @param float|null $saving The saving accrued.
     *
     * @return self
     */
    public function setSaving($saving)
    {
        if (is_null($saving)) {
            throw new \InvalidArgumentException('non-nullable saving cannot be null');
        }
        $this->container['saving'] = $saving;

        return $this;
    }

    /**
     * Gets discount_reason_code_id
     *
     * @return int|null
     */
    public function getDiscountReasonCodeId()
    {
        return $this->container['discount_reason_code_id'];
    }

    /**
     * Sets discount_reason_code_id
     *
     * @param int|null $discount_reason_code_id The associated reason code id.
     *
     * @return self
     */
    public function setDiscountReasonCodeId($discount_reason_code_id)
    {
        if (is_null($discount_reason_code_id)) {
            array_push($this->openAPINullablesSetToNull, 'discount_reason_code_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('discount_reason_code_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['discount_reason_code_id'] = $discount_reason_code_id;

        return $this;
    }

    /**
     * Gets benefit_key
     *
     * @return string|null
     */
    public function getBenefitKey()
    {
        return $this->container['benefit_key'];
    }

    /**
     * Sets benefit_key
     *
     * @param string|null $benefit_key A character to be used on a receipt, if issued, to associate product lines with savings.
     *
     * @return self
     */
    public function setBenefitKey($benefit_key)
    {
        if (is_null($benefit_key)) {
            array_push($this->openAPINullablesSetToNull, 'benefit_key');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('benefit_key', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['benefit_key'] = $benefit_key;

        return $this;
    }

    /**
     * Gets benefit_type_id
     *
     * @return int|null
     */
    public function getBenefitTypeId()
    {
        return $this->container['benefit_type_id'];
    }

    /**
     * Sets benefit_type_id
     *
     * @param int|null $benefit_type_id The id of the benefit type.
     *
     * @return self
     */
    public function setBenefitTypeId($benefit_type_id)
    {
        if (is_null($benefit_type_id)) {
            throw new \InvalidArgumentException('non-nullable benefit_type_id cannot be null');
        }
        $this->container['benefit_type_id'] = $benefit_type_id;

        return $this;
    }

    /**
     * Gets promotion_id
     *
     * @return int|null
     */
    public function getPromotionId()
    {
        return $this->container['promotion_id'];
    }

    /**
     * Sets promotion_id
     *
     * @param int|null $promotion_id The id of the promotion that generated the saving, if applicable.
     *
     * @return self
     */
    public function setPromotionId($promotion_id)
    {
        if (is_null($promotion_id)) {
            array_push($this->openAPINullablesSetToNull, 'promotion_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('promotion_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['promotion_id'] = $promotion_id;

        return $this;
    }

    /**
     * Gets promotion_last_updated
     *
     * @return \DateTime|null
     */
    public function getPromotionLastUpdated()
    {
        return $this->container['promotion_last_updated'];
    }

    /**
     * Sets promotion_last_updated
     *
     * @param \DateTime|null $promotion_last_updated The last updated date of the promotion that generated the saving, if applicable.
     *
     * @return self
     */
    public function setPromotionLastUpdated($promotion_last_updated)
    {
        if (is_null($promotion_last_updated)) {
            array_push($this->openAPINullablesSetToNull, 'promotion_last_updated');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('promotion_last_updated', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['promotion_last_updated'] = $promotion_last_updated;

        return $this;
    }

    /**
     * Gets points_to_be_redeemed
     *
     * @return int|null
     */
    public function getPointsToBeRedeemed()
    {
        return $this->container['points_to_be_redeemed'];
    }

    /**
     * Sets points_to_be_redeemed
     *
     * @param int|null $points_to_be_redeemed The number of loyalty points that will be redeemed when the basket is converted to a sale, if applicable.
     *
     * @return self
     */
    public function setPointsToBeRedeemed($points_to_be_redeemed)
    {
        if (is_null($points_to_be_redeemed)) {
            array_push($this->openAPINullablesSetToNull, 'points_to_be_redeemed');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('points_to_be_redeemed', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['points_to_be_redeemed'] = $points_to_be_redeemed;

        return $this;
    }

    /**
     * Gets loyalty_type_id
     *
     * @return int|null
     */
    public function getLoyaltyTypeId()
    {
        return $this->container['loyalty_type_id'];
    }

    /**
     * Sets loyalty_type_id
     *
     * @param int|null $loyalty_type_id The type of loyalty points that will be redeemed when the basket is converted to a sale, if applicable.
     *
     * @return self
     */
    public function setLoyaltyTypeId($loyalty_type_id)
    {
        if (is_null($loyalty_type_id)) {
            array_push($this->openAPINullablesSetToNull, 'loyalty_type_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('loyalty_type_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['loyalty_type_id'] = $loyalty_type_id;

        return $this;
    }

    /**
     * Gets redeemed_bounce_back_coupon_serial_numbers
     *
     * @return string[]|null
     */
    public function getRedeemedBounceBackCouponSerialNumbers()
    {
        return $this->container['redeemed_bounce_back_coupon_serial_numbers'];
    }

    /**
     * Sets redeemed_bounce_back_coupon_serial_numbers
     *
     * @param string[]|null $redeemed_bounce_back_coupon_serial_numbers Array of promotion coupon serial numbers that have been redeemed.
     *
     * @return self
     */
    public function setRedeemedBounceBackCouponSerialNumbers($redeemed_bounce_back_coupon_serial_numbers)
    {
        if (is_null($redeemed_bounce_back_coupon_serial_numbers)) {
            array_push($this->openAPINullablesSetToNull, 'redeemed_bounce_back_coupon_serial_numbers');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('redeemed_bounce_back_coupon_serial_numbers', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['redeemed_bounce_back_coupon_serial_numbers'] = $redeemed_bounce_back_coupon_serial_numbers;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


