<?php
/**
 * ProcessedBasket
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * ProcessedBasket Class Doc Comment
 *
 * @category Class
 * @description A basket of products after calculation of any applicable promotions.
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ProcessedBasket implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ProcessedBasket';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'location_id' => 'int',
        'customer_id' => 'int',
        'is_tax_inclusive_prices' => 'bool',
        'date_created' => '\DateTime',
        'expiry_date' => '\DateTime',
        'basket_total' => 'float',
        'table_id' => 'int',
        'basket_lines' => '\Opsuite2\Model\ProcessedBasketLine[]',
        'benefits' => '\Opsuite2\Model\ProcessedBasketBenefit[]',
        'discount_coupons' => '\Opsuite2\Model\ProcessedBasketCoupon[]',
        'promotion_coupons' => '\Opsuite2\Model\ProcessedBasketCoupon[]',
        'bounce_back_coupons' => '\Opsuite2\Model\ProcessedBasketCoupon[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'int32',
        'location_id' => 'int32',
        'customer_id' => 'int32',
        'is_tax_inclusive_prices' => null,
        'date_created' => 'date-time',
        'expiry_date' => 'date-time',
        'basket_total' => 'double',
        'table_id' => 'int32',
        'basket_lines' => null,
        'benefits' => null,
        'discount_coupons' => null,
        'promotion_coupons' => null,
        'bounce_back_coupons' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'location_id' => false,
        'customer_id' => true,
        'is_tax_inclusive_prices' => false,
        'date_created' => false,
        'expiry_date' => false,
        'basket_total' => false,
        'table_id' => true,
        'basket_lines' => true,
        'benefits' => true,
        'discount_coupons' => true,
        'promotion_coupons' => true,
        'bounce_back_coupons' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'location_id' => 'locationId',
        'customer_id' => 'customerId',
        'is_tax_inclusive_prices' => 'isTaxInclusivePrices',
        'date_created' => 'dateCreated',
        'expiry_date' => 'expiryDate',
        'basket_total' => 'basketTotal',
        'table_id' => 'tableId',
        'basket_lines' => 'basketLines',
        'benefits' => 'benefits',
        'discount_coupons' => 'discountCoupons',
        'promotion_coupons' => 'promotionCoupons',
        'bounce_back_coupons' => 'bounceBackCoupons'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'location_id' => 'setLocationId',
        'customer_id' => 'setCustomerId',
        'is_tax_inclusive_prices' => 'setIsTaxInclusivePrices',
        'date_created' => 'setDateCreated',
        'expiry_date' => 'setExpiryDate',
        'basket_total' => 'setBasketTotal',
        'table_id' => 'setTableId',
        'basket_lines' => 'setBasketLines',
        'benefits' => 'setBenefits',
        'discount_coupons' => 'setDiscountCoupons',
        'promotion_coupons' => 'setPromotionCoupons',
        'bounce_back_coupons' => 'setBounceBackCoupons'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'location_id' => 'getLocationId',
        'customer_id' => 'getCustomerId',
        'is_tax_inclusive_prices' => 'getIsTaxInclusivePrices',
        'date_created' => 'getDateCreated',
        'expiry_date' => 'getExpiryDate',
        'basket_total' => 'getBasketTotal',
        'table_id' => 'getTableId',
        'basket_lines' => 'getBasketLines',
        'benefits' => 'getBenefits',
        'discount_coupons' => 'getDiscountCoupons',
        'promotion_coupons' => 'getPromotionCoupons',
        'bounce_back_coupons' => 'getBounceBackCoupons'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('location_id', $data ?? [], null);
        $this->setIfExists('customer_id', $data ?? [], null);
        $this->setIfExists('is_tax_inclusive_prices', $data ?? [], null);
        $this->setIfExists('date_created', $data ?? [], null);
        $this->setIfExists('expiry_date', $data ?? [], null);
        $this->setIfExists('basket_total', $data ?? [], null);
        $this->setIfExists('table_id', $data ?? [], null);
        $this->setIfExists('basket_lines', $data ?? [], null);
        $this->setIfExists('benefits', $data ?? [], null);
        $this->setIfExists('discount_coupons', $data ?? [], null);
        $this->setIfExists('promotion_coupons', $data ?? [], null);
        $this->setIfExists('bounce_back_coupons', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id Id of the saved basket.
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets location_id
     *
     * @return int|null
     */
    public function getLocationId()
    {
        return $this->container['location_id'];
    }

    /**
     * Sets location_id
     *
     * @param int|null $location_id The id of the location associated with this basket.
     *
     * @return self
     */
    public function setLocationId($location_id)
    {
        if (is_null($location_id)) {
            throw new \InvalidArgumentException('non-nullable location_id cannot be null');
        }
        $this->container['location_id'] = $location_id;

        return $this;
    }

    /**
     * Gets customer_id
     *
     * @return int|null
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     *
     * @param int|null $customer_id The customer id, if applicable.
     *
     * @return self
     */
    public function setCustomerId($customer_id)
    {
        if (is_null($customer_id)) {
            array_push($this->openAPINullablesSetToNull, 'customer_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('customer_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets is_tax_inclusive_prices
     *
     * @return bool|null
     */
    public function getIsTaxInclusivePrices()
    {
        return $this->container['is_tax_inclusive_prices'];
    }

    /**
     * Sets is_tax_inclusive_prices
     *
     * @param bool|null $is_tax_inclusive_prices Whether prices in the basket are tax inclusive.
     *
     * @return self
     */
    public function setIsTaxInclusivePrices($is_tax_inclusive_prices)
    {
        if (is_null($is_tax_inclusive_prices)) {
            throw new \InvalidArgumentException('non-nullable is_tax_inclusive_prices cannot be null');
        }
        $this->container['is_tax_inclusive_prices'] = $is_tax_inclusive_prices;

        return $this;
    }

    /**
     * Gets date_created
     *
     * @return \DateTime|null
     */
    public function getDateCreated()
    {
        return $this->container['date_created'];
    }

    /**
     * Sets date_created
     *
     * @param \DateTime|null $date_created Date and time when basket was created.
     *
     * @return self
     */
    public function setDateCreated($date_created)
    {
        if (is_null($date_created)) {
            throw new \InvalidArgumentException('non-nullable date_created cannot be null');
        }
        $this->container['date_created'] = $date_created;

        return $this;
    }

    /**
     * Gets expiry_date
     *
     * @return \DateTime|null
     */
    public function getExpiryDate()
    {
        return $this->container['expiry_date'];
    }

    /**
     * Sets expiry_date
     *
     * @param \DateTime|null $expiry_date Date and time when basket with calculated benefits will expire.  This date can be extended further through OpSuite in the Company Setup > API settings.
     *
     * @return self
     */
    public function setExpiryDate($expiry_date)
    {
        if (is_null($expiry_date)) {
            throw new \InvalidArgumentException('non-nullable expiry_date cannot be null');
        }
        $this->container['expiry_date'] = $expiry_date;

        return $this;
    }

    /**
     * Gets basket_total
     *
     * @return float|null
     */
    public function getBasketTotal()
    {
        return $this->container['basket_total'];
    }

    /**
     * Sets basket_total
     *
     * @param float|null $basket_total The calculated basket total to be used as the tender amount when converting the basket to a sale  Note that this might not exactly match the sum of the basket lines due to rounding
     *
     * @return self
     */
    public function setBasketTotal($basket_total)
    {
        if (is_null($basket_total)) {
            throw new \InvalidArgumentException('non-nullable basket_total cannot be null');
        }
        $this->container['basket_total'] = $basket_total;

        return $this;
    }

    /**
     * Gets table_id
     *
     * @return int|null
     */
    public function getTableId()
    {
        return $this->container['table_id'];
    }

    /**
     * Sets table_id
     *
     * @param int|null $table_id The customer id, if applicable.
     *
     * @return self
     */
    public function setTableId($table_id)
    {
        if (is_null($table_id)) {
            array_push($this->openAPINullablesSetToNull, 'table_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('table_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['table_id'] = $table_id;

        return $this;
    }

    /**
     * Gets basket_lines
     *
     * @return \Opsuite2\Model\ProcessedBasketLine[]|null
     */
    public function getBasketLines()
    {
        return $this->container['basket_lines'];
    }

    /**
     * Sets basket_lines
     *
     * @param \Opsuite2\Model\ProcessedBasketLine[]|null $basket_lines The product lines in the basket after calculation of any applicable  discounts and promotions.
     *
     * @return self
     */
    public function setBasketLines($basket_lines)
    {
        if (is_null($basket_lines)) {
            array_push($this->openAPINullablesSetToNull, 'basket_lines');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('basket_lines', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['basket_lines'] = $basket_lines;

        return $this;
    }

    /**
     * Gets benefits
     *
     * @return \Opsuite2\Model\ProcessedBasketBenefit[]|null
     */
    public function getBenefits()
    {
        return $this->container['benefits'];
    }

    /**
     * Sets benefits
     *
     * @param \Opsuite2\Model\ProcessedBasketBenefit[]|null $benefits The benefits (savings) that have accrued after calculation of any  applicable discounts and promotions
     *
     * @return self
     */
    public function setBenefits($benefits)
    {
        if (is_null($benefits)) {
            array_push($this->openAPINullablesSetToNull, 'benefits');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('benefits', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['benefits'] = $benefits;

        return $this;
    }

    /**
     * Gets discount_coupons
     *
     * @return \Opsuite2\Model\ProcessedBasketCoupon[]|null
     */
    public function getDiscountCoupons()
    {
        return $this->container['discount_coupons'];
    }

    /**
     * Sets discount_coupons
     *
     * @param \Opsuite2\Model\ProcessedBasketCoupon[]|null $discount_coupons Array of the discount coupons that were submitted with the basket.
     *
     * @return self
     */
    public function setDiscountCoupons($discount_coupons)
    {
        if (is_null($discount_coupons)) {
            array_push($this->openAPINullablesSetToNull, 'discount_coupons');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('discount_coupons', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['discount_coupons'] = $discount_coupons;

        return $this;
    }

    /**
     * Gets promotion_coupons
     *
     * @return \Opsuite2\Model\ProcessedBasketCoupon[]|null
     */
    public function getPromotionCoupons()
    {
        return $this->container['promotion_coupons'];
    }

    /**
     * Sets promotion_coupons
     *
     * @param \Opsuite2\Model\ProcessedBasketCoupon[]|null $promotion_coupons Array of the promotion coupons that were submitted with the basket.
     *
     * @return self
     */
    public function setPromotionCoupons($promotion_coupons)
    {
        if (is_null($promotion_coupons)) {
            array_push($this->openAPINullablesSetToNull, 'promotion_coupons');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('promotion_coupons', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['promotion_coupons'] = $promotion_coupons;

        return $this;
    }

    /**
     * Gets bounce_back_coupons
     *
     * @return \Opsuite2\Model\ProcessedBasketCoupon[]|null
     */
    public function getBounceBackCoupons()
    {
        return $this->container['bounce_back_coupons'];
    }

    /**
     * Sets bounce_back_coupons
     *
     * @param \Opsuite2\Model\ProcessedBasketCoupon[]|null $bounce_back_coupons Array of the bounce back coupons that were submitted with the basket.
     *
     * @return self
     */
    public function setBounceBackCoupons($bounce_back_coupons)
    {
        if (is_null($bounce_back_coupons)) {
            array_push($this->openAPINullablesSetToNull, 'bounce_back_coupons');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('bounce_back_coupons', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['bounce_back_coupons'] = $bounce_back_coupons;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


