<?php
/**
 * OrderTransaction
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * OrderTransaction Class Doc Comment
 *
 * @category Class
 * @description Details of a customer sales order
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class OrderTransaction implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'OrderTransaction';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'order_transaction_type' => 'int',
        'location_id' => 'int',
        'order_number' => 'string',
        'reference_number' => 'string',
        'comment' => 'string',
        'closed' => 'bool',
        'customer_id' => 'int',
        'shipping_service_id' => 'int',
        'shipping_tracking_number' => 'string',
        'status_id' => 'int',
        'status_name' => 'string',
        'transaction_id' => 'int',
        'transaction_receipt_number' => 'string',
        'order_value' => 'float',
        'date_created' => '\DateTime',
        'last_updated' => '\DateTime',
        'deposit' => 'float',
        'sales' => '\Opsuite2\Model\OrderSalesTransaction[]',
        'refunds' => '\Opsuite2\Model\OrderRefundTransaction[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'int32',
        'order_transaction_type' => 'int32',
        'location_id' => 'int32',
        'order_number' => null,
        'reference_number' => null,
        'comment' => null,
        'closed' => null,
        'customer_id' => 'int32',
        'shipping_service_id' => 'int32',
        'shipping_tracking_number' => null,
        'status_id' => 'int32',
        'status_name' => null,
        'transaction_id' => 'int32',
        'transaction_receipt_number' => null,
        'order_value' => 'double',
        'date_created' => 'date-time',
        'last_updated' => 'date-time',
        'deposit' => 'double',
        'sales' => null,
        'refunds' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'order_transaction_type' => false,
        'location_id' => false,
        'order_number' => true,
        'reference_number' => true,
        'comment' => true,
        'closed' => false,
        'customer_id' => true,
        'shipping_service_id' => false,
        'shipping_tracking_number' => true,
        'status_id' => true,
        'status_name' => true,
        'transaction_id' => true,
        'transaction_receipt_number' => true,
        'order_value' => false,
        'date_created' => false,
        'last_updated' => false,
        'deposit' => false,
        'sales' => true,
        'refunds' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'order_transaction_type' => 'orderTransactionType',
        'location_id' => 'locationId',
        'order_number' => 'orderNumber',
        'reference_number' => 'referenceNumber',
        'comment' => 'comment',
        'closed' => 'closed',
        'customer_id' => 'customerId',
        'shipping_service_id' => 'shippingServiceId',
        'shipping_tracking_number' => 'shippingTrackingNumber',
        'status_id' => 'statusId',
        'status_name' => 'statusName',
        'transaction_id' => 'transactionId',
        'transaction_receipt_number' => 'transactionReceiptNumber',
        'order_value' => 'orderValue',
        'date_created' => 'dateCreated',
        'last_updated' => 'lastUpdated',
        'deposit' => 'deposit',
        'sales' => 'sales',
        'refunds' => 'refunds'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'order_transaction_type' => 'setOrderTransactionType',
        'location_id' => 'setLocationId',
        'order_number' => 'setOrderNumber',
        'reference_number' => 'setReferenceNumber',
        'comment' => 'setComment',
        'closed' => 'setClosed',
        'customer_id' => 'setCustomerId',
        'shipping_service_id' => 'setShippingServiceId',
        'shipping_tracking_number' => 'setShippingTrackingNumber',
        'status_id' => 'setStatusId',
        'status_name' => 'setStatusName',
        'transaction_id' => 'setTransactionId',
        'transaction_receipt_number' => 'setTransactionReceiptNumber',
        'order_value' => 'setOrderValue',
        'date_created' => 'setDateCreated',
        'last_updated' => 'setLastUpdated',
        'deposit' => 'setDeposit',
        'sales' => 'setSales',
        'refunds' => 'setRefunds'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'order_transaction_type' => 'getOrderTransactionType',
        'location_id' => 'getLocationId',
        'order_number' => 'getOrderNumber',
        'reference_number' => 'getReferenceNumber',
        'comment' => 'getComment',
        'closed' => 'getClosed',
        'customer_id' => 'getCustomerId',
        'shipping_service_id' => 'getShippingServiceId',
        'shipping_tracking_number' => 'getShippingTrackingNumber',
        'status_id' => 'getStatusId',
        'status_name' => 'getStatusName',
        'transaction_id' => 'getTransactionId',
        'transaction_receipt_number' => 'getTransactionReceiptNumber',
        'order_value' => 'getOrderValue',
        'date_created' => 'getDateCreated',
        'last_updated' => 'getLastUpdated',
        'deposit' => 'getDeposit',
        'sales' => 'getSales',
        'refunds' => 'getRefunds'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('order_transaction_type', $data ?? [], null);
        $this->setIfExists('location_id', $data ?? [], null);
        $this->setIfExists('order_number', $data ?? [], null);
        $this->setIfExists('reference_number', $data ?? [], null);
        $this->setIfExists('comment', $data ?? [], null);
        $this->setIfExists('closed', $data ?? [], null);
        $this->setIfExists('customer_id', $data ?? [], null);
        $this->setIfExists('shipping_service_id', $data ?? [], null);
        $this->setIfExists('shipping_tracking_number', $data ?? [], null);
        $this->setIfExists('status_id', $data ?? [], null);
        $this->setIfExists('status_name', $data ?? [], null);
        $this->setIfExists('transaction_id', $data ?? [], null);
        $this->setIfExists('transaction_receipt_number', $data ?? [], null);
        $this->setIfExists('order_value', $data ?? [], null);
        $this->setIfExists('date_created', $data ?? [], null);
        $this->setIfExists('last_updated', $data ?? [], null);
        $this->setIfExists('deposit', $data ?? [], null);
        $this->setIfExists('sales', $data ?? [], null);
        $this->setIfExists('refunds', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id The order id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets order_transaction_type
     *
     * @return int|null
     */
    public function getOrderTransactionType()
    {
        return $this->container['order_transaction_type'];
    }

    /**
     * Sets order_transaction_type
     *
     * @param int|null $order_transaction_type The order type id one of the following types:<br />  2 Work Order<br />  3 Quote<br />  4 Back Order<br />  5 Layaway<br />  6 Hospitality Order<br />  7 Placeholder<br />  8 Multi Location Sales Order<br />  9 Multi Location Customer Picking Order<br />  10 App Pay At Till Order<br />
     *
     * @return self
     */
    public function setOrderTransactionType($order_transaction_type)
    {
        if (is_null($order_transaction_type)) {
            throw new \InvalidArgumentException('non-nullable order_transaction_type cannot be null');
        }
        $this->container['order_transaction_type'] = $order_transaction_type;

        return $this;
    }

    /**
     * Gets location_id
     *
     * @return int|null
     */
    public function getLocationId()
    {
        return $this->container['location_id'];
    }

    /**
     * Sets location_id
     *
     * @param int|null $location_id The id of the location where the order was taken
     *
     * @return self
     */
    public function setLocationId($location_id)
    {
        if (is_null($location_id)) {
            throw new \InvalidArgumentException('non-nullable location_id cannot be null');
        }
        $this->container['location_id'] = $location_id;

        return $this;
    }

    /**
     * Gets order_number
     *
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->container['order_number'];
    }

    /**
     * Sets order_number
     *
     * @param string|null $order_number The order number
     *
     * @return self
     */
    public function setOrderNumber($order_number)
    {
        if (is_null($order_number)) {
            array_push($this->openAPINullablesSetToNull, 'order_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('order_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['order_number'] = $order_number;

        return $this;
    }

    /**
     * Gets reference_number
     *
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->container['reference_number'];
    }

    /**
     * Sets reference_number
     *
     * @param string|null $reference_number The reference number for the order
     *
     * @return self
     */
    public function setReferenceNumber($reference_number)
    {
        if (is_null($reference_number)) {
            array_push($this->openAPINullablesSetToNull, 'reference_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('reference_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['reference_number'] = $reference_number;

        return $this;
    }

    /**
     * Gets comment
     *
     * @return string|null
     */
    public function getComment()
    {
        return $this->container['comment'];
    }

    /**
     * Sets comment
     *
     * @param string|null $comment Any comments associated with the order
     *
     * @return self
     */
    public function setComment($comment)
    {
        if (is_null($comment)) {
            array_push($this->openAPINullablesSetToNull, 'comment');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('comment', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['comment'] = $comment;

        return $this;
    }

    /**
     * Gets closed
     *
     * @return bool|null
     */
    public function getClosed()
    {
        return $this->container['closed'];
    }

    /**
     * Sets closed
     *
     * @param bool|null $closed Whether the order is closed
     *
     * @return self
     */
    public function setClosed($closed)
    {
        if (is_null($closed)) {
            throw new \InvalidArgumentException('non-nullable closed cannot be null');
        }
        $this->container['closed'] = $closed;

        return $this;
    }

    /**
     * Gets customer_id
     *
     * @return int|null
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     *
     * @param int|null $customer_id The customer id
     *
     * @return self
     */
    public function setCustomerId($customer_id)
    {
        if (is_null($customer_id)) {
            array_push($this->openAPINullablesSetToNull, 'customer_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('customer_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets shipping_service_id
     *
     * @return int|null
     */
    public function getShippingServiceId()
    {
        return $this->container['shipping_service_id'];
    }

    /**
     * Sets shipping_service_id
     *
     * @param int|null $shipping_service_id The shipping service used to dispatch the order
     *
     * @return self
     */
    public function setShippingServiceId($shipping_service_id)
    {
        if (is_null($shipping_service_id)) {
            throw new \InvalidArgumentException('non-nullable shipping_service_id cannot be null');
        }
        $this->container['shipping_service_id'] = $shipping_service_id;

        return $this;
    }

    /**
     * Gets shipping_tracking_number
     *
     * @return string|null
     */
    public function getShippingTrackingNumber()
    {
        return $this->container['shipping_tracking_number'];
    }

    /**
     * Sets shipping_tracking_number
     *
     * @param string|null $shipping_tracking_number The shipping service tracking number for this order
     *
     * @return self
     */
    public function setShippingTrackingNumber($shipping_tracking_number)
    {
        if (is_null($shipping_tracking_number)) {
            array_push($this->openAPINullablesSetToNull, 'shipping_tracking_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('shipping_tracking_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['shipping_tracking_number'] = $shipping_tracking_number;

        return $this;
    }

    /**
     * Gets status_id
     *
     * @return int|null
     */
    public function getStatusId()
    {
        return $this->container['status_id'];
    }

    /**
     * Sets status_id
     *
     * @param int|null $status_id The order status id
     *
     * @return self
     */
    public function setStatusId($status_id)
    {
        if (is_null($status_id)) {
            array_push($this->openAPINullablesSetToNull, 'status_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('status_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['status_id'] = $status_id;

        return $this;
    }

    /**
     * Gets status_name
     *
     * @return string|null
     */
    public function getStatusName()
    {
        return $this->container['status_name'];
    }

    /**
     * Sets status_name
     *
     * @param string|null $status_name The order status
     *
     * @return self
     */
    public function setStatusName($status_name)
    {
        if (is_null($status_name)) {
            array_push($this->openAPINullablesSetToNull, 'status_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('status_name', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['status_name'] = $status_name;

        return $this;
    }

    /**
     * Gets transaction_id
     *
     * @return int|null
     * @deprecated
     */
    public function getTransactionId()
    {
        return $this->container['transaction_id'];
    }

    /**
     * Sets transaction_id
     *
     * @param int|null $transaction_id The transaction id for the sales transaction that paid for the order
     *
     * @return self
     * @deprecated
     */
    public function setTransactionId($transaction_id)
    {
        if (is_null($transaction_id)) {
            array_push($this->openAPINullablesSetToNull, 'transaction_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('transaction_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['transaction_id'] = $transaction_id;

        return $this;
    }

    /**
     * Gets transaction_receipt_number
     *
     * @return string|null
     * @deprecated
     */
    public function getTransactionReceiptNumber()
    {
        return $this->container['transaction_receipt_number'];
    }

    /**
     * Sets transaction_receipt_number
     *
     * @param string|null $transaction_receipt_number The receipt number for the sales transaction that paid for the order
     *
     * @return self
     * @deprecated
     */
    public function setTransactionReceiptNumber($transaction_receipt_number)
    {
        if (is_null($transaction_receipt_number)) {
            array_push($this->openAPINullablesSetToNull, 'transaction_receipt_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('transaction_receipt_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['transaction_receipt_number'] = $transaction_receipt_number;

        return $this;
    }

    /**
     * Gets order_value
     *
     * @return float|null
     */
    public function getOrderValue()
    {
        return $this->container['order_value'];
    }

    /**
     * Sets order_value
     *
     * @param float|null $order_value The value of the order
     *
     * @return self
     */
    public function setOrderValue($order_value)
    {
        if (is_null($order_value)) {
            throw new \InvalidArgumentException('non-nullable order_value cannot be null');
        }
        $this->container['order_value'] = $order_value;

        return $this;
    }

    /**
     * Gets date_created
     *
     * @return \DateTime|null
     */
    public function getDateCreated()
    {
        return $this->container['date_created'];
    }

    /**
     * Sets date_created
     *
     * @param \DateTime|null $date_created The date the order was created
     *
     * @return self
     */
    public function setDateCreated($date_created)
    {
        if (is_null($date_created)) {
            throw new \InvalidArgumentException('non-nullable date_created cannot be null');
        }
        $this->container['date_created'] = $date_created;

        return $this;
    }

    /**
     * Gets last_updated
     *
     * @return \DateTime|null
     */
    public function getLastUpdated()
    {
        return $this->container['last_updated'];
    }

    /**
     * Sets last_updated
     *
     * @param \DateTime|null $last_updated The last time the order was updated in any way
     *
     * @return self
     */
    public function setLastUpdated($last_updated)
    {
        if (is_null($last_updated)) {
            throw new \InvalidArgumentException('non-nullable last_updated cannot be null');
        }
        $this->container['last_updated'] = $last_updated;

        return $this;
    }

    /**
     * Gets deposit
     *
     * @return float|null
     */
    public function getDeposit()
    {
        return $this->container['deposit'];
    }

    /**
     * Sets deposit
     *
     * @param float|null $deposit The total deposit paid on the order
     *
     * @return self
     */
    public function setDeposit($deposit)
    {
        if (is_null($deposit)) {
            throw new \InvalidArgumentException('non-nullable deposit cannot be null');
        }
        $this->container['deposit'] = $deposit;

        return $this;
    }

    /**
     * Gets sales
     *
     * @return \Opsuite2\Model\OrderSalesTransaction[]|null
     */
    public function getSales()
    {
        return $this->container['sales'];
    }

    /**
     * Sets sales
     *
     * @param \Opsuite2\Model\OrderSalesTransaction[]|null $sales A list of sales transactions that paid for the order
     *
     * @return self
     */
    public function setSales($sales)
    {
        if (is_null($sales)) {
            array_push($this->openAPINullablesSetToNull, 'sales');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('sales', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['sales'] = $sales;

        return $this;
    }

    /**
     * Gets refunds
     *
     * @return \Opsuite2\Model\OrderRefundTransaction[]|null
     */
    public function getRefunds()
    {
        return $this->container['refunds'];
    }

    /**
     * Sets refunds
     *
     * @param \Opsuite2\Model\OrderRefundTransaction[]|null $refunds A list of any refund transactions for items on the order
     *
     * @return self
     */
    public function setRefunds($refunds)
    {
        if (is_null($refunds)) {
            array_push($this->openAPINullablesSetToNull, 'refunds');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('refunds', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['refunds'] = $refunds;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


