<?php
/**
 * MultiLocationSalesOrderBasket
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * MultiLocationSalesOrderBasket Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class MultiLocationSalesOrderBasket implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'MultiLocationSalesOrderBasket';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'basket_id' => 'int',
        'order_transaction_type' => 'int',
        'order_reference_number' => 'string',
        'order_comment' => 'string',
        'delivery_comment' => 'string',
        'internal_delivery_comment' => 'string',
        'ship_to_contact_id' => 'int',
        'shipping_service_id' => 'int',
        'shipping_tracking_number' => 'string',
        'shipping_notes' => 'string',
        'expiration_or_due_date' => '\DateTime',
        'register_id' => 'int',
        'cashier_id' => 'int',
        'cashier_number' => 'string',
        'tender_lines' => '\Opsuite2\Model\OrderTenderLine[]',
        'stock_location_id' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'basket_id' => 'int32',
        'order_transaction_type' => 'int32',
        'order_reference_number' => null,
        'order_comment' => null,
        'delivery_comment' => null,
        'internal_delivery_comment' => null,
        'ship_to_contact_id' => 'int32',
        'shipping_service_id' => 'int32',
        'shipping_tracking_number' => null,
        'shipping_notes' => null,
        'expiration_or_due_date' => 'date-time',
        'register_id' => 'int32',
        'cashier_id' => 'int32',
        'cashier_number' => null,
        'tender_lines' => null,
        'stock_location_id' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'basket_id' => false,
        'order_transaction_type' => true,
        'order_reference_number' => true,
        'order_comment' => true,
        'delivery_comment' => true,
        'internal_delivery_comment' => true,
        'ship_to_contact_id' => true,
        'shipping_service_id' => true,
        'shipping_tracking_number' => true,
        'shipping_notes' => true,
        'expiration_or_due_date' => true,
        'register_id' => true,
        'cashier_id' => true,
        'cashier_number' => true,
        'tender_lines' => false,
        'stock_location_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'basket_id' => 'basketId',
        'order_transaction_type' => 'orderTransactionType',
        'order_reference_number' => 'orderReferenceNumber',
        'order_comment' => 'orderComment',
        'delivery_comment' => 'deliveryComment',
        'internal_delivery_comment' => 'internalDeliveryComment',
        'ship_to_contact_id' => 'shipToContactId',
        'shipping_service_id' => 'shippingServiceId',
        'shipping_tracking_number' => 'shippingTrackingNumber',
        'shipping_notes' => 'shippingNotes',
        'expiration_or_due_date' => 'expirationOrDueDate',
        'register_id' => 'registerId',
        'cashier_id' => 'cashierId',
        'cashier_number' => 'cashierNumber',
        'tender_lines' => 'tenderLines',
        'stock_location_id' => 'stockLocationId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'basket_id' => 'setBasketId',
        'order_transaction_type' => 'setOrderTransactionType',
        'order_reference_number' => 'setOrderReferenceNumber',
        'order_comment' => 'setOrderComment',
        'delivery_comment' => 'setDeliveryComment',
        'internal_delivery_comment' => 'setInternalDeliveryComment',
        'ship_to_contact_id' => 'setShipToContactId',
        'shipping_service_id' => 'setShippingServiceId',
        'shipping_tracking_number' => 'setShippingTrackingNumber',
        'shipping_notes' => 'setShippingNotes',
        'expiration_or_due_date' => 'setExpirationOrDueDate',
        'register_id' => 'setRegisterId',
        'cashier_id' => 'setCashierId',
        'cashier_number' => 'setCashierNumber',
        'tender_lines' => 'setTenderLines',
        'stock_location_id' => 'setStockLocationId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'basket_id' => 'getBasketId',
        'order_transaction_type' => 'getOrderTransactionType',
        'order_reference_number' => 'getOrderReferenceNumber',
        'order_comment' => 'getOrderComment',
        'delivery_comment' => 'getDeliveryComment',
        'internal_delivery_comment' => 'getInternalDeliveryComment',
        'ship_to_contact_id' => 'getShipToContactId',
        'shipping_service_id' => 'getShippingServiceId',
        'shipping_tracking_number' => 'getShippingTrackingNumber',
        'shipping_notes' => 'getShippingNotes',
        'expiration_or_due_date' => 'getExpirationOrDueDate',
        'register_id' => 'getRegisterId',
        'cashier_id' => 'getCashierId',
        'cashier_number' => 'getCashierNumber',
        'tender_lines' => 'getTenderLines',
        'stock_location_id' => 'getStockLocationId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('basket_id', $data ?? [], null);
        $this->setIfExists('order_transaction_type', $data ?? [], null);
        $this->setIfExists('order_reference_number', $data ?? [], null);
        $this->setIfExists('order_comment', $data ?? [], null);
        $this->setIfExists('delivery_comment', $data ?? [], null);
        $this->setIfExists('internal_delivery_comment', $data ?? [], null);
        $this->setIfExists('ship_to_contact_id', $data ?? [], null);
        $this->setIfExists('shipping_service_id', $data ?? [], null);
        $this->setIfExists('shipping_tracking_number', $data ?? [], null);
        $this->setIfExists('shipping_notes', $data ?? [], null);
        $this->setIfExists('expiration_or_due_date', $data ?? [], null);
        $this->setIfExists('register_id', $data ?? [], null);
        $this->setIfExists('cashier_id', $data ?? [], null);
        $this->setIfExists('cashier_number', $data ?? [], null);
        $this->setIfExists('tender_lines', $data ?? [], null);
        $this->setIfExists('stock_location_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['order_reference_number']) && (mb_strlen($this->container['order_reference_number']) > 50)) {
            $invalidProperties[] = "invalid value for 'order_reference_number', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['order_reference_number']) && (mb_strlen($this->container['order_reference_number']) < 0)) {
            $invalidProperties[] = "invalid value for 'order_reference_number', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['order_comment']) && (mb_strlen($this->container['order_comment']) > 500)) {
            $invalidProperties[] = "invalid value for 'order_comment', the character length must be smaller than or equal to 500.";
        }

        if (!is_null($this->container['order_comment']) && (mb_strlen($this->container['order_comment']) < 0)) {
            $invalidProperties[] = "invalid value for 'order_comment', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['delivery_comment']) && (mb_strlen($this->container['delivery_comment']) > 500)) {
            $invalidProperties[] = "invalid value for 'delivery_comment', the character length must be smaller than or equal to 500.";
        }

        if (!is_null($this->container['delivery_comment']) && (mb_strlen($this->container['delivery_comment']) < 0)) {
            $invalidProperties[] = "invalid value for 'delivery_comment', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['internal_delivery_comment']) && (mb_strlen($this->container['internal_delivery_comment']) > 500)) {
            $invalidProperties[] = "invalid value for 'internal_delivery_comment', the character length must be smaller than or equal to 500.";
        }

        if (!is_null($this->container['internal_delivery_comment']) && (mb_strlen($this->container['internal_delivery_comment']) < 0)) {
            $invalidProperties[] = "invalid value for 'internal_delivery_comment', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['shipping_tracking_number']) && (mb_strlen($this->container['shipping_tracking_number']) > 255)) {
            $invalidProperties[] = "invalid value for 'shipping_tracking_number', the character length must be smaller than or equal to 255.";
        }

        if (!is_null($this->container['shipping_tracking_number']) && (mb_strlen($this->container['shipping_tracking_number']) < 0)) {
            $invalidProperties[] = "invalid value for 'shipping_tracking_number', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['shipping_notes']) && (mb_strlen($this->container['shipping_notes']) > 2000)) {
            $invalidProperties[] = "invalid value for 'shipping_notes', the character length must be smaller than or equal to 2000.";
        }

        if (!is_null($this->container['shipping_notes']) && (mb_strlen($this->container['shipping_notes']) < 0)) {
            $invalidProperties[] = "invalid value for 'shipping_notes', the character length must be bigger than or equal to 0.";
        }

        if ($this->container['tender_lines'] === null) {
            $invalidProperties[] = "'tender_lines' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets basket_id
     *
     * @return int|null
     */
    public function getBasketId()
    {
        return $this->container['basket_id'];
    }

    /**
     * Sets basket_id
     *
     * @param int|null $basket_id The id of the basket being converted to an order.
     *
     * @return self
     */
    public function setBasketId($basket_id)
    {
        if (is_null($basket_id)) {
            throw new \InvalidArgumentException('non-nullable basket_id cannot be null');
        }
        $this->container['basket_id'] = $basket_id;

        return $this;
    }

    /**
     * Gets order_transaction_type
     *
     * @return int|null
     */
    public function getOrderTransactionType()
    {
        return $this->container['order_transaction_type'];
    }

    /**
     * Sets order_transaction_type
     *
     * @param int|null $order_transaction_type The type of order being created.  Currently supported types:  2 - Work order  10 - App pay at till order
     *
     * @return self
     */
    public function setOrderTransactionType($order_transaction_type)
    {
        if (is_null($order_transaction_type)) {
            array_push($this->openAPINullablesSetToNull, 'order_transaction_type');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('order_transaction_type', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['order_transaction_type'] = $order_transaction_type;

        return $this;
    }

    /**
     * Gets order_reference_number
     *
     * @return string|null
     */
    public function getOrderReferenceNumber()
    {
        return $this->container['order_reference_number'];
    }

    /**
     * Sets order_reference_number
     *
     * @param string|null $order_reference_number A reference number for the order.
     *
     * @return self
     */
    public function setOrderReferenceNumber($order_reference_number)
    {
        if (is_null($order_reference_number)) {
            array_push($this->openAPINullablesSetToNull, 'order_reference_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('order_reference_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($order_reference_number) && (mb_strlen($order_reference_number) > 50)) {
            throw new \InvalidArgumentException('invalid length for $order_reference_number when calling MultiLocationSalesOrderBasket., must be smaller than or equal to 50.');
        }
        if (!is_null($order_reference_number) && (mb_strlen($order_reference_number) < 0)) {
            throw new \InvalidArgumentException('invalid length for $order_reference_number when calling MultiLocationSalesOrderBasket., must be bigger than or equal to 0.');
        }

        $this->container['order_reference_number'] = $order_reference_number;

        return $this;
    }

    /**
     * Gets order_comment
     *
     * @return string|null
     */
    public function getOrderComment()
    {
        return $this->container['order_comment'];
    }

    /**
     * Sets order_comment
     *
     * @param string|null $order_comment Any comment relating to the order.
     *
     * @return self
     */
    public function setOrderComment($order_comment)
    {
        if (is_null($order_comment)) {
            array_push($this->openAPINullablesSetToNull, 'order_comment');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('order_comment', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($order_comment) && (mb_strlen($order_comment) > 500)) {
            throw new \InvalidArgumentException('invalid length for $order_comment when calling MultiLocationSalesOrderBasket., must be smaller than or equal to 500.');
        }
        if (!is_null($order_comment) && (mb_strlen($order_comment) < 0)) {
            throw new \InvalidArgumentException('invalid length for $order_comment when calling MultiLocationSalesOrderBasket., must be bigger than or equal to 0.');
        }

        $this->container['order_comment'] = $order_comment;

        return $this;
    }

    /**
     * Gets delivery_comment
     *
     * @return string|null
     */
    public function getDeliveryComment()
    {
        return $this->container['delivery_comment'];
    }

    /**
     * Sets delivery_comment
     *
     * @param string|null $delivery_comment Any delivery comment relating to the order.
     *
     * @return self
     */
    public function setDeliveryComment($delivery_comment)
    {
        if (is_null($delivery_comment)) {
            array_push($this->openAPINullablesSetToNull, 'delivery_comment');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('delivery_comment', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($delivery_comment) && (mb_strlen($delivery_comment) > 500)) {
            throw new \InvalidArgumentException('invalid length for $delivery_comment when calling MultiLocationSalesOrderBasket., must be smaller than or equal to 500.');
        }
        if (!is_null($delivery_comment) && (mb_strlen($delivery_comment) < 0)) {
            throw new \InvalidArgumentException('invalid length for $delivery_comment when calling MultiLocationSalesOrderBasket., must be bigger than or equal to 0.');
        }

        $this->container['delivery_comment'] = $delivery_comment;

        return $this;
    }

    /**
     * Gets internal_delivery_comment
     *
     * @return string|null
     */
    public function getInternalDeliveryComment()
    {
        return $this->container['internal_delivery_comment'];
    }

    /**
     * Sets internal_delivery_comment
     *
     * @param string|null $internal_delivery_comment Any internal delivery comment relating to the order.
     *
     * @return self
     */
    public function setInternalDeliveryComment($internal_delivery_comment)
    {
        if (is_null($internal_delivery_comment)) {
            array_push($this->openAPINullablesSetToNull, 'internal_delivery_comment');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('internal_delivery_comment', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($internal_delivery_comment) && (mb_strlen($internal_delivery_comment) > 500)) {
            throw new \InvalidArgumentException('invalid length for $internal_delivery_comment when calling MultiLocationSalesOrderBasket., must be smaller than or equal to 500.');
        }
        if (!is_null($internal_delivery_comment) && (mb_strlen($internal_delivery_comment) < 0)) {
            throw new \InvalidArgumentException('invalid length for $internal_delivery_comment when calling MultiLocationSalesOrderBasket., must be bigger than or equal to 0.');
        }

        $this->container['internal_delivery_comment'] = $internal_delivery_comment;

        return $this;
    }

    /**
     * Gets ship_to_contact_id
     *
     * @return int|null
     */
    public function getShipToContactId()
    {
        return $this->container['ship_to_contact_id'];
    }

    /**
     * Sets ship_to_contact_id
     *
     * @param int|null $ship_to_contact_id ship_to_contact_id
     *
     * @return self
     */
    public function setShipToContactId($ship_to_contact_id)
    {
        if (is_null($ship_to_contact_id)) {
            array_push($this->openAPINullablesSetToNull, 'ship_to_contact_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ship_to_contact_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['ship_to_contact_id'] = $ship_to_contact_id;

        return $this;
    }

    /**
     * Gets shipping_service_id
     *
     * @return int|null
     */
    public function getShippingServiceId()
    {
        return $this->container['shipping_service_id'];
    }

    /**
     * Sets shipping_service_id
     *
     * @param int|null $shipping_service_id The id of the shipping service to use. The ShippingServiceId relates to the ShippingCarriers and ShippingServices setup in OpSuite and are used on the POS.  You can get them via the AdminService.GetShippingCarriers().
     *
     * @return self
     */
    public function setShippingServiceId($shipping_service_id)
    {
        if (is_null($shipping_service_id)) {
            array_push($this->openAPINullablesSetToNull, 'shipping_service_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('shipping_service_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['shipping_service_id'] = $shipping_service_id;

        return $this;
    }

    /**
     * Gets shipping_tracking_number
     *
     * @return string|null
     */
    public function getShippingTrackingNumber()
    {
        return $this->container['shipping_tracking_number'];
    }

    /**
     * Sets shipping_tracking_number
     *
     * @param string|null $shipping_tracking_number The tracking number of the shipping service.
     *
     * @return self
     */
    public function setShippingTrackingNumber($shipping_tracking_number)
    {
        if (is_null($shipping_tracking_number)) {
            array_push($this->openAPINullablesSetToNull, 'shipping_tracking_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('shipping_tracking_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($shipping_tracking_number) && (mb_strlen($shipping_tracking_number) > 255)) {
            throw new \InvalidArgumentException('invalid length for $shipping_tracking_number when calling MultiLocationSalesOrderBasket., must be smaller than or equal to 255.');
        }
        if (!is_null($shipping_tracking_number) && (mb_strlen($shipping_tracking_number) < 0)) {
            throw new \InvalidArgumentException('invalid length for $shipping_tracking_number when calling MultiLocationSalesOrderBasket., must be bigger than or equal to 0.');
        }

        $this->container['shipping_tracking_number'] = $shipping_tracking_number;

        return $this;
    }

    /**
     * Gets shipping_notes
     *
     * @return string|null
     */
    public function getShippingNotes()
    {
        return $this->container['shipping_notes'];
    }

    /**
     * Sets shipping_notes
     *
     * @param string|null $shipping_notes Any notes relating to the shipping service
     *
     * @return self
     */
    public function setShippingNotes($shipping_notes)
    {
        if (is_null($shipping_notes)) {
            array_push($this->openAPINullablesSetToNull, 'shipping_notes');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('shipping_notes', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($shipping_notes) && (mb_strlen($shipping_notes) > 2000)) {
            throw new \InvalidArgumentException('invalid length for $shipping_notes when calling MultiLocationSalesOrderBasket., must be smaller than or equal to 2000.');
        }
        if (!is_null($shipping_notes) && (mb_strlen($shipping_notes) < 0)) {
            throw new \InvalidArgumentException('invalid length for $shipping_notes when calling MultiLocationSalesOrderBasket., must be bigger than or equal to 0.');
        }

        $this->container['shipping_notes'] = $shipping_notes;

        return $this;
    }

    /**
     * Gets expiration_or_due_date
     *
     * @return \DateTime|null
     */
    public function getExpirationOrDueDate()
    {
        return $this->container['expiration_or_due_date'];
    }

    /**
     * Sets expiration_or_due_date
     *
     * @param \DateTime|null $expiration_or_due_date Date the order expires or is due.  Set this to the date at which it is estimated that the order will be ready to complete.  It is just used for information purposes.  If not provided, the default value is the order date.
     *
     * @return self
     */
    public function setExpirationOrDueDate($expiration_or_due_date)
    {
        if (is_null($expiration_or_due_date)) {
            array_push($this->openAPINullablesSetToNull, 'expiration_or_due_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('expiration_or_due_date', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['expiration_or_due_date'] = $expiration_or_due_date;

        return $this;
    }

    /**
     * Gets register_id
     *
     * @return int|null
     */
    public function getRegisterId()
    {
        return $this->container['register_id'];
    }

    /**
     * Sets register_id
     *
     * @param int|null $register_id The register the order transaction will be processed on.
     *
     * @return self
     */
    public function setRegisterId($register_id)
    {
        if (is_null($register_id)) {
            array_push($this->openAPINullablesSetToNull, 'register_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('register_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['register_id'] = $register_id;

        return $this;
    }

    /**
     * Gets cashier_id
     *
     * @return int|null
     */
    public function getCashierId()
    {
        return $this->container['cashier_id'];
    }

    /**
     * Sets cashier_id
     *
     * @param int|null $cashier_id The cashier the order transaction will be assigned to.
     *
     * @return self
     */
    public function setCashierId($cashier_id)
    {
        if (is_null($cashier_id)) {
            array_push($this->openAPINullablesSetToNull, 'cashier_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('cashier_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['cashier_id'] = $cashier_id;

        return $this;
    }

    /**
     * Gets cashier_number
     *
     * @return string|null
     */
    public function getCashierNumber()
    {
        return $this->container['cashier_number'];
    }

    /**
     * Sets cashier_number
     *
     * @param string|null $cashier_number The cashier the order transaction will be assigned to.
     *
     * @return self
     */
    public function setCashierNumber($cashier_number)
    {
        if (is_null($cashier_number)) {
            array_push($this->openAPINullablesSetToNull, 'cashier_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('cashier_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['cashier_number'] = $cashier_number;

        return $this;
    }

    /**
     * Gets tender_lines
     *
     * @return \Opsuite2\Model\OrderTenderLine[]
     */
    public function getTenderLines()
    {
        return $this->container['tender_lines'];
    }

    /**
     * Sets tender_lines
     *
     * @param \Opsuite2\Model\OrderTenderLine[] $tender_lines The tender lines for the transaction.
     *
     * @return self
     */
    public function setTenderLines($tender_lines)
    {
        if (is_null($tender_lines)) {
            throw new \InvalidArgumentException('non-nullable tender_lines cannot be null');
        }
        $this->container['tender_lines'] = $tender_lines;

        return $this;
    }

    /**
     * Gets stock_location_id
     *
     * @return int|null
     */
    public function getStockLocationId()
    {
        return $this->container['stock_location_id'];
    }

    /**
     * Sets stock_location_id
     *
     * @param int|null $stock_location_id The id of the stock location.
     *
     * @return self
     */
    public function setStockLocationId($stock_location_id)
    {
        if (is_null($stock_location_id)) {
            throw new \InvalidArgumentException('non-nullable stock_location_id cannot be null');
        }
        $this->container['stock_location_id'] = $stock_location_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


