<?php
/**
 * MatrixMaster
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * MatrixMaster Class Doc Comment
 *
 * @category Class
 * @description Describes a matrix master
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class MatrixMaster implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'MatrixMaster';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'active' => 'bool',
        'category_id' => 'int',
        'cost' => 'float',
        'department_id' => 'int',
        'do_not_order' => 'bool',
        'extended_description' => 'string',
        'id' => 'int',
        'item_type_id' => 'int',
        'manufacturer' => 'string',
        'matrix_description' => 'string',
        'matrix_sku' => 'string',
        'msrp' => 'float',
        'price_ex_tax' => 'float',
        'price_inc_tax' => 'float',
        'supplier_id' => 'int',
        'product_line' => 'string',
        'sku_formula' => 'string',
        'style' => 'string',
        'sub_description1' => 'string',
        'sub_description2' => 'string',
        'sub_description3' => 'string',
        'matrix_items' => '\Opsuite2\Model\MatrixItem[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'active' => null,
        'category_id' => 'int32',
        'cost' => 'double',
        'department_id' => 'int32',
        'do_not_order' => null,
        'extended_description' => null,
        'id' => 'int32',
        'item_type_id' => 'int32',
        'manufacturer' => null,
        'matrix_description' => null,
        'matrix_sku' => null,
        'msrp' => 'double',
        'price_ex_tax' => 'double',
        'price_inc_tax' => 'double',
        'supplier_id' => 'int32',
        'product_line' => null,
        'sku_formula' => null,
        'style' => null,
        'sub_description1' => null,
        'sub_description2' => null,
        'sub_description3' => null,
        'matrix_items' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'active' => false,
        'category_id' => false,
        'cost' => false,
        'department_id' => false,
        'do_not_order' => false,
        'extended_description' => true,
        'id' => false,
        'item_type_id' => false,
        'manufacturer' => true,
        'matrix_description' => true,
        'matrix_sku' => true,
        'msrp' => false,
        'price_ex_tax' => false,
        'price_inc_tax' => false,
        'supplier_id' => true,
        'product_line' => true,
        'sku_formula' => true,
        'style' => true,
        'sub_description1' => true,
        'sub_description2' => true,
        'sub_description3' => true,
        'matrix_items' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'active' => 'active',
        'category_id' => 'categoryId',
        'cost' => 'cost',
        'department_id' => 'departmentId',
        'do_not_order' => 'doNotOrder',
        'extended_description' => 'extendedDescription',
        'id' => 'id',
        'item_type_id' => 'itemTypeId',
        'manufacturer' => 'manufacturer',
        'matrix_description' => 'matrixDescription',
        'matrix_sku' => 'matrixSku',
        'msrp' => 'msrp',
        'price_ex_tax' => 'priceExTax',
        'price_inc_tax' => 'priceIncTax',
        'supplier_id' => 'supplierId',
        'product_line' => 'productLine',
        'sku_formula' => 'skuFormula',
        'style' => 'style',
        'sub_description1' => 'subDescription1',
        'sub_description2' => 'subDescription2',
        'sub_description3' => 'subDescription3',
        'matrix_items' => 'matrixItems'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'active' => 'setActive',
        'category_id' => 'setCategoryId',
        'cost' => 'setCost',
        'department_id' => 'setDepartmentId',
        'do_not_order' => 'setDoNotOrder',
        'extended_description' => 'setExtendedDescription',
        'id' => 'setId',
        'item_type_id' => 'setItemTypeId',
        'manufacturer' => 'setManufacturer',
        'matrix_description' => 'setMatrixDescription',
        'matrix_sku' => 'setMatrixSku',
        'msrp' => 'setMsrp',
        'price_ex_tax' => 'setPriceExTax',
        'price_inc_tax' => 'setPriceIncTax',
        'supplier_id' => 'setSupplierId',
        'product_line' => 'setProductLine',
        'sku_formula' => 'setSkuFormula',
        'style' => 'setStyle',
        'sub_description1' => 'setSubDescription1',
        'sub_description2' => 'setSubDescription2',
        'sub_description3' => 'setSubDescription3',
        'matrix_items' => 'setMatrixItems'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'active' => 'getActive',
        'category_id' => 'getCategoryId',
        'cost' => 'getCost',
        'department_id' => 'getDepartmentId',
        'do_not_order' => 'getDoNotOrder',
        'extended_description' => 'getExtendedDescription',
        'id' => 'getId',
        'item_type_id' => 'getItemTypeId',
        'manufacturer' => 'getManufacturer',
        'matrix_description' => 'getMatrixDescription',
        'matrix_sku' => 'getMatrixSku',
        'msrp' => 'getMsrp',
        'price_ex_tax' => 'getPriceExTax',
        'price_inc_tax' => 'getPriceIncTax',
        'supplier_id' => 'getSupplierId',
        'product_line' => 'getProductLine',
        'sku_formula' => 'getSkuFormula',
        'style' => 'getStyle',
        'sub_description1' => 'getSubDescription1',
        'sub_description2' => 'getSubDescription2',
        'sub_description3' => 'getSubDescription3',
        'matrix_items' => 'getMatrixItems'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('active', $data ?? [], null);
        $this->setIfExists('category_id', $data ?? [], null);
        $this->setIfExists('cost', $data ?? [], null);
        $this->setIfExists('department_id', $data ?? [], null);
        $this->setIfExists('do_not_order', $data ?? [], null);
        $this->setIfExists('extended_description', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('item_type_id', $data ?? [], null);
        $this->setIfExists('manufacturer', $data ?? [], null);
        $this->setIfExists('matrix_description', $data ?? [], null);
        $this->setIfExists('matrix_sku', $data ?? [], null);
        $this->setIfExists('msrp', $data ?? [], null);
        $this->setIfExists('price_ex_tax', $data ?? [], null);
        $this->setIfExists('price_inc_tax', $data ?? [], null);
        $this->setIfExists('supplier_id', $data ?? [], null);
        $this->setIfExists('product_line', $data ?? [], null);
        $this->setIfExists('sku_formula', $data ?? [], null);
        $this->setIfExists('style', $data ?? [], null);
        $this->setIfExists('sub_description1', $data ?? [], null);
        $this->setIfExists('sub_description2', $data ?? [], null);
        $this->setIfExists('sub_description3', $data ?? [], null);
        $this->setIfExists('matrix_items', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets active
     *
     * @return bool|null
     */
    public function getActive()
    {
        return $this->container['active'];
    }

    /**
     * Sets active
     *
     * @param bool|null $active Whether the matrix master is active or not
     *
     * @return self
     */
    public function setActive($active)
    {
        if (is_null($active)) {
            throw new \InvalidArgumentException('non-nullable active cannot be null');
        }
        $this->container['active'] = $active;

        return $this;
    }

    /**
     * Gets category_id
     *
     * @return int|null
     */
    public function getCategoryId()
    {
        return $this->container['category_id'];
    }

    /**
     * Sets category_id
     *
     * @param int|null $category_id The category id
     *
     * @return self
     */
    public function setCategoryId($category_id)
    {
        if (is_null($category_id)) {
            throw new \InvalidArgumentException('non-nullable category_id cannot be null');
        }
        $this->container['category_id'] = $category_id;

        return $this;
    }

    /**
     * Gets cost
     *
     * @return float|null
     */
    public function getCost()
    {
        return $this->container['cost'];
    }

    /**
     * Sets cost
     *
     * @param float|null $cost The cost
     *
     * @return self
     */
    public function setCost($cost)
    {
        if (is_null($cost)) {
            throw new \InvalidArgumentException('non-nullable cost cannot be null');
        }
        $this->container['cost'] = $cost;

        return $this;
    }

    /**
     * Gets department_id
     *
     * @return int|null
     */
    public function getDepartmentId()
    {
        return $this->container['department_id'];
    }

    /**
     * Sets department_id
     *
     * @param int|null $department_id The department id
     *
     * @return self
     */
    public function setDepartmentId($department_id)
    {
        if (is_null($department_id)) {
            throw new \InvalidArgumentException('non-nullable department_id cannot be null');
        }
        $this->container['department_id'] = $department_id;

        return $this;
    }

    /**
     * Gets do_not_order
     *
     * @return bool|null
     */
    public function getDoNotOrder()
    {
        return $this->container['do_not_order'];
    }

    /**
     * Sets do_not_order
     *
     * @param bool|null $do_not_order Whether the matrix master can be ordered or not
     *
     * @return self
     */
    public function setDoNotOrder($do_not_order)
    {
        if (is_null($do_not_order)) {
            throw new \InvalidArgumentException('non-nullable do_not_order cannot be null');
        }
        $this->container['do_not_order'] = $do_not_order;

        return $this;
    }

    /**
     * Gets extended_description
     *
     * @return string|null
     */
    public function getExtendedDescription()
    {
        return $this->container['extended_description'];
    }

    /**
     * Sets extended_description
     *
     * @param string|null $extended_description The extended description
     *
     * @return self
     */
    public function setExtendedDescription($extended_description)
    {
        if (is_null($extended_description)) {
            array_push($this->openAPINullablesSetToNull, 'extended_description');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('extended_description', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['extended_description'] = $extended_description;

        return $this;
    }

    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id The matrix master id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets item_type_id
     *
     * @return int|null
     */
    public function getItemTypeId()
    {
        return $this->container['item_type_id'];
    }

    /**
     * Sets item_type_id
     *
     * @param int|null $item_type_id The item type:<br />  0 Standard<br />  6 Weighed<br />  7 Non-Inventory<br />  9 Voucher<br />  10 Scale<br />  11 OpSuite Kit<br />  12 Non-Inventory Scale<br />
     *
     * @return self
     */
    public function setItemTypeId($item_type_id)
    {
        if (is_null($item_type_id)) {
            throw new \InvalidArgumentException('non-nullable item_type_id cannot be null');
        }
        $this->container['item_type_id'] = $item_type_id;

        return $this;
    }

    /**
     * Gets manufacturer
     *
     * @return string|null
     */
    public function getManufacturer()
    {
        return $this->container['manufacturer'];
    }

    /**
     * Sets manufacturer
     *
     * @param string|null $manufacturer The manufacturer
     *
     * @return self
     */
    public function setManufacturer($manufacturer)
    {
        if (is_null($manufacturer)) {
            array_push($this->openAPINullablesSetToNull, 'manufacturer');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('manufacturer', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['manufacturer'] = $manufacturer;

        return $this;
    }

    /**
     * Gets matrix_description
     *
     * @return string|null
     */
    public function getMatrixDescription()
    {
        return $this->container['matrix_description'];
    }

    /**
     * Sets matrix_description
     *
     * @param string|null $matrix_description The matrix master description
     *
     * @return self
     */
    public function setMatrixDescription($matrix_description)
    {
        if (is_null($matrix_description)) {
            array_push($this->openAPINullablesSetToNull, 'matrix_description');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('matrix_description', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['matrix_description'] = $matrix_description;

        return $this;
    }

    /**
     * Gets matrix_sku
     *
     * @return string|null
     */
    public function getMatrixSku()
    {
        return $this->container['matrix_sku'];
    }

    /**
     * Sets matrix_sku
     *
     * @param string|null $matrix_sku The matrix master sku
     *
     * @return self
     */
    public function setMatrixSku($matrix_sku)
    {
        if (is_null($matrix_sku)) {
            array_push($this->openAPINullablesSetToNull, 'matrix_sku');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('matrix_sku', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['matrix_sku'] = $matrix_sku;

        return $this;
    }

    /**
     * Gets msrp
     *
     * @return float|null
     */
    public function getMsrp()
    {
        return $this->container['msrp'];
    }

    /**
     * Sets msrp
     *
     * @param float|null $msrp The MSRP
     *
     * @return self
     */
    public function setMsrp($msrp)
    {
        if (is_null($msrp)) {
            throw new \InvalidArgumentException('non-nullable msrp cannot be null');
        }
        $this->container['msrp'] = $msrp;

        return $this;
    }

    /**
     * Gets price_ex_tax
     *
     * @return float|null
     */
    public function getPriceExTax()
    {
        return $this->container['price_ex_tax'];
    }

    /**
     * Sets price_ex_tax
     *
     * @param float|null $price_ex_tax The price (ex tax)
     *
     * @return self
     */
    public function setPriceExTax($price_ex_tax)
    {
        if (is_null($price_ex_tax)) {
            throw new \InvalidArgumentException('non-nullable price_ex_tax cannot be null');
        }
        $this->container['price_ex_tax'] = $price_ex_tax;

        return $this;
    }

    /**
     * Gets price_inc_tax
     *
     * @return float|null
     */
    public function getPriceIncTax()
    {
        return $this->container['price_inc_tax'];
    }

    /**
     * Sets price_inc_tax
     *
     * @param float|null $price_inc_tax The price (inc tax)
     *
     * @return self
     */
    public function setPriceIncTax($price_inc_tax)
    {
        if (is_null($price_inc_tax)) {
            throw new \InvalidArgumentException('non-nullable price_inc_tax cannot be null');
        }
        $this->container['price_inc_tax'] = $price_inc_tax;

        return $this;
    }

    /**
     * Gets supplier_id
     *
     * @return int|null
     */
    public function getSupplierId()
    {
        return $this->container['supplier_id'];
    }

    /**
     * Sets supplier_id
     *
     * @param int|null $supplier_id The supplier id
     *
     * @return self
     */
    public function setSupplierId($supplier_id)
    {
        if (is_null($supplier_id)) {
            array_push($this->openAPINullablesSetToNull, 'supplier_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('supplier_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['supplier_id'] = $supplier_id;

        return $this;
    }

    /**
     * Gets product_line
     *
     * @return string|null
     */
    public function getProductLine()
    {
        return $this->container['product_line'];
    }

    /**
     * Sets product_line
     *
     * @param string|null $product_line The product line
     *
     * @return self
     */
    public function setProductLine($product_line)
    {
        if (is_null($product_line)) {
            array_push($this->openAPINullablesSetToNull, 'product_line');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('product_line', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['product_line'] = $product_line;

        return $this;
    }

    /**
     * Gets sku_formula
     *
     * @return string|null
     */
    public function getSkuFormula()
    {
        return $this->container['sku_formula'];
    }

    /**
     * Sets sku_formula
     *
     * @param string|null $sku_formula The formula used to create the matrix item skus
     *
     * @return self
     */
    public function setSkuFormula($sku_formula)
    {
        if (is_null($sku_formula)) {
            array_push($this->openAPINullablesSetToNull, 'sku_formula');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('sku_formula', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['sku_formula'] = $sku_formula;

        return $this;
    }

    /**
     * Gets style
     *
     * @return string|null
     */
    public function getStyle()
    {
        return $this->container['style'];
    }

    /**
     * Sets style
     *
     * @param string|null $style The style
     *
     * @return self
     */
    public function setStyle($style)
    {
        if (is_null($style)) {
            array_push($this->openAPINullablesSetToNull, 'style');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('style', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['style'] = $style;

        return $this;
    }

    /**
     * Gets sub_description1
     *
     * @return string|null
     */
    public function getSubDescription1()
    {
        return $this->container['sub_description1'];
    }

    /**
     * Sets sub_description1
     *
     * @param string|null $sub_description1 Sub description 1
     *
     * @return self
     */
    public function setSubDescription1($sub_description1)
    {
        if (is_null($sub_description1)) {
            array_push($this->openAPINullablesSetToNull, 'sub_description1');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('sub_description1', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['sub_description1'] = $sub_description1;

        return $this;
    }

    /**
     * Gets sub_description2
     *
     * @return string|null
     */
    public function getSubDescription2()
    {
        return $this->container['sub_description2'];
    }

    /**
     * Sets sub_description2
     *
     * @param string|null $sub_description2 Sub description 2
     *
     * @return self
     */
    public function setSubDescription2($sub_description2)
    {
        if (is_null($sub_description2)) {
            array_push($this->openAPINullablesSetToNull, 'sub_description2');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('sub_description2', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['sub_description2'] = $sub_description2;

        return $this;
    }

    /**
     * Gets sub_description3
     *
     * @return string|null
     */
    public function getSubDescription3()
    {
        return $this->container['sub_description3'];
    }

    /**
     * Sets sub_description3
     *
     * @param string|null $sub_description3 Sub description 3
     *
     * @return self
     */
    public function setSubDescription3($sub_description3)
    {
        if (is_null($sub_description3)) {
            array_push($this->openAPINullablesSetToNull, 'sub_description3');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('sub_description3', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['sub_description3'] = $sub_description3;

        return $this;
    }

    /**
     * Gets matrix_items
     *
     * @return \Opsuite2\Model\MatrixItem[]|null
     */
    public function getMatrixItems()
    {
        return $this->container['matrix_items'];
    }

    /**
     * Sets matrix_items
     *
     * @param \Opsuite2\Model\MatrixItem[]|null $matrix_items The matrix items
     *
     * @return self
     */
    public function setMatrixItems($matrix_items)
    {
        if (is_null($matrix_items)) {
            array_push($this->openAPINullablesSetToNull, 'matrix_items');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('matrix_items', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['matrix_items'] = $matrix_items;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


