<?php
/**
 * ManualAdjustment
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * ManualAdjustment Class Doc Comment
 *
 * @category Class
 * @description The details of a manual adjustment
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ManualAdjustment implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ManualAdjustment';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'location_id' => 'int',
        'item_id' => 'int',
        'item_sku' => 'string',
        'item_description' => 'string',
        'item_unit_cost' => 'float',
        'item_extended_cost' => 'float',
        'item_retail_price' => 'float',
        'item_extended_retail_price' => 'float',
        'department_id' => 'int',
        'category_id' => 'int',
        'supplier_id' => 'int',
        'movement_quantity' => 'float',
        'tax_group_id' => 'int',
        'tax_group_name' => 'string',
        'reason_code' => 'string',
        'movement_date' => '\DateTime'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'location_id' => 'int32',
        'item_id' => 'int32',
        'item_sku' => null,
        'item_description' => null,
        'item_unit_cost' => 'double',
        'item_extended_cost' => 'double',
        'item_retail_price' => 'double',
        'item_extended_retail_price' => 'double',
        'department_id' => 'int32',
        'category_id' => 'int32',
        'supplier_id' => 'int32',
        'movement_quantity' => 'double',
        'tax_group_id' => 'int32',
        'tax_group_name' => null,
        'reason_code' => null,
        'movement_date' => 'date-time'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'location_id' => false,
        'item_id' => false,
        'item_sku' => true,
        'item_description' => true,
        'item_unit_cost' => false,
        'item_extended_cost' => false,
        'item_retail_price' => false,
        'item_extended_retail_price' => false,
        'department_id' => false,
        'category_id' => false,
        'supplier_id' => true,
        'movement_quantity' => false,
        'tax_group_id' => false,
        'tax_group_name' => true,
        'reason_code' => true,
        'movement_date' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'location_id' => 'locationId',
        'item_id' => 'itemId',
        'item_sku' => 'itemSku',
        'item_description' => 'itemDescription',
        'item_unit_cost' => 'itemUnitCost',
        'item_extended_cost' => 'itemExtendedCost',
        'item_retail_price' => 'itemRetailPrice',
        'item_extended_retail_price' => 'itemExtendedRetailPrice',
        'department_id' => 'departmentId',
        'category_id' => 'categoryId',
        'supplier_id' => 'supplierId',
        'movement_quantity' => 'movementQuantity',
        'tax_group_id' => 'taxGroupId',
        'tax_group_name' => 'taxGroupName',
        'reason_code' => 'reasonCode',
        'movement_date' => 'movementDate'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'location_id' => 'setLocationId',
        'item_id' => 'setItemId',
        'item_sku' => 'setItemSku',
        'item_description' => 'setItemDescription',
        'item_unit_cost' => 'setItemUnitCost',
        'item_extended_cost' => 'setItemExtendedCost',
        'item_retail_price' => 'setItemRetailPrice',
        'item_extended_retail_price' => 'setItemExtendedRetailPrice',
        'department_id' => 'setDepartmentId',
        'category_id' => 'setCategoryId',
        'supplier_id' => 'setSupplierId',
        'movement_quantity' => 'setMovementQuantity',
        'tax_group_id' => 'setTaxGroupId',
        'tax_group_name' => 'setTaxGroupName',
        'reason_code' => 'setReasonCode',
        'movement_date' => 'setMovementDate'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'location_id' => 'getLocationId',
        'item_id' => 'getItemId',
        'item_sku' => 'getItemSku',
        'item_description' => 'getItemDescription',
        'item_unit_cost' => 'getItemUnitCost',
        'item_extended_cost' => 'getItemExtendedCost',
        'item_retail_price' => 'getItemRetailPrice',
        'item_extended_retail_price' => 'getItemExtendedRetailPrice',
        'department_id' => 'getDepartmentId',
        'category_id' => 'getCategoryId',
        'supplier_id' => 'getSupplierId',
        'movement_quantity' => 'getMovementQuantity',
        'tax_group_id' => 'getTaxGroupId',
        'tax_group_name' => 'getTaxGroupName',
        'reason_code' => 'getReasonCode',
        'movement_date' => 'getMovementDate'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('location_id', $data ?? [], null);
        $this->setIfExists('item_id', $data ?? [], null);
        $this->setIfExists('item_sku', $data ?? [], null);
        $this->setIfExists('item_description', $data ?? [], null);
        $this->setIfExists('item_unit_cost', $data ?? [], null);
        $this->setIfExists('item_extended_cost', $data ?? [], null);
        $this->setIfExists('item_retail_price', $data ?? [], null);
        $this->setIfExists('item_extended_retail_price', $data ?? [], null);
        $this->setIfExists('department_id', $data ?? [], null);
        $this->setIfExists('category_id', $data ?? [], null);
        $this->setIfExists('supplier_id', $data ?? [], null);
        $this->setIfExists('movement_quantity', $data ?? [], null);
        $this->setIfExists('tax_group_id', $data ?? [], null);
        $this->setIfExists('tax_group_name', $data ?? [], null);
        $this->setIfExists('reason_code', $data ?? [], null);
        $this->setIfExists('movement_date', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets location_id
     *
     * @return int|null
     */
    public function getLocationId()
    {
        return $this->container['location_id'];
    }

    /**
     * Sets location_id
     *
     * @param int|null $location_id The location id
     *
     * @return self
     */
    public function setLocationId($location_id)
    {
        if (is_null($location_id)) {
            throw new \InvalidArgumentException('non-nullable location_id cannot be null');
        }
        $this->container['location_id'] = $location_id;

        return $this;
    }

    /**
     * Gets item_id
     *
     * @return int|null
     */
    public function getItemId()
    {
        return $this->container['item_id'];
    }

    /**
     * Sets item_id
     *
     * @param int|null $item_id The item id
     *
     * @return self
     */
    public function setItemId($item_id)
    {
        if (is_null($item_id)) {
            throw new \InvalidArgumentException('non-nullable item_id cannot be null');
        }
        $this->container['item_id'] = $item_id;

        return $this;
    }

    /**
     * Gets item_sku
     *
     * @return string|null
     */
    public function getItemSku()
    {
        return $this->container['item_sku'];
    }

    /**
     * Sets item_sku
     *
     * @param string|null $item_sku The item sku
     *
     * @return self
     */
    public function setItemSku($item_sku)
    {
        if (is_null($item_sku)) {
            array_push($this->openAPINullablesSetToNull, 'item_sku');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('item_sku', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['item_sku'] = $item_sku;

        return $this;
    }

    /**
     * Gets item_description
     *
     * @return string|null
     */
    public function getItemDescription()
    {
        return $this->container['item_description'];
    }

    /**
     * Sets item_description
     *
     * @param string|null $item_description The item description
     *
     * @return self
     */
    public function setItemDescription($item_description)
    {
        if (is_null($item_description)) {
            array_push($this->openAPINullablesSetToNull, 'item_description');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('item_description', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['item_description'] = $item_description;

        return $this;
    }

    /**
     * Gets item_unit_cost
     *
     * @return float|null
     */
    public function getItemUnitCost()
    {
        return $this->container['item_unit_cost'];
    }

    /**
     * Sets item_unit_cost
     *
     * @param float|null $item_unit_cost The cost of the item
     *
     * @return self
     */
    public function setItemUnitCost($item_unit_cost)
    {
        if (is_null($item_unit_cost)) {
            throw new \InvalidArgumentException('non-nullable item_unit_cost cannot be null');
        }
        $this->container['item_unit_cost'] = $item_unit_cost;

        return $this;
    }

    /**
     * Gets item_extended_cost
     *
     * @return float|null
     */
    public function getItemExtendedCost()
    {
        return $this->container['item_extended_cost'];
    }

    /**
     * Sets item_extended_cost
     *
     * @param float|null $item_extended_cost The cost of the movement
     *
     * @return self
     */
    public function setItemExtendedCost($item_extended_cost)
    {
        if (is_null($item_extended_cost)) {
            throw new \InvalidArgumentException('non-nullable item_extended_cost cannot be null');
        }
        $this->container['item_extended_cost'] = $item_extended_cost;

        return $this;
    }

    /**
     * Gets item_retail_price
     *
     * @return float|null
     */
    public function getItemRetailPrice()
    {
        return $this->container['item_retail_price'];
    }

    /**
     * Sets item_retail_price
     *
     * @param float|null $item_retail_price The price of the item
     *
     * @return self
     */
    public function setItemRetailPrice($item_retail_price)
    {
        if (is_null($item_retail_price)) {
            throw new \InvalidArgumentException('non-nullable item_retail_price cannot be null');
        }
        $this->container['item_retail_price'] = $item_retail_price;

        return $this;
    }

    /**
     * Gets item_extended_retail_price
     *
     * @return float|null
     */
    public function getItemExtendedRetailPrice()
    {
        return $this->container['item_extended_retail_price'];
    }

    /**
     * Sets item_extended_retail_price
     *
     * @param float|null $item_extended_retail_price The value of the movement
     *
     * @return self
     */
    public function setItemExtendedRetailPrice($item_extended_retail_price)
    {
        if (is_null($item_extended_retail_price)) {
            throw new \InvalidArgumentException('non-nullable item_extended_retail_price cannot be null');
        }
        $this->container['item_extended_retail_price'] = $item_extended_retail_price;

        return $this;
    }

    /**
     * Gets department_id
     *
     * @return int|null
     */
    public function getDepartmentId()
    {
        return $this->container['department_id'];
    }

    /**
     * Sets department_id
     *
     * @param int|null $department_id The item's department id
     *
     * @return self
     */
    public function setDepartmentId($department_id)
    {
        if (is_null($department_id)) {
            throw new \InvalidArgumentException('non-nullable department_id cannot be null');
        }
        $this->container['department_id'] = $department_id;

        return $this;
    }

    /**
     * Gets category_id
     *
     * @return int|null
     */
    public function getCategoryId()
    {
        return $this->container['category_id'];
    }

    /**
     * Sets category_id
     *
     * @param int|null $category_id The item's category id
     *
     * @return self
     */
    public function setCategoryId($category_id)
    {
        if (is_null($category_id)) {
            throw new \InvalidArgumentException('non-nullable category_id cannot be null');
        }
        $this->container['category_id'] = $category_id;

        return $this;
    }

    /**
     * Gets supplier_id
     *
     * @return int|null
     */
    public function getSupplierId()
    {
        return $this->container['supplier_id'];
    }

    /**
     * Sets supplier_id
     *
     * @param int|null $supplier_id The item's supplier id
     *
     * @return self
     */
    public function setSupplierId($supplier_id)
    {
        if (is_null($supplier_id)) {
            array_push($this->openAPINullablesSetToNull, 'supplier_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('supplier_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['supplier_id'] = $supplier_id;

        return $this;
    }

    /**
     * Gets movement_quantity
     *
     * @return float|null
     */
    public function getMovementQuantity()
    {
        return $this->container['movement_quantity'];
    }

    /**
     * Sets movement_quantity
     *
     * @param float|null $movement_quantity The movement quantity
     *
     * @return self
     */
    public function setMovementQuantity($movement_quantity)
    {
        if (is_null($movement_quantity)) {
            throw new \InvalidArgumentException('non-nullable movement_quantity cannot be null');
        }
        $this->container['movement_quantity'] = $movement_quantity;

        return $this;
    }

    /**
     * Gets tax_group_id
     *
     * @return int|null
     */
    public function getTaxGroupId()
    {
        return $this->container['tax_group_id'];
    }

    /**
     * Sets tax_group_id
     *
     * @param int|null $tax_group_id The item's tax group id
     *
     * @return self
     */
    public function setTaxGroupId($tax_group_id)
    {
        if (is_null($tax_group_id)) {
            throw new \InvalidArgumentException('non-nullable tax_group_id cannot be null');
        }
        $this->container['tax_group_id'] = $tax_group_id;

        return $this;
    }

    /**
     * Gets tax_group_name
     *
     * @return string|null
     */
    public function getTaxGroupName()
    {
        return $this->container['tax_group_name'];
    }

    /**
     * Sets tax_group_name
     *
     * @param string|null $tax_group_name The item's tax group name
     *
     * @return self
     */
    public function setTaxGroupName($tax_group_name)
    {
        if (is_null($tax_group_name)) {
            array_push($this->openAPINullablesSetToNull, 'tax_group_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('tax_group_name', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['tax_group_name'] = $tax_group_name;

        return $this;
    }

    /**
     * Gets reason_code
     *
     * @return string|null
     */
    public function getReasonCode()
    {
        return $this->container['reason_code'];
    }

    /**
     * Sets reason_code
     *
     * @param string|null $reason_code The movement reason code
     *
     * @return self
     */
    public function setReasonCode($reason_code)
    {
        if (is_null($reason_code)) {
            array_push($this->openAPINullablesSetToNull, 'reason_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('reason_code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['reason_code'] = $reason_code;

        return $this;
    }

    /**
     * Gets movement_date
     *
     * @return \DateTime|null
     */
    public function getMovementDate()
    {
        return $this->container['movement_date'];
    }

    /**
     * Sets movement_date
     *
     * @param \DateTime|null $movement_date The movement date
     *
     * @return self
     */
    public function setMovementDate($movement_date)
    {
        if (is_null($movement_date)) {
            throw new \InvalidArgumentException('non-nullable movement_date cannot be null');
        }
        $this->container['movement_date'] = $movement_date;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


