<?php
/**
 * Location
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * Location Class Doc Comment
 *
 * @category Class
 * @description Details of a location.
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Location implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Location';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'location_code' => 'string',
        'location_name' => 'string',
        'location_trading_name' => 'string',
        'location_type_name' => 'string',
        'is_warehouse' => 'bool',
        'is_web_location' => 'bool',
        'tax_registration_number' => 'string',
        'web_address' => 'string',
        'email' => 'string',
        'address_line1' => 'string',
        'address_line2' => 'string',
        'address_line3' => 'string',
        'address_line4' => 'string',
        'city' => 'string',
        'territory' => 'string',
        'zip' => 'string',
        'iso_country_code' => 'string',
        'telephone_itu_country_code' => 'string',
        'telephone_number' => 'string',
        'fax_itu_country_code' => 'string',
        'fax_number' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'int32',
        'location_code' => null,
        'location_name' => null,
        'location_trading_name' => null,
        'location_type_name' => null,
        'is_warehouse' => null,
        'is_web_location' => null,
        'tax_registration_number' => null,
        'web_address' => null,
        'email' => null,
        'address_line1' => null,
        'address_line2' => null,
        'address_line3' => null,
        'address_line4' => null,
        'city' => null,
        'territory' => null,
        'zip' => null,
        'iso_country_code' => null,
        'telephone_itu_country_code' => null,
        'telephone_number' => null,
        'fax_itu_country_code' => null,
        'fax_number' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'location_code' => true,
        'location_name' => true,
        'location_trading_name' => true,
        'location_type_name' => true,
        'is_warehouse' => false,
        'is_web_location' => false,
        'tax_registration_number' => true,
        'web_address' => true,
        'email' => true,
        'address_line1' => true,
        'address_line2' => true,
        'address_line3' => true,
        'address_line4' => true,
        'city' => true,
        'territory' => true,
        'zip' => true,
        'iso_country_code' => true,
        'telephone_itu_country_code' => true,
        'telephone_number' => true,
        'fax_itu_country_code' => true,
        'fax_number' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'location_code' => 'locationCode',
        'location_name' => 'locationName',
        'location_trading_name' => 'locationTradingName',
        'location_type_name' => 'locationTypeName',
        'is_warehouse' => 'isWarehouse',
        'is_web_location' => 'isWebLocation',
        'tax_registration_number' => 'taxRegistrationNumber',
        'web_address' => 'webAddress',
        'email' => 'email',
        'address_line1' => 'addressLine1',
        'address_line2' => 'addressLine2',
        'address_line3' => 'addressLine3',
        'address_line4' => 'addressLine4',
        'city' => 'city',
        'territory' => 'territory',
        'zip' => 'zip',
        'iso_country_code' => 'isoCountryCode',
        'telephone_itu_country_code' => 'telephoneItuCountryCode',
        'telephone_number' => 'telephoneNumber',
        'fax_itu_country_code' => 'faxItuCountryCode',
        'fax_number' => 'faxNumber'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'location_code' => 'setLocationCode',
        'location_name' => 'setLocationName',
        'location_trading_name' => 'setLocationTradingName',
        'location_type_name' => 'setLocationTypeName',
        'is_warehouse' => 'setIsWarehouse',
        'is_web_location' => 'setIsWebLocation',
        'tax_registration_number' => 'setTaxRegistrationNumber',
        'web_address' => 'setWebAddress',
        'email' => 'setEmail',
        'address_line1' => 'setAddressLine1',
        'address_line2' => 'setAddressLine2',
        'address_line3' => 'setAddressLine3',
        'address_line4' => 'setAddressLine4',
        'city' => 'setCity',
        'territory' => 'setTerritory',
        'zip' => 'setZip',
        'iso_country_code' => 'setIsoCountryCode',
        'telephone_itu_country_code' => 'setTelephoneItuCountryCode',
        'telephone_number' => 'setTelephoneNumber',
        'fax_itu_country_code' => 'setFaxItuCountryCode',
        'fax_number' => 'setFaxNumber'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'location_code' => 'getLocationCode',
        'location_name' => 'getLocationName',
        'location_trading_name' => 'getLocationTradingName',
        'location_type_name' => 'getLocationTypeName',
        'is_warehouse' => 'getIsWarehouse',
        'is_web_location' => 'getIsWebLocation',
        'tax_registration_number' => 'getTaxRegistrationNumber',
        'web_address' => 'getWebAddress',
        'email' => 'getEmail',
        'address_line1' => 'getAddressLine1',
        'address_line2' => 'getAddressLine2',
        'address_line3' => 'getAddressLine3',
        'address_line4' => 'getAddressLine4',
        'city' => 'getCity',
        'territory' => 'getTerritory',
        'zip' => 'getZip',
        'iso_country_code' => 'getIsoCountryCode',
        'telephone_itu_country_code' => 'getTelephoneItuCountryCode',
        'telephone_number' => 'getTelephoneNumber',
        'fax_itu_country_code' => 'getFaxItuCountryCode',
        'fax_number' => 'getFaxNumber'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('location_code', $data ?? [], null);
        $this->setIfExists('location_name', $data ?? [], null);
        $this->setIfExists('location_trading_name', $data ?? [], null);
        $this->setIfExists('location_type_name', $data ?? [], null);
        $this->setIfExists('is_warehouse', $data ?? [], null);
        $this->setIfExists('is_web_location', $data ?? [], null);
        $this->setIfExists('tax_registration_number', $data ?? [], null);
        $this->setIfExists('web_address', $data ?? [], null);
        $this->setIfExists('email', $data ?? [], null);
        $this->setIfExists('address_line1', $data ?? [], null);
        $this->setIfExists('address_line2', $data ?? [], null);
        $this->setIfExists('address_line3', $data ?? [], null);
        $this->setIfExists('address_line4', $data ?? [], null);
        $this->setIfExists('city', $data ?? [], null);
        $this->setIfExists('territory', $data ?? [], null);
        $this->setIfExists('zip', $data ?? [], null);
        $this->setIfExists('iso_country_code', $data ?? [], null);
        $this->setIfExists('telephone_itu_country_code', $data ?? [], null);
        $this->setIfExists('telephone_number', $data ?? [], null);
        $this->setIfExists('fax_itu_country_code', $data ?? [], null);
        $this->setIfExists('fax_number', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['location_code']) && (mb_strlen($this->container['location_code']) > 50)) {
            $invalidProperties[] = "invalid value for 'location_code', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['location_code']) && (mb_strlen($this->container['location_code']) < 0)) {
            $invalidProperties[] = "invalid value for 'location_code', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['location_name']) && (mb_strlen($this->container['location_name']) > 50)) {
            $invalidProperties[] = "invalid value for 'location_name', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['location_name']) && (mb_strlen($this->container['location_name']) < 0)) {
            $invalidProperties[] = "invalid value for 'location_name', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['location_trading_name']) && (mb_strlen($this->container['location_trading_name']) > 50)) {
            $invalidProperties[] = "invalid value for 'location_trading_name', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['location_trading_name']) && (mb_strlen($this->container['location_trading_name']) < 0)) {
            $invalidProperties[] = "invalid value for 'location_trading_name', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['location_type_name']) && (mb_strlen($this->container['location_type_name']) > 50)) {
            $invalidProperties[] = "invalid value for 'location_type_name', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['location_type_name']) && (mb_strlen($this->container['location_type_name']) < 0)) {
            $invalidProperties[] = "invalid value for 'location_type_name', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['tax_registration_number']) && (mb_strlen($this->container['tax_registration_number']) > 50)) {
            $invalidProperties[] = "invalid value for 'tax_registration_number', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['tax_registration_number']) && (mb_strlen($this->container['tax_registration_number']) < 0)) {
            $invalidProperties[] = "invalid value for 'tax_registration_number', the character length must be bigger than or equal to 0.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id The location id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets location_code
     *
     * @return string|null
     */
    public function getLocationCode()
    {
        return $this->container['location_code'];
    }

    /**
     * Sets location_code
     *
     * @param string|null $location_code The location code
     *
     * @return self
     */
    public function setLocationCode($location_code)
    {
        if (is_null($location_code)) {
            array_push($this->openAPINullablesSetToNull, 'location_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('location_code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($location_code) && (mb_strlen($location_code) > 50)) {
            throw new \InvalidArgumentException('invalid length for $location_code when calling Location., must be smaller than or equal to 50.');
        }
        if (!is_null($location_code) && (mb_strlen($location_code) < 0)) {
            throw new \InvalidArgumentException('invalid length for $location_code when calling Location., must be bigger than or equal to 0.');
        }

        $this->container['location_code'] = $location_code;

        return $this;
    }

    /**
     * Gets location_name
     *
     * @return string|null
     */
    public function getLocationName()
    {
        return $this->container['location_name'];
    }

    /**
     * Sets location_name
     *
     * @param string|null $location_name The location name
     *
     * @return self
     */
    public function setLocationName($location_name)
    {
        if (is_null($location_name)) {
            array_push($this->openAPINullablesSetToNull, 'location_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('location_name', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($location_name) && (mb_strlen($location_name) > 50)) {
            throw new \InvalidArgumentException('invalid length for $location_name when calling Location., must be smaller than or equal to 50.');
        }
        if (!is_null($location_name) && (mb_strlen($location_name) < 0)) {
            throw new \InvalidArgumentException('invalid length for $location_name when calling Location., must be bigger than or equal to 0.');
        }

        $this->container['location_name'] = $location_name;

        return $this;
    }

    /**
     * Gets location_trading_name
     *
     * @return string|null
     */
    public function getLocationTradingName()
    {
        return $this->container['location_trading_name'];
    }

    /**
     * Sets location_trading_name
     *
     * @param string|null $location_trading_name The location's trading name if different from the name
     *
     * @return self
     */
    public function setLocationTradingName($location_trading_name)
    {
        if (is_null($location_trading_name)) {
            array_push($this->openAPINullablesSetToNull, 'location_trading_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('location_trading_name', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($location_trading_name) && (mb_strlen($location_trading_name) > 50)) {
            throw new \InvalidArgumentException('invalid length for $location_trading_name when calling Location., must be smaller than or equal to 50.');
        }
        if (!is_null($location_trading_name) && (mb_strlen($location_trading_name) < 0)) {
            throw new \InvalidArgumentException('invalid length for $location_trading_name when calling Location., must be bigger than or equal to 0.');
        }

        $this->container['location_trading_name'] = $location_trading_name;

        return $this;
    }

    /**
     * Gets location_type_name
     *
     * @return string|null
     */
    public function getLocationTypeName()
    {
        return $this->container['location_type_name'];
    }

    /**
     * Sets location_type_name
     *
     * @param string|null $location_type_name The type of location
     *
     * @return self
     */
    public function setLocationTypeName($location_type_name)
    {
        if (is_null($location_type_name)) {
            array_push($this->openAPINullablesSetToNull, 'location_type_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('location_type_name', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($location_type_name) && (mb_strlen($location_type_name) > 50)) {
            throw new \InvalidArgumentException('invalid length for $location_type_name when calling Location., must be smaller than or equal to 50.');
        }
        if (!is_null($location_type_name) && (mb_strlen($location_type_name) < 0)) {
            throw new \InvalidArgumentException('invalid length for $location_type_name when calling Location., must be bigger than or equal to 0.');
        }

        $this->container['location_type_name'] = $location_type_name;

        return $this;
    }

    /**
     * Gets is_warehouse
     *
     * @return bool|null
     */
    public function getIsWarehouse()
    {
        return $this->container['is_warehouse'];
    }

    /**
     * Sets is_warehouse
     *
     * @param bool|null $is_warehouse Whether this location is a warehouse or not
     *
     * @return self
     */
    public function setIsWarehouse($is_warehouse)
    {
        if (is_null($is_warehouse)) {
            throw new \InvalidArgumentException('non-nullable is_warehouse cannot be null');
        }
        $this->container['is_warehouse'] = $is_warehouse;

        return $this;
    }

    /**
     * Gets is_web_location
     *
     * @return bool|null
     */
    public function getIsWebLocation()
    {
        return $this->container['is_web_location'];
    }

    /**
     * Sets is_web_location
     *
     * @param bool|null $is_web_location Whether this location is a web location or not
     *
     * @return self
     */
    public function setIsWebLocation($is_web_location)
    {
        if (is_null($is_web_location)) {
            throw new \InvalidArgumentException('non-nullable is_web_location cannot be null');
        }
        $this->container['is_web_location'] = $is_web_location;

        return $this;
    }

    /**
     * Gets tax_registration_number
     *
     * @return string|null
     */
    public function getTaxRegistrationNumber()
    {
        return $this->container['tax_registration_number'];
    }

    /**
     * Sets tax_registration_number
     *
     * @param string|null $tax_registration_number The location's tax number
     *
     * @return self
     */
    public function setTaxRegistrationNumber($tax_registration_number)
    {
        if (is_null($tax_registration_number)) {
            array_push($this->openAPINullablesSetToNull, 'tax_registration_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('tax_registration_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($tax_registration_number) && (mb_strlen($tax_registration_number) > 50)) {
            throw new \InvalidArgumentException('invalid length for $tax_registration_number when calling Location., must be smaller than or equal to 50.');
        }
        if (!is_null($tax_registration_number) && (mb_strlen($tax_registration_number) < 0)) {
            throw new \InvalidArgumentException('invalid length for $tax_registration_number when calling Location., must be bigger than or equal to 0.');
        }

        $this->container['tax_registration_number'] = $tax_registration_number;

        return $this;
    }

    /**
     * Gets web_address
     *
     * @return string|null
     */
    public function getWebAddress()
    {
        return $this->container['web_address'];
    }

    /**
     * Sets web_address
     *
     * @param string|null $web_address If set, the web site associated with this location
     *
     * @return self
     */
    public function setWebAddress($web_address)
    {
        if (is_null($web_address)) {
            array_push($this->openAPINullablesSetToNull, 'web_address');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('web_address', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['web_address'] = $web_address;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string|null $email If set, the email address associated with this location
     *
     * @return self
     */
    public function setEmail($email)
    {
        if (is_null($email)) {
            array_push($this->openAPINullablesSetToNull, 'email');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('email', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets address_line1
     *
     * @return string|null
     */
    public function getAddressLine1()
    {
        return $this->container['address_line1'];
    }

    /**
     * Sets address_line1
     *
     * @param string|null $address_line1 The first line of the location's physical address
     *
     * @return self
     */
    public function setAddressLine1($address_line1)
    {
        if (is_null($address_line1)) {
            array_push($this->openAPINullablesSetToNull, 'address_line1');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('address_line1', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['address_line1'] = $address_line1;

        return $this;
    }

    /**
     * Gets address_line2
     *
     * @return string|null
     */
    public function getAddressLine2()
    {
        return $this->container['address_line2'];
    }

    /**
     * Sets address_line2
     *
     * @param string|null $address_line2 The second line of the location's physical address
     *
     * @return self
     */
    public function setAddressLine2($address_line2)
    {
        if (is_null($address_line2)) {
            array_push($this->openAPINullablesSetToNull, 'address_line2');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('address_line2', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['address_line2'] = $address_line2;

        return $this;
    }

    /**
     * Gets address_line3
     *
     * @return string|null
     */
    public function getAddressLine3()
    {
        return $this->container['address_line3'];
    }

    /**
     * Sets address_line3
     *
     * @param string|null $address_line3 The third line of the location's physical address
     *
     * @return self
     */
    public function setAddressLine3($address_line3)
    {
        if (is_null($address_line3)) {
            array_push($this->openAPINullablesSetToNull, 'address_line3');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('address_line3', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['address_line3'] = $address_line3;

        return $this;
    }

    /**
     * Gets address_line4
     *
     * @return string|null
     */
    public function getAddressLine4()
    {
        return $this->container['address_line4'];
    }

    /**
     * Sets address_line4
     *
     * @param string|null $address_line4 The fourth line of the location's physical address
     *
     * @return self
     */
    public function setAddressLine4($address_line4)
    {
        if (is_null($address_line4)) {
            array_push($this->openAPINullablesSetToNull, 'address_line4');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('address_line4', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['address_line4'] = $address_line4;

        return $this;
    }

    /**
     * Gets city
     *
     * @return string|null
     */
    public function getCity()
    {
        return $this->container['city'];
    }

    /**
     * Sets city
     *
     * @param string|null $city The city of the location's physical address
     *
     * @return self
     */
    public function setCity($city)
    {
        if (is_null($city)) {
            array_push($this->openAPINullablesSetToNull, 'city');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('city', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['city'] = $city;

        return $this;
    }

    /**
     * Gets territory
     *
     * @return string|null
     */
    public function getTerritory()
    {
        return $this->container['territory'];
    }

    /**
     * Sets territory
     *
     * @param string|null $territory The county of the location's physical address
     *
     * @return self
     */
    public function setTerritory($territory)
    {
        if (is_null($territory)) {
            array_push($this->openAPINullablesSetToNull, 'territory');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('territory', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['territory'] = $territory;

        return $this;
    }

    /**
     * Gets zip
     *
     * @return string|null
     */
    public function getZip()
    {
        return $this->container['zip'];
    }

    /**
     * Sets zip
     *
     * @param string|null $zip The postcode of the location's physical address
     *
     * @return self
     */
    public function setZip($zip)
    {
        if (is_null($zip)) {
            array_push($this->openAPINullablesSetToNull, 'zip');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('zip', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['zip'] = $zip;

        return $this;
    }

    /**
     * Gets iso_country_code
     *
     * @return string|null
     */
    public function getIsoCountryCode()
    {
        return $this->container['iso_country_code'];
    }

    /**
     * Sets iso_country_code
     *
     * @param string|null $iso_country_code The country code of the location's address
     *
     * @return self
     */
    public function setIsoCountryCode($iso_country_code)
    {
        if (is_null($iso_country_code)) {
            array_push($this->openAPINullablesSetToNull, 'iso_country_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('iso_country_code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['iso_country_code'] = $iso_country_code;

        return $this;
    }

    /**
     * Gets telephone_itu_country_code
     *
     * @return string|null
     */
    public function getTelephoneItuCountryCode()
    {
        return $this->container['telephone_itu_country_code'];
    }

    /**
     * Sets telephone_itu_country_code
     *
     * @param string|null $telephone_itu_country_code The country code of the location's phone number
     *
     * @return self
     */
    public function setTelephoneItuCountryCode($telephone_itu_country_code)
    {
        if (is_null($telephone_itu_country_code)) {
            array_push($this->openAPINullablesSetToNull, 'telephone_itu_country_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('telephone_itu_country_code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['telephone_itu_country_code'] = $telephone_itu_country_code;

        return $this;
    }

    /**
     * Gets telephone_number
     *
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return $this->container['telephone_number'];
    }

    /**
     * Sets telephone_number
     *
     * @param string|null $telephone_number The location's phone number
     *
     * @return self
     */
    public function setTelephoneNumber($telephone_number)
    {
        if (is_null($telephone_number)) {
            array_push($this->openAPINullablesSetToNull, 'telephone_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('telephone_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['telephone_number'] = $telephone_number;

        return $this;
    }

    /**
     * Gets fax_itu_country_code
     *
     * @return string|null
     */
    public function getFaxItuCountryCode()
    {
        return $this->container['fax_itu_country_code'];
    }

    /**
     * Sets fax_itu_country_code
     *
     * @param string|null $fax_itu_country_code The country code of the location's fax number
     *
     * @return self
     */
    public function setFaxItuCountryCode($fax_itu_country_code)
    {
        if (is_null($fax_itu_country_code)) {
            array_push($this->openAPINullablesSetToNull, 'fax_itu_country_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('fax_itu_country_code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['fax_itu_country_code'] = $fax_itu_country_code;

        return $this;
    }

    /**
     * Gets fax_number
     *
     * @return string|null
     */
    public function getFaxNumber()
    {
        return $this->container['fax_number'];
    }

    /**
     * Sets fax_number
     *
     * @param string|null $fax_number The location's fax number
     *
     * @return self
     */
    public function setFaxNumber($fax_number)
    {
        if (is_null($fax_number)) {
            array_push($this->openAPINullablesSetToNull, 'fax_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('fax_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['fax_number'] = $fax_number;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


