<?php
/**
 * ItemMaster
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * ItemMaster Class Doc Comment
 *
 * @category Class
 * @description The details of an item
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ItemMaster implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ItemMaster';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'item_type_id' => 'int',
        'sku' => 'string',
        'department_id' => 'int',
        'category_id' => 'int',
        'cost' => 'float',
        'description' => 'string',
        'extended_description' => 'string',
        'sub_description1' => 'string',
        'sub_description2' => 'string',
        'sub_description3' => 'string',
        'manufacturer' => 'string',
        'product_line' => 'string',
        'commodity_code' => 'string',
        'primary_supplier_id' => 'int',
        'price' => 'float',
        'price_inc_tax' => 'float',
        'msrp' => 'float',
        'tax_rate_id' => 'int',
        'unit_of_measure_id' => 'int',
        'barcode_number' => 'string',
        'active' => 'bool',
        'weight' => 'float'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'int32',
        'item_type_id' => 'int32',
        'sku' => null,
        'department_id' => 'int32',
        'category_id' => 'int32',
        'cost' => 'double',
        'description' => null,
        'extended_description' => null,
        'sub_description1' => null,
        'sub_description2' => null,
        'sub_description3' => null,
        'manufacturer' => null,
        'product_line' => null,
        'commodity_code' => null,
        'primary_supplier_id' => 'int32',
        'price' => 'double',
        'price_inc_tax' => 'double',
        'msrp' => 'double',
        'tax_rate_id' => 'int32',
        'unit_of_measure_id' => 'int32',
        'barcode_number' => null,
        'active' => null,
        'weight' => 'double'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'item_type_id' => false,
        'sku' => false,
        'department_id' => false,
        'category_id' => false,
        'cost' => false,
        'description' => false,
        'extended_description' => true,
        'sub_description1' => true,
        'sub_description2' => true,
        'sub_description3' => true,
        'manufacturer' => true,
        'product_line' => true,
        'commodity_code' => true,
        'primary_supplier_id' => true,
        'price' => false,
        'price_inc_tax' => false,
        'msrp' => false,
        'tax_rate_id' => true,
        'unit_of_measure_id' => false,
        'barcode_number' => true,
        'active' => false,
        'weight' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'item_type_id' => 'itemTypeId',
        'sku' => 'sku',
        'department_id' => 'departmentId',
        'category_id' => 'categoryId',
        'cost' => 'cost',
        'description' => 'description',
        'extended_description' => 'extendedDescription',
        'sub_description1' => 'subDescription1',
        'sub_description2' => 'subDescription2',
        'sub_description3' => 'subDescription3',
        'manufacturer' => 'manufacturer',
        'product_line' => 'productLine',
        'commodity_code' => 'commodityCode',
        'primary_supplier_id' => 'primarySupplierId',
        'price' => 'price',
        'price_inc_tax' => 'priceIncTax',
        'msrp' => 'msrp',
        'tax_rate_id' => 'taxRateId',
        'unit_of_measure_id' => 'unitOfMeasureId',
        'barcode_number' => 'barcodeNumber',
        'active' => 'active',
        'weight' => 'weight'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'item_type_id' => 'setItemTypeId',
        'sku' => 'setSku',
        'department_id' => 'setDepartmentId',
        'category_id' => 'setCategoryId',
        'cost' => 'setCost',
        'description' => 'setDescription',
        'extended_description' => 'setExtendedDescription',
        'sub_description1' => 'setSubDescription1',
        'sub_description2' => 'setSubDescription2',
        'sub_description3' => 'setSubDescription3',
        'manufacturer' => 'setManufacturer',
        'product_line' => 'setProductLine',
        'commodity_code' => 'setCommodityCode',
        'primary_supplier_id' => 'setPrimarySupplierId',
        'price' => 'setPrice',
        'price_inc_tax' => 'setPriceIncTax',
        'msrp' => 'setMsrp',
        'tax_rate_id' => 'setTaxRateId',
        'unit_of_measure_id' => 'setUnitOfMeasureId',
        'barcode_number' => 'setBarcodeNumber',
        'active' => 'setActive',
        'weight' => 'setWeight'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'item_type_id' => 'getItemTypeId',
        'sku' => 'getSku',
        'department_id' => 'getDepartmentId',
        'category_id' => 'getCategoryId',
        'cost' => 'getCost',
        'description' => 'getDescription',
        'extended_description' => 'getExtendedDescription',
        'sub_description1' => 'getSubDescription1',
        'sub_description2' => 'getSubDescription2',
        'sub_description3' => 'getSubDescription3',
        'manufacturer' => 'getManufacturer',
        'product_line' => 'getProductLine',
        'commodity_code' => 'getCommodityCode',
        'primary_supplier_id' => 'getPrimarySupplierId',
        'price' => 'getPrice',
        'price_inc_tax' => 'getPriceIncTax',
        'msrp' => 'getMsrp',
        'tax_rate_id' => 'getTaxRateId',
        'unit_of_measure_id' => 'getUnitOfMeasureId',
        'barcode_number' => 'getBarcodeNumber',
        'active' => 'getActive',
        'weight' => 'getWeight'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('item_type_id', $data ?? [], null);
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('department_id', $data ?? [], null);
        $this->setIfExists('category_id', $data ?? [], null);
        $this->setIfExists('cost', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('extended_description', $data ?? [], null);
        $this->setIfExists('sub_description1', $data ?? [], null);
        $this->setIfExists('sub_description2', $data ?? [], null);
        $this->setIfExists('sub_description3', $data ?? [], null);
        $this->setIfExists('manufacturer', $data ?? [], null);
        $this->setIfExists('product_line', $data ?? [], null);
        $this->setIfExists('commodity_code', $data ?? [], null);
        $this->setIfExists('primary_supplier_id', $data ?? [], null);
        $this->setIfExists('price', $data ?? [], null);
        $this->setIfExists('price_inc_tax', $data ?? [], null);
        $this->setIfExists('msrp', $data ?? [], null);
        $this->setIfExists('tax_rate_id', $data ?? [], null);
        $this->setIfExists('unit_of_measure_id', $data ?? [], null);
        $this->setIfExists('barcode_number', $data ?? [], null);
        $this->setIfExists('active', $data ?? [], null);
        $this->setIfExists('weight', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['item_type_id'] === null) {
            $invalidProperties[] = "'item_type_id' can't be null";
        }
        if ($this->container['sku'] === null) {
            $invalidProperties[] = "'sku' can't be null";
        }
        if ((mb_strlen($this->container['sku']) > 32)) {
            $invalidProperties[] = "invalid value for 'sku', the character length must be smaller than or equal to 32.";
        }

        if ((mb_strlen($this->container['sku']) < 0)) {
            $invalidProperties[] = "invalid value for 'sku', the character length must be bigger than or equal to 0.";
        }

        if ($this->container['department_id'] === null) {
            $invalidProperties[] = "'department_id' can't be null";
        }
        if ($this->container['category_id'] === null) {
            $invalidProperties[] = "'category_id' can't be null";
        }
        if ($this->container['cost'] === null) {
            $invalidProperties[] = "'cost' can't be null";
        }
        if ($this->container['description'] === null) {
            $invalidProperties[] = "'description' can't be null";
        }
        if ((mb_strlen($this->container['description']) > 128)) {
            $invalidProperties[] = "invalid value for 'description', the character length must be smaller than or equal to 128.";
        }

        if ((mb_strlen($this->container['description']) < 0)) {
            $invalidProperties[] = "invalid value for 'description', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['barcode_number']) && (mb_strlen($this->container['barcode_number']) > 32)) {
            $invalidProperties[] = "invalid value for 'barcode_number', the character length must be smaller than or equal to 32.";
        }

        if (!is_null($this->container['barcode_number']) && (mb_strlen($this->container['barcode_number']) < 0)) {
            $invalidProperties[] = "invalid value for 'barcode_number', the character length must be bigger than or equal to 0.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id The item master id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets item_type_id
     *
     * @return int
     */
    public function getItemTypeId()
    {
        return $this->container['item_type_id'];
    }

    /**
     * Sets item_type_id
     *
     * @param int $item_type_id The item type:<br />  0 Standard<br />  6 Weighed<br />  7 Non-Inventory<br />  9 Voucher<br />  10 Scale<br />  11 OpSuite Kit<br />  12 Non-Inventory Scale<br />
     *
     * @return self
     */
    public function setItemTypeId($item_type_id)
    {
        if (is_null($item_type_id)) {
            throw new \InvalidArgumentException('non-nullable item_type_id cannot be null');
        }
        $this->container['item_type_id'] = $item_type_id;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string $sku The item Sku
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            throw new \InvalidArgumentException('non-nullable sku cannot be null');
        }
        if ((mb_strlen($sku) > 32)) {
            throw new \InvalidArgumentException('invalid length for $sku when calling ItemMaster., must be smaller than or equal to 32.');
        }
        if ((mb_strlen($sku) < 0)) {
            throw new \InvalidArgumentException('invalid length for $sku when calling ItemMaster., must be bigger than or equal to 0.');
        }

        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets department_id
     *
     * @return int
     */
    public function getDepartmentId()
    {
        return $this->container['department_id'];
    }

    /**
     * Sets department_id
     *
     * @param int $department_id The item's department id
     *
     * @return self
     */
    public function setDepartmentId($department_id)
    {
        if (is_null($department_id)) {
            throw new \InvalidArgumentException('non-nullable department_id cannot be null');
        }
        $this->container['department_id'] = $department_id;

        return $this;
    }

    /**
     * Gets category_id
     *
     * @return int
     */
    public function getCategoryId()
    {
        return $this->container['category_id'];
    }

    /**
     * Sets category_id
     *
     * @param int $category_id The item's category id
     *
     * @return self
     */
    public function setCategoryId($category_id)
    {
        if (is_null($category_id)) {
            throw new \InvalidArgumentException('non-nullable category_id cannot be null');
        }
        $this->container['category_id'] = $category_id;

        return $this;
    }

    /**
     * Gets cost
     *
     * @return float
     */
    public function getCost()
    {
        return $this->container['cost'];
    }

    /**
     * Sets cost
     *
     * @param float $cost The item's default cost
     *
     * @return self
     */
    public function setCost($cost)
    {
        if (is_null($cost)) {
            throw new \InvalidArgumentException('non-nullable cost cannot be null');
        }
        $this->container['cost'] = $cost;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string $description The item description
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            throw new \InvalidArgumentException('non-nullable description cannot be null');
        }
        if ((mb_strlen($description) > 128)) {
            throw new \InvalidArgumentException('invalid length for $description when calling ItemMaster., must be smaller than or equal to 128.');
        }
        if ((mb_strlen($description) < 0)) {
            throw new \InvalidArgumentException('invalid length for $description when calling ItemMaster., must be bigger than or equal to 0.');
        }

        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets extended_description
     *
     * @return string|null
     */
    public function getExtendedDescription()
    {
        return $this->container['extended_description'];
    }

    /**
     * Sets extended_description
     *
     * @param string|null $extended_description The item extended description
     *
     * @return self
     */
    public function setExtendedDescription($extended_description)
    {
        if (is_null($extended_description)) {
            array_push($this->openAPINullablesSetToNull, 'extended_description');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('extended_description', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['extended_description'] = $extended_description;

        return $this;
    }

    /**
     * Gets sub_description1
     *
     * @return string|null
     */
    public function getSubDescription1()
    {
        return $this->container['sub_description1'];
    }

    /**
     * Sets sub_description1
     *
     * @param string|null $sub_description1 The item sub description 1
     *
     * @return self
     */
    public function setSubDescription1($sub_description1)
    {
        if (is_null($sub_description1)) {
            array_push($this->openAPINullablesSetToNull, 'sub_description1');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('sub_description1', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['sub_description1'] = $sub_description1;

        return $this;
    }

    /**
     * Gets sub_description2
     *
     * @return string|null
     */
    public function getSubDescription2()
    {
        return $this->container['sub_description2'];
    }

    /**
     * Sets sub_description2
     *
     * @param string|null $sub_description2 The item sub description 2
     *
     * @return self
     */
    public function setSubDescription2($sub_description2)
    {
        if (is_null($sub_description2)) {
            array_push($this->openAPINullablesSetToNull, 'sub_description2');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('sub_description2', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['sub_description2'] = $sub_description2;

        return $this;
    }

    /**
     * Gets sub_description3
     *
     * @return string|null
     */
    public function getSubDescription3()
    {
        return $this->container['sub_description3'];
    }

    /**
     * Sets sub_description3
     *
     * @param string|null $sub_description3 The item sub description 3
     *
     * @return self
     */
    public function setSubDescription3($sub_description3)
    {
        if (is_null($sub_description3)) {
            array_push($this->openAPINullablesSetToNull, 'sub_description3');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('sub_description3', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['sub_description3'] = $sub_description3;

        return $this;
    }

    /**
     * Gets manufacturer
     *
     * @return string|null
     */
    public function getManufacturer()
    {
        return $this->container['manufacturer'];
    }

    /**
     * Sets manufacturer
     *
     * @param string|null $manufacturer The item manufacturer
     *
     * @return self
     */
    public function setManufacturer($manufacturer)
    {
        if (is_null($manufacturer)) {
            array_push($this->openAPINullablesSetToNull, 'manufacturer');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('manufacturer', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['manufacturer'] = $manufacturer;

        return $this;
    }

    /**
     * Gets product_line
     *
     * @return string|null
     */
    public function getProductLine()
    {
        return $this->container['product_line'];
    }

    /**
     * Sets product_line
     *
     * @param string|null $product_line The item product line
     *
     * @return self
     */
    public function setProductLine($product_line)
    {
        if (is_null($product_line)) {
            array_push($this->openAPINullablesSetToNull, 'product_line');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('product_line', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['product_line'] = $product_line;

        return $this;
    }

    /**
     * Gets commodity_code
     *
     * @return string|null
     */
    public function getCommodityCode()
    {
        return $this->container['commodity_code'];
    }

    /**
     * Sets commodity_code
     *
     * @param string|null $commodity_code The item commodity code
     *
     * @return self
     */
    public function setCommodityCode($commodity_code)
    {
        if (is_null($commodity_code)) {
            array_push($this->openAPINullablesSetToNull, 'commodity_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('commodity_code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['commodity_code'] = $commodity_code;

        return $this;
    }

    /**
     * Gets primary_supplier_id
     *
     * @return int|null
     */
    public function getPrimarySupplierId()
    {
        return $this->container['primary_supplier_id'];
    }

    /**
     * Sets primary_supplier_id
     *
     * @param int|null $primary_supplier_id The item primary supplier
     *
     * @return self
     */
    public function setPrimarySupplierId($primary_supplier_id)
    {
        if (is_null($primary_supplier_id)) {
            array_push($this->openAPINullablesSetToNull, 'primary_supplier_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('primary_supplier_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['primary_supplier_id'] = $primary_supplier_id;

        return $this;
    }

    /**
     * Gets price
     *
     * @return float|null
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param float|null $price The item default tax exclusive price
     *
     * @return self
     */
    public function setPrice($price)
    {
        if (is_null($price)) {
            throw new \InvalidArgumentException('non-nullable price cannot be null');
        }
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets price_inc_tax
     *
     * @return float|null
     */
    public function getPriceIncTax()
    {
        return $this->container['price_inc_tax'];
    }

    /**
     * Sets price_inc_tax
     *
     * @param float|null $price_inc_tax The item default tax inclusive price
     *
     * @return self
     */
    public function setPriceIncTax($price_inc_tax)
    {
        if (is_null($price_inc_tax)) {
            throw new \InvalidArgumentException('non-nullable price_inc_tax cannot be null');
        }
        $this->container['price_inc_tax'] = $price_inc_tax;

        return $this;
    }

    /**
     * Gets msrp
     *
     * @return float|null
     */
    public function getMsrp()
    {
        return $this->container['msrp'];
    }

    /**
     * Sets msrp
     *
     * @param float|null $msrp The item's manufacturer's suggested retail price
     *
     * @return self
     */
    public function setMsrp($msrp)
    {
        if (is_null($msrp)) {
            throw new \InvalidArgumentException('non-nullable msrp cannot be null');
        }
        $this->container['msrp'] = $msrp;

        return $this;
    }

    /**
     * Gets tax_rate_id
     *
     * @return int|null
     */
    public function getTaxRateId()
    {
        return $this->container['tax_rate_id'];
    }

    /**
     * Sets tax_rate_id
     *
     * @param int|null $tax_rate_id The item default tax rate
     *
     * @return self
     */
    public function setTaxRateId($tax_rate_id)
    {
        if (is_null($tax_rate_id)) {
            array_push($this->openAPINullablesSetToNull, 'tax_rate_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('tax_rate_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['tax_rate_id'] = $tax_rate_id;

        return $this;
    }

    /**
     * Gets unit_of_measure_id
     *
     * @return int|null
     */
    public function getUnitOfMeasureId()
    {
        return $this->container['unit_of_measure_id'];
    }

    /**
     * Sets unit_of_measure_id
     *
     * @param int|null $unit_of_measure_id The unit of measure
     *
     * @return self
     */
    public function setUnitOfMeasureId($unit_of_measure_id)
    {
        if (is_null($unit_of_measure_id)) {
            throw new \InvalidArgumentException('non-nullable unit_of_measure_id cannot be null');
        }
        $this->container['unit_of_measure_id'] = $unit_of_measure_id;

        return $this;
    }

    /**
     * Gets barcode_number
     *
     * @return string|null
     */
    public function getBarcodeNumber()
    {
        return $this->container['barcode_number'];
    }

    /**
     * Sets barcode_number
     *
     * @param string|null $barcode_number The barcode number
     *
     * @return self
     */
    public function setBarcodeNumber($barcode_number)
    {
        if (is_null($barcode_number)) {
            array_push($this->openAPINullablesSetToNull, 'barcode_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('barcode_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($barcode_number) && (mb_strlen($barcode_number) > 32)) {
            throw new \InvalidArgumentException('invalid length for $barcode_number when calling ItemMaster., must be smaller than or equal to 32.');
        }
        if (!is_null($barcode_number) && (mb_strlen($barcode_number) < 0)) {
            throw new \InvalidArgumentException('invalid length for $barcode_number when calling ItemMaster., must be bigger than or equal to 0.');
        }

        $this->container['barcode_number'] = $barcode_number;

        return $this;
    }

    /**
     * Gets active
     *
     * @return bool|null
     */
    public function getActive()
    {
        return $this->container['active'];
    }

    /**
     * Sets active
     *
     * @param bool|null $active Whether the item is active or not
     *
     * @return self
     */
    public function setActive($active)
    {
        if (is_null($active)) {
            throw new \InvalidArgumentException('non-nullable active cannot be null');
        }
        $this->container['active'] = $active;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return float|null
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param float|null $weight The weight of the item
     *
     * @return self
     */
    public function setWeight($weight)
    {
        if (is_null($weight)) {
            throw new \InvalidArgumentException('non-nullable weight cannot be null');
        }
        $this->container['weight'] = $weight;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


