<?php
/**
 * ItemLocationQuantities
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * ItemLocationQuantities Class Doc Comment
 *
 * @category Class
 * @description Important details about an item at a location
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ItemLocationQuantities implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ItemLocationQuantities';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'item_location_detail_id' => 'int',
        'location_id' => 'int',
        'location_name' => 'string',
        'quantity_available' => 'float',
        'quantity_on_hand' => 'float',
        'quantity_committed' => 'float',
        'quantity_on_order' => 'float',
        'quantity_offline' => 'float'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'item_location_detail_id' => 'int32',
        'location_id' => 'int32',
        'location_name' => null,
        'quantity_available' => 'double',
        'quantity_on_hand' => 'double',
        'quantity_committed' => 'double',
        'quantity_on_order' => 'double',
        'quantity_offline' => 'double'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'item_location_detail_id' => false,
        'location_id' => false,
        'location_name' => true,
        'quantity_available' => false,
        'quantity_on_hand' => false,
        'quantity_committed' => false,
        'quantity_on_order' => false,
        'quantity_offline' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'item_location_detail_id' => 'itemLocationDetailId',
        'location_id' => 'locationId',
        'location_name' => 'locationName',
        'quantity_available' => 'quantityAvailable',
        'quantity_on_hand' => 'quantityOnHand',
        'quantity_committed' => 'quantityCommitted',
        'quantity_on_order' => 'quantityOnOrder',
        'quantity_offline' => 'quantityOffline'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'item_location_detail_id' => 'setItemLocationDetailId',
        'location_id' => 'setLocationId',
        'location_name' => 'setLocationName',
        'quantity_available' => 'setQuantityAvailable',
        'quantity_on_hand' => 'setQuantityOnHand',
        'quantity_committed' => 'setQuantityCommitted',
        'quantity_on_order' => 'setQuantityOnOrder',
        'quantity_offline' => 'setQuantityOffline'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'item_location_detail_id' => 'getItemLocationDetailId',
        'location_id' => 'getLocationId',
        'location_name' => 'getLocationName',
        'quantity_available' => 'getQuantityAvailable',
        'quantity_on_hand' => 'getQuantityOnHand',
        'quantity_committed' => 'getQuantityCommitted',
        'quantity_on_order' => 'getQuantityOnOrder',
        'quantity_offline' => 'getQuantityOffline'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('item_location_detail_id', $data ?? [], null);
        $this->setIfExists('location_id', $data ?? [], null);
        $this->setIfExists('location_name', $data ?? [], null);
        $this->setIfExists('quantity_available', $data ?? [], null);
        $this->setIfExists('quantity_on_hand', $data ?? [], null);
        $this->setIfExists('quantity_committed', $data ?? [], null);
        $this->setIfExists('quantity_on_order', $data ?? [], null);
        $this->setIfExists('quantity_offline', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets item_location_detail_id
     *
     * @return int|null
     */
    public function getItemLocationDetailId()
    {
        return $this->container['item_location_detail_id'];
    }

    /**
     * Sets item_location_detail_id
     *
     * @param int|null $item_location_detail_id The location detail id
     *
     * @return self
     */
    public function setItemLocationDetailId($item_location_detail_id)
    {
        if (is_null($item_location_detail_id)) {
            throw new \InvalidArgumentException('non-nullable item_location_detail_id cannot be null');
        }
        $this->container['item_location_detail_id'] = $item_location_detail_id;

        return $this;
    }

    /**
     * Gets location_id
     *
     * @return int|null
     */
    public function getLocationId()
    {
        return $this->container['location_id'];
    }

    /**
     * Sets location_id
     *
     * @param int|null $location_id The location id
     *
     * @return self
     */
    public function setLocationId($location_id)
    {
        if (is_null($location_id)) {
            throw new \InvalidArgumentException('non-nullable location_id cannot be null');
        }
        $this->container['location_id'] = $location_id;

        return $this;
    }

    /**
     * Gets location_name
     *
     * @return string|null
     */
    public function getLocationName()
    {
        return $this->container['location_name'];
    }

    /**
     * Sets location_name
     *
     * @param string|null $location_name The location name
     *
     * @return self
     */
    public function setLocationName($location_name)
    {
        if (is_null($location_name)) {
            array_push($this->openAPINullablesSetToNull, 'location_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('location_name', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['location_name'] = $location_name;

        return $this;
    }

    /**
     * Gets quantity_available
     *
     * @return float|null
     */
    public function getQuantityAvailable()
    {
        return $this->container['quantity_available'];
    }

    /**
     * Sets quantity_available
     *
     * @param float|null $quantity_available The quantity available to sell
     *
     * @return self
     */
    public function setQuantityAvailable($quantity_available)
    {
        if (is_null($quantity_available)) {
            throw new \InvalidArgumentException('non-nullable quantity_available cannot be null');
        }
        $this->container['quantity_available'] = $quantity_available;

        return $this;
    }

    /**
     * Gets quantity_on_hand
     *
     * @return float|null
     */
    public function getQuantityOnHand()
    {
        return $this->container['quantity_on_hand'];
    }

    /**
     * Sets quantity_on_hand
     *
     * @param float|null $quantity_on_hand The quantity on hand (may be greater than the quantity avaiable)
     *
     * @return self
     */
    public function setQuantityOnHand($quantity_on_hand)
    {
        if (is_null($quantity_on_hand)) {
            throw new \InvalidArgumentException('non-nullable quantity_on_hand cannot be null');
        }
        $this->container['quantity_on_hand'] = $quantity_on_hand;

        return $this;
    }

    /**
     * Gets quantity_committed
     *
     * @return float|null
     */
    public function getQuantityCommitted()
    {
        return $this->container['quantity_committed'];
    }

    /**
     * Sets quantity_committed
     *
     * @param float|null $quantity_committed The quantity on customer orders
     *
     * @return self
     */
    public function setQuantityCommitted($quantity_committed)
    {
        if (is_null($quantity_committed)) {
            throw new \InvalidArgumentException('non-nullable quantity_committed cannot be null');
        }
        $this->container['quantity_committed'] = $quantity_committed;

        return $this;
    }

    /**
     * Gets quantity_on_order
     *
     * @return float|null
     */
    public function getQuantityOnOrder()
    {
        return $this->container['quantity_on_order'];
    }

    /**
     * Sets quantity_on_order
     *
     * @param float|null $quantity_on_order The quantity on purchase orders
     *
     * @return self
     */
    public function setQuantityOnOrder($quantity_on_order)
    {
        if (is_null($quantity_on_order)) {
            throw new \InvalidArgumentException('non-nullable quantity_on_order cannot be null');
        }
        $this->container['quantity_on_order'] = $quantity_on_order;

        return $this;
    }

    /**
     * Gets quantity_offline
     *
     * @return float|null
     */
    public function getQuantityOffline()
    {
        return $this->container['quantity_offline'];
    }

    /**
     * Sets quantity_offline
     *
     * @param float|null $quantity_offline The quantity in quarantine
     *
     * @return self
     */
    public function setQuantityOffline($quantity_offline)
    {
        if (is_null($quantity_offline)) {
            throw new \InvalidArgumentException('non-nullable quantity_offline cannot be null');
        }
        $this->container['quantity_offline'] = $quantity_offline;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


