<?php
/**
 * ItemLocationDetail
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * ItemLocationDetail Class Doc Comment
 *
 * @category Class
 * @description The details of an item at a specific location
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ItemLocationDetail implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ItemLocationDetail';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'location_id' => 'int',
        'item_master_id' => 'int',
        'item_master' => '\Opsuite2\Model\ItemMaster',
        'store_sku' => 'string',
        'store_description' => 'string',
        'quantity_on_hand' => 'float',
        'quantity_available' => 'float',
        'quantity_on_order' => 'float',
        'cost' => 'float',
        'price' => 'float',
        'price_a' => 'float',
        'price_b' => 'float',
        'price_c' => 'float',
        'sale_price' => 'float',
        'price_inc_tax' => 'float',
        'price_a_inc_tax' => 'float',
        'price_b_inc_tax' => 'float',
        'price_c_inc_tax' => 'float',
        'sale_price_inc_tax' => 'float',
        'sale_start_date' => '\DateTime',
        'sale_end_date' => '\DateTime',
        'tax_rate_id' => 'int',
        'active' => 'bool',
        'web_item' => 'bool',
        'item_type_id' => 'int',
        'max_restock_level' => 'float',
        'min_reorder_point' => 'float',
        'do_not_sell' => 'bool',
        'commission_percent_profit' => 'float',
        'last_sold' => '\DateTime',
        'last_received' => '\DateTime',
        'last_updated' => '\DateTime',
        'last_in_stocktake' => '\DateTime',
        'last_counted' => '\DateTime'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'int32',
        'location_id' => 'int32',
        'item_master_id' => 'int32',
        'item_master' => null,
        'store_sku' => null,
        'store_description' => null,
        'quantity_on_hand' => 'float',
        'quantity_available' => 'float',
        'quantity_on_order' => 'float',
        'cost' => 'double',
        'price' => 'double',
        'price_a' => 'double',
        'price_b' => 'double',
        'price_c' => 'double',
        'sale_price' => 'double',
        'price_inc_tax' => 'double',
        'price_a_inc_tax' => 'double',
        'price_b_inc_tax' => 'double',
        'price_c_inc_tax' => 'double',
        'sale_price_inc_tax' => 'double',
        'sale_start_date' => 'date-time',
        'sale_end_date' => 'date-time',
        'tax_rate_id' => 'int32',
        'active' => null,
        'web_item' => null,
        'item_type_id' => 'int32',
        'max_restock_level' => 'double',
        'min_reorder_point' => 'double',
        'do_not_sell' => null,
        'commission_percent_profit' => 'double',
        'last_sold' => 'date-time',
        'last_received' => 'date-time',
        'last_updated' => 'date-time',
        'last_in_stocktake' => 'date-time',
        'last_counted' => 'date-time'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'location_id' => false,
        'item_master_id' => false,
        'item_master' => false,
        'store_sku' => false,
        'store_description' => false,
        'quantity_on_hand' => false,
        'quantity_available' => false,
        'quantity_on_order' => false,
        'cost' => false,
        'price' => false,
        'price_a' => false,
        'price_b' => false,
        'price_c' => false,
        'sale_price' => false,
        'price_inc_tax' => false,
        'price_a_inc_tax' => false,
        'price_b_inc_tax' => false,
        'price_c_inc_tax' => false,
        'sale_price_inc_tax' => false,
        'sale_start_date' => true,
        'sale_end_date' => true,
        'tax_rate_id' => false,
        'active' => false,
        'web_item' => false,
        'item_type_id' => false,
        'max_restock_level' => false,
        'min_reorder_point' => false,
        'do_not_sell' => false,
        'commission_percent_profit' => false,
        'last_sold' => true,
        'last_received' => true,
        'last_updated' => false,
        'last_in_stocktake' => true,
        'last_counted' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'location_id' => 'locationId',
        'item_master_id' => 'itemMasterId',
        'item_master' => 'itemMaster',
        'store_sku' => 'storeSku',
        'store_description' => 'storeDescription',
        'quantity_on_hand' => 'quantityOnHand',
        'quantity_available' => 'quantityAvailable',
        'quantity_on_order' => 'quantityOnOrder',
        'cost' => 'cost',
        'price' => 'price',
        'price_a' => 'priceA',
        'price_b' => 'priceB',
        'price_c' => 'priceC',
        'sale_price' => 'salePrice',
        'price_inc_tax' => 'priceIncTax',
        'price_a_inc_tax' => 'priceAIncTax',
        'price_b_inc_tax' => 'priceBIncTax',
        'price_c_inc_tax' => 'priceCIncTax',
        'sale_price_inc_tax' => 'salePriceIncTax',
        'sale_start_date' => 'saleStartDate',
        'sale_end_date' => 'saleEndDate',
        'tax_rate_id' => 'taxRateId',
        'active' => 'active',
        'web_item' => 'webItem',
        'item_type_id' => 'itemTypeId',
        'max_restock_level' => 'maxRestockLevel',
        'min_reorder_point' => 'minReorderPoint',
        'do_not_sell' => 'doNotSell',
        'commission_percent_profit' => 'commissionPercentProfit',
        'last_sold' => 'lastSold',
        'last_received' => 'lastReceived',
        'last_updated' => 'lastUpdated',
        'last_in_stocktake' => 'lastInStocktake',
        'last_counted' => 'lastCounted'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'location_id' => 'setLocationId',
        'item_master_id' => 'setItemMasterId',
        'item_master' => 'setItemMaster',
        'store_sku' => 'setStoreSku',
        'store_description' => 'setStoreDescription',
        'quantity_on_hand' => 'setQuantityOnHand',
        'quantity_available' => 'setQuantityAvailable',
        'quantity_on_order' => 'setQuantityOnOrder',
        'cost' => 'setCost',
        'price' => 'setPrice',
        'price_a' => 'setPriceA',
        'price_b' => 'setPriceB',
        'price_c' => 'setPriceC',
        'sale_price' => 'setSalePrice',
        'price_inc_tax' => 'setPriceIncTax',
        'price_a_inc_tax' => 'setPriceAIncTax',
        'price_b_inc_tax' => 'setPriceBIncTax',
        'price_c_inc_tax' => 'setPriceCIncTax',
        'sale_price_inc_tax' => 'setSalePriceIncTax',
        'sale_start_date' => 'setSaleStartDate',
        'sale_end_date' => 'setSaleEndDate',
        'tax_rate_id' => 'setTaxRateId',
        'active' => 'setActive',
        'web_item' => 'setWebItem',
        'item_type_id' => 'setItemTypeId',
        'max_restock_level' => 'setMaxRestockLevel',
        'min_reorder_point' => 'setMinReorderPoint',
        'do_not_sell' => 'setDoNotSell',
        'commission_percent_profit' => 'setCommissionPercentProfit',
        'last_sold' => 'setLastSold',
        'last_received' => 'setLastReceived',
        'last_updated' => 'setLastUpdated',
        'last_in_stocktake' => 'setLastInStocktake',
        'last_counted' => 'setLastCounted'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'location_id' => 'getLocationId',
        'item_master_id' => 'getItemMasterId',
        'item_master' => 'getItemMaster',
        'store_sku' => 'getStoreSku',
        'store_description' => 'getStoreDescription',
        'quantity_on_hand' => 'getQuantityOnHand',
        'quantity_available' => 'getQuantityAvailable',
        'quantity_on_order' => 'getQuantityOnOrder',
        'cost' => 'getCost',
        'price' => 'getPrice',
        'price_a' => 'getPriceA',
        'price_b' => 'getPriceB',
        'price_c' => 'getPriceC',
        'sale_price' => 'getSalePrice',
        'price_inc_tax' => 'getPriceIncTax',
        'price_a_inc_tax' => 'getPriceAIncTax',
        'price_b_inc_tax' => 'getPriceBIncTax',
        'price_c_inc_tax' => 'getPriceCIncTax',
        'sale_price_inc_tax' => 'getSalePriceIncTax',
        'sale_start_date' => 'getSaleStartDate',
        'sale_end_date' => 'getSaleEndDate',
        'tax_rate_id' => 'getTaxRateId',
        'active' => 'getActive',
        'web_item' => 'getWebItem',
        'item_type_id' => 'getItemTypeId',
        'max_restock_level' => 'getMaxRestockLevel',
        'min_reorder_point' => 'getMinReorderPoint',
        'do_not_sell' => 'getDoNotSell',
        'commission_percent_profit' => 'getCommissionPercentProfit',
        'last_sold' => 'getLastSold',
        'last_received' => 'getLastReceived',
        'last_updated' => 'getLastUpdated',
        'last_in_stocktake' => 'getLastInStocktake',
        'last_counted' => 'getLastCounted'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('location_id', $data ?? [], null);
        $this->setIfExists('item_master_id', $data ?? [], null);
        $this->setIfExists('item_master', $data ?? [], null);
        $this->setIfExists('store_sku', $data ?? [], null);
        $this->setIfExists('store_description', $data ?? [], null);
        $this->setIfExists('quantity_on_hand', $data ?? [], null);
        $this->setIfExists('quantity_available', $data ?? [], null);
        $this->setIfExists('quantity_on_order', $data ?? [], null);
        $this->setIfExists('cost', $data ?? [], null);
        $this->setIfExists('price', $data ?? [], null);
        $this->setIfExists('price_a', $data ?? [], null);
        $this->setIfExists('price_b', $data ?? [], null);
        $this->setIfExists('price_c', $data ?? [], null);
        $this->setIfExists('sale_price', $data ?? [], null);
        $this->setIfExists('price_inc_tax', $data ?? [], null);
        $this->setIfExists('price_a_inc_tax', $data ?? [], null);
        $this->setIfExists('price_b_inc_tax', $data ?? [], null);
        $this->setIfExists('price_c_inc_tax', $data ?? [], null);
        $this->setIfExists('sale_price_inc_tax', $data ?? [], null);
        $this->setIfExists('sale_start_date', $data ?? [], null);
        $this->setIfExists('sale_end_date', $data ?? [], null);
        $this->setIfExists('tax_rate_id', $data ?? [], null);
        $this->setIfExists('active', $data ?? [], null);
        $this->setIfExists('web_item', $data ?? [], null);
        $this->setIfExists('item_type_id', $data ?? [], null);
        $this->setIfExists('max_restock_level', $data ?? [], null);
        $this->setIfExists('min_reorder_point', $data ?? [], null);
        $this->setIfExists('do_not_sell', $data ?? [], false);
        $this->setIfExists('commission_percent_profit', $data ?? [], null);
        $this->setIfExists('last_sold', $data ?? [], null);
        $this->setIfExists('last_received', $data ?? [], null);
        $this->setIfExists('last_updated', $data ?? [], null);
        $this->setIfExists('last_in_stocktake', $data ?? [], null);
        $this->setIfExists('last_counted', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['location_id'] === null) {
            $invalidProperties[] = "'location_id' can't be null";
        }
        if ($this->container['item_master_id'] === null) {
            $invalidProperties[] = "'item_master_id' can't be null";
        }
        if ($this->container['store_sku'] === null) {
            $invalidProperties[] = "'store_sku' can't be null";
        }
        if ((mb_strlen($this->container['store_sku']) > 32)) {
            $invalidProperties[] = "invalid value for 'store_sku', the character length must be smaller than or equal to 32.";
        }

        if ((mb_strlen($this->container['store_sku']) < 0)) {
            $invalidProperties[] = "invalid value for 'store_sku', the character length must be bigger than or equal to 0.";
        }

        if ($this->container['store_description'] === null) {
            $invalidProperties[] = "'store_description' can't be null";
        }
        if ((mb_strlen($this->container['store_description']) > 128)) {
            $invalidProperties[] = "invalid value for 'store_description', the character length must be smaller than or equal to 128.";
        }

        if ((mb_strlen($this->container['store_description']) < 0)) {
            $invalidProperties[] = "invalid value for 'store_description', the character length must be bigger than or equal to 0.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id The item location detail id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets location_id
     *
     * @return int
     */
    public function getLocationId()
    {
        return $this->container['location_id'];
    }

    /**
     * Sets location_id
     *
     * @param int $location_id The location id
     *
     * @return self
     */
    public function setLocationId($location_id)
    {
        if (is_null($location_id)) {
            throw new \InvalidArgumentException('non-nullable location_id cannot be null');
        }
        $this->container['location_id'] = $location_id;

        return $this;
    }

    /**
     * Gets item_master_id
     *
     * @return int
     */
    public function getItemMasterId()
    {
        return $this->container['item_master_id'];
    }

    /**
     * Sets item_master_id
     *
     * @param int $item_master_id The item master id
     *
     * @return self
     */
    public function setItemMasterId($item_master_id)
    {
        if (is_null($item_master_id)) {
            throw new \InvalidArgumentException('non-nullable item_master_id cannot be null');
        }
        $this->container['item_master_id'] = $item_master_id;

        return $this;
    }

    /**
     * Gets item_master
     *
     * @return \Opsuite2\Model\ItemMaster|null
     */
    public function getItemMaster()
    {
        return $this->container['item_master'];
    }

    /**
     * Sets item_master
     *
     * @param \Opsuite2\Model\ItemMaster|null $item_master item_master
     *
     * @return self
     */
    public function setItemMaster($item_master)
    {
        if (is_null($item_master)) {
            throw new \InvalidArgumentException('non-nullable item_master cannot be null');
        }
        $this->container['item_master'] = $item_master;

        return $this;
    }

    /**
     * Gets store_sku
     *
     * @return string
     */
    public function getStoreSku()
    {
        return $this->container['store_sku'];
    }

    /**
     * Sets store_sku
     *
     * @param string $store_sku The item SKU
     *
     * @return self
     */
    public function setStoreSku($store_sku)
    {
        if (is_null($store_sku)) {
            throw new \InvalidArgumentException('non-nullable store_sku cannot be null');
        }
        if ((mb_strlen($store_sku) > 32)) {
            throw new \InvalidArgumentException('invalid length for $store_sku when calling ItemLocationDetail., must be smaller than or equal to 32.');
        }
        if ((mb_strlen($store_sku) < 0)) {
            throw new \InvalidArgumentException('invalid length for $store_sku when calling ItemLocationDetail., must be bigger than or equal to 0.');
        }

        $this->container['store_sku'] = $store_sku;

        return $this;
    }

    /**
     * Gets store_description
     *
     * @return string
     */
    public function getStoreDescription()
    {
        return $this->container['store_description'];
    }

    /**
     * Sets store_description
     *
     * @param string $store_description The item description
     *
     * @return self
     */
    public function setStoreDescription($store_description)
    {
        if (is_null($store_description)) {
            throw new \InvalidArgumentException('non-nullable store_description cannot be null');
        }
        if ((mb_strlen($store_description) > 128)) {
            throw new \InvalidArgumentException('invalid length for $store_description when calling ItemLocationDetail., must be smaller than or equal to 128.');
        }
        if ((mb_strlen($store_description) < 0)) {
            throw new \InvalidArgumentException('invalid length for $store_description when calling ItemLocationDetail., must be bigger than or equal to 0.');
        }

        $this->container['store_description'] = $store_description;

        return $this;
    }

    /**
     * Gets quantity_on_hand
     *
     * @return float|null
     */
    public function getQuantityOnHand()
    {
        return $this->container['quantity_on_hand'];
    }

    /**
     * Sets quantity_on_hand
     *
     * @param float|null $quantity_on_hand The current quantity on hand at the location
     *
     * @return self
     */
    public function setQuantityOnHand($quantity_on_hand)
    {
        if (is_null($quantity_on_hand)) {
            throw new \InvalidArgumentException('non-nullable quantity_on_hand cannot be null');
        }
        $this->container['quantity_on_hand'] = $quantity_on_hand;

        return $this;
    }

    /**
     * Gets quantity_available
     *
     * @return float|null
     */
    public function getQuantityAvailable()
    {
        return $this->container['quantity_available'];
    }

    /**
     * Sets quantity_available
     *
     * @param float|null $quantity_available The current quantity available at the location (on hand - committed - offline)
     *
     * @return self
     */
    public function setQuantityAvailable($quantity_available)
    {
        if (is_null($quantity_available)) {
            throw new \InvalidArgumentException('non-nullable quantity_available cannot be null');
        }
        $this->container['quantity_available'] = $quantity_available;

        return $this;
    }

    /**
     * Gets quantity_on_order
     *
     * @return float|null
     */
    public function getQuantityOnOrder()
    {
        return $this->container['quantity_on_order'];
    }

    /**
     * Sets quantity_on_order
     *
     * @param float|null $quantity_on_order The current quantity on order at the location
     *
     * @return self
     */
    public function setQuantityOnOrder($quantity_on_order)
    {
        if (is_null($quantity_on_order)) {
            throw new \InvalidArgumentException('non-nullable quantity_on_order cannot be null');
        }
        $this->container['quantity_on_order'] = $quantity_on_order;

        return $this;
    }

    /**
     * Gets cost
     *
     * @return float|null
     */
    public function getCost()
    {
        return $this->container['cost'];
    }

    /**
     * Sets cost
     *
     * @param float|null $cost The item cost
     *
     * @return self
     */
    public function setCost($cost)
    {
        if (is_null($cost)) {
            throw new \InvalidArgumentException('non-nullable cost cannot be null');
        }
        $this->container['cost'] = $cost;

        return $this;
    }

    /**
     * Gets price
     *
     * @return float|null
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param float|null $price The item price ex vat - only used if the location is tax exclusive
     *
     * @return self
     */
    public function setPrice($price)
    {
        if (is_null($price)) {
            throw new \InvalidArgumentException('non-nullable price cannot be null');
        }
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets price_a
     *
     * @return float|null
     */
    public function getPriceA()
    {
        return $this->container['price_a'];
    }

    /**
     * Sets price_a
     *
     * @param float|null $price_a The item price A ex vat - only used if the location is tax exclusive
     *
     * @return self
     */
    public function setPriceA($price_a)
    {
        if (is_null($price_a)) {
            throw new \InvalidArgumentException('non-nullable price_a cannot be null');
        }
        $this->container['price_a'] = $price_a;

        return $this;
    }

    /**
     * Gets price_b
     *
     * @return float|null
     */
    public function getPriceB()
    {
        return $this->container['price_b'];
    }

    /**
     * Sets price_b
     *
     * @param float|null $price_b The item price B ex vat - only used if the location is tax exclusive
     *
     * @return self
     */
    public function setPriceB($price_b)
    {
        if (is_null($price_b)) {
            throw new \InvalidArgumentException('non-nullable price_b cannot be null');
        }
        $this->container['price_b'] = $price_b;

        return $this;
    }

    /**
     * Gets price_c
     *
     * @return float|null
     */
    public function getPriceC()
    {
        return $this->container['price_c'];
    }

    /**
     * Sets price_c
     *
     * @param float|null $price_c The item price C ex vat - only used if the location is tax exclusive
     *
     * @return self
     */
    public function setPriceC($price_c)
    {
        if (is_null($price_c)) {
            throw new \InvalidArgumentException('non-nullable price_c cannot be null');
        }
        $this->container['price_c'] = $price_c;

        return $this;
    }

    /**
     * Gets sale_price
     *
     * @return float|null
     */
    public function getSalePrice()
    {
        return $this->container['sale_price'];
    }

    /**
     * Sets sale_price
     *
     * @param float|null $sale_price The item sale price ex vat - only used if the location is tax exclusive between the sale start and end dates
     *
     * @return self
     */
    public function setSalePrice($sale_price)
    {
        if (is_null($sale_price)) {
            throw new \InvalidArgumentException('non-nullable sale_price cannot be null');
        }
        $this->container['sale_price'] = $sale_price;

        return $this;
    }

    /**
     * Gets price_inc_tax
     *
     * @return float|null
     */
    public function getPriceIncTax()
    {
        return $this->container['price_inc_tax'];
    }

    /**
     * Sets price_inc_tax
     *
     * @param float|null $price_inc_tax The item price inc vat - only used if the location is tax inclusive
     *
     * @return self
     */
    public function setPriceIncTax($price_inc_tax)
    {
        if (is_null($price_inc_tax)) {
            throw new \InvalidArgumentException('non-nullable price_inc_tax cannot be null');
        }
        $this->container['price_inc_tax'] = $price_inc_tax;

        return $this;
    }

    /**
     * Gets price_a_inc_tax
     *
     * @return float|null
     */
    public function getPriceAIncTax()
    {
        return $this->container['price_a_inc_tax'];
    }

    /**
     * Sets price_a_inc_tax
     *
     * @param float|null $price_a_inc_tax The item price A inc vat - only used if the location is tax inclusive
     *
     * @return self
     */
    public function setPriceAIncTax($price_a_inc_tax)
    {
        if (is_null($price_a_inc_tax)) {
            throw new \InvalidArgumentException('non-nullable price_a_inc_tax cannot be null');
        }
        $this->container['price_a_inc_tax'] = $price_a_inc_tax;

        return $this;
    }

    /**
     * Gets price_b_inc_tax
     *
     * @return float|null
     */
    public function getPriceBIncTax()
    {
        return $this->container['price_b_inc_tax'];
    }

    /**
     * Sets price_b_inc_tax
     *
     * @param float|null $price_b_inc_tax The item price B inc vat - only used if the location is tax inclusive
     *
     * @return self
     */
    public function setPriceBIncTax($price_b_inc_tax)
    {
        if (is_null($price_b_inc_tax)) {
            throw new \InvalidArgumentException('non-nullable price_b_inc_tax cannot be null');
        }
        $this->container['price_b_inc_tax'] = $price_b_inc_tax;

        return $this;
    }

    /**
     * Gets price_c_inc_tax
     *
     * @return float|null
     */
    public function getPriceCIncTax()
    {
        return $this->container['price_c_inc_tax'];
    }

    /**
     * Sets price_c_inc_tax
     *
     * @param float|null $price_c_inc_tax The item price C inc vat - only used if the location is tax inclusive
     *
     * @return self
     */
    public function setPriceCIncTax($price_c_inc_tax)
    {
        if (is_null($price_c_inc_tax)) {
            throw new \InvalidArgumentException('non-nullable price_c_inc_tax cannot be null');
        }
        $this->container['price_c_inc_tax'] = $price_c_inc_tax;

        return $this;
    }

    /**
     * Gets sale_price_inc_tax
     *
     * @return float|null
     */
    public function getSalePriceIncTax()
    {
        return $this->container['sale_price_inc_tax'];
    }

    /**
     * Sets sale_price_inc_tax
     *
     * @param float|null $sale_price_inc_tax The item sale price inc vat - only used if the location is tax inclusive between the sale start and end dates
     *
     * @return self
     */
    public function setSalePriceIncTax($sale_price_inc_tax)
    {
        if (is_null($sale_price_inc_tax)) {
            throw new \InvalidArgumentException('non-nullable sale_price_inc_tax cannot be null');
        }
        $this->container['sale_price_inc_tax'] = $sale_price_inc_tax;

        return $this;
    }

    /**
     * Gets sale_start_date
     *
     * @return \DateTime|null
     */
    public function getSaleStartDate()
    {
        return $this->container['sale_start_date'];
    }

    /**
     * Sets sale_start_date
     *
     * @param \DateTime|null $sale_start_date If set, the date the item changes to the sale price
     *
     * @return self
     */
    public function setSaleStartDate($sale_start_date)
    {
        if (is_null($sale_start_date)) {
            array_push($this->openAPINullablesSetToNull, 'sale_start_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('sale_start_date', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['sale_start_date'] = $sale_start_date;

        return $this;
    }

    /**
     * Gets sale_end_date
     *
     * @return \DateTime|null
     */
    public function getSaleEndDate()
    {
        return $this->container['sale_end_date'];
    }

    /**
     * Sets sale_end_date
     *
     * @param \DateTime|null $sale_end_date If set, the date the item changes back to the normal price
     *
     * @return self
     */
    public function setSaleEndDate($sale_end_date)
    {
        if (is_null($sale_end_date)) {
            array_push($this->openAPINullablesSetToNull, 'sale_end_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('sale_end_date', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['sale_end_date'] = $sale_end_date;

        return $this;
    }

    /**
     * Gets tax_rate_id
     *
     * @return int|null
     */
    public function getTaxRateId()
    {
        return $this->container['tax_rate_id'];
    }

    /**
     * Sets tax_rate_id
     *
     * @param int|null $tax_rate_id The id of the tax applied to the item
     *
     * @return self
     */
    public function setTaxRateId($tax_rate_id)
    {
        if (is_null($tax_rate_id)) {
            throw new \InvalidArgumentException('non-nullable tax_rate_id cannot be null');
        }
        $this->container['tax_rate_id'] = $tax_rate_id;

        return $this;
    }

    /**
     * Gets active
     *
     * @return bool|null
     */
    public function getActive()
    {
        return $this->container['active'];
    }

    /**
     * Sets active
     *
     * @param bool|null $active Whether the item is active or not
     *
     * @return self
     */
    public function setActive($active)
    {
        if (is_null($active)) {
            throw new \InvalidArgumentException('non-nullable active cannot be null');
        }
        $this->container['active'] = $active;

        return $this;
    }

    /**
     * Gets web_item
     *
     * @return bool|null
     */
    public function getWebItem()
    {
        return $this->container['web_item'];
    }

    /**
     * Sets web_item
     *
     * @param bool|null $web_item Whether the item is available on the web or not
     *
     * @return self
     */
    public function setWebItem($web_item)
    {
        if (is_null($web_item)) {
            throw new \InvalidArgumentException('non-nullable web_item cannot be null');
        }
        $this->container['web_item'] = $web_item;

        return $this;
    }

    /**
     * Gets item_type_id
     *
     * @return int|null
     */
    public function getItemTypeId()
    {
        return $this->container['item_type_id'];
    }

    /**
     * Sets item_type_id
     *
     * @param int|null $item_type_id The item type:<br />  0 Standard<br />  6 Weighed<br />  7 Non-Inventory<br />  9 Voucher<br />  10 Scale<br />  11 OpSuite Kit<br />  12 Non-Inventory Scale<br />
     *
     * @return self
     */
    public function setItemTypeId($item_type_id)
    {
        if (is_null($item_type_id)) {
            throw new \InvalidArgumentException('non-nullable item_type_id cannot be null');
        }
        $this->container['item_type_id'] = $item_type_id;

        return $this;
    }

    /**
     * Gets max_restock_level
     *
     * @return float|null
     */
    public function getMaxRestockLevel()
    {
        return $this->container['max_restock_level'];
    }

    /**
     * Sets max_restock_level
     *
     * @param float|null $max_restock_level The maximum quantity of the item that can be stocked at this location
     *
     * @return self
     */
    public function setMaxRestockLevel($max_restock_level)
    {
        if (is_null($max_restock_level)) {
            throw new \InvalidArgumentException('non-nullable max_restock_level cannot be null');
        }
        $this->container['max_restock_level'] = $max_restock_level;

        return $this;
    }

    /**
     * Gets min_reorder_point
     *
     * @return float|null
     */
    public function getMinReorderPoint()
    {
        return $this->container['min_reorder_point'];
    }

    /**
     * Sets min_reorder_point
     *
     * @param float|null $min_reorder_point The minimum quantity of the item that should be stocked at this location.  If stock falls below this level then it should be placed on a purchase order.
     *
     * @return self
     */
    public function setMinReorderPoint($min_reorder_point)
    {
        if (is_null($min_reorder_point)) {
            throw new \InvalidArgumentException('non-nullable min_reorder_point cannot be null');
        }
        $this->container['min_reorder_point'] = $min_reorder_point;

        return $this;
    }

    /**
     * Gets do_not_sell
     *
     * @return bool|null
     */
    public function getDoNotSell()
    {
        return $this->container['do_not_sell'];
    }

    /**
     * Sets do_not_sell
     *
     * @param bool|null $do_not_sell Whether the item can be sold or not
     *
     * @return self
     */
    public function setDoNotSell($do_not_sell)
    {
        if (is_null($do_not_sell)) {
            throw new \InvalidArgumentException('non-nullable do_not_sell cannot be null');
        }
        $this->container['do_not_sell'] = $do_not_sell;

        return $this;
    }

    /**
     * Gets commission_percent_profit
     *
     * @return float|null
     */
    public function getCommissionPercentProfit()
    {
        return $this->container['commission_percent_profit'];
    }

    /**
     * Sets commission_percent_profit
     *
     * @param float|null $commission_percent_profit The commission percentage on an item (not used)
     *
     * @return self
     */
    public function setCommissionPercentProfit($commission_percent_profit)
    {
        if (is_null($commission_percent_profit)) {
            throw new \InvalidArgumentException('non-nullable commission_percent_profit cannot be null');
        }
        $this->container['commission_percent_profit'] = $commission_percent_profit;

        return $this;
    }

    /**
     * Gets last_sold
     *
     * @return \DateTime|null
     */
    public function getLastSold()
    {
        return $this->container['last_sold'];
    }

    /**
     * Sets last_sold
     *
     * @param \DateTime|null $last_sold When the item was last sold at this location
     *
     * @return self
     */
    public function setLastSold($last_sold)
    {
        if (is_null($last_sold)) {
            array_push($this->openAPINullablesSetToNull, 'last_sold');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('last_sold', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['last_sold'] = $last_sold;

        return $this;
    }

    /**
     * Gets last_received
     *
     * @return \DateTime|null
     */
    public function getLastReceived()
    {
        return $this->container['last_received'];
    }

    /**
     * Sets last_received
     *
     * @param \DateTime|null $last_received When the item was last received at this location
     *
     * @return self
     */
    public function setLastReceived($last_received)
    {
        if (is_null($last_received)) {
            array_push($this->openAPINullablesSetToNull, 'last_received');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('last_received', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['last_received'] = $last_received;

        return $this;
    }

    /**
     * Gets last_updated
     *
     * @return \DateTime|null
     */
    public function getLastUpdated()
    {
        return $this->container['last_updated'];
    }

    /**
     * Sets last_updated
     *
     * @param \DateTime|null $last_updated When the item was last updated at this location
     *
     * @return self
     */
    public function setLastUpdated($last_updated)
    {
        if (is_null($last_updated)) {
            throw new \InvalidArgumentException('non-nullable last_updated cannot be null');
        }
        $this->container['last_updated'] = $last_updated;

        return $this;
    }

    /**
     * Gets last_in_stocktake
     *
     * @return \DateTime|null
     */
    public function getLastInStocktake()
    {
        return $this->container['last_in_stocktake'];
    }

    /**
     * Sets last_in_stocktake
     *
     * @param \DateTime|null $last_in_stocktake When the item was last in a stock take at this location
     *
     * @return self
     */
    public function setLastInStocktake($last_in_stocktake)
    {
        if (is_null($last_in_stocktake)) {
            array_push($this->openAPINullablesSetToNull, 'last_in_stocktake');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('last_in_stocktake', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['last_in_stocktake'] = $last_in_stocktake;

        return $this;
    }

    /**
     * Gets last_counted
     *
     * @return \DateTime|null
     */
    public function getLastCounted()
    {
        return $this->container['last_counted'];
    }

    /**
     * Sets last_counted
     *
     * @param \DateTime|null $last_counted When the item was last counted in a stock take at this location
     *
     * @return self
     */
    public function setLastCounted($last_counted)
    {
        if (is_null($last_counted)) {
            array_push($this->openAPINullablesSetToNull, 'last_counted');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('last_counted', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['last_counted'] = $last_counted;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


