<?php
/**
 * ItemDetails
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * ItemDetails Class Doc Comment
 *
 * @category Class
 * @description All the details of an item
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ItemDetails implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ItemDetails';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'item_master_id' => 'int',
        'active' => 'bool',
        'aliases' => 'string[]',
        'barcode_format' => 'int',
        'barcode_number' => 'string',
        'category_id' => 'int',
        'commodity_code' => 'string',
        'default_cost' => 'float',
        'department_id' => 'int',
        'depth' => 'float',
        'description' => 'string',
        'do_not_order' => 'bool',
        'extended_description' => 'string',
        'height' => 'float',
        'item_type_id' => 'int',
        'last_updated' => '\DateTime',
        'manufacturer' => 'string',
        'msrp' => 'float',
        'notes' => 'string',
        'default_price' => 'float',
        'default_price_inc_tax' => 'float',
        'primary_vendor_cost' => 'float',
        'primary_vendor_id' => 'int',
        'primary_vendor_master_pack_quantity' => 'float',
        'primary_vendor_minimum_order' => 'float',
        'primary_vendor_re_order_number' => 'string',
        'primary_vendor_tax_rate' => 'float',
        'product_line' => 'string',
        'sku' => 'string',
        'sub_description1' => 'string',
        'sub_description2' => 'string',
        'sub_description3' => 'string',
        'tag_along_item_skus' => 'string[]',
        'taxable' => 'bool',
        'taxable_group_id' => 'int',
        'unit_of_measure_id' => 'int',
        'web_content' => '\Opsuite2\Model\WebContent',
        'web_item' => 'bool',
        'web_links' => '\Opsuite2\Model\WebLink[]',
        'weight' => 'float',
        'width' => 'float',
        'has_question_set' => 'bool',
        'matrix_sku' => 'string',
        'location_quantities' => '\Opsuite2\Model\ItemLocationQuantities[]',
        'location_details' => '\Opsuite2\Model\ItemLocationDetails[]',
        'kit_component_details' => '\Opsuite2\Model\KitComponent[]',
        'item_messages' => '\Opsuite2\Model\ItemMessage[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'item_master_id' => 'int32',
        'active' => null,
        'aliases' => null,
        'barcode_format' => 'int32',
        'barcode_number' => null,
        'category_id' => 'int32',
        'commodity_code' => null,
        'default_cost' => 'double',
        'department_id' => 'int32',
        'depth' => 'double',
        'description' => null,
        'do_not_order' => null,
        'extended_description' => null,
        'height' => 'double',
        'item_type_id' => 'int32',
        'last_updated' => 'date-time',
        'manufacturer' => null,
        'msrp' => 'double',
        'notes' => null,
        'default_price' => 'double',
        'default_price_inc_tax' => 'double',
        'primary_vendor_cost' => 'double',
        'primary_vendor_id' => 'int32',
        'primary_vendor_master_pack_quantity' => 'double',
        'primary_vendor_minimum_order' => 'double',
        'primary_vendor_re_order_number' => null,
        'primary_vendor_tax_rate' => 'double',
        'product_line' => null,
        'sku' => null,
        'sub_description1' => null,
        'sub_description2' => null,
        'sub_description3' => null,
        'tag_along_item_skus' => null,
        'taxable' => null,
        'taxable_group_id' => 'int32',
        'unit_of_measure_id' => 'int32',
        'web_content' => null,
        'web_item' => null,
        'web_links' => null,
        'weight' => 'double',
        'width' => 'double',
        'has_question_set' => null,
        'matrix_sku' => null,
        'location_quantities' => null,
        'location_details' => null,
        'kit_component_details' => null,
        'item_messages' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'item_master_id' => false,
        'active' => false,
        'aliases' => true,
        'barcode_format' => false,
        'barcode_number' => true,
        'category_id' => false,
        'commodity_code' => true,
        'default_cost' => false,
        'department_id' => false,
        'depth' => true,
        'description' => true,
        'do_not_order' => false,
        'extended_description' => true,
        'height' => true,
        'item_type_id' => false,
        'last_updated' => false,
        'manufacturer' => true,
        'msrp' => false,
        'notes' => true,
        'default_price' => false,
        'default_price_inc_tax' => false,
        'primary_vendor_cost' => true,
        'primary_vendor_id' => true,
        'primary_vendor_master_pack_quantity' => true,
        'primary_vendor_minimum_order' => true,
        'primary_vendor_re_order_number' => true,
        'primary_vendor_tax_rate' => true,
        'product_line' => true,
        'sku' => true,
        'sub_description1' => true,
        'sub_description2' => true,
        'sub_description3' => true,
        'tag_along_item_skus' => true,
        'taxable' => false,
        'taxable_group_id' => true,
        'unit_of_measure_id' => false,
        'web_content' => false,
        'web_item' => false,
        'web_links' => true,
        'weight' => false,
        'width' => true,
        'has_question_set' => false,
        'matrix_sku' => true,
        'location_quantities' => true,
        'location_details' => true,
        'kit_component_details' => true,
        'item_messages' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'item_master_id' => 'itemMasterId',
        'active' => 'active',
        'aliases' => 'aliases',
        'barcode_format' => 'barcodeFormat',
        'barcode_number' => 'barcodeNumber',
        'category_id' => 'categoryId',
        'commodity_code' => 'commodityCode',
        'default_cost' => 'defaultCost',
        'department_id' => 'departmentId',
        'depth' => 'depth',
        'description' => 'description',
        'do_not_order' => 'doNotOrder',
        'extended_description' => 'extendedDescription',
        'height' => 'height',
        'item_type_id' => 'itemTypeId',
        'last_updated' => 'lastUpdated',
        'manufacturer' => 'manufacturer',
        'msrp' => 'msrp',
        'notes' => 'notes',
        'default_price' => 'defaultPrice',
        'default_price_inc_tax' => 'defaultPriceIncTax',
        'primary_vendor_cost' => 'primaryVendorCost',
        'primary_vendor_id' => 'primaryVendorId',
        'primary_vendor_master_pack_quantity' => 'primaryVendorMasterPackQuantity',
        'primary_vendor_minimum_order' => 'primaryVendorMinimumOrder',
        'primary_vendor_re_order_number' => 'primaryVendorReOrderNumber',
        'primary_vendor_tax_rate' => 'primaryVendorTaxRate',
        'product_line' => 'productLine',
        'sku' => 'sku',
        'sub_description1' => 'subDescription1',
        'sub_description2' => 'subDescription2',
        'sub_description3' => 'subDescription3',
        'tag_along_item_skus' => 'tagAlongItemSkus',
        'taxable' => 'taxable',
        'taxable_group_id' => 'taxableGroupId',
        'unit_of_measure_id' => 'unitOfMeasureId',
        'web_content' => 'webContent',
        'web_item' => 'webItem',
        'web_links' => 'webLinks',
        'weight' => 'weight',
        'width' => 'width',
        'has_question_set' => 'hasQuestionSet',
        'matrix_sku' => 'matrixSku',
        'location_quantities' => 'locationQuantities',
        'location_details' => 'locationDetails',
        'kit_component_details' => 'kitComponentDetails',
        'item_messages' => 'itemMessages'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'item_master_id' => 'setItemMasterId',
        'active' => 'setActive',
        'aliases' => 'setAliases',
        'barcode_format' => 'setBarcodeFormat',
        'barcode_number' => 'setBarcodeNumber',
        'category_id' => 'setCategoryId',
        'commodity_code' => 'setCommodityCode',
        'default_cost' => 'setDefaultCost',
        'department_id' => 'setDepartmentId',
        'depth' => 'setDepth',
        'description' => 'setDescription',
        'do_not_order' => 'setDoNotOrder',
        'extended_description' => 'setExtendedDescription',
        'height' => 'setHeight',
        'item_type_id' => 'setItemTypeId',
        'last_updated' => 'setLastUpdated',
        'manufacturer' => 'setManufacturer',
        'msrp' => 'setMsrp',
        'notes' => 'setNotes',
        'default_price' => 'setDefaultPrice',
        'default_price_inc_tax' => 'setDefaultPriceIncTax',
        'primary_vendor_cost' => 'setPrimaryVendorCost',
        'primary_vendor_id' => 'setPrimaryVendorId',
        'primary_vendor_master_pack_quantity' => 'setPrimaryVendorMasterPackQuantity',
        'primary_vendor_minimum_order' => 'setPrimaryVendorMinimumOrder',
        'primary_vendor_re_order_number' => 'setPrimaryVendorReOrderNumber',
        'primary_vendor_tax_rate' => 'setPrimaryVendorTaxRate',
        'product_line' => 'setProductLine',
        'sku' => 'setSku',
        'sub_description1' => 'setSubDescription1',
        'sub_description2' => 'setSubDescription2',
        'sub_description3' => 'setSubDescription3',
        'tag_along_item_skus' => 'setTagAlongItemSkus',
        'taxable' => 'setTaxable',
        'taxable_group_id' => 'setTaxableGroupId',
        'unit_of_measure_id' => 'setUnitOfMeasureId',
        'web_content' => 'setWebContent',
        'web_item' => 'setWebItem',
        'web_links' => 'setWebLinks',
        'weight' => 'setWeight',
        'width' => 'setWidth',
        'has_question_set' => 'setHasQuestionSet',
        'matrix_sku' => 'setMatrixSku',
        'location_quantities' => 'setLocationQuantities',
        'location_details' => 'setLocationDetails',
        'kit_component_details' => 'setKitComponentDetails',
        'item_messages' => 'setItemMessages'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'item_master_id' => 'getItemMasterId',
        'active' => 'getActive',
        'aliases' => 'getAliases',
        'barcode_format' => 'getBarcodeFormat',
        'barcode_number' => 'getBarcodeNumber',
        'category_id' => 'getCategoryId',
        'commodity_code' => 'getCommodityCode',
        'default_cost' => 'getDefaultCost',
        'department_id' => 'getDepartmentId',
        'depth' => 'getDepth',
        'description' => 'getDescription',
        'do_not_order' => 'getDoNotOrder',
        'extended_description' => 'getExtendedDescription',
        'height' => 'getHeight',
        'item_type_id' => 'getItemTypeId',
        'last_updated' => 'getLastUpdated',
        'manufacturer' => 'getManufacturer',
        'msrp' => 'getMsrp',
        'notes' => 'getNotes',
        'default_price' => 'getDefaultPrice',
        'default_price_inc_tax' => 'getDefaultPriceIncTax',
        'primary_vendor_cost' => 'getPrimaryVendorCost',
        'primary_vendor_id' => 'getPrimaryVendorId',
        'primary_vendor_master_pack_quantity' => 'getPrimaryVendorMasterPackQuantity',
        'primary_vendor_minimum_order' => 'getPrimaryVendorMinimumOrder',
        'primary_vendor_re_order_number' => 'getPrimaryVendorReOrderNumber',
        'primary_vendor_tax_rate' => 'getPrimaryVendorTaxRate',
        'product_line' => 'getProductLine',
        'sku' => 'getSku',
        'sub_description1' => 'getSubDescription1',
        'sub_description2' => 'getSubDescription2',
        'sub_description3' => 'getSubDescription3',
        'tag_along_item_skus' => 'getTagAlongItemSkus',
        'taxable' => 'getTaxable',
        'taxable_group_id' => 'getTaxableGroupId',
        'unit_of_measure_id' => 'getUnitOfMeasureId',
        'web_content' => 'getWebContent',
        'web_item' => 'getWebItem',
        'web_links' => 'getWebLinks',
        'weight' => 'getWeight',
        'width' => 'getWidth',
        'has_question_set' => 'getHasQuestionSet',
        'matrix_sku' => 'getMatrixSku',
        'location_quantities' => 'getLocationQuantities',
        'location_details' => 'getLocationDetails',
        'kit_component_details' => 'getKitComponentDetails',
        'item_messages' => 'getItemMessages'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('item_master_id', $data ?? [], null);
        $this->setIfExists('active', $data ?? [], null);
        $this->setIfExists('aliases', $data ?? [], null);
        $this->setIfExists('barcode_format', $data ?? [], null);
        $this->setIfExists('barcode_number', $data ?? [], null);
        $this->setIfExists('category_id', $data ?? [], null);
        $this->setIfExists('commodity_code', $data ?? [], null);
        $this->setIfExists('default_cost', $data ?? [], null);
        $this->setIfExists('department_id', $data ?? [], null);
        $this->setIfExists('depth', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('do_not_order', $data ?? [], null);
        $this->setIfExists('extended_description', $data ?? [], null);
        $this->setIfExists('height', $data ?? [], null);
        $this->setIfExists('item_type_id', $data ?? [], null);
        $this->setIfExists('last_updated', $data ?? [], null);
        $this->setIfExists('manufacturer', $data ?? [], null);
        $this->setIfExists('msrp', $data ?? [], null);
        $this->setIfExists('notes', $data ?? [], null);
        $this->setIfExists('default_price', $data ?? [], null);
        $this->setIfExists('default_price_inc_tax', $data ?? [], null);
        $this->setIfExists('primary_vendor_cost', $data ?? [], null);
        $this->setIfExists('primary_vendor_id', $data ?? [], null);
        $this->setIfExists('primary_vendor_master_pack_quantity', $data ?? [], null);
        $this->setIfExists('primary_vendor_minimum_order', $data ?? [], null);
        $this->setIfExists('primary_vendor_re_order_number', $data ?? [], null);
        $this->setIfExists('primary_vendor_tax_rate', $data ?? [], null);
        $this->setIfExists('product_line', $data ?? [], null);
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('sub_description1', $data ?? [], null);
        $this->setIfExists('sub_description2', $data ?? [], null);
        $this->setIfExists('sub_description3', $data ?? [], null);
        $this->setIfExists('tag_along_item_skus', $data ?? [], null);
        $this->setIfExists('taxable', $data ?? [], null);
        $this->setIfExists('taxable_group_id', $data ?? [], null);
        $this->setIfExists('unit_of_measure_id', $data ?? [], null);
        $this->setIfExists('web_content', $data ?? [], null);
        $this->setIfExists('web_item', $data ?? [], null);
        $this->setIfExists('web_links', $data ?? [], null);
        $this->setIfExists('weight', $data ?? [], null);
        $this->setIfExists('width', $data ?? [], null);
        $this->setIfExists('has_question_set', $data ?? [], null);
        $this->setIfExists('matrix_sku', $data ?? [], null);
        $this->setIfExists('location_quantities', $data ?? [], null);
        $this->setIfExists('location_details', $data ?? [], null);
        $this->setIfExists('kit_component_details', $data ?? [], null);
        $this->setIfExists('item_messages', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets item_master_id
     *
     * @return int|null
     */
    public function getItemMasterId()
    {
        return $this->container['item_master_id'];
    }

    /**
     * Sets item_master_id
     *
     * @param int|null $item_master_id The item master id
     *
     * @return self
     */
    public function setItemMasterId($item_master_id)
    {
        if (is_null($item_master_id)) {
            throw new \InvalidArgumentException('non-nullable item_master_id cannot be null');
        }
        $this->container['item_master_id'] = $item_master_id;

        return $this;
    }

    /**
     * Gets active
     *
     * @return bool|null
     */
    public function getActive()
    {
        return $this->container['active'];
    }

    /**
     * Sets active
     *
     * @param bool|null $active Whether the item is active or not
     *
     * @return self
     */
    public function setActive($active)
    {
        if (is_null($active)) {
            throw new \InvalidArgumentException('non-nullable active cannot be null');
        }
        $this->container['active'] = $active;

        return $this;
    }

    /**
     * Gets aliases
     *
     * @return string[]|null
     */
    public function getAliases()
    {
        return $this->container['aliases'];
    }

    /**
     * Sets aliases
     *
     * @param string[]|null $aliases List of aliases that can be used to find this item
     *
     * @return self
     */
    public function setAliases($aliases)
    {
        if (is_null($aliases)) {
            array_push($this->openAPINullablesSetToNull, 'aliases');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('aliases', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['aliases'] = $aliases;

        return $this;
    }

    /**
     * Gets barcode_format
     *
     * @return int|null
     */
    public function getBarcodeFormat()
    {
        return $this->container['barcode_format'];
    }

    /**
     * Sets barcode_format
     *
     * @param int|null $barcode_format The preferred format of the barcode
     *
     * @return self
     */
    public function setBarcodeFormat($barcode_format)
    {
        if (is_null($barcode_format)) {
            throw new \InvalidArgumentException('non-nullable barcode_format cannot be null');
        }
        $this->container['barcode_format'] = $barcode_format;

        return $this;
    }

    /**
     * Gets barcode_number
     *
     * @return string|null
     */
    public function getBarcodeNumber()
    {
        return $this->container['barcode_number'];
    }

    /**
     * Sets barcode_number
     *
     * @param string|null $barcode_number The barcode number - a special alias
     *
     * @return self
     */
    public function setBarcodeNumber($barcode_number)
    {
        if (is_null($barcode_number)) {
            array_push($this->openAPINullablesSetToNull, 'barcode_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('barcode_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['barcode_number'] = $barcode_number;

        return $this;
    }

    /**
     * Gets category_id
     *
     * @return int|null
     */
    public function getCategoryId()
    {
        return $this->container['category_id'];
    }

    /**
     * Sets category_id
     *
     * @param int|null $category_id The item's category
     *
     * @return self
     */
    public function setCategoryId($category_id)
    {
        if (is_null($category_id)) {
            throw new \InvalidArgumentException('non-nullable category_id cannot be null');
        }
        $this->container['category_id'] = $category_id;

        return $this;
    }

    /**
     * Gets commodity_code
     *
     * @return string|null
     */
    public function getCommodityCode()
    {
        return $this->container['commodity_code'];
    }

    /**
     * Sets commodity_code
     *
     * @param string|null $commodity_code The item's commodity code
     *
     * @return self
     */
    public function setCommodityCode($commodity_code)
    {
        if (is_null($commodity_code)) {
            array_push($this->openAPINullablesSetToNull, 'commodity_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('commodity_code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['commodity_code'] = $commodity_code;

        return $this;
    }

    /**
     * Gets default_cost
     *
     * @return float|null
     */
    public function getDefaultCost()
    {
        return $this->container['default_cost'];
    }

    /**
     * Sets default_cost
     *
     * @param float|null $default_cost The default cost of the item
     *
     * @return self
     */
    public function setDefaultCost($default_cost)
    {
        if (is_null($default_cost)) {
            throw new \InvalidArgumentException('non-nullable default_cost cannot be null');
        }
        $this->container['default_cost'] = $default_cost;

        return $this;
    }

    /**
     * Gets department_id
     *
     * @return int|null
     */
    public function getDepartmentId()
    {
        return $this->container['department_id'];
    }

    /**
     * Sets department_id
     *
     * @param int|null $department_id The item's department
     *
     * @return self
     */
    public function setDepartmentId($department_id)
    {
        if (is_null($department_id)) {
            throw new \InvalidArgumentException('non-nullable department_id cannot be null');
        }
        $this->container['department_id'] = $department_id;

        return $this;
    }

    /**
     * Gets depth
     *
     * @return float|null
     */
    public function getDepth()
    {
        return $this->container['depth'];
    }

    /**
     * Sets depth
     *
     * @param float|null $depth The depth of the item packaging
     *
     * @return self
     */
    public function setDepth($depth)
    {
        if (is_null($depth)) {
            array_push($this->openAPINullablesSetToNull, 'depth');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('depth', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['depth'] = $depth;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description The item's description
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            array_push($this->openAPINullablesSetToNull, 'description');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('description', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets do_not_order
     *
     * @return bool|null
     */
    public function getDoNotOrder()
    {
        return $this->container['do_not_order'];
    }

    /**
     * Sets do_not_order
     *
     * @param bool|null $do_not_order Whether the item can be placed on purchase orders or not
     *
     * @return self
     */
    public function setDoNotOrder($do_not_order)
    {
        if (is_null($do_not_order)) {
            throw new \InvalidArgumentException('non-nullable do_not_order cannot be null');
        }
        $this->container['do_not_order'] = $do_not_order;

        return $this;
    }

    /**
     * Gets extended_description
     *
     * @return string|null
     */
    public function getExtendedDescription()
    {
        return $this->container['extended_description'];
    }

    /**
     * Sets extended_description
     *
     * @param string|null $extended_description The longer, extended description of the item
     *
     * @return self
     */
    public function setExtendedDescription($extended_description)
    {
        if (is_null($extended_description)) {
            array_push($this->openAPINullablesSetToNull, 'extended_description');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('extended_description', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['extended_description'] = $extended_description;

        return $this;
    }

    /**
     * Gets height
     *
     * @return float|null
     */
    public function getHeight()
    {
        return $this->container['height'];
    }

    /**
     * Sets height
     *
     * @param float|null $height The height of the item packaging
     *
     * @return self
     */
    public function setHeight($height)
    {
        if (is_null($height)) {
            array_push($this->openAPINullablesSetToNull, 'height');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('height', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['height'] = $height;

        return $this;
    }

    /**
     * Gets item_type_id
     *
     * @return int|null
     */
    public function getItemTypeId()
    {
        return $this->container['item_type_id'];
    }

    /**
     * Sets item_type_id
     *
     * @param int|null $item_type_id The item type:<br />  0 Standard<br />  6 Weighed<br />  7 Non-Inventory<br />  9 Voucher<br />  10 Scale<br />  11 OpSuite Kit<br />  12 Non-Inventory Scale<br />
     *
     * @return self
     */
    public function setItemTypeId($item_type_id)
    {
        if (is_null($item_type_id)) {
            throw new \InvalidArgumentException('non-nullable item_type_id cannot be null');
        }
        $this->container['item_type_id'] = $item_type_id;

        return $this;
    }

    /**
     * Gets last_updated
     *
     * @return \DateTime|null
     */
    public function getLastUpdated()
    {
        return $this->container['last_updated'];
    }

    /**
     * Sets last_updated
     *
     * @param \DateTime|null $last_updated When the item was last updated
     *
     * @return self
     */
    public function setLastUpdated($last_updated)
    {
        if (is_null($last_updated)) {
            throw new \InvalidArgumentException('non-nullable last_updated cannot be null');
        }
        $this->container['last_updated'] = $last_updated;

        return $this;
    }

    /**
     * Gets manufacturer
     *
     * @return string|null
     */
    public function getManufacturer()
    {
        return $this->container['manufacturer'];
    }

    /**
     * Sets manufacturer
     *
     * @param string|null $manufacturer The manufacturer
     *
     * @return self
     */
    public function setManufacturer($manufacturer)
    {
        if (is_null($manufacturer)) {
            array_push($this->openAPINullablesSetToNull, 'manufacturer');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('manufacturer', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['manufacturer'] = $manufacturer;

        return $this;
    }

    /**
     * Gets msrp
     *
     * @return float|null
     */
    public function getMsrp()
    {
        return $this->container['msrp'];
    }

    /**
     * Sets msrp
     *
     * @param float|null $msrp The manufacturer's suggested retail price
     *
     * @return self
     */
    public function setMsrp($msrp)
    {
        if (is_null($msrp)) {
            throw new \InvalidArgumentException('non-nullable msrp cannot be null');
        }
        $this->container['msrp'] = $msrp;

        return $this;
    }

    /**
     * Gets notes
     *
     * @return string|null
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     *
     * @param string|null $notes Notes
     *
     * @return self
     */
    public function setNotes($notes)
    {
        if (is_null($notes)) {
            array_push($this->openAPINullablesSetToNull, 'notes');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('notes', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets default_price
     *
     * @return float|null
     */
    public function getDefaultPrice()
    {
        return $this->container['default_price'];
    }

    /**
     * Sets default_price
     *
     * @param float|null $default_price The default tax exclusive price
     *
     * @return self
     */
    public function setDefaultPrice($default_price)
    {
        if (is_null($default_price)) {
            throw new \InvalidArgumentException('non-nullable default_price cannot be null');
        }
        $this->container['default_price'] = $default_price;

        return $this;
    }

    /**
     * Gets default_price_inc_tax
     *
     * @return float|null
     */
    public function getDefaultPriceIncTax()
    {
        return $this->container['default_price_inc_tax'];
    }

    /**
     * Sets default_price_inc_tax
     *
     * @param float|null $default_price_inc_tax The default tax inclusive price
     *
     * @return self
     */
    public function setDefaultPriceIncTax($default_price_inc_tax)
    {
        if (is_null($default_price_inc_tax)) {
            throw new \InvalidArgumentException('non-nullable default_price_inc_tax cannot be null');
        }
        $this->container['default_price_inc_tax'] = $default_price_inc_tax;

        return $this;
    }

    /**
     * Gets primary_vendor_cost
     *
     * @return float|null
     */
    public function getPrimaryVendorCost()
    {
        return $this->container['primary_vendor_cost'];
    }

    /**
     * Sets primary_vendor_cost
     *
     * @param float|null $primary_vendor_cost The primary supplier cost
     *
     * @return self
     */
    public function setPrimaryVendorCost($primary_vendor_cost)
    {
        if (is_null($primary_vendor_cost)) {
            array_push($this->openAPINullablesSetToNull, 'primary_vendor_cost');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('primary_vendor_cost', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['primary_vendor_cost'] = $primary_vendor_cost;

        return $this;
    }

    /**
     * Gets primary_vendor_id
     *
     * @return int|null
     */
    public function getPrimaryVendorId()
    {
        return $this->container['primary_vendor_id'];
    }

    /**
     * Sets primary_vendor_id
     *
     * @param int|null $primary_vendor_id The primary supplier
     *
     * @return self
     */
    public function setPrimaryVendorId($primary_vendor_id)
    {
        if (is_null($primary_vendor_id)) {
            array_push($this->openAPINullablesSetToNull, 'primary_vendor_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('primary_vendor_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['primary_vendor_id'] = $primary_vendor_id;

        return $this;
    }

    /**
     * Gets primary_vendor_master_pack_quantity
     *
     * @return float|null
     */
    public function getPrimaryVendorMasterPackQuantity()
    {
        return $this->container['primary_vendor_master_pack_quantity'];
    }

    /**
     * Sets primary_vendor_master_pack_quantity
     *
     * @param float|null $primary_vendor_master_pack_quantity The master pack quantity
     *
     * @return self
     */
    public function setPrimaryVendorMasterPackQuantity($primary_vendor_master_pack_quantity)
    {
        if (is_null($primary_vendor_master_pack_quantity)) {
            array_push($this->openAPINullablesSetToNull, 'primary_vendor_master_pack_quantity');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('primary_vendor_master_pack_quantity', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['primary_vendor_master_pack_quantity'] = $primary_vendor_master_pack_quantity;

        return $this;
    }

    /**
     * Gets primary_vendor_minimum_order
     *
     * @return float|null
     */
    public function getPrimaryVendorMinimumOrder()
    {
        return $this->container['primary_vendor_minimum_order'];
    }

    /**
     * Sets primary_vendor_minimum_order
     *
     * @param float|null $primary_vendor_minimum_order The minimum order for the item from the primary supplier
     *
     * @return self
     */
    public function setPrimaryVendorMinimumOrder($primary_vendor_minimum_order)
    {
        if (is_null($primary_vendor_minimum_order)) {
            array_push($this->openAPINullablesSetToNull, 'primary_vendor_minimum_order');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('primary_vendor_minimum_order', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['primary_vendor_minimum_order'] = $primary_vendor_minimum_order;

        return $this;
    }

    /**
     * Gets primary_vendor_re_order_number
     *
     * @return string|null
     */
    public function getPrimaryVendorReOrderNumber()
    {
        return $this->container['primary_vendor_re_order_number'];
    }

    /**
     * Sets primary_vendor_re_order_number
     *
     * @param string|null $primary_vendor_re_order_number The primary supplier's reorder number for the item
     *
     * @return self
     */
    public function setPrimaryVendorReOrderNumber($primary_vendor_re_order_number)
    {
        if (is_null($primary_vendor_re_order_number)) {
            array_push($this->openAPINullablesSetToNull, 'primary_vendor_re_order_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('primary_vendor_re_order_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['primary_vendor_re_order_number'] = $primary_vendor_re_order_number;

        return $this;
    }

    /**
     * Gets primary_vendor_tax_rate
     *
     * @return float|null
     */
    public function getPrimaryVendorTaxRate()
    {
        return $this->container['primary_vendor_tax_rate'];
    }

    /**
     * Sets primary_vendor_tax_rate
     *
     * @param float|null $primary_vendor_tax_rate The tax rate that applies
     *
     * @return self
     */
    public function setPrimaryVendorTaxRate($primary_vendor_tax_rate)
    {
        if (is_null($primary_vendor_tax_rate)) {
            array_push($this->openAPINullablesSetToNull, 'primary_vendor_tax_rate');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('primary_vendor_tax_rate', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['primary_vendor_tax_rate'] = $primary_vendor_tax_rate;

        return $this;
    }

    /**
     * Gets product_line
     *
     * @return string|null
     */
    public function getProductLine()
    {
        return $this->container['product_line'];
    }

    /**
     * Sets product_line
     *
     * @param string|null $product_line The product line
     *
     * @return self
     */
    public function setProductLine($product_line)
    {
        if (is_null($product_line)) {
            array_push($this->openAPINullablesSetToNull, 'product_line');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('product_line', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['product_line'] = $product_line;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku The item sku
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            array_push($this->openAPINullablesSetToNull, 'sku');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('sku', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets sub_description1
     *
     * @return string|null
     */
    public function getSubDescription1()
    {
        return $this->container['sub_description1'];
    }

    /**
     * Sets sub_description1
     *
     * @param string|null $sub_description1 Sub description 1
     *
     * @return self
     */
    public function setSubDescription1($sub_description1)
    {
        if (is_null($sub_description1)) {
            array_push($this->openAPINullablesSetToNull, 'sub_description1');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('sub_description1', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['sub_description1'] = $sub_description1;

        return $this;
    }

    /**
     * Gets sub_description2
     *
     * @return string|null
     */
    public function getSubDescription2()
    {
        return $this->container['sub_description2'];
    }

    /**
     * Sets sub_description2
     *
     * @param string|null $sub_description2 Sub description 2
     *
     * @return self
     */
    public function setSubDescription2($sub_description2)
    {
        if (is_null($sub_description2)) {
            array_push($this->openAPINullablesSetToNull, 'sub_description2');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('sub_description2', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['sub_description2'] = $sub_description2;

        return $this;
    }

    /**
     * Gets sub_description3
     *
     * @return string|null
     */
    public function getSubDescription3()
    {
        return $this->container['sub_description3'];
    }

    /**
     * Sets sub_description3
     *
     * @param string|null $sub_description3 Sub description 3
     *
     * @return self
     */
    public function setSubDescription3($sub_description3)
    {
        if (is_null($sub_description3)) {
            array_push($this->openAPINullablesSetToNull, 'sub_description3');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('sub_description3', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['sub_description3'] = $sub_description3;

        return $this;
    }

    /**
     * Gets tag_along_item_skus
     *
     * @return string[]|null
     */
    public function getTagAlongItemSkus()
    {
        return $this->container['tag_along_item_skus'];
    }

    /**
     * Sets tag_along_item_skus
     *
     * @param string[]|null $tag_along_item_skus A list of tag along item skus
     *
     * @return self
     */
    public function setTagAlongItemSkus($tag_along_item_skus)
    {
        if (is_null($tag_along_item_skus)) {
            array_push($this->openAPINullablesSetToNull, 'tag_along_item_skus');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('tag_along_item_skus', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['tag_along_item_skus'] = $tag_along_item_skus;

        return $this;
    }

    /**
     * Gets taxable
     *
     * @return bool|null
     */
    public function getTaxable()
    {
        return $this->container['taxable'];
    }

    /**
     * Sets taxable
     *
     * @param bool|null $taxable Whether the item is taxable or not
     *
     * @return self
     */
    public function setTaxable($taxable)
    {
        if (is_null($taxable)) {
            throw new \InvalidArgumentException('non-nullable taxable cannot be null');
        }
        $this->container['taxable'] = $taxable;

        return $this;
    }

    /**
     * Gets taxable_group_id
     *
     * @return int|null
     */
    public function getTaxableGroupId()
    {
        return $this->container['taxable_group_id'];
    }

    /**
     * Sets taxable_group_id
     *
     * @param int|null $taxable_group_id The tax group
     *
     * @return self
     */
    public function setTaxableGroupId($taxable_group_id)
    {
        if (is_null($taxable_group_id)) {
            array_push($this->openAPINullablesSetToNull, 'taxable_group_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('taxable_group_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['taxable_group_id'] = $taxable_group_id;

        return $this;
    }

    /**
     * Gets unit_of_measure_id
     *
     * @return int|null
     */
    public function getUnitOfMeasureId()
    {
        return $this->container['unit_of_measure_id'];
    }

    /**
     * Sets unit_of_measure_id
     *
     * @param int|null $unit_of_measure_id Unit of measure
     *
     * @return self
     */
    public function setUnitOfMeasureId($unit_of_measure_id)
    {
        if (is_null($unit_of_measure_id)) {
            throw new \InvalidArgumentException('non-nullable unit_of_measure_id cannot be null');
        }
        $this->container['unit_of_measure_id'] = $unit_of_measure_id;

        return $this;
    }

    /**
     * Gets web_content
     *
     * @return \Opsuite2\Model\WebContent|null
     */
    public function getWebContent()
    {
        return $this->container['web_content'];
    }

    /**
     * Sets web_content
     *
     * @param \Opsuite2\Model\WebContent|null $web_content web_content
     *
     * @return self
     */
    public function setWebContent($web_content)
    {
        if (is_null($web_content)) {
            throw new \InvalidArgumentException('non-nullable web_content cannot be null');
        }
        $this->container['web_content'] = $web_content;

        return $this;
    }

    /**
     * Gets web_item
     *
     * @return bool|null
     */
    public function getWebItem()
    {
        return $this->container['web_item'];
    }

    /**
     * Sets web_item
     *
     * @param bool|null $web_item Whether this item is available on the web or not
     *
     * @return self
     */
    public function setWebItem($web_item)
    {
        if (is_null($web_item)) {
            throw new \InvalidArgumentException('non-nullable web_item cannot be null');
        }
        $this->container['web_item'] = $web_item;

        return $this;
    }

    /**
     * Gets web_links
     *
     * @return \Opsuite2\Model\WebLink[]|null
     */
    public function getWebLinks()
    {
        return $this->container['web_links'];
    }

    /**
     * Sets web_links
     *
     * @param \Opsuite2\Model\WebLink[]|null $web_links The (optional) web links associated with the item
     *
     * @return self
     */
    public function setWebLinks($web_links)
    {
        if (is_null($web_links)) {
            array_push($this->openAPINullablesSetToNull, 'web_links');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('web_links', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['web_links'] = $web_links;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return float|null
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param float|null $weight The weight of the item when packed
     *
     * @return self
     */
    public function setWeight($weight)
    {
        if (is_null($weight)) {
            throw new \InvalidArgumentException('non-nullable weight cannot be null');
        }
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets width
     *
     * @return float|null
     */
    public function getWidth()
    {
        return $this->container['width'];
    }

    /**
     * Sets width
     *
     * @param float|null $width The width of the item's packaging
     *
     * @return self
     */
    public function setWidth($width)
    {
        if (is_null($width)) {
            array_push($this->openAPINullablesSetToNull, 'width');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('width', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['width'] = $width;

        return $this;
    }

    /**
     * Gets has_question_set
     *
     * @return bool|null
     */
    public function getHasQuestionSet()
    {
        return $this->container['has_question_set'];
    }

    /**
     * Sets has_question_set
     *
     * @param bool|null $has_question_set Whether the item has any questions associated with it or not
     *
     * @return self
     */
    public function setHasQuestionSet($has_question_set)
    {
        if (is_null($has_question_set)) {
            throw new \InvalidArgumentException('non-nullable has_question_set cannot be null');
        }
        $this->container['has_question_set'] = $has_question_set;

        return $this;
    }

    /**
     * Gets matrix_sku
     *
     * @return string|null
     */
    public function getMatrixSku()
    {
        return $this->container['matrix_sku'];
    }

    /**
     * Sets matrix_sku
     *
     * @param string|null $matrix_sku If this item is part of a matrix the matrix sku will appear here
     *
     * @return self
     */
    public function setMatrixSku($matrix_sku)
    {
        if (is_null($matrix_sku)) {
            array_push($this->openAPINullablesSetToNull, 'matrix_sku');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('matrix_sku', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['matrix_sku'] = $matrix_sku;

        return $this;
    }

    /**
     * Gets location_quantities
     *
     * @return \Opsuite2\Model\ItemLocationQuantities[]|null
     * @deprecated
     */
    public function getLocationQuantities()
    {
        return $this->container['location_quantities'];
    }

    /**
     * Sets location_quantities
     *
     * @param \Opsuite2\Model\ItemLocationQuantities[]|null $location_quantities A list of the quantities of the item at each location
     *
     * @return self
     * @deprecated
     */
    public function setLocationQuantities($location_quantities)
    {
        if (is_null($location_quantities)) {
            array_push($this->openAPINullablesSetToNull, 'location_quantities');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('location_quantities', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['location_quantities'] = $location_quantities;

        return $this;
    }

    /**
     * Gets location_details
     *
     * @return \Opsuite2\Model\ItemLocationDetails[]|null
     */
    public function getLocationDetails()
    {
        return $this->container['location_details'];
    }

    /**
     * Sets location_details
     *
     * @param \Opsuite2\Model\ItemLocationDetails[]|null $location_details A list of the details of the item at each location
     *
     * @return self
     */
    public function setLocationDetails($location_details)
    {
        if (is_null($location_details)) {
            array_push($this->openAPINullablesSetToNull, 'location_details');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('location_details', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['location_details'] = $location_details;

        return $this;
    }

    /**
     * Gets kit_component_details
     *
     * @return \Opsuite2\Model\KitComponent[]|null
     */
    public function getKitComponentDetails()
    {
        return $this->container['kit_component_details'];
    }

    /**
     * Sets kit_component_details
     *
     * @param \Opsuite2\Model\KitComponent[]|null $kit_component_details An optional list of kit information for the item
     *
     * @return self
     */
    public function setKitComponentDetails($kit_component_details)
    {
        if (is_null($kit_component_details)) {
            array_push($this->openAPINullablesSetToNull, 'kit_component_details');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('kit_component_details', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['kit_component_details'] = $kit_component_details;

        return $this;
    }

    /**
     * Gets item_messages
     *
     * @return \Opsuite2\Model\ItemMessage[]|null
     */
    public function getItemMessages()
    {
        return $this->container['item_messages'];
    }

    /**
     * Sets item_messages
     *
     * @param \Opsuite2\Model\ItemMessage[]|null $item_messages The optional item messages that are displayed for the item
     *
     * @return self
     */
    public function setItemMessages($item_messages)
    {
        if (is_null($item_messages)) {
            array_push($this->openAPINullablesSetToNull, 'item_messages');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('item_messages', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['item_messages'] = $item_messages;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


