<?php
/**
 * ItemBinQuantitiesUpdateByName
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * ItemBinQuantitiesUpdateByName Class Doc Comment
 *
 * @category Class
 * @description Describes an update to the item location detail bin location quantities
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ItemBinQuantitiesUpdateByName implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ItemBinQuantitiesUpdateByName';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'index' => 'int',
        'source_location' => 'string',
        'destination_location' => 'string',
        'source_bin_location' => 'string',
        'destination_bin_location' => 'string',
        'sku' => 'string',
        'movement_type' => 'int',
        'movement_quantity' => 'float',
        'reason_code' => 'string',
        'title' => 'string',
        'remarks' => 'string',
        'inventory_control_document_id' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'index' => 'int32',
        'source_location' => null,
        'destination_location' => null,
        'source_bin_location' => null,
        'destination_bin_location' => null,
        'sku' => null,
        'movement_type' => 'int32',
        'movement_quantity' => 'double',
        'reason_code' => null,
        'title' => null,
        'remarks' => null,
        'inventory_control_document_id' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'index' => false,
        'source_location' => true,
        'destination_location' => true,
        'source_bin_location' => true,
        'destination_bin_location' => true,
        'sku' => true,
        'movement_type' => false,
        'movement_quantity' => false,
        'reason_code' => true,
        'title' => true,
        'remarks' => true,
        'inventory_control_document_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'index' => 'index',
        'source_location' => 'sourceLocation',
        'destination_location' => 'destinationLocation',
        'source_bin_location' => 'sourceBinLocation',
        'destination_bin_location' => 'destinationBinLocation',
        'sku' => 'sku',
        'movement_type' => 'movementType',
        'movement_quantity' => 'movementQuantity',
        'reason_code' => 'reasonCode',
        'title' => 'title',
        'remarks' => 'remarks',
        'inventory_control_document_id' => 'inventoryControlDocumentId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'index' => 'setIndex',
        'source_location' => 'setSourceLocation',
        'destination_location' => 'setDestinationLocation',
        'source_bin_location' => 'setSourceBinLocation',
        'destination_bin_location' => 'setDestinationBinLocation',
        'sku' => 'setSku',
        'movement_type' => 'setMovementType',
        'movement_quantity' => 'setMovementQuantity',
        'reason_code' => 'setReasonCode',
        'title' => 'setTitle',
        'remarks' => 'setRemarks',
        'inventory_control_document_id' => 'setInventoryControlDocumentId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'index' => 'getIndex',
        'source_location' => 'getSourceLocation',
        'destination_location' => 'getDestinationLocation',
        'source_bin_location' => 'getSourceBinLocation',
        'destination_bin_location' => 'getDestinationBinLocation',
        'sku' => 'getSku',
        'movement_type' => 'getMovementType',
        'movement_quantity' => 'getMovementQuantity',
        'reason_code' => 'getReasonCode',
        'title' => 'getTitle',
        'remarks' => 'getRemarks',
        'inventory_control_document_id' => 'getInventoryControlDocumentId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('index', $data ?? [], null);
        $this->setIfExists('source_location', $data ?? [], null);
        $this->setIfExists('destination_location', $data ?? [], null);
        $this->setIfExists('source_bin_location', $data ?? [], null);
        $this->setIfExists('destination_bin_location', $data ?? [], null);
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('movement_type', $data ?? [], null);
        $this->setIfExists('movement_quantity', $data ?? [], null);
        $this->setIfExists('reason_code', $data ?? [], null);
        $this->setIfExists('title', $data ?? [], null);
        $this->setIfExists('remarks', $data ?? [], null);
        $this->setIfExists('inventory_control_document_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets index
     *
     * @return int|null
     */
    public function getIndex()
    {
        return $this->container['index'];
    }

    /**
     * Sets index
     *
     * @param int|null $index The position in the array
     *
     * @return self
     */
    public function setIndex($index)
    {
        if (is_null($index)) {
            throw new \InvalidArgumentException('non-nullable index cannot be null');
        }
        $this->container['index'] = $index;

        return $this;
    }

    /**
     * Gets source_location
     *
     * @return string|null
     */
    public function getSourceLocation()
    {
        return $this->container['source_location'];
    }

    /**
     * Sets source_location
     *
     * @param string|null $source_location Source location id.
     *
     * @return self
     */
    public function setSourceLocation($source_location)
    {
        if (is_null($source_location)) {
            array_push($this->openAPINullablesSetToNull, 'source_location');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('source_location', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['source_location'] = $source_location;

        return $this;
    }

    /**
     * Gets destination_location
     *
     * @return string|null
     */
    public function getDestinationLocation()
    {
        return $this->container['destination_location'];
    }

    /**
     * Sets destination_location
     *
     * @param string|null $destination_location Destination location. Unset for a bin to bin movement within a warehouse.
     *
     * @return self
     */
    public function setDestinationLocation($destination_location)
    {
        if (is_null($destination_location)) {
            array_push($this->openAPINullablesSetToNull, 'destination_location');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('destination_location', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['destination_location'] = $destination_location;

        return $this;
    }

    /**
     * Gets source_bin_location
     *
     * @return string|null
     */
    public function getSourceBinLocation()
    {
        return $this->container['source_bin_location'];
    }

    /**
     * Sets source_bin_location
     *
     * @param string|null $source_bin_location Source bin location. Only set if the source location is a warehouse.
     *
     * @return self
     */
    public function setSourceBinLocation($source_bin_location)
    {
        if (is_null($source_bin_location)) {
            array_push($this->openAPINullablesSetToNull, 'source_bin_location');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('source_bin_location', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['source_bin_location'] = $source_bin_location;

        return $this;
    }

    /**
     * Gets destination_bin_location
     *
     * @return string|null
     */
    public function getDestinationBinLocation()
    {
        return $this->container['destination_bin_location'];
    }

    /**
     * Sets destination_bin_location
     *
     * @param string|null $destination_bin_location Destination bin location. Only set if the destination is a warehouse.
     *
     * @return self
     */
    public function setDestinationBinLocation($destination_bin_location)
    {
        if (is_null($destination_bin_location)) {
            array_push($this->openAPINullablesSetToNull, 'destination_bin_location');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('destination_bin_location', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['destination_bin_location'] = $destination_bin_location;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku The item location detail sku.
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            array_push($this->openAPINullablesSetToNull, 'sku');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('sku', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets movement_type
     *
     * @return int|null
     */
    public function getMovementType()
    {
        return $this->container['movement_type'];
    }

    /**
     * Sets movement_type
     *
     * @param int|null $movement_type The type of movement:  1 - For Customer Order. Item moved to default customer order out bin  2 - For Inter-Store Transfer. Item moved to default inter-store transfer out bin  3 - For Transfer Out. Item moved to default transfer out bin.  4 - For Transfer to Supplier. Item moved to default transfer to supplier bin  5 - Bin to Bin. Destination bin location must be set.  6 - Bin to Store. Destination loction and item location detail must be set.  7 - Store to Bin. Destination location, item location detail, and bin location must be set.
     *
     * @return self
     */
    public function setMovementType($movement_type)
    {
        if (is_null($movement_type)) {
            throw new \InvalidArgumentException('non-nullable movement_type cannot be null');
        }
        $this->container['movement_type'] = $movement_type;

        return $this;
    }

    /**
     * Gets movement_quantity
     *
     * @return float|null
     */
    public function getMovementQuantity()
    {
        return $this->container['movement_quantity'];
    }

    /**
     * Sets movement_quantity
     *
     * @param float|null $movement_quantity The quantity of the item to move between bins, bin to store, or store to bin
     *
     * @return self
     */
    public function setMovementQuantity($movement_quantity)
    {
        if (is_null($movement_quantity)) {
            throw new \InvalidArgumentException('non-nullable movement_quantity cannot be null');
        }
        $this->container['movement_quantity'] = $movement_quantity;

        return $this;
    }

    /**
     * Gets reason_code
     *
     * @return string|null
     */
    public function getReasonCode()
    {
        return $this->container['reason_code'];
    }

    /**
     * Sets reason_code
     *
     * @param string|null $reason_code The reason for the movement
     *
     * @return self
     */
    public function setReasonCode($reason_code)
    {
        if (is_null($reason_code)) {
            array_push($this->openAPINullablesSetToNull, 'reason_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('reason_code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['reason_code'] = $reason_code;

        return $this;
    }

    /**
     * Gets title
     *
     * @return string|null
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     *
     * @param string|null $title A heading to append to the stock movement document title
     *
     * @return self
     */
    public function setTitle($title)
    {
        if (is_null($title)) {
            array_push($this->openAPINullablesSetToNull, 'title');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('title', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets remarks
     *
     * @return string|null
     */
    public function getRemarks()
    {
        return $this->container['remarks'];
    }

    /**
     * Sets remarks
     *
     * @param string|null $remarks Any remarks to attach to the stock movement document
     *
     * @return self
     */
    public function setRemarks($remarks)
    {
        if (is_null($remarks)) {
            array_push($this->openAPINullablesSetToNull, 'remarks');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('remarks', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['remarks'] = $remarks;

        return $this;
    }

    /**
     * Gets inventory_control_document_id
     *
     * @return int|null
     */
    public function getInventoryControlDocumentId()
    {
        return $this->container['inventory_control_document_id'];
    }

    /**
     * Sets inventory_control_document_id
     *
     * @param int|null $inventory_control_document_id Set to the id of the inventory control document created for this movement
     *
     * @return self
     */
    public function setInventoryControlDocumentId($inventory_control_document_id)
    {
        if (is_null($inventory_control_document_id)) {
            throw new \InvalidArgumentException('non-nullable inventory_control_document_id cannot be null');
        }
        $this->container['inventory_control_document_id'] = $inventory_control_document_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


