<?php
/**
 * ItemBinLocation
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * ItemBinLocation Class Doc Comment
 *
 * @category Class
 * @description The item bin location record
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ItemBinLocation implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ItemBinLocation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'item_location_detail_id' => 'int',
        'bin_location_id' => 'int',
        'bin_location_name' => 'string',
        'id' => 'int',
        'item_location_detail' => '\Opsuite2\Model\ItemLocationDetail',
        'quantity_on_hand' => 'float',
        'quantity_on_pick_list' => 'float',
        'quantity_available' => 'float',
        'holds_offline_stock' => 'bool',
        'unpickable' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'item_location_detail_id' => 'int32',
        'bin_location_id' => 'int32',
        'bin_location_name' => null,
        'id' => 'int32',
        'item_location_detail' => null,
        'quantity_on_hand' => 'double',
        'quantity_on_pick_list' => 'double',
        'quantity_available' => 'double',
        'holds_offline_stock' => null,
        'unpickable' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'item_location_detail_id' => false,
        'bin_location_id' => false,
        'bin_location_name' => true,
        'id' => false,
        'item_location_detail' => false,
        'quantity_on_hand' => false,
        'quantity_on_pick_list' => false,
        'quantity_available' => false,
        'holds_offline_stock' => false,
        'unpickable' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'item_location_detail_id' => 'itemLocationDetailId',
        'bin_location_id' => 'binLocationId',
        'bin_location_name' => 'binLocationName',
        'id' => 'id',
        'item_location_detail' => 'itemLocationDetail',
        'quantity_on_hand' => 'quantityOnHand',
        'quantity_on_pick_list' => 'quantityOnPickList',
        'quantity_available' => 'quantityAvailable',
        'holds_offline_stock' => 'holdsOfflineStock',
        'unpickable' => 'unpickable'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'item_location_detail_id' => 'setItemLocationDetailId',
        'bin_location_id' => 'setBinLocationId',
        'bin_location_name' => 'setBinLocationName',
        'id' => 'setId',
        'item_location_detail' => 'setItemLocationDetail',
        'quantity_on_hand' => 'setQuantityOnHand',
        'quantity_on_pick_list' => 'setQuantityOnPickList',
        'quantity_available' => 'setQuantityAvailable',
        'holds_offline_stock' => 'setHoldsOfflineStock',
        'unpickable' => 'setUnpickable'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'item_location_detail_id' => 'getItemLocationDetailId',
        'bin_location_id' => 'getBinLocationId',
        'bin_location_name' => 'getBinLocationName',
        'id' => 'getId',
        'item_location_detail' => 'getItemLocationDetail',
        'quantity_on_hand' => 'getQuantityOnHand',
        'quantity_on_pick_list' => 'getQuantityOnPickList',
        'quantity_available' => 'getQuantityAvailable',
        'holds_offline_stock' => 'getHoldsOfflineStock',
        'unpickable' => 'getUnpickable'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('item_location_detail_id', $data ?? [], null);
        $this->setIfExists('bin_location_id', $data ?? [], null);
        $this->setIfExists('bin_location_name', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('item_location_detail', $data ?? [], null);
        $this->setIfExists('quantity_on_hand', $data ?? [], null);
        $this->setIfExists('quantity_on_pick_list', $data ?? [], null);
        $this->setIfExists('quantity_available', $data ?? [], null);
        $this->setIfExists('holds_offline_stock', $data ?? [], null);
        $this->setIfExists('unpickable', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets item_location_detail_id
     *
     * @return int|null
     */
    public function getItemLocationDetailId()
    {
        return $this->container['item_location_detail_id'];
    }

    /**
     * Sets item_location_detail_id
     *
     * @param int|null $item_location_detail_id The item location detail id
     *
     * @return self
     */
    public function setItemLocationDetailId($item_location_detail_id)
    {
        if (is_null($item_location_detail_id)) {
            throw new \InvalidArgumentException('non-nullable item_location_detail_id cannot be null');
        }
        $this->container['item_location_detail_id'] = $item_location_detail_id;

        return $this;
    }

    /**
     * Gets bin_location_id
     *
     * @return int|null
     */
    public function getBinLocationId()
    {
        return $this->container['bin_location_id'];
    }

    /**
     * Sets bin_location_id
     *
     * @param int|null $bin_location_id The bin id
     *
     * @return self
     */
    public function setBinLocationId($bin_location_id)
    {
        if (is_null($bin_location_id)) {
            throw new \InvalidArgumentException('non-nullable bin_location_id cannot be null');
        }
        $this->container['bin_location_id'] = $bin_location_id;

        return $this;
    }

    /**
     * Gets bin_location_name
     *
     * @return string|null
     */
    public function getBinLocationName()
    {
        return $this->container['bin_location_name'];
    }

    /**
     * Sets bin_location_name
     *
     * @param string|null $bin_location_name The bin name
     *
     * @return self
     */
    public function setBinLocationName($bin_location_name)
    {
        if (is_null($bin_location_name)) {
            array_push($this->openAPINullablesSetToNull, 'bin_location_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('bin_location_name', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['bin_location_name'] = $bin_location_name;

        return $this;
    }

    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id The item bin location id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets item_location_detail
     *
     * @return \Opsuite2\Model\ItemLocationDetail|null
     */
    public function getItemLocationDetail()
    {
        return $this->container['item_location_detail'];
    }

    /**
     * Sets item_location_detail
     *
     * @param \Opsuite2\Model\ItemLocationDetail|null $item_location_detail item_location_detail
     *
     * @return self
     */
    public function setItemLocationDetail($item_location_detail)
    {
        if (is_null($item_location_detail)) {
            throw new \InvalidArgumentException('non-nullable item_location_detail cannot be null');
        }
        $this->container['item_location_detail'] = $item_location_detail;

        return $this;
    }

    /**
     * Gets quantity_on_hand
     *
     * @return float|null
     */
    public function getQuantityOnHand()
    {
        return $this->container['quantity_on_hand'];
    }

    /**
     * Sets quantity_on_hand
     *
     * @param float|null $quantity_on_hand The quantity on hand in the bin
     *
     * @return self
     */
    public function setQuantityOnHand($quantity_on_hand)
    {
        if (is_null($quantity_on_hand)) {
            throw new \InvalidArgumentException('non-nullable quantity_on_hand cannot be null');
        }
        $this->container['quantity_on_hand'] = $quantity_on_hand;

        return $this;
    }

    /**
     * Gets quantity_on_pick_list
     *
     * @return float|null
     */
    public function getQuantityOnPickList()
    {
        return $this->container['quantity_on_pick_list'];
    }

    /**
     * Sets quantity_on_pick_list
     *
     * @param float|null $quantity_on_pick_list The quantity on pick lists in the bin
     *
     * @return self
     */
    public function setQuantityOnPickList($quantity_on_pick_list)
    {
        if (is_null($quantity_on_pick_list)) {
            throw new \InvalidArgumentException('non-nullable quantity_on_pick_list cannot be null');
        }
        $this->container['quantity_on_pick_list'] = $quantity_on_pick_list;

        return $this;
    }

    /**
     * Gets quantity_available
     *
     * @return float|null
     */
    public function getQuantityAvailable()
    {
        return $this->container['quantity_available'];
    }

    /**
     * Sets quantity_available
     *
     * @param float|null $quantity_available The quantity available (quantity on hand - quantity on pick list)
     *
     * @return self
     */
    public function setQuantityAvailable($quantity_available)
    {
        if (is_null($quantity_available)) {
            throw new \InvalidArgumentException('non-nullable quantity_available cannot be null');
        }
        $this->container['quantity_available'] = $quantity_available;

        return $this;
    }

    /**
     * Gets holds_offline_stock
     *
     * @return bool|null
     */
    public function getHoldsOfflineStock()
    {
        return $this->container['holds_offline_stock'];
    }

    /**
     * Sets holds_offline_stock
     *
     * @param bool|null $holds_offline_stock Whether the bin holds off line stock
     *
     * @return self
     */
    public function setHoldsOfflineStock($holds_offline_stock)
    {
        if (is_null($holds_offline_stock)) {
            throw new \InvalidArgumentException('non-nullable holds_offline_stock cannot be null');
        }
        $this->container['holds_offline_stock'] = $holds_offline_stock;

        return $this;
    }

    /**
     * Gets unpickable
     *
     * @return bool|null
     */
    public function getUnpickable()
    {
        return $this->container['unpickable'];
    }

    /**
     * Sets unpickable
     *
     * @param bool|null $unpickable Whether the bin holds pickable stock
     *
     * @return self
     */
    public function setUnpickable($unpickable)
    {
        if (is_null($unpickable)) {
            throw new \InvalidArgumentException('non-nullable unpickable cannot be null');
        }
        $this->container['unpickable'] = $unpickable;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


