<?php
/**
 * Item
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * Item Class Doc Comment
 *
 * @category Class
 * @description An item for sale at a store location
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Item implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Item';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'item_location_detail_id' => 'int',
        'item_master_id' => 'int',
        'sku' => 'string',
        'barcode_number' => 'string',
        'description' => 'string',
        'msrp' => 'float',
        'price_inc_tax' => 'float',
        'price_a_inc_tax' => 'float',
        'price_b_inc_tax' => 'float',
        'price_c_inc_tax' => 'float',
        'price_exc_tax' => 'float',
        'price_a_exc_tax' => 'float',
        'price_b_exc_tax' => 'float',
        'price_c_exc_tax' => 'float',
        'sale_price_inc_tax' => 'float',
        'sale_price_exc_tax' => 'float',
        'sale_start_date' => '\DateTime',
        'sale_end_date' => '\DateTime',
        'price_reduction_price' => 'float'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'item_location_detail_id' => 'int32',
        'item_master_id' => 'int32',
        'sku' => null,
        'barcode_number' => null,
        'description' => null,
        'msrp' => 'double',
        'price_inc_tax' => 'double',
        'price_a_inc_tax' => 'double',
        'price_b_inc_tax' => 'double',
        'price_c_inc_tax' => 'double',
        'price_exc_tax' => 'double',
        'price_a_exc_tax' => 'double',
        'price_b_exc_tax' => 'double',
        'price_c_exc_tax' => 'double',
        'sale_price_inc_tax' => 'double',
        'sale_price_exc_tax' => 'double',
        'sale_start_date' => 'date-time',
        'sale_end_date' => 'date-time',
        'price_reduction_price' => 'double'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'item_location_detail_id' => false,
        'item_master_id' => false,
        'sku' => true,
        'barcode_number' => true,
        'description' => true,
        'msrp' => false,
        'price_inc_tax' => false,
        'price_a_inc_tax' => false,
        'price_b_inc_tax' => false,
        'price_c_inc_tax' => false,
        'price_exc_tax' => false,
        'price_a_exc_tax' => false,
        'price_b_exc_tax' => false,
        'price_c_exc_tax' => false,
        'sale_price_inc_tax' => false,
        'sale_price_exc_tax' => false,
        'sale_start_date' => true,
        'sale_end_date' => true,
        'price_reduction_price' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'item_location_detail_id' => 'itemLocationDetailId',
        'item_master_id' => 'itemMasterId',
        'sku' => 'sku',
        'barcode_number' => 'barcodeNumber',
        'description' => 'description',
        'msrp' => 'msrp',
        'price_inc_tax' => 'priceIncTax',
        'price_a_inc_tax' => 'priceAIncTax',
        'price_b_inc_tax' => 'priceBIncTax',
        'price_c_inc_tax' => 'priceCIncTax',
        'price_exc_tax' => 'priceExcTax',
        'price_a_exc_tax' => 'priceAExcTax',
        'price_b_exc_tax' => 'priceBExcTax',
        'price_c_exc_tax' => 'priceCExcTax',
        'sale_price_inc_tax' => 'salePriceIncTax',
        'sale_price_exc_tax' => 'salePriceExcTax',
        'sale_start_date' => 'saleStartDate',
        'sale_end_date' => 'saleEndDate',
        'price_reduction_price' => 'priceReductionPrice'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'item_location_detail_id' => 'setItemLocationDetailId',
        'item_master_id' => 'setItemMasterId',
        'sku' => 'setSku',
        'barcode_number' => 'setBarcodeNumber',
        'description' => 'setDescription',
        'msrp' => 'setMsrp',
        'price_inc_tax' => 'setPriceIncTax',
        'price_a_inc_tax' => 'setPriceAIncTax',
        'price_b_inc_tax' => 'setPriceBIncTax',
        'price_c_inc_tax' => 'setPriceCIncTax',
        'price_exc_tax' => 'setPriceExcTax',
        'price_a_exc_tax' => 'setPriceAExcTax',
        'price_b_exc_tax' => 'setPriceBExcTax',
        'price_c_exc_tax' => 'setPriceCExcTax',
        'sale_price_inc_tax' => 'setSalePriceIncTax',
        'sale_price_exc_tax' => 'setSalePriceExcTax',
        'sale_start_date' => 'setSaleStartDate',
        'sale_end_date' => 'setSaleEndDate',
        'price_reduction_price' => 'setPriceReductionPrice'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'item_location_detail_id' => 'getItemLocationDetailId',
        'item_master_id' => 'getItemMasterId',
        'sku' => 'getSku',
        'barcode_number' => 'getBarcodeNumber',
        'description' => 'getDescription',
        'msrp' => 'getMsrp',
        'price_inc_tax' => 'getPriceIncTax',
        'price_a_inc_tax' => 'getPriceAIncTax',
        'price_b_inc_tax' => 'getPriceBIncTax',
        'price_c_inc_tax' => 'getPriceCIncTax',
        'price_exc_tax' => 'getPriceExcTax',
        'price_a_exc_tax' => 'getPriceAExcTax',
        'price_b_exc_tax' => 'getPriceBExcTax',
        'price_c_exc_tax' => 'getPriceCExcTax',
        'sale_price_inc_tax' => 'getSalePriceIncTax',
        'sale_price_exc_tax' => 'getSalePriceExcTax',
        'sale_start_date' => 'getSaleStartDate',
        'sale_end_date' => 'getSaleEndDate',
        'price_reduction_price' => 'getPriceReductionPrice'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('item_location_detail_id', $data ?? [], null);
        $this->setIfExists('item_master_id', $data ?? [], null);
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('barcode_number', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('msrp', $data ?? [], null);
        $this->setIfExists('price_inc_tax', $data ?? [], null);
        $this->setIfExists('price_a_inc_tax', $data ?? [], null);
        $this->setIfExists('price_b_inc_tax', $data ?? [], null);
        $this->setIfExists('price_c_inc_tax', $data ?? [], null);
        $this->setIfExists('price_exc_tax', $data ?? [], null);
        $this->setIfExists('price_a_exc_tax', $data ?? [], null);
        $this->setIfExists('price_b_exc_tax', $data ?? [], null);
        $this->setIfExists('price_c_exc_tax', $data ?? [], null);
        $this->setIfExists('sale_price_inc_tax', $data ?? [], null);
        $this->setIfExists('sale_price_exc_tax', $data ?? [], null);
        $this->setIfExists('sale_start_date', $data ?? [], null);
        $this->setIfExists('sale_end_date', $data ?? [], null);
        $this->setIfExists('price_reduction_price', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets item_location_detail_id
     *
     * @return int|null
     */
    public function getItemLocationDetailId()
    {
        return $this->container['item_location_detail_id'];
    }

    /**
     * Sets item_location_detail_id
     *
     * @param int|null $item_location_detail_id The id of the item.  Read only.
     *
     * @return self
     */
    public function setItemLocationDetailId($item_location_detail_id)
    {
        if (is_null($item_location_detail_id)) {
            throw new \InvalidArgumentException('non-nullable item_location_detail_id cannot be null');
        }
        $this->container['item_location_detail_id'] = $item_location_detail_id;

        return $this;
    }

    /**
     * Gets item_master_id
     *
     * @return int|null
     */
    public function getItemMasterId()
    {
        return $this->container['item_master_id'];
    }

    /**
     * Sets item_master_id
     *
     * @param int|null $item_master_id The id of the associated master record.  Read only except for new Items.
     *
     * @return self
     */
    public function setItemMasterId($item_master_id)
    {
        if (is_null($item_master_id)) {
            throw new \InvalidArgumentException('non-nullable item_master_id cannot be null');
        }
        $this->container['item_master_id'] = $item_master_id;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku The SKU of the item.  Read only.
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            array_push($this->openAPINullablesSetToNull, 'sku');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('sku', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets barcode_number
     *
     * @return string|null
     */
    public function getBarcodeNumber()
    {
        return $this->container['barcode_number'];
    }

    /**
     * Sets barcode_number
     *
     * @param string|null $barcode_number The barcode number of the item.  Read only.
     *
     * @return self
     */
    public function setBarcodeNumber($barcode_number)
    {
        if (is_null($barcode_number)) {
            array_push($this->openAPINullablesSetToNull, 'barcode_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('barcode_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['barcode_number'] = $barcode_number;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description The description of the item.  Read only depending upon settings.
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            array_push($this->openAPINullablesSetToNull, 'description');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('description', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets msrp
     *
     * @return float|null
     */
    public function getMsrp()
    {
        return $this->container['msrp'];
    }

    /**
     * Sets msrp
     *
     * @param float|null $msrp The manufactorers suggested retail price of the item.  Read only.
     *
     * @return self
     */
    public function setMsrp($msrp)
    {
        if (is_null($msrp)) {
            throw new \InvalidArgumentException('non-nullable msrp cannot be null');
        }
        $this->container['msrp'] = $msrp;

        return $this;
    }

    /**
     * Gets price_inc_tax
     *
     * @return float|null
     */
    public function getPriceIncTax()
    {
        return $this->container['price_inc_tax'];
    }

    /**
     * Sets price_inc_tax
     *
     * @param float|null $price_inc_tax The full price of the item inclusive of tax.  Read only depending upon settings.
     *
     * @return self
     */
    public function setPriceIncTax($price_inc_tax)
    {
        if (is_null($price_inc_tax)) {
            throw new \InvalidArgumentException('non-nullable price_inc_tax cannot be null');
        }
        $this->container['price_inc_tax'] = $price_inc_tax;

        return $this;
    }

    /**
     * Gets price_a_inc_tax
     *
     * @return float|null
     */
    public function getPriceAIncTax()
    {
        return $this->container['price_a_inc_tax'];
    }

    /**
     * Sets price_a_inc_tax
     *
     * @param float|null $price_a_inc_tax Price Level A price of the item inclusive of tax.  Read only depending upon settings.
     *
     * @return self
     */
    public function setPriceAIncTax($price_a_inc_tax)
    {
        if (is_null($price_a_inc_tax)) {
            throw new \InvalidArgumentException('non-nullable price_a_inc_tax cannot be null');
        }
        $this->container['price_a_inc_tax'] = $price_a_inc_tax;

        return $this;
    }

    /**
     * Gets price_b_inc_tax
     *
     * @return float|null
     */
    public function getPriceBIncTax()
    {
        return $this->container['price_b_inc_tax'];
    }

    /**
     * Sets price_b_inc_tax
     *
     * @param float|null $price_b_inc_tax Price Level B price of the item inclusive of tax.  Read only depending upon settings.
     *
     * @return self
     */
    public function setPriceBIncTax($price_b_inc_tax)
    {
        if (is_null($price_b_inc_tax)) {
            throw new \InvalidArgumentException('non-nullable price_b_inc_tax cannot be null');
        }
        $this->container['price_b_inc_tax'] = $price_b_inc_tax;

        return $this;
    }

    /**
     * Gets price_c_inc_tax
     *
     * @return float|null
     */
    public function getPriceCIncTax()
    {
        return $this->container['price_c_inc_tax'];
    }

    /**
     * Sets price_c_inc_tax
     *
     * @param float|null $price_c_inc_tax Price Level C price of the item inclusive of tax.  Read only depending upon settings.
     *
     * @return self
     */
    public function setPriceCIncTax($price_c_inc_tax)
    {
        if (is_null($price_c_inc_tax)) {
            throw new \InvalidArgumentException('non-nullable price_c_inc_tax cannot be null');
        }
        $this->container['price_c_inc_tax'] = $price_c_inc_tax;

        return $this;
    }

    /**
     * Gets price_exc_tax
     *
     * @return float|null
     */
    public function getPriceExcTax()
    {
        return $this->container['price_exc_tax'];
    }

    /**
     * Sets price_exc_tax
     *
     * @param float|null $price_exc_tax The full price of the item exclusive of tax.  Read only depending upon settings.
     *
     * @return self
     */
    public function setPriceExcTax($price_exc_tax)
    {
        if (is_null($price_exc_tax)) {
            throw new \InvalidArgumentException('non-nullable price_exc_tax cannot be null');
        }
        $this->container['price_exc_tax'] = $price_exc_tax;

        return $this;
    }

    /**
     * Gets price_a_exc_tax
     *
     * @return float|null
     */
    public function getPriceAExcTax()
    {
        return $this->container['price_a_exc_tax'];
    }

    /**
     * Sets price_a_exc_tax
     *
     * @param float|null $price_a_exc_tax Price Level A price of the item exclusive of tax.  Read only depending upon settings.
     *
     * @return self
     */
    public function setPriceAExcTax($price_a_exc_tax)
    {
        if (is_null($price_a_exc_tax)) {
            throw new \InvalidArgumentException('non-nullable price_a_exc_tax cannot be null');
        }
        $this->container['price_a_exc_tax'] = $price_a_exc_tax;

        return $this;
    }

    /**
     * Gets price_b_exc_tax
     *
     * @return float|null
     */
    public function getPriceBExcTax()
    {
        return $this->container['price_b_exc_tax'];
    }

    /**
     * Sets price_b_exc_tax
     *
     * @param float|null $price_b_exc_tax Price Level B price of the item exclusive of tax.  Read only depending upon settings.
     *
     * @return self
     */
    public function setPriceBExcTax($price_b_exc_tax)
    {
        if (is_null($price_b_exc_tax)) {
            throw new \InvalidArgumentException('non-nullable price_b_exc_tax cannot be null');
        }
        $this->container['price_b_exc_tax'] = $price_b_exc_tax;

        return $this;
    }

    /**
     * Gets price_c_exc_tax
     *
     * @return float|null
     */
    public function getPriceCExcTax()
    {
        return $this->container['price_c_exc_tax'];
    }

    /**
     * Sets price_c_exc_tax
     *
     * @param float|null $price_c_exc_tax Price Level C price of the item exclusive of tax.  Read only depending upon settings.
     *
     * @return self
     */
    public function setPriceCExcTax($price_c_exc_tax)
    {
        if (is_null($price_c_exc_tax)) {
            throw new \InvalidArgumentException('non-nullable price_c_exc_tax cannot be null');
        }
        $this->container['price_c_exc_tax'] = $price_c_exc_tax;

        return $this;
    }

    /**
     * Gets sale_price_inc_tax
     *
     * @return float|null
     */
    public function getSalePriceIncTax()
    {
        return $this->container['sale_price_inc_tax'];
    }

    /**
     * Sets sale_price_inc_tax
     *
     * @param float|null $sale_price_inc_tax The sale price of the item inclusive of tax if on sale  (see SaleStartDate and SaleEndDate)
     *
     * @return self
     */
    public function setSalePriceIncTax($sale_price_inc_tax)
    {
        if (is_null($sale_price_inc_tax)) {
            throw new \InvalidArgumentException('non-nullable sale_price_inc_tax cannot be null');
        }
        $this->container['sale_price_inc_tax'] = $sale_price_inc_tax;

        return $this;
    }

    /**
     * Gets sale_price_exc_tax
     *
     * @return float|null
     */
    public function getSalePriceExcTax()
    {
        return $this->container['sale_price_exc_tax'];
    }

    /**
     * Sets sale_price_exc_tax
     *
     * @param float|null $sale_price_exc_tax The sale price of the item exclusive of tax if on sale  (see SaleStartDate and SaleEndDate)
     *
     * @return self
     */
    public function setSalePriceExcTax($sale_price_exc_tax)
    {
        if (is_null($sale_price_exc_tax)) {
            throw new \InvalidArgumentException('non-nullable sale_price_exc_tax cannot be null');
        }
        $this->container['sale_price_exc_tax'] = $sale_price_exc_tax;

        return $this;
    }

    /**
     * Gets sale_start_date
     *
     * @return \DateTime|null
     */
    public function getSaleStartDate()
    {
        return $this->container['sale_start_date'];
    }

    /**
     * Sets sale_start_date
     *
     * @param \DateTime|null $sale_start_date The start date of the on sale period
     *
     * @return self
     */
    public function setSaleStartDate($sale_start_date)
    {
        if (is_null($sale_start_date)) {
            array_push($this->openAPINullablesSetToNull, 'sale_start_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('sale_start_date', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['sale_start_date'] = $sale_start_date;

        return $this;
    }

    /**
     * Gets sale_end_date
     *
     * @return \DateTime|null
     */
    public function getSaleEndDate()
    {
        return $this->container['sale_end_date'];
    }

    /**
     * Sets sale_end_date
     *
     * @param \DateTime|null $sale_end_date The end date of the on sale period
     *
     * @return self
     */
    public function setSaleEndDate($sale_end_date)
    {
        if (is_null($sale_end_date)) {
            array_push($this->openAPINullablesSetToNull, 'sale_end_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('sale_end_date', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['sale_end_date'] = $sale_end_date;

        return $this;
    }

    /**
     * Gets price_reduction_price
     *
     * @return float|null
     */
    public function getPriceReductionPrice()
    {
        return $this->container['price_reduction_price'];
    }

    /**
     * Sets price_reduction_price
     *
     * @param float|null $price_reduction_price Temporary reduced price of the item.  This field will be null  if there is no temporary reduced price.  Read only.
     *
     * @return self
     */
    public function setPriceReductionPrice($price_reduction_price)
    {
        if (is_null($price_reduction_price)) {
            array_push($this->openAPINullablesSetToNull, 'price_reduction_price');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('price_reduction_price', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['price_reduction_price'] = $price_reduction_price;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


