<?php
/**
 * InvoiceMatchingLine
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * InvoiceMatchingLine Class Doc Comment
 *
 * @category Class
 * @description Details of a line on a matched invoice
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class InvoiceMatchingLine implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'InvoiceMatchingLine';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'item_sku' => 'string',
        'item_description' => 'string',
        'tax_group_id' => 'int',
        'tax_group_name' => 'string',
        'supplier_cost' => 'float',
        'invoice_cost' => 'float',
        'item_tax' => 'float',
        'reorder_number' => 'string',
        'invoice_quantity' => 'float',
        'advised_quantity' => 'float',
        'quantity_received' => 'float',
        'reason_code' => 'string',
        'department_id' => 'int',
        'category_id' => 'int',
        'grn_id' => 'int',
        'grn_number' => 'string',
        'cost_reduction' => 'float',
        'adjusted_cost' => 'float'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'item_sku' => null,
        'item_description' => null,
        'tax_group_id' => 'int32',
        'tax_group_name' => null,
        'supplier_cost' => 'double',
        'invoice_cost' => 'double',
        'item_tax' => 'double',
        'reorder_number' => null,
        'invoice_quantity' => 'double',
        'advised_quantity' => 'double',
        'quantity_received' => 'double',
        'reason_code' => null,
        'department_id' => 'int32',
        'category_id' => 'int32',
        'grn_id' => 'int32',
        'grn_number' => null,
        'cost_reduction' => 'double',
        'adjusted_cost' => 'double'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'item_sku' => true,
        'item_description' => true,
        'tax_group_id' => true,
        'tax_group_name' => true,
        'supplier_cost' => true,
        'invoice_cost' => false,
        'item_tax' => false,
        'reorder_number' => true,
        'invoice_quantity' => false,
        'advised_quantity' => true,
        'quantity_received' => true,
        'reason_code' => true,
        'department_id' => false,
        'category_id' => false,
        'grn_id' => true,
        'grn_number' => true,
        'cost_reduction' => true,
        'adjusted_cost' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'item_sku' => 'itemSku',
        'item_description' => 'itemDescription',
        'tax_group_id' => 'taxGroupId',
        'tax_group_name' => 'taxGroupName',
        'supplier_cost' => 'supplierCost',
        'invoice_cost' => 'invoiceCost',
        'item_tax' => 'itemTax',
        'reorder_number' => 'reorderNumber',
        'invoice_quantity' => 'invoiceQuantity',
        'advised_quantity' => 'advisedQuantity',
        'quantity_received' => 'quantityReceived',
        'reason_code' => 'reasonCode',
        'department_id' => 'departmentId',
        'category_id' => 'categoryId',
        'grn_id' => 'grnId',
        'grn_number' => 'grnNumber',
        'cost_reduction' => 'costReduction',
        'adjusted_cost' => 'adjustedCost'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'item_sku' => 'setItemSku',
        'item_description' => 'setItemDescription',
        'tax_group_id' => 'setTaxGroupId',
        'tax_group_name' => 'setTaxGroupName',
        'supplier_cost' => 'setSupplierCost',
        'invoice_cost' => 'setInvoiceCost',
        'item_tax' => 'setItemTax',
        'reorder_number' => 'setReorderNumber',
        'invoice_quantity' => 'setInvoiceQuantity',
        'advised_quantity' => 'setAdvisedQuantity',
        'quantity_received' => 'setQuantityReceived',
        'reason_code' => 'setReasonCode',
        'department_id' => 'setDepartmentId',
        'category_id' => 'setCategoryId',
        'grn_id' => 'setGrnId',
        'grn_number' => 'setGrnNumber',
        'cost_reduction' => 'setCostReduction',
        'adjusted_cost' => 'setAdjustedCost'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'item_sku' => 'getItemSku',
        'item_description' => 'getItemDescription',
        'tax_group_id' => 'getTaxGroupId',
        'tax_group_name' => 'getTaxGroupName',
        'supplier_cost' => 'getSupplierCost',
        'invoice_cost' => 'getInvoiceCost',
        'item_tax' => 'getItemTax',
        'reorder_number' => 'getReorderNumber',
        'invoice_quantity' => 'getInvoiceQuantity',
        'advised_quantity' => 'getAdvisedQuantity',
        'quantity_received' => 'getQuantityReceived',
        'reason_code' => 'getReasonCode',
        'department_id' => 'getDepartmentId',
        'category_id' => 'getCategoryId',
        'grn_id' => 'getGrnId',
        'grn_number' => 'getGrnNumber',
        'cost_reduction' => 'getCostReduction',
        'adjusted_cost' => 'getAdjustedCost'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('item_sku', $data ?? [], null);
        $this->setIfExists('item_description', $data ?? [], null);
        $this->setIfExists('tax_group_id', $data ?? [], null);
        $this->setIfExists('tax_group_name', $data ?? [], null);
        $this->setIfExists('supplier_cost', $data ?? [], null);
        $this->setIfExists('invoice_cost', $data ?? [], null);
        $this->setIfExists('item_tax', $data ?? [], null);
        $this->setIfExists('reorder_number', $data ?? [], null);
        $this->setIfExists('invoice_quantity', $data ?? [], null);
        $this->setIfExists('advised_quantity', $data ?? [], null);
        $this->setIfExists('quantity_received', $data ?? [], null);
        $this->setIfExists('reason_code', $data ?? [], null);
        $this->setIfExists('department_id', $data ?? [], null);
        $this->setIfExists('category_id', $data ?? [], null);
        $this->setIfExists('grn_id', $data ?? [], null);
        $this->setIfExists('grn_number', $data ?? [], null);
        $this->setIfExists('cost_reduction', $data ?? [], null);
        $this->setIfExists('adjusted_cost', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets item_sku
     *
     * @return string|null
     */
    public function getItemSku()
    {
        return $this->container['item_sku'];
    }

    /**
     * Sets item_sku
     *
     * @param string|null $item_sku The item sku
     *
     * @return self
     */
    public function setItemSku($item_sku)
    {
        if (is_null($item_sku)) {
            array_push($this->openAPINullablesSetToNull, 'item_sku');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('item_sku', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['item_sku'] = $item_sku;

        return $this;
    }

    /**
     * Gets item_description
     *
     * @return string|null
     */
    public function getItemDescription()
    {
        return $this->container['item_description'];
    }

    /**
     * Sets item_description
     *
     * @param string|null $item_description The item description
     *
     * @return self
     */
    public function setItemDescription($item_description)
    {
        if (is_null($item_description)) {
            array_push($this->openAPINullablesSetToNull, 'item_description');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('item_description', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['item_description'] = $item_description;

        return $this;
    }

    /**
     * Gets tax_group_id
     *
     * @return int|null
     */
    public function getTaxGroupId()
    {
        return $this->container['tax_group_id'];
    }

    /**
     * Sets tax_group_id
     *
     * @param int|null $tax_group_id The item's tax group id
     *
     * @return self
     */
    public function setTaxGroupId($tax_group_id)
    {
        if (is_null($tax_group_id)) {
            array_push($this->openAPINullablesSetToNull, 'tax_group_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('tax_group_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['tax_group_id'] = $tax_group_id;

        return $this;
    }

    /**
     * Gets tax_group_name
     *
     * @return string|null
     */
    public function getTaxGroupName()
    {
        return $this->container['tax_group_name'];
    }

    /**
     * Sets tax_group_name
     *
     * @param string|null $tax_group_name The item's tax group name
     *
     * @return self
     */
    public function setTaxGroupName($tax_group_name)
    {
        if (is_null($tax_group_name)) {
            array_push($this->openAPINullablesSetToNull, 'tax_group_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('tax_group_name', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['tax_group_name'] = $tax_group_name;

        return $this;
    }

    /**
     * Gets supplier_cost
     *
     * @return float|null
     */
    public function getSupplierCost()
    {
        return $this->container['supplier_cost'];
    }

    /**
     * Sets supplier_cost
     *
     * @param float|null $supplier_cost The supplier cost of the item
     *
     * @return self
     */
    public function setSupplierCost($supplier_cost)
    {
        if (is_null($supplier_cost)) {
            array_push($this->openAPINullablesSetToNull, 'supplier_cost');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('supplier_cost', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['supplier_cost'] = $supplier_cost;

        return $this;
    }

    /**
     * Gets invoice_cost
     *
     * @return float|null
     */
    public function getInvoiceCost()
    {
        return $this->container['invoice_cost'];
    }

    /**
     * Sets invoice_cost
     *
     * @param float|null $invoice_cost The invoice cost of the item
     *
     * @return self
     */
    public function setInvoiceCost($invoice_cost)
    {
        if (is_null($invoice_cost)) {
            throw new \InvalidArgumentException('non-nullable invoice_cost cannot be null');
        }
        $this->container['invoice_cost'] = $invoice_cost;

        return $this;
    }

    /**
     * Gets item_tax
     *
     * @return float|null
     */
    public function getItemTax()
    {
        return $this->container['item_tax'];
    }

    /**
     * Sets item_tax
     *
     * @param float|null $item_tax The item tax
     *
     * @return self
     */
    public function setItemTax($item_tax)
    {
        if (is_null($item_tax)) {
            throw new \InvalidArgumentException('non-nullable item_tax cannot be null');
        }
        $this->container['item_tax'] = $item_tax;

        return $this;
    }

    /**
     * Gets reorder_number
     *
     * @return string|null
     */
    public function getReorderNumber()
    {
        return $this->container['reorder_number'];
    }

    /**
     * Sets reorder_number
     *
     * @param string|null $reorder_number The supplier's reorder number for the item
     *
     * @return self
     */
    public function setReorderNumber($reorder_number)
    {
        if (is_null($reorder_number)) {
            array_push($this->openAPINullablesSetToNull, 'reorder_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('reorder_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['reorder_number'] = $reorder_number;

        return $this;
    }

    /**
     * Gets invoice_quantity
     *
     * @return float|null
     */
    public function getInvoiceQuantity()
    {
        return $this->container['invoice_quantity'];
    }

    /**
     * Sets invoice_quantity
     *
     * @param float|null $invoice_quantity The quantity invoiced
     *
     * @return self
     */
    public function setInvoiceQuantity($invoice_quantity)
    {
        if (is_null($invoice_quantity)) {
            throw new \InvalidArgumentException('non-nullable invoice_quantity cannot be null');
        }
        $this->container['invoice_quantity'] = $invoice_quantity;

        return $this;
    }

    /**
     * Gets advised_quantity
     *
     * @return float|null
     */
    public function getAdvisedQuantity()
    {
        return $this->container['advised_quantity'];
    }

    /**
     * Sets advised_quantity
     *
     * @param float|null $advised_quantity The quantity sent
     *
     * @return self
     */
    public function setAdvisedQuantity($advised_quantity)
    {
        if (is_null($advised_quantity)) {
            array_push($this->openAPINullablesSetToNull, 'advised_quantity');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('advised_quantity', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['advised_quantity'] = $advised_quantity;

        return $this;
    }

    /**
     * Gets quantity_received
     *
     * @return float|null
     */
    public function getQuantityReceived()
    {
        return $this->container['quantity_received'];
    }

    /**
     * Sets quantity_received
     *
     * @param float|null $quantity_received The quantity received
     *
     * @return self
     */
    public function setQuantityReceived($quantity_received)
    {
        if (is_null($quantity_received)) {
            array_push($this->openAPINullablesSetToNull, 'quantity_received');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('quantity_received', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['quantity_received'] = $quantity_received;

        return $this;
    }

    /**
     * Gets reason_code
     *
     * @return string|null
     */
    public function getReasonCode()
    {
        return $this->container['reason_code'];
    }

    /**
     * Sets reason_code
     *
     * @param string|null $reason_code The cost reduction reason code
     *
     * @return self
     */
    public function setReasonCode($reason_code)
    {
        if (is_null($reason_code)) {
            array_push($this->openAPINullablesSetToNull, 'reason_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('reason_code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['reason_code'] = $reason_code;

        return $this;
    }

    /**
     * Gets department_id
     *
     * @return int|null
     */
    public function getDepartmentId()
    {
        return $this->container['department_id'];
    }

    /**
     * Sets department_id
     *
     * @param int|null $department_id The item's department id
     *
     * @return self
     */
    public function setDepartmentId($department_id)
    {
        if (is_null($department_id)) {
            throw new \InvalidArgumentException('non-nullable department_id cannot be null');
        }
        $this->container['department_id'] = $department_id;

        return $this;
    }

    /**
     * Gets category_id
     *
     * @return int|null
     */
    public function getCategoryId()
    {
        return $this->container['category_id'];
    }

    /**
     * Sets category_id
     *
     * @param int|null $category_id The item's category id
     *
     * @return self
     */
    public function setCategoryId($category_id)
    {
        if (is_null($category_id)) {
            throw new \InvalidArgumentException('non-nullable category_id cannot be null');
        }
        $this->container['category_id'] = $category_id;

        return $this;
    }

    /**
     * Gets grn_id
     *
     * @return int|null
     */
    public function getGrnId()
    {
        return $this->container['grn_id'];
    }

    /**
     * Sets grn_id
     *
     * @param int|null $grn_id The id of the receiving document this item is on
     *
     * @return self
     */
    public function setGrnId($grn_id)
    {
        if (is_null($grn_id)) {
            array_push($this->openAPINullablesSetToNull, 'grn_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('grn_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['grn_id'] = $grn_id;

        return $this;
    }

    /**
     * Gets grn_number
     *
     * @return string|null
     */
    public function getGrnNumber()
    {
        return $this->container['grn_number'];
    }

    /**
     * Sets grn_number
     *
     * @param string|null $grn_number The number of the receiving document this item is on
     *
     * @return self
     */
    public function setGrnNumber($grn_number)
    {
        if (is_null($grn_number)) {
            array_push($this->openAPINullablesSetToNull, 'grn_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('grn_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['grn_number'] = $grn_number;

        return $this;
    }

    /**
     * Gets cost_reduction
     *
     * @return float|null
     */
    public function getCostReduction()
    {
        return $this->container['cost_reduction'];
    }

    /**
     * Sets cost_reduction
     *
     * @param float|null $cost_reduction Any cost reduction applied by a monetary credit note
     *
     * @return self
     */
    public function setCostReduction($cost_reduction)
    {
        if (is_null($cost_reduction)) {
            array_push($this->openAPINullablesSetToNull, 'cost_reduction');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('cost_reduction', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['cost_reduction'] = $cost_reduction;

        return $this;
    }

    /**
     * Gets adjusted_cost
     *
     * @return float|null
     */
    public function getAdjustedCost()
    {
        return $this->container['adjusted_cost'];
    }

    /**
     * Sets adjusted_cost
     *
     * @param float|null $adjusted_cost The adjusted cost after applying the cost reduction
     *
     * @return self
     */
    public function setAdjustedCost($adjusted_cost)
    {
        if (is_null($adjusted_cost)) {
            array_push($this->openAPINullablesSetToNull, 'adjusted_cost');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('adjusted_cost', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['adjusted_cost'] = $adjusted_cost;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


