<?php
/**
 * InvoiceMatching
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * InvoiceMatching Class Doc Comment
 *
 * @category Class
 * @description Details of a matched invoice
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class InvoiceMatching implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'InvoiceMatching';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'invoice_id' => 'int',
        'invoice_number' => 'string',
        'invoice_type' => '\Opsuite2\Model\InvoiceTypeEnum',
        'invoice_date' => '\DateTime',
        'date_created' => '\DateTime',
        'supplier_id' => 'int',
        'supplier_name' => 'string',
        'status' => '\Opsuite2\Model\InvoiceStatusTypeEnum',
        'supplier_invoice_number' => 'string',
        'settlement_discount' => 'float',
        'update_supplier_cost' => 'bool',
        'document_net_value' => 'float',
        'document_delivery_charge' => 'float',
        'document_total_tax' => 'float',
        'document_total_value' => 'float',
        'invoice_net_value' => 'float',
        'invoice_delivery_charge' => 'float',
        'invoice_total_tax' => 'float',
        'invoice_total_value' => 'float',
        'difference_net_value' => 'float',
        'difference_delivery_charge' => 'float',
        'difference_total_tax' => 'float',
        'difference_total_value' => 'float',
        'grn_net_value' => 'float',
        'grn_delivery_charge' => 'float',
        'grn_total_value' => 'float',
        'matched_grns' => '\Opsuite2\Model\GRNSummary[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'invoice_id' => 'int32',
        'invoice_number' => null,
        'invoice_type' => null,
        'invoice_date' => 'date-time',
        'date_created' => 'date-time',
        'supplier_id' => 'int32',
        'supplier_name' => null,
        'status' => null,
        'supplier_invoice_number' => null,
        'settlement_discount' => 'double',
        'update_supplier_cost' => null,
        'document_net_value' => 'double',
        'document_delivery_charge' => 'double',
        'document_total_tax' => 'double',
        'document_total_value' => 'double',
        'invoice_net_value' => 'double',
        'invoice_delivery_charge' => 'double',
        'invoice_total_tax' => 'double',
        'invoice_total_value' => 'double',
        'difference_net_value' => 'double',
        'difference_delivery_charge' => 'double',
        'difference_total_tax' => 'double',
        'difference_total_value' => 'double',
        'grn_net_value' => 'double',
        'grn_delivery_charge' => 'double',
        'grn_total_value' => 'double',
        'matched_grns' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'invoice_id' => false,
        'invoice_number' => true,
        'invoice_type' => false,
        'invoice_date' => false,
        'date_created' => false,
        'supplier_id' => false,
        'supplier_name' => true,
        'status' => false,
        'supplier_invoice_number' => true,
        'settlement_discount' => false,
        'update_supplier_cost' => false,
        'document_net_value' => false,
        'document_delivery_charge' => false,
        'document_total_tax' => false,
        'document_total_value' => false,
        'invoice_net_value' => false,
        'invoice_delivery_charge' => false,
        'invoice_total_tax' => false,
        'invoice_total_value' => false,
        'difference_net_value' => false,
        'difference_delivery_charge' => false,
        'difference_total_tax' => false,
        'difference_total_value' => false,
        'grn_net_value' => false,
        'grn_delivery_charge' => false,
        'grn_total_value' => false,
        'matched_grns' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'invoice_id' => 'invoiceId',
        'invoice_number' => 'invoiceNumber',
        'invoice_type' => 'invoiceType',
        'invoice_date' => 'invoiceDate',
        'date_created' => 'dateCreated',
        'supplier_id' => 'supplierId',
        'supplier_name' => 'supplierName',
        'status' => 'status',
        'supplier_invoice_number' => 'supplierInvoiceNumber',
        'settlement_discount' => 'settlementDiscount',
        'update_supplier_cost' => 'updateSupplierCost',
        'document_net_value' => 'documentNetValue',
        'document_delivery_charge' => 'documentDeliveryCharge',
        'document_total_tax' => 'documentTotalTax',
        'document_total_value' => 'documentTotalValue',
        'invoice_net_value' => 'invoiceNetValue',
        'invoice_delivery_charge' => 'invoiceDeliveryCharge',
        'invoice_total_tax' => 'invoiceTotalTax',
        'invoice_total_value' => 'invoiceTotalValue',
        'difference_net_value' => 'differenceNetValue',
        'difference_delivery_charge' => 'differenceDeliveryCharge',
        'difference_total_tax' => 'differenceTotalTax',
        'difference_total_value' => 'differenceTotalValue',
        'grn_net_value' => 'grnNetValue',
        'grn_delivery_charge' => 'grnDeliveryCharge',
        'grn_total_value' => 'grnTotalValue',
        'matched_grns' => 'matchedGRNs'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'invoice_id' => 'setInvoiceId',
        'invoice_number' => 'setInvoiceNumber',
        'invoice_type' => 'setInvoiceType',
        'invoice_date' => 'setInvoiceDate',
        'date_created' => 'setDateCreated',
        'supplier_id' => 'setSupplierId',
        'supplier_name' => 'setSupplierName',
        'status' => 'setStatus',
        'supplier_invoice_number' => 'setSupplierInvoiceNumber',
        'settlement_discount' => 'setSettlementDiscount',
        'update_supplier_cost' => 'setUpdateSupplierCost',
        'document_net_value' => 'setDocumentNetValue',
        'document_delivery_charge' => 'setDocumentDeliveryCharge',
        'document_total_tax' => 'setDocumentTotalTax',
        'document_total_value' => 'setDocumentTotalValue',
        'invoice_net_value' => 'setInvoiceNetValue',
        'invoice_delivery_charge' => 'setInvoiceDeliveryCharge',
        'invoice_total_tax' => 'setInvoiceTotalTax',
        'invoice_total_value' => 'setInvoiceTotalValue',
        'difference_net_value' => 'setDifferenceNetValue',
        'difference_delivery_charge' => 'setDifferenceDeliveryCharge',
        'difference_total_tax' => 'setDifferenceTotalTax',
        'difference_total_value' => 'setDifferenceTotalValue',
        'grn_net_value' => 'setGrnNetValue',
        'grn_delivery_charge' => 'setGrnDeliveryCharge',
        'grn_total_value' => 'setGrnTotalValue',
        'matched_grns' => 'setMatchedGrns'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'invoice_id' => 'getInvoiceId',
        'invoice_number' => 'getInvoiceNumber',
        'invoice_type' => 'getInvoiceType',
        'invoice_date' => 'getInvoiceDate',
        'date_created' => 'getDateCreated',
        'supplier_id' => 'getSupplierId',
        'supplier_name' => 'getSupplierName',
        'status' => 'getStatus',
        'supplier_invoice_number' => 'getSupplierInvoiceNumber',
        'settlement_discount' => 'getSettlementDiscount',
        'update_supplier_cost' => 'getUpdateSupplierCost',
        'document_net_value' => 'getDocumentNetValue',
        'document_delivery_charge' => 'getDocumentDeliveryCharge',
        'document_total_tax' => 'getDocumentTotalTax',
        'document_total_value' => 'getDocumentTotalValue',
        'invoice_net_value' => 'getInvoiceNetValue',
        'invoice_delivery_charge' => 'getInvoiceDeliveryCharge',
        'invoice_total_tax' => 'getInvoiceTotalTax',
        'invoice_total_value' => 'getInvoiceTotalValue',
        'difference_net_value' => 'getDifferenceNetValue',
        'difference_delivery_charge' => 'getDifferenceDeliveryCharge',
        'difference_total_tax' => 'getDifferenceTotalTax',
        'difference_total_value' => 'getDifferenceTotalValue',
        'grn_net_value' => 'getGrnNetValue',
        'grn_delivery_charge' => 'getGrnDeliveryCharge',
        'grn_total_value' => 'getGrnTotalValue',
        'matched_grns' => 'getMatchedGrns'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('invoice_id', $data ?? [], null);
        $this->setIfExists('invoice_number', $data ?? [], null);
        $this->setIfExists('invoice_type', $data ?? [], null);
        $this->setIfExists('invoice_date', $data ?? [], null);
        $this->setIfExists('date_created', $data ?? [], null);
        $this->setIfExists('supplier_id', $data ?? [], null);
        $this->setIfExists('supplier_name', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('supplier_invoice_number', $data ?? [], null);
        $this->setIfExists('settlement_discount', $data ?? [], null);
        $this->setIfExists('update_supplier_cost', $data ?? [], null);
        $this->setIfExists('document_net_value', $data ?? [], null);
        $this->setIfExists('document_delivery_charge', $data ?? [], null);
        $this->setIfExists('document_total_tax', $data ?? [], null);
        $this->setIfExists('document_total_value', $data ?? [], null);
        $this->setIfExists('invoice_net_value', $data ?? [], null);
        $this->setIfExists('invoice_delivery_charge', $data ?? [], null);
        $this->setIfExists('invoice_total_tax', $data ?? [], null);
        $this->setIfExists('invoice_total_value', $data ?? [], null);
        $this->setIfExists('difference_net_value', $data ?? [], null);
        $this->setIfExists('difference_delivery_charge', $data ?? [], null);
        $this->setIfExists('difference_total_tax', $data ?? [], null);
        $this->setIfExists('difference_total_value', $data ?? [], null);
        $this->setIfExists('grn_net_value', $data ?? [], null);
        $this->setIfExists('grn_delivery_charge', $data ?? [], null);
        $this->setIfExists('grn_total_value', $data ?? [], null);
        $this->setIfExists('matched_grns', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets invoice_id
     *
     * @return int|null
     */
    public function getInvoiceId()
    {
        return $this->container['invoice_id'];
    }

    /**
     * Sets invoice_id
     *
     * @param int|null $invoice_id The invoice id
     *
     * @return self
     */
    public function setInvoiceId($invoice_id)
    {
        if (is_null($invoice_id)) {
            throw new \InvalidArgumentException('non-nullable invoice_id cannot be null');
        }
        $this->container['invoice_id'] = $invoice_id;

        return $this;
    }

    /**
     * Gets invoice_number
     *
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->container['invoice_number'];
    }

    /**
     * Sets invoice_number
     *
     * @param string|null $invoice_number Invoice number
     *
     * @return self
     */
    public function setInvoiceNumber($invoice_number)
    {
        if (is_null($invoice_number)) {
            array_push($this->openAPINullablesSetToNull, 'invoice_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('invoice_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['invoice_number'] = $invoice_number;

        return $this;
    }

    /**
     * Gets invoice_type
     *
     * @return \Opsuite2\Model\InvoiceTypeEnum|null
     */
    public function getInvoiceType()
    {
        return $this->container['invoice_type'];
    }

    /**
     * Sets invoice_type
     *
     * @param \Opsuite2\Model\InvoiceTypeEnum|null $invoice_type invoice_type
     *
     * @return self
     */
    public function setInvoiceType($invoice_type)
    {
        if (is_null($invoice_type)) {
            throw new \InvalidArgumentException('non-nullable invoice_type cannot be null');
        }
        $this->container['invoice_type'] = $invoice_type;

        return $this;
    }

    /**
     * Gets invoice_date
     *
     * @return \DateTime|null
     */
    public function getInvoiceDate()
    {
        return $this->container['invoice_date'];
    }

    /**
     * Sets invoice_date
     *
     * @param \DateTime|null $invoice_date Invoice date
     *
     * @return self
     */
    public function setInvoiceDate($invoice_date)
    {
        if (is_null($invoice_date)) {
            throw new \InvalidArgumentException('non-nullable invoice_date cannot be null');
        }
        $this->container['invoice_date'] = $invoice_date;

        return $this;
    }

    /**
     * Gets date_created
     *
     * @return \DateTime|null
     */
    public function getDateCreated()
    {
        return $this->container['date_created'];
    }

    /**
     * Sets date_created
     *
     * @param \DateTime|null $date_created Date created
     *
     * @return self
     */
    public function setDateCreated($date_created)
    {
        if (is_null($date_created)) {
            throw new \InvalidArgumentException('non-nullable date_created cannot be null');
        }
        $this->container['date_created'] = $date_created;

        return $this;
    }

    /**
     * Gets supplier_id
     *
     * @return int|null
     */
    public function getSupplierId()
    {
        return $this->container['supplier_id'];
    }

    /**
     * Sets supplier_id
     *
     * @param int|null $supplier_id Invoice supplier id
     *
     * @return self
     */
    public function setSupplierId($supplier_id)
    {
        if (is_null($supplier_id)) {
            throw new \InvalidArgumentException('non-nullable supplier_id cannot be null');
        }
        $this->container['supplier_id'] = $supplier_id;

        return $this;
    }

    /**
     * Gets supplier_name
     *
     * @return string|null
     */
    public function getSupplierName()
    {
        return $this->container['supplier_name'];
    }

    /**
     * Sets supplier_name
     *
     * @param string|null $supplier_name Invoice supplier name
     *
     * @return self
     */
    public function setSupplierName($supplier_name)
    {
        if (is_null($supplier_name)) {
            array_push($this->openAPINullablesSetToNull, 'supplier_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('supplier_name', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['supplier_name'] = $supplier_name;

        return $this;
    }

    /**
     * Gets status
     *
     * @return \Opsuite2\Model\InvoiceStatusTypeEnum|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param \Opsuite2\Model\InvoiceStatusTypeEnum|null $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets supplier_invoice_number
     *
     * @return string|null
     */
    public function getSupplierInvoiceNumber()
    {
        return $this->container['supplier_invoice_number'];
    }

    /**
     * Sets supplier_invoice_number
     *
     * @param string|null $supplier_invoice_number Supplier's invoice number
     *
     * @return self
     */
    public function setSupplierInvoiceNumber($supplier_invoice_number)
    {
        if (is_null($supplier_invoice_number)) {
            array_push($this->openAPINullablesSetToNull, 'supplier_invoice_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('supplier_invoice_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['supplier_invoice_number'] = $supplier_invoice_number;

        return $this;
    }

    /**
     * Gets settlement_discount
     *
     * @return float|null
     */
    public function getSettlementDiscount()
    {
        return $this->container['settlement_discount'];
    }

    /**
     * Sets settlement_discount
     *
     * @param float|null $settlement_discount Any settlement discount applied to the invoice
     *
     * @return self
     */
    public function setSettlementDiscount($settlement_discount)
    {
        if (is_null($settlement_discount)) {
            throw new \InvalidArgumentException('non-nullable settlement_discount cannot be null');
        }
        $this->container['settlement_discount'] = $settlement_discount;

        return $this;
    }

    /**
     * Gets update_supplier_cost
     *
     * @return bool|null
     */
    public function getUpdateSupplierCost()
    {
        return $this->container['update_supplier_cost'];
    }

    /**
     * Sets update_supplier_cost
     *
     * @param bool|null $update_supplier_cost Whether this invoice will update or has updated the supplier cost on the items
     *
     * @return self
     */
    public function setUpdateSupplierCost($update_supplier_cost)
    {
        if (is_null($update_supplier_cost)) {
            throw new \InvalidArgumentException('non-nullable update_supplier_cost cannot be null');
        }
        $this->container['update_supplier_cost'] = $update_supplier_cost;

        return $this;
    }

    /**
     * Gets document_net_value
     *
     * @return float|null
     */
    public function getDocumentNetValue()
    {
        return $this->container['document_net_value'];
    }

    /**
     * Sets document_net_value
     *
     * @param float|null $document_net_value The value on the invoice
     *
     * @return self
     */
    public function setDocumentNetValue($document_net_value)
    {
        if (is_null($document_net_value)) {
            throw new \InvalidArgumentException('non-nullable document_net_value cannot be null');
        }
        $this->container['document_net_value'] = $document_net_value;

        return $this;
    }

    /**
     * Gets document_delivery_charge
     *
     * @return float|null
     */
    public function getDocumentDeliveryCharge()
    {
        return $this->container['document_delivery_charge'];
    }

    /**
     * Sets document_delivery_charge
     *
     * @param float|null $document_delivery_charge The delivery charge on the invoice
     *
     * @return self
     */
    public function setDocumentDeliveryCharge($document_delivery_charge)
    {
        if (is_null($document_delivery_charge)) {
            throw new \InvalidArgumentException('non-nullable document_delivery_charge cannot be null');
        }
        $this->container['document_delivery_charge'] = $document_delivery_charge;

        return $this;
    }

    /**
     * Gets document_total_tax
     *
     * @return float|null
     */
    public function getDocumentTotalTax()
    {
        return $this->container['document_total_tax'];
    }

    /**
     * Sets document_total_tax
     *
     * @param float|null $document_total_tax The total tax on the invoice
     *
     * @return self
     */
    public function setDocumentTotalTax($document_total_tax)
    {
        if (is_null($document_total_tax)) {
            throw new \InvalidArgumentException('non-nullable document_total_tax cannot be null');
        }
        $this->container['document_total_tax'] = $document_total_tax;

        return $this;
    }

    /**
     * Gets document_total_value
     *
     * @return float|null
     */
    public function getDocumentTotalValue()
    {
        return $this->container['document_total_value'];
    }

    /**
     * Sets document_total_value
     *
     * @param float|null $document_total_value The total value on the invoice
     *
     * @return self
     */
    public function setDocumentTotalValue($document_total_value)
    {
        if (is_null($document_total_value)) {
            throw new \InvalidArgumentException('non-nullable document_total_value cannot be null');
        }
        $this->container['document_total_value'] = $document_total_value;

        return $this;
    }

    /**
     * Gets invoice_net_value
     *
     * @return float|null
     */
    public function getInvoiceNetValue()
    {
        return $this->container['invoice_net_value'];
    }

    /**
     * Sets invoice_net_value
     *
     * @param float|null $invoice_net_value The actual value of the invoice
     *
     * @return self
     */
    public function setInvoiceNetValue($invoice_net_value)
    {
        if (is_null($invoice_net_value)) {
            throw new \InvalidArgumentException('non-nullable invoice_net_value cannot be null');
        }
        $this->container['invoice_net_value'] = $invoice_net_value;

        return $this;
    }

    /**
     * Gets invoice_delivery_charge
     *
     * @return float|null
     */
    public function getInvoiceDeliveryCharge()
    {
        return $this->container['invoice_delivery_charge'];
    }

    /**
     * Sets invoice_delivery_charge
     *
     * @param float|null $invoice_delivery_charge The actual delivery charge
     *
     * @return self
     */
    public function setInvoiceDeliveryCharge($invoice_delivery_charge)
    {
        if (is_null($invoice_delivery_charge)) {
            throw new \InvalidArgumentException('non-nullable invoice_delivery_charge cannot be null');
        }
        $this->container['invoice_delivery_charge'] = $invoice_delivery_charge;

        return $this;
    }

    /**
     * Gets invoice_total_tax
     *
     * @return float|null
     */
    public function getInvoiceTotalTax()
    {
        return $this->container['invoice_total_tax'];
    }

    /**
     * Sets invoice_total_tax
     *
     * @param float|null $invoice_total_tax The actual total tax
     *
     * @return self
     */
    public function setInvoiceTotalTax($invoice_total_tax)
    {
        if (is_null($invoice_total_tax)) {
            throw new \InvalidArgumentException('non-nullable invoice_total_tax cannot be null');
        }
        $this->container['invoice_total_tax'] = $invoice_total_tax;

        return $this;
    }

    /**
     * Gets invoice_total_value
     *
     * @return float|null
     */
    public function getInvoiceTotalValue()
    {
        return $this->container['invoice_total_value'];
    }

    /**
     * Sets invoice_total_value
     *
     * @param float|null $invoice_total_value The actual total value
     *
     * @return self
     */
    public function setInvoiceTotalValue($invoice_total_value)
    {
        if (is_null($invoice_total_value)) {
            throw new \InvalidArgumentException('non-nullable invoice_total_value cannot be null');
        }
        $this->container['invoice_total_value'] = $invoice_total_value;

        return $this;
    }

    /**
     * Gets difference_net_value
     *
     * @return float|null
     */
    public function getDifferenceNetValue()
    {
        return $this->container['difference_net_value'];
    }

    /**
     * Sets difference_net_value
     *
     * @param float|null $difference_net_value The difference between the actual value and documented value
     *
     * @return self
     */
    public function setDifferenceNetValue($difference_net_value)
    {
        if (is_null($difference_net_value)) {
            throw new \InvalidArgumentException('non-nullable difference_net_value cannot be null');
        }
        $this->container['difference_net_value'] = $difference_net_value;

        return $this;
    }

    /**
     * Gets difference_delivery_charge
     *
     * @return float|null
     */
    public function getDifferenceDeliveryCharge()
    {
        return $this->container['difference_delivery_charge'];
    }

    /**
     * Sets difference_delivery_charge
     *
     * @param float|null $difference_delivery_charge The difference between the actual delivery charge and documented delivery charge
     *
     * @return self
     */
    public function setDifferenceDeliveryCharge($difference_delivery_charge)
    {
        if (is_null($difference_delivery_charge)) {
            throw new \InvalidArgumentException('non-nullable difference_delivery_charge cannot be null');
        }
        $this->container['difference_delivery_charge'] = $difference_delivery_charge;

        return $this;
    }

    /**
     * Gets difference_total_tax
     *
     * @return float|null
     */
    public function getDifferenceTotalTax()
    {
        return $this->container['difference_total_tax'];
    }

    /**
     * Sets difference_total_tax
     *
     * @param float|null $difference_total_tax The difference between the actual total tax and documented total tax
     *
     * @return self
     */
    public function setDifferenceTotalTax($difference_total_tax)
    {
        if (is_null($difference_total_tax)) {
            throw new \InvalidArgumentException('non-nullable difference_total_tax cannot be null');
        }
        $this->container['difference_total_tax'] = $difference_total_tax;

        return $this;
    }

    /**
     * Gets difference_total_value
     *
     * @return float|null
     */
    public function getDifferenceTotalValue()
    {
        return $this->container['difference_total_value'];
    }

    /**
     * Sets difference_total_value
     *
     * @param float|null $difference_total_value The difference between the actual total value and documented total value
     *
     * @return self
     */
    public function setDifferenceTotalValue($difference_total_value)
    {
        if (is_null($difference_total_value)) {
            throw new \InvalidArgumentException('non-nullable difference_total_value cannot be null');
        }
        $this->container['difference_total_value'] = $difference_total_value;

        return $this;
    }

    /**
     * Gets grn_net_value
     *
     * @return float|null
     */
    public function getGrnNetValue()
    {
        return $this->container['grn_net_value'];
    }

    /**
     * Sets grn_net_value
     *
     * @param float|null $grn_net_value The value of the GRN's attached to the invoice
     *
     * @return self
     */
    public function setGrnNetValue($grn_net_value)
    {
        if (is_null($grn_net_value)) {
            throw new \InvalidArgumentException('non-nullable grn_net_value cannot be null');
        }
        $this->container['grn_net_value'] = $grn_net_value;

        return $this;
    }

    /**
     * Gets grn_delivery_charge
     *
     * @return float|null
     */
    public function getGrnDeliveryCharge()
    {
        return $this->container['grn_delivery_charge'];
    }

    /**
     * Sets grn_delivery_charge
     *
     * @param float|null $grn_delivery_charge The delivery charges on the GRN's attached to the invoice
     *
     * @return self
     */
    public function setGrnDeliveryCharge($grn_delivery_charge)
    {
        if (is_null($grn_delivery_charge)) {
            throw new \InvalidArgumentException('non-nullable grn_delivery_charge cannot be null');
        }
        $this->container['grn_delivery_charge'] = $grn_delivery_charge;

        return $this;
    }

    /**
     * Gets grn_total_value
     *
     * @return float|null
     */
    public function getGrnTotalValue()
    {
        return $this->container['grn_total_value'];
    }

    /**
     * Sets grn_total_value
     *
     * @param float|null $grn_total_value The total value of the GRN's attached to the invoice
     *
     * @return self
     */
    public function setGrnTotalValue($grn_total_value)
    {
        if (is_null($grn_total_value)) {
            throw new \InvalidArgumentException('non-nullable grn_total_value cannot be null');
        }
        $this->container['grn_total_value'] = $grn_total_value;

        return $this;
    }

    /**
     * Gets matched_grns
     *
     * @return \Opsuite2\Model\GRNSummary[]|null
     */
    public function getMatchedGrns()
    {
        return $this->container['matched_grns'];
    }

    /**
     * Sets matched_grns
     *
     * @param \Opsuite2\Model\GRNSummary[]|null $matched_grns The list of GRN's covered by this invoice
     *
     * @return self
     */
    public function setMatchedGrns($matched_grns)
    {
        if (is_null($matched_grns)) {
            array_push($this->openAPINullablesSetToNull, 'matched_grns');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('matched_grns', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['matched_grns'] = $matched_grns;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


