<?php
/**
 * GRNDetails
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * GRNDetails Class Doc Comment
 *
 * @category Class
 * @description Details of a receiving document
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class GRNDetails implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'GRNDetails';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'location_id' => 'int',
        'grn_number' => 'string',
        'originating_order_number' => 'string',
        'date_created' => '\DateTime',
        'last_updated' => '\DateTime',
        'date_required' => '\DateTime',
        'date_received' => '\DateTime',
        'date_committed' => '\DateTime',
        'allocation_method' => 'string',
        'advised_delivery_date' => '\DateTime',
        'available_value' => 'float',
        'is_correction' => 'bool',
        'matched' => 'bool',
        'order_inventory_control_document_id' => 'int',
        'received' => 'bool',
        'status' => 'string',
        'shipping_fees' => 'float',
        'supplier_code' => 'string',
        'supplier_currency_symbol' => 'string',
        'supplier_name' => 'string',
        'supplier_id' => 'int',
        'title' => 'string',
        'total_cost' => 'float',
        'original_order_cost' => 'float',
        'total_supplier_cost' => 'float',
        'type' => 'string',
        'committing_user_id' => 'int',
        'committing_user_name' => 'string',
        'number_of_lines' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'int32',
        'location_id' => 'int32',
        'grn_number' => null,
        'originating_order_number' => null,
        'date_created' => 'date-time',
        'last_updated' => 'date-time',
        'date_required' => 'date-time',
        'date_received' => 'date-time',
        'date_committed' => 'date-time',
        'allocation_method' => null,
        'advised_delivery_date' => 'date-time',
        'available_value' => 'double',
        'is_correction' => null,
        'matched' => null,
        'order_inventory_control_document_id' => 'int32',
        'received' => null,
        'status' => null,
        'shipping_fees' => 'double',
        'supplier_code' => null,
        'supplier_currency_symbol' => null,
        'supplier_name' => null,
        'supplier_id' => 'int32',
        'title' => null,
        'total_cost' => 'double',
        'original_order_cost' => 'double',
        'total_supplier_cost' => 'double',
        'type' => null,
        'committing_user_id' => 'int32',
        'committing_user_name' => null,
        'number_of_lines' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'location_id' => false,
        'grn_number' => true,
        'originating_order_number' => true,
        'date_created' => false,
        'last_updated' => false,
        'date_required' => false,
        'date_received' => true,
        'date_committed' => true,
        'allocation_method' => true,
        'advised_delivery_date' => true,
        'available_value' => false,
        'is_correction' => false,
        'matched' => false,
        'order_inventory_control_document_id' => false,
        'received' => false,
        'status' => true,
        'shipping_fees' => false,
        'supplier_code' => true,
        'supplier_currency_symbol' => true,
        'supplier_name' => true,
        'supplier_id' => true,
        'title' => true,
        'total_cost' => false,
        'original_order_cost' => false,
        'total_supplier_cost' => false,
        'type' => true,
        'committing_user_id' => false,
        'committing_user_name' => true,
        'number_of_lines' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'location_id' => 'locationId',
        'grn_number' => 'grnNumber',
        'originating_order_number' => 'originatingOrderNumber',
        'date_created' => 'dateCreated',
        'last_updated' => 'lastUpdated',
        'date_required' => 'dateRequired',
        'date_received' => 'dateReceived',
        'date_committed' => 'dateCommitted',
        'allocation_method' => 'allocationMethod',
        'advised_delivery_date' => 'advisedDeliveryDate',
        'available_value' => 'availableValue',
        'is_correction' => 'isCorrection',
        'matched' => 'matched',
        'order_inventory_control_document_id' => 'orderInventoryControlDocumentId',
        'received' => 'received',
        'status' => 'status',
        'shipping_fees' => 'shippingFees',
        'supplier_code' => 'supplierCode',
        'supplier_currency_symbol' => 'supplierCurrencySymbol',
        'supplier_name' => 'supplierName',
        'supplier_id' => 'supplierId',
        'title' => 'title',
        'total_cost' => 'totalCost',
        'original_order_cost' => 'originalOrderCost',
        'total_supplier_cost' => 'totalSupplierCost',
        'type' => 'type',
        'committing_user_id' => 'committingUserId',
        'committing_user_name' => 'committingUserName',
        'number_of_lines' => 'numberOfLines'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'location_id' => 'setLocationId',
        'grn_number' => 'setGrnNumber',
        'originating_order_number' => 'setOriginatingOrderNumber',
        'date_created' => 'setDateCreated',
        'last_updated' => 'setLastUpdated',
        'date_required' => 'setDateRequired',
        'date_received' => 'setDateReceived',
        'date_committed' => 'setDateCommitted',
        'allocation_method' => 'setAllocationMethod',
        'advised_delivery_date' => 'setAdvisedDeliveryDate',
        'available_value' => 'setAvailableValue',
        'is_correction' => 'setIsCorrection',
        'matched' => 'setMatched',
        'order_inventory_control_document_id' => 'setOrderInventoryControlDocumentId',
        'received' => 'setReceived',
        'status' => 'setStatus',
        'shipping_fees' => 'setShippingFees',
        'supplier_code' => 'setSupplierCode',
        'supplier_currency_symbol' => 'setSupplierCurrencySymbol',
        'supplier_name' => 'setSupplierName',
        'supplier_id' => 'setSupplierId',
        'title' => 'setTitle',
        'total_cost' => 'setTotalCost',
        'original_order_cost' => 'setOriginalOrderCost',
        'total_supplier_cost' => 'setTotalSupplierCost',
        'type' => 'setType',
        'committing_user_id' => 'setCommittingUserId',
        'committing_user_name' => 'setCommittingUserName',
        'number_of_lines' => 'setNumberOfLines'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'location_id' => 'getLocationId',
        'grn_number' => 'getGrnNumber',
        'originating_order_number' => 'getOriginatingOrderNumber',
        'date_created' => 'getDateCreated',
        'last_updated' => 'getLastUpdated',
        'date_required' => 'getDateRequired',
        'date_received' => 'getDateReceived',
        'date_committed' => 'getDateCommitted',
        'allocation_method' => 'getAllocationMethod',
        'advised_delivery_date' => 'getAdvisedDeliveryDate',
        'available_value' => 'getAvailableValue',
        'is_correction' => 'getIsCorrection',
        'matched' => 'getMatched',
        'order_inventory_control_document_id' => 'getOrderInventoryControlDocumentId',
        'received' => 'getReceived',
        'status' => 'getStatus',
        'shipping_fees' => 'getShippingFees',
        'supplier_code' => 'getSupplierCode',
        'supplier_currency_symbol' => 'getSupplierCurrencySymbol',
        'supplier_name' => 'getSupplierName',
        'supplier_id' => 'getSupplierId',
        'title' => 'getTitle',
        'total_cost' => 'getTotalCost',
        'original_order_cost' => 'getOriginalOrderCost',
        'total_supplier_cost' => 'getTotalSupplierCost',
        'type' => 'getType',
        'committing_user_id' => 'getCommittingUserId',
        'committing_user_name' => 'getCommittingUserName',
        'number_of_lines' => 'getNumberOfLines'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('location_id', $data ?? [], null);
        $this->setIfExists('grn_number', $data ?? [], null);
        $this->setIfExists('originating_order_number', $data ?? [], null);
        $this->setIfExists('date_created', $data ?? [], null);
        $this->setIfExists('last_updated', $data ?? [], null);
        $this->setIfExists('date_required', $data ?? [], null);
        $this->setIfExists('date_received', $data ?? [], null);
        $this->setIfExists('date_committed', $data ?? [], null);
        $this->setIfExists('allocation_method', $data ?? [], null);
        $this->setIfExists('advised_delivery_date', $data ?? [], null);
        $this->setIfExists('available_value', $data ?? [], null);
        $this->setIfExists('is_correction', $data ?? [], null);
        $this->setIfExists('matched', $data ?? [], null);
        $this->setIfExists('order_inventory_control_document_id', $data ?? [], null);
        $this->setIfExists('received', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('shipping_fees', $data ?? [], null);
        $this->setIfExists('supplier_code', $data ?? [], null);
        $this->setIfExists('supplier_currency_symbol', $data ?? [], null);
        $this->setIfExists('supplier_name', $data ?? [], null);
        $this->setIfExists('supplier_id', $data ?? [], null);
        $this->setIfExists('title', $data ?? [], null);
        $this->setIfExists('total_cost', $data ?? [], null);
        $this->setIfExists('original_order_cost', $data ?? [], null);
        $this->setIfExists('total_supplier_cost', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('committing_user_id', $data ?? [], null);
        $this->setIfExists('committing_user_name', $data ?? [], null);
        $this->setIfExists('number_of_lines', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id The document id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets location_id
     *
     * @return int|null
     */
    public function getLocationId()
    {
        return $this->container['location_id'];
    }

    /**
     * Sets location_id
     *
     * @param int|null $location_id The location id for the document
     *
     * @return self
     */
    public function setLocationId($location_id)
    {
        if (is_null($location_id)) {
            throw new \InvalidArgumentException('non-nullable location_id cannot be null');
        }
        $this->container['location_id'] = $location_id;

        return $this;
    }

    /**
     * Gets grn_number
     *
     * @return string|null
     */
    public function getGrnNumber()
    {
        return $this->container['grn_number'];
    }

    /**
     * Sets grn_number
     *
     * @param string|null $grn_number The receiving document number
     *
     * @return self
     */
    public function setGrnNumber($grn_number)
    {
        if (is_null($grn_number)) {
            array_push($this->openAPINullablesSetToNull, 'grn_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('grn_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['grn_number'] = $grn_number;

        return $this;
    }

    /**
     * Gets originating_order_number
     *
     * @return string|null
     */
    public function getOriginatingOrderNumber()
    {
        return $this->container['originating_order_number'];
    }

    /**
     * Sets originating_order_number
     *
     * @param string|null $originating_order_number The order number of the purchase order/transfer being received
     *
     * @return self
     */
    public function setOriginatingOrderNumber($originating_order_number)
    {
        if (is_null($originating_order_number)) {
            array_push($this->openAPINullablesSetToNull, 'originating_order_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('originating_order_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['originating_order_number'] = $originating_order_number;

        return $this;
    }

    /**
     * Gets date_created
     *
     * @return \DateTime|null
     */
    public function getDateCreated()
    {
        return $this->container['date_created'];
    }

    /**
     * Sets date_created
     *
     * @param \DateTime|null $date_created The date the document was created
     *
     * @return self
     */
    public function setDateCreated($date_created)
    {
        if (is_null($date_created)) {
            throw new \InvalidArgumentException('non-nullable date_created cannot be null');
        }
        $this->container['date_created'] = $date_created;

        return $this;
    }

    /**
     * Gets last_updated
     *
     * @return \DateTime|null
     */
    public function getLastUpdated()
    {
        return $this->container['last_updated'];
    }

    /**
     * Sets last_updated
     *
     * @param \DateTime|null $last_updated The date the document was last updated
     *
     * @return self
     */
    public function setLastUpdated($last_updated)
    {
        if (is_null($last_updated)) {
            throw new \InvalidArgumentException('non-nullable last_updated cannot be null');
        }
        $this->container['last_updated'] = $last_updated;

        return $this;
    }

    /**
     * Gets date_required
     *
     * @return \DateTime|null
     */
    public function getDateRequired()
    {
        return $this->container['date_required'];
    }

    /**
     * Sets date_required
     *
     * @param \DateTime|null $date_required The date the goods were required
     *
     * @return self
     */
    public function setDateRequired($date_required)
    {
        if (is_null($date_required)) {
            throw new \InvalidArgumentException('non-nullable date_required cannot be null');
        }
        $this->container['date_required'] = $date_required;

        return $this;
    }

    /**
     * Gets date_received
     *
     * @return \DateTime|null
     */
    public function getDateReceived()
    {
        return $this->container['date_received'];
    }

    /**
     * Sets date_received
     *
     * @param \DateTime|null $date_received The date the goods were received
     *
     * @return self
     */
    public function setDateReceived($date_received)
    {
        if (is_null($date_received)) {
            array_push($this->openAPINullablesSetToNull, 'date_received');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date_received', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date_received'] = $date_received;

        return $this;
    }

    /**
     * Gets date_committed
     *
     * @return \DateTime|null
     */
    public function getDateCommitted()
    {
        return $this->container['date_committed'];
    }

    /**
     * Sets date_committed
     *
     * @param \DateTime|null $date_committed The date the document was committed
     *
     * @return self
     */
    public function setDateCommitted($date_committed)
    {
        if (is_null($date_committed)) {
            array_push($this->openAPINullablesSetToNull, 'date_committed');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date_committed', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date_committed'] = $date_committed;

        return $this;
    }

    /**
     * Gets allocation_method
     *
     * @return string|null
     */
    public function getAllocationMethod()
    {
        return $this->container['allocation_method'];
    }

    /**
     * Sets allocation_method
     *
     * @param string|null $allocation_method The allocation method
     *
     * @return self
     */
    public function setAllocationMethod($allocation_method)
    {
        if (is_null($allocation_method)) {
            array_push($this->openAPINullablesSetToNull, 'allocation_method');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('allocation_method', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['allocation_method'] = $allocation_method;

        return $this;
    }

    /**
     * Gets advised_delivery_date
     *
     * @return \DateTime|null
     */
    public function getAdvisedDeliveryDate()
    {
        return $this->container['advised_delivery_date'];
    }

    /**
     * Sets advised_delivery_date
     *
     * @param \DateTime|null $advised_delivery_date The advised delivery date for the goods
     *
     * @return self
     */
    public function setAdvisedDeliveryDate($advised_delivery_date)
    {
        if (is_null($advised_delivery_date)) {
            array_push($this->openAPINullablesSetToNull, 'advised_delivery_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('advised_delivery_date', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['advised_delivery_date'] = $advised_delivery_date;

        return $this;
    }

    /**
     * Gets available_value
     *
     * @return float|null
     */
    public function getAvailableValue()
    {
        return $this->container['available_value'];
    }

    /**
     * Sets available_value
     *
     * @param float|null $available_value The value of the GRN still to be matched
     *
     * @return self
     */
    public function setAvailableValue($available_value)
    {
        if (is_null($available_value)) {
            throw new \InvalidArgumentException('non-nullable available_value cannot be null');
        }
        $this->container['available_value'] = $available_value;

        return $this;
    }

    /**
     * Gets is_correction
     *
     * @return bool|null
     */
    public function getIsCorrection()
    {
        return $this->container['is_correction'];
    }

    /**
     * Sets is_correction
     *
     * @param bool|null $is_correction Is this a document issued as a correction
     *
     * @return self
     */
    public function setIsCorrection($is_correction)
    {
        if (is_null($is_correction)) {
            throw new \InvalidArgumentException('non-nullable is_correction cannot be null');
        }
        $this->container['is_correction'] = $is_correction;

        return $this;
    }

    /**
     * Gets matched
     *
     * @return bool|null
     */
    public function getMatched()
    {
        return $this->container['matched'];
    }

    /**
     * Sets matched
     *
     * @param bool|null $matched Has this GRN been matched to an invoice
     *
     * @return self
     */
    public function setMatched($matched)
    {
        if (is_null($matched)) {
            throw new \InvalidArgumentException('non-nullable matched cannot be null');
        }
        $this->container['matched'] = $matched;

        return $this;
    }

    /**
     * Gets order_inventory_control_document_id
     *
     * @return int|null
     */
    public function getOrderInventoryControlDocumentId()
    {
        return $this->container['order_inventory_control_document_id'];
    }

    /**
     * Sets order_inventory_control_document_id
     *
     * @param int|null $order_inventory_control_document_id The id of the original inventory control document
     *
     * @return self
     */
    public function setOrderInventoryControlDocumentId($order_inventory_control_document_id)
    {
        if (is_null($order_inventory_control_document_id)) {
            throw new \InvalidArgumentException('non-nullable order_inventory_control_document_id cannot be null');
        }
        $this->container['order_inventory_control_document_id'] = $order_inventory_control_document_id;

        return $this;
    }

    /**
     * Gets received
     *
     * @return bool|null
     */
    public function getReceived()
    {
        return $this->container['received'];
    }

    /**
     * Sets received
     *
     * @param bool|null $received Has this GRN been received
     *
     * @return self
     */
    public function setReceived($received)
    {
        if (is_null($received)) {
            throw new \InvalidArgumentException('non-nullable received cannot be null');
        }
        $this->container['received'] = $received;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status The GRN status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            array_push($this->openAPINullablesSetToNull, 'status');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('status', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets shipping_fees
     *
     * @return float|null
     */
    public function getShippingFees()
    {
        return $this->container['shipping_fees'];
    }

    /**
     * Sets shipping_fees
     *
     * @param float|null $shipping_fees The shipping fees
     *
     * @return self
     */
    public function setShippingFees($shipping_fees)
    {
        if (is_null($shipping_fees)) {
            throw new \InvalidArgumentException('non-nullable shipping_fees cannot be null');
        }
        $this->container['shipping_fees'] = $shipping_fees;

        return $this;
    }

    /**
     * Gets supplier_code
     *
     * @return string|null
     */
    public function getSupplierCode()
    {
        return $this->container['supplier_code'];
    }

    /**
     * Sets supplier_code
     *
     * @param string|null $supplier_code The supplier code
     *
     * @return self
     */
    public function setSupplierCode($supplier_code)
    {
        if (is_null($supplier_code)) {
            array_push($this->openAPINullablesSetToNull, 'supplier_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('supplier_code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['supplier_code'] = $supplier_code;

        return $this;
    }

    /**
     * Gets supplier_currency_symbol
     *
     * @return string|null
     */
    public function getSupplierCurrencySymbol()
    {
        return $this->container['supplier_currency_symbol'];
    }

    /**
     * Sets supplier_currency_symbol
     *
     * @param string|null $supplier_currency_symbol The supplier currency
     *
     * @return self
     */
    public function setSupplierCurrencySymbol($supplier_currency_symbol)
    {
        if (is_null($supplier_currency_symbol)) {
            array_push($this->openAPINullablesSetToNull, 'supplier_currency_symbol');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('supplier_currency_symbol', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['supplier_currency_symbol'] = $supplier_currency_symbol;

        return $this;
    }

    /**
     * Gets supplier_name
     *
     * @return string|null
     */
    public function getSupplierName()
    {
        return $this->container['supplier_name'];
    }

    /**
     * Sets supplier_name
     *
     * @param string|null $supplier_name The supplier name
     *
     * @return self
     */
    public function setSupplierName($supplier_name)
    {
        if (is_null($supplier_name)) {
            array_push($this->openAPINullablesSetToNull, 'supplier_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('supplier_name', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['supplier_name'] = $supplier_name;

        return $this;
    }

    /**
     * Gets supplier_id
     *
     * @return int|null
     */
    public function getSupplierId()
    {
        return $this->container['supplier_id'];
    }

    /**
     * Sets supplier_id
     *
     * @param int|null $supplier_id The supplier
     *
     * @return self
     */
    public function setSupplierId($supplier_id)
    {
        if (is_null($supplier_id)) {
            array_push($this->openAPINullablesSetToNull, 'supplier_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('supplier_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['supplier_id'] = $supplier_id;

        return $this;
    }

    /**
     * Gets title
     *
     * @return string|null
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     *
     * @param string|null $title The document title
     *
     * @return self
     */
    public function setTitle($title)
    {
        if (is_null($title)) {
            array_push($this->openAPINullablesSetToNull, 'title');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('title', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets total_cost
     *
     * @return float|null
     */
    public function getTotalCost()
    {
        return $this->container['total_cost'];
    }

    /**
     * Sets total_cost
     *
     * @param float|null $total_cost The total cost of the received items on the GRN in the enterprise currency
     *
     * @return self
     */
    public function setTotalCost($total_cost)
    {
        if (is_null($total_cost)) {
            throw new \InvalidArgumentException('non-nullable total_cost cannot be null');
        }
        $this->container['total_cost'] = $total_cost;

        return $this;
    }

    /**
     * Gets original_order_cost
     *
     * @return float|null
     */
    public function getOriginalOrderCost()
    {
        return $this->container['original_order_cost'];
    }

    /**
     * Sets original_order_cost
     *
     * @param float|null $original_order_cost The original cost of the items on the GRN in the enterprise currency
     *
     * @return self
     */
    public function setOriginalOrderCost($original_order_cost)
    {
        if (is_null($original_order_cost)) {
            throw new \InvalidArgumentException('non-nullable original_order_cost cannot be null');
        }
        $this->container['original_order_cost'] = $original_order_cost;

        return $this;
    }

    /**
     * Gets total_supplier_cost
     *
     * @return float|null
     */
    public function getTotalSupplierCost()
    {
        return $this->container['total_supplier_cost'];
    }

    /**
     * Sets total_supplier_cost
     *
     * @param float|null $total_supplier_cost The total cost of the items on the GRN in the supplier currency
     *
     * @return self
     */
    public function setTotalSupplierCost($total_supplier_cost)
    {
        if (is_null($total_supplier_cost)) {
            throw new \InvalidArgumentException('non-nullable total_supplier_cost cannot be null');
        }
        $this->container['total_supplier_cost'] = $total_supplier_cost;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type The type of document being received      Purchase Order<br />      Inter-Store Transfer<br />      Supplier Transfer<br />      Transfer In<br />      Transfer Out      ///
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            array_push($this->openAPINullablesSetToNull, 'type');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('type', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets committing_user_id
     *
     * @return int|null
     */
    public function getCommittingUserId()
    {
        return $this->container['committing_user_id'];
    }

    /**
     * Sets committing_user_id
     *
     * @param int|null $committing_user_id The committing user id
     *
     * @return self
     */
    public function setCommittingUserId($committing_user_id)
    {
        if (is_null($committing_user_id)) {
            throw new \InvalidArgumentException('non-nullable committing_user_id cannot be null');
        }
        $this->container['committing_user_id'] = $committing_user_id;

        return $this;
    }

    /**
     * Gets committing_user_name
     *
     * @return string|null
     */
    public function getCommittingUserName()
    {
        return $this->container['committing_user_name'];
    }

    /**
     * Sets committing_user_name
     *
     * @param string|null $committing_user_name The committing user name
     *
     * @return self
     */
    public function setCommittingUserName($committing_user_name)
    {
        if (is_null($committing_user_name)) {
            array_push($this->openAPINullablesSetToNull, 'committing_user_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('committing_user_name', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['committing_user_name'] = $committing_user_name;

        return $this;
    }

    /**
     * Gets number_of_lines
     *
     * @return int|null
     */
    public function getNumberOfLines()
    {
        return $this->container['number_of_lines'];
    }

    /**
     * Sets number_of_lines
     *
     * @param int|null $number_of_lines The number of items on the GRN
     *
     * @return self
     */
    public function setNumberOfLines($number_of_lines)
    {
        if (is_null($number_of_lines)) {
            throw new \InvalidArgumentException('non-nullable number_of_lines cannot be null');
        }
        $this->container['number_of_lines'] = $number_of_lines;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


