<?php
/**
 * CustomerLoyaltyField
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * CustomerLoyaltyField Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CustomerLoyaltyField implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CustomerLoyaltyField';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'customer_loyalty_field_id' => 'int',
        'customer_id' => 'int',
        'loyalty_card_id' => 'int',
        'text01' => 'string',
        'text02' => 'string',
        'text03' => 'string',
        'text04' => 'string',
        'text05' => 'string',
        'text06' => 'string',
        'text07' => 'string',
        'text08' => 'string',
        'text09' => 'string',
        'text10' => 'string',
        'text11' => 'string',
        'text12' => 'string',
        'text13' => 'string',
        'text14' => 'string',
        'text15' => 'string',
        'text16' => 'string',
        'text17' => 'string',
        'text18' => 'string',
        'text19' => 'string',
        'text20' => 'string',
        'date01' => '\DateTime',
        'date02' => '\DateTime',
        'date03' => '\DateTime',
        'date04' => '\DateTime',
        'date05' => '\DateTime',
        'date06' => '\DateTime',
        'date07' => '\DateTime',
        'date08' => '\DateTime',
        'date09' => '\DateTime',
        'date10' => '\DateTime',
        'date11' => '\DateTime',
        'date12' => '\DateTime',
        'date13' => '\DateTime',
        'date14' => '\DateTime',
        'date15' => '\DateTime',
        'date16' => '\DateTime',
        'date17' => '\DateTime',
        'date18' => '\DateTime',
        'date19' => '\DateTime',
        'date20' => '\DateTime',
        'number01' => 'float',
        'number02' => 'float',
        'number03' => 'float',
        'number04' => 'float',
        'number05' => 'float',
        'number06' => 'float',
        'number07' => 'float',
        'number08' => 'float',
        'number09' => 'float',
        'number10' => 'float',
        'number11' => 'float',
        'number12' => 'float',
        'number13' => 'float',
        'number14' => 'float',
        'number15' => 'float',
        'number16' => 'float',
        'number17' => 'float',
        'number18' => 'float',
        'number19' => 'float',
        'number20' => 'float',
        'boolean01' => 'bool',
        'boolean02' => 'bool',
        'boolean03' => 'bool',
        'boolean04' => 'bool',
        'boolean05' => 'bool',
        'boolean06' => 'bool',
        'boolean07' => 'bool',
        'boolean08' => 'bool',
        'boolean09' => 'bool',
        'boolean10' => 'bool',
        'boolean11' => 'bool',
        'boolean12' => 'bool',
        'boolean13' => 'bool',
        'boolean14' => 'bool',
        'boolean15' => 'bool',
        'boolean16' => 'bool',
        'boolean17' => 'bool',
        'boolean18' => 'bool',
        'boolean19' => 'bool',
        'boolean20' => 'bool',
        'list_item01' => 'string',
        'list_item02' => 'string',
        'list_item03' => 'string',
        'list_item04' => 'string',
        'list_item05' => 'string',
        'list_item06' => 'string',
        'list_item07' => 'string',
        'list_item08' => 'string',
        'list_item09' => 'string',
        'list_item10' => 'string',
        'list_item11' => 'string',
        'list_item12' => 'string',
        'list_item13' => 'string',
        'list_item14' => 'string',
        'list_item15' => 'string',
        'list_item16' => 'string',
        'list_item17' => 'string',
        'list_item18' => 'string',
        'list_item19' => 'string',
        'list_item20' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'customer_loyalty_field_id' => 'int32',
        'customer_id' => 'int32',
        'loyalty_card_id' => 'int32',
        'text01' => null,
        'text02' => null,
        'text03' => null,
        'text04' => null,
        'text05' => null,
        'text06' => null,
        'text07' => null,
        'text08' => null,
        'text09' => null,
        'text10' => null,
        'text11' => null,
        'text12' => null,
        'text13' => null,
        'text14' => null,
        'text15' => null,
        'text16' => null,
        'text17' => null,
        'text18' => null,
        'text19' => null,
        'text20' => null,
        'date01' => 'date-time',
        'date02' => 'date-time',
        'date03' => 'date-time',
        'date04' => 'date-time',
        'date05' => 'date-time',
        'date06' => 'date-time',
        'date07' => 'date-time',
        'date08' => 'date-time',
        'date09' => 'date-time',
        'date10' => 'date-time',
        'date11' => 'date-time',
        'date12' => 'date-time',
        'date13' => 'date-time',
        'date14' => 'date-time',
        'date15' => 'date-time',
        'date16' => 'date-time',
        'date17' => 'date-time',
        'date18' => 'date-time',
        'date19' => 'date-time',
        'date20' => 'date-time',
        'number01' => 'double',
        'number02' => 'double',
        'number03' => 'double',
        'number04' => 'double',
        'number05' => 'double',
        'number06' => 'double',
        'number07' => 'double',
        'number08' => 'double',
        'number09' => 'double',
        'number10' => 'double',
        'number11' => 'double',
        'number12' => 'double',
        'number13' => 'double',
        'number14' => 'double',
        'number15' => 'double',
        'number16' => 'double',
        'number17' => 'double',
        'number18' => 'double',
        'number19' => 'double',
        'number20' => 'double',
        'boolean01' => null,
        'boolean02' => null,
        'boolean03' => null,
        'boolean04' => null,
        'boolean05' => null,
        'boolean06' => null,
        'boolean07' => null,
        'boolean08' => null,
        'boolean09' => null,
        'boolean10' => null,
        'boolean11' => null,
        'boolean12' => null,
        'boolean13' => null,
        'boolean14' => null,
        'boolean15' => null,
        'boolean16' => null,
        'boolean17' => null,
        'boolean18' => null,
        'boolean19' => null,
        'boolean20' => null,
        'list_item01' => null,
        'list_item02' => null,
        'list_item03' => null,
        'list_item04' => null,
        'list_item05' => null,
        'list_item06' => null,
        'list_item07' => null,
        'list_item08' => null,
        'list_item09' => null,
        'list_item10' => null,
        'list_item11' => null,
        'list_item12' => null,
        'list_item13' => null,
        'list_item14' => null,
        'list_item15' => null,
        'list_item16' => null,
        'list_item17' => null,
        'list_item18' => null,
        'list_item19' => null,
        'list_item20' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'customer_loyalty_field_id' => false,
        'customer_id' => true,
        'loyalty_card_id' => true,
        'text01' => true,
        'text02' => true,
        'text03' => true,
        'text04' => true,
        'text05' => true,
        'text06' => true,
        'text07' => true,
        'text08' => true,
        'text09' => true,
        'text10' => true,
        'text11' => true,
        'text12' => true,
        'text13' => true,
        'text14' => true,
        'text15' => true,
        'text16' => true,
        'text17' => true,
        'text18' => true,
        'text19' => true,
        'text20' => true,
        'date01' => true,
        'date02' => true,
        'date03' => true,
        'date04' => true,
        'date05' => true,
        'date06' => true,
        'date07' => true,
        'date08' => true,
        'date09' => true,
        'date10' => true,
        'date11' => true,
        'date12' => true,
        'date13' => true,
        'date14' => true,
        'date15' => true,
        'date16' => true,
        'date17' => true,
        'date18' => true,
        'date19' => true,
        'date20' => true,
        'number01' => true,
        'number02' => true,
        'number03' => true,
        'number04' => true,
        'number05' => true,
        'number06' => true,
        'number07' => true,
        'number08' => true,
        'number09' => true,
        'number10' => true,
        'number11' => true,
        'number12' => true,
        'number13' => true,
        'number14' => true,
        'number15' => true,
        'number16' => true,
        'number17' => true,
        'number18' => true,
        'number19' => true,
        'number20' => true,
        'boolean01' => true,
        'boolean02' => true,
        'boolean03' => true,
        'boolean04' => true,
        'boolean05' => true,
        'boolean06' => true,
        'boolean07' => true,
        'boolean08' => true,
        'boolean09' => true,
        'boolean10' => true,
        'boolean11' => true,
        'boolean12' => true,
        'boolean13' => true,
        'boolean14' => true,
        'boolean15' => true,
        'boolean16' => true,
        'boolean17' => true,
        'boolean18' => true,
        'boolean19' => true,
        'boolean20' => true,
        'list_item01' => true,
        'list_item02' => true,
        'list_item03' => true,
        'list_item04' => true,
        'list_item05' => true,
        'list_item06' => true,
        'list_item07' => true,
        'list_item08' => true,
        'list_item09' => true,
        'list_item10' => true,
        'list_item11' => true,
        'list_item12' => true,
        'list_item13' => true,
        'list_item14' => true,
        'list_item15' => true,
        'list_item16' => true,
        'list_item17' => true,
        'list_item18' => true,
        'list_item19' => true,
        'list_item20' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'customer_loyalty_field_id' => 'customerLoyaltyFieldId',
        'customer_id' => 'customerId',
        'loyalty_card_id' => 'loyaltyCardId',
        'text01' => 'text01',
        'text02' => 'text02',
        'text03' => 'text03',
        'text04' => 'text04',
        'text05' => 'text05',
        'text06' => 'text06',
        'text07' => 'text07',
        'text08' => 'text08',
        'text09' => 'text09',
        'text10' => 'text10',
        'text11' => 'text11',
        'text12' => 'text12',
        'text13' => 'text13',
        'text14' => 'text14',
        'text15' => 'text15',
        'text16' => 'text16',
        'text17' => 'text17',
        'text18' => 'text18',
        'text19' => 'text19',
        'text20' => 'text20',
        'date01' => 'date01',
        'date02' => 'date02',
        'date03' => 'date03',
        'date04' => 'date04',
        'date05' => 'date05',
        'date06' => 'date06',
        'date07' => 'date07',
        'date08' => 'date08',
        'date09' => 'date09',
        'date10' => 'date10',
        'date11' => 'date11',
        'date12' => 'date12',
        'date13' => 'date13',
        'date14' => 'date14',
        'date15' => 'date15',
        'date16' => 'date16',
        'date17' => 'date17',
        'date18' => 'date18',
        'date19' => 'date19',
        'date20' => 'date20',
        'number01' => 'number01',
        'number02' => 'number02',
        'number03' => 'number03',
        'number04' => 'number04',
        'number05' => 'number05',
        'number06' => 'number06',
        'number07' => 'number07',
        'number08' => 'number08',
        'number09' => 'number09',
        'number10' => 'number10',
        'number11' => 'number11',
        'number12' => 'number12',
        'number13' => 'number13',
        'number14' => 'number14',
        'number15' => 'number15',
        'number16' => 'number16',
        'number17' => 'number17',
        'number18' => 'number18',
        'number19' => 'number19',
        'number20' => 'number20',
        'boolean01' => 'boolean01',
        'boolean02' => 'boolean02',
        'boolean03' => 'boolean03',
        'boolean04' => 'boolean04',
        'boolean05' => 'boolean05',
        'boolean06' => 'boolean06',
        'boolean07' => 'boolean07',
        'boolean08' => 'boolean08',
        'boolean09' => 'boolean09',
        'boolean10' => 'boolean10',
        'boolean11' => 'boolean11',
        'boolean12' => 'boolean12',
        'boolean13' => 'boolean13',
        'boolean14' => 'boolean14',
        'boolean15' => 'boolean15',
        'boolean16' => 'boolean16',
        'boolean17' => 'boolean17',
        'boolean18' => 'boolean18',
        'boolean19' => 'boolean19',
        'boolean20' => 'boolean20',
        'list_item01' => 'listItem01',
        'list_item02' => 'listItem02',
        'list_item03' => 'listItem03',
        'list_item04' => 'listItem04',
        'list_item05' => 'listItem05',
        'list_item06' => 'listItem06',
        'list_item07' => 'listItem07',
        'list_item08' => 'listItem08',
        'list_item09' => 'listItem09',
        'list_item10' => 'listItem10',
        'list_item11' => 'listItem11',
        'list_item12' => 'listItem12',
        'list_item13' => 'listItem13',
        'list_item14' => 'listItem14',
        'list_item15' => 'listItem15',
        'list_item16' => 'listItem16',
        'list_item17' => 'listItem17',
        'list_item18' => 'listItem18',
        'list_item19' => 'listItem19',
        'list_item20' => 'listItem20'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'customer_loyalty_field_id' => 'setCustomerLoyaltyFieldId',
        'customer_id' => 'setCustomerId',
        'loyalty_card_id' => 'setLoyaltyCardId',
        'text01' => 'setText01',
        'text02' => 'setText02',
        'text03' => 'setText03',
        'text04' => 'setText04',
        'text05' => 'setText05',
        'text06' => 'setText06',
        'text07' => 'setText07',
        'text08' => 'setText08',
        'text09' => 'setText09',
        'text10' => 'setText10',
        'text11' => 'setText11',
        'text12' => 'setText12',
        'text13' => 'setText13',
        'text14' => 'setText14',
        'text15' => 'setText15',
        'text16' => 'setText16',
        'text17' => 'setText17',
        'text18' => 'setText18',
        'text19' => 'setText19',
        'text20' => 'setText20',
        'date01' => 'setDate01',
        'date02' => 'setDate02',
        'date03' => 'setDate03',
        'date04' => 'setDate04',
        'date05' => 'setDate05',
        'date06' => 'setDate06',
        'date07' => 'setDate07',
        'date08' => 'setDate08',
        'date09' => 'setDate09',
        'date10' => 'setDate10',
        'date11' => 'setDate11',
        'date12' => 'setDate12',
        'date13' => 'setDate13',
        'date14' => 'setDate14',
        'date15' => 'setDate15',
        'date16' => 'setDate16',
        'date17' => 'setDate17',
        'date18' => 'setDate18',
        'date19' => 'setDate19',
        'date20' => 'setDate20',
        'number01' => 'setNumber01',
        'number02' => 'setNumber02',
        'number03' => 'setNumber03',
        'number04' => 'setNumber04',
        'number05' => 'setNumber05',
        'number06' => 'setNumber06',
        'number07' => 'setNumber07',
        'number08' => 'setNumber08',
        'number09' => 'setNumber09',
        'number10' => 'setNumber10',
        'number11' => 'setNumber11',
        'number12' => 'setNumber12',
        'number13' => 'setNumber13',
        'number14' => 'setNumber14',
        'number15' => 'setNumber15',
        'number16' => 'setNumber16',
        'number17' => 'setNumber17',
        'number18' => 'setNumber18',
        'number19' => 'setNumber19',
        'number20' => 'setNumber20',
        'boolean01' => 'setBoolean01',
        'boolean02' => 'setBoolean02',
        'boolean03' => 'setBoolean03',
        'boolean04' => 'setBoolean04',
        'boolean05' => 'setBoolean05',
        'boolean06' => 'setBoolean06',
        'boolean07' => 'setBoolean07',
        'boolean08' => 'setBoolean08',
        'boolean09' => 'setBoolean09',
        'boolean10' => 'setBoolean10',
        'boolean11' => 'setBoolean11',
        'boolean12' => 'setBoolean12',
        'boolean13' => 'setBoolean13',
        'boolean14' => 'setBoolean14',
        'boolean15' => 'setBoolean15',
        'boolean16' => 'setBoolean16',
        'boolean17' => 'setBoolean17',
        'boolean18' => 'setBoolean18',
        'boolean19' => 'setBoolean19',
        'boolean20' => 'setBoolean20',
        'list_item01' => 'setListItem01',
        'list_item02' => 'setListItem02',
        'list_item03' => 'setListItem03',
        'list_item04' => 'setListItem04',
        'list_item05' => 'setListItem05',
        'list_item06' => 'setListItem06',
        'list_item07' => 'setListItem07',
        'list_item08' => 'setListItem08',
        'list_item09' => 'setListItem09',
        'list_item10' => 'setListItem10',
        'list_item11' => 'setListItem11',
        'list_item12' => 'setListItem12',
        'list_item13' => 'setListItem13',
        'list_item14' => 'setListItem14',
        'list_item15' => 'setListItem15',
        'list_item16' => 'setListItem16',
        'list_item17' => 'setListItem17',
        'list_item18' => 'setListItem18',
        'list_item19' => 'setListItem19',
        'list_item20' => 'setListItem20'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'customer_loyalty_field_id' => 'getCustomerLoyaltyFieldId',
        'customer_id' => 'getCustomerId',
        'loyalty_card_id' => 'getLoyaltyCardId',
        'text01' => 'getText01',
        'text02' => 'getText02',
        'text03' => 'getText03',
        'text04' => 'getText04',
        'text05' => 'getText05',
        'text06' => 'getText06',
        'text07' => 'getText07',
        'text08' => 'getText08',
        'text09' => 'getText09',
        'text10' => 'getText10',
        'text11' => 'getText11',
        'text12' => 'getText12',
        'text13' => 'getText13',
        'text14' => 'getText14',
        'text15' => 'getText15',
        'text16' => 'getText16',
        'text17' => 'getText17',
        'text18' => 'getText18',
        'text19' => 'getText19',
        'text20' => 'getText20',
        'date01' => 'getDate01',
        'date02' => 'getDate02',
        'date03' => 'getDate03',
        'date04' => 'getDate04',
        'date05' => 'getDate05',
        'date06' => 'getDate06',
        'date07' => 'getDate07',
        'date08' => 'getDate08',
        'date09' => 'getDate09',
        'date10' => 'getDate10',
        'date11' => 'getDate11',
        'date12' => 'getDate12',
        'date13' => 'getDate13',
        'date14' => 'getDate14',
        'date15' => 'getDate15',
        'date16' => 'getDate16',
        'date17' => 'getDate17',
        'date18' => 'getDate18',
        'date19' => 'getDate19',
        'date20' => 'getDate20',
        'number01' => 'getNumber01',
        'number02' => 'getNumber02',
        'number03' => 'getNumber03',
        'number04' => 'getNumber04',
        'number05' => 'getNumber05',
        'number06' => 'getNumber06',
        'number07' => 'getNumber07',
        'number08' => 'getNumber08',
        'number09' => 'getNumber09',
        'number10' => 'getNumber10',
        'number11' => 'getNumber11',
        'number12' => 'getNumber12',
        'number13' => 'getNumber13',
        'number14' => 'getNumber14',
        'number15' => 'getNumber15',
        'number16' => 'getNumber16',
        'number17' => 'getNumber17',
        'number18' => 'getNumber18',
        'number19' => 'getNumber19',
        'number20' => 'getNumber20',
        'boolean01' => 'getBoolean01',
        'boolean02' => 'getBoolean02',
        'boolean03' => 'getBoolean03',
        'boolean04' => 'getBoolean04',
        'boolean05' => 'getBoolean05',
        'boolean06' => 'getBoolean06',
        'boolean07' => 'getBoolean07',
        'boolean08' => 'getBoolean08',
        'boolean09' => 'getBoolean09',
        'boolean10' => 'getBoolean10',
        'boolean11' => 'getBoolean11',
        'boolean12' => 'getBoolean12',
        'boolean13' => 'getBoolean13',
        'boolean14' => 'getBoolean14',
        'boolean15' => 'getBoolean15',
        'boolean16' => 'getBoolean16',
        'boolean17' => 'getBoolean17',
        'boolean18' => 'getBoolean18',
        'boolean19' => 'getBoolean19',
        'boolean20' => 'getBoolean20',
        'list_item01' => 'getListItem01',
        'list_item02' => 'getListItem02',
        'list_item03' => 'getListItem03',
        'list_item04' => 'getListItem04',
        'list_item05' => 'getListItem05',
        'list_item06' => 'getListItem06',
        'list_item07' => 'getListItem07',
        'list_item08' => 'getListItem08',
        'list_item09' => 'getListItem09',
        'list_item10' => 'getListItem10',
        'list_item11' => 'getListItem11',
        'list_item12' => 'getListItem12',
        'list_item13' => 'getListItem13',
        'list_item14' => 'getListItem14',
        'list_item15' => 'getListItem15',
        'list_item16' => 'getListItem16',
        'list_item17' => 'getListItem17',
        'list_item18' => 'getListItem18',
        'list_item19' => 'getListItem19',
        'list_item20' => 'getListItem20'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('customer_loyalty_field_id', $data ?? [], null);
        $this->setIfExists('customer_id', $data ?? [], null);
        $this->setIfExists('loyalty_card_id', $data ?? [], null);
        $this->setIfExists('text01', $data ?? [], null);
        $this->setIfExists('text02', $data ?? [], null);
        $this->setIfExists('text03', $data ?? [], null);
        $this->setIfExists('text04', $data ?? [], null);
        $this->setIfExists('text05', $data ?? [], null);
        $this->setIfExists('text06', $data ?? [], null);
        $this->setIfExists('text07', $data ?? [], null);
        $this->setIfExists('text08', $data ?? [], null);
        $this->setIfExists('text09', $data ?? [], null);
        $this->setIfExists('text10', $data ?? [], null);
        $this->setIfExists('text11', $data ?? [], null);
        $this->setIfExists('text12', $data ?? [], null);
        $this->setIfExists('text13', $data ?? [], null);
        $this->setIfExists('text14', $data ?? [], null);
        $this->setIfExists('text15', $data ?? [], null);
        $this->setIfExists('text16', $data ?? [], null);
        $this->setIfExists('text17', $data ?? [], null);
        $this->setIfExists('text18', $data ?? [], null);
        $this->setIfExists('text19', $data ?? [], null);
        $this->setIfExists('text20', $data ?? [], null);
        $this->setIfExists('date01', $data ?? [], null);
        $this->setIfExists('date02', $data ?? [], null);
        $this->setIfExists('date03', $data ?? [], null);
        $this->setIfExists('date04', $data ?? [], null);
        $this->setIfExists('date05', $data ?? [], null);
        $this->setIfExists('date06', $data ?? [], null);
        $this->setIfExists('date07', $data ?? [], null);
        $this->setIfExists('date08', $data ?? [], null);
        $this->setIfExists('date09', $data ?? [], null);
        $this->setIfExists('date10', $data ?? [], null);
        $this->setIfExists('date11', $data ?? [], null);
        $this->setIfExists('date12', $data ?? [], null);
        $this->setIfExists('date13', $data ?? [], null);
        $this->setIfExists('date14', $data ?? [], null);
        $this->setIfExists('date15', $data ?? [], null);
        $this->setIfExists('date16', $data ?? [], null);
        $this->setIfExists('date17', $data ?? [], null);
        $this->setIfExists('date18', $data ?? [], null);
        $this->setIfExists('date19', $data ?? [], null);
        $this->setIfExists('date20', $data ?? [], null);
        $this->setIfExists('number01', $data ?? [], null);
        $this->setIfExists('number02', $data ?? [], null);
        $this->setIfExists('number03', $data ?? [], null);
        $this->setIfExists('number04', $data ?? [], null);
        $this->setIfExists('number05', $data ?? [], null);
        $this->setIfExists('number06', $data ?? [], null);
        $this->setIfExists('number07', $data ?? [], null);
        $this->setIfExists('number08', $data ?? [], null);
        $this->setIfExists('number09', $data ?? [], null);
        $this->setIfExists('number10', $data ?? [], null);
        $this->setIfExists('number11', $data ?? [], null);
        $this->setIfExists('number12', $data ?? [], null);
        $this->setIfExists('number13', $data ?? [], null);
        $this->setIfExists('number14', $data ?? [], null);
        $this->setIfExists('number15', $data ?? [], null);
        $this->setIfExists('number16', $data ?? [], null);
        $this->setIfExists('number17', $data ?? [], null);
        $this->setIfExists('number18', $data ?? [], null);
        $this->setIfExists('number19', $data ?? [], null);
        $this->setIfExists('number20', $data ?? [], null);
        $this->setIfExists('boolean01', $data ?? [], null);
        $this->setIfExists('boolean02', $data ?? [], null);
        $this->setIfExists('boolean03', $data ?? [], null);
        $this->setIfExists('boolean04', $data ?? [], null);
        $this->setIfExists('boolean05', $data ?? [], null);
        $this->setIfExists('boolean06', $data ?? [], null);
        $this->setIfExists('boolean07', $data ?? [], null);
        $this->setIfExists('boolean08', $data ?? [], null);
        $this->setIfExists('boolean09', $data ?? [], null);
        $this->setIfExists('boolean10', $data ?? [], null);
        $this->setIfExists('boolean11', $data ?? [], null);
        $this->setIfExists('boolean12', $data ?? [], null);
        $this->setIfExists('boolean13', $data ?? [], null);
        $this->setIfExists('boolean14', $data ?? [], null);
        $this->setIfExists('boolean15', $data ?? [], null);
        $this->setIfExists('boolean16', $data ?? [], null);
        $this->setIfExists('boolean17', $data ?? [], null);
        $this->setIfExists('boolean18', $data ?? [], null);
        $this->setIfExists('boolean19', $data ?? [], null);
        $this->setIfExists('boolean20', $data ?? [], null);
        $this->setIfExists('list_item01', $data ?? [], null);
        $this->setIfExists('list_item02', $data ?? [], null);
        $this->setIfExists('list_item03', $data ?? [], null);
        $this->setIfExists('list_item04', $data ?? [], null);
        $this->setIfExists('list_item05', $data ?? [], null);
        $this->setIfExists('list_item06', $data ?? [], null);
        $this->setIfExists('list_item07', $data ?? [], null);
        $this->setIfExists('list_item08', $data ?? [], null);
        $this->setIfExists('list_item09', $data ?? [], null);
        $this->setIfExists('list_item10', $data ?? [], null);
        $this->setIfExists('list_item11', $data ?? [], null);
        $this->setIfExists('list_item12', $data ?? [], null);
        $this->setIfExists('list_item13', $data ?? [], null);
        $this->setIfExists('list_item14', $data ?? [], null);
        $this->setIfExists('list_item15', $data ?? [], null);
        $this->setIfExists('list_item16', $data ?? [], null);
        $this->setIfExists('list_item17', $data ?? [], null);
        $this->setIfExists('list_item18', $data ?? [], null);
        $this->setIfExists('list_item19', $data ?? [], null);
        $this->setIfExists('list_item20', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets customer_loyalty_field_id
     *
     * @return int|null
     */
    public function getCustomerLoyaltyFieldId()
    {
        return $this->container['customer_loyalty_field_id'];
    }

    /**
     * Sets customer_loyalty_field_id
     *
     * @param int|null $customer_loyalty_field_id customer_loyalty_field_id
     *
     * @return self
     */
    public function setCustomerLoyaltyFieldId($customer_loyalty_field_id)
    {
        if (is_null($customer_loyalty_field_id)) {
            throw new \InvalidArgumentException('non-nullable customer_loyalty_field_id cannot be null');
        }
        $this->container['customer_loyalty_field_id'] = $customer_loyalty_field_id;

        return $this;
    }

    /**
     * Gets customer_id
     *
     * @return int|null
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     *
     * @param int|null $customer_id customer_id
     *
     * @return self
     */
    public function setCustomerId($customer_id)
    {
        if (is_null($customer_id)) {
            array_push($this->openAPINullablesSetToNull, 'customer_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('customer_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets loyalty_card_id
     *
     * @return int|null
     */
    public function getLoyaltyCardId()
    {
        return $this->container['loyalty_card_id'];
    }

    /**
     * Sets loyalty_card_id
     *
     * @param int|null $loyalty_card_id loyalty_card_id
     *
     * @return self
     */
    public function setLoyaltyCardId($loyalty_card_id)
    {
        if (is_null($loyalty_card_id)) {
            array_push($this->openAPINullablesSetToNull, 'loyalty_card_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('loyalty_card_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['loyalty_card_id'] = $loyalty_card_id;

        return $this;
    }

    /**
     * Gets text01
     *
     * @return string|null
     */
    public function getText01()
    {
        return $this->container['text01'];
    }

    /**
     * Sets text01
     *
     * @param string|null $text01 text01
     *
     * @return self
     */
    public function setText01($text01)
    {
        if (is_null($text01)) {
            array_push($this->openAPINullablesSetToNull, 'text01');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('text01', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['text01'] = $text01;

        return $this;
    }

    /**
     * Gets text02
     *
     * @return string|null
     */
    public function getText02()
    {
        return $this->container['text02'];
    }

    /**
     * Sets text02
     *
     * @param string|null $text02 text02
     *
     * @return self
     */
    public function setText02($text02)
    {
        if (is_null($text02)) {
            array_push($this->openAPINullablesSetToNull, 'text02');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('text02', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['text02'] = $text02;

        return $this;
    }

    /**
     * Gets text03
     *
     * @return string|null
     */
    public function getText03()
    {
        return $this->container['text03'];
    }

    /**
     * Sets text03
     *
     * @param string|null $text03 text03
     *
     * @return self
     */
    public function setText03($text03)
    {
        if (is_null($text03)) {
            array_push($this->openAPINullablesSetToNull, 'text03');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('text03', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['text03'] = $text03;

        return $this;
    }

    /**
     * Gets text04
     *
     * @return string|null
     */
    public function getText04()
    {
        return $this->container['text04'];
    }

    /**
     * Sets text04
     *
     * @param string|null $text04 text04
     *
     * @return self
     */
    public function setText04($text04)
    {
        if (is_null($text04)) {
            array_push($this->openAPINullablesSetToNull, 'text04');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('text04', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['text04'] = $text04;

        return $this;
    }

    /**
     * Gets text05
     *
     * @return string|null
     */
    public function getText05()
    {
        return $this->container['text05'];
    }

    /**
     * Sets text05
     *
     * @param string|null $text05 text05
     *
     * @return self
     */
    public function setText05($text05)
    {
        if (is_null($text05)) {
            array_push($this->openAPINullablesSetToNull, 'text05');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('text05', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['text05'] = $text05;

        return $this;
    }

    /**
     * Gets text06
     *
     * @return string|null
     */
    public function getText06()
    {
        return $this->container['text06'];
    }

    /**
     * Sets text06
     *
     * @param string|null $text06 text06
     *
     * @return self
     */
    public function setText06($text06)
    {
        if (is_null($text06)) {
            array_push($this->openAPINullablesSetToNull, 'text06');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('text06', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['text06'] = $text06;

        return $this;
    }

    /**
     * Gets text07
     *
     * @return string|null
     */
    public function getText07()
    {
        return $this->container['text07'];
    }

    /**
     * Sets text07
     *
     * @param string|null $text07 text07
     *
     * @return self
     */
    public function setText07($text07)
    {
        if (is_null($text07)) {
            array_push($this->openAPINullablesSetToNull, 'text07');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('text07', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['text07'] = $text07;

        return $this;
    }

    /**
     * Gets text08
     *
     * @return string|null
     */
    public function getText08()
    {
        return $this->container['text08'];
    }

    /**
     * Sets text08
     *
     * @param string|null $text08 text08
     *
     * @return self
     */
    public function setText08($text08)
    {
        if (is_null($text08)) {
            array_push($this->openAPINullablesSetToNull, 'text08');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('text08', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['text08'] = $text08;

        return $this;
    }

    /**
     * Gets text09
     *
     * @return string|null
     */
    public function getText09()
    {
        return $this->container['text09'];
    }

    /**
     * Sets text09
     *
     * @param string|null $text09 text09
     *
     * @return self
     */
    public function setText09($text09)
    {
        if (is_null($text09)) {
            array_push($this->openAPINullablesSetToNull, 'text09');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('text09', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['text09'] = $text09;

        return $this;
    }

    /**
     * Gets text10
     *
     * @return string|null
     */
    public function getText10()
    {
        return $this->container['text10'];
    }

    /**
     * Sets text10
     *
     * @param string|null $text10 text10
     *
     * @return self
     */
    public function setText10($text10)
    {
        if (is_null($text10)) {
            array_push($this->openAPINullablesSetToNull, 'text10');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('text10', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['text10'] = $text10;

        return $this;
    }

    /**
     * Gets text11
     *
     * @return string|null
     */
    public function getText11()
    {
        return $this->container['text11'];
    }

    /**
     * Sets text11
     *
     * @param string|null $text11 text11
     *
     * @return self
     */
    public function setText11($text11)
    {
        if (is_null($text11)) {
            array_push($this->openAPINullablesSetToNull, 'text11');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('text11', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['text11'] = $text11;

        return $this;
    }

    /**
     * Gets text12
     *
     * @return string|null
     */
    public function getText12()
    {
        return $this->container['text12'];
    }

    /**
     * Sets text12
     *
     * @param string|null $text12 text12
     *
     * @return self
     */
    public function setText12($text12)
    {
        if (is_null($text12)) {
            array_push($this->openAPINullablesSetToNull, 'text12');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('text12', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['text12'] = $text12;

        return $this;
    }

    /**
     * Gets text13
     *
     * @return string|null
     */
    public function getText13()
    {
        return $this->container['text13'];
    }

    /**
     * Sets text13
     *
     * @param string|null $text13 text13
     *
     * @return self
     */
    public function setText13($text13)
    {
        if (is_null($text13)) {
            array_push($this->openAPINullablesSetToNull, 'text13');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('text13', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['text13'] = $text13;

        return $this;
    }

    /**
     * Gets text14
     *
     * @return string|null
     */
    public function getText14()
    {
        return $this->container['text14'];
    }

    /**
     * Sets text14
     *
     * @param string|null $text14 text14
     *
     * @return self
     */
    public function setText14($text14)
    {
        if (is_null($text14)) {
            array_push($this->openAPINullablesSetToNull, 'text14');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('text14', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['text14'] = $text14;

        return $this;
    }

    /**
     * Gets text15
     *
     * @return string|null
     */
    public function getText15()
    {
        return $this->container['text15'];
    }

    /**
     * Sets text15
     *
     * @param string|null $text15 text15
     *
     * @return self
     */
    public function setText15($text15)
    {
        if (is_null($text15)) {
            array_push($this->openAPINullablesSetToNull, 'text15');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('text15', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['text15'] = $text15;

        return $this;
    }

    /**
     * Gets text16
     *
     * @return string|null
     */
    public function getText16()
    {
        return $this->container['text16'];
    }

    /**
     * Sets text16
     *
     * @param string|null $text16 text16
     *
     * @return self
     */
    public function setText16($text16)
    {
        if (is_null($text16)) {
            array_push($this->openAPINullablesSetToNull, 'text16');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('text16', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['text16'] = $text16;

        return $this;
    }

    /**
     * Gets text17
     *
     * @return string|null
     */
    public function getText17()
    {
        return $this->container['text17'];
    }

    /**
     * Sets text17
     *
     * @param string|null $text17 text17
     *
     * @return self
     */
    public function setText17($text17)
    {
        if (is_null($text17)) {
            array_push($this->openAPINullablesSetToNull, 'text17');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('text17', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['text17'] = $text17;

        return $this;
    }

    /**
     * Gets text18
     *
     * @return string|null
     */
    public function getText18()
    {
        return $this->container['text18'];
    }

    /**
     * Sets text18
     *
     * @param string|null $text18 text18
     *
     * @return self
     */
    public function setText18($text18)
    {
        if (is_null($text18)) {
            array_push($this->openAPINullablesSetToNull, 'text18');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('text18', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['text18'] = $text18;

        return $this;
    }

    /**
     * Gets text19
     *
     * @return string|null
     */
    public function getText19()
    {
        return $this->container['text19'];
    }

    /**
     * Sets text19
     *
     * @param string|null $text19 text19
     *
     * @return self
     */
    public function setText19($text19)
    {
        if (is_null($text19)) {
            array_push($this->openAPINullablesSetToNull, 'text19');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('text19', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['text19'] = $text19;

        return $this;
    }

    /**
     * Gets text20
     *
     * @return string|null
     */
    public function getText20()
    {
        return $this->container['text20'];
    }

    /**
     * Sets text20
     *
     * @param string|null $text20 text20
     *
     * @return self
     */
    public function setText20($text20)
    {
        if (is_null($text20)) {
            array_push($this->openAPINullablesSetToNull, 'text20');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('text20', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['text20'] = $text20;

        return $this;
    }

    /**
     * Gets date01
     *
     * @return \DateTime|null
     */
    public function getDate01()
    {
        return $this->container['date01'];
    }

    /**
     * Sets date01
     *
     * @param \DateTime|null $date01 date01
     *
     * @return self
     */
    public function setDate01($date01)
    {
        if (is_null($date01)) {
            array_push($this->openAPINullablesSetToNull, 'date01');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date01', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date01'] = $date01;

        return $this;
    }

    /**
     * Gets date02
     *
     * @return \DateTime|null
     */
    public function getDate02()
    {
        return $this->container['date02'];
    }

    /**
     * Sets date02
     *
     * @param \DateTime|null $date02 date02
     *
     * @return self
     */
    public function setDate02($date02)
    {
        if (is_null($date02)) {
            array_push($this->openAPINullablesSetToNull, 'date02');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date02', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date02'] = $date02;

        return $this;
    }

    /**
     * Gets date03
     *
     * @return \DateTime|null
     */
    public function getDate03()
    {
        return $this->container['date03'];
    }

    /**
     * Sets date03
     *
     * @param \DateTime|null $date03 date03
     *
     * @return self
     */
    public function setDate03($date03)
    {
        if (is_null($date03)) {
            array_push($this->openAPINullablesSetToNull, 'date03');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date03', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date03'] = $date03;

        return $this;
    }

    /**
     * Gets date04
     *
     * @return \DateTime|null
     */
    public function getDate04()
    {
        return $this->container['date04'];
    }

    /**
     * Sets date04
     *
     * @param \DateTime|null $date04 date04
     *
     * @return self
     */
    public function setDate04($date04)
    {
        if (is_null($date04)) {
            array_push($this->openAPINullablesSetToNull, 'date04');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date04', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date04'] = $date04;

        return $this;
    }

    /**
     * Gets date05
     *
     * @return \DateTime|null
     */
    public function getDate05()
    {
        return $this->container['date05'];
    }

    /**
     * Sets date05
     *
     * @param \DateTime|null $date05 date05
     *
     * @return self
     */
    public function setDate05($date05)
    {
        if (is_null($date05)) {
            array_push($this->openAPINullablesSetToNull, 'date05');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date05', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date05'] = $date05;

        return $this;
    }

    /**
     * Gets date06
     *
     * @return \DateTime|null
     */
    public function getDate06()
    {
        return $this->container['date06'];
    }

    /**
     * Sets date06
     *
     * @param \DateTime|null $date06 date06
     *
     * @return self
     */
    public function setDate06($date06)
    {
        if (is_null($date06)) {
            array_push($this->openAPINullablesSetToNull, 'date06');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date06', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date06'] = $date06;

        return $this;
    }

    /**
     * Gets date07
     *
     * @return \DateTime|null
     */
    public function getDate07()
    {
        return $this->container['date07'];
    }

    /**
     * Sets date07
     *
     * @param \DateTime|null $date07 date07
     *
     * @return self
     */
    public function setDate07($date07)
    {
        if (is_null($date07)) {
            array_push($this->openAPINullablesSetToNull, 'date07');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date07', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date07'] = $date07;

        return $this;
    }

    /**
     * Gets date08
     *
     * @return \DateTime|null
     */
    public function getDate08()
    {
        return $this->container['date08'];
    }

    /**
     * Sets date08
     *
     * @param \DateTime|null $date08 date08
     *
     * @return self
     */
    public function setDate08($date08)
    {
        if (is_null($date08)) {
            array_push($this->openAPINullablesSetToNull, 'date08');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date08', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date08'] = $date08;

        return $this;
    }

    /**
     * Gets date09
     *
     * @return \DateTime|null
     */
    public function getDate09()
    {
        return $this->container['date09'];
    }

    /**
     * Sets date09
     *
     * @param \DateTime|null $date09 date09
     *
     * @return self
     */
    public function setDate09($date09)
    {
        if (is_null($date09)) {
            array_push($this->openAPINullablesSetToNull, 'date09');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date09', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date09'] = $date09;

        return $this;
    }

    /**
     * Gets date10
     *
     * @return \DateTime|null
     */
    public function getDate10()
    {
        return $this->container['date10'];
    }

    /**
     * Sets date10
     *
     * @param \DateTime|null $date10 date10
     *
     * @return self
     */
    public function setDate10($date10)
    {
        if (is_null($date10)) {
            array_push($this->openAPINullablesSetToNull, 'date10');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date10', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date10'] = $date10;

        return $this;
    }

    /**
     * Gets date11
     *
     * @return \DateTime|null
     */
    public function getDate11()
    {
        return $this->container['date11'];
    }

    /**
     * Sets date11
     *
     * @param \DateTime|null $date11 date11
     *
     * @return self
     */
    public function setDate11($date11)
    {
        if (is_null($date11)) {
            array_push($this->openAPINullablesSetToNull, 'date11');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date11', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date11'] = $date11;

        return $this;
    }

    /**
     * Gets date12
     *
     * @return \DateTime|null
     */
    public function getDate12()
    {
        return $this->container['date12'];
    }

    /**
     * Sets date12
     *
     * @param \DateTime|null $date12 date12
     *
     * @return self
     */
    public function setDate12($date12)
    {
        if (is_null($date12)) {
            array_push($this->openAPINullablesSetToNull, 'date12');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date12', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date12'] = $date12;

        return $this;
    }

    /**
     * Gets date13
     *
     * @return \DateTime|null
     */
    public function getDate13()
    {
        return $this->container['date13'];
    }

    /**
     * Sets date13
     *
     * @param \DateTime|null $date13 date13
     *
     * @return self
     */
    public function setDate13($date13)
    {
        if (is_null($date13)) {
            array_push($this->openAPINullablesSetToNull, 'date13');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date13', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date13'] = $date13;

        return $this;
    }

    /**
     * Gets date14
     *
     * @return \DateTime|null
     */
    public function getDate14()
    {
        return $this->container['date14'];
    }

    /**
     * Sets date14
     *
     * @param \DateTime|null $date14 date14
     *
     * @return self
     */
    public function setDate14($date14)
    {
        if (is_null($date14)) {
            array_push($this->openAPINullablesSetToNull, 'date14');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date14', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date14'] = $date14;

        return $this;
    }

    /**
     * Gets date15
     *
     * @return \DateTime|null
     */
    public function getDate15()
    {
        return $this->container['date15'];
    }

    /**
     * Sets date15
     *
     * @param \DateTime|null $date15 date15
     *
     * @return self
     */
    public function setDate15($date15)
    {
        if (is_null($date15)) {
            array_push($this->openAPINullablesSetToNull, 'date15');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date15', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date15'] = $date15;

        return $this;
    }

    /**
     * Gets date16
     *
     * @return \DateTime|null
     */
    public function getDate16()
    {
        return $this->container['date16'];
    }

    /**
     * Sets date16
     *
     * @param \DateTime|null $date16 date16
     *
     * @return self
     */
    public function setDate16($date16)
    {
        if (is_null($date16)) {
            array_push($this->openAPINullablesSetToNull, 'date16');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date16', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date16'] = $date16;

        return $this;
    }

    /**
     * Gets date17
     *
     * @return \DateTime|null
     */
    public function getDate17()
    {
        return $this->container['date17'];
    }

    /**
     * Sets date17
     *
     * @param \DateTime|null $date17 date17
     *
     * @return self
     */
    public function setDate17($date17)
    {
        if (is_null($date17)) {
            array_push($this->openAPINullablesSetToNull, 'date17');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date17', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date17'] = $date17;

        return $this;
    }

    /**
     * Gets date18
     *
     * @return \DateTime|null
     */
    public function getDate18()
    {
        return $this->container['date18'];
    }

    /**
     * Sets date18
     *
     * @param \DateTime|null $date18 date18
     *
     * @return self
     */
    public function setDate18($date18)
    {
        if (is_null($date18)) {
            array_push($this->openAPINullablesSetToNull, 'date18');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date18', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date18'] = $date18;

        return $this;
    }

    /**
     * Gets date19
     *
     * @return \DateTime|null
     */
    public function getDate19()
    {
        return $this->container['date19'];
    }

    /**
     * Sets date19
     *
     * @param \DateTime|null $date19 date19
     *
     * @return self
     */
    public function setDate19($date19)
    {
        if (is_null($date19)) {
            array_push($this->openAPINullablesSetToNull, 'date19');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date19', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date19'] = $date19;

        return $this;
    }

    /**
     * Gets date20
     *
     * @return \DateTime|null
     */
    public function getDate20()
    {
        return $this->container['date20'];
    }

    /**
     * Sets date20
     *
     * @param \DateTime|null $date20 date20
     *
     * @return self
     */
    public function setDate20($date20)
    {
        if (is_null($date20)) {
            array_push($this->openAPINullablesSetToNull, 'date20');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date20', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date20'] = $date20;

        return $this;
    }

    /**
     * Gets number01
     *
     * @return float|null
     */
    public function getNumber01()
    {
        return $this->container['number01'];
    }

    /**
     * Sets number01
     *
     * @param float|null $number01 number01
     *
     * @return self
     */
    public function setNumber01($number01)
    {
        if (is_null($number01)) {
            array_push($this->openAPINullablesSetToNull, 'number01');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('number01', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['number01'] = $number01;

        return $this;
    }

    /**
     * Gets number02
     *
     * @return float|null
     */
    public function getNumber02()
    {
        return $this->container['number02'];
    }

    /**
     * Sets number02
     *
     * @param float|null $number02 number02
     *
     * @return self
     */
    public function setNumber02($number02)
    {
        if (is_null($number02)) {
            array_push($this->openAPINullablesSetToNull, 'number02');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('number02', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['number02'] = $number02;

        return $this;
    }

    /**
     * Gets number03
     *
     * @return float|null
     */
    public function getNumber03()
    {
        return $this->container['number03'];
    }

    /**
     * Sets number03
     *
     * @param float|null $number03 number03
     *
     * @return self
     */
    public function setNumber03($number03)
    {
        if (is_null($number03)) {
            array_push($this->openAPINullablesSetToNull, 'number03');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('number03', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['number03'] = $number03;

        return $this;
    }

    /**
     * Gets number04
     *
     * @return float|null
     */
    public function getNumber04()
    {
        return $this->container['number04'];
    }

    /**
     * Sets number04
     *
     * @param float|null $number04 number04
     *
     * @return self
     */
    public function setNumber04($number04)
    {
        if (is_null($number04)) {
            array_push($this->openAPINullablesSetToNull, 'number04');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('number04', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['number04'] = $number04;

        return $this;
    }

    /**
     * Gets number05
     *
     * @return float|null
     */
    public function getNumber05()
    {
        return $this->container['number05'];
    }

    /**
     * Sets number05
     *
     * @param float|null $number05 number05
     *
     * @return self
     */
    public function setNumber05($number05)
    {
        if (is_null($number05)) {
            array_push($this->openAPINullablesSetToNull, 'number05');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('number05', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['number05'] = $number05;

        return $this;
    }

    /**
     * Gets number06
     *
     * @return float|null
     */
    public function getNumber06()
    {
        return $this->container['number06'];
    }

    /**
     * Sets number06
     *
     * @param float|null $number06 number06
     *
     * @return self
     */
    public function setNumber06($number06)
    {
        if (is_null($number06)) {
            array_push($this->openAPINullablesSetToNull, 'number06');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('number06', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['number06'] = $number06;

        return $this;
    }

    /**
     * Gets number07
     *
     * @return float|null
     */
    public function getNumber07()
    {
        return $this->container['number07'];
    }

    /**
     * Sets number07
     *
     * @param float|null $number07 number07
     *
     * @return self
     */
    public function setNumber07($number07)
    {
        if (is_null($number07)) {
            array_push($this->openAPINullablesSetToNull, 'number07');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('number07', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['number07'] = $number07;

        return $this;
    }

    /**
     * Gets number08
     *
     * @return float|null
     */
    public function getNumber08()
    {
        return $this->container['number08'];
    }

    /**
     * Sets number08
     *
     * @param float|null $number08 number08
     *
     * @return self
     */
    public function setNumber08($number08)
    {
        if (is_null($number08)) {
            array_push($this->openAPINullablesSetToNull, 'number08');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('number08', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['number08'] = $number08;

        return $this;
    }

    /**
     * Gets number09
     *
     * @return float|null
     */
    public function getNumber09()
    {
        return $this->container['number09'];
    }

    /**
     * Sets number09
     *
     * @param float|null $number09 number09
     *
     * @return self
     */
    public function setNumber09($number09)
    {
        if (is_null($number09)) {
            array_push($this->openAPINullablesSetToNull, 'number09');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('number09', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['number09'] = $number09;

        return $this;
    }

    /**
     * Gets number10
     *
     * @return float|null
     */
    public function getNumber10()
    {
        return $this->container['number10'];
    }

    /**
     * Sets number10
     *
     * @param float|null $number10 number10
     *
     * @return self
     */
    public function setNumber10($number10)
    {
        if (is_null($number10)) {
            array_push($this->openAPINullablesSetToNull, 'number10');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('number10', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['number10'] = $number10;

        return $this;
    }

    /**
     * Gets number11
     *
     * @return float|null
     */
    public function getNumber11()
    {
        return $this->container['number11'];
    }

    /**
     * Sets number11
     *
     * @param float|null $number11 number11
     *
     * @return self
     */
    public function setNumber11($number11)
    {
        if (is_null($number11)) {
            array_push($this->openAPINullablesSetToNull, 'number11');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('number11', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['number11'] = $number11;

        return $this;
    }

    /**
     * Gets number12
     *
     * @return float|null
     */
    public function getNumber12()
    {
        return $this->container['number12'];
    }

    /**
     * Sets number12
     *
     * @param float|null $number12 number12
     *
     * @return self
     */
    public function setNumber12($number12)
    {
        if (is_null($number12)) {
            array_push($this->openAPINullablesSetToNull, 'number12');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('number12', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['number12'] = $number12;

        return $this;
    }

    /**
     * Gets number13
     *
     * @return float|null
     */
    public function getNumber13()
    {
        return $this->container['number13'];
    }

    /**
     * Sets number13
     *
     * @param float|null $number13 number13
     *
     * @return self
     */
    public function setNumber13($number13)
    {
        if (is_null($number13)) {
            array_push($this->openAPINullablesSetToNull, 'number13');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('number13', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['number13'] = $number13;

        return $this;
    }

    /**
     * Gets number14
     *
     * @return float|null
     */
    public function getNumber14()
    {
        return $this->container['number14'];
    }

    /**
     * Sets number14
     *
     * @param float|null $number14 number14
     *
     * @return self
     */
    public function setNumber14($number14)
    {
        if (is_null($number14)) {
            array_push($this->openAPINullablesSetToNull, 'number14');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('number14', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['number14'] = $number14;

        return $this;
    }

    /**
     * Gets number15
     *
     * @return float|null
     */
    public function getNumber15()
    {
        return $this->container['number15'];
    }

    /**
     * Sets number15
     *
     * @param float|null $number15 number15
     *
     * @return self
     */
    public function setNumber15($number15)
    {
        if (is_null($number15)) {
            array_push($this->openAPINullablesSetToNull, 'number15');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('number15', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['number15'] = $number15;

        return $this;
    }

    /**
     * Gets number16
     *
     * @return float|null
     */
    public function getNumber16()
    {
        return $this->container['number16'];
    }

    /**
     * Sets number16
     *
     * @param float|null $number16 number16
     *
     * @return self
     */
    public function setNumber16($number16)
    {
        if (is_null($number16)) {
            array_push($this->openAPINullablesSetToNull, 'number16');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('number16', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['number16'] = $number16;

        return $this;
    }

    /**
     * Gets number17
     *
     * @return float|null
     */
    public function getNumber17()
    {
        return $this->container['number17'];
    }

    /**
     * Sets number17
     *
     * @param float|null $number17 number17
     *
     * @return self
     */
    public function setNumber17($number17)
    {
        if (is_null($number17)) {
            array_push($this->openAPINullablesSetToNull, 'number17');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('number17', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['number17'] = $number17;

        return $this;
    }

    /**
     * Gets number18
     *
     * @return float|null
     */
    public function getNumber18()
    {
        return $this->container['number18'];
    }

    /**
     * Sets number18
     *
     * @param float|null $number18 number18
     *
     * @return self
     */
    public function setNumber18($number18)
    {
        if (is_null($number18)) {
            array_push($this->openAPINullablesSetToNull, 'number18');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('number18', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['number18'] = $number18;

        return $this;
    }

    /**
     * Gets number19
     *
     * @return float|null
     */
    public function getNumber19()
    {
        return $this->container['number19'];
    }

    /**
     * Sets number19
     *
     * @param float|null $number19 number19
     *
     * @return self
     */
    public function setNumber19($number19)
    {
        if (is_null($number19)) {
            array_push($this->openAPINullablesSetToNull, 'number19');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('number19', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['number19'] = $number19;

        return $this;
    }

    /**
     * Gets number20
     *
     * @return float|null
     */
    public function getNumber20()
    {
        return $this->container['number20'];
    }

    /**
     * Sets number20
     *
     * @param float|null $number20 number20
     *
     * @return self
     */
    public function setNumber20($number20)
    {
        if (is_null($number20)) {
            array_push($this->openAPINullablesSetToNull, 'number20');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('number20', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['number20'] = $number20;

        return $this;
    }

    /**
     * Gets boolean01
     *
     * @return bool|null
     */
    public function getBoolean01()
    {
        return $this->container['boolean01'];
    }

    /**
     * Sets boolean01
     *
     * @param bool|null $boolean01 boolean01
     *
     * @return self
     */
    public function setBoolean01($boolean01)
    {
        if (is_null($boolean01)) {
            array_push($this->openAPINullablesSetToNull, 'boolean01');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('boolean01', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['boolean01'] = $boolean01;

        return $this;
    }

    /**
     * Gets boolean02
     *
     * @return bool|null
     */
    public function getBoolean02()
    {
        return $this->container['boolean02'];
    }

    /**
     * Sets boolean02
     *
     * @param bool|null $boolean02 boolean02
     *
     * @return self
     */
    public function setBoolean02($boolean02)
    {
        if (is_null($boolean02)) {
            array_push($this->openAPINullablesSetToNull, 'boolean02');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('boolean02', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['boolean02'] = $boolean02;

        return $this;
    }

    /**
     * Gets boolean03
     *
     * @return bool|null
     */
    public function getBoolean03()
    {
        return $this->container['boolean03'];
    }

    /**
     * Sets boolean03
     *
     * @param bool|null $boolean03 boolean03
     *
     * @return self
     */
    public function setBoolean03($boolean03)
    {
        if (is_null($boolean03)) {
            array_push($this->openAPINullablesSetToNull, 'boolean03');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('boolean03', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['boolean03'] = $boolean03;

        return $this;
    }

    /**
     * Gets boolean04
     *
     * @return bool|null
     */
    public function getBoolean04()
    {
        return $this->container['boolean04'];
    }

    /**
     * Sets boolean04
     *
     * @param bool|null $boolean04 boolean04
     *
     * @return self
     */
    public function setBoolean04($boolean04)
    {
        if (is_null($boolean04)) {
            array_push($this->openAPINullablesSetToNull, 'boolean04');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('boolean04', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['boolean04'] = $boolean04;

        return $this;
    }

    /**
     * Gets boolean05
     *
     * @return bool|null
     */
    public function getBoolean05()
    {
        return $this->container['boolean05'];
    }

    /**
     * Sets boolean05
     *
     * @param bool|null $boolean05 boolean05
     *
     * @return self
     */
    public function setBoolean05($boolean05)
    {
        if (is_null($boolean05)) {
            array_push($this->openAPINullablesSetToNull, 'boolean05');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('boolean05', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['boolean05'] = $boolean05;

        return $this;
    }

    /**
     * Gets boolean06
     *
     * @return bool|null
     */
    public function getBoolean06()
    {
        return $this->container['boolean06'];
    }

    /**
     * Sets boolean06
     *
     * @param bool|null $boolean06 boolean06
     *
     * @return self
     */
    public function setBoolean06($boolean06)
    {
        if (is_null($boolean06)) {
            array_push($this->openAPINullablesSetToNull, 'boolean06');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('boolean06', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['boolean06'] = $boolean06;

        return $this;
    }

    /**
     * Gets boolean07
     *
     * @return bool|null
     */
    public function getBoolean07()
    {
        return $this->container['boolean07'];
    }

    /**
     * Sets boolean07
     *
     * @param bool|null $boolean07 boolean07
     *
     * @return self
     */
    public function setBoolean07($boolean07)
    {
        if (is_null($boolean07)) {
            array_push($this->openAPINullablesSetToNull, 'boolean07');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('boolean07', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['boolean07'] = $boolean07;

        return $this;
    }

    /**
     * Gets boolean08
     *
     * @return bool|null
     */
    public function getBoolean08()
    {
        return $this->container['boolean08'];
    }

    /**
     * Sets boolean08
     *
     * @param bool|null $boolean08 boolean08
     *
     * @return self
     */
    public function setBoolean08($boolean08)
    {
        if (is_null($boolean08)) {
            array_push($this->openAPINullablesSetToNull, 'boolean08');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('boolean08', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['boolean08'] = $boolean08;

        return $this;
    }

    /**
     * Gets boolean09
     *
     * @return bool|null
     */
    public function getBoolean09()
    {
        return $this->container['boolean09'];
    }

    /**
     * Sets boolean09
     *
     * @param bool|null $boolean09 boolean09
     *
     * @return self
     */
    public function setBoolean09($boolean09)
    {
        if (is_null($boolean09)) {
            array_push($this->openAPINullablesSetToNull, 'boolean09');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('boolean09', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['boolean09'] = $boolean09;

        return $this;
    }

    /**
     * Gets boolean10
     *
     * @return bool|null
     */
    public function getBoolean10()
    {
        return $this->container['boolean10'];
    }

    /**
     * Sets boolean10
     *
     * @param bool|null $boolean10 boolean10
     *
     * @return self
     */
    public function setBoolean10($boolean10)
    {
        if (is_null($boolean10)) {
            array_push($this->openAPINullablesSetToNull, 'boolean10');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('boolean10', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['boolean10'] = $boolean10;

        return $this;
    }

    /**
     * Gets boolean11
     *
     * @return bool|null
     */
    public function getBoolean11()
    {
        return $this->container['boolean11'];
    }

    /**
     * Sets boolean11
     *
     * @param bool|null $boolean11 boolean11
     *
     * @return self
     */
    public function setBoolean11($boolean11)
    {
        if (is_null($boolean11)) {
            array_push($this->openAPINullablesSetToNull, 'boolean11');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('boolean11', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['boolean11'] = $boolean11;

        return $this;
    }

    /**
     * Gets boolean12
     *
     * @return bool|null
     */
    public function getBoolean12()
    {
        return $this->container['boolean12'];
    }

    /**
     * Sets boolean12
     *
     * @param bool|null $boolean12 boolean12
     *
     * @return self
     */
    public function setBoolean12($boolean12)
    {
        if (is_null($boolean12)) {
            array_push($this->openAPINullablesSetToNull, 'boolean12');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('boolean12', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['boolean12'] = $boolean12;

        return $this;
    }

    /**
     * Gets boolean13
     *
     * @return bool|null
     */
    public function getBoolean13()
    {
        return $this->container['boolean13'];
    }

    /**
     * Sets boolean13
     *
     * @param bool|null $boolean13 boolean13
     *
     * @return self
     */
    public function setBoolean13($boolean13)
    {
        if (is_null($boolean13)) {
            array_push($this->openAPINullablesSetToNull, 'boolean13');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('boolean13', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['boolean13'] = $boolean13;

        return $this;
    }

    /**
     * Gets boolean14
     *
     * @return bool|null
     */
    public function getBoolean14()
    {
        return $this->container['boolean14'];
    }

    /**
     * Sets boolean14
     *
     * @param bool|null $boolean14 boolean14
     *
     * @return self
     */
    public function setBoolean14($boolean14)
    {
        if (is_null($boolean14)) {
            array_push($this->openAPINullablesSetToNull, 'boolean14');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('boolean14', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['boolean14'] = $boolean14;

        return $this;
    }

    /**
     * Gets boolean15
     *
     * @return bool|null
     */
    public function getBoolean15()
    {
        return $this->container['boolean15'];
    }

    /**
     * Sets boolean15
     *
     * @param bool|null $boolean15 boolean15
     *
     * @return self
     */
    public function setBoolean15($boolean15)
    {
        if (is_null($boolean15)) {
            array_push($this->openAPINullablesSetToNull, 'boolean15');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('boolean15', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['boolean15'] = $boolean15;

        return $this;
    }

    /**
     * Gets boolean16
     *
     * @return bool|null
     */
    public function getBoolean16()
    {
        return $this->container['boolean16'];
    }

    /**
     * Sets boolean16
     *
     * @param bool|null $boolean16 boolean16
     *
     * @return self
     */
    public function setBoolean16($boolean16)
    {
        if (is_null($boolean16)) {
            array_push($this->openAPINullablesSetToNull, 'boolean16');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('boolean16', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['boolean16'] = $boolean16;

        return $this;
    }

    /**
     * Gets boolean17
     *
     * @return bool|null
     */
    public function getBoolean17()
    {
        return $this->container['boolean17'];
    }

    /**
     * Sets boolean17
     *
     * @param bool|null $boolean17 boolean17
     *
     * @return self
     */
    public function setBoolean17($boolean17)
    {
        if (is_null($boolean17)) {
            array_push($this->openAPINullablesSetToNull, 'boolean17');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('boolean17', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['boolean17'] = $boolean17;

        return $this;
    }

    /**
     * Gets boolean18
     *
     * @return bool|null
     */
    public function getBoolean18()
    {
        return $this->container['boolean18'];
    }

    /**
     * Sets boolean18
     *
     * @param bool|null $boolean18 boolean18
     *
     * @return self
     */
    public function setBoolean18($boolean18)
    {
        if (is_null($boolean18)) {
            array_push($this->openAPINullablesSetToNull, 'boolean18');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('boolean18', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['boolean18'] = $boolean18;

        return $this;
    }

    /**
     * Gets boolean19
     *
     * @return bool|null
     */
    public function getBoolean19()
    {
        return $this->container['boolean19'];
    }

    /**
     * Sets boolean19
     *
     * @param bool|null $boolean19 boolean19
     *
     * @return self
     */
    public function setBoolean19($boolean19)
    {
        if (is_null($boolean19)) {
            array_push($this->openAPINullablesSetToNull, 'boolean19');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('boolean19', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['boolean19'] = $boolean19;

        return $this;
    }

    /**
     * Gets boolean20
     *
     * @return bool|null
     */
    public function getBoolean20()
    {
        return $this->container['boolean20'];
    }

    /**
     * Sets boolean20
     *
     * @param bool|null $boolean20 boolean20
     *
     * @return self
     */
    public function setBoolean20($boolean20)
    {
        if (is_null($boolean20)) {
            array_push($this->openAPINullablesSetToNull, 'boolean20');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('boolean20', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['boolean20'] = $boolean20;

        return $this;
    }

    /**
     * Gets list_item01
     *
     * @return string|null
     */
    public function getListItem01()
    {
        return $this->container['list_item01'];
    }

    /**
     * Sets list_item01
     *
     * @param string|null $list_item01 list_item01
     *
     * @return self
     */
    public function setListItem01($list_item01)
    {
        if (is_null($list_item01)) {
            array_push($this->openAPINullablesSetToNull, 'list_item01');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('list_item01', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['list_item01'] = $list_item01;

        return $this;
    }

    /**
     * Gets list_item02
     *
     * @return string|null
     */
    public function getListItem02()
    {
        return $this->container['list_item02'];
    }

    /**
     * Sets list_item02
     *
     * @param string|null $list_item02 list_item02
     *
     * @return self
     */
    public function setListItem02($list_item02)
    {
        if (is_null($list_item02)) {
            array_push($this->openAPINullablesSetToNull, 'list_item02');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('list_item02', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['list_item02'] = $list_item02;

        return $this;
    }

    /**
     * Gets list_item03
     *
     * @return string|null
     */
    public function getListItem03()
    {
        return $this->container['list_item03'];
    }

    /**
     * Sets list_item03
     *
     * @param string|null $list_item03 list_item03
     *
     * @return self
     */
    public function setListItem03($list_item03)
    {
        if (is_null($list_item03)) {
            array_push($this->openAPINullablesSetToNull, 'list_item03');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('list_item03', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['list_item03'] = $list_item03;

        return $this;
    }

    /**
     * Gets list_item04
     *
     * @return string|null
     */
    public function getListItem04()
    {
        return $this->container['list_item04'];
    }

    /**
     * Sets list_item04
     *
     * @param string|null $list_item04 list_item04
     *
     * @return self
     */
    public function setListItem04($list_item04)
    {
        if (is_null($list_item04)) {
            array_push($this->openAPINullablesSetToNull, 'list_item04');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('list_item04', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['list_item04'] = $list_item04;

        return $this;
    }

    /**
     * Gets list_item05
     *
     * @return string|null
     */
    public function getListItem05()
    {
        return $this->container['list_item05'];
    }

    /**
     * Sets list_item05
     *
     * @param string|null $list_item05 list_item05
     *
     * @return self
     */
    public function setListItem05($list_item05)
    {
        if (is_null($list_item05)) {
            array_push($this->openAPINullablesSetToNull, 'list_item05');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('list_item05', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['list_item05'] = $list_item05;

        return $this;
    }

    /**
     * Gets list_item06
     *
     * @return string|null
     */
    public function getListItem06()
    {
        return $this->container['list_item06'];
    }

    /**
     * Sets list_item06
     *
     * @param string|null $list_item06 list_item06
     *
     * @return self
     */
    public function setListItem06($list_item06)
    {
        if (is_null($list_item06)) {
            array_push($this->openAPINullablesSetToNull, 'list_item06');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('list_item06', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['list_item06'] = $list_item06;

        return $this;
    }

    /**
     * Gets list_item07
     *
     * @return string|null
     */
    public function getListItem07()
    {
        return $this->container['list_item07'];
    }

    /**
     * Sets list_item07
     *
     * @param string|null $list_item07 list_item07
     *
     * @return self
     */
    public function setListItem07($list_item07)
    {
        if (is_null($list_item07)) {
            array_push($this->openAPINullablesSetToNull, 'list_item07');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('list_item07', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['list_item07'] = $list_item07;

        return $this;
    }

    /**
     * Gets list_item08
     *
     * @return string|null
     */
    public function getListItem08()
    {
        return $this->container['list_item08'];
    }

    /**
     * Sets list_item08
     *
     * @param string|null $list_item08 list_item08
     *
     * @return self
     */
    public function setListItem08($list_item08)
    {
        if (is_null($list_item08)) {
            array_push($this->openAPINullablesSetToNull, 'list_item08');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('list_item08', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['list_item08'] = $list_item08;

        return $this;
    }

    /**
     * Gets list_item09
     *
     * @return string|null
     */
    public function getListItem09()
    {
        return $this->container['list_item09'];
    }

    /**
     * Sets list_item09
     *
     * @param string|null $list_item09 list_item09
     *
     * @return self
     */
    public function setListItem09($list_item09)
    {
        if (is_null($list_item09)) {
            array_push($this->openAPINullablesSetToNull, 'list_item09');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('list_item09', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['list_item09'] = $list_item09;

        return $this;
    }

    /**
     * Gets list_item10
     *
     * @return string|null
     */
    public function getListItem10()
    {
        return $this->container['list_item10'];
    }

    /**
     * Sets list_item10
     *
     * @param string|null $list_item10 list_item10
     *
     * @return self
     */
    public function setListItem10($list_item10)
    {
        if (is_null($list_item10)) {
            array_push($this->openAPINullablesSetToNull, 'list_item10');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('list_item10', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['list_item10'] = $list_item10;

        return $this;
    }

    /**
     * Gets list_item11
     *
     * @return string|null
     */
    public function getListItem11()
    {
        return $this->container['list_item11'];
    }

    /**
     * Sets list_item11
     *
     * @param string|null $list_item11 list_item11
     *
     * @return self
     */
    public function setListItem11($list_item11)
    {
        if (is_null($list_item11)) {
            array_push($this->openAPINullablesSetToNull, 'list_item11');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('list_item11', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['list_item11'] = $list_item11;

        return $this;
    }

    /**
     * Gets list_item12
     *
     * @return string|null
     */
    public function getListItem12()
    {
        return $this->container['list_item12'];
    }

    /**
     * Sets list_item12
     *
     * @param string|null $list_item12 list_item12
     *
     * @return self
     */
    public function setListItem12($list_item12)
    {
        if (is_null($list_item12)) {
            array_push($this->openAPINullablesSetToNull, 'list_item12');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('list_item12', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['list_item12'] = $list_item12;

        return $this;
    }

    /**
     * Gets list_item13
     *
     * @return string|null
     */
    public function getListItem13()
    {
        return $this->container['list_item13'];
    }

    /**
     * Sets list_item13
     *
     * @param string|null $list_item13 list_item13
     *
     * @return self
     */
    public function setListItem13($list_item13)
    {
        if (is_null($list_item13)) {
            array_push($this->openAPINullablesSetToNull, 'list_item13');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('list_item13', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['list_item13'] = $list_item13;

        return $this;
    }

    /**
     * Gets list_item14
     *
     * @return string|null
     */
    public function getListItem14()
    {
        return $this->container['list_item14'];
    }

    /**
     * Sets list_item14
     *
     * @param string|null $list_item14 list_item14
     *
     * @return self
     */
    public function setListItem14($list_item14)
    {
        if (is_null($list_item14)) {
            array_push($this->openAPINullablesSetToNull, 'list_item14');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('list_item14', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['list_item14'] = $list_item14;

        return $this;
    }

    /**
     * Gets list_item15
     *
     * @return string|null
     */
    public function getListItem15()
    {
        return $this->container['list_item15'];
    }

    /**
     * Sets list_item15
     *
     * @param string|null $list_item15 list_item15
     *
     * @return self
     */
    public function setListItem15($list_item15)
    {
        if (is_null($list_item15)) {
            array_push($this->openAPINullablesSetToNull, 'list_item15');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('list_item15', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['list_item15'] = $list_item15;

        return $this;
    }

    /**
     * Gets list_item16
     *
     * @return string|null
     */
    public function getListItem16()
    {
        return $this->container['list_item16'];
    }

    /**
     * Sets list_item16
     *
     * @param string|null $list_item16 list_item16
     *
     * @return self
     */
    public function setListItem16($list_item16)
    {
        if (is_null($list_item16)) {
            array_push($this->openAPINullablesSetToNull, 'list_item16');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('list_item16', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['list_item16'] = $list_item16;

        return $this;
    }

    /**
     * Gets list_item17
     *
     * @return string|null
     */
    public function getListItem17()
    {
        return $this->container['list_item17'];
    }

    /**
     * Sets list_item17
     *
     * @param string|null $list_item17 list_item17
     *
     * @return self
     */
    public function setListItem17($list_item17)
    {
        if (is_null($list_item17)) {
            array_push($this->openAPINullablesSetToNull, 'list_item17');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('list_item17', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['list_item17'] = $list_item17;

        return $this;
    }

    /**
     * Gets list_item18
     *
     * @return string|null
     */
    public function getListItem18()
    {
        return $this->container['list_item18'];
    }

    /**
     * Sets list_item18
     *
     * @param string|null $list_item18 list_item18
     *
     * @return self
     */
    public function setListItem18($list_item18)
    {
        if (is_null($list_item18)) {
            array_push($this->openAPINullablesSetToNull, 'list_item18');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('list_item18', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['list_item18'] = $list_item18;

        return $this;
    }

    /**
     * Gets list_item19
     *
     * @return string|null
     */
    public function getListItem19()
    {
        return $this->container['list_item19'];
    }

    /**
     * Sets list_item19
     *
     * @param string|null $list_item19 list_item19
     *
     * @return self
     */
    public function setListItem19($list_item19)
    {
        if (is_null($list_item19)) {
            array_push($this->openAPINullablesSetToNull, 'list_item19');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('list_item19', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['list_item19'] = $list_item19;

        return $this;
    }

    /**
     * Gets list_item20
     *
     * @return string|null
     */
    public function getListItem20()
    {
        return $this->container['list_item20'];
    }

    /**
     * Sets list_item20
     *
     * @param string|null $list_item20 list_item20
     *
     * @return self
     */
    public function setListItem20($list_item20)
    {
        if (is_null($list_item20)) {
            array_push($this->openAPINullablesSetToNull, 'list_item20');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('list_item20', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['list_item20'] = $list_item20;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


