<?php
/**
 * Customer
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * Customer Class Doc Comment
 *
 * @category Class
 * @description Represents a customer with billing and ship to contact details
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Customer implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Customer';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'customer_id' => 'int',
        'origination_location_id' => 'int',
        'location_group_id' => 'int',
        'account_number' => 'string',
        'account_type_id' => 'int',
        'custom_date1' => '\DateTime',
        'custom_date2' => '\DateTime',
        'custom_date3' => '\DateTime',
        'custom_date4' => '\DateTime',
        'custom_date5' => '\DateTime',
        'custom_number1' => 'float',
        'custom_number2' => 'float',
        'custom_number3' => 'float',
        'custom_number4' => 'float',
        'custom_number5' => 'float',
        'custom_text1' => 'string',
        'custom_text2' => 'string',
        'custom_text3' => 'string',
        'custom_text4' => 'string',
        'custom_text5' => 'string',
        'last_starting_date' => '\DateTime',
        'last_closing_date' => '\DateTime',
        'last_updated' => '\DateTime',
        'credit_limit' => 'float',
        'last_visit' => '\DateTime',
        'tax_exempt' => 'bool',
        'notes' => 'string',
        'active' => 'bool',
        'is_employee' => 'bool',
        'referred_by' => 'int',
        'referred_by_account_number' => 'string',
        'opt_in_email' => 'bool',
        'opt_in_direct_mail' => 'bool',
        'opt_in_telephone' => 'bool',
        'billing_contact_id' => 'int',
        'billing_email' => 'string',
        'billing_title' => 'string',
        'billing_first_name' => 'string',
        'billing_last_name' => 'string',
        'billing_date_of_birth' => '\DateTime',
        'billing_company' => 'string',
        'billing_address_line1' => 'string',
        'billing_address_line2' => 'string',
        'billing_address_line3' => 'string',
        'billing_address_line4' => 'string',
        'billing_city' => 'string',
        'billing_territory' => 'string',
        'billing_zip' => 'string',
        'billing_iso_country_code' => 'string',
        'billing_telephone_itu_country_code' => 'string',
        'billing_telephone_number' => 'string',
        'billing_fax_itu_country_code' => 'string',
        'billing_fax_number' => 'string',
        'ship_to_contact_id' => 'int',
        'ship_to_email' => 'string',
        'ship_to_title' => 'string',
        'ship_to_first_name' => 'string',
        'ship_to_last_name' => 'string',
        'ship_to_date_of_birth' => '\DateTime',
        'ship_to_company' => 'string',
        'ship_to_address_line1' => 'string',
        'ship_to_address_line2' => 'string',
        'ship_to_address_line3' => 'string',
        'ship_to_address_line4' => 'string',
        'ship_to_city' => 'string',
        'ship_to_territory' => 'string',
        'ship_to_zip' => 'string',
        'ship_to_iso_country_code' => 'string',
        'ship_to_telephone_itu_country_code' => 'string',
        'ship_to_telephone_number' => 'string',
        'ship_to_fax_itu_country_code' => 'string',
        'ship_to_fax_number' => 'string',
        'community_ids' => 'int[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'customer_id' => 'int32',
        'origination_location_id' => 'int32',
        'location_group_id' => 'int32',
        'account_number' => null,
        'account_type_id' => 'int32',
        'custom_date1' => 'date-time',
        'custom_date2' => 'date-time',
        'custom_date3' => 'date-time',
        'custom_date4' => 'date-time',
        'custom_date5' => 'date-time',
        'custom_number1' => 'double',
        'custom_number2' => 'double',
        'custom_number3' => 'double',
        'custom_number4' => 'double',
        'custom_number5' => 'double',
        'custom_text1' => null,
        'custom_text2' => null,
        'custom_text3' => null,
        'custom_text4' => null,
        'custom_text5' => null,
        'last_starting_date' => 'date-time',
        'last_closing_date' => 'date-time',
        'last_updated' => 'date-time',
        'credit_limit' => 'double',
        'last_visit' => 'date-time',
        'tax_exempt' => null,
        'notes' => null,
        'active' => null,
        'is_employee' => null,
        'referred_by' => 'int32',
        'referred_by_account_number' => null,
        'opt_in_email' => null,
        'opt_in_direct_mail' => null,
        'opt_in_telephone' => null,
        'billing_contact_id' => 'int32',
        'billing_email' => null,
        'billing_title' => null,
        'billing_first_name' => null,
        'billing_last_name' => null,
        'billing_date_of_birth' => 'date-time',
        'billing_company' => null,
        'billing_address_line1' => null,
        'billing_address_line2' => null,
        'billing_address_line3' => null,
        'billing_address_line4' => null,
        'billing_city' => null,
        'billing_territory' => null,
        'billing_zip' => null,
        'billing_iso_country_code' => null,
        'billing_telephone_itu_country_code' => null,
        'billing_telephone_number' => null,
        'billing_fax_itu_country_code' => null,
        'billing_fax_number' => null,
        'ship_to_contact_id' => 'int32',
        'ship_to_email' => null,
        'ship_to_title' => null,
        'ship_to_first_name' => null,
        'ship_to_last_name' => null,
        'ship_to_date_of_birth' => 'date-time',
        'ship_to_company' => null,
        'ship_to_address_line1' => null,
        'ship_to_address_line2' => null,
        'ship_to_address_line3' => null,
        'ship_to_address_line4' => null,
        'ship_to_city' => null,
        'ship_to_territory' => null,
        'ship_to_zip' => null,
        'ship_to_iso_country_code' => null,
        'ship_to_telephone_itu_country_code' => null,
        'ship_to_telephone_number' => null,
        'ship_to_fax_itu_country_code' => null,
        'ship_to_fax_number' => null,
        'community_ids' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'customer_id' => false,
        'origination_location_id' => false,
        'location_group_id' => false,
        'account_number' => false,
        'account_type_id' => true,
        'custom_date1' => true,
        'custom_date2' => true,
        'custom_date3' => true,
        'custom_date4' => true,
        'custom_date5' => true,
        'custom_number1' => true,
        'custom_number2' => true,
        'custom_number3' => true,
        'custom_number4' => true,
        'custom_number5' => true,
        'custom_text1' => true,
        'custom_text2' => true,
        'custom_text3' => true,
        'custom_text4' => true,
        'custom_text5' => true,
        'last_starting_date' => true,
        'last_closing_date' => true,
        'last_updated' => true,
        'credit_limit' => false,
        'last_visit' => true,
        'tax_exempt' => false,
        'notes' => true,
        'active' => false,
        'is_employee' => false,
        'referred_by' => true,
        'referred_by_account_number' => true,
        'opt_in_email' => false,
        'opt_in_direct_mail' => false,
        'opt_in_telephone' => false,
        'billing_contact_id' => false,
        'billing_email' => false,
        'billing_title' => true,
        'billing_first_name' => false,
        'billing_last_name' => false,
        'billing_date_of_birth' => true,
        'billing_company' => true,
        'billing_address_line1' => true,
        'billing_address_line2' => true,
        'billing_address_line3' => true,
        'billing_address_line4' => true,
        'billing_city' => false,
        'billing_territory' => false,
        'billing_zip' => false,
        'billing_iso_country_code' => true,
        'billing_telephone_itu_country_code' => true,
        'billing_telephone_number' => false,
        'billing_fax_itu_country_code' => true,
        'billing_fax_number' => true,
        'ship_to_contact_id' => false,
        'ship_to_email' => false,
        'ship_to_title' => true,
        'ship_to_first_name' => false,
        'ship_to_last_name' => false,
        'ship_to_date_of_birth' => true,
        'ship_to_company' => true,
        'ship_to_address_line1' => true,
        'ship_to_address_line2' => true,
        'ship_to_address_line3' => true,
        'ship_to_address_line4' => true,
        'ship_to_city' => false,
        'ship_to_territory' => false,
        'ship_to_zip' => false,
        'ship_to_iso_country_code' => true,
        'ship_to_telephone_itu_country_code' => true,
        'ship_to_telephone_number' => false,
        'ship_to_fax_itu_country_code' => true,
        'ship_to_fax_number' => true,
        'community_ids' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'customer_id' => 'customerId',
        'origination_location_id' => 'originationLocationId',
        'location_group_id' => 'locationGroupId',
        'account_number' => 'accountNumber',
        'account_type_id' => 'accountTypeId',
        'custom_date1' => 'customDate1',
        'custom_date2' => 'customDate2',
        'custom_date3' => 'customDate3',
        'custom_date4' => 'customDate4',
        'custom_date5' => 'customDate5',
        'custom_number1' => 'customNumber1',
        'custom_number2' => 'customNumber2',
        'custom_number3' => 'customNumber3',
        'custom_number4' => 'customNumber4',
        'custom_number5' => 'customNumber5',
        'custom_text1' => 'customText1',
        'custom_text2' => 'customText2',
        'custom_text3' => 'customText3',
        'custom_text4' => 'customText4',
        'custom_text5' => 'customText5',
        'last_starting_date' => 'lastStartingDate',
        'last_closing_date' => 'lastClosingDate',
        'last_updated' => 'lastUpdated',
        'credit_limit' => 'creditLimit',
        'last_visit' => 'lastVisit',
        'tax_exempt' => 'taxExempt',
        'notes' => 'notes',
        'active' => 'active',
        'is_employee' => 'isEmployee',
        'referred_by' => 'referredBy',
        'referred_by_account_number' => 'referredByAccountNumber',
        'opt_in_email' => 'optInEmail',
        'opt_in_direct_mail' => 'optInDirectMail',
        'opt_in_telephone' => 'optInTelephone',
        'billing_contact_id' => 'billingContactId',
        'billing_email' => 'billingEmail',
        'billing_title' => 'billingTitle',
        'billing_first_name' => 'billingFirstName',
        'billing_last_name' => 'billingLastName',
        'billing_date_of_birth' => 'billingDateOfBirth',
        'billing_company' => 'billingCompany',
        'billing_address_line1' => 'billingAddressLine1',
        'billing_address_line2' => 'billingAddressLine2',
        'billing_address_line3' => 'billingAddressLine3',
        'billing_address_line4' => 'billingAddressLine4',
        'billing_city' => 'billingCity',
        'billing_territory' => 'billingTerritory',
        'billing_zip' => 'billingZip',
        'billing_iso_country_code' => 'billingIsoCountryCode',
        'billing_telephone_itu_country_code' => 'billingTelephoneItuCountryCode',
        'billing_telephone_number' => 'billingTelephoneNumber',
        'billing_fax_itu_country_code' => 'billingFaxItuCountryCode',
        'billing_fax_number' => 'billingFaxNumber',
        'ship_to_contact_id' => 'shipToContactId',
        'ship_to_email' => 'shipToEmail',
        'ship_to_title' => 'shipToTitle',
        'ship_to_first_name' => 'shipToFirstName',
        'ship_to_last_name' => 'shipToLastName',
        'ship_to_date_of_birth' => 'shipToDateOfBirth',
        'ship_to_company' => 'shipToCompany',
        'ship_to_address_line1' => 'shipToAddressLine1',
        'ship_to_address_line2' => 'shipToAddressLine2',
        'ship_to_address_line3' => 'shipToAddressLine3',
        'ship_to_address_line4' => 'shipToAddressLine4',
        'ship_to_city' => 'shipToCity',
        'ship_to_territory' => 'shipToTerritory',
        'ship_to_zip' => 'shipToZip',
        'ship_to_iso_country_code' => 'shipToIsoCountryCode',
        'ship_to_telephone_itu_country_code' => 'shipToTelephoneItuCountryCode',
        'ship_to_telephone_number' => 'shipToTelephoneNumber',
        'ship_to_fax_itu_country_code' => 'shipToFaxItuCountryCode',
        'ship_to_fax_number' => 'shipToFaxNumber',
        'community_ids' => 'communityIds'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'customer_id' => 'setCustomerId',
        'origination_location_id' => 'setOriginationLocationId',
        'location_group_id' => 'setLocationGroupId',
        'account_number' => 'setAccountNumber',
        'account_type_id' => 'setAccountTypeId',
        'custom_date1' => 'setCustomDate1',
        'custom_date2' => 'setCustomDate2',
        'custom_date3' => 'setCustomDate3',
        'custom_date4' => 'setCustomDate4',
        'custom_date5' => 'setCustomDate5',
        'custom_number1' => 'setCustomNumber1',
        'custom_number2' => 'setCustomNumber2',
        'custom_number3' => 'setCustomNumber3',
        'custom_number4' => 'setCustomNumber4',
        'custom_number5' => 'setCustomNumber5',
        'custom_text1' => 'setCustomText1',
        'custom_text2' => 'setCustomText2',
        'custom_text3' => 'setCustomText3',
        'custom_text4' => 'setCustomText4',
        'custom_text5' => 'setCustomText5',
        'last_starting_date' => 'setLastStartingDate',
        'last_closing_date' => 'setLastClosingDate',
        'last_updated' => 'setLastUpdated',
        'credit_limit' => 'setCreditLimit',
        'last_visit' => 'setLastVisit',
        'tax_exempt' => 'setTaxExempt',
        'notes' => 'setNotes',
        'active' => 'setActive',
        'is_employee' => 'setIsEmployee',
        'referred_by' => 'setReferredBy',
        'referred_by_account_number' => 'setReferredByAccountNumber',
        'opt_in_email' => 'setOptInEmail',
        'opt_in_direct_mail' => 'setOptInDirectMail',
        'opt_in_telephone' => 'setOptInTelephone',
        'billing_contact_id' => 'setBillingContactId',
        'billing_email' => 'setBillingEmail',
        'billing_title' => 'setBillingTitle',
        'billing_first_name' => 'setBillingFirstName',
        'billing_last_name' => 'setBillingLastName',
        'billing_date_of_birth' => 'setBillingDateOfBirth',
        'billing_company' => 'setBillingCompany',
        'billing_address_line1' => 'setBillingAddressLine1',
        'billing_address_line2' => 'setBillingAddressLine2',
        'billing_address_line3' => 'setBillingAddressLine3',
        'billing_address_line4' => 'setBillingAddressLine4',
        'billing_city' => 'setBillingCity',
        'billing_territory' => 'setBillingTerritory',
        'billing_zip' => 'setBillingZip',
        'billing_iso_country_code' => 'setBillingIsoCountryCode',
        'billing_telephone_itu_country_code' => 'setBillingTelephoneItuCountryCode',
        'billing_telephone_number' => 'setBillingTelephoneNumber',
        'billing_fax_itu_country_code' => 'setBillingFaxItuCountryCode',
        'billing_fax_number' => 'setBillingFaxNumber',
        'ship_to_contact_id' => 'setShipToContactId',
        'ship_to_email' => 'setShipToEmail',
        'ship_to_title' => 'setShipToTitle',
        'ship_to_first_name' => 'setShipToFirstName',
        'ship_to_last_name' => 'setShipToLastName',
        'ship_to_date_of_birth' => 'setShipToDateOfBirth',
        'ship_to_company' => 'setShipToCompany',
        'ship_to_address_line1' => 'setShipToAddressLine1',
        'ship_to_address_line2' => 'setShipToAddressLine2',
        'ship_to_address_line3' => 'setShipToAddressLine3',
        'ship_to_address_line4' => 'setShipToAddressLine4',
        'ship_to_city' => 'setShipToCity',
        'ship_to_territory' => 'setShipToTerritory',
        'ship_to_zip' => 'setShipToZip',
        'ship_to_iso_country_code' => 'setShipToIsoCountryCode',
        'ship_to_telephone_itu_country_code' => 'setShipToTelephoneItuCountryCode',
        'ship_to_telephone_number' => 'setShipToTelephoneNumber',
        'ship_to_fax_itu_country_code' => 'setShipToFaxItuCountryCode',
        'ship_to_fax_number' => 'setShipToFaxNumber',
        'community_ids' => 'setCommunityIds'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'customer_id' => 'getCustomerId',
        'origination_location_id' => 'getOriginationLocationId',
        'location_group_id' => 'getLocationGroupId',
        'account_number' => 'getAccountNumber',
        'account_type_id' => 'getAccountTypeId',
        'custom_date1' => 'getCustomDate1',
        'custom_date2' => 'getCustomDate2',
        'custom_date3' => 'getCustomDate3',
        'custom_date4' => 'getCustomDate4',
        'custom_date5' => 'getCustomDate5',
        'custom_number1' => 'getCustomNumber1',
        'custom_number2' => 'getCustomNumber2',
        'custom_number3' => 'getCustomNumber3',
        'custom_number4' => 'getCustomNumber4',
        'custom_number5' => 'getCustomNumber5',
        'custom_text1' => 'getCustomText1',
        'custom_text2' => 'getCustomText2',
        'custom_text3' => 'getCustomText3',
        'custom_text4' => 'getCustomText4',
        'custom_text5' => 'getCustomText5',
        'last_starting_date' => 'getLastStartingDate',
        'last_closing_date' => 'getLastClosingDate',
        'last_updated' => 'getLastUpdated',
        'credit_limit' => 'getCreditLimit',
        'last_visit' => 'getLastVisit',
        'tax_exempt' => 'getTaxExempt',
        'notes' => 'getNotes',
        'active' => 'getActive',
        'is_employee' => 'getIsEmployee',
        'referred_by' => 'getReferredBy',
        'referred_by_account_number' => 'getReferredByAccountNumber',
        'opt_in_email' => 'getOptInEmail',
        'opt_in_direct_mail' => 'getOptInDirectMail',
        'opt_in_telephone' => 'getOptInTelephone',
        'billing_contact_id' => 'getBillingContactId',
        'billing_email' => 'getBillingEmail',
        'billing_title' => 'getBillingTitle',
        'billing_first_name' => 'getBillingFirstName',
        'billing_last_name' => 'getBillingLastName',
        'billing_date_of_birth' => 'getBillingDateOfBirth',
        'billing_company' => 'getBillingCompany',
        'billing_address_line1' => 'getBillingAddressLine1',
        'billing_address_line2' => 'getBillingAddressLine2',
        'billing_address_line3' => 'getBillingAddressLine3',
        'billing_address_line4' => 'getBillingAddressLine4',
        'billing_city' => 'getBillingCity',
        'billing_territory' => 'getBillingTerritory',
        'billing_zip' => 'getBillingZip',
        'billing_iso_country_code' => 'getBillingIsoCountryCode',
        'billing_telephone_itu_country_code' => 'getBillingTelephoneItuCountryCode',
        'billing_telephone_number' => 'getBillingTelephoneNumber',
        'billing_fax_itu_country_code' => 'getBillingFaxItuCountryCode',
        'billing_fax_number' => 'getBillingFaxNumber',
        'ship_to_contact_id' => 'getShipToContactId',
        'ship_to_email' => 'getShipToEmail',
        'ship_to_title' => 'getShipToTitle',
        'ship_to_first_name' => 'getShipToFirstName',
        'ship_to_last_name' => 'getShipToLastName',
        'ship_to_date_of_birth' => 'getShipToDateOfBirth',
        'ship_to_company' => 'getShipToCompany',
        'ship_to_address_line1' => 'getShipToAddressLine1',
        'ship_to_address_line2' => 'getShipToAddressLine2',
        'ship_to_address_line3' => 'getShipToAddressLine3',
        'ship_to_address_line4' => 'getShipToAddressLine4',
        'ship_to_city' => 'getShipToCity',
        'ship_to_territory' => 'getShipToTerritory',
        'ship_to_zip' => 'getShipToZip',
        'ship_to_iso_country_code' => 'getShipToIsoCountryCode',
        'ship_to_telephone_itu_country_code' => 'getShipToTelephoneItuCountryCode',
        'ship_to_telephone_number' => 'getShipToTelephoneNumber',
        'ship_to_fax_itu_country_code' => 'getShipToFaxItuCountryCode',
        'ship_to_fax_number' => 'getShipToFaxNumber',
        'community_ids' => 'getCommunityIds'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('customer_id', $data ?? [], null);
        $this->setIfExists('origination_location_id', $data ?? [], null);
        $this->setIfExists('location_group_id', $data ?? [], null);
        $this->setIfExists('account_number', $data ?? [], null);
        $this->setIfExists('account_type_id', $data ?? [], null);
        $this->setIfExists('custom_date1', $data ?? [], null);
        $this->setIfExists('custom_date2', $data ?? [], null);
        $this->setIfExists('custom_date3', $data ?? [], null);
        $this->setIfExists('custom_date4', $data ?? [], null);
        $this->setIfExists('custom_date5', $data ?? [], null);
        $this->setIfExists('custom_number1', $data ?? [], null);
        $this->setIfExists('custom_number2', $data ?? [], null);
        $this->setIfExists('custom_number3', $data ?? [], null);
        $this->setIfExists('custom_number4', $data ?? [], null);
        $this->setIfExists('custom_number5', $data ?? [], null);
        $this->setIfExists('custom_text1', $data ?? [], null);
        $this->setIfExists('custom_text2', $data ?? [], null);
        $this->setIfExists('custom_text3', $data ?? [], null);
        $this->setIfExists('custom_text4', $data ?? [], null);
        $this->setIfExists('custom_text5', $data ?? [], null);
        $this->setIfExists('last_starting_date', $data ?? [], null);
        $this->setIfExists('last_closing_date', $data ?? [], null);
        $this->setIfExists('last_updated', $data ?? [], null);
        $this->setIfExists('credit_limit', $data ?? [], null);
        $this->setIfExists('last_visit', $data ?? [], null);
        $this->setIfExists('tax_exempt', $data ?? [], false);
        $this->setIfExists('notes', $data ?? [], null);
        $this->setIfExists('active', $data ?? [], null);
        $this->setIfExists('is_employee', $data ?? [], false);
        $this->setIfExists('referred_by', $data ?? [], null);
        $this->setIfExists('referred_by_account_number', $data ?? [], null);
        $this->setIfExists('opt_in_email', $data ?? [], false);
        $this->setIfExists('opt_in_direct_mail', $data ?? [], false);
        $this->setIfExists('opt_in_telephone', $data ?? [], false);
        $this->setIfExists('billing_contact_id', $data ?? [], null);
        $this->setIfExists('billing_email', $data ?? [], null);
        $this->setIfExists('billing_title', $data ?? [], null);
        $this->setIfExists('billing_first_name', $data ?? [], null);
        $this->setIfExists('billing_last_name', $data ?? [], null);
        $this->setIfExists('billing_date_of_birth', $data ?? [], null);
        $this->setIfExists('billing_company', $data ?? [], null);
        $this->setIfExists('billing_address_line1', $data ?? [], null);
        $this->setIfExists('billing_address_line2', $data ?? [], null);
        $this->setIfExists('billing_address_line3', $data ?? [], null);
        $this->setIfExists('billing_address_line4', $data ?? [], null);
        $this->setIfExists('billing_city', $data ?? [], null);
        $this->setIfExists('billing_territory', $data ?? [], null);
        $this->setIfExists('billing_zip', $data ?? [], null);
        $this->setIfExists('billing_iso_country_code', $data ?? [], null);
        $this->setIfExists('billing_telephone_itu_country_code', $data ?? [], null);
        $this->setIfExists('billing_telephone_number', $data ?? [], null);
        $this->setIfExists('billing_fax_itu_country_code', $data ?? [], null);
        $this->setIfExists('billing_fax_number', $data ?? [], null);
        $this->setIfExists('ship_to_contact_id', $data ?? [], null);
        $this->setIfExists('ship_to_email', $data ?? [], null);
        $this->setIfExists('ship_to_title', $data ?? [], null);
        $this->setIfExists('ship_to_first_name', $data ?? [], null);
        $this->setIfExists('ship_to_last_name', $data ?? [], null);
        $this->setIfExists('ship_to_date_of_birth', $data ?? [], null);
        $this->setIfExists('ship_to_company', $data ?? [], null);
        $this->setIfExists('ship_to_address_line1', $data ?? [], null);
        $this->setIfExists('ship_to_address_line2', $data ?? [], null);
        $this->setIfExists('ship_to_address_line3', $data ?? [], null);
        $this->setIfExists('ship_to_address_line4', $data ?? [], null);
        $this->setIfExists('ship_to_city', $data ?? [], null);
        $this->setIfExists('ship_to_territory', $data ?? [], null);
        $this->setIfExists('ship_to_zip', $data ?? [], null);
        $this->setIfExists('ship_to_iso_country_code', $data ?? [], null);
        $this->setIfExists('ship_to_telephone_itu_country_code', $data ?? [], null);
        $this->setIfExists('ship_to_telephone_number', $data ?? [], null);
        $this->setIfExists('ship_to_fax_itu_country_code', $data ?? [], null);
        $this->setIfExists('ship_to_fax_number', $data ?? [], null);
        $this->setIfExists('community_ids', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['origination_location_id'] === null) {
            $invalidProperties[] = "'origination_location_id' can't be null";
        }
        if ($this->container['location_group_id'] === null) {
            $invalidProperties[] = "'location_group_id' can't be null";
        }
        if ($this->container['account_number'] === null) {
            $invalidProperties[] = "'account_number' can't be null";
        }
        if ((mb_strlen($this->container['account_number']) > 20)) {
            $invalidProperties[] = "invalid value for 'account_number', the character length must be smaller than or equal to 20.";
        }

        if ((mb_strlen($this->container['account_number']) < 0)) {
            $invalidProperties[] = "invalid value for 'account_number', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['custom_text1']) && (mb_strlen($this->container['custom_text1']) > 30)) {
            $invalidProperties[] = "invalid value for 'custom_text1', the character length must be smaller than or equal to 30.";
        }

        if (!is_null($this->container['custom_text1']) && (mb_strlen($this->container['custom_text1']) < 0)) {
            $invalidProperties[] = "invalid value for 'custom_text1', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['custom_text2']) && (mb_strlen($this->container['custom_text2']) > 30)) {
            $invalidProperties[] = "invalid value for 'custom_text2', the character length must be smaller than or equal to 30.";
        }

        if (!is_null($this->container['custom_text2']) && (mb_strlen($this->container['custom_text2']) < 0)) {
            $invalidProperties[] = "invalid value for 'custom_text2', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['custom_text3']) && (mb_strlen($this->container['custom_text3']) > 30)) {
            $invalidProperties[] = "invalid value for 'custom_text3', the character length must be smaller than or equal to 30.";
        }

        if (!is_null($this->container['custom_text3']) && (mb_strlen($this->container['custom_text3']) < 0)) {
            $invalidProperties[] = "invalid value for 'custom_text3', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['custom_text4']) && (mb_strlen($this->container['custom_text4']) > 30)) {
            $invalidProperties[] = "invalid value for 'custom_text4', the character length must be smaller than or equal to 30.";
        }

        if (!is_null($this->container['custom_text4']) && (mb_strlen($this->container['custom_text4']) < 0)) {
            $invalidProperties[] = "invalid value for 'custom_text4', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['custom_text5']) && (mb_strlen($this->container['custom_text5']) > 30)) {
            $invalidProperties[] = "invalid value for 'custom_text5', the character length must be smaller than or equal to 30.";
        }

        if (!is_null($this->container['custom_text5']) && (mb_strlen($this->container['custom_text5']) < 0)) {
            $invalidProperties[] = "invalid value for 'custom_text5', the character length must be bigger than or equal to 0.";
        }

        if ($this->container['billing_email'] === null) {
            $invalidProperties[] = "'billing_email' can't be null";
        }
        if ((mb_strlen($this->container['billing_email']) > 255)) {
            $invalidProperties[] = "invalid value for 'billing_email', the character length must be smaller than or equal to 255.";
        }

        if ((mb_strlen($this->container['billing_email']) < 0)) {
            $invalidProperties[] = "invalid value for 'billing_email', the character length must be bigger than or equal to 0.";
        }

        if ($this->container['billing_first_name'] === null) {
            $invalidProperties[] = "'billing_first_name' can't be null";
        }
        if ((mb_strlen($this->container['billing_first_name']) > 50)) {
            $invalidProperties[] = "invalid value for 'billing_first_name', the character length must be smaller than or equal to 50.";
        }

        if ((mb_strlen($this->container['billing_first_name']) < 0)) {
            $invalidProperties[] = "invalid value for 'billing_first_name', the character length must be bigger than or equal to 0.";
        }

        if ($this->container['billing_last_name'] === null) {
            $invalidProperties[] = "'billing_last_name' can't be null";
        }
        if ((mb_strlen($this->container['billing_last_name']) > 50)) {
            $invalidProperties[] = "invalid value for 'billing_last_name', the character length must be smaller than or equal to 50.";
        }

        if ((mb_strlen($this->container['billing_last_name']) < 0)) {
            $invalidProperties[] = "invalid value for 'billing_last_name', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['billing_company']) && (mb_strlen($this->container['billing_company']) > 50)) {
            $invalidProperties[] = "invalid value for 'billing_company', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['billing_company']) && (mb_strlen($this->container['billing_company']) < 0)) {
            $invalidProperties[] = "invalid value for 'billing_company', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['billing_address_line1']) && (mb_strlen($this->container['billing_address_line1']) > 50)) {
            $invalidProperties[] = "invalid value for 'billing_address_line1', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['billing_address_line1']) && (mb_strlen($this->container['billing_address_line1']) < 0)) {
            $invalidProperties[] = "invalid value for 'billing_address_line1', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['billing_address_line2']) && (mb_strlen($this->container['billing_address_line2']) > 50)) {
            $invalidProperties[] = "invalid value for 'billing_address_line2', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['billing_address_line2']) && (mb_strlen($this->container['billing_address_line2']) < 0)) {
            $invalidProperties[] = "invalid value for 'billing_address_line2', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['billing_address_line3']) && (mb_strlen($this->container['billing_address_line3']) > 50)) {
            $invalidProperties[] = "invalid value for 'billing_address_line3', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['billing_address_line3']) && (mb_strlen($this->container['billing_address_line3']) < 0)) {
            $invalidProperties[] = "invalid value for 'billing_address_line3', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['billing_address_line4']) && (mb_strlen($this->container['billing_address_line4']) > 50)) {
            $invalidProperties[] = "invalid value for 'billing_address_line4', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['billing_address_line4']) && (mb_strlen($this->container['billing_address_line4']) < 0)) {
            $invalidProperties[] = "invalid value for 'billing_address_line4', the character length must be bigger than or equal to 0.";
        }

        if ($this->container['billing_city'] === null) {
            $invalidProperties[] = "'billing_city' can't be null";
        }
        if ((mb_strlen($this->container['billing_city']) > 50)) {
            $invalidProperties[] = "invalid value for 'billing_city', the character length must be smaller than or equal to 50.";
        }

        if ((mb_strlen($this->container['billing_city']) < 0)) {
            $invalidProperties[] = "invalid value for 'billing_city', the character length must be bigger than or equal to 0.";
        }

        if ($this->container['billing_territory'] === null) {
            $invalidProperties[] = "'billing_territory' can't be null";
        }
        if ((mb_strlen($this->container['billing_territory']) > 50)) {
            $invalidProperties[] = "invalid value for 'billing_territory', the character length must be smaller than or equal to 50.";
        }

        if ((mb_strlen($this->container['billing_territory']) < 0)) {
            $invalidProperties[] = "invalid value for 'billing_territory', the character length must be bigger than or equal to 0.";
        }

        if ($this->container['billing_zip'] === null) {
            $invalidProperties[] = "'billing_zip' can't be null";
        }
        if ((mb_strlen($this->container['billing_zip']) > 50)) {
            $invalidProperties[] = "invalid value for 'billing_zip', the character length must be smaller than or equal to 50.";
        }

        if ((mb_strlen($this->container['billing_zip']) < 0)) {
            $invalidProperties[] = "invalid value for 'billing_zip', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['billing_iso_country_code']) && (mb_strlen($this->container['billing_iso_country_code']) > 4)) {
            $invalidProperties[] = "invalid value for 'billing_iso_country_code', the character length must be smaller than or equal to 4.";
        }

        if (!is_null($this->container['billing_iso_country_code']) && (mb_strlen($this->container['billing_iso_country_code']) < 0)) {
            $invalidProperties[] = "invalid value for 'billing_iso_country_code', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['billing_telephone_itu_country_code']) && (mb_strlen($this->container['billing_telephone_itu_country_code']) > 7)) {
            $invalidProperties[] = "invalid value for 'billing_telephone_itu_country_code', the character length must be smaller than or equal to 7.";
        }

        if (!is_null($this->container['billing_telephone_itu_country_code']) && (mb_strlen($this->container['billing_telephone_itu_country_code']) < 0)) {
            $invalidProperties[] = "invalid value for 'billing_telephone_itu_country_code', the character length must be bigger than or equal to 0.";
        }

        if ($this->container['billing_telephone_number'] === null) {
            $invalidProperties[] = "'billing_telephone_number' can't be null";
        }
        if ((mb_strlen($this->container['billing_telephone_number']) > 50)) {
            $invalidProperties[] = "invalid value for 'billing_telephone_number', the character length must be smaller than or equal to 50.";
        }

        if ((mb_strlen($this->container['billing_telephone_number']) < 0)) {
            $invalidProperties[] = "invalid value for 'billing_telephone_number', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['billing_fax_itu_country_code']) && (mb_strlen($this->container['billing_fax_itu_country_code']) > 7)) {
            $invalidProperties[] = "invalid value for 'billing_fax_itu_country_code', the character length must be smaller than or equal to 7.";
        }

        if (!is_null($this->container['billing_fax_itu_country_code']) && (mb_strlen($this->container['billing_fax_itu_country_code']) < 0)) {
            $invalidProperties[] = "invalid value for 'billing_fax_itu_country_code', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['billing_fax_number']) && (mb_strlen($this->container['billing_fax_number']) > 50)) {
            $invalidProperties[] = "invalid value for 'billing_fax_number', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['billing_fax_number']) && (mb_strlen($this->container['billing_fax_number']) < 0)) {
            $invalidProperties[] = "invalid value for 'billing_fax_number', the character length must be bigger than or equal to 0.";
        }

        if ($this->container['ship_to_email'] === null) {
            $invalidProperties[] = "'ship_to_email' can't be null";
        }
        if ((mb_strlen($this->container['ship_to_email']) > 255)) {
            $invalidProperties[] = "invalid value for 'ship_to_email', the character length must be smaller than or equal to 255.";
        }

        if ((mb_strlen($this->container['ship_to_email']) < 0)) {
            $invalidProperties[] = "invalid value for 'ship_to_email', the character length must be bigger than or equal to 0.";
        }

        if ($this->container['ship_to_first_name'] === null) {
            $invalidProperties[] = "'ship_to_first_name' can't be null";
        }
        if ((mb_strlen($this->container['ship_to_first_name']) > 50)) {
            $invalidProperties[] = "invalid value for 'ship_to_first_name', the character length must be smaller than or equal to 50.";
        }

        if ((mb_strlen($this->container['ship_to_first_name']) < 0)) {
            $invalidProperties[] = "invalid value for 'ship_to_first_name', the character length must be bigger than or equal to 0.";
        }

        if ($this->container['ship_to_last_name'] === null) {
            $invalidProperties[] = "'ship_to_last_name' can't be null";
        }
        if ((mb_strlen($this->container['ship_to_last_name']) > 50)) {
            $invalidProperties[] = "invalid value for 'ship_to_last_name', the character length must be smaller than or equal to 50.";
        }

        if ((mb_strlen($this->container['ship_to_last_name']) < 0)) {
            $invalidProperties[] = "invalid value for 'ship_to_last_name', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['ship_to_company']) && (mb_strlen($this->container['ship_to_company']) > 50)) {
            $invalidProperties[] = "invalid value for 'ship_to_company', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['ship_to_company']) && (mb_strlen($this->container['ship_to_company']) < 0)) {
            $invalidProperties[] = "invalid value for 'ship_to_company', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['ship_to_address_line1']) && (mb_strlen($this->container['ship_to_address_line1']) > 50)) {
            $invalidProperties[] = "invalid value for 'ship_to_address_line1', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['ship_to_address_line1']) && (mb_strlen($this->container['ship_to_address_line1']) < 0)) {
            $invalidProperties[] = "invalid value for 'ship_to_address_line1', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['ship_to_address_line2']) && (mb_strlen($this->container['ship_to_address_line2']) > 50)) {
            $invalidProperties[] = "invalid value for 'ship_to_address_line2', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['ship_to_address_line2']) && (mb_strlen($this->container['ship_to_address_line2']) < 0)) {
            $invalidProperties[] = "invalid value for 'ship_to_address_line2', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['ship_to_address_line3']) && (mb_strlen($this->container['ship_to_address_line3']) > 50)) {
            $invalidProperties[] = "invalid value for 'ship_to_address_line3', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['ship_to_address_line3']) && (mb_strlen($this->container['ship_to_address_line3']) < 0)) {
            $invalidProperties[] = "invalid value for 'ship_to_address_line3', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['ship_to_address_line4']) && (mb_strlen($this->container['ship_to_address_line4']) > 50)) {
            $invalidProperties[] = "invalid value for 'ship_to_address_line4', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['ship_to_address_line4']) && (mb_strlen($this->container['ship_to_address_line4']) < 0)) {
            $invalidProperties[] = "invalid value for 'ship_to_address_line4', the character length must be bigger than or equal to 0.";
        }

        if ($this->container['ship_to_city'] === null) {
            $invalidProperties[] = "'ship_to_city' can't be null";
        }
        if ((mb_strlen($this->container['ship_to_city']) > 50)) {
            $invalidProperties[] = "invalid value for 'ship_to_city', the character length must be smaller than or equal to 50.";
        }

        if ((mb_strlen($this->container['ship_to_city']) < 0)) {
            $invalidProperties[] = "invalid value for 'ship_to_city', the character length must be bigger than or equal to 0.";
        }

        if ($this->container['ship_to_territory'] === null) {
            $invalidProperties[] = "'ship_to_territory' can't be null";
        }
        if ((mb_strlen($this->container['ship_to_territory']) > 50)) {
            $invalidProperties[] = "invalid value for 'ship_to_territory', the character length must be smaller than or equal to 50.";
        }

        if ((mb_strlen($this->container['ship_to_territory']) < 0)) {
            $invalidProperties[] = "invalid value for 'ship_to_territory', the character length must be bigger than or equal to 0.";
        }

        if ($this->container['ship_to_zip'] === null) {
            $invalidProperties[] = "'ship_to_zip' can't be null";
        }
        if ((mb_strlen($this->container['ship_to_zip']) > 50)) {
            $invalidProperties[] = "invalid value for 'ship_to_zip', the character length must be smaller than or equal to 50.";
        }

        if ((mb_strlen($this->container['ship_to_zip']) < 0)) {
            $invalidProperties[] = "invalid value for 'ship_to_zip', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['ship_to_iso_country_code']) && (mb_strlen($this->container['ship_to_iso_country_code']) > 4)) {
            $invalidProperties[] = "invalid value for 'ship_to_iso_country_code', the character length must be smaller than or equal to 4.";
        }

        if (!is_null($this->container['ship_to_iso_country_code']) && (mb_strlen($this->container['ship_to_iso_country_code']) < 0)) {
            $invalidProperties[] = "invalid value for 'ship_to_iso_country_code', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['ship_to_telephone_itu_country_code']) && (mb_strlen($this->container['ship_to_telephone_itu_country_code']) > 7)) {
            $invalidProperties[] = "invalid value for 'ship_to_telephone_itu_country_code', the character length must be smaller than or equal to 7.";
        }

        if (!is_null($this->container['ship_to_telephone_itu_country_code']) && (mb_strlen($this->container['ship_to_telephone_itu_country_code']) < 0)) {
            $invalidProperties[] = "invalid value for 'ship_to_telephone_itu_country_code', the character length must be bigger than or equal to 0.";
        }

        if ($this->container['ship_to_telephone_number'] === null) {
            $invalidProperties[] = "'ship_to_telephone_number' can't be null";
        }
        if ((mb_strlen($this->container['ship_to_telephone_number']) > 50)) {
            $invalidProperties[] = "invalid value for 'ship_to_telephone_number', the character length must be smaller than or equal to 50.";
        }

        if ((mb_strlen($this->container['ship_to_telephone_number']) < 0)) {
            $invalidProperties[] = "invalid value for 'ship_to_telephone_number', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['ship_to_fax_itu_country_code']) && (mb_strlen($this->container['ship_to_fax_itu_country_code']) > 7)) {
            $invalidProperties[] = "invalid value for 'ship_to_fax_itu_country_code', the character length must be smaller than or equal to 7.";
        }

        if (!is_null($this->container['ship_to_fax_itu_country_code']) && (mb_strlen($this->container['ship_to_fax_itu_country_code']) < 0)) {
            $invalidProperties[] = "invalid value for 'ship_to_fax_itu_country_code', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['ship_to_fax_number']) && (mb_strlen($this->container['ship_to_fax_number']) > 50)) {
            $invalidProperties[] = "invalid value for 'ship_to_fax_number', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['ship_to_fax_number']) && (mb_strlen($this->container['ship_to_fax_number']) < 0)) {
            $invalidProperties[] = "invalid value for 'ship_to_fax_number', the character length must be bigger than or equal to 0.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets customer_id
     *
     * @return int|null
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     *
     * @param int|null $customer_id primary key
     *
     * @return self
     */
    public function setCustomerId($customer_id)
    {
        if (is_null($customer_id)) {
            throw new \InvalidArgumentException('non-nullable customer_id cannot be null');
        }
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets origination_location_id
     *
     * @return int
     */
    public function getOriginationLocationId()
    {
        return $this->container['origination_location_id'];
    }

    /**
     * Sets origination_location_id
     *
     * @param int $origination_location_id The home location of the customer.  Required Field.  Must be a valid locationId under the hierarchy of the proved locationgroupid.
     *
     * @return self
     */
    public function setOriginationLocationId($origination_location_id)
    {
        if (is_null($origination_location_id)) {
            throw new \InvalidArgumentException('non-nullable origination_location_id cannot be null');
        }
        $this->container['origination_location_id'] = $origination_location_id;

        return $this;
    }

    /**
     * Gets location_group_id
     *
     * @return int
     */
    public function getLocationGroupId()
    {
        return $this->container['location_group_id'];
    }

    /**
     * Sets location_group_id
     *
     * @param int $location_group_id The location group defining the scope at which the customer will be distributed.
     *
     * @return self
     */
    public function setLocationGroupId($location_group_id)
    {
        if (is_null($location_group_id)) {
            throw new \InvalidArgumentException('non-nullable location_group_id cannot be null');
        }
        $this->container['location_group_id'] = $location_group_id;

        return $this;
    }

    /**
     * Gets account_number
     *
     * @return string
     */
    public function getAccountNumber()
    {
        return $this->container['account_number'];
    }

    /**
     * Sets account_number
     *
     * @param string $account_number Required field if autonumbering is not setup for customers in OpSuite.
     *
     * @return self
     */
    public function setAccountNumber($account_number)
    {
        if (is_null($account_number)) {
            throw new \InvalidArgumentException('non-nullable account_number cannot be null');
        }
        if ((mb_strlen($account_number) > 20)) {
            throw new \InvalidArgumentException('invalid length for $account_number when calling Customer., must be smaller than or equal to 20.');
        }
        if ((mb_strlen($account_number) < 0)) {
            throw new \InvalidArgumentException('invalid length for $account_number when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['account_number'] = $account_number;

        return $this;
    }

    /**
     * Gets account_type_id
     *
     * @return int|null
     */
    public function getAccountTypeId()
    {
        return $this->container['account_type_id'];
    }

    /**
     * Sets account_type_id
     *
     * @param int|null $account_type_id Then opsuite id of the account type of the customer
     *
     * @return self
     */
    public function setAccountTypeId($account_type_id)
    {
        if (is_null($account_type_id)) {
            array_push($this->openAPINullablesSetToNull, 'account_type_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('account_type_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['account_type_id'] = $account_type_id;

        return $this;
    }

    /**
     * Gets custom_date1
     *
     * @return \DateTime|null
     */
    public function getCustomDate1()
    {
        return $this->container['custom_date1'];
    }

    /**
     * Sets custom_date1
     *
     * @param \DateTime|null $custom_date1 Custom field for storing any customer related data
     *
     * @return self
     */
    public function setCustomDate1($custom_date1)
    {
        if (is_null($custom_date1)) {
            array_push($this->openAPINullablesSetToNull, 'custom_date1');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('custom_date1', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['custom_date1'] = $custom_date1;

        return $this;
    }

    /**
     * Gets custom_date2
     *
     * @return \DateTime|null
     */
    public function getCustomDate2()
    {
        return $this->container['custom_date2'];
    }

    /**
     * Sets custom_date2
     *
     * @param \DateTime|null $custom_date2 Custom field for storing any customer related data
     *
     * @return self
     */
    public function setCustomDate2($custom_date2)
    {
        if (is_null($custom_date2)) {
            array_push($this->openAPINullablesSetToNull, 'custom_date2');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('custom_date2', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['custom_date2'] = $custom_date2;

        return $this;
    }

    /**
     * Gets custom_date3
     *
     * @return \DateTime|null
     */
    public function getCustomDate3()
    {
        return $this->container['custom_date3'];
    }

    /**
     * Sets custom_date3
     *
     * @param \DateTime|null $custom_date3 Custom field for storing any customer related data
     *
     * @return self
     */
    public function setCustomDate3($custom_date3)
    {
        if (is_null($custom_date3)) {
            array_push($this->openAPINullablesSetToNull, 'custom_date3');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('custom_date3', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['custom_date3'] = $custom_date3;

        return $this;
    }

    /**
     * Gets custom_date4
     *
     * @return \DateTime|null
     */
    public function getCustomDate4()
    {
        return $this->container['custom_date4'];
    }

    /**
     * Sets custom_date4
     *
     * @param \DateTime|null $custom_date4 Custom field for storing any customer related data
     *
     * @return self
     */
    public function setCustomDate4($custom_date4)
    {
        if (is_null($custom_date4)) {
            array_push($this->openAPINullablesSetToNull, 'custom_date4');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('custom_date4', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['custom_date4'] = $custom_date4;

        return $this;
    }

    /**
     * Gets custom_date5
     *
     * @return \DateTime|null
     */
    public function getCustomDate5()
    {
        return $this->container['custom_date5'];
    }

    /**
     * Sets custom_date5
     *
     * @param \DateTime|null $custom_date5 Custom field for storing any customer related data
     *
     * @return self
     */
    public function setCustomDate5($custom_date5)
    {
        if (is_null($custom_date5)) {
            array_push($this->openAPINullablesSetToNull, 'custom_date5');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('custom_date5', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['custom_date5'] = $custom_date5;

        return $this;
    }

    /**
     * Gets custom_number1
     *
     * @return float|null
     */
    public function getCustomNumber1()
    {
        return $this->container['custom_number1'];
    }

    /**
     * Sets custom_number1
     *
     * @param float|null $custom_number1 Custom field for storing any customer related data
     *
     * @return self
     */
    public function setCustomNumber1($custom_number1)
    {
        if (is_null($custom_number1)) {
            array_push($this->openAPINullablesSetToNull, 'custom_number1');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('custom_number1', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['custom_number1'] = $custom_number1;

        return $this;
    }

    /**
     * Gets custom_number2
     *
     * @return float|null
     */
    public function getCustomNumber2()
    {
        return $this->container['custom_number2'];
    }

    /**
     * Sets custom_number2
     *
     * @param float|null $custom_number2 Custom field for storing any customer related data
     *
     * @return self
     */
    public function setCustomNumber2($custom_number2)
    {
        if (is_null($custom_number2)) {
            array_push($this->openAPINullablesSetToNull, 'custom_number2');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('custom_number2', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['custom_number2'] = $custom_number2;

        return $this;
    }

    /**
     * Gets custom_number3
     *
     * @return float|null
     */
    public function getCustomNumber3()
    {
        return $this->container['custom_number3'];
    }

    /**
     * Sets custom_number3
     *
     * @param float|null $custom_number3 Custom field for storing any customer related data
     *
     * @return self
     */
    public function setCustomNumber3($custom_number3)
    {
        if (is_null($custom_number3)) {
            array_push($this->openAPINullablesSetToNull, 'custom_number3');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('custom_number3', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['custom_number3'] = $custom_number3;

        return $this;
    }

    /**
     * Gets custom_number4
     *
     * @return float|null
     */
    public function getCustomNumber4()
    {
        return $this->container['custom_number4'];
    }

    /**
     * Sets custom_number4
     *
     * @param float|null $custom_number4 Custom field for storing any customer related data
     *
     * @return self
     */
    public function setCustomNumber4($custom_number4)
    {
        if (is_null($custom_number4)) {
            array_push($this->openAPINullablesSetToNull, 'custom_number4');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('custom_number4', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['custom_number4'] = $custom_number4;

        return $this;
    }

    /**
     * Gets custom_number5
     *
     * @return float|null
     */
    public function getCustomNumber5()
    {
        return $this->container['custom_number5'];
    }

    /**
     * Sets custom_number5
     *
     * @param float|null $custom_number5 Custom field for storing any customer related data
     *
     * @return self
     */
    public function setCustomNumber5($custom_number5)
    {
        if (is_null($custom_number5)) {
            array_push($this->openAPINullablesSetToNull, 'custom_number5');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('custom_number5', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['custom_number5'] = $custom_number5;

        return $this;
    }

    /**
     * Gets custom_text1
     *
     * @return string|null
     */
    public function getCustomText1()
    {
        return $this->container['custom_text1'];
    }

    /**
     * Sets custom_text1
     *
     * @param string|null $custom_text1 Custom field for storing any customer related data
     *
     * @return self
     */
    public function setCustomText1($custom_text1)
    {
        if (is_null($custom_text1)) {
            array_push($this->openAPINullablesSetToNull, 'custom_text1');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('custom_text1', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($custom_text1) && (mb_strlen($custom_text1) > 30)) {
            throw new \InvalidArgumentException('invalid length for $custom_text1 when calling Customer., must be smaller than or equal to 30.');
        }
        if (!is_null($custom_text1) && (mb_strlen($custom_text1) < 0)) {
            throw new \InvalidArgumentException('invalid length for $custom_text1 when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['custom_text1'] = $custom_text1;

        return $this;
    }

    /**
     * Gets custom_text2
     *
     * @return string|null
     */
    public function getCustomText2()
    {
        return $this->container['custom_text2'];
    }

    /**
     * Sets custom_text2
     *
     * @param string|null $custom_text2 Custom field for storing any customer related data
     *
     * @return self
     */
    public function setCustomText2($custom_text2)
    {
        if (is_null($custom_text2)) {
            array_push($this->openAPINullablesSetToNull, 'custom_text2');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('custom_text2', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($custom_text2) && (mb_strlen($custom_text2) > 30)) {
            throw new \InvalidArgumentException('invalid length for $custom_text2 when calling Customer., must be smaller than or equal to 30.');
        }
        if (!is_null($custom_text2) && (mb_strlen($custom_text2) < 0)) {
            throw new \InvalidArgumentException('invalid length for $custom_text2 when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['custom_text2'] = $custom_text2;

        return $this;
    }

    /**
     * Gets custom_text3
     *
     * @return string|null
     */
    public function getCustomText3()
    {
        return $this->container['custom_text3'];
    }

    /**
     * Sets custom_text3
     *
     * @param string|null $custom_text3 Custom field for storing any customer related data
     *
     * @return self
     */
    public function setCustomText3($custom_text3)
    {
        if (is_null($custom_text3)) {
            array_push($this->openAPINullablesSetToNull, 'custom_text3');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('custom_text3', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($custom_text3) && (mb_strlen($custom_text3) > 30)) {
            throw new \InvalidArgumentException('invalid length for $custom_text3 when calling Customer., must be smaller than or equal to 30.');
        }
        if (!is_null($custom_text3) && (mb_strlen($custom_text3) < 0)) {
            throw new \InvalidArgumentException('invalid length for $custom_text3 when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['custom_text3'] = $custom_text3;

        return $this;
    }

    /**
     * Gets custom_text4
     *
     * @return string|null
     */
    public function getCustomText4()
    {
        return $this->container['custom_text4'];
    }

    /**
     * Sets custom_text4
     *
     * @param string|null $custom_text4 Custom field for storing any customer related data
     *
     * @return self
     */
    public function setCustomText4($custom_text4)
    {
        if (is_null($custom_text4)) {
            array_push($this->openAPINullablesSetToNull, 'custom_text4');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('custom_text4', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($custom_text4) && (mb_strlen($custom_text4) > 30)) {
            throw new \InvalidArgumentException('invalid length for $custom_text4 when calling Customer., must be smaller than or equal to 30.');
        }
        if (!is_null($custom_text4) && (mb_strlen($custom_text4) < 0)) {
            throw new \InvalidArgumentException('invalid length for $custom_text4 when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['custom_text4'] = $custom_text4;

        return $this;
    }

    /**
     * Gets custom_text5
     *
     * @return string|null
     */
    public function getCustomText5()
    {
        return $this->container['custom_text5'];
    }

    /**
     * Sets custom_text5
     *
     * @param string|null $custom_text5 Custom field for storing any customer related data
     *
     * @return self
     */
    public function setCustomText5($custom_text5)
    {
        if (is_null($custom_text5)) {
            array_push($this->openAPINullablesSetToNull, 'custom_text5');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('custom_text5', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($custom_text5) && (mb_strlen($custom_text5) > 30)) {
            throw new \InvalidArgumentException('invalid length for $custom_text5 when calling Customer., must be smaller than or equal to 30.');
        }
        if (!is_null($custom_text5) && (mb_strlen($custom_text5) < 0)) {
            throw new \InvalidArgumentException('invalid length for $custom_text5 when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['custom_text5'] = $custom_text5;

        return $this;
    }

    /**
     * Gets last_starting_date
     *
     * @return \DateTime|null
     */
    public function getLastStartingDate()
    {
        return $this->container['last_starting_date'];
    }

    /**
     * Sets last_starting_date
     *
     * @param \DateTime|null $last_starting_date Date the customer account was last started
     *
     * @return self
     */
    public function setLastStartingDate($last_starting_date)
    {
        if (is_null($last_starting_date)) {
            array_push($this->openAPINullablesSetToNull, 'last_starting_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('last_starting_date', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['last_starting_date'] = $last_starting_date;

        return $this;
    }

    /**
     * Gets last_closing_date
     *
     * @return \DateTime|null
     */
    public function getLastClosingDate()
    {
        return $this->container['last_closing_date'];
    }

    /**
     * Sets last_closing_date
     *
     * @param \DateTime|null $last_closing_date Date the customers account was last closed
     *
     * @return self
     */
    public function setLastClosingDate($last_closing_date)
    {
        if (is_null($last_closing_date)) {
            array_push($this->openAPINullablesSetToNull, 'last_closing_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('last_closing_date', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['last_closing_date'] = $last_closing_date;

        return $this;
    }

    /**
     * Gets last_updated
     *
     * @return \DateTime|null
     */
    public function getLastUpdated()
    {
        return $this->container['last_updated'];
    }

    /**
     * Sets last_updated
     *
     * @param \DateTime|null $last_updated Date the customer was last upated
     *
     * @return self
     */
    public function setLastUpdated($last_updated)
    {
        if (is_null($last_updated)) {
            array_push($this->openAPINullablesSetToNull, 'last_updated');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('last_updated', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['last_updated'] = $last_updated;

        return $this;
    }

    /**
     * Gets credit_limit
     *
     * @return float|null
     */
    public function getCreditLimit()
    {
        return $this->container['credit_limit'];
    }

    /**
     * Sets credit_limit
     *
     * @param float|null $credit_limit The credit limit for the customer when they buy on account
     *
     * @return self
     */
    public function setCreditLimit($credit_limit)
    {
        if (is_null($credit_limit)) {
            throw new \InvalidArgumentException('non-nullable credit_limit cannot be null');
        }
        $this->container['credit_limit'] = $credit_limit;

        return $this;
    }

    /**
     * Gets last_visit
     *
     * @return \DateTime|null
     */
    public function getLastVisit()
    {
        return $this->container['last_visit'];
    }

    /**
     * Sets last_visit
     *
     * @param \DateTime|null $last_visit Date the customer last visted
     *
     * @return self
     */
    public function setLastVisit($last_visit)
    {
        if (is_null($last_visit)) {
            array_push($this->openAPINullablesSetToNull, 'last_visit');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('last_visit', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['last_visit'] = $last_visit;

        return $this;
    }

    /**
     * Gets tax_exempt
     *
     * @return bool|null
     */
    public function getTaxExempt()
    {
        return $this->container['tax_exempt'];
    }

    /**
     * Sets tax_exempt
     *
     * @param bool|null $tax_exempt Indicates if the customer is tax exempt
     *
     * @return self
     */
    public function setTaxExempt($tax_exempt)
    {
        if (is_null($tax_exempt)) {
            throw new \InvalidArgumentException('non-nullable tax_exempt cannot be null');
        }
        $this->container['tax_exempt'] = $tax_exempt;

        return $this;
    }

    /**
     * Gets notes
     *
     * @return string|null
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     *
     * @param string|null $notes Notes. SQL Ntext field.
     *
     * @return self
     */
    public function setNotes($notes)
    {
        if (is_null($notes)) {
            array_push($this->openAPINullablesSetToNull, 'notes');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('notes', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets active
     *
     * @return bool|null
     */
    public function getActive()
    {
        return $this->container['active'];
    }

    /**
     * Sets active
     *
     * @param bool|null $active Is the customer Active?
     *
     * @return self
     */
    public function setActive($active)
    {
        if (is_null($active)) {
            throw new \InvalidArgumentException('non-nullable active cannot be null');
        }
        $this->container['active'] = $active;

        return $this;
    }

    /**
     * Gets is_employee
     *
     * @return bool|null
     */
    public function getIsEmployee()
    {
        return $this->container['is_employee'];
    }

    /**
     * Sets is_employee
     *
     * @param bool|null $is_employee Is the customer an employee?
     *
     * @return self
     */
    public function setIsEmployee($is_employee)
    {
        if (is_null($is_employee)) {
            throw new \InvalidArgumentException('non-nullable is_employee cannot be null');
        }
        $this->container['is_employee'] = $is_employee;

        return $this;
    }

    /**
     * Gets referred_by
     *
     * @return int|null
     */
    public function getReferredBy()
    {
        return $this->container['referred_by'];
    }

    /**
     * Sets referred_by
     *
     * @param int|null $referred_by The customer id of a customer that was the referer of this customer
     *
     * @return self
     */
    public function setReferredBy($referred_by)
    {
        if (is_null($referred_by)) {
            array_push($this->openAPINullablesSetToNull, 'referred_by');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('referred_by', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['referred_by'] = $referred_by;

        return $this;
    }

    /**
     * Gets referred_by_account_number
     *
     * @return string|null
     */
    public function getReferredByAccountNumber()
    {
        return $this->container['referred_by_account_number'];
    }

    /**
     * Sets referred_by_account_number
     *
     * @param string|null $referred_by_account_number The account number of a customer that was the referer of this customer
     *
     * @return self
     */
    public function setReferredByAccountNumber($referred_by_account_number)
    {
        if (is_null($referred_by_account_number)) {
            array_push($this->openAPINullablesSetToNull, 'referred_by_account_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('referred_by_account_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['referred_by_account_number'] = $referred_by_account_number;

        return $this;
    }

    /**
     * Gets opt_in_email
     *
     * @return bool|null
     */
    public function getOptInEmail()
    {
        return $this->container['opt_in_email'];
    }

    /**
     * Sets opt_in_email
     *
     * @param bool|null $opt_in_email Has customer opted in for email communication?
     *
     * @return self
     */
    public function setOptInEmail($opt_in_email)
    {
        if (is_null($opt_in_email)) {
            throw new \InvalidArgumentException('non-nullable opt_in_email cannot be null');
        }
        $this->container['opt_in_email'] = $opt_in_email;

        return $this;
    }

    /**
     * Gets opt_in_direct_mail
     *
     * @return bool|null
     */
    public function getOptInDirectMail()
    {
        return $this->container['opt_in_direct_mail'];
    }

    /**
     * Sets opt_in_direct_mail
     *
     * @param bool|null $opt_in_direct_mail Has customer opted in for direct mail communication?
     *
     * @return self
     */
    public function setOptInDirectMail($opt_in_direct_mail)
    {
        if (is_null($opt_in_direct_mail)) {
            throw new \InvalidArgumentException('non-nullable opt_in_direct_mail cannot be null');
        }
        $this->container['opt_in_direct_mail'] = $opt_in_direct_mail;

        return $this;
    }

    /**
     * Gets opt_in_telephone
     *
     * @return bool|null
     */
    public function getOptInTelephone()
    {
        return $this->container['opt_in_telephone'];
    }

    /**
     * Sets opt_in_telephone
     *
     * @param bool|null $opt_in_telephone Has customer opted in for telephone communication?
     *
     * @return self
     */
    public function setOptInTelephone($opt_in_telephone)
    {
        if (is_null($opt_in_telephone)) {
            throw new \InvalidArgumentException('non-nullable opt_in_telephone cannot be null');
        }
        $this->container['opt_in_telephone'] = $opt_in_telephone;

        return $this;
    }

    /**
     * Gets billing_contact_id
     *
     * @return int|null
     */
    public function getBillingContactId()
    {
        return $this->container['billing_contact_id'];
    }

    /**
     * Sets billing_contact_id
     *
     * @param int|null $billing_contact_id The id of the billing contact record.
     *
     * @return self
     */
    public function setBillingContactId($billing_contact_id)
    {
        if (is_null($billing_contact_id)) {
            throw new \InvalidArgumentException('non-nullable billing_contact_id cannot be null');
        }
        $this->container['billing_contact_id'] = $billing_contact_id;

        return $this;
    }

    /**
     * Gets billing_email
     *
     * @return string
     */
    public function getBillingEmail()
    {
        return $this->container['billing_email'];
    }

    /**
     * Sets billing_email
     *
     * @param string $billing_email Billing Email Address.  It will be validated to ensure it's a valid format.
     *
     * @return self
     */
    public function setBillingEmail($billing_email)
    {
        if (is_null($billing_email)) {
            throw new \InvalidArgumentException('non-nullable billing_email cannot be null');
        }
        if ((mb_strlen($billing_email) > 255)) {
            throw new \InvalidArgumentException('invalid length for $billing_email when calling Customer., must be smaller than or equal to 255.');
        }
        if ((mb_strlen($billing_email) < 0)) {
            throw new \InvalidArgumentException('invalid length for $billing_email when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['billing_email'] = $billing_email;

        return $this;
    }

    /**
     * Gets billing_title
     *
     * @return string|null
     */
    public function getBillingTitle()
    {
        return $this->container['billing_title'];
    }

    /**
     * Sets billing_title
     *
     * @param string|null $billing_title Billing contact's title.  You can get a list of titles from the Common controller.
     *
     * @return self
     */
    public function setBillingTitle($billing_title)
    {
        if (is_null($billing_title)) {
            array_push($this->openAPINullablesSetToNull, 'billing_title');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('billing_title', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['billing_title'] = $billing_title;

        return $this;
    }

    /**
     * Gets billing_first_name
     *
     * @return string
     */
    public function getBillingFirstName()
    {
        return $this->container['billing_first_name'];
    }

    /**
     * Sets billing_first_name
     *
     * @param string $billing_first_name Billing contact first name.
     *
     * @return self
     */
    public function setBillingFirstName($billing_first_name)
    {
        if (is_null($billing_first_name)) {
            throw new \InvalidArgumentException('non-nullable billing_first_name cannot be null');
        }
        if ((mb_strlen($billing_first_name) > 50)) {
            throw new \InvalidArgumentException('invalid length for $billing_first_name when calling Customer., must be smaller than or equal to 50.');
        }
        if ((mb_strlen($billing_first_name) < 0)) {
            throw new \InvalidArgumentException('invalid length for $billing_first_name when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['billing_first_name'] = $billing_first_name;

        return $this;
    }

    /**
     * Gets billing_last_name
     *
     * @return string
     */
    public function getBillingLastName()
    {
        return $this->container['billing_last_name'];
    }

    /**
     * Sets billing_last_name
     *
     * @param string $billing_last_name Billing contact last name.
     *
     * @return self
     */
    public function setBillingLastName($billing_last_name)
    {
        if (is_null($billing_last_name)) {
            throw new \InvalidArgumentException('non-nullable billing_last_name cannot be null');
        }
        if ((mb_strlen($billing_last_name) > 50)) {
            throw new \InvalidArgumentException('invalid length for $billing_last_name when calling Customer., must be smaller than or equal to 50.');
        }
        if ((mb_strlen($billing_last_name) < 0)) {
            throw new \InvalidArgumentException('invalid length for $billing_last_name when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['billing_last_name'] = $billing_last_name;

        return $this;
    }

    /**
     * Gets billing_date_of_birth
     *
     * @return \DateTime|null
     */
    public function getBillingDateOfBirth()
    {
        return $this->container['billing_date_of_birth'];
    }

    /**
     * Sets billing_date_of_birth
     *
     * @param \DateTime|null $billing_date_of_birth Billing contact date of birth
     *
     * @return self
     */
    public function setBillingDateOfBirth($billing_date_of_birth)
    {
        if (is_null($billing_date_of_birth)) {
            array_push($this->openAPINullablesSetToNull, 'billing_date_of_birth');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('billing_date_of_birth', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['billing_date_of_birth'] = $billing_date_of_birth;

        return $this;
    }

    /**
     * Gets billing_company
     *
     * @return string|null
     */
    public function getBillingCompany()
    {
        return $this->container['billing_company'];
    }

    /**
     * Sets billing_company
     *
     * @param string|null $billing_company Billing address company name
     *
     * @return self
     */
    public function setBillingCompany($billing_company)
    {
        if (is_null($billing_company)) {
            array_push($this->openAPINullablesSetToNull, 'billing_company');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('billing_company', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($billing_company) && (mb_strlen($billing_company) > 50)) {
            throw new \InvalidArgumentException('invalid length for $billing_company when calling Customer., must be smaller than or equal to 50.');
        }
        if (!is_null($billing_company) && (mb_strlen($billing_company) < 0)) {
            throw new \InvalidArgumentException('invalid length for $billing_company when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['billing_company'] = $billing_company;

        return $this;
    }

    /**
     * Gets billing_address_line1
     *
     * @return string|null
     */
    public function getBillingAddressLine1()
    {
        return $this->container['billing_address_line1'];
    }

    /**
     * Sets billing_address_line1
     *
     * @param string|null $billing_address_line1 Billing address line 1
     *
     * @return self
     */
    public function setBillingAddressLine1($billing_address_line1)
    {
        if (is_null($billing_address_line1)) {
            array_push($this->openAPINullablesSetToNull, 'billing_address_line1');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('billing_address_line1', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($billing_address_line1) && (mb_strlen($billing_address_line1) > 50)) {
            throw new \InvalidArgumentException('invalid length for $billing_address_line1 when calling Customer., must be smaller than or equal to 50.');
        }
        if (!is_null($billing_address_line1) && (mb_strlen($billing_address_line1) < 0)) {
            throw new \InvalidArgumentException('invalid length for $billing_address_line1 when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['billing_address_line1'] = $billing_address_line1;

        return $this;
    }

    /**
     * Gets billing_address_line2
     *
     * @return string|null
     */
    public function getBillingAddressLine2()
    {
        return $this->container['billing_address_line2'];
    }

    /**
     * Sets billing_address_line2
     *
     * @param string|null $billing_address_line2 Billing address line 2
     *
     * @return self
     */
    public function setBillingAddressLine2($billing_address_line2)
    {
        if (is_null($billing_address_line2)) {
            array_push($this->openAPINullablesSetToNull, 'billing_address_line2');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('billing_address_line2', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($billing_address_line2) && (mb_strlen($billing_address_line2) > 50)) {
            throw new \InvalidArgumentException('invalid length for $billing_address_line2 when calling Customer., must be smaller than or equal to 50.');
        }
        if (!is_null($billing_address_line2) && (mb_strlen($billing_address_line2) < 0)) {
            throw new \InvalidArgumentException('invalid length for $billing_address_line2 when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['billing_address_line2'] = $billing_address_line2;

        return $this;
    }

    /**
     * Gets billing_address_line3
     *
     * @return string|null
     */
    public function getBillingAddressLine3()
    {
        return $this->container['billing_address_line3'];
    }

    /**
     * Sets billing_address_line3
     *
     * @param string|null $billing_address_line3 Billing address line 3
     *
     * @return self
     */
    public function setBillingAddressLine3($billing_address_line3)
    {
        if (is_null($billing_address_line3)) {
            array_push($this->openAPINullablesSetToNull, 'billing_address_line3');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('billing_address_line3', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($billing_address_line3) && (mb_strlen($billing_address_line3) > 50)) {
            throw new \InvalidArgumentException('invalid length for $billing_address_line3 when calling Customer., must be smaller than or equal to 50.');
        }
        if (!is_null($billing_address_line3) && (mb_strlen($billing_address_line3) < 0)) {
            throw new \InvalidArgumentException('invalid length for $billing_address_line3 when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['billing_address_line3'] = $billing_address_line3;

        return $this;
    }

    /**
     * Gets billing_address_line4
     *
     * @return string|null
     */
    public function getBillingAddressLine4()
    {
        return $this->container['billing_address_line4'];
    }

    /**
     * Sets billing_address_line4
     *
     * @param string|null $billing_address_line4 Billing address line 4
     *
     * @return self
     */
    public function setBillingAddressLine4($billing_address_line4)
    {
        if (is_null($billing_address_line4)) {
            array_push($this->openAPINullablesSetToNull, 'billing_address_line4');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('billing_address_line4', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($billing_address_line4) && (mb_strlen($billing_address_line4) > 50)) {
            throw new \InvalidArgumentException('invalid length for $billing_address_line4 when calling Customer., must be smaller than or equal to 50.');
        }
        if (!is_null($billing_address_line4) && (mb_strlen($billing_address_line4) < 0)) {
            throw new \InvalidArgumentException('invalid length for $billing_address_line4 when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['billing_address_line4'] = $billing_address_line4;

        return $this;
    }

    /**
     * Gets billing_city
     *
     * @return string
     */
    public function getBillingCity()
    {
        return $this->container['billing_city'];
    }

    /**
     * Sets billing_city
     *
     * @param string $billing_city Billing address city or town
     *
     * @return self
     */
    public function setBillingCity($billing_city)
    {
        if (is_null($billing_city)) {
            throw new \InvalidArgumentException('non-nullable billing_city cannot be null');
        }
        if ((mb_strlen($billing_city) > 50)) {
            throw new \InvalidArgumentException('invalid length for $billing_city when calling Customer., must be smaller than or equal to 50.');
        }
        if ((mb_strlen($billing_city) < 0)) {
            throw new \InvalidArgumentException('invalid length for $billing_city when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['billing_city'] = $billing_city;

        return $this;
    }

    /**
     * Gets billing_territory
     *
     * @return string
     */
    public function getBillingTerritory()
    {
        return $this->container['billing_territory'];
    }

    /**
     * Sets billing_territory
     *
     * @param string $billing_territory Billing address territory or county
     *
     * @return self
     */
    public function setBillingTerritory($billing_territory)
    {
        if (is_null($billing_territory)) {
            throw new \InvalidArgumentException('non-nullable billing_territory cannot be null');
        }
        if ((mb_strlen($billing_territory) > 50)) {
            throw new \InvalidArgumentException('invalid length for $billing_territory when calling Customer., must be smaller than or equal to 50.');
        }
        if ((mb_strlen($billing_territory) < 0)) {
            throw new \InvalidArgumentException('invalid length for $billing_territory when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['billing_territory'] = $billing_territory;

        return $this;
    }

    /**
     * Gets billing_zip
     *
     * @return string
     */
    public function getBillingZip()
    {
        return $this->container['billing_zip'];
    }

    /**
     * Sets billing_zip
     *
     * @param string $billing_zip Billing address zip or postcode
     *
     * @return self
     */
    public function setBillingZip($billing_zip)
    {
        if (is_null($billing_zip)) {
            throw new \InvalidArgumentException('non-nullable billing_zip cannot be null');
        }
        if ((mb_strlen($billing_zip) > 50)) {
            throw new \InvalidArgumentException('invalid length for $billing_zip when calling Customer., must be smaller than or equal to 50.');
        }
        if ((mb_strlen($billing_zip) < 0)) {
            throw new \InvalidArgumentException('invalid length for $billing_zip when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['billing_zip'] = $billing_zip;

        return $this;
    }

    /**
     * Gets billing_iso_country_code
     *
     * @return string|null
     */
    public function getBillingIsoCountryCode()
    {
        return $this->container['billing_iso_country_code'];
    }

    /**
     * Sets billing_iso_country_code
     *
     * @param string|null $billing_iso_country_code Billing address IsoCountryCode.  A 3 character ISO 3166-1 alpha-3 string. http://http://en.wikipedia.org/wiki/ISO_3166-1_alpha-3
     *
     * @return self
     */
    public function setBillingIsoCountryCode($billing_iso_country_code)
    {
        if (is_null($billing_iso_country_code)) {
            array_push($this->openAPINullablesSetToNull, 'billing_iso_country_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('billing_iso_country_code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($billing_iso_country_code) && (mb_strlen($billing_iso_country_code) > 4)) {
            throw new \InvalidArgumentException('invalid length for $billing_iso_country_code when calling Customer., must be smaller than or equal to 4.');
        }
        if (!is_null($billing_iso_country_code) && (mb_strlen($billing_iso_country_code) < 0)) {
            throw new \InvalidArgumentException('invalid length for $billing_iso_country_code when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['billing_iso_country_code'] = $billing_iso_country_code;

        return $this;
    }

    /**
     * Gets billing_telephone_itu_country_code
     *
     * @return string|null
     */
    public function getBillingTelephoneItuCountryCode()
    {
        return $this->container['billing_telephone_itu_country_code'];
    }

    /**
     * Sets billing_telephone_itu_country_code
     *
     * @param string|null $billing_telephone_itu_country_code Billing telephone Itu Country Code.
     *
     * @return self
     */
    public function setBillingTelephoneItuCountryCode($billing_telephone_itu_country_code)
    {
        if (is_null($billing_telephone_itu_country_code)) {
            array_push($this->openAPINullablesSetToNull, 'billing_telephone_itu_country_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('billing_telephone_itu_country_code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($billing_telephone_itu_country_code) && (mb_strlen($billing_telephone_itu_country_code) > 7)) {
            throw new \InvalidArgumentException('invalid length for $billing_telephone_itu_country_code when calling Customer., must be smaller than or equal to 7.');
        }
        if (!is_null($billing_telephone_itu_country_code) && (mb_strlen($billing_telephone_itu_country_code) < 0)) {
            throw new \InvalidArgumentException('invalid length for $billing_telephone_itu_country_code when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['billing_telephone_itu_country_code'] = $billing_telephone_itu_country_code;

        return $this;
    }

    /**
     * Gets billing_telephone_number
     *
     * @return string
     */
    public function getBillingTelephoneNumber()
    {
        return $this->container['billing_telephone_number'];
    }

    /**
     * Sets billing_telephone_number
     *
     * @param string $billing_telephone_number Billing telephone number
     *
     * @return self
     */
    public function setBillingTelephoneNumber($billing_telephone_number)
    {
        if (is_null($billing_telephone_number)) {
            throw new \InvalidArgumentException('non-nullable billing_telephone_number cannot be null');
        }
        if ((mb_strlen($billing_telephone_number) > 50)) {
            throw new \InvalidArgumentException('invalid length for $billing_telephone_number when calling Customer., must be smaller than or equal to 50.');
        }
        if ((mb_strlen($billing_telephone_number) < 0)) {
            throw new \InvalidArgumentException('invalid length for $billing_telephone_number when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['billing_telephone_number'] = $billing_telephone_number;

        return $this;
    }

    /**
     * Gets billing_fax_itu_country_code
     *
     * @return string|null
     */
    public function getBillingFaxItuCountryCode()
    {
        return $this->container['billing_fax_itu_country_code'];
    }

    /**
     * Sets billing_fax_itu_country_code
     *
     * @param string|null $billing_fax_itu_country_code Billing fax Itu Country Code.
     *
     * @return self
     */
    public function setBillingFaxItuCountryCode($billing_fax_itu_country_code)
    {
        if (is_null($billing_fax_itu_country_code)) {
            array_push($this->openAPINullablesSetToNull, 'billing_fax_itu_country_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('billing_fax_itu_country_code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($billing_fax_itu_country_code) && (mb_strlen($billing_fax_itu_country_code) > 7)) {
            throw new \InvalidArgumentException('invalid length for $billing_fax_itu_country_code when calling Customer., must be smaller than or equal to 7.');
        }
        if (!is_null($billing_fax_itu_country_code) && (mb_strlen($billing_fax_itu_country_code) < 0)) {
            throw new \InvalidArgumentException('invalid length for $billing_fax_itu_country_code when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['billing_fax_itu_country_code'] = $billing_fax_itu_country_code;

        return $this;
    }

    /**
     * Gets billing_fax_number
     *
     * @return string|null
     */
    public function getBillingFaxNumber()
    {
        return $this->container['billing_fax_number'];
    }

    /**
     * Sets billing_fax_number
     *
     * @param string|null $billing_fax_number Billing fax number
     *
     * @return self
     */
    public function setBillingFaxNumber($billing_fax_number)
    {
        if (is_null($billing_fax_number)) {
            array_push($this->openAPINullablesSetToNull, 'billing_fax_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('billing_fax_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($billing_fax_number) && (mb_strlen($billing_fax_number) > 50)) {
            throw new \InvalidArgumentException('invalid length for $billing_fax_number when calling Customer., must be smaller than or equal to 50.');
        }
        if (!is_null($billing_fax_number) && (mb_strlen($billing_fax_number) < 0)) {
            throw new \InvalidArgumentException('invalid length for $billing_fax_number when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['billing_fax_number'] = $billing_fax_number;

        return $this;
    }

    /**
     * Gets ship_to_contact_id
     *
     * @return int|null
     */
    public function getShipToContactId()
    {
        return $this->container['ship_to_contact_id'];
    }

    /**
     * Sets ship_to_contact_id
     *
     * @param int|null $ship_to_contact_id The id of the ship to contact record.
     *
     * @return self
     */
    public function setShipToContactId($ship_to_contact_id)
    {
        if (is_null($ship_to_contact_id)) {
            throw new \InvalidArgumentException('non-nullable ship_to_contact_id cannot be null');
        }
        $this->container['ship_to_contact_id'] = $ship_to_contact_id;

        return $this;
    }

    /**
     * Gets ship_to_email
     *
     * @return string
     */
    public function getShipToEmail()
    {
        return $this->container['ship_to_email'];
    }

    /**
     * Sets ship_to_email
     *
     * @param string $ship_to_email Ship To Email Address.  It will be validated to ensure it's a valid format.
     *
     * @return self
     */
    public function setShipToEmail($ship_to_email)
    {
        if (is_null($ship_to_email)) {
            throw new \InvalidArgumentException('non-nullable ship_to_email cannot be null');
        }
        if ((mb_strlen($ship_to_email) > 255)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_email when calling Customer., must be smaller than or equal to 255.');
        }
        if ((mb_strlen($ship_to_email) < 0)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_email when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['ship_to_email'] = $ship_to_email;

        return $this;
    }

    /**
     * Gets ship_to_title
     *
     * @return string|null
     */
    public function getShipToTitle()
    {
        return $this->container['ship_to_title'];
    }

    /**
     * Sets ship_to_title
     *
     * @param string|null $ship_to_title Ship to contact's title.  You can get a list of titles from the Common controller.
     *
     * @return self
     */
    public function setShipToTitle($ship_to_title)
    {
        if (is_null($ship_to_title)) {
            array_push($this->openAPINullablesSetToNull, 'ship_to_title');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ship_to_title', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['ship_to_title'] = $ship_to_title;

        return $this;
    }

    /**
     * Gets ship_to_first_name
     *
     * @return string
     */
    public function getShipToFirstName()
    {
        return $this->container['ship_to_first_name'];
    }

    /**
     * Sets ship_to_first_name
     *
     * @param string $ship_to_first_name Ship to contact first name.
     *
     * @return self
     */
    public function setShipToFirstName($ship_to_first_name)
    {
        if (is_null($ship_to_first_name)) {
            throw new \InvalidArgumentException('non-nullable ship_to_first_name cannot be null');
        }
        if ((mb_strlen($ship_to_first_name) > 50)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_first_name when calling Customer., must be smaller than or equal to 50.');
        }
        if ((mb_strlen($ship_to_first_name) < 0)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_first_name when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['ship_to_first_name'] = $ship_to_first_name;

        return $this;
    }

    /**
     * Gets ship_to_last_name
     *
     * @return string
     */
    public function getShipToLastName()
    {
        return $this->container['ship_to_last_name'];
    }

    /**
     * Sets ship_to_last_name
     *
     * @param string $ship_to_last_name Ship to contact last name.
     *
     * @return self
     */
    public function setShipToLastName($ship_to_last_name)
    {
        if (is_null($ship_to_last_name)) {
            throw new \InvalidArgumentException('non-nullable ship_to_last_name cannot be null');
        }
        if ((mb_strlen($ship_to_last_name) > 50)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_last_name when calling Customer., must be smaller than or equal to 50.');
        }
        if ((mb_strlen($ship_to_last_name) < 0)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_last_name when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['ship_to_last_name'] = $ship_to_last_name;

        return $this;
    }

    /**
     * Gets ship_to_date_of_birth
     *
     * @return \DateTime|null
     */
    public function getShipToDateOfBirth()
    {
        return $this->container['ship_to_date_of_birth'];
    }

    /**
     * Sets ship_to_date_of_birth
     *
     * @param \DateTime|null $ship_to_date_of_birth Ship to contact date of birth
     *
     * @return self
     */
    public function setShipToDateOfBirth($ship_to_date_of_birth)
    {
        if (is_null($ship_to_date_of_birth)) {
            array_push($this->openAPINullablesSetToNull, 'ship_to_date_of_birth');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ship_to_date_of_birth', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['ship_to_date_of_birth'] = $ship_to_date_of_birth;

        return $this;
    }

    /**
     * Gets ship_to_company
     *
     * @return string|null
     */
    public function getShipToCompany()
    {
        return $this->container['ship_to_company'];
    }

    /**
     * Sets ship_to_company
     *
     * @param string|null $ship_to_company Ship to address company name
     *
     * @return self
     */
    public function setShipToCompany($ship_to_company)
    {
        if (is_null($ship_to_company)) {
            array_push($this->openAPINullablesSetToNull, 'ship_to_company');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ship_to_company', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($ship_to_company) && (mb_strlen($ship_to_company) > 50)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_company when calling Customer., must be smaller than or equal to 50.');
        }
        if (!is_null($ship_to_company) && (mb_strlen($ship_to_company) < 0)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_company when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['ship_to_company'] = $ship_to_company;

        return $this;
    }

    /**
     * Gets ship_to_address_line1
     *
     * @return string|null
     */
    public function getShipToAddressLine1()
    {
        return $this->container['ship_to_address_line1'];
    }

    /**
     * Sets ship_to_address_line1
     *
     * @param string|null $ship_to_address_line1 Ship to address line 1
     *
     * @return self
     */
    public function setShipToAddressLine1($ship_to_address_line1)
    {
        if (is_null($ship_to_address_line1)) {
            array_push($this->openAPINullablesSetToNull, 'ship_to_address_line1');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ship_to_address_line1', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($ship_to_address_line1) && (mb_strlen($ship_to_address_line1) > 50)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_address_line1 when calling Customer., must be smaller than or equal to 50.');
        }
        if (!is_null($ship_to_address_line1) && (mb_strlen($ship_to_address_line1) < 0)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_address_line1 when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['ship_to_address_line1'] = $ship_to_address_line1;

        return $this;
    }

    /**
     * Gets ship_to_address_line2
     *
     * @return string|null
     */
    public function getShipToAddressLine2()
    {
        return $this->container['ship_to_address_line2'];
    }

    /**
     * Sets ship_to_address_line2
     *
     * @param string|null $ship_to_address_line2 Ship to address line 2
     *
     * @return self
     */
    public function setShipToAddressLine2($ship_to_address_line2)
    {
        if (is_null($ship_to_address_line2)) {
            array_push($this->openAPINullablesSetToNull, 'ship_to_address_line2');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ship_to_address_line2', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($ship_to_address_line2) && (mb_strlen($ship_to_address_line2) > 50)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_address_line2 when calling Customer., must be smaller than or equal to 50.');
        }
        if (!is_null($ship_to_address_line2) && (mb_strlen($ship_to_address_line2) < 0)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_address_line2 when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['ship_to_address_line2'] = $ship_to_address_line2;

        return $this;
    }

    /**
     * Gets ship_to_address_line3
     *
     * @return string|null
     */
    public function getShipToAddressLine3()
    {
        return $this->container['ship_to_address_line3'];
    }

    /**
     * Sets ship_to_address_line3
     *
     * @param string|null $ship_to_address_line3 Ship to address line 3
     *
     * @return self
     */
    public function setShipToAddressLine3($ship_to_address_line3)
    {
        if (is_null($ship_to_address_line3)) {
            array_push($this->openAPINullablesSetToNull, 'ship_to_address_line3');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ship_to_address_line3', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($ship_to_address_line3) && (mb_strlen($ship_to_address_line3) > 50)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_address_line3 when calling Customer., must be smaller than or equal to 50.');
        }
        if (!is_null($ship_to_address_line3) && (mb_strlen($ship_to_address_line3) < 0)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_address_line3 when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['ship_to_address_line3'] = $ship_to_address_line3;

        return $this;
    }

    /**
     * Gets ship_to_address_line4
     *
     * @return string|null
     */
    public function getShipToAddressLine4()
    {
        return $this->container['ship_to_address_line4'];
    }

    /**
     * Sets ship_to_address_line4
     *
     * @param string|null $ship_to_address_line4 Ship to address line 4
     *
     * @return self
     */
    public function setShipToAddressLine4($ship_to_address_line4)
    {
        if (is_null($ship_to_address_line4)) {
            array_push($this->openAPINullablesSetToNull, 'ship_to_address_line4');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ship_to_address_line4', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($ship_to_address_line4) && (mb_strlen($ship_to_address_line4) > 50)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_address_line4 when calling Customer., must be smaller than or equal to 50.');
        }
        if (!is_null($ship_to_address_line4) && (mb_strlen($ship_to_address_line4) < 0)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_address_line4 when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['ship_to_address_line4'] = $ship_to_address_line4;

        return $this;
    }

    /**
     * Gets ship_to_city
     *
     * @return string
     */
    public function getShipToCity()
    {
        return $this->container['ship_to_city'];
    }

    /**
     * Sets ship_to_city
     *
     * @param string $ship_to_city Ship to address city or town
     *
     * @return self
     */
    public function setShipToCity($ship_to_city)
    {
        if (is_null($ship_to_city)) {
            throw new \InvalidArgumentException('non-nullable ship_to_city cannot be null');
        }
        if ((mb_strlen($ship_to_city) > 50)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_city when calling Customer., must be smaller than or equal to 50.');
        }
        if ((mb_strlen($ship_to_city) < 0)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_city when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['ship_to_city'] = $ship_to_city;

        return $this;
    }

    /**
     * Gets ship_to_territory
     *
     * @return string
     */
    public function getShipToTerritory()
    {
        return $this->container['ship_to_territory'];
    }

    /**
     * Sets ship_to_territory
     *
     * @param string $ship_to_territory Ship to address territory or county
     *
     * @return self
     */
    public function setShipToTerritory($ship_to_territory)
    {
        if (is_null($ship_to_territory)) {
            throw new \InvalidArgumentException('non-nullable ship_to_territory cannot be null');
        }
        if ((mb_strlen($ship_to_territory) > 50)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_territory when calling Customer., must be smaller than or equal to 50.');
        }
        if ((mb_strlen($ship_to_territory) < 0)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_territory when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['ship_to_territory'] = $ship_to_territory;

        return $this;
    }

    /**
     * Gets ship_to_zip
     *
     * @return string
     */
    public function getShipToZip()
    {
        return $this->container['ship_to_zip'];
    }

    /**
     * Sets ship_to_zip
     *
     * @param string $ship_to_zip Ship to address zip or postcode
     *
     * @return self
     */
    public function setShipToZip($ship_to_zip)
    {
        if (is_null($ship_to_zip)) {
            throw new \InvalidArgumentException('non-nullable ship_to_zip cannot be null');
        }
        if ((mb_strlen($ship_to_zip) > 50)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_zip when calling Customer., must be smaller than or equal to 50.');
        }
        if ((mb_strlen($ship_to_zip) < 0)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_zip when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['ship_to_zip'] = $ship_to_zip;

        return $this;
    }

    /**
     * Gets ship_to_iso_country_code
     *
     * @return string|null
     */
    public function getShipToIsoCountryCode()
    {
        return $this->container['ship_to_iso_country_code'];
    }

    /**
     * Sets ship_to_iso_country_code
     *
     * @param string|null $ship_to_iso_country_code Ship to address IsoCountryCode. http://../Countries
     *
     * @return self
     */
    public function setShipToIsoCountryCode($ship_to_iso_country_code)
    {
        if (is_null($ship_to_iso_country_code)) {
            array_push($this->openAPINullablesSetToNull, 'ship_to_iso_country_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ship_to_iso_country_code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($ship_to_iso_country_code) && (mb_strlen($ship_to_iso_country_code) > 4)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_iso_country_code when calling Customer., must be smaller than or equal to 4.');
        }
        if (!is_null($ship_to_iso_country_code) && (mb_strlen($ship_to_iso_country_code) < 0)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_iso_country_code when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['ship_to_iso_country_code'] = $ship_to_iso_country_code;

        return $this;
    }

    /**
     * Gets ship_to_telephone_itu_country_code
     *
     * @return string|null
     */
    public function getShipToTelephoneItuCountryCode()
    {
        return $this->container['ship_to_telephone_itu_country_code'];
    }

    /**
     * Sets ship_to_telephone_itu_country_code
     *
     * @param string|null $ship_to_telephone_itu_country_code Ship to telephone Itu Country Code.
     *
     * @return self
     */
    public function setShipToTelephoneItuCountryCode($ship_to_telephone_itu_country_code)
    {
        if (is_null($ship_to_telephone_itu_country_code)) {
            array_push($this->openAPINullablesSetToNull, 'ship_to_telephone_itu_country_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ship_to_telephone_itu_country_code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($ship_to_telephone_itu_country_code) && (mb_strlen($ship_to_telephone_itu_country_code) > 7)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_telephone_itu_country_code when calling Customer., must be smaller than or equal to 7.');
        }
        if (!is_null($ship_to_telephone_itu_country_code) && (mb_strlen($ship_to_telephone_itu_country_code) < 0)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_telephone_itu_country_code when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['ship_to_telephone_itu_country_code'] = $ship_to_telephone_itu_country_code;

        return $this;
    }

    /**
     * Gets ship_to_telephone_number
     *
     * @return string
     */
    public function getShipToTelephoneNumber()
    {
        return $this->container['ship_to_telephone_number'];
    }

    /**
     * Sets ship_to_telephone_number
     *
     * @param string $ship_to_telephone_number Ship to telephone number
     *
     * @return self
     */
    public function setShipToTelephoneNumber($ship_to_telephone_number)
    {
        if (is_null($ship_to_telephone_number)) {
            throw new \InvalidArgumentException('non-nullable ship_to_telephone_number cannot be null');
        }
        if ((mb_strlen($ship_to_telephone_number) > 50)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_telephone_number when calling Customer., must be smaller than or equal to 50.');
        }
        if ((mb_strlen($ship_to_telephone_number) < 0)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_telephone_number when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['ship_to_telephone_number'] = $ship_to_telephone_number;

        return $this;
    }

    /**
     * Gets ship_to_fax_itu_country_code
     *
     * @return string|null
     */
    public function getShipToFaxItuCountryCode()
    {
        return $this->container['ship_to_fax_itu_country_code'];
    }

    /**
     * Sets ship_to_fax_itu_country_code
     *
     * @param string|null $ship_to_fax_itu_country_code Ship to fax Itu Country Code.
     *
     * @return self
     */
    public function setShipToFaxItuCountryCode($ship_to_fax_itu_country_code)
    {
        if (is_null($ship_to_fax_itu_country_code)) {
            array_push($this->openAPINullablesSetToNull, 'ship_to_fax_itu_country_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ship_to_fax_itu_country_code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($ship_to_fax_itu_country_code) && (mb_strlen($ship_to_fax_itu_country_code) > 7)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_fax_itu_country_code when calling Customer., must be smaller than or equal to 7.');
        }
        if (!is_null($ship_to_fax_itu_country_code) && (mb_strlen($ship_to_fax_itu_country_code) < 0)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_fax_itu_country_code when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['ship_to_fax_itu_country_code'] = $ship_to_fax_itu_country_code;

        return $this;
    }

    /**
     * Gets ship_to_fax_number
     *
     * @return string|null
     */
    public function getShipToFaxNumber()
    {
        return $this->container['ship_to_fax_number'];
    }

    /**
     * Sets ship_to_fax_number
     *
     * @param string|null $ship_to_fax_number Ship to fax number
     *
     * @return self
     */
    public function setShipToFaxNumber($ship_to_fax_number)
    {
        if (is_null($ship_to_fax_number)) {
            array_push($this->openAPINullablesSetToNull, 'ship_to_fax_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ship_to_fax_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($ship_to_fax_number) && (mb_strlen($ship_to_fax_number) > 50)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_fax_number when calling Customer., must be smaller than or equal to 50.');
        }
        if (!is_null($ship_to_fax_number) && (mb_strlen($ship_to_fax_number) < 0)) {
            throw new \InvalidArgumentException('invalid length for $ship_to_fax_number when calling Customer., must be bigger than or equal to 0.');
        }

        $this->container['ship_to_fax_number'] = $ship_to_fax_number;

        return $this;
    }

    /**
     * Gets community_ids
     *
     * @return int[]|null
     */
    public function getCommunityIds()
    {
        return $this->container['community_ids'];
    }

    /**
     * Sets community_ids
     *
     * @param int[]|null $community_ids The list of community ids that the customer belongs to
     *
     * @return self
     */
    public function setCommunityIds($community_ids)
    {
        if (is_null($community_ids)) {
            array_push($this->openAPINullablesSetToNull, 'community_ids');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('community_ids', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['community_ids'] = $community_ids;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


