<?php
/**
 * BasketLine
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * BasketLine Class Doc Comment
 *
 * @category Class
 * @description A line within a basket of products.
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class BasketLine implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'BasketLine';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'line_identifier' => 'string',
        'item_location_detail_id' => 'int',
        'quantity' => 'float',
        'regular_unit_price' => 'float',
        'actual_unit_price' => 'float',
        'tax_group_id' => 'int',
        'sales_tax' => 'float',
        'discount_reason_code_id' => 'int',
        'discount_description' => 'string',
        'comment' => 'string',
        'serial_number' => 'string',
        'seat_number' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'line_identifier' => null,
        'item_location_detail_id' => 'int32',
        'quantity' => 'double',
        'regular_unit_price' => 'double',
        'actual_unit_price' => 'double',
        'tax_group_id' => 'int32',
        'sales_tax' => 'double',
        'discount_reason_code_id' => 'int32',
        'discount_description' => null,
        'comment' => null,
        'serial_number' => null,
        'seat_number' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'line_identifier' => false,
        'item_location_detail_id' => false,
        'quantity' => false,
        'regular_unit_price' => false,
        'actual_unit_price' => false,
        'tax_group_id' => true,
        'sales_tax' => true,
        'discount_reason_code_id' => true,
        'discount_description' => true,
        'comment' => true,
        'serial_number' => true,
        'seat_number' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'line_identifier' => 'lineIdentifier',
        'item_location_detail_id' => 'itemLocationDetailId',
        'quantity' => 'quantity',
        'regular_unit_price' => 'regularUnitPrice',
        'actual_unit_price' => 'actualUnitPrice',
        'tax_group_id' => 'taxGroupId',
        'sales_tax' => 'salesTax',
        'discount_reason_code_id' => 'discountReasonCodeId',
        'discount_description' => 'discountDescription',
        'comment' => 'comment',
        'serial_number' => 'serialNumber',
        'seat_number' => 'seatNumber'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'line_identifier' => 'setLineIdentifier',
        'item_location_detail_id' => 'setItemLocationDetailId',
        'quantity' => 'setQuantity',
        'regular_unit_price' => 'setRegularUnitPrice',
        'actual_unit_price' => 'setActualUnitPrice',
        'tax_group_id' => 'setTaxGroupId',
        'sales_tax' => 'setSalesTax',
        'discount_reason_code_id' => 'setDiscountReasonCodeId',
        'discount_description' => 'setDiscountDescription',
        'comment' => 'setComment',
        'serial_number' => 'setSerialNumber',
        'seat_number' => 'setSeatNumber'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'line_identifier' => 'getLineIdentifier',
        'item_location_detail_id' => 'getItemLocationDetailId',
        'quantity' => 'getQuantity',
        'regular_unit_price' => 'getRegularUnitPrice',
        'actual_unit_price' => 'getActualUnitPrice',
        'tax_group_id' => 'getTaxGroupId',
        'sales_tax' => 'getSalesTax',
        'discount_reason_code_id' => 'getDiscountReasonCodeId',
        'discount_description' => 'getDiscountDescription',
        'comment' => 'getComment',
        'serial_number' => 'getSerialNumber',
        'seat_number' => 'getSeatNumber'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('line_identifier', $data ?? [], null);
        $this->setIfExists('item_location_detail_id', $data ?? [], null);
        $this->setIfExists('quantity', $data ?? [], null);
        $this->setIfExists('regular_unit_price', $data ?? [], null);
        $this->setIfExists('actual_unit_price', $data ?? [], null);
        $this->setIfExists('tax_group_id', $data ?? [], null);
        $this->setIfExists('sales_tax', $data ?? [], null);
        $this->setIfExists('discount_reason_code_id', $data ?? [], null);
        $this->setIfExists('discount_description', $data ?? [], null);
        $this->setIfExists('comment', $data ?? [], null);
        $this->setIfExists('serial_number', $data ?? [], null);
        $this->setIfExists('seat_number', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['line_identifier'] === null) {
            $invalidProperties[] = "'line_identifier' can't be null";
        }
        if ((mb_strlen($this->container['line_identifier']) < 1)) {
            $invalidProperties[] = "invalid value for 'line_identifier', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['regular_unit_price'] === null) {
            $invalidProperties[] = "'regular_unit_price' can't be null";
        }
        if ($this->container['actual_unit_price'] === null) {
            $invalidProperties[] = "'actual_unit_price' can't be null";
        }
        if (!is_null($this->container['discount_description']) && (mb_strlen($this->container['discount_description']) > 255)) {
            $invalidProperties[] = "invalid value for 'discount_description', the character length must be smaller than or equal to 255.";
        }

        if (!is_null($this->container['discount_description']) && (mb_strlen($this->container['discount_description']) < 0)) {
            $invalidProperties[] = "invalid value for 'discount_description', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['comment']) && (mb_strlen($this->container['comment']) > 255)) {
            $invalidProperties[] = "invalid value for 'comment', the character length must be smaller than or equal to 255.";
        }

        if (!is_null($this->container['comment']) && (mb_strlen($this->container['comment']) < 0)) {
            $invalidProperties[] = "invalid value for 'comment', the character length must be bigger than or equal to 0.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets line_identifier
     *
     * @return string
     */
    public function getLineIdentifier()
    {
        return $this->container['line_identifier'];
    }

    /**
     * Sets line_identifier
     *
     * @param string $line_identifier A unique identifier for this BasketLine object.
     *
     * @return self
     */
    public function setLineIdentifier($line_identifier)
    {
        if (is_null($line_identifier)) {
            throw new \InvalidArgumentException('non-nullable line_identifier cannot be null');
        }

        if ((mb_strlen($line_identifier) < 1)) {
            throw new \InvalidArgumentException('invalid length for $line_identifier when calling BasketLine., must be bigger than or equal to 1.');
        }

        $this->container['line_identifier'] = $line_identifier;

        return $this;
    }

    /**
     * Gets item_location_detail_id
     *
     * @return int|null
     */
    public function getItemLocationDetailId()
    {
        return $this->container['item_location_detail_id'];
    }

    /**
     * Sets item_location_detail_id
     *
     * @param int|null $item_location_detail_id The id of the item location detail record.
     *
     * @return self
     */
    public function setItemLocationDetailId($item_location_detail_id)
    {
        if (is_null($item_location_detail_id)) {
            throw new \InvalidArgumentException('non-nullable item_location_detail_id cannot be null');
        }
        $this->container['item_location_detail_id'] = $item_location_detail_id;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param float|null $quantity The quantity of individual units in the line.
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        if (is_null($quantity)) {
            throw new \InvalidArgumentException('non-nullable quantity cannot be null');
        }
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets regular_unit_price
     *
     * @return float
     */
    public function getRegularUnitPrice()
    {
        return $this->container['regular_unit_price'];
    }

    /**
     * Sets regular_unit_price
     *
     * @param float $regular_unit_price The regular unit price of the line. To include tax if the Basket.IsTaxInclusivePrices = true.
     *
     * @return self
     */
    public function setRegularUnitPrice($regular_unit_price)
    {
        if (is_null($regular_unit_price)) {
            throw new \InvalidArgumentException('non-nullable regular_unit_price cannot be null');
        }
        $this->container['regular_unit_price'] = $regular_unit_price;

        return $this;
    }

    /**
     * Gets actual_unit_price
     *
     * @return float
     */
    public function getActualUnitPrice()
    {
        return $this->container['actual_unit_price'];
    }

    /**
     * Sets actual_unit_price
     *
     * @param float $actual_unit_price The actual unit price of the line. To include tax if the Basket.IsTaxInclusivePrices = true.
     *
     * @return self
     */
    public function setActualUnitPrice($actual_unit_price)
    {
        if (is_null($actual_unit_price)) {
            throw new \InvalidArgumentException('non-nullable actual_unit_price cannot be null');
        }
        $this->container['actual_unit_price'] = $actual_unit_price;

        return $this;
    }

    /**
     * Gets tax_group_id
     *
     * @return int|null
     */
    public function getTaxGroupId()
    {
        return $this->container['tax_group_id'];
    }

    /**
     * Sets tax_group_id
     *
     * @param int|null $tax_group_id The actual tax group applied to the item if it's different to the default for this sale.
     *
     * @return self
     */
    public function setTaxGroupId($tax_group_id)
    {
        if (is_null($tax_group_id)) {
            array_push($this->openAPINullablesSetToNull, 'tax_group_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('tax_group_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['tax_group_id'] = $tax_group_id;

        return $this;
    }

    /**
     * Gets sales_tax
     *
     * @return float|null
     */
    public function getSalesTax()
    {
        return $this->container['sales_tax'];
    }

    /**
     * Sets sales_tax
     *
     * @param float|null $sales_tax The tax on the item if the basket is set to tax exclusive but there are taxable items  or if the tax is being overridden.
     *
     * @return self
     */
    public function setSalesTax($sales_tax)
    {
        if (is_null($sales_tax)) {
            array_push($this->openAPINullablesSetToNull, 'sales_tax');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('sales_tax', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['sales_tax'] = $sales_tax;

        return $this;
    }

    /**
     * Gets discount_reason_code_id
     *
     * @return int|null
     */
    public function getDiscountReasonCodeId()
    {
        return $this->container['discount_reason_code_id'];
    }

    /**
     * Sets discount_reason_code_id
     *
     * @param int|null $discount_reason_code_id Discount Reason Code Id if line has already been discounted.
     *
     * @return self
     */
    public function setDiscountReasonCodeId($discount_reason_code_id)
    {
        if (is_null($discount_reason_code_id)) {
            array_push($this->openAPINullablesSetToNull, 'discount_reason_code_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('discount_reason_code_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['discount_reason_code_id'] = $discount_reason_code_id;

        return $this;
    }

    /**
     * Gets discount_description
     *
     * @return string|null
     */
    public function getDiscountDescription()
    {
        return $this->container['discount_description'];
    }

    /**
     * Sets discount_description
     *
     * @param string|null $discount_description Discount Description if line has already been discounted.
     *
     * @return self
     */
    public function setDiscountDescription($discount_description)
    {
        if (is_null($discount_description)) {
            array_push($this->openAPINullablesSetToNull, 'discount_description');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('discount_description', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($discount_description) && (mb_strlen($discount_description) > 255)) {
            throw new \InvalidArgumentException('invalid length for $discount_description when calling BasketLine., must be smaller than or equal to 255.');
        }
        if (!is_null($discount_description) && (mb_strlen($discount_description) < 0)) {
            throw new \InvalidArgumentException('invalid length for $discount_description when calling BasketLine., must be bigger than or equal to 0.');
        }

        $this->container['discount_description'] = $discount_description;

        return $this;
    }

    /**
     * Gets comment
     *
     * @return string|null
     */
    public function getComment()
    {
        return $this->container['comment'];
    }

    /**
     * Sets comment
     *
     * @param string|null $comment Any comment associated with this line.
     *
     * @return self
     */
    public function setComment($comment)
    {
        if (is_null($comment)) {
            array_push($this->openAPINullablesSetToNull, 'comment');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('comment', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        if (!is_null($comment) && (mb_strlen($comment) > 255)) {
            throw new \InvalidArgumentException('invalid length for $comment when calling BasketLine., must be smaller than or equal to 255.');
        }
        if (!is_null($comment) && (mb_strlen($comment) < 0)) {
            throw new \InvalidArgumentException('invalid length for $comment when calling BasketLine., must be bigger than or equal to 0.');
        }

        $this->container['comment'] = $comment;

        return $this;
    }

    /**
     * Gets serial_number
     *
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->container['serial_number'];
    }

    /**
     * Sets serial_number
     *
     * @param string|null $serial_number Any serial number associated with this line - e.g. the gift card number
     *
     * @return self
     */
    public function setSerialNumber($serial_number)
    {
        if (is_null($serial_number)) {
            array_push($this->openAPINullablesSetToNull, 'serial_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('serial_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['serial_number'] = $serial_number;

        return $this;
    }

    /**
     * Gets seat_number
     *
     * @return int|null
     */
    public function getSeatNumber()
    {
        return $this->container['seat_number'];
    }

    /**
     * Sets seat_number
     *
     * @param int|null $seat_number Any seat number associated with this line
     *
     * @return self
     */
    public function setSeatNumber($seat_number)
    {
        if (is_null($seat_number)) {
            array_push($this->openAPINullablesSetToNull, 'seat_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('seat_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['seat_number'] = $seat_number;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


