<?php
/**
 * Basket
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Model;

use \ArrayAccess;
use \Opsuite2\ObjectSerializer;

/**
 * Basket Class Doc Comment
 *
 * @category Class
 * @description A basket of products.
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Basket implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Basket';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'location_id' => 'int',
        'customer_id' => 'int',
        'customer_account_number' => 'string',
        'customer_email_address' => 'string',
        'is_tax_inclusive_prices' => 'bool',
        'table_id' => 'int',
        'basket_lines' => '\Opsuite2\Model\BasketLine[]',
        'discount_coupon_serial_numbers' => 'string[]',
        'promotion_coupon_serial_numbers' => 'string[]',
        'bounce_back_coupon_serial_numbers' => 'string[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'location_id' => 'int32',
        'customer_id' => 'int32',
        'customer_account_number' => null,
        'customer_email_address' => null,
        'is_tax_inclusive_prices' => null,
        'table_id' => 'int32',
        'basket_lines' => null,
        'discount_coupon_serial_numbers' => null,
        'promotion_coupon_serial_numbers' => null,
        'bounce_back_coupon_serial_numbers' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'location_id' => false,
        'customer_id' => true,
        'customer_account_number' => true,
        'customer_email_address' => true,
        'is_tax_inclusive_prices' => false,
        'table_id' => true,
        'basket_lines' => false,
        'discount_coupon_serial_numbers' => true,
        'promotion_coupon_serial_numbers' => true,
        'bounce_back_coupon_serial_numbers' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'location_id' => 'locationId',
        'customer_id' => 'customerId',
        'customer_account_number' => 'customerAccountNumber',
        'customer_email_address' => 'customerEmailAddress',
        'is_tax_inclusive_prices' => 'isTaxInclusivePrices',
        'table_id' => 'tableId',
        'basket_lines' => 'basketLines',
        'discount_coupon_serial_numbers' => 'discountCouponSerialNumbers',
        'promotion_coupon_serial_numbers' => 'promotionCouponSerialNumbers',
        'bounce_back_coupon_serial_numbers' => 'bounceBackCouponSerialNumbers'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'location_id' => 'setLocationId',
        'customer_id' => 'setCustomerId',
        'customer_account_number' => 'setCustomerAccountNumber',
        'customer_email_address' => 'setCustomerEmailAddress',
        'is_tax_inclusive_prices' => 'setIsTaxInclusivePrices',
        'table_id' => 'setTableId',
        'basket_lines' => 'setBasketLines',
        'discount_coupon_serial_numbers' => 'setDiscountCouponSerialNumbers',
        'promotion_coupon_serial_numbers' => 'setPromotionCouponSerialNumbers',
        'bounce_back_coupon_serial_numbers' => 'setBounceBackCouponSerialNumbers'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'location_id' => 'getLocationId',
        'customer_id' => 'getCustomerId',
        'customer_account_number' => 'getCustomerAccountNumber',
        'customer_email_address' => 'getCustomerEmailAddress',
        'is_tax_inclusive_prices' => 'getIsTaxInclusivePrices',
        'table_id' => 'getTableId',
        'basket_lines' => 'getBasketLines',
        'discount_coupon_serial_numbers' => 'getDiscountCouponSerialNumbers',
        'promotion_coupon_serial_numbers' => 'getPromotionCouponSerialNumbers',
        'bounce_back_coupon_serial_numbers' => 'getBounceBackCouponSerialNumbers'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('location_id', $data ?? [], null);
        $this->setIfExists('customer_id', $data ?? [], null);
        $this->setIfExists('customer_account_number', $data ?? [], null);
        $this->setIfExists('customer_email_address', $data ?? [], null);
        $this->setIfExists('is_tax_inclusive_prices', $data ?? [], null);
        $this->setIfExists('table_id', $data ?? [], null);
        $this->setIfExists('basket_lines', $data ?? [], null);
        $this->setIfExists('discount_coupon_serial_numbers', $data ?? [], null);
        $this->setIfExists('promotion_coupon_serial_numbers', $data ?? [], null);
        $this->setIfExists('bounce_back_coupon_serial_numbers', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['is_tax_inclusive_prices'] === null) {
            $invalidProperties[] = "'is_tax_inclusive_prices' can't be null";
        }
        if ($this->container['basket_lines'] === null) {
            $invalidProperties[] = "'basket_lines' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets location_id
     *
     * @return int|null
     */
    public function getLocationId()
    {
        return $this->container['location_id'];
    }

    /**
     * Sets location_id
     *
     * @param int|null $location_id The id of the location associated with this basket.
     *
     * @return self
     */
    public function setLocationId($location_id)
    {
        if (is_null($location_id)) {
            throw new \InvalidArgumentException('non-nullable location_id cannot be null');
        }
        $this->container['location_id'] = $location_id;

        return $this;
    }

    /**
     * Gets customer_id
     *
     * @return int|null
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     *
     * @param int|null $customer_id The customer id, if applicable.
     *
     * @return self
     */
    public function setCustomerId($customer_id)
    {
        if (is_null($customer_id)) {
            array_push($this->openAPINullablesSetToNull, 'customer_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('customer_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets customer_account_number
     *
     * @return string|null
     */
    public function getCustomerAccountNumber()
    {
        return $this->container['customer_account_number'];
    }

    /**
     * Sets customer_account_number
     *
     * @param string|null $customer_account_number The customer account number, if applicable
     *
     * @return self
     */
    public function setCustomerAccountNumber($customer_account_number)
    {
        if (is_null($customer_account_number)) {
            array_push($this->openAPINullablesSetToNull, 'customer_account_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('customer_account_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['customer_account_number'] = $customer_account_number;

        return $this;
    }

    /**
     * Gets customer_email_address
     *
     * @return string|null
     */
    public function getCustomerEmailAddress()
    {
        return $this->container['customer_email_address'];
    }

    /**
     * Sets customer_email_address
     *
     * @param string|null $customer_email_address The customer email address, if applicable
     *
     * @return self
     */
    public function setCustomerEmailAddress($customer_email_address)
    {
        if (is_null($customer_email_address)) {
            array_push($this->openAPINullablesSetToNull, 'customer_email_address');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('customer_email_address', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['customer_email_address'] = $customer_email_address;

        return $this;
    }

    /**
     * Gets is_tax_inclusive_prices
     *
     * @return bool
     */
    public function getIsTaxInclusivePrices()
    {
        return $this->container['is_tax_inclusive_prices'];
    }

    /**
     * Sets is_tax_inclusive_prices
     *
     * @param bool $is_tax_inclusive_prices Whether prices in the basket are tax inclusive.
     *
     * @return self
     */
    public function setIsTaxInclusivePrices($is_tax_inclusive_prices)
    {
        if (is_null($is_tax_inclusive_prices)) {
            throw new \InvalidArgumentException('non-nullable is_tax_inclusive_prices cannot be null');
        }
        $this->container['is_tax_inclusive_prices'] = $is_tax_inclusive_prices;

        return $this;
    }

    /**
     * Gets table_id
     *
     * @return int|null
     */
    public function getTableId()
    {
        return $this->container['table_id'];
    }

    /**
     * Sets table_id
     *
     * @param int|null $table_id The table id, if applicable
     *
     * @return self
     */
    public function setTableId($table_id)
    {
        if (is_null($table_id)) {
            array_push($this->openAPINullablesSetToNull, 'table_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('table_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['table_id'] = $table_id;

        return $this;
    }

    /**
     * Gets basket_lines
     *
     * @return \Opsuite2\Model\BasketLine[]
     */
    public function getBasketLines()
    {
        return $this->container['basket_lines'];
    }

    /**
     * Sets basket_lines
     *
     * @param \Opsuite2\Model\BasketLine[] $basket_lines The product lines in the basket.
     *
     * @return self
     */
    public function setBasketLines($basket_lines)
    {
        if (is_null($basket_lines)) {
            throw new \InvalidArgumentException('non-nullable basket_lines cannot be null');
        }
        $this->container['basket_lines'] = $basket_lines;

        return $this;
    }

    /**
     * Gets discount_coupon_serial_numbers
     *
     * @return string[]|null
     */
    public function getDiscountCouponSerialNumbers()
    {
        return $this->container['discount_coupon_serial_numbers'];
    }

    /**
     * Sets discount_coupon_serial_numbers
     *
     * @param string[]|null $discount_coupon_serial_numbers Serial numbers of any discount coupons.
     *
     * @return self
     */
    public function setDiscountCouponSerialNumbers($discount_coupon_serial_numbers)
    {
        if (is_null($discount_coupon_serial_numbers)) {
            array_push($this->openAPINullablesSetToNull, 'discount_coupon_serial_numbers');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('discount_coupon_serial_numbers', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['discount_coupon_serial_numbers'] = $discount_coupon_serial_numbers;

        return $this;
    }

    /**
     * Gets promotion_coupon_serial_numbers
     *
     * @return string[]|null
     */
    public function getPromotionCouponSerialNumbers()
    {
        return $this->container['promotion_coupon_serial_numbers'];
    }

    /**
     * Sets promotion_coupon_serial_numbers
     *
     * @param string[]|null $promotion_coupon_serial_numbers Serial numbers of any promotion coupons.
     *
     * @return self
     */
    public function setPromotionCouponSerialNumbers($promotion_coupon_serial_numbers)
    {
        if (is_null($promotion_coupon_serial_numbers)) {
            array_push($this->openAPINullablesSetToNull, 'promotion_coupon_serial_numbers');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('promotion_coupon_serial_numbers', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['promotion_coupon_serial_numbers'] = $promotion_coupon_serial_numbers;

        return $this;
    }

    /**
     * Gets bounce_back_coupon_serial_numbers
     *
     * @return string[]|null
     */
    public function getBounceBackCouponSerialNumbers()
    {
        return $this->container['bounce_back_coupon_serial_numbers'];
    }

    /**
     * Sets bounce_back_coupon_serial_numbers
     *
     * @param string[]|null $bounce_back_coupon_serial_numbers Serial numbers of any bounce back coupons.
     *
     * @return self
     */
    public function setBounceBackCouponSerialNumbers($bounce_back_coupon_serial_numbers)
    {
        if (is_null($bounce_back_coupon_serial_numbers)) {
            array_push($this->openAPINullablesSetToNull, 'bounce_back_coupon_serial_numbers');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('bounce_back_coupon_serial_numbers', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['bounce_back_coupon_serial_numbers'] = $bounce_back_coupon_serial_numbers;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


