<?php
/**
 * VouchersApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Opsuite2\ApiException;
use Opsuite2\Configuration;
use Opsuite2\FormDataProcessor;
use Opsuite2\HeaderSelector;
use Opsuite2\ObjectSerializer;

/**
 * VouchersApi Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class VouchersApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV1VouchersGet' => [
            'application/json',
        ],
        'apiV1VouchersPatchMultipleVouchersPatch' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'apiV1VouchersPost' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'apiV1VouchersPostMultipleVouchersPost' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'apiV1VouchersPostVoucherNumbersPost' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'apiV1VouchersPostVouchersPost' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'apiV1VouchersVoucherIdPatch' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'getVoucherById' => [
            'application/json',
        ],
        'getVoucherByNumber' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV1VouchersGet
     *
     * Returns an array of Vouchers that match the specified search criteria.
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  int|null $item_master_id item_master_id (optional)
     * @param  string|null $item_master_sku item_master_sku (optional)
     * @param  \Opsuite2\Model\StringSearchOperatorEnum|null $sku_search_operator sku_search_operator (optional)
     * @param  int|null $location_id location_id (optional)
     * @param  float|null $balance balance (optional)
     * @param  \Opsuite2\Model\NumericSearchOperatorEnum|null $balance_search_operator balance_search_operator (optional)
     * @param  \DateTime|null $date_created_date_range_start date_created_date_range_start (optional)
     * @param  \DateTime|null $date_created_date_range_end date_created_date_range_end (optional)
     * @param  bool|null $sold sold (optional)
     * @param  \DateTime|null $date_sold_date_range_start date_sold_date_range_start (optional)
     * @param  \DateTime|null $date_sold_date_range_end date_sold_date_range_end (optional)
     * @param  \DateTime|null $last_used_date_range_start last_used_date_range_start (optional)
     * @param  \DateTime|null $last_used_date_range_end last_used_date_range_end (optional)
     * @param  bool|null $expired expired (optional)
     * @param  \DateTime|null $expiration_date_date_range_start expiration_date_date_range_start (optional)
     * @param  \DateTime|null $expiration_date_date_range_end expiration_date_date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\Voucher[]|string
     */
    public function apiV1VouchersGet($page_number = null, $page_size = null, $item_master_id = null, $item_master_sku = null, $sku_search_operator = null, $location_id = null, $balance = null, $balance_search_operator = null, $date_created_date_range_start = null, $date_created_date_range_end = null, $sold = null, $date_sold_date_range_start = null, $date_sold_date_range_end = null, $last_used_date_range_start = null, $last_used_date_range_end = null, $expired = null, $expiration_date_date_range_start = null, $expiration_date_date_range_end = null, string $contentType = self::contentTypes['apiV1VouchersGet'][0])
    {
        list($response) = $this->apiV1VouchersGetWithHttpInfo($page_number, $page_size, $item_master_id, $item_master_sku, $sku_search_operator, $location_id, $balance, $balance_search_operator, $date_created_date_range_start, $date_created_date_range_end, $sold, $date_sold_date_range_start, $date_sold_date_range_end, $last_used_date_range_start, $last_used_date_range_end, $expired, $expiration_date_date_range_start, $expiration_date_date_range_end, $contentType);
        return $response;
    }

    /**
     * Operation apiV1VouchersGetWithHttpInfo
     *
     * Returns an array of Vouchers that match the specified search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $item_master_id (optional)
     * @param  string|null $item_master_sku (optional)
     * @param  \Opsuite2\Model\StringSearchOperatorEnum|null $sku_search_operator (optional)
     * @param  int|null $location_id (optional)
     * @param  float|null $balance (optional)
     * @param  \Opsuite2\Model\NumericSearchOperatorEnum|null $balance_search_operator (optional)
     * @param  \DateTime|null $date_created_date_range_start (optional)
     * @param  \DateTime|null $date_created_date_range_end (optional)
     * @param  bool|null $sold (optional)
     * @param  \DateTime|null $date_sold_date_range_start (optional)
     * @param  \DateTime|null $date_sold_date_range_end (optional)
     * @param  \DateTime|null $last_used_date_range_start (optional)
     * @param  \DateTime|null $last_used_date_range_end (optional)
     * @param  bool|null $expired (optional)
     * @param  \DateTime|null $expiration_date_date_range_start (optional)
     * @param  \DateTime|null $expiration_date_date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\Voucher[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1VouchersGetWithHttpInfo($page_number = null, $page_size = null, $item_master_id = null, $item_master_sku = null, $sku_search_operator = null, $location_id = null, $balance = null, $balance_search_operator = null, $date_created_date_range_start = null, $date_created_date_range_end = null, $sold = null, $date_sold_date_range_start = null, $date_sold_date_range_end = null, $last_used_date_range_start = null, $last_used_date_range_end = null, $expired = null, $expiration_date_date_range_start = null, $expiration_date_date_range_end = null, string $contentType = self::contentTypes['apiV1VouchersGet'][0])
    {
        $request = $this->apiV1VouchersGetRequest($page_number, $page_size, $item_master_id, $item_master_sku, $sku_search_operator, $location_id, $balance, $balance_search_operator, $date_created_date_range_start, $date_created_date_range_end, $sold, $date_sold_date_range_start, $date_sold_date_range_end, $last_used_date_range_start, $last_used_date_range_end, $expired, $expiration_date_date_range_start, $expiration_date_date_range_end, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\Voucher[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\Voucher[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\Voucher[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1VouchersGetAsync
     *
     * Returns an array of Vouchers that match the specified search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $item_master_id (optional)
     * @param  string|null $item_master_sku (optional)
     * @param  \Opsuite2\Model\StringSearchOperatorEnum|null $sku_search_operator (optional)
     * @param  int|null $location_id (optional)
     * @param  float|null $balance (optional)
     * @param  \Opsuite2\Model\NumericSearchOperatorEnum|null $balance_search_operator (optional)
     * @param  \DateTime|null $date_created_date_range_start (optional)
     * @param  \DateTime|null $date_created_date_range_end (optional)
     * @param  bool|null $sold (optional)
     * @param  \DateTime|null $date_sold_date_range_start (optional)
     * @param  \DateTime|null $date_sold_date_range_end (optional)
     * @param  \DateTime|null $last_used_date_range_start (optional)
     * @param  \DateTime|null $last_used_date_range_end (optional)
     * @param  bool|null $expired (optional)
     * @param  \DateTime|null $expiration_date_date_range_start (optional)
     * @param  \DateTime|null $expiration_date_date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1VouchersGetAsync($page_number = null, $page_size = null, $item_master_id = null, $item_master_sku = null, $sku_search_operator = null, $location_id = null, $balance = null, $balance_search_operator = null, $date_created_date_range_start = null, $date_created_date_range_end = null, $sold = null, $date_sold_date_range_start = null, $date_sold_date_range_end = null, $last_used_date_range_start = null, $last_used_date_range_end = null, $expired = null, $expiration_date_date_range_start = null, $expiration_date_date_range_end = null, string $contentType = self::contentTypes['apiV1VouchersGet'][0])
    {
        return $this->apiV1VouchersGetAsyncWithHttpInfo($page_number, $page_size, $item_master_id, $item_master_sku, $sku_search_operator, $location_id, $balance, $balance_search_operator, $date_created_date_range_start, $date_created_date_range_end, $sold, $date_sold_date_range_start, $date_sold_date_range_end, $last_used_date_range_start, $last_used_date_range_end, $expired, $expiration_date_date_range_start, $expiration_date_date_range_end, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1VouchersGetAsyncWithHttpInfo
     *
     * Returns an array of Vouchers that match the specified search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $item_master_id (optional)
     * @param  string|null $item_master_sku (optional)
     * @param  \Opsuite2\Model\StringSearchOperatorEnum|null $sku_search_operator (optional)
     * @param  int|null $location_id (optional)
     * @param  float|null $balance (optional)
     * @param  \Opsuite2\Model\NumericSearchOperatorEnum|null $balance_search_operator (optional)
     * @param  \DateTime|null $date_created_date_range_start (optional)
     * @param  \DateTime|null $date_created_date_range_end (optional)
     * @param  bool|null $sold (optional)
     * @param  \DateTime|null $date_sold_date_range_start (optional)
     * @param  \DateTime|null $date_sold_date_range_end (optional)
     * @param  \DateTime|null $last_used_date_range_start (optional)
     * @param  \DateTime|null $last_used_date_range_end (optional)
     * @param  bool|null $expired (optional)
     * @param  \DateTime|null $expiration_date_date_range_start (optional)
     * @param  \DateTime|null $expiration_date_date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1VouchersGetAsyncWithHttpInfo($page_number = null, $page_size = null, $item_master_id = null, $item_master_sku = null, $sku_search_operator = null, $location_id = null, $balance = null, $balance_search_operator = null, $date_created_date_range_start = null, $date_created_date_range_end = null, $sold = null, $date_sold_date_range_start = null, $date_sold_date_range_end = null, $last_used_date_range_start = null, $last_used_date_range_end = null, $expired = null, $expiration_date_date_range_start = null, $expiration_date_date_range_end = null, string $contentType = self::contentTypes['apiV1VouchersGet'][0])
    {
        $returnType = '\Opsuite2\Model\Voucher[]';
        $request = $this->apiV1VouchersGetRequest($page_number, $page_size, $item_master_id, $item_master_sku, $sku_search_operator, $location_id, $balance, $balance_search_operator, $date_created_date_range_start, $date_created_date_range_end, $sold, $date_sold_date_range_start, $date_sold_date_range_end, $last_used_date_range_start, $last_used_date_range_end, $expired, $expiration_date_date_range_start, $expiration_date_date_range_end, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1VouchersGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $item_master_id (optional)
     * @param  string|null $item_master_sku (optional)
     * @param  \Opsuite2\Model\StringSearchOperatorEnum|null $sku_search_operator (optional)
     * @param  int|null $location_id (optional)
     * @param  float|null $balance (optional)
     * @param  \Opsuite2\Model\NumericSearchOperatorEnum|null $balance_search_operator (optional)
     * @param  \DateTime|null $date_created_date_range_start (optional)
     * @param  \DateTime|null $date_created_date_range_end (optional)
     * @param  bool|null $sold (optional)
     * @param  \DateTime|null $date_sold_date_range_start (optional)
     * @param  \DateTime|null $date_sold_date_range_end (optional)
     * @param  \DateTime|null $last_used_date_range_start (optional)
     * @param  \DateTime|null $last_used_date_range_end (optional)
     * @param  bool|null $expired (optional)
     * @param  \DateTime|null $expiration_date_date_range_start (optional)
     * @param  \DateTime|null $expiration_date_date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1VouchersGetRequest($page_number = null, $page_size = null, $item_master_id = null, $item_master_sku = null, $sku_search_operator = null, $location_id = null, $balance = null, $balance_search_operator = null, $date_created_date_range_start = null, $date_created_date_range_end = null, $sold = null, $date_sold_date_range_start = null, $date_sold_date_range_end = null, $last_used_date_range_start = null, $last_used_date_range_end = null, $expired = null, $expiration_date_date_range_start = null, $expiration_date_date_range_end = null, string $contentType = self::contentTypes['apiV1VouchersGet'][0])
    {




















        $resourcePath = '/api/v1/Vouchers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $item_master_id,
            'ItemMasterId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $item_master_sku,
            'ItemMasterSku', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sku_search_operator,
            'SkuSearchOperator', // param base name
            'StringSearchOperatorEnum', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $location_id,
            'LocationId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $balance,
            'Balance', // param base name
            'number', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $balance_search_operator,
            'BalanceSearchOperator', // param base name
            'NumericSearchOperatorEnum', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_created_date_range_start,
            'DateCreatedDateRangeStart', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_created_date_range_end,
            'DateCreatedDateRangeEnd', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sold,
            'Sold', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_sold_date_range_start,
            'DateSoldDateRangeStart', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_sold_date_range_end,
            'DateSoldDateRangeEnd', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $last_used_date_range_start,
            'LastUsedDateRangeStart', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $last_used_date_range_end,
            'LastUsedDateRangeEnd', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $expired,
            'Expired', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $expiration_date_date_range_start,
            'ExpirationDateDateRangeStart', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $expiration_date_date_range_end,
            'ExpirationDateDateRangeEnd', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1VouchersPatchMultipleVouchersPatch
     *
     * Updates specified properties of multiple vouchers.
     *
     * @param  \Opsuite2\Model\PatchCollection[]|null $patch_collection patch_collection (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersPatchMultipleVouchersPatch'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\PatchResponse[]|string
     */
    public function apiV1VouchersPatchMultipleVouchersPatch($patch_collection = null, string $contentType = self::contentTypes['apiV1VouchersPatchMultipleVouchersPatch'][0])
    {
        list($response) = $this->apiV1VouchersPatchMultipleVouchersPatchWithHttpInfo($patch_collection, $contentType);
        return $response;
    }

    /**
     * Operation apiV1VouchersPatchMultipleVouchersPatchWithHttpInfo
     *
     * Updates specified properties of multiple vouchers.
     *
     * @param  \Opsuite2\Model\PatchCollection[]|null $patch_collection (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersPatchMultipleVouchersPatch'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\PatchResponse[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1VouchersPatchMultipleVouchersPatchWithHttpInfo($patch_collection = null, string $contentType = self::contentTypes['apiV1VouchersPatchMultipleVouchersPatch'][0])
    {
        $request = $this->apiV1VouchersPatchMultipleVouchersPatchRequest($patch_collection, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 202:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\PatchResponse[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\PatchResponse[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 202:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\PatchResponse[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1VouchersPatchMultipleVouchersPatchAsync
     *
     * Updates specified properties of multiple vouchers.
     *
     * @param  \Opsuite2\Model\PatchCollection[]|null $patch_collection (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersPatchMultipleVouchersPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1VouchersPatchMultipleVouchersPatchAsync($patch_collection = null, string $contentType = self::contentTypes['apiV1VouchersPatchMultipleVouchersPatch'][0])
    {
        return $this->apiV1VouchersPatchMultipleVouchersPatchAsyncWithHttpInfo($patch_collection, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1VouchersPatchMultipleVouchersPatchAsyncWithHttpInfo
     *
     * Updates specified properties of multiple vouchers.
     *
     * @param  \Opsuite2\Model\PatchCollection[]|null $patch_collection (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersPatchMultipleVouchersPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1VouchersPatchMultipleVouchersPatchAsyncWithHttpInfo($patch_collection = null, string $contentType = self::contentTypes['apiV1VouchersPatchMultipleVouchersPatch'][0])
    {
        $returnType = '\Opsuite2\Model\PatchResponse[]';
        $request = $this->apiV1VouchersPatchMultipleVouchersPatchRequest($patch_collection, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1VouchersPatchMultipleVouchersPatch'
     *
     * @param  \Opsuite2\Model\PatchCollection[]|null $patch_collection (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersPatchMultipleVouchersPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1VouchersPatchMultipleVouchersPatchRequest($patch_collection = null, string $contentType = self::contentTypes['apiV1VouchersPatchMultipleVouchersPatch'][0])
    {



        $resourcePath = '/api/v1/Vouchers/PatchMultipleVouchers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($patch_collection)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($patch_collection));
            } else {
                $httpBody = $patch_collection;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1VouchersPost
     *
     * Creates a new voucher.
     *
     * @param  \Opsuite2\Model\Voucher|null $voucher voucher (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\Voucher|string|string
     */
    public function apiV1VouchersPost($voucher = null, string $contentType = self::contentTypes['apiV1VouchersPost'][0])
    {
        list($response) = $this->apiV1VouchersPostWithHttpInfo($voucher, $contentType);
        return $response;
    }

    /**
     * Operation apiV1VouchersPostWithHttpInfo
     *
     * Creates a new voucher.
     *
     * @param  \Opsuite2\Model\Voucher|null $voucher (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\Voucher|string|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1VouchersPostWithHttpInfo($voucher = null, string $contentType = self::contentTypes['apiV1VouchersPost'][0])
    {
        $request = $this->apiV1VouchersPostRequest($voucher, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\Voucher',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\Voucher',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\Voucher',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1VouchersPostAsync
     *
     * Creates a new voucher.
     *
     * @param  \Opsuite2\Model\Voucher|null $voucher (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1VouchersPostAsync($voucher = null, string $contentType = self::contentTypes['apiV1VouchersPost'][0])
    {
        return $this->apiV1VouchersPostAsyncWithHttpInfo($voucher, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1VouchersPostAsyncWithHttpInfo
     *
     * Creates a new voucher.
     *
     * @param  \Opsuite2\Model\Voucher|null $voucher (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1VouchersPostAsyncWithHttpInfo($voucher = null, string $contentType = self::contentTypes['apiV1VouchersPost'][0])
    {
        $returnType = '\Opsuite2\Model\Voucher';
        $request = $this->apiV1VouchersPostRequest($voucher, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1VouchersPost'
     *
     * @param  \Opsuite2\Model\Voucher|null $voucher (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1VouchersPostRequest($voucher = null, string $contentType = self::contentTypes['apiV1VouchersPost'][0])
    {



        $resourcePath = '/api/v1/Vouchers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($voucher)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($voucher));
            } else {
                $httpBody = $voucher;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1VouchersPostMultipleVouchersPost
     *
     * Creates multiple new vouchers.
     *
     * @param  \Opsuite2\Model\Voucher[]|null $voucher voucher (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersPostMultipleVouchersPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\PostResponseVoucher[]|string
     */
    public function apiV1VouchersPostMultipleVouchersPost($voucher = null, string $contentType = self::contentTypes['apiV1VouchersPostMultipleVouchersPost'][0])
    {
        list($response) = $this->apiV1VouchersPostMultipleVouchersPostWithHttpInfo($voucher, $contentType);
        return $response;
    }

    /**
     * Operation apiV1VouchersPostMultipleVouchersPostWithHttpInfo
     *
     * Creates multiple new vouchers.
     *
     * @param  \Opsuite2\Model\Voucher[]|null $voucher (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersPostMultipleVouchersPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\PostResponseVoucher[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1VouchersPostMultipleVouchersPostWithHttpInfo($voucher = null, string $contentType = self::contentTypes['apiV1VouchersPostMultipleVouchersPost'][0])
    {
        $request = $this->apiV1VouchersPostMultipleVouchersPostRequest($voucher, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\PostResponseVoucher[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\PostResponseVoucher[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\PostResponseVoucher[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1VouchersPostMultipleVouchersPostAsync
     *
     * Creates multiple new vouchers.
     *
     * @param  \Opsuite2\Model\Voucher[]|null $voucher (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersPostMultipleVouchersPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1VouchersPostMultipleVouchersPostAsync($voucher = null, string $contentType = self::contentTypes['apiV1VouchersPostMultipleVouchersPost'][0])
    {
        return $this->apiV1VouchersPostMultipleVouchersPostAsyncWithHttpInfo($voucher, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1VouchersPostMultipleVouchersPostAsyncWithHttpInfo
     *
     * Creates multiple new vouchers.
     *
     * @param  \Opsuite2\Model\Voucher[]|null $voucher (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersPostMultipleVouchersPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1VouchersPostMultipleVouchersPostAsyncWithHttpInfo($voucher = null, string $contentType = self::contentTypes['apiV1VouchersPostMultipleVouchersPost'][0])
    {
        $returnType = '\Opsuite2\Model\PostResponseVoucher[]';
        $request = $this->apiV1VouchersPostMultipleVouchersPostRequest($voucher, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1VouchersPostMultipleVouchersPost'
     *
     * @param  \Opsuite2\Model\Voucher[]|null $voucher (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersPostMultipleVouchersPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1VouchersPostMultipleVouchersPostRequest($voucher = null, string $contentType = self::contentTypes['apiV1VouchersPostMultipleVouchersPost'][0])
    {



        $resourcePath = '/api/v1/Vouchers/PostMultipleVouchers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($voucher)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($voucher));
            } else {
                $httpBody = $voucher;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1VouchersPostVoucherNumbersPost
     *
     * Creates the specified number of new vouchers.
     *
     * @param  string|null $item_master_sku item_master_sku (optional)
     * @param  int|null $item_master_id item_master_id (optional)
     * @param  int|null $location_id location_id (optional)
     * @param  \DateTime|null $expiration_date expiration_date (optional)
     * @param  string[]|null $request_body request_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersPostVoucherNumbersPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\PostResponseVouchers|string
     */
    public function apiV1VouchersPostVoucherNumbersPost($item_master_sku = null, $item_master_id = null, $location_id = null, $expiration_date = null, $request_body = null, string $contentType = self::contentTypes['apiV1VouchersPostVoucherNumbersPost'][0])
    {
        list($response) = $this->apiV1VouchersPostVoucherNumbersPostWithHttpInfo($item_master_sku, $item_master_id, $location_id, $expiration_date, $request_body, $contentType);
        return $response;
    }

    /**
     * Operation apiV1VouchersPostVoucherNumbersPostWithHttpInfo
     *
     * Creates the specified number of new vouchers.
     *
     * @param  string|null $item_master_sku (optional)
     * @param  int|null $item_master_id (optional)
     * @param  int|null $location_id (optional)
     * @param  \DateTime|null $expiration_date (optional)
     * @param  string[]|null $request_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersPostVoucherNumbersPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\PostResponseVouchers|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1VouchersPostVoucherNumbersPostWithHttpInfo($item_master_sku = null, $item_master_id = null, $location_id = null, $expiration_date = null, $request_body = null, string $contentType = self::contentTypes['apiV1VouchersPostVoucherNumbersPost'][0])
    {
        $request = $this->apiV1VouchersPostVoucherNumbersPostRequest($item_master_sku, $item_master_id, $location_id, $expiration_date, $request_body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\PostResponseVouchers',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\PostResponseVouchers',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\PostResponseVouchers',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1VouchersPostVoucherNumbersPostAsync
     *
     * Creates the specified number of new vouchers.
     *
     * @param  string|null $item_master_sku (optional)
     * @param  int|null $item_master_id (optional)
     * @param  int|null $location_id (optional)
     * @param  \DateTime|null $expiration_date (optional)
     * @param  string[]|null $request_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersPostVoucherNumbersPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1VouchersPostVoucherNumbersPostAsync($item_master_sku = null, $item_master_id = null, $location_id = null, $expiration_date = null, $request_body = null, string $contentType = self::contentTypes['apiV1VouchersPostVoucherNumbersPost'][0])
    {
        return $this->apiV1VouchersPostVoucherNumbersPostAsyncWithHttpInfo($item_master_sku, $item_master_id, $location_id, $expiration_date, $request_body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1VouchersPostVoucherNumbersPostAsyncWithHttpInfo
     *
     * Creates the specified number of new vouchers.
     *
     * @param  string|null $item_master_sku (optional)
     * @param  int|null $item_master_id (optional)
     * @param  int|null $location_id (optional)
     * @param  \DateTime|null $expiration_date (optional)
     * @param  string[]|null $request_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersPostVoucherNumbersPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1VouchersPostVoucherNumbersPostAsyncWithHttpInfo($item_master_sku = null, $item_master_id = null, $location_id = null, $expiration_date = null, $request_body = null, string $contentType = self::contentTypes['apiV1VouchersPostVoucherNumbersPost'][0])
    {
        $returnType = '\Opsuite2\Model\PostResponseVouchers';
        $request = $this->apiV1VouchersPostVoucherNumbersPostRequest($item_master_sku, $item_master_id, $location_id, $expiration_date, $request_body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1VouchersPostVoucherNumbersPost'
     *
     * @param  string|null $item_master_sku (optional)
     * @param  int|null $item_master_id (optional)
     * @param  int|null $location_id (optional)
     * @param  \DateTime|null $expiration_date (optional)
     * @param  string[]|null $request_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersPostVoucherNumbersPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1VouchersPostVoucherNumbersPostRequest($item_master_sku = null, $item_master_id = null, $location_id = null, $expiration_date = null, $request_body = null, string $contentType = self::contentTypes['apiV1VouchersPostVoucherNumbersPost'][0])
    {







        $resourcePath = '/api/v1/Vouchers/PostVoucherNumbers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $item_master_sku,
            'itemMasterSku', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $item_master_id,
            'itemMasterId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $location_id,
            'locationId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $expiration_date,
            'expirationDate', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($request_body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($request_body));
            } else {
                $httpBody = $request_body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1VouchersPostVouchersPost
     *
     * Creates the specified number of new vouchers.
     *
     * @param  int|null $number number (optional)
     * @param  \Opsuite2\Model\Voucher|null $voucher voucher (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersPostVouchersPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\PostResponseVouchers|string
     */
    public function apiV1VouchersPostVouchersPost($number = null, $voucher = null, string $contentType = self::contentTypes['apiV1VouchersPostVouchersPost'][0])
    {
        list($response) = $this->apiV1VouchersPostVouchersPostWithHttpInfo($number, $voucher, $contentType);
        return $response;
    }

    /**
     * Operation apiV1VouchersPostVouchersPostWithHttpInfo
     *
     * Creates the specified number of new vouchers.
     *
     * @param  int|null $number (optional)
     * @param  \Opsuite2\Model\Voucher|null $voucher (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersPostVouchersPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\PostResponseVouchers|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1VouchersPostVouchersPostWithHttpInfo($number = null, $voucher = null, string $contentType = self::contentTypes['apiV1VouchersPostVouchersPost'][0])
    {
        $request = $this->apiV1VouchersPostVouchersPostRequest($number, $voucher, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\PostResponseVouchers',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\PostResponseVouchers',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\PostResponseVouchers',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1VouchersPostVouchersPostAsync
     *
     * Creates the specified number of new vouchers.
     *
     * @param  int|null $number (optional)
     * @param  \Opsuite2\Model\Voucher|null $voucher (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersPostVouchersPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1VouchersPostVouchersPostAsync($number = null, $voucher = null, string $contentType = self::contentTypes['apiV1VouchersPostVouchersPost'][0])
    {
        return $this->apiV1VouchersPostVouchersPostAsyncWithHttpInfo($number, $voucher, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1VouchersPostVouchersPostAsyncWithHttpInfo
     *
     * Creates the specified number of new vouchers.
     *
     * @param  int|null $number (optional)
     * @param  \Opsuite2\Model\Voucher|null $voucher (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersPostVouchersPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1VouchersPostVouchersPostAsyncWithHttpInfo($number = null, $voucher = null, string $contentType = self::contentTypes['apiV1VouchersPostVouchersPost'][0])
    {
        $returnType = '\Opsuite2\Model\PostResponseVouchers';
        $request = $this->apiV1VouchersPostVouchersPostRequest($number, $voucher, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1VouchersPostVouchersPost'
     *
     * @param  int|null $number (optional)
     * @param  \Opsuite2\Model\Voucher|null $voucher (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersPostVouchersPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1VouchersPostVouchersPostRequest($number = null, $voucher = null, string $contentType = self::contentTypes['apiV1VouchersPostVouchersPost'][0])
    {




        $resourcePath = '/api/v1/Vouchers/PostVouchers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $number,
            'number', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($voucher)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($voucher));
            } else {
                $httpBody = $voucher;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1VouchersVoucherIdPatch
     *
     * Updates specified properties of a voucher.
     *
     * @param  int $voucher_id voucher_id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersVoucherIdPatch'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function apiV1VouchersVoucherIdPatch($voucher_id, $patch = null, string $contentType = self::contentTypes['apiV1VouchersVoucherIdPatch'][0])
    {
        $this->apiV1VouchersVoucherIdPatchWithHttpInfo($voucher_id, $patch, $contentType);
    }

    /**
     * Operation apiV1VouchersVoucherIdPatchWithHttpInfo
     *
     * Updates specified properties of a voucher.
     *
     * @param  int $voucher_id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersVoucherIdPatch'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1VouchersVoucherIdPatchWithHttpInfo($voucher_id, $patch = null, string $contentType = self::contentTypes['apiV1VouchersVoucherIdPatch'][0])
    {
        $request = $this->apiV1VouchersVoucherIdPatchRequest($voucher_id, $patch, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1VouchersVoucherIdPatchAsync
     *
     * Updates specified properties of a voucher.
     *
     * @param  int $voucher_id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersVoucherIdPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1VouchersVoucherIdPatchAsync($voucher_id, $patch = null, string $contentType = self::contentTypes['apiV1VouchersVoucherIdPatch'][0])
    {
        return $this->apiV1VouchersVoucherIdPatchAsyncWithHttpInfo($voucher_id, $patch, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1VouchersVoucherIdPatchAsyncWithHttpInfo
     *
     * Updates specified properties of a voucher.
     *
     * @param  int $voucher_id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersVoucherIdPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1VouchersVoucherIdPatchAsyncWithHttpInfo($voucher_id, $patch = null, string $contentType = self::contentTypes['apiV1VouchersVoucherIdPatch'][0])
    {
        $returnType = '';
        $request = $this->apiV1VouchersVoucherIdPatchRequest($voucher_id, $patch, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1VouchersVoucherIdPatch'
     *
     * @param  int $voucher_id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1VouchersVoucherIdPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1VouchersVoucherIdPatchRequest($voucher_id, $patch = null, string $contentType = self::contentTypes['apiV1VouchersVoucherIdPatch'][0])
    {

        // verify the required parameter 'voucher_id' is set
        if ($voucher_id === null || (is_array($voucher_id) && count($voucher_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $voucher_id when calling apiV1VouchersVoucherIdPatch'
            );
        }
        if ($voucher_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$voucher_id" when calling VouchersApi.apiV1VouchersVoucherIdPatch, must be bigger than or equal to 1.');
        }
        


        $resourcePath = '/api/v1/Vouchers/{voucherId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($voucher_id !== null) {
            $resourcePath = str_replace(
                '{' . 'voucherId' . '}',
                ObjectSerializer::toPathValue($voucher_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($patch)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($patch));
            } else {
                $httpBody = $patch;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getVoucherById
     *
     * Returns a single Voucher with the specified id.
     *
     * @param  int $voucher_id voucher_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVoucherById'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\Voucher|string
     */
    public function getVoucherById($voucher_id, string $contentType = self::contentTypes['getVoucherById'][0])
    {
        list($response) = $this->getVoucherByIdWithHttpInfo($voucher_id, $contentType);
        return $response;
    }

    /**
     * Operation getVoucherByIdWithHttpInfo
     *
     * Returns a single Voucher with the specified id.
     *
     * @param  int $voucher_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVoucherById'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\Voucher|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getVoucherByIdWithHttpInfo($voucher_id, string $contentType = self::contentTypes['getVoucherById'][0])
    {
        $request = $this->getVoucherByIdRequest($voucher_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\Voucher',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\Voucher',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\Voucher',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getVoucherByIdAsync
     *
     * Returns a single Voucher with the specified id.
     *
     * @param  int $voucher_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVoucherById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getVoucherByIdAsync($voucher_id, string $contentType = self::contentTypes['getVoucherById'][0])
    {
        return $this->getVoucherByIdAsyncWithHttpInfo($voucher_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getVoucherByIdAsyncWithHttpInfo
     *
     * Returns a single Voucher with the specified id.
     *
     * @param  int $voucher_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVoucherById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getVoucherByIdAsyncWithHttpInfo($voucher_id, string $contentType = self::contentTypes['getVoucherById'][0])
    {
        $returnType = '\Opsuite2\Model\Voucher';
        $request = $this->getVoucherByIdRequest($voucher_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getVoucherById'
     *
     * @param  int $voucher_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVoucherById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getVoucherByIdRequest($voucher_id, string $contentType = self::contentTypes['getVoucherById'][0])
    {

        // verify the required parameter 'voucher_id' is set
        if ($voucher_id === null || (is_array($voucher_id) && count($voucher_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $voucher_id when calling getVoucherById'
            );
        }
        if ($voucher_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$voucher_id" when calling VouchersApi.getVoucherById, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v1/Vouchers/{voucherId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($voucher_id !== null) {
            $resourcePath = str_replace(
                '{' . 'voucherId' . '}',
                ObjectSerializer::toPathValue($voucher_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getVoucherByNumber
     *
     * Returns a single Voucher with the specified number.
     *
     * @param  string|null $number number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVoucherByNumber'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\Voucher|string
     */
    public function getVoucherByNumber($number = null, string $contentType = self::contentTypes['getVoucherByNumber'][0])
    {
        list($response) = $this->getVoucherByNumberWithHttpInfo($number, $contentType);
        return $response;
    }

    /**
     * Operation getVoucherByNumberWithHttpInfo
     *
     * Returns a single Voucher with the specified number.
     *
     * @param  string|null $number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVoucherByNumber'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\Voucher|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getVoucherByNumberWithHttpInfo($number = null, string $contentType = self::contentTypes['getVoucherByNumber'][0])
    {
        $request = $this->getVoucherByNumberRequest($number, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\Voucher',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\Voucher',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\Voucher',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getVoucherByNumberAsync
     *
     * Returns a single Voucher with the specified number.
     *
     * @param  string|null $number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVoucherByNumber'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getVoucherByNumberAsync($number = null, string $contentType = self::contentTypes['getVoucherByNumber'][0])
    {
        return $this->getVoucherByNumberAsyncWithHttpInfo($number, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getVoucherByNumberAsyncWithHttpInfo
     *
     * Returns a single Voucher with the specified number.
     *
     * @param  string|null $number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVoucherByNumber'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getVoucherByNumberAsyncWithHttpInfo($number = null, string $contentType = self::contentTypes['getVoucherByNumber'][0])
    {
        $returnType = '\Opsuite2\Model\Voucher';
        $request = $this->getVoucherByNumberRequest($number, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getVoucherByNumber'
     *
     * @param  string|null $number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVoucherByNumber'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getVoucherByNumberRequest($number = null, string $contentType = self::contentTypes['getVoucherByNumber'][0])
    {



        $resourcePath = '/api/v1/Vouchers/GetVoucherByNumber';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $number,
            'number', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
