<?php
/**
 * UnitsOfMeasureApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Opsuite2\ApiException;
use Opsuite2\Configuration;
use Opsuite2\FormDataProcessor;
use Opsuite2\HeaderSelector;
use Opsuite2\ObjectSerializer;

/**
 * UnitsOfMeasureApi Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class UnitsOfMeasureApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV1UnitsOfMeasureDefaultUomIdGet' => [
            'application/json',
        ],
        'apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGet' => [
            'application/json',
        ],
        'apiV1UnitsOfMeasureGetUomsByDescriptionGet' => [
            'application/json',
        ],
        'apiV1UnitsOfMeasurePost' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'apiV1UnitsOfMeasureUnitOfMeasureIdPatch' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'getUnitOfMeasureById' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV1UnitsOfMeasureDefaultUomIdGet
     *
     * Returns an integer which is the id of the default unit of measure.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1UnitsOfMeasureDefaultUomIdGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return int|string
     */
    public function apiV1UnitsOfMeasureDefaultUomIdGet(string $contentType = self::contentTypes['apiV1UnitsOfMeasureDefaultUomIdGet'][0])
    {
        list($response) = $this->apiV1UnitsOfMeasureDefaultUomIdGetWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation apiV1UnitsOfMeasureDefaultUomIdGetWithHttpInfo
     *
     * Returns an integer which is the id of the default unit of measure.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1UnitsOfMeasureDefaultUomIdGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of int|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1UnitsOfMeasureDefaultUomIdGetWithHttpInfo(string $contentType = self::contentTypes['apiV1UnitsOfMeasureDefaultUomIdGet'][0])
    {
        $request = $this->apiV1UnitsOfMeasureDefaultUomIdGetRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'int',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'int',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'int',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1UnitsOfMeasureDefaultUomIdGetAsync
     *
     * Returns an integer which is the id of the default unit of measure.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1UnitsOfMeasureDefaultUomIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1UnitsOfMeasureDefaultUomIdGetAsync(string $contentType = self::contentTypes['apiV1UnitsOfMeasureDefaultUomIdGet'][0])
    {
        return $this->apiV1UnitsOfMeasureDefaultUomIdGetAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1UnitsOfMeasureDefaultUomIdGetAsyncWithHttpInfo
     *
     * Returns an integer which is the id of the default unit of measure.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1UnitsOfMeasureDefaultUomIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1UnitsOfMeasureDefaultUomIdGetAsyncWithHttpInfo(string $contentType = self::contentTypes['apiV1UnitsOfMeasureDefaultUomIdGet'][0])
    {
        $returnType = 'int';
        $request = $this->apiV1UnitsOfMeasureDefaultUomIdGetRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1UnitsOfMeasureDefaultUomIdGet'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1UnitsOfMeasureDefaultUomIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1UnitsOfMeasureDefaultUomIdGetRequest(string $contentType = self::contentTypes['apiV1UnitsOfMeasureDefaultUomIdGet'][0])
    {


        $resourcePath = '/api/v1/UnitsOfMeasure/DefaultUomId';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGet
     *
     * Returns a single UnitOfMeasure with the specified code.
     *
     * @param  string|null $code code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\UnitOfMeasure|string
     */
    public function apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGet($code = null, string $contentType = self::contentTypes['apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGet'][0])
    {
        list($response) = $this->apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGetWithHttpInfo($code, $contentType);
        return $response;
    }

    /**
     * Operation apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGetWithHttpInfo
     *
     * Returns a single UnitOfMeasure with the specified code.
     *
     * @param  string|null $code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\UnitOfMeasure|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGetWithHttpInfo($code = null, string $contentType = self::contentTypes['apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGet'][0])
    {
        $request = $this->apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGetRequest($code, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\UnitOfMeasure',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\UnitOfMeasure',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\UnitOfMeasure',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGetAsync
     *
     * Returns a single UnitOfMeasure with the specified code.
     *
     * @param  string|null $code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGetAsync($code = null, string $contentType = self::contentTypes['apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGet'][0])
    {
        return $this->apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGetAsyncWithHttpInfo($code, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGetAsyncWithHttpInfo
     *
     * Returns a single UnitOfMeasure with the specified code.
     *
     * @param  string|null $code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGetAsyncWithHttpInfo($code = null, string $contentType = self::contentTypes['apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGet'][0])
    {
        $returnType = '\Opsuite2\Model\UnitOfMeasure';
        $request = $this->apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGetRequest($code, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGet'
     *
     * @param  string|null $code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGetRequest($code = null, string $contentType = self::contentTypes['apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGet'][0])
    {



        $resourcePath = '/api/v1/UnitsOfMeasure/GetUnitOfMeasureByCode';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $code,
            'code', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1UnitsOfMeasureGetUomsByDescriptionGet
     *
     * Returns an array of UnitOfMeasure with the specified description.
     *
     * @param  string|null $description description (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1UnitsOfMeasureGetUomsByDescriptionGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\UnitOfMeasure[]|string
     */
    public function apiV1UnitsOfMeasureGetUomsByDescriptionGet($description = null, string $contentType = self::contentTypes['apiV1UnitsOfMeasureGetUomsByDescriptionGet'][0])
    {
        list($response) = $this->apiV1UnitsOfMeasureGetUomsByDescriptionGetWithHttpInfo($description, $contentType);
        return $response;
    }

    /**
     * Operation apiV1UnitsOfMeasureGetUomsByDescriptionGetWithHttpInfo
     *
     * Returns an array of UnitOfMeasure with the specified description.
     *
     * @param  string|null $description (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1UnitsOfMeasureGetUomsByDescriptionGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\UnitOfMeasure[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1UnitsOfMeasureGetUomsByDescriptionGetWithHttpInfo($description = null, string $contentType = self::contentTypes['apiV1UnitsOfMeasureGetUomsByDescriptionGet'][0])
    {
        $request = $this->apiV1UnitsOfMeasureGetUomsByDescriptionGetRequest($description, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\UnitOfMeasure[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\UnitOfMeasure[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\UnitOfMeasure[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1UnitsOfMeasureGetUomsByDescriptionGetAsync
     *
     * Returns an array of UnitOfMeasure with the specified description.
     *
     * @param  string|null $description (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1UnitsOfMeasureGetUomsByDescriptionGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1UnitsOfMeasureGetUomsByDescriptionGetAsync($description = null, string $contentType = self::contentTypes['apiV1UnitsOfMeasureGetUomsByDescriptionGet'][0])
    {
        return $this->apiV1UnitsOfMeasureGetUomsByDescriptionGetAsyncWithHttpInfo($description, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1UnitsOfMeasureGetUomsByDescriptionGetAsyncWithHttpInfo
     *
     * Returns an array of UnitOfMeasure with the specified description.
     *
     * @param  string|null $description (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1UnitsOfMeasureGetUomsByDescriptionGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1UnitsOfMeasureGetUomsByDescriptionGetAsyncWithHttpInfo($description = null, string $contentType = self::contentTypes['apiV1UnitsOfMeasureGetUomsByDescriptionGet'][0])
    {
        $returnType = '\Opsuite2\Model\UnitOfMeasure[]';
        $request = $this->apiV1UnitsOfMeasureGetUomsByDescriptionGetRequest($description, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1UnitsOfMeasureGetUomsByDescriptionGet'
     *
     * @param  string|null $description (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1UnitsOfMeasureGetUomsByDescriptionGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1UnitsOfMeasureGetUomsByDescriptionGetRequest($description = null, string $contentType = self::contentTypes['apiV1UnitsOfMeasureGetUomsByDescriptionGet'][0])
    {



        $resourcePath = '/api/v1/UnitsOfMeasure/GetUomsByDescription';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $description,
            'description', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1UnitsOfMeasurePost
     *
     * Creates a new UnitOfMeasure.
     *
     * @param  \Opsuite2\Model\UnitOfMeasure|null $unit_of_measure unit_of_measure (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1UnitsOfMeasurePost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\UnitOfMeasure|string|string
     */
    public function apiV1UnitsOfMeasurePost($unit_of_measure = null, string $contentType = self::contentTypes['apiV1UnitsOfMeasurePost'][0])
    {
        list($response) = $this->apiV1UnitsOfMeasurePostWithHttpInfo($unit_of_measure, $contentType);
        return $response;
    }

    /**
     * Operation apiV1UnitsOfMeasurePostWithHttpInfo
     *
     * Creates a new UnitOfMeasure.
     *
     * @param  \Opsuite2\Model\UnitOfMeasure|null $unit_of_measure (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1UnitsOfMeasurePost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\UnitOfMeasure|string|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1UnitsOfMeasurePostWithHttpInfo($unit_of_measure = null, string $contentType = self::contentTypes['apiV1UnitsOfMeasurePost'][0])
    {
        $request = $this->apiV1UnitsOfMeasurePostRequest($unit_of_measure, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\UnitOfMeasure',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\UnitOfMeasure',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\UnitOfMeasure',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1UnitsOfMeasurePostAsync
     *
     * Creates a new UnitOfMeasure.
     *
     * @param  \Opsuite2\Model\UnitOfMeasure|null $unit_of_measure (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1UnitsOfMeasurePost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1UnitsOfMeasurePostAsync($unit_of_measure = null, string $contentType = self::contentTypes['apiV1UnitsOfMeasurePost'][0])
    {
        return $this->apiV1UnitsOfMeasurePostAsyncWithHttpInfo($unit_of_measure, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1UnitsOfMeasurePostAsyncWithHttpInfo
     *
     * Creates a new UnitOfMeasure.
     *
     * @param  \Opsuite2\Model\UnitOfMeasure|null $unit_of_measure (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1UnitsOfMeasurePost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1UnitsOfMeasurePostAsyncWithHttpInfo($unit_of_measure = null, string $contentType = self::contentTypes['apiV1UnitsOfMeasurePost'][0])
    {
        $returnType = '\Opsuite2\Model\UnitOfMeasure';
        $request = $this->apiV1UnitsOfMeasurePostRequest($unit_of_measure, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1UnitsOfMeasurePost'
     *
     * @param  \Opsuite2\Model\UnitOfMeasure|null $unit_of_measure (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1UnitsOfMeasurePost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1UnitsOfMeasurePostRequest($unit_of_measure = null, string $contentType = self::contentTypes['apiV1UnitsOfMeasurePost'][0])
    {



        $resourcePath = '/api/v1/UnitsOfMeasure';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($unit_of_measure)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($unit_of_measure));
            } else {
                $httpBody = $unit_of_measure;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1UnitsOfMeasureUnitOfMeasureIdPatch
     *
     * Updates specified properties of a UnitOfMeasure.
     *
     * @param  int $unit_of_measure_id unit_of_measure_id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1UnitsOfMeasureUnitOfMeasureIdPatch'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function apiV1UnitsOfMeasureUnitOfMeasureIdPatch($unit_of_measure_id, $patch = null, string $contentType = self::contentTypes['apiV1UnitsOfMeasureUnitOfMeasureIdPatch'][0])
    {
        $this->apiV1UnitsOfMeasureUnitOfMeasureIdPatchWithHttpInfo($unit_of_measure_id, $patch, $contentType);
    }

    /**
     * Operation apiV1UnitsOfMeasureUnitOfMeasureIdPatchWithHttpInfo
     *
     * Updates specified properties of a UnitOfMeasure.
     *
     * @param  int $unit_of_measure_id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1UnitsOfMeasureUnitOfMeasureIdPatch'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1UnitsOfMeasureUnitOfMeasureIdPatchWithHttpInfo($unit_of_measure_id, $patch = null, string $contentType = self::contentTypes['apiV1UnitsOfMeasureUnitOfMeasureIdPatch'][0])
    {
        $request = $this->apiV1UnitsOfMeasureUnitOfMeasureIdPatchRequest($unit_of_measure_id, $patch, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1UnitsOfMeasureUnitOfMeasureIdPatchAsync
     *
     * Updates specified properties of a UnitOfMeasure.
     *
     * @param  int $unit_of_measure_id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1UnitsOfMeasureUnitOfMeasureIdPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1UnitsOfMeasureUnitOfMeasureIdPatchAsync($unit_of_measure_id, $patch = null, string $contentType = self::contentTypes['apiV1UnitsOfMeasureUnitOfMeasureIdPatch'][0])
    {
        return $this->apiV1UnitsOfMeasureUnitOfMeasureIdPatchAsyncWithHttpInfo($unit_of_measure_id, $patch, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1UnitsOfMeasureUnitOfMeasureIdPatchAsyncWithHttpInfo
     *
     * Updates specified properties of a UnitOfMeasure.
     *
     * @param  int $unit_of_measure_id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1UnitsOfMeasureUnitOfMeasureIdPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1UnitsOfMeasureUnitOfMeasureIdPatchAsyncWithHttpInfo($unit_of_measure_id, $patch = null, string $contentType = self::contentTypes['apiV1UnitsOfMeasureUnitOfMeasureIdPatch'][0])
    {
        $returnType = '';
        $request = $this->apiV1UnitsOfMeasureUnitOfMeasureIdPatchRequest($unit_of_measure_id, $patch, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1UnitsOfMeasureUnitOfMeasureIdPatch'
     *
     * @param  int $unit_of_measure_id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1UnitsOfMeasureUnitOfMeasureIdPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1UnitsOfMeasureUnitOfMeasureIdPatchRequest($unit_of_measure_id, $patch = null, string $contentType = self::contentTypes['apiV1UnitsOfMeasureUnitOfMeasureIdPatch'][0])
    {

        // verify the required parameter 'unit_of_measure_id' is set
        if ($unit_of_measure_id === null || (is_array($unit_of_measure_id) && count($unit_of_measure_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $unit_of_measure_id when calling apiV1UnitsOfMeasureUnitOfMeasureIdPatch'
            );
        }
        if ($unit_of_measure_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$unit_of_measure_id" when calling UnitsOfMeasureApi.apiV1UnitsOfMeasureUnitOfMeasureIdPatch, must be bigger than or equal to 1.');
        }
        


        $resourcePath = '/api/v1/UnitsOfMeasure/{unitOfMeasureId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($unit_of_measure_id !== null) {
            $resourcePath = str_replace(
                '{' . 'unitOfMeasureId' . '}',
                ObjectSerializer::toPathValue($unit_of_measure_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($patch)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($patch));
            } else {
                $httpBody = $patch;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getUnitOfMeasureById
     *
     * Returns a single UnitOfMeasure with the specified id.
     *
     * @param  int $unit_of_measure_id unit_of_measure_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getUnitOfMeasureById'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\UnitOfMeasure|string
     */
    public function getUnitOfMeasureById($unit_of_measure_id, string $contentType = self::contentTypes['getUnitOfMeasureById'][0])
    {
        list($response) = $this->getUnitOfMeasureByIdWithHttpInfo($unit_of_measure_id, $contentType);
        return $response;
    }

    /**
     * Operation getUnitOfMeasureByIdWithHttpInfo
     *
     * Returns a single UnitOfMeasure with the specified id.
     *
     * @param  int $unit_of_measure_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getUnitOfMeasureById'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\UnitOfMeasure|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getUnitOfMeasureByIdWithHttpInfo($unit_of_measure_id, string $contentType = self::contentTypes['getUnitOfMeasureById'][0])
    {
        $request = $this->getUnitOfMeasureByIdRequest($unit_of_measure_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\UnitOfMeasure',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\UnitOfMeasure',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\UnitOfMeasure',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getUnitOfMeasureByIdAsync
     *
     * Returns a single UnitOfMeasure with the specified id.
     *
     * @param  int $unit_of_measure_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getUnitOfMeasureById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getUnitOfMeasureByIdAsync($unit_of_measure_id, string $contentType = self::contentTypes['getUnitOfMeasureById'][0])
    {
        return $this->getUnitOfMeasureByIdAsyncWithHttpInfo($unit_of_measure_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getUnitOfMeasureByIdAsyncWithHttpInfo
     *
     * Returns a single UnitOfMeasure with the specified id.
     *
     * @param  int $unit_of_measure_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getUnitOfMeasureById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getUnitOfMeasureByIdAsyncWithHttpInfo($unit_of_measure_id, string $contentType = self::contentTypes['getUnitOfMeasureById'][0])
    {
        $returnType = '\Opsuite2\Model\UnitOfMeasure';
        $request = $this->getUnitOfMeasureByIdRequest($unit_of_measure_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getUnitOfMeasureById'
     *
     * @param  int $unit_of_measure_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getUnitOfMeasureById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getUnitOfMeasureByIdRequest($unit_of_measure_id, string $contentType = self::contentTypes['getUnitOfMeasureById'][0])
    {

        // verify the required parameter 'unit_of_measure_id' is set
        if ($unit_of_measure_id === null || (is_array($unit_of_measure_id) && count($unit_of_measure_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $unit_of_measure_id when calling getUnitOfMeasureById'
            );
        }
        if ($unit_of_measure_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$unit_of_measure_id" when calling UnitsOfMeasureApi.getUnitOfMeasureById, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v1/UnitsOfMeasure/{unitOfMeasureId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($unit_of_measure_id !== null) {
            $resourcePath = str_replace(
                '{' . 'unitOfMeasureId' . '}',
                ObjectSerializer::toPathValue($unit_of_measure_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
