<?php
/**
 * TransferDetailsApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Opsuite2\ApiException;
use Opsuite2\Configuration;
use Opsuite2\FormDataProcessor;
use Opsuite2\HeaderSelector;
use Opsuite2\ObjectSerializer;

/**
 * TransferDetailsApi Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class TransferDetailsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV1TransferDetailsGetTransferDetailsByOrderNumberGet' => [
            'application/json',
        ],
        'apiV1TransferDetailsGetTransferDetailsGet' => [
            'application/json',
        ],
        'apiV1TransferDetailsIssueTransferPost' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'getTransferDetailsById' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV1TransferDetailsGetTransferDetailsByOrderNumberGet
     *
     * Returns a TransferDetails for a given inventory control document order number.
     *
     * @param  string|null $order_number order_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransferDetailsGetTransferDetailsByOrderNumberGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\TransferDetails|string
     */
    public function apiV1TransferDetailsGetTransferDetailsByOrderNumberGet($order_number = null, string $contentType = self::contentTypes['apiV1TransferDetailsGetTransferDetailsByOrderNumberGet'][0])
    {
        list($response) = $this->apiV1TransferDetailsGetTransferDetailsByOrderNumberGetWithHttpInfo($order_number, $contentType);
        return $response;
    }

    /**
     * Operation apiV1TransferDetailsGetTransferDetailsByOrderNumberGetWithHttpInfo
     *
     * Returns a TransferDetails for a given inventory control document order number.
     *
     * @param  string|null $order_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransferDetailsGetTransferDetailsByOrderNumberGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\TransferDetails|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1TransferDetailsGetTransferDetailsByOrderNumberGetWithHttpInfo($order_number = null, string $contentType = self::contentTypes['apiV1TransferDetailsGetTransferDetailsByOrderNumberGet'][0])
    {
        $request = $this->apiV1TransferDetailsGetTransferDetailsByOrderNumberGetRequest($order_number, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\TransferDetails',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\TransferDetails',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\TransferDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1TransferDetailsGetTransferDetailsByOrderNumberGetAsync
     *
     * Returns a TransferDetails for a given inventory control document order number.
     *
     * @param  string|null $order_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransferDetailsGetTransferDetailsByOrderNumberGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1TransferDetailsGetTransferDetailsByOrderNumberGetAsync($order_number = null, string $contentType = self::contentTypes['apiV1TransferDetailsGetTransferDetailsByOrderNumberGet'][0])
    {
        return $this->apiV1TransferDetailsGetTransferDetailsByOrderNumberGetAsyncWithHttpInfo($order_number, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1TransferDetailsGetTransferDetailsByOrderNumberGetAsyncWithHttpInfo
     *
     * Returns a TransferDetails for a given inventory control document order number.
     *
     * @param  string|null $order_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransferDetailsGetTransferDetailsByOrderNumberGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1TransferDetailsGetTransferDetailsByOrderNumberGetAsyncWithHttpInfo($order_number = null, string $contentType = self::contentTypes['apiV1TransferDetailsGetTransferDetailsByOrderNumberGet'][0])
    {
        $returnType = '\Opsuite2\Model\TransferDetails';
        $request = $this->apiV1TransferDetailsGetTransferDetailsByOrderNumberGetRequest($order_number, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1TransferDetailsGetTransferDetailsByOrderNumberGet'
     *
     * @param  string|null $order_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransferDetailsGetTransferDetailsByOrderNumberGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1TransferDetailsGetTransferDetailsByOrderNumberGetRequest($order_number = null, string $contentType = self::contentTypes['apiV1TransferDetailsGetTransferDetailsByOrderNumberGet'][0])
    {



        $resourcePath = '/api/v1/TransferDetails/GetTransferDetailsByOrderNumber';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_number,
            'orderNumber', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1TransferDetailsGetTransferDetailsGet
     *
     * Returns an array of TransferDetails that match the specified search criteria.
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  \DateTime|null $date_created_date_range_start date_created_date_range_start (optional)
     * @param  \DateTime|null $date_created_date_range_end date_created_date_range_end (optional)
     * @param  \DateTime|null $date_placed_date_range_start date_placed_date_range_start (optional)
     * @param  \DateTime|null $date_placed_date_range_end date_placed_date_range_end (optional)
     * @param  \DateTime|null $last_updated_date_range_start last_updated_date_range_start (optional)
     * @param  \DateTime|null $last_updated_date_range_end last_updated_date_range_end (optional)
     * @param  int|null $transfer_type transfer_type (optional)
     * @param  int|null $location_id location_id (optional)
     * @param  string|null $transfer_status transfer_status (optional)
     * @param  int|null $source_location_id source_location_id (optional)
     * @param  int|null $destination_location_id destination_location_id (optional)
     * @param  string|null $order_number order_number (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_number_search_operator order_number_search_operator (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransferDetailsGetTransferDetailsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\TransferDetails[]|string
     */
    public function apiV1TransferDetailsGetTransferDetailsGet($page_number = null, $page_size = null, $date_created_date_range_start = null, $date_created_date_range_end = null, $date_placed_date_range_start = null, $date_placed_date_range_end = null, $last_updated_date_range_start = null, $last_updated_date_range_end = null, $transfer_type = null, $location_id = null, $transfer_status = null, $source_location_id = null, $destination_location_id = null, $order_number = null, $order_number_search_operator = null, string $contentType = self::contentTypes['apiV1TransferDetailsGetTransferDetailsGet'][0])
    {
        list($response) = $this->apiV1TransferDetailsGetTransferDetailsGetWithHttpInfo($page_number, $page_size, $date_created_date_range_start, $date_created_date_range_end, $date_placed_date_range_start, $date_placed_date_range_end, $last_updated_date_range_start, $last_updated_date_range_end, $transfer_type, $location_id, $transfer_status, $source_location_id, $destination_location_id, $order_number, $order_number_search_operator, $contentType);
        return $response;
    }

    /**
     * Operation apiV1TransferDetailsGetTransferDetailsGetWithHttpInfo
     *
     * Returns an array of TransferDetails that match the specified search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $date_created_date_range_start (optional)
     * @param  \DateTime|null $date_created_date_range_end (optional)
     * @param  \DateTime|null $date_placed_date_range_start (optional)
     * @param  \DateTime|null $date_placed_date_range_end (optional)
     * @param  \DateTime|null $last_updated_date_range_start (optional)
     * @param  \DateTime|null $last_updated_date_range_end (optional)
     * @param  int|null $transfer_type (optional)
     * @param  int|null $location_id (optional)
     * @param  string|null $transfer_status (optional)
     * @param  int|null $source_location_id (optional)
     * @param  int|null $destination_location_id (optional)
     * @param  string|null $order_number (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_number_search_operator (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransferDetailsGetTransferDetailsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\TransferDetails[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1TransferDetailsGetTransferDetailsGetWithHttpInfo($page_number = null, $page_size = null, $date_created_date_range_start = null, $date_created_date_range_end = null, $date_placed_date_range_start = null, $date_placed_date_range_end = null, $last_updated_date_range_start = null, $last_updated_date_range_end = null, $transfer_type = null, $location_id = null, $transfer_status = null, $source_location_id = null, $destination_location_id = null, $order_number = null, $order_number_search_operator = null, string $contentType = self::contentTypes['apiV1TransferDetailsGetTransferDetailsGet'][0])
    {
        $request = $this->apiV1TransferDetailsGetTransferDetailsGetRequest($page_number, $page_size, $date_created_date_range_start, $date_created_date_range_end, $date_placed_date_range_start, $date_placed_date_range_end, $last_updated_date_range_start, $last_updated_date_range_end, $transfer_type, $location_id, $transfer_status, $source_location_id, $destination_location_id, $order_number, $order_number_search_operator, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\TransferDetails[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\TransferDetails[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\TransferDetails[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1TransferDetailsGetTransferDetailsGetAsync
     *
     * Returns an array of TransferDetails that match the specified search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $date_created_date_range_start (optional)
     * @param  \DateTime|null $date_created_date_range_end (optional)
     * @param  \DateTime|null $date_placed_date_range_start (optional)
     * @param  \DateTime|null $date_placed_date_range_end (optional)
     * @param  \DateTime|null $last_updated_date_range_start (optional)
     * @param  \DateTime|null $last_updated_date_range_end (optional)
     * @param  int|null $transfer_type (optional)
     * @param  int|null $location_id (optional)
     * @param  string|null $transfer_status (optional)
     * @param  int|null $source_location_id (optional)
     * @param  int|null $destination_location_id (optional)
     * @param  string|null $order_number (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_number_search_operator (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransferDetailsGetTransferDetailsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1TransferDetailsGetTransferDetailsGetAsync($page_number = null, $page_size = null, $date_created_date_range_start = null, $date_created_date_range_end = null, $date_placed_date_range_start = null, $date_placed_date_range_end = null, $last_updated_date_range_start = null, $last_updated_date_range_end = null, $transfer_type = null, $location_id = null, $transfer_status = null, $source_location_id = null, $destination_location_id = null, $order_number = null, $order_number_search_operator = null, string $contentType = self::contentTypes['apiV1TransferDetailsGetTransferDetailsGet'][0])
    {
        return $this->apiV1TransferDetailsGetTransferDetailsGetAsyncWithHttpInfo($page_number, $page_size, $date_created_date_range_start, $date_created_date_range_end, $date_placed_date_range_start, $date_placed_date_range_end, $last_updated_date_range_start, $last_updated_date_range_end, $transfer_type, $location_id, $transfer_status, $source_location_id, $destination_location_id, $order_number, $order_number_search_operator, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1TransferDetailsGetTransferDetailsGetAsyncWithHttpInfo
     *
     * Returns an array of TransferDetails that match the specified search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $date_created_date_range_start (optional)
     * @param  \DateTime|null $date_created_date_range_end (optional)
     * @param  \DateTime|null $date_placed_date_range_start (optional)
     * @param  \DateTime|null $date_placed_date_range_end (optional)
     * @param  \DateTime|null $last_updated_date_range_start (optional)
     * @param  \DateTime|null $last_updated_date_range_end (optional)
     * @param  int|null $transfer_type (optional)
     * @param  int|null $location_id (optional)
     * @param  string|null $transfer_status (optional)
     * @param  int|null $source_location_id (optional)
     * @param  int|null $destination_location_id (optional)
     * @param  string|null $order_number (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_number_search_operator (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransferDetailsGetTransferDetailsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1TransferDetailsGetTransferDetailsGetAsyncWithHttpInfo($page_number = null, $page_size = null, $date_created_date_range_start = null, $date_created_date_range_end = null, $date_placed_date_range_start = null, $date_placed_date_range_end = null, $last_updated_date_range_start = null, $last_updated_date_range_end = null, $transfer_type = null, $location_id = null, $transfer_status = null, $source_location_id = null, $destination_location_id = null, $order_number = null, $order_number_search_operator = null, string $contentType = self::contentTypes['apiV1TransferDetailsGetTransferDetailsGet'][0])
    {
        $returnType = '\Opsuite2\Model\TransferDetails[]';
        $request = $this->apiV1TransferDetailsGetTransferDetailsGetRequest($page_number, $page_size, $date_created_date_range_start, $date_created_date_range_end, $date_placed_date_range_start, $date_placed_date_range_end, $last_updated_date_range_start, $last_updated_date_range_end, $transfer_type, $location_id, $transfer_status, $source_location_id, $destination_location_id, $order_number, $order_number_search_operator, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1TransferDetailsGetTransferDetailsGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $date_created_date_range_start (optional)
     * @param  \DateTime|null $date_created_date_range_end (optional)
     * @param  \DateTime|null $date_placed_date_range_start (optional)
     * @param  \DateTime|null $date_placed_date_range_end (optional)
     * @param  \DateTime|null $last_updated_date_range_start (optional)
     * @param  \DateTime|null $last_updated_date_range_end (optional)
     * @param  int|null $transfer_type (optional)
     * @param  int|null $location_id (optional)
     * @param  string|null $transfer_status (optional)
     * @param  int|null $source_location_id (optional)
     * @param  int|null $destination_location_id (optional)
     * @param  string|null $order_number (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_number_search_operator (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransferDetailsGetTransferDetailsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1TransferDetailsGetTransferDetailsGetRequest($page_number = null, $page_size = null, $date_created_date_range_start = null, $date_created_date_range_end = null, $date_placed_date_range_start = null, $date_placed_date_range_end = null, $last_updated_date_range_start = null, $last_updated_date_range_end = null, $transfer_type = null, $location_id = null, $transfer_status = null, $source_location_id = null, $destination_location_id = null, $order_number = null, $order_number_search_operator = null, string $contentType = self::contentTypes['apiV1TransferDetailsGetTransferDetailsGet'][0])
    {

















        $resourcePath = '/api/v1/TransferDetails/GetTransferDetails';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_created_date_range_start,
            'DateCreatedDateRangeStart', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_created_date_range_end,
            'DateCreatedDateRangeEnd', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_placed_date_range_start,
            'DatePlacedDateRangeStart', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_placed_date_range_end,
            'DatePlacedDateRangeEnd', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $last_updated_date_range_start,
            'LastUpdatedDateRangeStart', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $last_updated_date_range_end,
            'LastUpdatedDateRangeEnd', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $transfer_type,
            'TransferType', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $location_id,
            'LocationId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $transfer_status,
            'TransferStatus', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $source_location_id,
            'SourceLocationId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $destination_location_id,
            'DestinationLocationId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_number,
            'OrderNumber', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_number_search_operator,
            'OrderNumberSearchOperator', // param base name
            'SimpleSearchOperatorEnum', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1TransferDetailsIssueTransferPost
     *
     * Issues a transfer
     *
     * @param  \Opsuite2\Model\TransferDetailsUpdate|null $transfer_details_update transfer_details_update (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransferDetailsIssueTransferPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\TransferDetailsUpdate|string
     */
    public function apiV1TransferDetailsIssueTransferPost($transfer_details_update = null, string $contentType = self::contentTypes['apiV1TransferDetailsIssueTransferPost'][0])
    {
        list($response) = $this->apiV1TransferDetailsIssueTransferPostWithHttpInfo($transfer_details_update, $contentType);
        return $response;
    }

    /**
     * Operation apiV1TransferDetailsIssueTransferPostWithHttpInfo
     *
     * Issues a transfer
     *
     * @param  \Opsuite2\Model\TransferDetailsUpdate|null $transfer_details_update (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransferDetailsIssueTransferPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\TransferDetailsUpdate|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1TransferDetailsIssueTransferPostWithHttpInfo($transfer_details_update = null, string $contentType = self::contentTypes['apiV1TransferDetailsIssueTransferPost'][0])
    {
        $request = $this->apiV1TransferDetailsIssueTransferPostRequest($transfer_details_update, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\TransferDetailsUpdate',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\TransferDetailsUpdate',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\TransferDetailsUpdate',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1TransferDetailsIssueTransferPostAsync
     *
     * Issues a transfer
     *
     * @param  \Opsuite2\Model\TransferDetailsUpdate|null $transfer_details_update (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransferDetailsIssueTransferPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1TransferDetailsIssueTransferPostAsync($transfer_details_update = null, string $contentType = self::contentTypes['apiV1TransferDetailsIssueTransferPost'][0])
    {
        return $this->apiV1TransferDetailsIssueTransferPostAsyncWithHttpInfo($transfer_details_update, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1TransferDetailsIssueTransferPostAsyncWithHttpInfo
     *
     * Issues a transfer
     *
     * @param  \Opsuite2\Model\TransferDetailsUpdate|null $transfer_details_update (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransferDetailsIssueTransferPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1TransferDetailsIssueTransferPostAsyncWithHttpInfo($transfer_details_update = null, string $contentType = self::contentTypes['apiV1TransferDetailsIssueTransferPost'][0])
    {
        $returnType = '\Opsuite2\Model\TransferDetailsUpdate';
        $request = $this->apiV1TransferDetailsIssueTransferPostRequest($transfer_details_update, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1TransferDetailsIssueTransferPost'
     *
     * @param  \Opsuite2\Model\TransferDetailsUpdate|null $transfer_details_update (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransferDetailsIssueTransferPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1TransferDetailsIssueTransferPostRequest($transfer_details_update = null, string $contentType = self::contentTypes['apiV1TransferDetailsIssueTransferPost'][0])
    {



        $resourcePath = '/api/v1/TransferDetails/IssueTransfer';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($transfer_details_update)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($transfer_details_update));
            } else {
                $httpBody = $transfer_details_update;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getTransferDetailsById
     *
     * Returns a TransferDetails for a given inventory control document id.
     *
     * @param  int $inventory_control_document_id inventory_control_document_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTransferDetailsById'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\TransferDetails|string
     */
    public function getTransferDetailsById($inventory_control_document_id, string $contentType = self::contentTypes['getTransferDetailsById'][0])
    {
        list($response) = $this->getTransferDetailsByIdWithHttpInfo($inventory_control_document_id, $contentType);
        return $response;
    }

    /**
     * Operation getTransferDetailsByIdWithHttpInfo
     *
     * Returns a TransferDetails for a given inventory control document id.
     *
     * @param  int $inventory_control_document_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTransferDetailsById'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\TransferDetails|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTransferDetailsByIdWithHttpInfo($inventory_control_document_id, string $contentType = self::contentTypes['getTransferDetailsById'][0])
    {
        $request = $this->getTransferDetailsByIdRequest($inventory_control_document_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\TransferDetails',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\TransferDetails',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\TransferDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getTransferDetailsByIdAsync
     *
     * Returns a TransferDetails for a given inventory control document id.
     *
     * @param  int $inventory_control_document_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTransferDetailsById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTransferDetailsByIdAsync($inventory_control_document_id, string $contentType = self::contentTypes['getTransferDetailsById'][0])
    {
        return $this->getTransferDetailsByIdAsyncWithHttpInfo($inventory_control_document_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getTransferDetailsByIdAsyncWithHttpInfo
     *
     * Returns a TransferDetails for a given inventory control document id.
     *
     * @param  int $inventory_control_document_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTransferDetailsById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTransferDetailsByIdAsyncWithHttpInfo($inventory_control_document_id, string $contentType = self::contentTypes['getTransferDetailsById'][0])
    {
        $returnType = '\Opsuite2\Model\TransferDetails';
        $request = $this->getTransferDetailsByIdRequest($inventory_control_document_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getTransferDetailsById'
     *
     * @param  int $inventory_control_document_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTransferDetailsById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getTransferDetailsByIdRequest($inventory_control_document_id, string $contentType = self::contentTypes['getTransferDetailsById'][0])
    {

        // verify the required parameter 'inventory_control_document_id' is set
        if ($inventory_control_document_id === null || (is_array($inventory_control_document_id) && count($inventory_control_document_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_control_document_id when calling getTransferDetailsById'
            );
        }
        if ($inventory_control_document_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$inventory_control_document_id" when calling TransferDetailsApi.getTransferDetailsById, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v1/TransferDetails/{inventoryControlDocumentId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($inventory_control_document_id !== null) {
            $resourcePath = str_replace(
                '{' . 'inventoryControlDocumentId' . '}',
                ObjectSerializer::toPathValue($inventory_control_document_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
