<?php
/**
 * TransactionsApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Opsuite2\ApiException;
use Opsuite2\Configuration;
use Opsuite2\FormDataProcessor;
use Opsuite2\HeaderSelector;
use Opsuite2\ObjectSerializer;

/**
 * TransactionsApi Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class TransactionsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV1TransactionsGetTransactionsGet' => [
            'application/json',
        ],
        'apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGet' => [
            'application/json',
        ],
        'apiV1TransactionsPost' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'apiV1TransactionsRefundTransactionPost' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'apiV2TransactionsGetTransactionsGet' => [
            'application/json',
        ],
        'getTransactionById' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV1TransactionsGetTransactionsGet
     *
     * Returns an array of Transactions based on the supplied search criteria.
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  int|null $customer_id customer_id (optional)
     * @param  int|null $recall_id recall_id (optional)
     * @param  string|null $receipt_number receipt_number (optional)
     * @param  string|null $order_reference order_reference (optional)
     * @param  string|null $transaction_reference transaction_reference (optional)
     * @param  \DateTime|null $date_range_start date_range_start (optional)
     * @param  \DateTime|null $date_range_end date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransactionsGetTransactionsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\RetailTransaction[]|string
     * @deprecated
     */
    public function apiV1TransactionsGetTransactionsGet($page_number = null, $page_size = null, $customer_id = null, $recall_id = null, $receipt_number = null, $order_reference = null, $transaction_reference = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV1TransactionsGetTransactionsGet'][0])
    {
        list($response) = $this->apiV1TransactionsGetTransactionsGetWithHttpInfo($page_number, $page_size, $customer_id, $recall_id, $receipt_number, $order_reference, $transaction_reference, $date_range_start, $date_range_end, $contentType);
        return $response;
    }

    /**
     * Operation apiV1TransactionsGetTransactionsGetWithHttpInfo
     *
     * Returns an array of Transactions based on the supplied search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $customer_id (optional)
     * @param  int|null $recall_id (optional)
     * @param  string|null $receipt_number (optional)
     * @param  string|null $order_reference (optional)
     * @param  string|null $transaction_reference (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransactionsGetTransactionsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\RetailTransaction[]|string, HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function apiV1TransactionsGetTransactionsGetWithHttpInfo($page_number = null, $page_size = null, $customer_id = null, $recall_id = null, $receipt_number = null, $order_reference = null, $transaction_reference = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV1TransactionsGetTransactionsGet'][0])
    {
        $request = $this->apiV1TransactionsGetTransactionsGetRequest($page_number, $page_size, $customer_id, $recall_id, $receipt_number, $order_reference, $transaction_reference, $date_range_start, $date_range_end, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\RetailTransaction[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\RetailTransaction[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\RetailTransaction[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1TransactionsGetTransactionsGetAsync
     *
     * Returns an array of Transactions based on the supplied search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $customer_id (optional)
     * @param  int|null $recall_id (optional)
     * @param  string|null $receipt_number (optional)
     * @param  string|null $order_reference (optional)
     * @param  string|null $transaction_reference (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransactionsGetTransactionsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function apiV1TransactionsGetTransactionsGetAsync($page_number = null, $page_size = null, $customer_id = null, $recall_id = null, $receipt_number = null, $order_reference = null, $transaction_reference = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV1TransactionsGetTransactionsGet'][0])
    {
        return $this->apiV1TransactionsGetTransactionsGetAsyncWithHttpInfo($page_number, $page_size, $customer_id, $recall_id, $receipt_number, $order_reference, $transaction_reference, $date_range_start, $date_range_end, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1TransactionsGetTransactionsGetAsyncWithHttpInfo
     *
     * Returns an array of Transactions based on the supplied search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $customer_id (optional)
     * @param  int|null $recall_id (optional)
     * @param  string|null $receipt_number (optional)
     * @param  string|null $order_reference (optional)
     * @param  string|null $transaction_reference (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransactionsGetTransactionsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function apiV1TransactionsGetTransactionsGetAsyncWithHttpInfo($page_number = null, $page_size = null, $customer_id = null, $recall_id = null, $receipt_number = null, $order_reference = null, $transaction_reference = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV1TransactionsGetTransactionsGet'][0])
    {
        $returnType = '\Opsuite2\Model\RetailTransaction[]';
        $request = $this->apiV1TransactionsGetTransactionsGetRequest($page_number, $page_size, $customer_id, $recall_id, $receipt_number, $order_reference, $transaction_reference, $date_range_start, $date_range_end, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1TransactionsGetTransactionsGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $customer_id (optional)
     * @param  int|null $recall_id (optional)
     * @param  string|null $receipt_number (optional)
     * @param  string|null $order_reference (optional)
     * @param  string|null $transaction_reference (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransactionsGetTransactionsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function apiV1TransactionsGetTransactionsGetRequest($page_number = null, $page_size = null, $customer_id = null, $recall_id = null, $receipt_number = null, $order_reference = null, $transaction_reference = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV1TransactionsGetTransactionsGet'][0])
    {











        $resourcePath = '/api/v1/Transactions/GetTransactions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $customer_id,
            'CustomerId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $recall_id,
            'RecallId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $receipt_number,
            'ReceiptNumber', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_reference,
            'OrderReference', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $transaction_reference,
            'TransactionReference', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_range_start,
            'DateRangeStart', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_range_end,
            'DateRangeEnd', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGet
     *
     * Returns an array of Transactions with an id greater than the specified id.
     *
     * @param  int|null $specified_id specified_id (optional)
     * @param  int|null $batch_size batch_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\RetailTransaction[]|string
     */
    public function apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGet($specified_id = null, $batch_size = null, string $contentType = self::contentTypes['apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGet'][0])
    {
        list($response) = $this->apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGetWithHttpInfo($specified_id, $batch_size, $contentType);
        return $response;
    }

    /**
     * Operation apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGetWithHttpInfo
     *
     * Returns an array of Transactions with an id greater than the specified id.
     *
     * @param  int|null $specified_id (optional)
     * @param  int|null $batch_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\RetailTransaction[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGetWithHttpInfo($specified_id = null, $batch_size = null, string $contentType = self::contentTypes['apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGet'][0])
    {
        $request = $this->apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGetRequest($specified_id, $batch_size, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\RetailTransaction[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\RetailTransaction[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\RetailTransaction[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGetAsync
     *
     * Returns an array of Transactions with an id greater than the specified id.
     *
     * @param  int|null $specified_id (optional)
     * @param  int|null $batch_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGetAsync($specified_id = null, $batch_size = null, string $contentType = self::contentTypes['apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGet'][0])
    {
        return $this->apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGetAsyncWithHttpInfo($specified_id, $batch_size, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGetAsyncWithHttpInfo
     *
     * Returns an array of Transactions with an id greater than the specified id.
     *
     * @param  int|null $specified_id (optional)
     * @param  int|null $batch_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGetAsyncWithHttpInfo($specified_id = null, $batch_size = null, string $contentType = self::contentTypes['apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGet'][0])
    {
        $returnType = '\Opsuite2\Model\RetailTransaction[]';
        $request = $this->apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGetRequest($specified_id, $batch_size, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGet'
     *
     * @param  int|null $specified_id (optional)
     * @param  int|null $batch_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGetRequest($specified_id = null, $batch_size = null, string $contentType = self::contentTypes['apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGet'][0])
    {




        $resourcePath = '/api/v1/Transactions/GetTransactionsWithIdGreaterThanSpecifiedId';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $specified_id,
            'specifiedId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $batch_size,
            'batchSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1TransactionsPost
     *
     * Creates a new transaction.
     *
     * @param  \Opsuite2\Model\RetailTransaction|null $retail_transaction retail_transaction (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransactionsPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\RetailTransaction|string|string
     */
    public function apiV1TransactionsPost($retail_transaction = null, string $contentType = self::contentTypes['apiV1TransactionsPost'][0])
    {
        list($response) = $this->apiV1TransactionsPostWithHttpInfo($retail_transaction, $contentType);
        return $response;
    }

    /**
     * Operation apiV1TransactionsPostWithHttpInfo
     *
     * Creates a new transaction.
     *
     * @param  \Opsuite2\Model\RetailTransaction|null $retail_transaction (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransactionsPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\RetailTransaction|string|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1TransactionsPostWithHttpInfo($retail_transaction = null, string $contentType = self::contentTypes['apiV1TransactionsPost'][0])
    {
        $request = $this->apiV1TransactionsPostRequest($retail_transaction, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\RetailTransaction',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\RetailTransaction',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\RetailTransaction',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1TransactionsPostAsync
     *
     * Creates a new transaction.
     *
     * @param  \Opsuite2\Model\RetailTransaction|null $retail_transaction (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransactionsPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1TransactionsPostAsync($retail_transaction = null, string $contentType = self::contentTypes['apiV1TransactionsPost'][0])
    {
        return $this->apiV1TransactionsPostAsyncWithHttpInfo($retail_transaction, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1TransactionsPostAsyncWithHttpInfo
     *
     * Creates a new transaction.
     *
     * @param  \Opsuite2\Model\RetailTransaction|null $retail_transaction (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransactionsPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1TransactionsPostAsyncWithHttpInfo($retail_transaction = null, string $contentType = self::contentTypes['apiV1TransactionsPost'][0])
    {
        $returnType = '\Opsuite2\Model\RetailTransaction';
        $request = $this->apiV1TransactionsPostRequest($retail_transaction, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1TransactionsPost'
     *
     * @param  \Opsuite2\Model\RetailTransaction|null $retail_transaction (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransactionsPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1TransactionsPostRequest($retail_transaction = null, string $contentType = self::contentTypes['apiV1TransactionsPost'][0])
    {



        $resourcePath = '/api/v1/Transactions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($retail_transaction)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($retail_transaction));
            } else {
                $httpBody = $retail_transaction;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1TransactionsRefundTransactionPost
     *
     * Refunds a transaction.
     *
     * @param  \Opsuite2\Model\RefundTransaction|null $refund_transaction refund_transaction (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransactionsRefundTransactionPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\RetailTransaction|string|string
     */
    public function apiV1TransactionsRefundTransactionPost($refund_transaction = null, string $contentType = self::contentTypes['apiV1TransactionsRefundTransactionPost'][0])
    {
        list($response) = $this->apiV1TransactionsRefundTransactionPostWithHttpInfo($refund_transaction, $contentType);
        return $response;
    }

    /**
     * Operation apiV1TransactionsRefundTransactionPostWithHttpInfo
     *
     * Refunds a transaction.
     *
     * @param  \Opsuite2\Model\RefundTransaction|null $refund_transaction (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransactionsRefundTransactionPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\RetailTransaction|string|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1TransactionsRefundTransactionPostWithHttpInfo($refund_transaction = null, string $contentType = self::contentTypes['apiV1TransactionsRefundTransactionPost'][0])
    {
        $request = $this->apiV1TransactionsRefundTransactionPostRequest($refund_transaction, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\RetailTransaction',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\RetailTransaction',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\RetailTransaction',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1TransactionsRefundTransactionPostAsync
     *
     * Refunds a transaction.
     *
     * @param  \Opsuite2\Model\RefundTransaction|null $refund_transaction (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransactionsRefundTransactionPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1TransactionsRefundTransactionPostAsync($refund_transaction = null, string $contentType = self::contentTypes['apiV1TransactionsRefundTransactionPost'][0])
    {
        return $this->apiV1TransactionsRefundTransactionPostAsyncWithHttpInfo($refund_transaction, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1TransactionsRefundTransactionPostAsyncWithHttpInfo
     *
     * Refunds a transaction.
     *
     * @param  \Opsuite2\Model\RefundTransaction|null $refund_transaction (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransactionsRefundTransactionPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1TransactionsRefundTransactionPostAsyncWithHttpInfo($refund_transaction = null, string $contentType = self::contentTypes['apiV1TransactionsRefundTransactionPost'][0])
    {
        $returnType = '\Opsuite2\Model\RetailTransaction';
        $request = $this->apiV1TransactionsRefundTransactionPostRequest($refund_transaction, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1TransactionsRefundTransactionPost'
     *
     * @param  \Opsuite2\Model\RefundTransaction|null $refund_transaction (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1TransactionsRefundTransactionPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1TransactionsRefundTransactionPostRequest($refund_transaction = null, string $contentType = self::contentTypes['apiV1TransactionsRefundTransactionPost'][0])
    {



        $resourcePath = '/api/v1/Transactions/RefundTransaction';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($refund_transaction)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($refund_transaction));
            } else {
                $httpBody = $refund_transaction;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2TransactionsGetTransactionsGet
     *
     * Returns an array of Transactions based on the supplied search criteria.
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  int|null $location_id location_id (optional)
     * @param  int|null $customer_id customer_id (optional)
     * @param  int|null $recall_id recall_id (optional)
     * @param  string|null $receipt_number receipt_number (optional)
     * @param  string|null $order_reference order_reference (optional)
     * @param  string|null $transaction_reference transaction_reference (optional)
     * @param  \DateTime|null $date_range_start date_range_start (optional)
     * @param  \DateTime|null $date_range_end date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2TransactionsGetTransactionsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\RetailTransaction[]|string
     */
    public function apiV2TransactionsGetTransactionsGet($page_number = null, $page_size = null, $location_id = null, $customer_id = null, $recall_id = null, $receipt_number = null, $order_reference = null, $transaction_reference = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV2TransactionsGetTransactionsGet'][0])
    {
        list($response) = $this->apiV2TransactionsGetTransactionsGetWithHttpInfo($page_number, $page_size, $location_id, $customer_id, $recall_id, $receipt_number, $order_reference, $transaction_reference, $date_range_start, $date_range_end, $contentType);
        return $response;
    }

    /**
     * Operation apiV2TransactionsGetTransactionsGetWithHttpInfo
     *
     * Returns an array of Transactions based on the supplied search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $location_id (optional)
     * @param  int|null $customer_id (optional)
     * @param  int|null $recall_id (optional)
     * @param  string|null $receipt_number (optional)
     * @param  string|null $order_reference (optional)
     * @param  string|null $transaction_reference (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2TransactionsGetTransactionsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\RetailTransaction[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2TransactionsGetTransactionsGetWithHttpInfo($page_number = null, $page_size = null, $location_id = null, $customer_id = null, $recall_id = null, $receipt_number = null, $order_reference = null, $transaction_reference = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV2TransactionsGetTransactionsGet'][0])
    {
        $request = $this->apiV2TransactionsGetTransactionsGetRequest($page_number, $page_size, $location_id, $customer_id, $recall_id, $receipt_number, $order_reference, $transaction_reference, $date_range_start, $date_range_end, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\RetailTransaction[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\RetailTransaction[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\RetailTransaction[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2TransactionsGetTransactionsGetAsync
     *
     * Returns an array of Transactions based on the supplied search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $location_id (optional)
     * @param  int|null $customer_id (optional)
     * @param  int|null $recall_id (optional)
     * @param  string|null $receipt_number (optional)
     * @param  string|null $order_reference (optional)
     * @param  string|null $transaction_reference (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2TransactionsGetTransactionsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2TransactionsGetTransactionsGetAsync($page_number = null, $page_size = null, $location_id = null, $customer_id = null, $recall_id = null, $receipt_number = null, $order_reference = null, $transaction_reference = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV2TransactionsGetTransactionsGet'][0])
    {
        return $this->apiV2TransactionsGetTransactionsGetAsyncWithHttpInfo($page_number, $page_size, $location_id, $customer_id, $recall_id, $receipt_number, $order_reference, $transaction_reference, $date_range_start, $date_range_end, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2TransactionsGetTransactionsGetAsyncWithHttpInfo
     *
     * Returns an array of Transactions based on the supplied search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $location_id (optional)
     * @param  int|null $customer_id (optional)
     * @param  int|null $recall_id (optional)
     * @param  string|null $receipt_number (optional)
     * @param  string|null $order_reference (optional)
     * @param  string|null $transaction_reference (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2TransactionsGetTransactionsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2TransactionsGetTransactionsGetAsyncWithHttpInfo($page_number = null, $page_size = null, $location_id = null, $customer_id = null, $recall_id = null, $receipt_number = null, $order_reference = null, $transaction_reference = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV2TransactionsGetTransactionsGet'][0])
    {
        $returnType = '\Opsuite2\Model\RetailTransaction[]';
        $request = $this->apiV2TransactionsGetTransactionsGetRequest($page_number, $page_size, $location_id, $customer_id, $recall_id, $receipt_number, $order_reference, $transaction_reference, $date_range_start, $date_range_end, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2TransactionsGetTransactionsGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $location_id (optional)
     * @param  int|null $customer_id (optional)
     * @param  int|null $recall_id (optional)
     * @param  string|null $receipt_number (optional)
     * @param  string|null $order_reference (optional)
     * @param  string|null $transaction_reference (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2TransactionsGetTransactionsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2TransactionsGetTransactionsGetRequest($page_number = null, $page_size = null, $location_id = null, $customer_id = null, $recall_id = null, $receipt_number = null, $order_reference = null, $transaction_reference = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV2TransactionsGetTransactionsGet'][0])
    {












        $resourcePath = '/api/v2/Transactions/GetTransactions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $location_id,
            'LocationId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $customer_id,
            'CustomerId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $recall_id,
            'RecallId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $receipt_number,
            'ReceiptNumber', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_reference,
            'OrderReference', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $transaction_reference,
            'TransactionReference', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_range_start,
            'DateRangeStart', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_range_end,
            'DateRangeEnd', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getTransactionById
     *
     * Returns a single Transaction with the specified id.
     *
     * @param  int $transaction_id transaction_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTransactionById'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\RetailTransaction|string
     */
    public function getTransactionById($transaction_id, string $contentType = self::contentTypes['getTransactionById'][0])
    {
        list($response) = $this->getTransactionByIdWithHttpInfo($transaction_id, $contentType);
        return $response;
    }

    /**
     * Operation getTransactionByIdWithHttpInfo
     *
     * Returns a single Transaction with the specified id.
     *
     * @param  int $transaction_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTransactionById'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\RetailTransaction|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTransactionByIdWithHttpInfo($transaction_id, string $contentType = self::contentTypes['getTransactionById'][0])
    {
        $request = $this->getTransactionByIdRequest($transaction_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\RetailTransaction',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\RetailTransaction',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\RetailTransaction',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getTransactionByIdAsync
     *
     * Returns a single Transaction with the specified id.
     *
     * @param  int $transaction_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTransactionById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTransactionByIdAsync($transaction_id, string $contentType = self::contentTypes['getTransactionById'][0])
    {
        return $this->getTransactionByIdAsyncWithHttpInfo($transaction_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getTransactionByIdAsyncWithHttpInfo
     *
     * Returns a single Transaction with the specified id.
     *
     * @param  int $transaction_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTransactionById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTransactionByIdAsyncWithHttpInfo($transaction_id, string $contentType = self::contentTypes['getTransactionById'][0])
    {
        $returnType = '\Opsuite2\Model\RetailTransaction';
        $request = $this->getTransactionByIdRequest($transaction_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getTransactionById'
     *
     * @param  int $transaction_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTransactionById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getTransactionByIdRequest($transaction_id, string $contentType = self::contentTypes['getTransactionById'][0])
    {

        // verify the required parameter 'transaction_id' is set
        if ($transaction_id === null || (is_array($transaction_id) && count($transaction_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $transaction_id when calling getTransactionById'
            );
        }
        if ($transaction_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$transaction_id" when calling TransactionsApi.getTransactionById, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v1/Transactions/{transactionId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($transaction_id !== null) {
            $resourcePath = str_replace(
                '{' . 'transactionId' . '}',
                ObjectSerializer::toPathValue($transaction_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
