<?php
/**
 * SimpleTaxRatesApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Opsuite2\ApiException;
use Opsuite2\Configuration;
use Opsuite2\FormDataProcessor;
use Opsuite2\HeaderSelector;
use Opsuite2\ObjectSerializer;

/**
 * SimpleTaxRatesApi Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class SimpleTaxRatesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV1SimpleTaxRatesGet' => [
            'application/json',
        ],
        'apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGet' => [
            'application/json',
        ],
        'apiV1SimpleTaxRatesIdPatch' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'apiV1SimpleTaxRatesPost' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'getSimpleTaxRateById' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV1SimpleTaxRatesGet
     *
     * Returns an array of SimpleTaxRates.
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SimpleTaxRatesGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\SimpleTaxRate[]|string
     */
    public function apiV1SimpleTaxRatesGet($page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1SimpleTaxRatesGet'][0])
    {
        list($response) = $this->apiV1SimpleTaxRatesGetWithHttpInfo($page_number, $page_size, $contentType);
        return $response;
    }

    /**
     * Operation apiV1SimpleTaxRatesGetWithHttpInfo
     *
     * Returns an array of SimpleTaxRates.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SimpleTaxRatesGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\SimpleTaxRate[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1SimpleTaxRatesGetWithHttpInfo($page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1SimpleTaxRatesGet'][0])
    {
        $request = $this->apiV1SimpleTaxRatesGetRequest($page_number, $page_size, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\SimpleTaxRate[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\SimpleTaxRate[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\SimpleTaxRate[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1SimpleTaxRatesGetAsync
     *
     * Returns an array of SimpleTaxRates.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SimpleTaxRatesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1SimpleTaxRatesGetAsync($page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1SimpleTaxRatesGet'][0])
    {
        return $this->apiV1SimpleTaxRatesGetAsyncWithHttpInfo($page_number, $page_size, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1SimpleTaxRatesGetAsyncWithHttpInfo
     *
     * Returns an array of SimpleTaxRates.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SimpleTaxRatesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1SimpleTaxRatesGetAsyncWithHttpInfo($page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1SimpleTaxRatesGet'][0])
    {
        $returnType = '\Opsuite2\Model\SimpleTaxRate[]';
        $request = $this->apiV1SimpleTaxRatesGetRequest($page_number, $page_size, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1SimpleTaxRatesGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SimpleTaxRatesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1SimpleTaxRatesGetRequest($page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1SimpleTaxRatesGet'][0])
    {




        $resourcePath = '/api/v1/SimpleTaxRates';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGet
     *
     * Returns a single SimpleTaxRate with the specified code.
     *
     * @param  string|null $code code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\SimpleTaxRate|string
     */
    public function apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGet($code = null, string $contentType = self::contentTypes['apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGet'][0])
    {
        list($response) = $this->apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGetWithHttpInfo($code, $contentType);
        return $response;
    }

    /**
     * Operation apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGetWithHttpInfo
     *
     * Returns a single SimpleTaxRate with the specified code.
     *
     * @param  string|null $code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\SimpleTaxRate|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGetWithHttpInfo($code = null, string $contentType = self::contentTypes['apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGet'][0])
    {
        $request = $this->apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGetRequest($code, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\SimpleTaxRate',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\SimpleTaxRate',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\SimpleTaxRate',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGetAsync
     *
     * Returns a single SimpleTaxRate with the specified code.
     *
     * @param  string|null $code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGetAsync($code = null, string $contentType = self::contentTypes['apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGet'][0])
    {
        return $this->apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGetAsyncWithHttpInfo($code, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGetAsyncWithHttpInfo
     *
     * Returns a single SimpleTaxRate with the specified code.
     *
     * @param  string|null $code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGetAsyncWithHttpInfo($code = null, string $contentType = self::contentTypes['apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGet'][0])
    {
        $returnType = '\Opsuite2\Model\SimpleTaxRate';
        $request = $this->apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGetRequest($code, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGet'
     *
     * @param  string|null $code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGetRequest($code = null, string $contentType = self::contentTypes['apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGet'][0])
    {



        $resourcePath = '/api/v1/SimpleTaxRates/GetSimpleTaxRateByCode';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $code,
            'code', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1SimpleTaxRatesIdPatch
     *
     * Updates specified properties of a simple tax rate.
     *
     * @param  int $id id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SimpleTaxRatesIdPatch'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function apiV1SimpleTaxRatesIdPatch($id, $patch = null, string $contentType = self::contentTypes['apiV1SimpleTaxRatesIdPatch'][0])
    {
        $this->apiV1SimpleTaxRatesIdPatchWithHttpInfo($id, $patch, $contentType);
    }

    /**
     * Operation apiV1SimpleTaxRatesIdPatchWithHttpInfo
     *
     * Updates specified properties of a simple tax rate.
     *
     * @param  int $id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SimpleTaxRatesIdPatch'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1SimpleTaxRatesIdPatchWithHttpInfo($id, $patch = null, string $contentType = self::contentTypes['apiV1SimpleTaxRatesIdPatch'][0])
    {
        $request = $this->apiV1SimpleTaxRatesIdPatchRequest($id, $patch, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1SimpleTaxRatesIdPatchAsync
     *
     * Updates specified properties of a simple tax rate.
     *
     * @param  int $id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SimpleTaxRatesIdPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1SimpleTaxRatesIdPatchAsync($id, $patch = null, string $contentType = self::contentTypes['apiV1SimpleTaxRatesIdPatch'][0])
    {
        return $this->apiV1SimpleTaxRatesIdPatchAsyncWithHttpInfo($id, $patch, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1SimpleTaxRatesIdPatchAsyncWithHttpInfo
     *
     * Updates specified properties of a simple tax rate.
     *
     * @param  int $id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SimpleTaxRatesIdPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1SimpleTaxRatesIdPatchAsyncWithHttpInfo($id, $patch = null, string $contentType = self::contentTypes['apiV1SimpleTaxRatesIdPatch'][0])
    {
        $returnType = '';
        $request = $this->apiV1SimpleTaxRatesIdPatchRequest($id, $patch, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1SimpleTaxRatesIdPatch'
     *
     * @param  int $id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SimpleTaxRatesIdPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1SimpleTaxRatesIdPatchRequest($id, $patch = null, string $contentType = self::contentTypes['apiV1SimpleTaxRatesIdPatch'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling apiV1SimpleTaxRatesIdPatch'
            );
        }
        if ($id < 1) {
            throw new \InvalidArgumentException('invalid value for "$id" when calling SimpleTaxRatesApi.apiV1SimpleTaxRatesIdPatch, must be bigger than or equal to 1.');
        }
        


        $resourcePath = '/api/v1/SimpleTaxRates/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($patch)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($patch));
            } else {
                $httpBody = $patch;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1SimpleTaxRatesPost
     *
     * Creates a new simple tax rate.
     *
     * @param  \Opsuite2\Model\SimpleTaxRate|null $simple_tax_rate simple_tax_rate (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SimpleTaxRatesPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\SimpleTaxRate|string|string
     */
    public function apiV1SimpleTaxRatesPost($simple_tax_rate = null, string $contentType = self::contentTypes['apiV1SimpleTaxRatesPost'][0])
    {
        list($response) = $this->apiV1SimpleTaxRatesPostWithHttpInfo($simple_tax_rate, $contentType);
        return $response;
    }

    /**
     * Operation apiV1SimpleTaxRatesPostWithHttpInfo
     *
     * Creates a new simple tax rate.
     *
     * @param  \Opsuite2\Model\SimpleTaxRate|null $simple_tax_rate (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SimpleTaxRatesPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\SimpleTaxRate|string|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1SimpleTaxRatesPostWithHttpInfo($simple_tax_rate = null, string $contentType = self::contentTypes['apiV1SimpleTaxRatesPost'][0])
    {
        $request = $this->apiV1SimpleTaxRatesPostRequest($simple_tax_rate, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\SimpleTaxRate',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\SimpleTaxRate',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\SimpleTaxRate',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1SimpleTaxRatesPostAsync
     *
     * Creates a new simple tax rate.
     *
     * @param  \Opsuite2\Model\SimpleTaxRate|null $simple_tax_rate (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SimpleTaxRatesPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1SimpleTaxRatesPostAsync($simple_tax_rate = null, string $contentType = self::contentTypes['apiV1SimpleTaxRatesPost'][0])
    {
        return $this->apiV1SimpleTaxRatesPostAsyncWithHttpInfo($simple_tax_rate, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1SimpleTaxRatesPostAsyncWithHttpInfo
     *
     * Creates a new simple tax rate.
     *
     * @param  \Opsuite2\Model\SimpleTaxRate|null $simple_tax_rate (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SimpleTaxRatesPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1SimpleTaxRatesPostAsyncWithHttpInfo($simple_tax_rate = null, string $contentType = self::contentTypes['apiV1SimpleTaxRatesPost'][0])
    {
        $returnType = '\Opsuite2\Model\SimpleTaxRate';
        $request = $this->apiV1SimpleTaxRatesPostRequest($simple_tax_rate, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1SimpleTaxRatesPost'
     *
     * @param  \Opsuite2\Model\SimpleTaxRate|null $simple_tax_rate (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SimpleTaxRatesPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1SimpleTaxRatesPostRequest($simple_tax_rate = null, string $contentType = self::contentTypes['apiV1SimpleTaxRatesPost'][0])
    {



        $resourcePath = '/api/v1/SimpleTaxRates';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($simple_tax_rate)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($simple_tax_rate));
            } else {
                $httpBody = $simple_tax_rate;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSimpleTaxRateById
     *
     * Returns a single SimpleTaxRate with the specified id.
     *
     * @param  int $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSimpleTaxRateById'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\SimpleTaxRate|string
     */
    public function getSimpleTaxRateById($id, string $contentType = self::contentTypes['getSimpleTaxRateById'][0])
    {
        list($response) = $this->getSimpleTaxRateByIdWithHttpInfo($id, $contentType);
        return $response;
    }

    /**
     * Operation getSimpleTaxRateByIdWithHttpInfo
     *
     * Returns a single SimpleTaxRate with the specified id.
     *
     * @param  int $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSimpleTaxRateById'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\SimpleTaxRate|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSimpleTaxRateByIdWithHttpInfo($id, string $contentType = self::contentTypes['getSimpleTaxRateById'][0])
    {
        $request = $this->getSimpleTaxRateByIdRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\SimpleTaxRate',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\SimpleTaxRate',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\SimpleTaxRate',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getSimpleTaxRateByIdAsync
     *
     * Returns a single SimpleTaxRate with the specified id.
     *
     * @param  int $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSimpleTaxRateById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSimpleTaxRateByIdAsync($id, string $contentType = self::contentTypes['getSimpleTaxRateById'][0])
    {
        return $this->getSimpleTaxRateByIdAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSimpleTaxRateByIdAsyncWithHttpInfo
     *
     * Returns a single SimpleTaxRate with the specified id.
     *
     * @param  int $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSimpleTaxRateById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSimpleTaxRateByIdAsyncWithHttpInfo($id, string $contentType = self::contentTypes['getSimpleTaxRateById'][0])
    {
        $returnType = '\Opsuite2\Model\SimpleTaxRate';
        $request = $this->getSimpleTaxRateByIdRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSimpleTaxRateById'
     *
     * @param  int $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSimpleTaxRateById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSimpleTaxRateByIdRequest($id, string $contentType = self::contentTypes['getSimpleTaxRateById'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling getSimpleTaxRateById'
            );
        }
        if ($id < 1) {
            throw new \InvalidArgumentException('invalid value for "$id" when calling SimpleTaxRatesApi.getSimpleTaxRateById, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v1/SimpleTaxRates/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
