<?php
/**
 * SalesOrdersApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Opsuite2\ApiException;
use Opsuite2\Configuration;
use Opsuite2\FormDataProcessor;
use Opsuite2\HeaderSelector;
use Opsuite2\ObjectSerializer;

/**
 * SalesOrdersApi Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class SalesOrdersApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV1SalesOrdersGet' => [
            'application/json',
        ],
        'apiV1SalesOrdersOrderIdClosedStatusGet' => [
            'application/json',
        ],
        'apiV1SalesOrdersUpdateTrackingNumberPatch' => [
            'application/json',
        ],
        'apiV2SalesOrdersGet' => [
            'application/json',
        ],
        'createMultiLocationSalesOrderFromBasket' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'createSalesOrderFromBasket' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'getSalesOrderByOrderId' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV1SalesOrdersGet
     *
     * Returns an array of SalesOrders that match the specified search criteria.
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  \DateTime|null $last_updated_date_range_start last_updated_date_range_start (optional)
     * @param  \DateTime|null $last_updated_date_range_end last_updated_date_range_end (optional)
     * @param  int|null $order_transaction_type_id order_transaction_type_id (optional)
     * @param  int|null $location_id location_id (optional)
     * @param  string|null $order_status order_status (optional)
     * @param  bool|null $include_closed include_closed (optional)
     * @param  string|null $order_comment order_comment (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_comment_search_operator order_comment_search_operator (optional)
     * @param  string|null $order_reference order_reference (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_reference_search_operator order_reference_search_operator (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SalesOrdersGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\OrderTransaction[]|string
     * @deprecated
     */
    public function apiV1SalesOrdersGet($page_number = null, $page_size = null, $last_updated_date_range_start = null, $last_updated_date_range_end = null, $order_transaction_type_id = null, $location_id = null, $order_status = null, $include_closed = null, $order_comment = null, $order_comment_search_operator = null, $order_reference = null, $order_reference_search_operator = null, string $contentType = self::contentTypes['apiV1SalesOrdersGet'][0])
    {
        list($response) = $this->apiV1SalesOrdersGetWithHttpInfo($page_number, $page_size, $last_updated_date_range_start, $last_updated_date_range_end, $order_transaction_type_id, $location_id, $order_status, $include_closed, $order_comment, $order_comment_search_operator, $order_reference, $order_reference_search_operator, $contentType);
        return $response;
    }

    /**
     * Operation apiV1SalesOrdersGetWithHttpInfo
     *
     * Returns an array of SalesOrders that match the specified search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $last_updated_date_range_start (optional)
     * @param  \DateTime|null $last_updated_date_range_end (optional)
     * @param  int|null $order_transaction_type_id (optional)
     * @param  int|null $location_id (optional)
     * @param  string|null $order_status (optional)
     * @param  bool|null $include_closed (optional)
     * @param  string|null $order_comment (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_comment_search_operator (optional)
     * @param  string|null $order_reference (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_reference_search_operator (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SalesOrdersGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\OrderTransaction[]|string, HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function apiV1SalesOrdersGetWithHttpInfo($page_number = null, $page_size = null, $last_updated_date_range_start = null, $last_updated_date_range_end = null, $order_transaction_type_id = null, $location_id = null, $order_status = null, $include_closed = null, $order_comment = null, $order_comment_search_operator = null, $order_reference = null, $order_reference_search_operator = null, string $contentType = self::contentTypes['apiV1SalesOrdersGet'][0])
    {
        $request = $this->apiV1SalesOrdersGetRequest($page_number, $page_size, $last_updated_date_range_start, $last_updated_date_range_end, $order_transaction_type_id, $location_id, $order_status, $include_closed, $order_comment, $order_comment_search_operator, $order_reference, $order_reference_search_operator, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\OrderTransaction[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\OrderTransaction[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\OrderTransaction[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1SalesOrdersGetAsync
     *
     * Returns an array of SalesOrders that match the specified search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $last_updated_date_range_start (optional)
     * @param  \DateTime|null $last_updated_date_range_end (optional)
     * @param  int|null $order_transaction_type_id (optional)
     * @param  int|null $location_id (optional)
     * @param  string|null $order_status (optional)
     * @param  bool|null $include_closed (optional)
     * @param  string|null $order_comment (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_comment_search_operator (optional)
     * @param  string|null $order_reference (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_reference_search_operator (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SalesOrdersGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function apiV1SalesOrdersGetAsync($page_number = null, $page_size = null, $last_updated_date_range_start = null, $last_updated_date_range_end = null, $order_transaction_type_id = null, $location_id = null, $order_status = null, $include_closed = null, $order_comment = null, $order_comment_search_operator = null, $order_reference = null, $order_reference_search_operator = null, string $contentType = self::contentTypes['apiV1SalesOrdersGet'][0])
    {
        return $this->apiV1SalesOrdersGetAsyncWithHttpInfo($page_number, $page_size, $last_updated_date_range_start, $last_updated_date_range_end, $order_transaction_type_id, $location_id, $order_status, $include_closed, $order_comment, $order_comment_search_operator, $order_reference, $order_reference_search_operator, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1SalesOrdersGetAsyncWithHttpInfo
     *
     * Returns an array of SalesOrders that match the specified search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $last_updated_date_range_start (optional)
     * @param  \DateTime|null $last_updated_date_range_end (optional)
     * @param  int|null $order_transaction_type_id (optional)
     * @param  int|null $location_id (optional)
     * @param  string|null $order_status (optional)
     * @param  bool|null $include_closed (optional)
     * @param  string|null $order_comment (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_comment_search_operator (optional)
     * @param  string|null $order_reference (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_reference_search_operator (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SalesOrdersGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function apiV1SalesOrdersGetAsyncWithHttpInfo($page_number = null, $page_size = null, $last_updated_date_range_start = null, $last_updated_date_range_end = null, $order_transaction_type_id = null, $location_id = null, $order_status = null, $include_closed = null, $order_comment = null, $order_comment_search_operator = null, $order_reference = null, $order_reference_search_operator = null, string $contentType = self::contentTypes['apiV1SalesOrdersGet'][0])
    {
        $returnType = '\Opsuite2\Model\OrderTransaction[]';
        $request = $this->apiV1SalesOrdersGetRequest($page_number, $page_size, $last_updated_date_range_start, $last_updated_date_range_end, $order_transaction_type_id, $location_id, $order_status, $include_closed, $order_comment, $order_comment_search_operator, $order_reference, $order_reference_search_operator, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1SalesOrdersGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $last_updated_date_range_start (optional)
     * @param  \DateTime|null $last_updated_date_range_end (optional)
     * @param  int|null $order_transaction_type_id (optional)
     * @param  int|null $location_id (optional)
     * @param  string|null $order_status (optional)
     * @param  bool|null $include_closed (optional)
     * @param  string|null $order_comment (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_comment_search_operator (optional)
     * @param  string|null $order_reference (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_reference_search_operator (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SalesOrdersGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function apiV1SalesOrdersGetRequest($page_number = null, $page_size = null, $last_updated_date_range_start = null, $last_updated_date_range_end = null, $order_transaction_type_id = null, $location_id = null, $order_status = null, $include_closed = null, $order_comment = null, $order_comment_search_operator = null, $order_reference = null, $order_reference_search_operator = null, string $contentType = self::contentTypes['apiV1SalesOrdersGet'][0])
    {














        $resourcePath = '/api/v1/SalesOrders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $last_updated_date_range_start,
            'LastUpdatedDateRangeStart', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $last_updated_date_range_end,
            'LastUpdatedDateRangeEnd', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_transaction_type_id,
            'OrderTransactionTypeId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $location_id,
            'LocationId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_status,
            'OrderStatus', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_closed,
            'IncludeClosed', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_comment,
            'OrderComment', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_comment_search_operator,
            'OrderCommentSearchOperator', // param base name
            'SimpleSearchOperatorEnum', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_reference,
            'OrderReference', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_reference_search_operator,
            'OrderReferenceSearchOperator', // param base name
            'SimpleSearchOperatorEnum', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1SalesOrdersOrderIdClosedStatusGet
     *
     * Returns the closed status for the specified sales order.
     *
     * @param  int $order_id order_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SalesOrdersOrderIdClosedStatusGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\OrderClosedStatus|string
     */
    public function apiV1SalesOrdersOrderIdClosedStatusGet($order_id, string $contentType = self::contentTypes['apiV1SalesOrdersOrderIdClosedStatusGet'][0])
    {
        list($response) = $this->apiV1SalesOrdersOrderIdClosedStatusGetWithHttpInfo($order_id, $contentType);
        return $response;
    }

    /**
     * Operation apiV1SalesOrdersOrderIdClosedStatusGetWithHttpInfo
     *
     * Returns the closed status for the specified sales order.
     *
     * @param  int $order_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SalesOrdersOrderIdClosedStatusGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\OrderClosedStatus|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1SalesOrdersOrderIdClosedStatusGetWithHttpInfo($order_id, string $contentType = self::contentTypes['apiV1SalesOrdersOrderIdClosedStatusGet'][0])
    {
        $request = $this->apiV1SalesOrdersOrderIdClosedStatusGetRequest($order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\OrderClosedStatus',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\OrderClosedStatus',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\OrderClosedStatus',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1SalesOrdersOrderIdClosedStatusGetAsync
     *
     * Returns the closed status for the specified sales order.
     *
     * @param  int $order_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SalesOrdersOrderIdClosedStatusGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1SalesOrdersOrderIdClosedStatusGetAsync($order_id, string $contentType = self::contentTypes['apiV1SalesOrdersOrderIdClosedStatusGet'][0])
    {
        return $this->apiV1SalesOrdersOrderIdClosedStatusGetAsyncWithHttpInfo($order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1SalesOrdersOrderIdClosedStatusGetAsyncWithHttpInfo
     *
     * Returns the closed status for the specified sales order.
     *
     * @param  int $order_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SalesOrdersOrderIdClosedStatusGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1SalesOrdersOrderIdClosedStatusGetAsyncWithHttpInfo($order_id, string $contentType = self::contentTypes['apiV1SalesOrdersOrderIdClosedStatusGet'][0])
    {
        $returnType = '\Opsuite2\Model\OrderClosedStatus';
        $request = $this->apiV1SalesOrdersOrderIdClosedStatusGetRequest($order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1SalesOrdersOrderIdClosedStatusGet'
     *
     * @param  int $order_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SalesOrdersOrderIdClosedStatusGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1SalesOrdersOrderIdClosedStatusGetRequest($order_id, string $contentType = self::contentTypes['apiV1SalesOrdersOrderIdClosedStatusGet'][0])
    {

        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling apiV1SalesOrdersOrderIdClosedStatusGet'
            );
        }
        if ($order_id < 0) {
            throw new \InvalidArgumentException('invalid value for "$order_id" when calling SalesOrdersApi.apiV1SalesOrdersOrderIdClosedStatusGet, must be bigger than or equal to 0.');
        }
        

        $resourcePath = '/api/v1/SalesOrders/{orderId}/ClosedStatus';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'orderId' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1SalesOrdersUpdateTrackingNumberPatch
     *
     * Updates the shipping tracking number on the specified order
     *
     * @param  int|null $order_id  (optional)
     * @param  string|null $tracking_number  (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SalesOrdersUpdateTrackingNumberPatch'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\OrderClosedStatus|string
     */
    public function apiV1SalesOrdersUpdateTrackingNumberPatch($order_id = null, $tracking_number = null, string $contentType = self::contentTypes['apiV1SalesOrdersUpdateTrackingNumberPatch'][0])
    {
        list($response) = $this->apiV1SalesOrdersUpdateTrackingNumberPatchWithHttpInfo($order_id, $tracking_number, $contentType);
        return $response;
    }

    /**
     * Operation apiV1SalesOrdersUpdateTrackingNumberPatchWithHttpInfo
     *
     * Updates the shipping tracking number on the specified order
     *
     * @param  int|null $order_id  (optional)
     * @param  string|null $tracking_number  (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SalesOrdersUpdateTrackingNumberPatch'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\OrderClosedStatus|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1SalesOrdersUpdateTrackingNumberPatchWithHttpInfo($order_id = null, $tracking_number = null, string $contentType = self::contentTypes['apiV1SalesOrdersUpdateTrackingNumberPatch'][0])
    {
        $request = $this->apiV1SalesOrdersUpdateTrackingNumberPatchRequest($order_id, $tracking_number, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\OrderClosedStatus',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\OrderClosedStatus',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\OrderClosedStatus',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1SalesOrdersUpdateTrackingNumberPatchAsync
     *
     * Updates the shipping tracking number on the specified order
     *
     * @param  int|null $order_id  (optional)
     * @param  string|null $tracking_number  (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SalesOrdersUpdateTrackingNumberPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1SalesOrdersUpdateTrackingNumberPatchAsync($order_id = null, $tracking_number = null, string $contentType = self::contentTypes['apiV1SalesOrdersUpdateTrackingNumberPatch'][0])
    {
        return $this->apiV1SalesOrdersUpdateTrackingNumberPatchAsyncWithHttpInfo($order_id, $tracking_number, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1SalesOrdersUpdateTrackingNumberPatchAsyncWithHttpInfo
     *
     * Updates the shipping tracking number on the specified order
     *
     * @param  int|null $order_id  (optional)
     * @param  string|null $tracking_number  (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SalesOrdersUpdateTrackingNumberPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1SalesOrdersUpdateTrackingNumberPatchAsyncWithHttpInfo($order_id = null, $tracking_number = null, string $contentType = self::contentTypes['apiV1SalesOrdersUpdateTrackingNumberPatch'][0])
    {
        $returnType = '\Opsuite2\Model\OrderClosedStatus';
        $request = $this->apiV1SalesOrdersUpdateTrackingNumberPatchRequest($order_id, $tracking_number, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1SalesOrdersUpdateTrackingNumberPatch'
     *
     * @param  int|null $order_id  (optional)
     * @param  string|null $tracking_number  (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1SalesOrdersUpdateTrackingNumberPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1SalesOrdersUpdateTrackingNumberPatchRequest($order_id = null, $tracking_number = null, string $contentType = self::contentTypes['apiV1SalesOrdersUpdateTrackingNumberPatch'][0])
    {




        $resourcePath = '/api/v1/SalesOrders/UpdateTrackingNumber';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_id,
            'orderId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $tracking_number,
            'trackingNumber', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2SalesOrdersGet
     *
     * Returns an array of SalesOrders that match the specified search criteria.
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  \DateTime|null $last_updated_date_range_start last_updated_date_range_start (optional)
     * @param  \DateTime|null $last_updated_date_range_end last_updated_date_range_end (optional)
     * @param  int|null $order_transaction_type_id order_transaction_type_id (optional)
     * @param  int|null $location_id location_id (optional)
     * @param  string|null $order_status order_status (optional)
     * @param  bool|null $include_closed include_closed (optional)
     * @param  string|null $order_comment order_comment (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_comment_search_operator order_comment_search_operator (optional)
     * @param  string|null $order_reference order_reference (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_reference_search_operator order_reference_search_operator (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2SalesOrdersGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\OrderTransaction[]|string
     */
    public function apiV2SalesOrdersGet($page_number = null, $page_size = null, $last_updated_date_range_start = null, $last_updated_date_range_end = null, $order_transaction_type_id = null, $location_id = null, $order_status = null, $include_closed = null, $order_comment = null, $order_comment_search_operator = null, $order_reference = null, $order_reference_search_operator = null, string $contentType = self::contentTypes['apiV2SalesOrdersGet'][0])
    {
        list($response) = $this->apiV2SalesOrdersGetWithHttpInfo($page_number, $page_size, $last_updated_date_range_start, $last_updated_date_range_end, $order_transaction_type_id, $location_id, $order_status, $include_closed, $order_comment, $order_comment_search_operator, $order_reference, $order_reference_search_operator, $contentType);
        return $response;
    }

    /**
     * Operation apiV2SalesOrdersGetWithHttpInfo
     *
     * Returns an array of SalesOrders that match the specified search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $last_updated_date_range_start (optional)
     * @param  \DateTime|null $last_updated_date_range_end (optional)
     * @param  int|null $order_transaction_type_id (optional)
     * @param  int|null $location_id (optional)
     * @param  string|null $order_status (optional)
     * @param  bool|null $include_closed (optional)
     * @param  string|null $order_comment (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_comment_search_operator (optional)
     * @param  string|null $order_reference (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_reference_search_operator (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2SalesOrdersGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\OrderTransaction[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2SalesOrdersGetWithHttpInfo($page_number = null, $page_size = null, $last_updated_date_range_start = null, $last_updated_date_range_end = null, $order_transaction_type_id = null, $location_id = null, $order_status = null, $include_closed = null, $order_comment = null, $order_comment_search_operator = null, $order_reference = null, $order_reference_search_operator = null, string $contentType = self::contentTypes['apiV2SalesOrdersGet'][0])
    {
        $request = $this->apiV2SalesOrdersGetRequest($page_number, $page_size, $last_updated_date_range_start, $last_updated_date_range_end, $order_transaction_type_id, $location_id, $order_status, $include_closed, $order_comment, $order_comment_search_operator, $order_reference, $order_reference_search_operator, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\OrderTransaction[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\OrderTransaction[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\OrderTransaction[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2SalesOrdersGetAsync
     *
     * Returns an array of SalesOrders that match the specified search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $last_updated_date_range_start (optional)
     * @param  \DateTime|null $last_updated_date_range_end (optional)
     * @param  int|null $order_transaction_type_id (optional)
     * @param  int|null $location_id (optional)
     * @param  string|null $order_status (optional)
     * @param  bool|null $include_closed (optional)
     * @param  string|null $order_comment (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_comment_search_operator (optional)
     * @param  string|null $order_reference (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_reference_search_operator (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2SalesOrdersGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2SalesOrdersGetAsync($page_number = null, $page_size = null, $last_updated_date_range_start = null, $last_updated_date_range_end = null, $order_transaction_type_id = null, $location_id = null, $order_status = null, $include_closed = null, $order_comment = null, $order_comment_search_operator = null, $order_reference = null, $order_reference_search_operator = null, string $contentType = self::contentTypes['apiV2SalesOrdersGet'][0])
    {
        return $this->apiV2SalesOrdersGetAsyncWithHttpInfo($page_number, $page_size, $last_updated_date_range_start, $last_updated_date_range_end, $order_transaction_type_id, $location_id, $order_status, $include_closed, $order_comment, $order_comment_search_operator, $order_reference, $order_reference_search_operator, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2SalesOrdersGetAsyncWithHttpInfo
     *
     * Returns an array of SalesOrders that match the specified search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $last_updated_date_range_start (optional)
     * @param  \DateTime|null $last_updated_date_range_end (optional)
     * @param  int|null $order_transaction_type_id (optional)
     * @param  int|null $location_id (optional)
     * @param  string|null $order_status (optional)
     * @param  bool|null $include_closed (optional)
     * @param  string|null $order_comment (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_comment_search_operator (optional)
     * @param  string|null $order_reference (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_reference_search_operator (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2SalesOrdersGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2SalesOrdersGetAsyncWithHttpInfo($page_number = null, $page_size = null, $last_updated_date_range_start = null, $last_updated_date_range_end = null, $order_transaction_type_id = null, $location_id = null, $order_status = null, $include_closed = null, $order_comment = null, $order_comment_search_operator = null, $order_reference = null, $order_reference_search_operator = null, string $contentType = self::contentTypes['apiV2SalesOrdersGet'][0])
    {
        $returnType = '\Opsuite2\Model\OrderTransaction[]';
        $request = $this->apiV2SalesOrdersGetRequest($page_number, $page_size, $last_updated_date_range_start, $last_updated_date_range_end, $order_transaction_type_id, $location_id, $order_status, $include_closed, $order_comment, $order_comment_search_operator, $order_reference, $order_reference_search_operator, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2SalesOrdersGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $last_updated_date_range_start (optional)
     * @param  \DateTime|null $last_updated_date_range_end (optional)
     * @param  int|null $order_transaction_type_id (optional)
     * @param  int|null $location_id (optional)
     * @param  string|null $order_status (optional)
     * @param  bool|null $include_closed (optional)
     * @param  string|null $order_comment (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_comment_search_operator (optional)
     * @param  string|null $order_reference (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_reference_search_operator (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2SalesOrdersGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2SalesOrdersGetRequest($page_number = null, $page_size = null, $last_updated_date_range_start = null, $last_updated_date_range_end = null, $order_transaction_type_id = null, $location_id = null, $order_status = null, $include_closed = null, $order_comment = null, $order_comment_search_operator = null, $order_reference = null, $order_reference_search_operator = null, string $contentType = self::contentTypes['apiV2SalesOrdersGet'][0])
    {














        $resourcePath = '/api/v2/SalesOrders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $last_updated_date_range_start,
            'LastUpdatedDateRangeStart', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $last_updated_date_range_end,
            'LastUpdatedDateRangeEnd', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_transaction_type_id,
            'OrderTransactionTypeId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $location_id,
            'LocationId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_status,
            'OrderStatus', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_closed,
            'IncludeClosed', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_comment,
            'OrderComment', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_comment_search_operator,
            'OrderCommentSearchOperator', // param base name
            'SimpleSearchOperatorEnum', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_reference,
            'OrderReference', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_reference_search_operator,
            'OrderReferenceSearchOperator', // param base name
            'SimpleSearchOperatorEnum', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createMultiLocationSalesOrderFromBasket
     *
     * Creates a new sales order from a stored basket of goods,  converts the sales order to a retail transaction,  and creates a picking order for the specified stock location
     *
     * @param  \Opsuite2\Model\MultiLocationSalesOrderBasket|null $multi_location_sales_order_basket multi_location_sales_order_basket (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createMultiLocationSalesOrderFromBasket'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\OrderTransaction|string|string
     */
    public function createMultiLocationSalesOrderFromBasket($multi_location_sales_order_basket = null, string $contentType = self::contentTypes['createMultiLocationSalesOrderFromBasket'][0])
    {
        list($response) = $this->createMultiLocationSalesOrderFromBasketWithHttpInfo($multi_location_sales_order_basket, $contentType);
        return $response;
    }

    /**
     * Operation createMultiLocationSalesOrderFromBasketWithHttpInfo
     *
     * Creates a new sales order from a stored basket of goods,  converts the sales order to a retail transaction,  and creates a picking order for the specified stock location
     *
     * @param  \Opsuite2\Model\MultiLocationSalesOrderBasket|null $multi_location_sales_order_basket (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createMultiLocationSalesOrderFromBasket'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\OrderTransaction|string|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function createMultiLocationSalesOrderFromBasketWithHttpInfo($multi_location_sales_order_basket = null, string $contentType = self::contentTypes['createMultiLocationSalesOrderFromBasket'][0])
    {
        $request = $this->createMultiLocationSalesOrderFromBasketRequest($multi_location_sales_order_basket, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\OrderTransaction',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\OrderTransaction',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\OrderTransaction',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createMultiLocationSalesOrderFromBasketAsync
     *
     * Creates a new sales order from a stored basket of goods,  converts the sales order to a retail transaction,  and creates a picking order for the specified stock location
     *
     * @param  \Opsuite2\Model\MultiLocationSalesOrderBasket|null $multi_location_sales_order_basket (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createMultiLocationSalesOrderFromBasket'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createMultiLocationSalesOrderFromBasketAsync($multi_location_sales_order_basket = null, string $contentType = self::contentTypes['createMultiLocationSalesOrderFromBasket'][0])
    {
        return $this->createMultiLocationSalesOrderFromBasketAsyncWithHttpInfo($multi_location_sales_order_basket, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createMultiLocationSalesOrderFromBasketAsyncWithHttpInfo
     *
     * Creates a new sales order from a stored basket of goods,  converts the sales order to a retail transaction,  and creates a picking order for the specified stock location
     *
     * @param  \Opsuite2\Model\MultiLocationSalesOrderBasket|null $multi_location_sales_order_basket (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createMultiLocationSalesOrderFromBasket'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createMultiLocationSalesOrderFromBasketAsyncWithHttpInfo($multi_location_sales_order_basket = null, string $contentType = self::contentTypes['createMultiLocationSalesOrderFromBasket'][0])
    {
        $returnType = '\Opsuite2\Model\OrderTransaction';
        $request = $this->createMultiLocationSalesOrderFromBasketRequest($multi_location_sales_order_basket, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createMultiLocationSalesOrderFromBasket'
     *
     * @param  \Opsuite2\Model\MultiLocationSalesOrderBasket|null $multi_location_sales_order_basket (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createMultiLocationSalesOrderFromBasket'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createMultiLocationSalesOrderFromBasketRequest($multi_location_sales_order_basket = null, string $contentType = self::contentTypes['createMultiLocationSalesOrderFromBasket'][0])
    {



        $resourcePath = '/api/v1/SalesOrders/CreateMultiLocationSalesOrderFromBasket';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($multi_location_sales_order_basket)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($multi_location_sales_order_basket));
            } else {
                $httpBody = $multi_location_sales_order_basket;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createSalesOrderFromBasket
     *
     * Creates a new sales order from a stored basket of goods.
     *
     * @param  \Opsuite2\Model\SalesOrderBasket|null $sales_order_basket sales_order_basket (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSalesOrderFromBasket'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\OrderTransaction|string|string
     */
    public function createSalesOrderFromBasket($sales_order_basket = null, string $contentType = self::contentTypes['createSalesOrderFromBasket'][0])
    {
        list($response) = $this->createSalesOrderFromBasketWithHttpInfo($sales_order_basket, $contentType);
        return $response;
    }

    /**
     * Operation createSalesOrderFromBasketWithHttpInfo
     *
     * Creates a new sales order from a stored basket of goods.
     *
     * @param  \Opsuite2\Model\SalesOrderBasket|null $sales_order_basket (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSalesOrderFromBasket'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\OrderTransaction|string|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function createSalesOrderFromBasketWithHttpInfo($sales_order_basket = null, string $contentType = self::contentTypes['createSalesOrderFromBasket'][0])
    {
        $request = $this->createSalesOrderFromBasketRequest($sales_order_basket, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\OrderTransaction',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\OrderTransaction',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\OrderTransaction',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createSalesOrderFromBasketAsync
     *
     * Creates a new sales order from a stored basket of goods.
     *
     * @param  \Opsuite2\Model\SalesOrderBasket|null $sales_order_basket (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSalesOrderFromBasket'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createSalesOrderFromBasketAsync($sales_order_basket = null, string $contentType = self::contentTypes['createSalesOrderFromBasket'][0])
    {
        return $this->createSalesOrderFromBasketAsyncWithHttpInfo($sales_order_basket, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createSalesOrderFromBasketAsyncWithHttpInfo
     *
     * Creates a new sales order from a stored basket of goods.
     *
     * @param  \Opsuite2\Model\SalesOrderBasket|null $sales_order_basket (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSalesOrderFromBasket'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createSalesOrderFromBasketAsyncWithHttpInfo($sales_order_basket = null, string $contentType = self::contentTypes['createSalesOrderFromBasket'][0])
    {
        $returnType = '\Opsuite2\Model\OrderTransaction';
        $request = $this->createSalesOrderFromBasketRequest($sales_order_basket, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createSalesOrderFromBasket'
     *
     * @param  \Opsuite2\Model\SalesOrderBasket|null $sales_order_basket (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSalesOrderFromBasket'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createSalesOrderFromBasketRequest($sales_order_basket = null, string $contentType = self::contentTypes['createSalesOrderFromBasket'][0])
    {



        $resourcePath = '/api/v1/SalesOrders/CreateSalesOrderFromBasket';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($sales_order_basket)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($sales_order_basket));
            } else {
                $httpBody = $sales_order_basket;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSalesOrderByOrderId
     *
     * Returns the specified sales order transaction.
     *
     * @param  int $order_id order_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSalesOrderByOrderId'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\OrderTransaction|string
     */
    public function getSalesOrderByOrderId($order_id, string $contentType = self::contentTypes['getSalesOrderByOrderId'][0])
    {
        list($response) = $this->getSalesOrderByOrderIdWithHttpInfo($order_id, $contentType);
        return $response;
    }

    /**
     * Operation getSalesOrderByOrderIdWithHttpInfo
     *
     * Returns the specified sales order transaction.
     *
     * @param  int $order_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSalesOrderByOrderId'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\OrderTransaction|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSalesOrderByOrderIdWithHttpInfo($order_id, string $contentType = self::contentTypes['getSalesOrderByOrderId'][0])
    {
        $request = $this->getSalesOrderByOrderIdRequest($order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\OrderTransaction',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\OrderTransaction',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\OrderTransaction',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getSalesOrderByOrderIdAsync
     *
     * Returns the specified sales order transaction.
     *
     * @param  int $order_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSalesOrderByOrderId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSalesOrderByOrderIdAsync($order_id, string $contentType = self::contentTypes['getSalesOrderByOrderId'][0])
    {
        return $this->getSalesOrderByOrderIdAsyncWithHttpInfo($order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSalesOrderByOrderIdAsyncWithHttpInfo
     *
     * Returns the specified sales order transaction.
     *
     * @param  int $order_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSalesOrderByOrderId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSalesOrderByOrderIdAsyncWithHttpInfo($order_id, string $contentType = self::contentTypes['getSalesOrderByOrderId'][0])
    {
        $returnType = '\Opsuite2\Model\OrderTransaction';
        $request = $this->getSalesOrderByOrderIdRequest($order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSalesOrderByOrderId'
     *
     * @param  int $order_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSalesOrderByOrderId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSalesOrderByOrderIdRequest($order_id, string $contentType = self::contentTypes['getSalesOrderByOrderId'][0])
    {

        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling getSalesOrderByOrderId'
            );
        }
        if ($order_id < 0) {
            throw new \InvalidArgumentException('invalid value for "$order_id" when calling SalesOrdersApi.getSalesOrderByOrderId, must be bigger than or equal to 0.');
        }
        

        $resourcePath = '/api/v1/SalesOrders/{orderId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'orderId' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
