<?php
/**
 * PromotionHeadersApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Opsuite2\ApiException;
use Opsuite2\Configuration;
use Opsuite2\FormDataProcessor;
use Opsuite2\HeaderSelector;
use Opsuite2\ObjectSerializer;

/**
 * PromotionHeadersApi Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class PromotionHeadersApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV1PromotionHeadersGet' => [
            'application/json',
        ],
        'apiV1PromotionHeadersGetPromotionHeadersForItemGet' => [
            'application/json',
        ],
        'apiV1PromotionHeadersGetPromotionHeadersForItemsGet' => [
            'application/json',
        ],
        'getPromotionHeaderById' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV1PromotionHeadersGet
     *
     * Returns an array of Promotion Headers that match the specified search criteria.
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  bool|null $include_inactive include_inactive (optional)
     * @param  \DateTime|null $active_on active_on (optional)
     * @param  \DateTime|null $date_range_start date_range_start (optional)
     * @param  \DateTime|null $date_range_end date_range_end (optional)
     * @param  \DateTime|null $modified_date_range_start modified_date_range_start (optional)
     * @param  \DateTime|null $modified_date_range_end modified_date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1PromotionHeadersGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\PromotionHeader[]|string
     */
    public function apiV1PromotionHeadersGet($page_number = null, $page_size = null, $include_inactive = null, $active_on = null, $date_range_start = null, $date_range_end = null, $modified_date_range_start = null, $modified_date_range_end = null, string $contentType = self::contentTypes['apiV1PromotionHeadersGet'][0])
    {
        list($response) = $this->apiV1PromotionHeadersGetWithHttpInfo($page_number, $page_size, $include_inactive, $active_on, $date_range_start, $date_range_end, $modified_date_range_start, $modified_date_range_end, $contentType);
        return $response;
    }

    /**
     * Operation apiV1PromotionHeadersGetWithHttpInfo
     *
     * Returns an array of Promotion Headers that match the specified search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  bool|null $include_inactive (optional)
     * @param  \DateTime|null $active_on (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  \DateTime|null $modified_date_range_start (optional)
     * @param  \DateTime|null $modified_date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1PromotionHeadersGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\PromotionHeader[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1PromotionHeadersGetWithHttpInfo($page_number = null, $page_size = null, $include_inactive = null, $active_on = null, $date_range_start = null, $date_range_end = null, $modified_date_range_start = null, $modified_date_range_end = null, string $contentType = self::contentTypes['apiV1PromotionHeadersGet'][0])
    {
        $request = $this->apiV1PromotionHeadersGetRequest($page_number, $page_size, $include_inactive, $active_on, $date_range_start, $date_range_end, $modified_date_range_start, $modified_date_range_end, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\PromotionHeader[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\PromotionHeader[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\PromotionHeader[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1PromotionHeadersGetAsync
     *
     * Returns an array of Promotion Headers that match the specified search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  bool|null $include_inactive (optional)
     * @param  \DateTime|null $active_on (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  \DateTime|null $modified_date_range_start (optional)
     * @param  \DateTime|null $modified_date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1PromotionHeadersGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1PromotionHeadersGetAsync($page_number = null, $page_size = null, $include_inactive = null, $active_on = null, $date_range_start = null, $date_range_end = null, $modified_date_range_start = null, $modified_date_range_end = null, string $contentType = self::contentTypes['apiV1PromotionHeadersGet'][0])
    {
        return $this->apiV1PromotionHeadersGetAsyncWithHttpInfo($page_number, $page_size, $include_inactive, $active_on, $date_range_start, $date_range_end, $modified_date_range_start, $modified_date_range_end, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1PromotionHeadersGetAsyncWithHttpInfo
     *
     * Returns an array of Promotion Headers that match the specified search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  bool|null $include_inactive (optional)
     * @param  \DateTime|null $active_on (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  \DateTime|null $modified_date_range_start (optional)
     * @param  \DateTime|null $modified_date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1PromotionHeadersGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1PromotionHeadersGetAsyncWithHttpInfo($page_number = null, $page_size = null, $include_inactive = null, $active_on = null, $date_range_start = null, $date_range_end = null, $modified_date_range_start = null, $modified_date_range_end = null, string $contentType = self::contentTypes['apiV1PromotionHeadersGet'][0])
    {
        $returnType = '\Opsuite2\Model\PromotionHeader[]';
        $request = $this->apiV1PromotionHeadersGetRequest($page_number, $page_size, $include_inactive, $active_on, $date_range_start, $date_range_end, $modified_date_range_start, $modified_date_range_end, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1PromotionHeadersGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  bool|null $include_inactive (optional)
     * @param  \DateTime|null $active_on (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  \DateTime|null $modified_date_range_start (optional)
     * @param  \DateTime|null $modified_date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1PromotionHeadersGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1PromotionHeadersGetRequest($page_number = null, $page_size = null, $include_inactive = null, $active_on = null, $date_range_start = null, $date_range_end = null, $modified_date_range_start = null, $modified_date_range_end = null, string $contentType = self::contentTypes['apiV1PromotionHeadersGet'][0])
    {










        $resourcePath = '/api/v1/PromotionHeaders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_inactive,
            'IncludeInactive', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $active_on,
            'ActiveOn', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_range_start,
            'DateRangeStart', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_range_end,
            'DateRangeEnd', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $modified_date_range_start,
            'ModifiedDateRangeStart', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $modified_date_range_end,
            'ModifiedDateRangeEnd', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1PromotionHeadersGetPromotionHeadersForItemGet
     *
     * Returns an array of Promotion Headers that could fire for the supplied item.
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  int|null $location_id location_id (optional)
     * @param  string|null $sku sku (optional)
     * @param  int|null $customer_id customer_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1PromotionHeadersGetPromotionHeadersForItemGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\PromotionHeader[]|string
     */
    public function apiV1PromotionHeadersGetPromotionHeadersForItemGet($page_number = null, $page_size = null, $location_id = null, $sku = null, $customer_id = null, string $contentType = self::contentTypes['apiV1PromotionHeadersGetPromotionHeadersForItemGet'][0])
    {
        list($response) = $this->apiV1PromotionHeadersGetPromotionHeadersForItemGetWithHttpInfo($page_number, $page_size, $location_id, $sku, $customer_id, $contentType);
        return $response;
    }

    /**
     * Operation apiV1PromotionHeadersGetPromotionHeadersForItemGetWithHttpInfo
     *
     * Returns an array of Promotion Headers that could fire for the supplied item.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $location_id (optional)
     * @param  string|null $sku (optional)
     * @param  int|null $customer_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1PromotionHeadersGetPromotionHeadersForItemGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\PromotionHeader[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1PromotionHeadersGetPromotionHeadersForItemGetWithHttpInfo($page_number = null, $page_size = null, $location_id = null, $sku = null, $customer_id = null, string $contentType = self::contentTypes['apiV1PromotionHeadersGetPromotionHeadersForItemGet'][0])
    {
        $request = $this->apiV1PromotionHeadersGetPromotionHeadersForItemGetRequest($page_number, $page_size, $location_id, $sku, $customer_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\PromotionHeader[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\PromotionHeader[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\PromotionHeader[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1PromotionHeadersGetPromotionHeadersForItemGetAsync
     *
     * Returns an array of Promotion Headers that could fire for the supplied item.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $location_id (optional)
     * @param  string|null $sku (optional)
     * @param  int|null $customer_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1PromotionHeadersGetPromotionHeadersForItemGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1PromotionHeadersGetPromotionHeadersForItemGetAsync($page_number = null, $page_size = null, $location_id = null, $sku = null, $customer_id = null, string $contentType = self::contentTypes['apiV1PromotionHeadersGetPromotionHeadersForItemGet'][0])
    {
        return $this->apiV1PromotionHeadersGetPromotionHeadersForItemGetAsyncWithHttpInfo($page_number, $page_size, $location_id, $sku, $customer_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1PromotionHeadersGetPromotionHeadersForItemGetAsyncWithHttpInfo
     *
     * Returns an array of Promotion Headers that could fire for the supplied item.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $location_id (optional)
     * @param  string|null $sku (optional)
     * @param  int|null $customer_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1PromotionHeadersGetPromotionHeadersForItemGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1PromotionHeadersGetPromotionHeadersForItemGetAsyncWithHttpInfo($page_number = null, $page_size = null, $location_id = null, $sku = null, $customer_id = null, string $contentType = self::contentTypes['apiV1PromotionHeadersGetPromotionHeadersForItemGet'][0])
    {
        $returnType = '\Opsuite2\Model\PromotionHeader[]';
        $request = $this->apiV1PromotionHeadersGetPromotionHeadersForItemGetRequest($page_number, $page_size, $location_id, $sku, $customer_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1PromotionHeadersGetPromotionHeadersForItemGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $location_id (optional)
     * @param  string|null $sku (optional)
     * @param  int|null $customer_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1PromotionHeadersGetPromotionHeadersForItemGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1PromotionHeadersGetPromotionHeadersForItemGetRequest($page_number = null, $page_size = null, $location_id = null, $sku = null, $customer_id = null, string $contentType = self::contentTypes['apiV1PromotionHeadersGetPromotionHeadersForItemGet'][0])
    {







        $resourcePath = '/api/v1/PromotionHeaders/GetPromotionHeadersForItem';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $location_id,
            'locationId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sku,
            'sku', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $customer_id,
            'customerId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1PromotionHeadersGetPromotionHeadersForItemsGet
     *
     * Returns an array of Promotion Headers that could fire for the supplied item.
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  int|null $location_id location_id (optional)
     * @param  string[]|null $skus skus (optional)
     * @param  int|null $customer_id customer_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1PromotionHeadersGetPromotionHeadersForItemsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\PromotionHeadersByItem[]|string
     */
    public function apiV1PromotionHeadersGetPromotionHeadersForItemsGet($page_number = null, $page_size = null, $location_id = null, $skus = null, $customer_id = null, string $contentType = self::contentTypes['apiV1PromotionHeadersGetPromotionHeadersForItemsGet'][0])
    {
        list($response) = $this->apiV1PromotionHeadersGetPromotionHeadersForItemsGetWithHttpInfo($page_number, $page_size, $location_id, $skus, $customer_id, $contentType);
        return $response;
    }

    /**
     * Operation apiV1PromotionHeadersGetPromotionHeadersForItemsGetWithHttpInfo
     *
     * Returns an array of Promotion Headers that could fire for the supplied item.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $location_id (optional)
     * @param  string[]|null $skus (optional)
     * @param  int|null $customer_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1PromotionHeadersGetPromotionHeadersForItemsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\PromotionHeadersByItem[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1PromotionHeadersGetPromotionHeadersForItemsGetWithHttpInfo($page_number = null, $page_size = null, $location_id = null, $skus = null, $customer_id = null, string $contentType = self::contentTypes['apiV1PromotionHeadersGetPromotionHeadersForItemsGet'][0])
    {
        $request = $this->apiV1PromotionHeadersGetPromotionHeadersForItemsGetRequest($page_number, $page_size, $location_id, $skus, $customer_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\PromotionHeadersByItem[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\PromotionHeadersByItem[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\PromotionHeadersByItem[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1PromotionHeadersGetPromotionHeadersForItemsGetAsync
     *
     * Returns an array of Promotion Headers that could fire for the supplied item.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $location_id (optional)
     * @param  string[]|null $skus (optional)
     * @param  int|null $customer_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1PromotionHeadersGetPromotionHeadersForItemsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1PromotionHeadersGetPromotionHeadersForItemsGetAsync($page_number = null, $page_size = null, $location_id = null, $skus = null, $customer_id = null, string $contentType = self::contentTypes['apiV1PromotionHeadersGetPromotionHeadersForItemsGet'][0])
    {
        return $this->apiV1PromotionHeadersGetPromotionHeadersForItemsGetAsyncWithHttpInfo($page_number, $page_size, $location_id, $skus, $customer_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1PromotionHeadersGetPromotionHeadersForItemsGetAsyncWithHttpInfo
     *
     * Returns an array of Promotion Headers that could fire for the supplied item.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $location_id (optional)
     * @param  string[]|null $skus (optional)
     * @param  int|null $customer_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1PromotionHeadersGetPromotionHeadersForItemsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1PromotionHeadersGetPromotionHeadersForItemsGetAsyncWithHttpInfo($page_number = null, $page_size = null, $location_id = null, $skus = null, $customer_id = null, string $contentType = self::contentTypes['apiV1PromotionHeadersGetPromotionHeadersForItemsGet'][0])
    {
        $returnType = '\Opsuite2\Model\PromotionHeadersByItem[]';
        $request = $this->apiV1PromotionHeadersGetPromotionHeadersForItemsGetRequest($page_number, $page_size, $location_id, $skus, $customer_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1PromotionHeadersGetPromotionHeadersForItemsGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $location_id (optional)
     * @param  string[]|null $skus (optional)
     * @param  int|null $customer_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1PromotionHeadersGetPromotionHeadersForItemsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1PromotionHeadersGetPromotionHeadersForItemsGetRequest($page_number = null, $page_size = null, $location_id = null, $skus = null, $customer_id = null, string $contentType = self::contentTypes['apiV1PromotionHeadersGetPromotionHeadersForItemsGet'][0])
    {







        $resourcePath = '/api/v1/PromotionHeaders/GetPromotionHeadersForItems';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $location_id,
            'locationId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $skus,
            'skus', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $customer_id,
            'customerId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPromotionHeaderById
     *
     * Returns a single PromotionHeader with the specified id.
     *
     * @param  int $promotion_id promotion_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPromotionHeaderById'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\PromotionHeader|string
     */
    public function getPromotionHeaderById($promotion_id, string $contentType = self::contentTypes['getPromotionHeaderById'][0])
    {
        list($response) = $this->getPromotionHeaderByIdWithHttpInfo($promotion_id, $contentType);
        return $response;
    }

    /**
     * Operation getPromotionHeaderByIdWithHttpInfo
     *
     * Returns a single PromotionHeader with the specified id.
     *
     * @param  int $promotion_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPromotionHeaderById'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\PromotionHeader|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPromotionHeaderByIdWithHttpInfo($promotion_id, string $contentType = self::contentTypes['getPromotionHeaderById'][0])
    {
        $request = $this->getPromotionHeaderByIdRequest($promotion_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\PromotionHeader',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\PromotionHeader',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\PromotionHeader',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getPromotionHeaderByIdAsync
     *
     * Returns a single PromotionHeader with the specified id.
     *
     * @param  int $promotion_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPromotionHeaderById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPromotionHeaderByIdAsync($promotion_id, string $contentType = self::contentTypes['getPromotionHeaderById'][0])
    {
        return $this->getPromotionHeaderByIdAsyncWithHttpInfo($promotion_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPromotionHeaderByIdAsyncWithHttpInfo
     *
     * Returns a single PromotionHeader with the specified id.
     *
     * @param  int $promotion_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPromotionHeaderById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPromotionHeaderByIdAsyncWithHttpInfo($promotion_id, string $contentType = self::contentTypes['getPromotionHeaderById'][0])
    {
        $returnType = '\Opsuite2\Model\PromotionHeader';
        $request = $this->getPromotionHeaderByIdRequest($promotion_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPromotionHeaderById'
     *
     * @param  int $promotion_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPromotionHeaderById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPromotionHeaderByIdRequest($promotion_id, string $contentType = self::contentTypes['getPromotionHeaderById'][0])
    {

        // verify the required parameter 'promotion_id' is set
        if ($promotion_id === null || (is_array($promotion_id) && count($promotion_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $promotion_id when calling getPromotionHeaderById'
            );
        }
        if ($promotion_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$promotion_id" when calling PromotionHeadersApi.getPromotionHeaderById, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v1/PromotionHeaders/{promotionId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($promotion_id !== null) {
            $resourcePath = str_replace(
                '{' . 'promotionId' . '}',
                ObjectSerializer::toPathValue($promotion_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
