<?php
/**
 * LoyaltyCardsApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Opsuite2\ApiException;
use Opsuite2\Configuration;
use Opsuite2\FormDataProcessor;
use Opsuite2\HeaderSelector;
use Opsuite2\ObjectSerializer;

/**
 * LoyaltyCardsApi Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class LoyaltyCardsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV1LoyaltyCardsCreateLoyaltyCardPost' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'apiV1LoyaltyCardsGetLoyaltyCardByNumberGet' => [
            'application/json',
        ],
        'apiV1LoyaltyCardsLoyaltyCardIdPatch' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'getLoyaltyCardById' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV1LoyaltyCardsCreateLoyaltyCardPost
     *
     * Creates a loyalty card
     *
     * @param  \Opsuite2\Model\LoyaltyCard|null $loyalty_card loyalty_card (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1LoyaltyCardsCreateLoyaltyCardPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\LoyaltyCard|string|string
     */
    public function apiV1LoyaltyCardsCreateLoyaltyCardPost($loyalty_card = null, string $contentType = self::contentTypes['apiV1LoyaltyCardsCreateLoyaltyCardPost'][0])
    {
        list($response) = $this->apiV1LoyaltyCardsCreateLoyaltyCardPostWithHttpInfo($loyalty_card, $contentType);
        return $response;
    }

    /**
     * Operation apiV1LoyaltyCardsCreateLoyaltyCardPostWithHttpInfo
     *
     * Creates a loyalty card
     *
     * @param  \Opsuite2\Model\LoyaltyCard|null $loyalty_card (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1LoyaltyCardsCreateLoyaltyCardPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\LoyaltyCard|string|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1LoyaltyCardsCreateLoyaltyCardPostWithHttpInfo($loyalty_card = null, string $contentType = self::contentTypes['apiV1LoyaltyCardsCreateLoyaltyCardPost'][0])
    {
        $request = $this->apiV1LoyaltyCardsCreateLoyaltyCardPostRequest($loyalty_card, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\LoyaltyCard',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\LoyaltyCard',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\LoyaltyCard',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1LoyaltyCardsCreateLoyaltyCardPostAsync
     *
     * Creates a loyalty card
     *
     * @param  \Opsuite2\Model\LoyaltyCard|null $loyalty_card (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1LoyaltyCardsCreateLoyaltyCardPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1LoyaltyCardsCreateLoyaltyCardPostAsync($loyalty_card = null, string $contentType = self::contentTypes['apiV1LoyaltyCardsCreateLoyaltyCardPost'][0])
    {
        return $this->apiV1LoyaltyCardsCreateLoyaltyCardPostAsyncWithHttpInfo($loyalty_card, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1LoyaltyCardsCreateLoyaltyCardPostAsyncWithHttpInfo
     *
     * Creates a loyalty card
     *
     * @param  \Opsuite2\Model\LoyaltyCard|null $loyalty_card (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1LoyaltyCardsCreateLoyaltyCardPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1LoyaltyCardsCreateLoyaltyCardPostAsyncWithHttpInfo($loyalty_card = null, string $contentType = self::contentTypes['apiV1LoyaltyCardsCreateLoyaltyCardPost'][0])
    {
        $returnType = '\Opsuite2\Model\LoyaltyCard';
        $request = $this->apiV1LoyaltyCardsCreateLoyaltyCardPostRequest($loyalty_card, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1LoyaltyCardsCreateLoyaltyCardPost'
     *
     * @param  \Opsuite2\Model\LoyaltyCard|null $loyalty_card (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1LoyaltyCardsCreateLoyaltyCardPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1LoyaltyCardsCreateLoyaltyCardPostRequest($loyalty_card = null, string $contentType = self::contentTypes['apiV1LoyaltyCardsCreateLoyaltyCardPost'][0])
    {



        $resourcePath = '/api/v1/LoyaltyCards/CreateLoyaltyCard';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($loyalty_card)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($loyalty_card));
            } else {
                $httpBody = $loyalty_card;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1LoyaltyCardsGetLoyaltyCardByNumberGet
     *
     * Returns a single LoyaltyCard with the specified number.
     *
     * @param  string|null $card_number card_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1LoyaltyCardsGetLoyaltyCardByNumberGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\LoyaltyCard|string
     */
    public function apiV1LoyaltyCardsGetLoyaltyCardByNumberGet($card_number = null, string $contentType = self::contentTypes['apiV1LoyaltyCardsGetLoyaltyCardByNumberGet'][0])
    {
        list($response) = $this->apiV1LoyaltyCardsGetLoyaltyCardByNumberGetWithHttpInfo($card_number, $contentType);
        return $response;
    }

    /**
     * Operation apiV1LoyaltyCardsGetLoyaltyCardByNumberGetWithHttpInfo
     *
     * Returns a single LoyaltyCard with the specified number.
     *
     * @param  string|null $card_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1LoyaltyCardsGetLoyaltyCardByNumberGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\LoyaltyCard|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1LoyaltyCardsGetLoyaltyCardByNumberGetWithHttpInfo($card_number = null, string $contentType = self::contentTypes['apiV1LoyaltyCardsGetLoyaltyCardByNumberGet'][0])
    {
        $request = $this->apiV1LoyaltyCardsGetLoyaltyCardByNumberGetRequest($card_number, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\LoyaltyCard',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\LoyaltyCard',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\LoyaltyCard',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1LoyaltyCardsGetLoyaltyCardByNumberGetAsync
     *
     * Returns a single LoyaltyCard with the specified number.
     *
     * @param  string|null $card_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1LoyaltyCardsGetLoyaltyCardByNumberGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1LoyaltyCardsGetLoyaltyCardByNumberGetAsync($card_number = null, string $contentType = self::contentTypes['apiV1LoyaltyCardsGetLoyaltyCardByNumberGet'][0])
    {
        return $this->apiV1LoyaltyCardsGetLoyaltyCardByNumberGetAsyncWithHttpInfo($card_number, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1LoyaltyCardsGetLoyaltyCardByNumberGetAsyncWithHttpInfo
     *
     * Returns a single LoyaltyCard with the specified number.
     *
     * @param  string|null $card_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1LoyaltyCardsGetLoyaltyCardByNumberGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1LoyaltyCardsGetLoyaltyCardByNumberGetAsyncWithHttpInfo($card_number = null, string $contentType = self::contentTypes['apiV1LoyaltyCardsGetLoyaltyCardByNumberGet'][0])
    {
        $returnType = '\Opsuite2\Model\LoyaltyCard';
        $request = $this->apiV1LoyaltyCardsGetLoyaltyCardByNumberGetRequest($card_number, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1LoyaltyCardsGetLoyaltyCardByNumberGet'
     *
     * @param  string|null $card_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1LoyaltyCardsGetLoyaltyCardByNumberGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1LoyaltyCardsGetLoyaltyCardByNumberGetRequest($card_number = null, string $contentType = self::contentTypes['apiV1LoyaltyCardsGetLoyaltyCardByNumberGet'][0])
    {



        $resourcePath = '/api/v1/LoyaltyCards/GetLoyaltyCardByNumber';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $card_number,
            'cardNumber', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1LoyaltyCardsLoyaltyCardIdPatch
     *
     * Updates specified properties of a loyalty card.
     *
     * @param  int $loyalty_card_id loyalty_card_id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1LoyaltyCardsLoyaltyCardIdPatch'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function apiV1LoyaltyCardsLoyaltyCardIdPatch($loyalty_card_id, $patch = null, string $contentType = self::contentTypes['apiV1LoyaltyCardsLoyaltyCardIdPatch'][0])
    {
        $this->apiV1LoyaltyCardsLoyaltyCardIdPatchWithHttpInfo($loyalty_card_id, $patch, $contentType);
    }

    /**
     * Operation apiV1LoyaltyCardsLoyaltyCardIdPatchWithHttpInfo
     *
     * Updates specified properties of a loyalty card.
     *
     * @param  int $loyalty_card_id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1LoyaltyCardsLoyaltyCardIdPatch'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1LoyaltyCardsLoyaltyCardIdPatchWithHttpInfo($loyalty_card_id, $patch = null, string $contentType = self::contentTypes['apiV1LoyaltyCardsLoyaltyCardIdPatch'][0])
    {
        $request = $this->apiV1LoyaltyCardsLoyaltyCardIdPatchRequest($loyalty_card_id, $patch, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1LoyaltyCardsLoyaltyCardIdPatchAsync
     *
     * Updates specified properties of a loyalty card.
     *
     * @param  int $loyalty_card_id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1LoyaltyCardsLoyaltyCardIdPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1LoyaltyCardsLoyaltyCardIdPatchAsync($loyalty_card_id, $patch = null, string $contentType = self::contentTypes['apiV1LoyaltyCardsLoyaltyCardIdPatch'][0])
    {
        return $this->apiV1LoyaltyCardsLoyaltyCardIdPatchAsyncWithHttpInfo($loyalty_card_id, $patch, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1LoyaltyCardsLoyaltyCardIdPatchAsyncWithHttpInfo
     *
     * Updates specified properties of a loyalty card.
     *
     * @param  int $loyalty_card_id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1LoyaltyCardsLoyaltyCardIdPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1LoyaltyCardsLoyaltyCardIdPatchAsyncWithHttpInfo($loyalty_card_id, $patch = null, string $contentType = self::contentTypes['apiV1LoyaltyCardsLoyaltyCardIdPatch'][0])
    {
        $returnType = '';
        $request = $this->apiV1LoyaltyCardsLoyaltyCardIdPatchRequest($loyalty_card_id, $patch, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1LoyaltyCardsLoyaltyCardIdPatch'
     *
     * @param  int $loyalty_card_id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1LoyaltyCardsLoyaltyCardIdPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1LoyaltyCardsLoyaltyCardIdPatchRequest($loyalty_card_id, $patch = null, string $contentType = self::contentTypes['apiV1LoyaltyCardsLoyaltyCardIdPatch'][0])
    {

        // verify the required parameter 'loyalty_card_id' is set
        if ($loyalty_card_id === null || (is_array($loyalty_card_id) && count($loyalty_card_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $loyalty_card_id when calling apiV1LoyaltyCardsLoyaltyCardIdPatch'
            );
        }
        if ($loyalty_card_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$loyalty_card_id" when calling LoyaltyCardsApi.apiV1LoyaltyCardsLoyaltyCardIdPatch, must be bigger than or equal to 1.');
        }
        


        $resourcePath = '/api/v1/LoyaltyCards/{loyaltyCardId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($loyalty_card_id !== null) {
            $resourcePath = str_replace(
                '{' . 'loyaltyCardId' . '}',
                ObjectSerializer::toPathValue($loyalty_card_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($patch)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($patch));
            } else {
                $httpBody = $patch;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getLoyaltyCardById
     *
     * Returns a single LoyaltyCard with the specified id.
     *
     * @param  int $loyalty_card_id loyalty_card_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLoyaltyCardById'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\LoyaltyCard|string
     */
    public function getLoyaltyCardById($loyalty_card_id, string $contentType = self::contentTypes['getLoyaltyCardById'][0])
    {
        list($response) = $this->getLoyaltyCardByIdWithHttpInfo($loyalty_card_id, $contentType);
        return $response;
    }

    /**
     * Operation getLoyaltyCardByIdWithHttpInfo
     *
     * Returns a single LoyaltyCard with the specified id.
     *
     * @param  int $loyalty_card_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLoyaltyCardById'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\LoyaltyCard|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getLoyaltyCardByIdWithHttpInfo($loyalty_card_id, string $contentType = self::contentTypes['getLoyaltyCardById'][0])
    {
        $request = $this->getLoyaltyCardByIdRequest($loyalty_card_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\LoyaltyCard',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\LoyaltyCard',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\LoyaltyCard',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getLoyaltyCardByIdAsync
     *
     * Returns a single LoyaltyCard with the specified id.
     *
     * @param  int $loyalty_card_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLoyaltyCardById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLoyaltyCardByIdAsync($loyalty_card_id, string $contentType = self::contentTypes['getLoyaltyCardById'][0])
    {
        return $this->getLoyaltyCardByIdAsyncWithHttpInfo($loyalty_card_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getLoyaltyCardByIdAsyncWithHttpInfo
     *
     * Returns a single LoyaltyCard with the specified id.
     *
     * @param  int $loyalty_card_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLoyaltyCardById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLoyaltyCardByIdAsyncWithHttpInfo($loyalty_card_id, string $contentType = self::contentTypes['getLoyaltyCardById'][0])
    {
        $returnType = '\Opsuite2\Model\LoyaltyCard';
        $request = $this->getLoyaltyCardByIdRequest($loyalty_card_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getLoyaltyCardById'
     *
     * @param  int $loyalty_card_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLoyaltyCardById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getLoyaltyCardByIdRequest($loyalty_card_id, string $contentType = self::contentTypes['getLoyaltyCardById'][0])
    {

        // verify the required parameter 'loyalty_card_id' is set
        if ($loyalty_card_id === null || (is_array($loyalty_card_id) && count($loyalty_card_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $loyalty_card_id when calling getLoyaltyCardById'
            );
        }
        if ($loyalty_card_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$loyalty_card_id" when calling LoyaltyCardsApi.getLoyaltyCardById, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v1/LoyaltyCards/{loyaltyCardId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($loyalty_card_id !== null) {
            $resourcePath = str_replace(
                '{' . 'loyaltyCardId' . '}',
                ObjectSerializer::toPathValue($loyalty_card_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
