<?php
/**
 * ItemMastersApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Opsuite2\ApiException;
use Opsuite2\Configuration;
use Opsuite2\FormDataProcessor;
use Opsuite2\HeaderSelector;
use Opsuite2\ObjectSerializer;

/**
 * ItemMastersApi Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ItemMastersApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV1ItemMastersGet' => [
            'application/json',
        ],
        'apiV1ItemMastersGetItemMasterBySkuGet' => [
            'application/json',
        ],
        'apiV1ItemMastersPatchMultipleItemMastersPatch' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'apiV1ItemMastersPost' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'apiV1ItemMastersPostMultipleItemMastersPost' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'getItemMasterById' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV1ItemMastersGet
     *
     * Returns an array of ItemMasters that match the specified search criteria.
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  int|null $item_type_id item_type_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMastersGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemMaster[]|string
     */
    public function apiV1ItemMastersGet($page_number = null, $page_size = null, $item_type_id = null, string $contentType = self::contentTypes['apiV1ItemMastersGet'][0])
    {
        list($response) = $this->apiV1ItemMastersGetWithHttpInfo($page_number, $page_size, $item_type_id, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ItemMastersGetWithHttpInfo
     *
     * Returns an array of ItemMasters that match the specified search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $item_type_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMastersGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemMaster[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ItemMastersGetWithHttpInfo($page_number = null, $page_size = null, $item_type_id = null, string $contentType = self::contentTypes['apiV1ItemMastersGet'][0])
    {
        $request = $this->apiV1ItemMastersGetRequest($page_number, $page_size, $item_type_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemMaster[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemMaster[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemMaster[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ItemMastersGetAsync
     *
     * Returns an array of ItemMasters that match the specified search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $item_type_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMastersGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemMastersGetAsync($page_number = null, $page_size = null, $item_type_id = null, string $contentType = self::contentTypes['apiV1ItemMastersGet'][0])
    {
        return $this->apiV1ItemMastersGetAsyncWithHttpInfo($page_number, $page_size, $item_type_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ItemMastersGetAsyncWithHttpInfo
     *
     * Returns an array of ItemMasters that match the specified search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $item_type_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMastersGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemMastersGetAsyncWithHttpInfo($page_number = null, $page_size = null, $item_type_id = null, string $contentType = self::contentTypes['apiV1ItemMastersGet'][0])
    {
        $returnType = '\Opsuite2\Model\ItemMaster[]';
        $request = $this->apiV1ItemMastersGetRequest($page_number, $page_size, $item_type_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ItemMastersGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $item_type_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMastersGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ItemMastersGetRequest($page_number = null, $page_size = null, $item_type_id = null, string $contentType = self::contentTypes['apiV1ItemMastersGet'][0])
    {





        $resourcePath = '/api/v1/ItemMasters';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $item_type_id,
            'ItemTypeId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ItemMastersGetItemMasterBySkuGet
     *
     * Returns a single ItemMaster with the specified sku.
     *
     * @param  string|null $sku sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMastersGetItemMasterBySkuGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemMaster|string
     */
    public function apiV1ItemMastersGetItemMasterBySkuGet($sku = null, string $contentType = self::contentTypes['apiV1ItemMastersGetItemMasterBySkuGet'][0])
    {
        list($response) = $this->apiV1ItemMastersGetItemMasterBySkuGetWithHttpInfo($sku, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ItemMastersGetItemMasterBySkuGetWithHttpInfo
     *
     * Returns a single ItemMaster with the specified sku.
     *
     * @param  string|null $sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMastersGetItemMasterBySkuGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemMaster|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ItemMastersGetItemMasterBySkuGetWithHttpInfo($sku = null, string $contentType = self::contentTypes['apiV1ItemMastersGetItemMasterBySkuGet'][0])
    {
        $request = $this->apiV1ItemMastersGetItemMasterBySkuGetRequest($sku, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemMaster',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemMaster',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemMaster',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ItemMastersGetItemMasterBySkuGetAsync
     *
     * Returns a single ItemMaster with the specified sku.
     *
     * @param  string|null $sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMastersGetItemMasterBySkuGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemMastersGetItemMasterBySkuGetAsync($sku = null, string $contentType = self::contentTypes['apiV1ItemMastersGetItemMasterBySkuGet'][0])
    {
        return $this->apiV1ItemMastersGetItemMasterBySkuGetAsyncWithHttpInfo($sku, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ItemMastersGetItemMasterBySkuGetAsyncWithHttpInfo
     *
     * Returns a single ItemMaster with the specified sku.
     *
     * @param  string|null $sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMastersGetItemMasterBySkuGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemMastersGetItemMasterBySkuGetAsyncWithHttpInfo($sku = null, string $contentType = self::contentTypes['apiV1ItemMastersGetItemMasterBySkuGet'][0])
    {
        $returnType = '\Opsuite2\Model\ItemMaster';
        $request = $this->apiV1ItemMastersGetItemMasterBySkuGetRequest($sku, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ItemMastersGetItemMasterBySkuGet'
     *
     * @param  string|null $sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMastersGetItemMasterBySkuGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ItemMastersGetItemMasterBySkuGetRequest($sku = null, string $contentType = self::contentTypes['apiV1ItemMastersGetItemMasterBySkuGet'][0])
    {



        $resourcePath = '/api/v1/ItemMasters/GetItemMasterBySku';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sku,
            'sku', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ItemMastersPatchMultipleItemMastersPatch
     *
     * Updates specified properties of multiple item masters.
     *
     * @param  \Opsuite2\Model\PatchCollection[]|null $patch_collection patch_collection (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMastersPatchMultipleItemMastersPatch'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\PatchResponse[]|string
     */
    public function apiV1ItemMastersPatchMultipleItemMastersPatch($patch_collection = null, string $contentType = self::contentTypes['apiV1ItemMastersPatchMultipleItemMastersPatch'][0])
    {
        list($response) = $this->apiV1ItemMastersPatchMultipleItemMastersPatchWithHttpInfo($patch_collection, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ItemMastersPatchMultipleItemMastersPatchWithHttpInfo
     *
     * Updates specified properties of multiple item masters.
     *
     * @param  \Opsuite2\Model\PatchCollection[]|null $patch_collection (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMastersPatchMultipleItemMastersPatch'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\PatchResponse[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ItemMastersPatchMultipleItemMastersPatchWithHttpInfo($patch_collection = null, string $contentType = self::contentTypes['apiV1ItemMastersPatchMultipleItemMastersPatch'][0])
    {
        $request = $this->apiV1ItemMastersPatchMultipleItemMastersPatchRequest($patch_collection, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 202:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\PatchResponse[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\PatchResponse[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 202:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\PatchResponse[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ItemMastersPatchMultipleItemMastersPatchAsync
     *
     * Updates specified properties of multiple item masters.
     *
     * @param  \Opsuite2\Model\PatchCollection[]|null $patch_collection (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMastersPatchMultipleItemMastersPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemMastersPatchMultipleItemMastersPatchAsync($patch_collection = null, string $contentType = self::contentTypes['apiV1ItemMastersPatchMultipleItemMastersPatch'][0])
    {
        return $this->apiV1ItemMastersPatchMultipleItemMastersPatchAsyncWithHttpInfo($patch_collection, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ItemMastersPatchMultipleItemMastersPatchAsyncWithHttpInfo
     *
     * Updates specified properties of multiple item masters.
     *
     * @param  \Opsuite2\Model\PatchCollection[]|null $patch_collection (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMastersPatchMultipleItemMastersPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemMastersPatchMultipleItemMastersPatchAsyncWithHttpInfo($patch_collection = null, string $contentType = self::contentTypes['apiV1ItemMastersPatchMultipleItemMastersPatch'][0])
    {
        $returnType = '\Opsuite2\Model\PatchResponse[]';
        $request = $this->apiV1ItemMastersPatchMultipleItemMastersPatchRequest($patch_collection, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ItemMastersPatchMultipleItemMastersPatch'
     *
     * @param  \Opsuite2\Model\PatchCollection[]|null $patch_collection (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMastersPatchMultipleItemMastersPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ItemMastersPatchMultipleItemMastersPatchRequest($patch_collection = null, string $contentType = self::contentTypes['apiV1ItemMastersPatchMultipleItemMastersPatch'][0])
    {



        $resourcePath = '/api/v1/ItemMasters/PatchMultipleItemMasters';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($patch_collection)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($patch_collection));
            } else {
                $httpBody = $patch_collection;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ItemMastersPost
     *
     * Creates a new item master.
     *
     * @param  \Opsuite2\Model\ItemMaster|null $item_master item_master (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMastersPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemMaster|string|string
     */
    public function apiV1ItemMastersPost($item_master = null, string $contentType = self::contentTypes['apiV1ItemMastersPost'][0])
    {
        list($response) = $this->apiV1ItemMastersPostWithHttpInfo($item_master, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ItemMastersPostWithHttpInfo
     *
     * Creates a new item master.
     *
     * @param  \Opsuite2\Model\ItemMaster|null $item_master (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMastersPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemMaster|string|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ItemMastersPostWithHttpInfo($item_master = null, string $contentType = self::contentTypes['apiV1ItemMastersPost'][0])
    {
        $request = $this->apiV1ItemMastersPostRequest($item_master, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemMaster',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemMaster',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemMaster',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ItemMastersPostAsync
     *
     * Creates a new item master.
     *
     * @param  \Opsuite2\Model\ItemMaster|null $item_master (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMastersPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemMastersPostAsync($item_master = null, string $contentType = self::contentTypes['apiV1ItemMastersPost'][0])
    {
        return $this->apiV1ItemMastersPostAsyncWithHttpInfo($item_master, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ItemMastersPostAsyncWithHttpInfo
     *
     * Creates a new item master.
     *
     * @param  \Opsuite2\Model\ItemMaster|null $item_master (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMastersPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemMastersPostAsyncWithHttpInfo($item_master = null, string $contentType = self::contentTypes['apiV1ItemMastersPost'][0])
    {
        $returnType = '\Opsuite2\Model\ItemMaster';
        $request = $this->apiV1ItemMastersPostRequest($item_master, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ItemMastersPost'
     *
     * @param  \Opsuite2\Model\ItemMaster|null $item_master (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMastersPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ItemMastersPostRequest($item_master = null, string $contentType = self::contentTypes['apiV1ItemMastersPost'][0])
    {



        $resourcePath = '/api/v1/ItemMasters';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($item_master)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($item_master));
            } else {
                $httpBody = $item_master;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ItemMastersPostMultipleItemMastersPost
     *
     * Creates multiple new item masters.
     *
     * @param  \Opsuite2\Model\ItemMaster[]|null $item_master item_master (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMastersPostMultipleItemMastersPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\PostResponseItemMaster[]|string
     */
    public function apiV1ItemMastersPostMultipleItemMastersPost($item_master = null, string $contentType = self::contentTypes['apiV1ItemMastersPostMultipleItemMastersPost'][0])
    {
        list($response) = $this->apiV1ItemMastersPostMultipleItemMastersPostWithHttpInfo($item_master, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ItemMastersPostMultipleItemMastersPostWithHttpInfo
     *
     * Creates multiple new item masters.
     *
     * @param  \Opsuite2\Model\ItemMaster[]|null $item_master (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMastersPostMultipleItemMastersPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\PostResponseItemMaster[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ItemMastersPostMultipleItemMastersPostWithHttpInfo($item_master = null, string $contentType = self::contentTypes['apiV1ItemMastersPostMultipleItemMastersPost'][0])
    {
        $request = $this->apiV1ItemMastersPostMultipleItemMastersPostRequest($item_master, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\PostResponseItemMaster[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\PostResponseItemMaster[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\PostResponseItemMaster[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ItemMastersPostMultipleItemMastersPostAsync
     *
     * Creates multiple new item masters.
     *
     * @param  \Opsuite2\Model\ItemMaster[]|null $item_master (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMastersPostMultipleItemMastersPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemMastersPostMultipleItemMastersPostAsync($item_master = null, string $contentType = self::contentTypes['apiV1ItemMastersPostMultipleItemMastersPost'][0])
    {
        return $this->apiV1ItemMastersPostMultipleItemMastersPostAsyncWithHttpInfo($item_master, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ItemMastersPostMultipleItemMastersPostAsyncWithHttpInfo
     *
     * Creates multiple new item masters.
     *
     * @param  \Opsuite2\Model\ItemMaster[]|null $item_master (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMastersPostMultipleItemMastersPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemMastersPostMultipleItemMastersPostAsyncWithHttpInfo($item_master = null, string $contentType = self::contentTypes['apiV1ItemMastersPostMultipleItemMastersPost'][0])
    {
        $returnType = '\Opsuite2\Model\PostResponseItemMaster[]';
        $request = $this->apiV1ItemMastersPostMultipleItemMastersPostRequest($item_master, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ItemMastersPostMultipleItemMastersPost'
     *
     * @param  \Opsuite2\Model\ItemMaster[]|null $item_master (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMastersPostMultipleItemMastersPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ItemMastersPostMultipleItemMastersPostRequest($item_master = null, string $contentType = self::contentTypes['apiV1ItemMastersPostMultipleItemMastersPost'][0])
    {



        $resourcePath = '/api/v1/ItemMasters/PostMultipleItemMasters';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($item_master)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($item_master));
            } else {
                $httpBody = $item_master;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getItemMasterById
     *
     * Returns a single ItemMaster with the specified id.
     *
     * @param  int $item_master_id item_master_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getItemMasterById'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemMaster|string
     */
    public function getItemMasterById($item_master_id, string $contentType = self::contentTypes['getItemMasterById'][0])
    {
        list($response) = $this->getItemMasterByIdWithHttpInfo($item_master_id, $contentType);
        return $response;
    }

    /**
     * Operation getItemMasterByIdWithHttpInfo
     *
     * Returns a single ItemMaster with the specified id.
     *
     * @param  int $item_master_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getItemMasterById'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemMaster|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getItemMasterByIdWithHttpInfo($item_master_id, string $contentType = self::contentTypes['getItemMasterById'][0])
    {
        $request = $this->getItemMasterByIdRequest($item_master_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemMaster',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemMaster',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemMaster',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getItemMasterByIdAsync
     *
     * Returns a single ItemMaster with the specified id.
     *
     * @param  int $item_master_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getItemMasterById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getItemMasterByIdAsync($item_master_id, string $contentType = self::contentTypes['getItemMasterById'][0])
    {
        return $this->getItemMasterByIdAsyncWithHttpInfo($item_master_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getItemMasterByIdAsyncWithHttpInfo
     *
     * Returns a single ItemMaster with the specified id.
     *
     * @param  int $item_master_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getItemMasterById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getItemMasterByIdAsyncWithHttpInfo($item_master_id, string $contentType = self::contentTypes['getItemMasterById'][0])
    {
        $returnType = '\Opsuite2\Model\ItemMaster';
        $request = $this->getItemMasterByIdRequest($item_master_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getItemMasterById'
     *
     * @param  int $item_master_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getItemMasterById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getItemMasterByIdRequest($item_master_id, string $contentType = self::contentTypes['getItemMasterById'][0])
    {

        // verify the required parameter 'item_master_id' is set
        if ($item_master_id === null || (is_array($item_master_id) && count($item_master_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $item_master_id when calling getItemMasterById'
            );
        }
        if ($item_master_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$item_master_id" when calling ItemMastersApi.getItemMasterById, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v1/ItemMasters/{itemMasterId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($item_master_id !== null) {
            $resourcePath = str_replace(
                '{' . 'itemMasterId' . '}',
                ObjectSerializer::toPathValue($item_master_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
