<?php
/**
 * ItemMasterAttributesApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Opsuite2\ApiException;
use Opsuite2\Configuration;
use Opsuite2\FormDataProcessor;
use Opsuite2\HeaderSelector;
use Opsuite2\ObjectSerializer;

/**
 * ItemMasterAttributesApi Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ItemMasterAttributesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGet' => [
            'application/json',
        ],
        'apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGet' => [
            'application/json',
        ],
        'apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGet' => [
            'application/json',
        ],
        'apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGet' => [
            'application/json',
        ],
        'getItemMasterAttributesById' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGet
     *
     * Returns the list of item master attribute groups.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\AttributeGroupItemMasterAttribute[]|string
     */
    public function apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGet(string $contentType = self::contentTypes['apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGet'][0])
    {
        list($response) = $this->apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGetWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGetWithHttpInfo
     *
     * Returns the list of item master attribute groups.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\AttributeGroupItemMasterAttribute[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGetWithHttpInfo(string $contentType = self::contentTypes['apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGet'][0])
    {
        $request = $this->apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGetRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\AttributeGroupItemMasterAttribute[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\AttributeGroupItemMasterAttribute[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\AttributeGroupItemMasterAttribute[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGetAsync
     *
     * Returns the list of item master attribute groups.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGetAsync(string $contentType = self::contentTypes['apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGet'][0])
    {
        return $this->apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGetAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGetAsyncWithHttpInfo
     *
     * Returns the list of item master attribute groups.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGetAsyncWithHttpInfo(string $contentType = self::contentTypes['apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGet'][0])
    {
        $returnType = '\Opsuite2\Model\AttributeGroupItemMasterAttribute[]';
        $request = $this->apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGetRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGet'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGetRequest(string $contentType = self::contentTypes['apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGet'][0])
    {


        $resourcePath = '/api/v1/ItemMasterAttributes/GetItemMasterAttributeGroups';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGet
     *
     * Returns a list of attributes for the ItemMaster with the specified sku.
     *
     * @param  string|null $sku sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemMasterAttribute[]|string
     */
    public function apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGet($sku = null, string $contentType = self::contentTypes['apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGet'][0])
    {
        list($response) = $this->apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGetWithHttpInfo($sku, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGetWithHttpInfo
     *
     * Returns a list of attributes for the ItemMaster with the specified sku.
     *
     * @param  string|null $sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemMasterAttribute[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGetWithHttpInfo($sku = null, string $contentType = self::contentTypes['apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGet'][0])
    {
        $request = $this->apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGetRequest($sku, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemMasterAttribute[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemMasterAttribute[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemMasterAttribute[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGetAsync
     *
     * Returns a list of attributes for the ItemMaster with the specified sku.
     *
     * @param  string|null $sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGetAsync($sku = null, string $contentType = self::contentTypes['apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGet'][0])
    {
        return $this->apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGetAsyncWithHttpInfo($sku, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGetAsyncWithHttpInfo
     *
     * Returns a list of attributes for the ItemMaster with the specified sku.
     *
     * @param  string|null $sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGetAsyncWithHttpInfo($sku = null, string $contentType = self::contentTypes['apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGet'][0])
    {
        $returnType = '\Opsuite2\Model\ItemMasterAttribute[]';
        $request = $this->apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGetRequest($sku, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGet'
     *
     * @param  string|null $sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGetRequest($sku = null, string $contentType = self::contentTypes['apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGet'][0])
    {



        $resourcePath = '/api/v1/ItemMasterAttributes/GetItemMasterAttributesBySku';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sku,
            'sku', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGet
     *
     * Returns a list item masters with attributes for the ItemMaster with the specified ids.
     *
     * @param  int[]|null $ids ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemMasterWithAttributes[]|string
     */
    public function apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGet($ids = null, string $contentType = self::contentTypes['apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGet'][0])
    {
        list($response) = $this->apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGetWithHttpInfo($ids, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGetWithHttpInfo
     *
     * Returns a list item masters with attributes for the ItemMaster with the specified ids.
     *
     * @param  int[]|null $ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemMasterWithAttributes[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGetWithHttpInfo($ids = null, string $contentType = self::contentTypes['apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGet'][0])
    {
        $request = $this->apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGetRequest($ids, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemMasterWithAttributes[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemMasterWithAttributes[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemMasterWithAttributes[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGetAsync
     *
     * Returns a list item masters with attributes for the ItemMaster with the specified ids.
     *
     * @param  int[]|null $ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGetAsync($ids = null, string $contentType = self::contentTypes['apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGet'][0])
    {
        return $this->apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGetAsyncWithHttpInfo($ids, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGetAsyncWithHttpInfo
     *
     * Returns a list item masters with attributes for the ItemMaster with the specified ids.
     *
     * @param  int[]|null $ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGetAsyncWithHttpInfo($ids = null, string $contentType = self::contentTypes['apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGet'][0])
    {
        $returnType = '\Opsuite2\Model\ItemMasterWithAttributes[]';
        $request = $this->apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGetRequest($ids, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGet'
     *
     * @param  int[]|null $ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGetRequest($ids = null, string $contentType = self::contentTypes['apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGet'][0])
    {



        $resourcePath = '/api/v1/ItemMasterAttributes/GetItemMastersWithAttributesByIds';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $ids,
            'ids', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGet
     *
     * Returns a list item masters with attributes for the ItemMaster with the specified skus.
     *
     * @param  string[]|null $skus skus (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemMasterWithAttributes[]|string
     */
    public function apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGet($skus = null, string $contentType = self::contentTypes['apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGet'][0])
    {
        list($response) = $this->apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGetWithHttpInfo($skus, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGetWithHttpInfo
     *
     * Returns a list item masters with attributes for the ItemMaster with the specified skus.
     *
     * @param  string[]|null $skus (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemMasterWithAttributes[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGetWithHttpInfo($skus = null, string $contentType = self::contentTypes['apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGet'][0])
    {
        $request = $this->apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGetRequest($skus, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemMasterWithAttributes[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemMasterWithAttributes[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemMasterWithAttributes[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGetAsync
     *
     * Returns a list item masters with attributes for the ItemMaster with the specified skus.
     *
     * @param  string[]|null $skus (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGetAsync($skus = null, string $contentType = self::contentTypes['apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGet'][0])
    {
        return $this->apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGetAsyncWithHttpInfo($skus, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGetAsyncWithHttpInfo
     *
     * Returns a list item masters with attributes for the ItemMaster with the specified skus.
     *
     * @param  string[]|null $skus (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGetAsyncWithHttpInfo($skus = null, string $contentType = self::contentTypes['apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGet'][0])
    {
        $returnType = '\Opsuite2\Model\ItemMasterWithAttributes[]';
        $request = $this->apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGetRequest($skus, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGet'
     *
     * @param  string[]|null $skus (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGetRequest($skus = null, string $contentType = self::contentTypes['apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGet'][0])
    {



        $resourcePath = '/api/v1/ItemMasterAttributes/GetItemMastersWithAttributesBySkus';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $skus,
            'skus', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getItemMasterAttributesById
     *
     * Returns a list of attributes for the ItemMaster with the specified id.
     *
     * @param  int $item_master_id item_master_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getItemMasterAttributesById'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemMasterAttribute[]|string
     */
    public function getItemMasterAttributesById($item_master_id, string $contentType = self::contentTypes['getItemMasterAttributesById'][0])
    {
        list($response) = $this->getItemMasterAttributesByIdWithHttpInfo($item_master_id, $contentType);
        return $response;
    }

    /**
     * Operation getItemMasterAttributesByIdWithHttpInfo
     *
     * Returns a list of attributes for the ItemMaster with the specified id.
     *
     * @param  int $item_master_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getItemMasterAttributesById'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemMasterAttribute[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getItemMasterAttributesByIdWithHttpInfo($item_master_id, string $contentType = self::contentTypes['getItemMasterAttributesById'][0])
    {
        $request = $this->getItemMasterAttributesByIdRequest($item_master_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemMasterAttribute[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemMasterAttribute[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemMasterAttribute[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getItemMasterAttributesByIdAsync
     *
     * Returns a list of attributes for the ItemMaster with the specified id.
     *
     * @param  int $item_master_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getItemMasterAttributesById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getItemMasterAttributesByIdAsync($item_master_id, string $contentType = self::contentTypes['getItemMasterAttributesById'][0])
    {
        return $this->getItemMasterAttributesByIdAsyncWithHttpInfo($item_master_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getItemMasterAttributesByIdAsyncWithHttpInfo
     *
     * Returns a list of attributes for the ItemMaster with the specified id.
     *
     * @param  int $item_master_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getItemMasterAttributesById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getItemMasterAttributesByIdAsyncWithHttpInfo($item_master_id, string $contentType = self::contentTypes['getItemMasterAttributesById'][0])
    {
        $returnType = '\Opsuite2\Model\ItemMasterAttribute[]';
        $request = $this->getItemMasterAttributesByIdRequest($item_master_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getItemMasterAttributesById'
     *
     * @param  int $item_master_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getItemMasterAttributesById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getItemMasterAttributesByIdRequest($item_master_id, string $contentType = self::contentTypes['getItemMasterAttributesById'][0])
    {

        // verify the required parameter 'item_master_id' is set
        if ($item_master_id === null || (is_array($item_master_id) && count($item_master_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $item_master_id when calling getItemMasterAttributesById'
            );
        }
        if ($item_master_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$item_master_id" when calling ItemMasterAttributesApi.getItemMasterAttributesById, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v1/ItemMasterAttributes/{itemMasterId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($item_master_id !== null) {
            $resourcePath = str_replace(
                '{' . 'itemMasterId' . '}',
                ObjectSerializer::toPathValue($item_master_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
