<?php
/**
 * ItemLocationDetailsApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Opsuite2\ApiException;
use Opsuite2\Configuration;
use Opsuite2\FormDataProcessor;
use Opsuite2\HeaderSelector;
use Opsuite2\ObjectSerializer;

/**
 * ItemLocationDetailsApi Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ItemLocationDetailsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGet' => [
            'application/json',
        ],
        'apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGet' => [
            'application/json',
        ],
        'apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGet' => [
            'application/json',
        ],
        'apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGet' => [
            'application/json',
        ],
        'apiV1ItemLocationDetailsGetItemLocationDetailsGet' => [
            'application/json',
        ],
        'apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGet' => [
            'application/json',
        ],
        'apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGet' => [
            'application/json',
        ],
        'apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatch' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPost' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGet
     *
     * Returns a single ItemLocationDetail with the specified LocationId and ItemMasterId
     *
     * @param  int|null $location_id location_id (optional)
     * @param  int|null $item_master_id item_master_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemLocationDetail|string
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGet($location_id = null, $item_master_id = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGet'][0])
    {
        list($response) = $this->apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGetWithHttpInfo($location_id, $item_master_id, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGetWithHttpInfo
     *
     * Returns a single ItemLocationDetail with the specified LocationId and ItemMasterId
     *
     * @param  int|null $location_id (optional)
     * @param  int|null $item_master_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemLocationDetail|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGetWithHttpInfo($location_id = null, $item_master_id = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGet'][0])
    {
        $request = $this->apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGetRequest($location_id, $item_master_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemLocationDetail',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemLocationDetail',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemLocationDetail',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGetAsync
     *
     * Returns a single ItemLocationDetail with the specified LocationId and ItemMasterId
     *
     * @param  int|null $location_id (optional)
     * @param  int|null $item_master_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGetAsync($location_id = null, $item_master_id = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGet'][0])
    {
        return $this->apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGetAsyncWithHttpInfo($location_id, $item_master_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGetAsyncWithHttpInfo
     *
     * Returns a single ItemLocationDetail with the specified LocationId and ItemMasterId
     *
     * @param  int|null $location_id (optional)
     * @param  int|null $item_master_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGetAsyncWithHttpInfo($location_id = null, $item_master_id = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGet'][0])
    {
        $returnType = '\Opsuite2\Model\ItemLocationDetail';
        $request = $this->apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGetRequest($location_id, $item_master_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGet'
     *
     * @param  int|null $location_id (optional)
     * @param  int|null $item_master_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGetRequest($location_id = null, $item_master_id = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGet'][0])
    {




        $resourcePath = '/api/v1/ItemLocationDetails/GetItemLocationDetailByLocationIdAndItemMasterId';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $location_id,
            'locationId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $item_master_id,
            'itemMasterId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGet
     *
     * Returns a single ItemLocationDetail with the specified LocationId and product code
     *
     * @param  int|null $location_id location_id (optional)
     * @param  string|null $product_code product_code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemLocationDetail|string
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGet($location_id = null, $product_code = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGet'][0])
    {
        list($response) = $this->apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGetWithHttpInfo($location_id, $product_code, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGetWithHttpInfo
     *
     * Returns a single ItemLocationDetail with the specified LocationId and product code
     *
     * @param  int|null $location_id (optional)
     * @param  string|null $product_code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemLocationDetail|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGetWithHttpInfo($location_id = null, $product_code = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGet'][0])
    {
        $request = $this->apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGetRequest($location_id, $product_code, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemLocationDetail',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemLocationDetail',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemLocationDetail',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGetAsync
     *
     * Returns a single ItemLocationDetail with the specified LocationId and product code
     *
     * @param  int|null $location_id (optional)
     * @param  string|null $product_code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGetAsync($location_id = null, $product_code = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGet'][0])
    {
        return $this->apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGetAsyncWithHttpInfo($location_id, $product_code, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGetAsyncWithHttpInfo
     *
     * Returns a single ItemLocationDetail with the specified LocationId and product code
     *
     * @param  int|null $location_id (optional)
     * @param  string|null $product_code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGetAsyncWithHttpInfo($location_id = null, $product_code = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGet'][0])
    {
        $returnType = '\Opsuite2\Model\ItemLocationDetail';
        $request = $this->apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGetRequest($location_id, $product_code, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGet'
     *
     * @param  int|null $location_id (optional)
     * @param  string|null $product_code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGetRequest($location_id = null, $product_code = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGet'][0])
    {




        $resourcePath = '/api/v1/ItemLocationDetails/GetItemLocationDetailByLocationIdAndProductCode';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $location_id,
            'locationId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $product_code,
            'productCode', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGet
     *
     * Returns a single ItemLocationDetail with the specified LocationId and sku
     *
     * @param  int|null $location_id location_id (optional)
     * @param  string|null $sku sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemLocationDetail|string
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGet($location_id = null, $sku = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGet'][0])
    {
        list($response) = $this->apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGetWithHttpInfo($location_id, $sku, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGetWithHttpInfo
     *
     * Returns a single ItemLocationDetail with the specified LocationId and sku
     *
     * @param  int|null $location_id (optional)
     * @param  string|null $sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemLocationDetail|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGetWithHttpInfo($location_id = null, $sku = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGet'][0])
    {
        $request = $this->apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGetRequest($location_id, $sku, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemLocationDetail',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemLocationDetail',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemLocationDetail',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGetAsync
     *
     * Returns a single ItemLocationDetail with the specified LocationId and sku
     *
     * @param  int|null $location_id (optional)
     * @param  string|null $sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGetAsync($location_id = null, $sku = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGet'][0])
    {
        return $this->apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGetAsyncWithHttpInfo($location_id, $sku, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGetAsyncWithHttpInfo
     *
     * Returns a single ItemLocationDetail with the specified LocationId and sku
     *
     * @param  int|null $location_id (optional)
     * @param  string|null $sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGetAsyncWithHttpInfo($location_id = null, $sku = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGet'][0])
    {
        $returnType = '\Opsuite2\Model\ItemLocationDetail';
        $request = $this->apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGetRequest($location_id, $sku, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGet'
     *
     * @param  int|null $location_id (optional)
     * @param  string|null $sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGetRequest($location_id = null, $sku = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGet'][0])
    {




        $resourcePath = '/api/v1/ItemLocationDetails/GetItemLocationDetailByLocationIdAndSku';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $location_id,
            'locationId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sku,
            'sku', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGet
     *
     * Returns a list ItemLocationDetails with the specified LocationId and skus
     *
     * @param  int|null $location_id location_id (optional)
     * @param  string[]|null $skus skus (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemLocationDetail[]|string
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGet($location_id = null, $skus = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGet'][0])
    {
        list($response) = $this->apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGetWithHttpInfo($location_id, $skus, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGetWithHttpInfo
     *
     * Returns a list ItemLocationDetails with the specified LocationId and skus
     *
     * @param  int|null $location_id (optional)
     * @param  string[]|null $skus (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemLocationDetail[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGetWithHttpInfo($location_id = null, $skus = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGet'][0])
    {
        $request = $this->apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGetRequest($location_id, $skus, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemLocationDetail[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemLocationDetail[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemLocationDetail[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGetAsync
     *
     * Returns a list ItemLocationDetails with the specified LocationId and skus
     *
     * @param  int|null $location_id (optional)
     * @param  string[]|null $skus (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGetAsync($location_id = null, $skus = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGet'][0])
    {
        return $this->apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGetAsyncWithHttpInfo($location_id, $skus, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGetAsyncWithHttpInfo
     *
     * Returns a list ItemLocationDetails with the specified LocationId and skus
     *
     * @param  int|null $location_id (optional)
     * @param  string[]|null $skus (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGetAsyncWithHttpInfo($location_id = null, $skus = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGet'][0])
    {
        $returnType = '\Opsuite2\Model\ItemLocationDetail[]';
        $request = $this->apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGetRequest($location_id, $skus, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGet'
     *
     * @param  int|null $location_id (optional)
     * @param  string[]|null $skus (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGetRequest($location_id = null, $skus = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGet'][0])
    {




        $resourcePath = '/api/v1/ItemLocationDetails/GetItemLocationDetailsByLocationIdAndSkuList';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $location_id,
            'locationId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $skus,
            'skus', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ItemLocationDetailsGetItemLocationDetailsGet
     *
     * Returns an array of ItemLocationDetails that match the specified search criteria  The last updated date and location id are required parameters
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  int|null $location_id location_id (optional)
     * @param  bool|null $web_item web_item (optional)
     * @param  \DateTime|null $last_updated last_updated (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemLocationDetail[]|string
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailsGet($page_number = null, $page_size = null, $location_id = null, $web_item = null, $last_updated = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsGet'][0])
    {
        list($response) = $this->apiV1ItemLocationDetailsGetItemLocationDetailsGetWithHttpInfo($page_number, $page_size, $location_id, $web_item, $last_updated, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ItemLocationDetailsGetItemLocationDetailsGetWithHttpInfo
     *
     * Returns an array of ItemLocationDetails that match the specified search criteria  The last updated date and location id are required parameters
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $location_id (optional)
     * @param  bool|null $web_item (optional)
     * @param  \DateTime|null $last_updated (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemLocationDetail[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailsGetWithHttpInfo($page_number = null, $page_size = null, $location_id = null, $web_item = null, $last_updated = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsGet'][0])
    {
        $request = $this->apiV1ItemLocationDetailsGetItemLocationDetailsGetRequest($page_number, $page_size, $location_id, $web_item, $last_updated, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemLocationDetail[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemLocationDetail[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemLocationDetail[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ItemLocationDetailsGetItemLocationDetailsGetAsync
     *
     * Returns an array of ItemLocationDetails that match the specified search criteria  The last updated date and location id are required parameters
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $location_id (optional)
     * @param  bool|null $web_item (optional)
     * @param  \DateTime|null $last_updated (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailsGetAsync($page_number = null, $page_size = null, $location_id = null, $web_item = null, $last_updated = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsGet'][0])
    {
        return $this->apiV1ItemLocationDetailsGetItemLocationDetailsGetAsyncWithHttpInfo($page_number, $page_size, $location_id, $web_item, $last_updated, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ItemLocationDetailsGetItemLocationDetailsGetAsyncWithHttpInfo
     *
     * Returns an array of ItemLocationDetails that match the specified search criteria  The last updated date and location id are required parameters
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $location_id (optional)
     * @param  bool|null $web_item (optional)
     * @param  \DateTime|null $last_updated (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailsGetAsyncWithHttpInfo($page_number = null, $page_size = null, $location_id = null, $web_item = null, $last_updated = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsGet'][0])
    {
        $returnType = '\Opsuite2\Model\ItemLocationDetail[]';
        $request = $this->apiV1ItemLocationDetailsGetItemLocationDetailsGetRequest($page_number, $page_size, $location_id, $web_item, $last_updated, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ItemLocationDetailsGetItemLocationDetailsGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $location_id (optional)
     * @param  bool|null $web_item (optional)
     * @param  \DateTime|null $last_updated (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailsGetRequest($page_number = null, $page_size = null, $location_id = null, $web_item = null, $last_updated = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsGet'][0])
    {







        $resourcePath = '/api/v1/ItemLocationDetails/GetItemLocationDetails';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $location_id,
            'LocationId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $web_item,
            'WebItem', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $last_updated,
            'LastUpdated', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGet
     *
     * Returns an array of ItemLocationDetails that have been modified since the specified date
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  \DateTime|null $specified_date specified_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemLocationDetail[]|string
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGet($page_number = null, $page_size = null, $specified_date = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGet'][0])
    {
        list($response) = $this->apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGetWithHttpInfo($page_number, $page_size, $specified_date, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGetWithHttpInfo
     *
     * Returns an array of ItemLocationDetails that have been modified since the specified date
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $specified_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemLocationDetail[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGetWithHttpInfo($page_number = null, $page_size = null, $specified_date = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGet'][0])
    {
        $request = $this->apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGetRequest($page_number, $page_size, $specified_date, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemLocationDetail[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemLocationDetail[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemLocationDetail[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGetAsync
     *
     * Returns an array of ItemLocationDetails that have been modified since the specified date
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $specified_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGetAsync($page_number = null, $page_size = null, $specified_date = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGet'][0])
    {
        return $this->apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGetAsyncWithHttpInfo($page_number, $page_size, $specified_date, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGetAsyncWithHttpInfo
     *
     * Returns an array of ItemLocationDetails that have been modified since the specified date
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $specified_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGetAsyncWithHttpInfo($page_number = null, $page_size = null, $specified_date = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGet'][0])
    {
        $returnType = '\Opsuite2\Model\ItemLocationDetail[]';
        $request = $this->apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGetRequest($page_number, $page_size, $specified_date, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $specified_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGetRequest($page_number = null, $page_size = null, $specified_date = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGet'][0])
    {





        $resourcePath = '/api/v1/ItemLocationDetails/GetItemLocationDetailsModifiedSinceSpecifiedDate';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $specified_date,
            'specifiedDate', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGet
     *
     * Returns an array of Questions associated with the specified ItemLocationDetail.
     *
     * @param  int $item_location_detail_id item_location_detail_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemQuestion[]|string
     */
    public function apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGet($item_location_detail_id, string $contentType = self::contentTypes['apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGet'][0])
    {
        list($response) = $this->apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGetWithHttpInfo($item_location_detail_id, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGetWithHttpInfo
     *
     * Returns an array of Questions associated with the specified ItemLocationDetail.
     *
     * @param  int $item_location_detail_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemQuestion[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGetWithHttpInfo($item_location_detail_id, string $contentType = self::contentTypes['apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGet'][0])
    {
        $request = $this->apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGetRequest($item_location_detail_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemQuestion[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemQuestion[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemQuestion[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGetAsync
     *
     * Returns an array of Questions associated with the specified ItemLocationDetail.
     *
     * @param  int $item_location_detail_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGetAsync($item_location_detail_id, string $contentType = self::contentTypes['apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGet'][0])
    {
        return $this->apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGetAsyncWithHttpInfo($item_location_detail_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGetAsyncWithHttpInfo
     *
     * Returns an array of Questions associated with the specified ItemLocationDetail.
     *
     * @param  int $item_location_detail_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGetAsyncWithHttpInfo($item_location_detail_id, string $contentType = self::contentTypes['apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGet'][0])
    {
        $returnType = '\Opsuite2\Model\ItemQuestion[]';
        $request = $this->apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGetRequest($item_location_detail_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGet'
     *
     * @param  int $item_location_detail_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGetRequest($item_location_detail_id, string $contentType = self::contentTypes['apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGet'][0])
    {

        // verify the required parameter 'item_location_detail_id' is set
        if ($item_location_detail_id === null || (is_array($item_location_detail_id) && count($item_location_detail_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $item_location_detail_id when calling apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGet'
            );
        }
        if ($item_location_detail_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$item_location_detail_id" when calling ItemLocationDetailsApi.apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGet, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v1/ItemLocationDetails/{itemLocationDetailId}/ItemQuestions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($item_location_detail_id !== null) {
            $resourcePath = str_replace(
                '{' . 'itemLocationDetailId' . '}',
                ObjectSerializer::toPathValue($item_location_detail_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatch
     *
     * Updates specified properties of multiple ItemLocationDetails.
     *
     * @param  \Opsuite2\Model\PatchCollection[]|null $patch_collection patch_collection (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatch'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\PatchResponse[]|string
     */
    public function apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatch($patch_collection = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatch'][0])
    {
        list($response) = $this->apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatchWithHttpInfo($patch_collection, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatchWithHttpInfo
     *
     * Updates specified properties of multiple ItemLocationDetails.
     *
     * @param  \Opsuite2\Model\PatchCollection[]|null $patch_collection (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatch'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\PatchResponse[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatchWithHttpInfo($patch_collection = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatch'][0])
    {
        $request = $this->apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatchRequest($patch_collection, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 202:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\PatchResponse[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\PatchResponse[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 202:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\PatchResponse[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatchAsync
     *
     * Updates specified properties of multiple ItemLocationDetails.
     *
     * @param  \Opsuite2\Model\PatchCollection[]|null $patch_collection (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatchAsync($patch_collection = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatch'][0])
    {
        return $this->apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatchAsyncWithHttpInfo($patch_collection, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatchAsyncWithHttpInfo
     *
     * Updates specified properties of multiple ItemLocationDetails.
     *
     * @param  \Opsuite2\Model\PatchCollection[]|null $patch_collection (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatchAsyncWithHttpInfo($patch_collection = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatch'][0])
    {
        $returnType = '\Opsuite2\Model\PatchResponse[]';
        $request = $this->apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatchRequest($patch_collection, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatch'
     *
     * @param  \Opsuite2\Model\PatchCollection[]|null $patch_collection (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatchRequest($patch_collection = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatch'][0])
    {



        $resourcePath = '/api/v1/ItemLocationDetails/PatchMultipleItemLocationDetails';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($patch_collection)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($patch_collection));
            } else {
                $httpBody = $patch_collection;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPost
     *
     * Creates multiple new item location details.
     *
     * @param  \Opsuite2\Model\ItemLocationDetail[]|null $item_location_detail item_location_detail (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\PostResponseItemLocationDetail[]|string
     */
    public function apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPost($item_location_detail = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPost'][0])
    {
        list($response) = $this->apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPostWithHttpInfo($item_location_detail, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPostWithHttpInfo
     *
     * Creates multiple new item location details.
     *
     * @param  \Opsuite2\Model\ItemLocationDetail[]|null $item_location_detail (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\PostResponseItemLocationDetail[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPostWithHttpInfo($item_location_detail = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPost'][0])
    {
        $request = $this->apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPostRequest($item_location_detail, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\PostResponseItemLocationDetail[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\PostResponseItemLocationDetail[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\PostResponseItemLocationDetail[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPostAsync
     *
     * Creates multiple new item location details.
     *
     * @param  \Opsuite2\Model\ItemLocationDetail[]|null $item_location_detail (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPostAsync($item_location_detail = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPost'][0])
    {
        return $this->apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPostAsyncWithHttpInfo($item_location_detail, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPostAsyncWithHttpInfo
     *
     * Creates multiple new item location details.
     *
     * @param  \Opsuite2\Model\ItemLocationDetail[]|null $item_location_detail (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPostAsyncWithHttpInfo($item_location_detail = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPost'][0])
    {
        $returnType = '\Opsuite2\Model\PostResponseItemLocationDetail[]';
        $request = $this->apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPostRequest($item_location_detail, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPost'
     *
     * @param  \Opsuite2\Model\ItemLocationDetail[]|null $item_location_detail (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPostRequest($item_location_detail = null, string $contentType = self::contentTypes['apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPost'][0])
    {



        $resourcePath = '/api/v1/ItemLocationDetails/PostMultipleItemLocationDetails';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($item_location_detail)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($item_location_detail));
            } else {
                $httpBody = $item_location_detail;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
