<?php
/**
 * ItemDetailsApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Opsuite2\ApiException;
use Opsuite2\Configuration;
use Opsuite2\FormDataProcessor;
use Opsuite2\HeaderSelector;
use Opsuite2\ObjectSerializer;

/**
 * ItemDetailsApi Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ItemDetailsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV1ItemDetailsGetItemDetailsByAttributeGet' => [
            'application/json',
        ],
        'apiV1ItemDetailsGetItemDetailsByIdListGet' => [
            'application/json',
        ],
        'apiV1ItemDetailsGetItemDetailsBySkuGet' => [
            'application/json',
        ],
        'apiV1ItemDetailsGetItemDetailsBySkuListGet' => [
            'application/json',
        ],
        'apiV1ItemDetailsGetItemDetailsGet' => [
            'application/json',
        ],
        'apiV2ItemDetailsGetItemDetailsByAttributeGet' => [
            'application/json',
        ],
        'apiV2ItemDetailsGetItemDetailsByIdListGet' => [
            'application/json',
        ],
        'apiV2ItemDetailsGetItemDetailsBySkuGet' => [
            'application/json',
        ],
        'apiV2ItemDetailsGetItemDetailsBySkuListGet' => [
            'application/json',
        ],
        'apiV2ItemDetailsGetItemDetailsGet' => [
            'application/json',
        ],
        'apiV2ItemDetailsItemMasterIdGet' => [
            'application/json',
        ],
        'getItemDetails' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV1ItemDetailsGetItemDetailsByAttributeGet
     *
     * Returns a list of ItemDetails that have the specified attribute code or description
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  string|null $attribute attribute (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemDetailsGetItemDetailsByAttributeGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemDetails[]|string
     * @deprecated
     */
    public function apiV1ItemDetailsGetItemDetailsByAttributeGet($page_number = null, $page_size = null, $attribute = null, string $contentType = self::contentTypes['apiV1ItemDetailsGetItemDetailsByAttributeGet'][0])
    {
        list($response) = $this->apiV1ItemDetailsGetItemDetailsByAttributeGetWithHttpInfo($page_number, $page_size, $attribute, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ItemDetailsGetItemDetailsByAttributeGetWithHttpInfo
     *
     * Returns a list of ItemDetails that have the specified attribute code or description
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string|null $attribute (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemDetailsGetItemDetailsByAttributeGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemDetails[]|string, HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function apiV1ItemDetailsGetItemDetailsByAttributeGetWithHttpInfo($page_number = null, $page_size = null, $attribute = null, string $contentType = self::contentTypes['apiV1ItemDetailsGetItemDetailsByAttributeGet'][0])
    {
        $request = $this->apiV1ItemDetailsGetItemDetailsByAttributeGetRequest($page_number, $page_size, $attribute, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemDetails[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemDetails[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemDetails[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ItemDetailsGetItemDetailsByAttributeGetAsync
     *
     * Returns a list of ItemDetails that have the specified attribute code or description
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string|null $attribute (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemDetailsGetItemDetailsByAttributeGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function apiV1ItemDetailsGetItemDetailsByAttributeGetAsync($page_number = null, $page_size = null, $attribute = null, string $contentType = self::contentTypes['apiV1ItemDetailsGetItemDetailsByAttributeGet'][0])
    {
        return $this->apiV1ItemDetailsGetItemDetailsByAttributeGetAsyncWithHttpInfo($page_number, $page_size, $attribute, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ItemDetailsGetItemDetailsByAttributeGetAsyncWithHttpInfo
     *
     * Returns a list of ItemDetails that have the specified attribute code or description
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string|null $attribute (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemDetailsGetItemDetailsByAttributeGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function apiV1ItemDetailsGetItemDetailsByAttributeGetAsyncWithHttpInfo($page_number = null, $page_size = null, $attribute = null, string $contentType = self::contentTypes['apiV1ItemDetailsGetItemDetailsByAttributeGet'][0])
    {
        $returnType = '\Opsuite2\Model\ItemDetails[]';
        $request = $this->apiV1ItemDetailsGetItemDetailsByAttributeGetRequest($page_number, $page_size, $attribute, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ItemDetailsGetItemDetailsByAttributeGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string|null $attribute (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemDetailsGetItemDetailsByAttributeGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function apiV1ItemDetailsGetItemDetailsByAttributeGetRequest($page_number = null, $page_size = null, $attribute = null, string $contentType = self::contentTypes['apiV1ItemDetailsGetItemDetailsByAttributeGet'][0])
    {





        $resourcePath = '/api/v1/ItemDetails/GetItemDetailsByAttribute';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $attribute,
            'attribute', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ItemDetailsGetItemDetailsByIdListGet
     *
     * Returns a list of ItemDetails for the specified list of item master ids.
     *
     * @param  int[]|null $ids ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemDetailsGetItemDetailsByIdListGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemDetails[]|string
     * @deprecated
     */
    public function apiV1ItemDetailsGetItemDetailsByIdListGet($ids = null, string $contentType = self::contentTypes['apiV1ItemDetailsGetItemDetailsByIdListGet'][0])
    {
        list($response) = $this->apiV1ItemDetailsGetItemDetailsByIdListGetWithHttpInfo($ids, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ItemDetailsGetItemDetailsByIdListGetWithHttpInfo
     *
     * Returns a list of ItemDetails for the specified list of item master ids.
     *
     * @param  int[]|null $ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemDetailsGetItemDetailsByIdListGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemDetails[]|string, HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function apiV1ItemDetailsGetItemDetailsByIdListGetWithHttpInfo($ids = null, string $contentType = self::contentTypes['apiV1ItemDetailsGetItemDetailsByIdListGet'][0])
    {
        $request = $this->apiV1ItemDetailsGetItemDetailsByIdListGetRequest($ids, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemDetails[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemDetails[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemDetails[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ItemDetailsGetItemDetailsByIdListGetAsync
     *
     * Returns a list of ItemDetails for the specified list of item master ids.
     *
     * @param  int[]|null $ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemDetailsGetItemDetailsByIdListGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function apiV1ItemDetailsGetItemDetailsByIdListGetAsync($ids = null, string $contentType = self::contentTypes['apiV1ItemDetailsGetItemDetailsByIdListGet'][0])
    {
        return $this->apiV1ItemDetailsGetItemDetailsByIdListGetAsyncWithHttpInfo($ids, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ItemDetailsGetItemDetailsByIdListGetAsyncWithHttpInfo
     *
     * Returns a list of ItemDetails for the specified list of item master ids.
     *
     * @param  int[]|null $ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemDetailsGetItemDetailsByIdListGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function apiV1ItemDetailsGetItemDetailsByIdListGetAsyncWithHttpInfo($ids = null, string $contentType = self::contentTypes['apiV1ItemDetailsGetItemDetailsByIdListGet'][0])
    {
        $returnType = '\Opsuite2\Model\ItemDetails[]';
        $request = $this->apiV1ItemDetailsGetItemDetailsByIdListGetRequest($ids, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ItemDetailsGetItemDetailsByIdListGet'
     *
     * @param  int[]|null $ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemDetailsGetItemDetailsByIdListGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function apiV1ItemDetailsGetItemDetailsByIdListGetRequest($ids = null, string $contentType = self::contentTypes['apiV1ItemDetailsGetItemDetailsByIdListGet'][0])
    {



        $resourcePath = '/api/v1/ItemDetails/GetItemDetailsByIdList';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $ids,
            'ids', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ItemDetailsGetItemDetailsBySkuGet
     *
     * Returns a single ItemDetails with the specified sku.
     *
     * @param  string|null $sku sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemDetailsGetItemDetailsBySkuGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemDetails|string
     * @deprecated
     */
    public function apiV1ItemDetailsGetItemDetailsBySkuGet($sku = null, string $contentType = self::contentTypes['apiV1ItemDetailsGetItemDetailsBySkuGet'][0])
    {
        list($response) = $this->apiV1ItemDetailsGetItemDetailsBySkuGetWithHttpInfo($sku, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ItemDetailsGetItemDetailsBySkuGetWithHttpInfo
     *
     * Returns a single ItemDetails with the specified sku.
     *
     * @param  string|null $sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemDetailsGetItemDetailsBySkuGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemDetails|string, HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function apiV1ItemDetailsGetItemDetailsBySkuGetWithHttpInfo($sku = null, string $contentType = self::contentTypes['apiV1ItemDetailsGetItemDetailsBySkuGet'][0])
    {
        $request = $this->apiV1ItemDetailsGetItemDetailsBySkuGetRequest($sku, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemDetails',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemDetails',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ItemDetailsGetItemDetailsBySkuGetAsync
     *
     * Returns a single ItemDetails with the specified sku.
     *
     * @param  string|null $sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemDetailsGetItemDetailsBySkuGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function apiV1ItemDetailsGetItemDetailsBySkuGetAsync($sku = null, string $contentType = self::contentTypes['apiV1ItemDetailsGetItemDetailsBySkuGet'][0])
    {
        return $this->apiV1ItemDetailsGetItemDetailsBySkuGetAsyncWithHttpInfo($sku, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ItemDetailsGetItemDetailsBySkuGetAsyncWithHttpInfo
     *
     * Returns a single ItemDetails with the specified sku.
     *
     * @param  string|null $sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemDetailsGetItemDetailsBySkuGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function apiV1ItemDetailsGetItemDetailsBySkuGetAsyncWithHttpInfo($sku = null, string $contentType = self::contentTypes['apiV1ItemDetailsGetItemDetailsBySkuGet'][0])
    {
        $returnType = '\Opsuite2\Model\ItemDetails';
        $request = $this->apiV1ItemDetailsGetItemDetailsBySkuGetRequest($sku, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ItemDetailsGetItemDetailsBySkuGet'
     *
     * @param  string|null $sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemDetailsGetItemDetailsBySkuGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function apiV1ItemDetailsGetItemDetailsBySkuGetRequest($sku = null, string $contentType = self::contentTypes['apiV1ItemDetailsGetItemDetailsBySkuGet'][0])
    {



        $resourcePath = '/api/v1/ItemDetails/GetItemDetailsBySku';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sku,
            'sku', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ItemDetailsGetItemDetailsBySkuListGet
     *
     * Returns a list of ItemDetails for the specified list of skus.
     *
     * @param  string[]|null $skus skus (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemDetailsGetItemDetailsBySkuListGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemDetails[]|string
     * @deprecated
     */
    public function apiV1ItemDetailsGetItemDetailsBySkuListGet($skus = null, string $contentType = self::contentTypes['apiV1ItemDetailsGetItemDetailsBySkuListGet'][0])
    {
        list($response) = $this->apiV1ItemDetailsGetItemDetailsBySkuListGetWithHttpInfo($skus, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ItemDetailsGetItemDetailsBySkuListGetWithHttpInfo
     *
     * Returns a list of ItemDetails for the specified list of skus.
     *
     * @param  string[]|null $skus (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemDetailsGetItemDetailsBySkuListGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemDetails[]|string, HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function apiV1ItemDetailsGetItemDetailsBySkuListGetWithHttpInfo($skus = null, string $contentType = self::contentTypes['apiV1ItemDetailsGetItemDetailsBySkuListGet'][0])
    {
        $request = $this->apiV1ItemDetailsGetItemDetailsBySkuListGetRequest($skus, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemDetails[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemDetails[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemDetails[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ItemDetailsGetItemDetailsBySkuListGetAsync
     *
     * Returns a list of ItemDetails for the specified list of skus.
     *
     * @param  string[]|null $skus (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemDetailsGetItemDetailsBySkuListGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function apiV1ItemDetailsGetItemDetailsBySkuListGetAsync($skus = null, string $contentType = self::contentTypes['apiV1ItemDetailsGetItemDetailsBySkuListGet'][0])
    {
        return $this->apiV1ItemDetailsGetItemDetailsBySkuListGetAsyncWithHttpInfo($skus, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ItemDetailsGetItemDetailsBySkuListGetAsyncWithHttpInfo
     *
     * Returns a list of ItemDetails for the specified list of skus.
     *
     * @param  string[]|null $skus (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemDetailsGetItemDetailsBySkuListGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function apiV1ItemDetailsGetItemDetailsBySkuListGetAsyncWithHttpInfo($skus = null, string $contentType = self::contentTypes['apiV1ItemDetailsGetItemDetailsBySkuListGet'][0])
    {
        $returnType = '\Opsuite2\Model\ItemDetails[]';
        $request = $this->apiV1ItemDetailsGetItemDetailsBySkuListGetRequest($skus, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ItemDetailsGetItemDetailsBySkuListGet'
     *
     * @param  string[]|null $skus (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemDetailsGetItemDetailsBySkuListGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function apiV1ItemDetailsGetItemDetailsBySkuListGetRequest($skus = null, string $contentType = self::contentTypes['apiV1ItemDetailsGetItemDetailsBySkuListGet'][0])
    {



        $resourcePath = '/api/v1/ItemDetails/GetItemDetailsBySkuList';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $skus,
            'skus', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ItemDetailsGetItemDetailsGet
     *
     * Returns a list of ItemDetails modified since the supplied date
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  \DateTime|null $specified_date specified_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemDetailsGetItemDetailsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemDetails[]|string
     * @deprecated
     */
    public function apiV1ItemDetailsGetItemDetailsGet($page_number = null, $page_size = null, $specified_date = null, string $contentType = self::contentTypes['apiV1ItemDetailsGetItemDetailsGet'][0])
    {
        list($response) = $this->apiV1ItemDetailsGetItemDetailsGetWithHttpInfo($page_number, $page_size, $specified_date, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ItemDetailsGetItemDetailsGetWithHttpInfo
     *
     * Returns a list of ItemDetails modified since the supplied date
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $specified_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemDetailsGetItemDetailsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemDetails[]|string, HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function apiV1ItemDetailsGetItemDetailsGetWithHttpInfo($page_number = null, $page_size = null, $specified_date = null, string $contentType = self::contentTypes['apiV1ItemDetailsGetItemDetailsGet'][0])
    {
        $request = $this->apiV1ItemDetailsGetItemDetailsGetRequest($page_number, $page_size, $specified_date, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemDetails[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemDetails[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemDetails[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ItemDetailsGetItemDetailsGetAsync
     *
     * Returns a list of ItemDetails modified since the supplied date
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $specified_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemDetailsGetItemDetailsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function apiV1ItemDetailsGetItemDetailsGetAsync($page_number = null, $page_size = null, $specified_date = null, string $contentType = self::contentTypes['apiV1ItemDetailsGetItemDetailsGet'][0])
    {
        return $this->apiV1ItemDetailsGetItemDetailsGetAsyncWithHttpInfo($page_number, $page_size, $specified_date, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ItemDetailsGetItemDetailsGetAsyncWithHttpInfo
     *
     * Returns a list of ItemDetails modified since the supplied date
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $specified_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemDetailsGetItemDetailsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function apiV1ItemDetailsGetItemDetailsGetAsyncWithHttpInfo($page_number = null, $page_size = null, $specified_date = null, string $contentType = self::contentTypes['apiV1ItemDetailsGetItemDetailsGet'][0])
    {
        $returnType = '\Opsuite2\Model\ItemDetails[]';
        $request = $this->apiV1ItemDetailsGetItemDetailsGetRequest($page_number, $page_size, $specified_date, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ItemDetailsGetItemDetailsGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $specified_date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemDetailsGetItemDetailsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function apiV1ItemDetailsGetItemDetailsGetRequest($page_number = null, $page_size = null, $specified_date = null, string $contentType = self::contentTypes['apiV1ItemDetailsGetItemDetailsGet'][0])
    {





        $resourcePath = '/api/v1/ItemDetails/GetItemDetails';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $specified_date,
            'specifiedDate', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2ItemDetailsGetItemDetailsByAttributeGet
     *
     * Returns a list of ItemDetails that have the specified attribute code or description
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  string|null $attribute attribute (optional)
     * @param  bool|null $include_inactive include_inactive (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsGetItemDetailsByAttributeGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemDetails[]|string
     */
    public function apiV2ItemDetailsGetItemDetailsByAttributeGet($page_number = null, $page_size = null, $attribute = null, $include_inactive = null, string $contentType = self::contentTypes['apiV2ItemDetailsGetItemDetailsByAttributeGet'][0])
    {
        list($response) = $this->apiV2ItemDetailsGetItemDetailsByAttributeGetWithHttpInfo($page_number, $page_size, $attribute, $include_inactive, $contentType);
        return $response;
    }

    /**
     * Operation apiV2ItemDetailsGetItemDetailsByAttributeGetWithHttpInfo
     *
     * Returns a list of ItemDetails that have the specified attribute code or description
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string|null $attribute (optional)
     * @param  bool|null $include_inactive (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsGetItemDetailsByAttributeGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemDetails[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2ItemDetailsGetItemDetailsByAttributeGetWithHttpInfo($page_number = null, $page_size = null, $attribute = null, $include_inactive = null, string $contentType = self::contentTypes['apiV2ItemDetailsGetItemDetailsByAttributeGet'][0])
    {
        $request = $this->apiV2ItemDetailsGetItemDetailsByAttributeGetRequest($page_number, $page_size, $attribute, $include_inactive, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemDetails[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemDetails[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemDetails[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2ItemDetailsGetItemDetailsByAttributeGetAsync
     *
     * Returns a list of ItemDetails that have the specified attribute code or description
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string|null $attribute (optional)
     * @param  bool|null $include_inactive (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsGetItemDetailsByAttributeGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ItemDetailsGetItemDetailsByAttributeGetAsync($page_number = null, $page_size = null, $attribute = null, $include_inactive = null, string $contentType = self::contentTypes['apiV2ItemDetailsGetItemDetailsByAttributeGet'][0])
    {
        return $this->apiV2ItemDetailsGetItemDetailsByAttributeGetAsyncWithHttpInfo($page_number, $page_size, $attribute, $include_inactive, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2ItemDetailsGetItemDetailsByAttributeGetAsyncWithHttpInfo
     *
     * Returns a list of ItemDetails that have the specified attribute code or description
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string|null $attribute (optional)
     * @param  bool|null $include_inactive (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsGetItemDetailsByAttributeGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ItemDetailsGetItemDetailsByAttributeGetAsyncWithHttpInfo($page_number = null, $page_size = null, $attribute = null, $include_inactive = null, string $contentType = self::contentTypes['apiV2ItemDetailsGetItemDetailsByAttributeGet'][0])
    {
        $returnType = '\Opsuite2\Model\ItemDetails[]';
        $request = $this->apiV2ItemDetailsGetItemDetailsByAttributeGetRequest($page_number, $page_size, $attribute, $include_inactive, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2ItemDetailsGetItemDetailsByAttributeGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string|null $attribute (optional)
     * @param  bool|null $include_inactive (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsGetItemDetailsByAttributeGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2ItemDetailsGetItemDetailsByAttributeGetRequest($page_number = null, $page_size = null, $attribute = null, $include_inactive = null, string $contentType = self::contentTypes['apiV2ItemDetailsGetItemDetailsByAttributeGet'][0])
    {






        $resourcePath = '/api/v2/ItemDetails/GetItemDetailsByAttribute';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $attribute,
            'attribute', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_inactive,
            'includeInactive', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2ItemDetailsGetItemDetailsByIdListGet
     *
     * Returns a list of ItemDetails for the specified list of item master ids.
     *
     * @param  int[]|null $ids ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsGetItemDetailsByIdListGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemDetails[]|string
     */
    public function apiV2ItemDetailsGetItemDetailsByIdListGet($ids = null, string $contentType = self::contentTypes['apiV2ItemDetailsGetItemDetailsByIdListGet'][0])
    {
        list($response) = $this->apiV2ItemDetailsGetItemDetailsByIdListGetWithHttpInfo($ids, $contentType);
        return $response;
    }

    /**
     * Operation apiV2ItemDetailsGetItemDetailsByIdListGetWithHttpInfo
     *
     * Returns a list of ItemDetails for the specified list of item master ids.
     *
     * @param  int[]|null $ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsGetItemDetailsByIdListGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemDetails[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2ItemDetailsGetItemDetailsByIdListGetWithHttpInfo($ids = null, string $contentType = self::contentTypes['apiV2ItemDetailsGetItemDetailsByIdListGet'][0])
    {
        $request = $this->apiV2ItemDetailsGetItemDetailsByIdListGetRequest($ids, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemDetails[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemDetails[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemDetails[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2ItemDetailsGetItemDetailsByIdListGetAsync
     *
     * Returns a list of ItemDetails for the specified list of item master ids.
     *
     * @param  int[]|null $ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsGetItemDetailsByIdListGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ItemDetailsGetItemDetailsByIdListGetAsync($ids = null, string $contentType = self::contentTypes['apiV2ItemDetailsGetItemDetailsByIdListGet'][0])
    {
        return $this->apiV2ItemDetailsGetItemDetailsByIdListGetAsyncWithHttpInfo($ids, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2ItemDetailsGetItemDetailsByIdListGetAsyncWithHttpInfo
     *
     * Returns a list of ItemDetails for the specified list of item master ids.
     *
     * @param  int[]|null $ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsGetItemDetailsByIdListGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ItemDetailsGetItemDetailsByIdListGetAsyncWithHttpInfo($ids = null, string $contentType = self::contentTypes['apiV2ItemDetailsGetItemDetailsByIdListGet'][0])
    {
        $returnType = '\Opsuite2\Model\ItemDetails[]';
        $request = $this->apiV2ItemDetailsGetItemDetailsByIdListGetRequest($ids, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2ItemDetailsGetItemDetailsByIdListGet'
     *
     * @param  int[]|null $ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsGetItemDetailsByIdListGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2ItemDetailsGetItemDetailsByIdListGetRequest($ids = null, string $contentType = self::contentTypes['apiV2ItemDetailsGetItemDetailsByIdListGet'][0])
    {



        $resourcePath = '/api/v2/ItemDetails/GetItemDetailsByIdList';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $ids,
            'ids', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2ItemDetailsGetItemDetailsBySkuGet
     *
     * Returns a single ItemDetails with the specified sku.
     *
     * @param  string|null $sku sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsGetItemDetailsBySkuGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemDetails|string
     */
    public function apiV2ItemDetailsGetItemDetailsBySkuGet($sku = null, string $contentType = self::contentTypes['apiV2ItemDetailsGetItemDetailsBySkuGet'][0])
    {
        list($response) = $this->apiV2ItemDetailsGetItemDetailsBySkuGetWithHttpInfo($sku, $contentType);
        return $response;
    }

    /**
     * Operation apiV2ItemDetailsGetItemDetailsBySkuGetWithHttpInfo
     *
     * Returns a single ItemDetails with the specified sku.
     *
     * @param  string|null $sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsGetItemDetailsBySkuGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemDetails|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2ItemDetailsGetItemDetailsBySkuGetWithHttpInfo($sku = null, string $contentType = self::contentTypes['apiV2ItemDetailsGetItemDetailsBySkuGet'][0])
    {
        $request = $this->apiV2ItemDetailsGetItemDetailsBySkuGetRequest($sku, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemDetails',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemDetails',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2ItemDetailsGetItemDetailsBySkuGetAsync
     *
     * Returns a single ItemDetails with the specified sku.
     *
     * @param  string|null $sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsGetItemDetailsBySkuGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ItemDetailsGetItemDetailsBySkuGetAsync($sku = null, string $contentType = self::contentTypes['apiV2ItemDetailsGetItemDetailsBySkuGet'][0])
    {
        return $this->apiV2ItemDetailsGetItemDetailsBySkuGetAsyncWithHttpInfo($sku, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2ItemDetailsGetItemDetailsBySkuGetAsyncWithHttpInfo
     *
     * Returns a single ItemDetails with the specified sku.
     *
     * @param  string|null $sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsGetItemDetailsBySkuGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ItemDetailsGetItemDetailsBySkuGetAsyncWithHttpInfo($sku = null, string $contentType = self::contentTypes['apiV2ItemDetailsGetItemDetailsBySkuGet'][0])
    {
        $returnType = '\Opsuite2\Model\ItemDetails';
        $request = $this->apiV2ItemDetailsGetItemDetailsBySkuGetRequest($sku, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2ItemDetailsGetItemDetailsBySkuGet'
     *
     * @param  string|null $sku (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsGetItemDetailsBySkuGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2ItemDetailsGetItemDetailsBySkuGetRequest($sku = null, string $contentType = self::contentTypes['apiV2ItemDetailsGetItemDetailsBySkuGet'][0])
    {



        $resourcePath = '/api/v2/ItemDetails/GetItemDetailsBySku';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sku,
            'sku', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2ItemDetailsGetItemDetailsBySkuListGet
     *
     * Returns a list of ItemDetails for the specified list of skus.
     *
     * @param  string[]|null $skus skus (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsGetItemDetailsBySkuListGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemDetails[]|string
     */
    public function apiV2ItemDetailsGetItemDetailsBySkuListGet($skus = null, string $contentType = self::contentTypes['apiV2ItemDetailsGetItemDetailsBySkuListGet'][0])
    {
        list($response) = $this->apiV2ItemDetailsGetItemDetailsBySkuListGetWithHttpInfo($skus, $contentType);
        return $response;
    }

    /**
     * Operation apiV2ItemDetailsGetItemDetailsBySkuListGetWithHttpInfo
     *
     * Returns a list of ItemDetails for the specified list of skus.
     *
     * @param  string[]|null $skus (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsGetItemDetailsBySkuListGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemDetails[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2ItemDetailsGetItemDetailsBySkuListGetWithHttpInfo($skus = null, string $contentType = self::contentTypes['apiV2ItemDetailsGetItemDetailsBySkuListGet'][0])
    {
        $request = $this->apiV2ItemDetailsGetItemDetailsBySkuListGetRequest($skus, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemDetails[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemDetails[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemDetails[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2ItemDetailsGetItemDetailsBySkuListGetAsync
     *
     * Returns a list of ItemDetails for the specified list of skus.
     *
     * @param  string[]|null $skus (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsGetItemDetailsBySkuListGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ItemDetailsGetItemDetailsBySkuListGetAsync($skus = null, string $contentType = self::contentTypes['apiV2ItemDetailsGetItemDetailsBySkuListGet'][0])
    {
        return $this->apiV2ItemDetailsGetItemDetailsBySkuListGetAsyncWithHttpInfo($skus, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2ItemDetailsGetItemDetailsBySkuListGetAsyncWithHttpInfo
     *
     * Returns a list of ItemDetails for the specified list of skus.
     *
     * @param  string[]|null $skus (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsGetItemDetailsBySkuListGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ItemDetailsGetItemDetailsBySkuListGetAsyncWithHttpInfo($skus = null, string $contentType = self::contentTypes['apiV2ItemDetailsGetItemDetailsBySkuListGet'][0])
    {
        $returnType = '\Opsuite2\Model\ItemDetails[]';
        $request = $this->apiV2ItemDetailsGetItemDetailsBySkuListGetRequest($skus, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2ItemDetailsGetItemDetailsBySkuListGet'
     *
     * @param  string[]|null $skus (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsGetItemDetailsBySkuListGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2ItemDetailsGetItemDetailsBySkuListGetRequest($skus = null, string $contentType = self::contentTypes['apiV2ItemDetailsGetItemDetailsBySkuListGet'][0])
    {



        $resourcePath = '/api/v2/ItemDetails/GetItemDetailsBySkuList';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $skus,
            'skus', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2ItemDetailsGetItemDetailsGet
     *
     * Returns a list of ItemDetails modified since the supplied date
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  \DateTime|null $specified_date specified_date (optional)
     * @param  bool|null $include_inactive include_inactive (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsGetItemDetailsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemDetails[]|string
     */
    public function apiV2ItemDetailsGetItemDetailsGet($page_number = null, $page_size = null, $specified_date = null, $include_inactive = null, string $contentType = self::contentTypes['apiV2ItemDetailsGetItemDetailsGet'][0])
    {
        list($response) = $this->apiV2ItemDetailsGetItemDetailsGetWithHttpInfo($page_number, $page_size, $specified_date, $include_inactive, $contentType);
        return $response;
    }

    /**
     * Operation apiV2ItemDetailsGetItemDetailsGetWithHttpInfo
     *
     * Returns a list of ItemDetails modified since the supplied date
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $specified_date (optional)
     * @param  bool|null $include_inactive (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsGetItemDetailsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemDetails[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2ItemDetailsGetItemDetailsGetWithHttpInfo($page_number = null, $page_size = null, $specified_date = null, $include_inactive = null, string $contentType = self::contentTypes['apiV2ItemDetailsGetItemDetailsGet'][0])
    {
        $request = $this->apiV2ItemDetailsGetItemDetailsGetRequest($page_number, $page_size, $specified_date, $include_inactive, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemDetails[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemDetails[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemDetails[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2ItemDetailsGetItemDetailsGetAsync
     *
     * Returns a list of ItemDetails modified since the supplied date
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $specified_date (optional)
     * @param  bool|null $include_inactive (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsGetItemDetailsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ItemDetailsGetItemDetailsGetAsync($page_number = null, $page_size = null, $specified_date = null, $include_inactive = null, string $contentType = self::contentTypes['apiV2ItemDetailsGetItemDetailsGet'][0])
    {
        return $this->apiV2ItemDetailsGetItemDetailsGetAsyncWithHttpInfo($page_number, $page_size, $specified_date, $include_inactive, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2ItemDetailsGetItemDetailsGetAsyncWithHttpInfo
     *
     * Returns a list of ItemDetails modified since the supplied date
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $specified_date (optional)
     * @param  bool|null $include_inactive (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsGetItemDetailsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ItemDetailsGetItemDetailsGetAsyncWithHttpInfo($page_number = null, $page_size = null, $specified_date = null, $include_inactive = null, string $contentType = self::contentTypes['apiV2ItemDetailsGetItemDetailsGet'][0])
    {
        $returnType = '\Opsuite2\Model\ItemDetails[]';
        $request = $this->apiV2ItemDetailsGetItemDetailsGetRequest($page_number, $page_size, $specified_date, $include_inactive, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2ItemDetailsGetItemDetailsGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $specified_date (optional)
     * @param  bool|null $include_inactive (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsGetItemDetailsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2ItemDetailsGetItemDetailsGetRequest($page_number = null, $page_size = null, $specified_date = null, $include_inactive = null, string $contentType = self::contentTypes['apiV2ItemDetailsGetItemDetailsGet'][0])
    {






        $resourcePath = '/api/v2/ItemDetails/GetItemDetails';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $specified_date,
            'specifiedDate', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_inactive,
            'includeInactive', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV2ItemDetailsItemMasterIdGet
     *
     * Returns a single ItemDetails with the specified item master id
     *
     * @param  int $item_master_id item_master_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsItemMasterIdGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemDetails|string
     */
    public function apiV2ItemDetailsItemMasterIdGet($item_master_id, string $contentType = self::contentTypes['apiV2ItemDetailsItemMasterIdGet'][0])
    {
        list($response) = $this->apiV2ItemDetailsItemMasterIdGetWithHttpInfo($item_master_id, $contentType);
        return $response;
    }

    /**
     * Operation apiV2ItemDetailsItemMasterIdGetWithHttpInfo
     *
     * Returns a single ItemDetails with the specified item master id
     *
     * @param  int $item_master_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsItemMasterIdGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemDetails|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV2ItemDetailsItemMasterIdGetWithHttpInfo($item_master_id, string $contentType = self::contentTypes['apiV2ItemDetailsItemMasterIdGet'][0])
    {
        $request = $this->apiV2ItemDetailsItemMasterIdGetRequest($item_master_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemDetails',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemDetails',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV2ItemDetailsItemMasterIdGetAsync
     *
     * Returns a single ItemDetails with the specified item master id
     *
     * @param  int $item_master_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsItemMasterIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ItemDetailsItemMasterIdGetAsync($item_master_id, string $contentType = self::contentTypes['apiV2ItemDetailsItemMasterIdGet'][0])
    {
        return $this->apiV2ItemDetailsItemMasterIdGetAsyncWithHttpInfo($item_master_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV2ItemDetailsItemMasterIdGetAsyncWithHttpInfo
     *
     * Returns a single ItemDetails with the specified item master id
     *
     * @param  int $item_master_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsItemMasterIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV2ItemDetailsItemMasterIdGetAsyncWithHttpInfo($item_master_id, string $contentType = self::contentTypes['apiV2ItemDetailsItemMasterIdGet'][0])
    {
        $returnType = '\Opsuite2\Model\ItemDetails';
        $request = $this->apiV2ItemDetailsItemMasterIdGetRequest($item_master_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV2ItemDetailsItemMasterIdGet'
     *
     * @param  int $item_master_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV2ItemDetailsItemMasterIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV2ItemDetailsItemMasterIdGetRequest($item_master_id, string $contentType = self::contentTypes['apiV2ItemDetailsItemMasterIdGet'][0])
    {

        // verify the required parameter 'item_master_id' is set
        if ($item_master_id === null || (is_array($item_master_id) && count($item_master_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $item_master_id when calling apiV2ItemDetailsItemMasterIdGet'
            );
        }
        if ($item_master_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$item_master_id" when calling ItemDetailsApi.apiV2ItemDetailsItemMasterIdGet, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v2/ItemDetails/{itemMasterId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($item_master_id !== null) {
            $resourcePath = str_replace(
                '{' . 'itemMasterId' . '}',
                ObjectSerializer::toPathValue($item_master_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getItemDetails
     *
     * Returns a single ItemDetails with the specified item master id
     *
     * @param  int $item_master_id item_master_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getItemDetails'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemDetails|string
     * @deprecated
     */
    public function getItemDetails($item_master_id, string $contentType = self::contentTypes['getItemDetails'][0])
    {
        list($response) = $this->getItemDetailsWithHttpInfo($item_master_id, $contentType);
        return $response;
    }

    /**
     * Operation getItemDetailsWithHttpInfo
     *
     * Returns a single ItemDetails with the specified item master id
     *
     * @param  int $item_master_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getItemDetails'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemDetails|string, HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function getItemDetailsWithHttpInfo($item_master_id, string $contentType = self::contentTypes['getItemDetails'][0])
    {
        $request = $this->getItemDetailsRequest($item_master_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemDetails',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemDetails',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getItemDetailsAsync
     *
     * Returns a single ItemDetails with the specified item master id
     *
     * @param  int $item_master_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getItemDetails'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function getItemDetailsAsync($item_master_id, string $contentType = self::contentTypes['getItemDetails'][0])
    {
        return $this->getItemDetailsAsyncWithHttpInfo($item_master_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getItemDetailsAsyncWithHttpInfo
     *
     * Returns a single ItemDetails with the specified item master id
     *
     * @param  int $item_master_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getItemDetails'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function getItemDetailsAsyncWithHttpInfo($item_master_id, string $contentType = self::contentTypes['getItemDetails'][0])
    {
        $returnType = '\Opsuite2\Model\ItemDetails';
        $request = $this->getItemDetailsRequest($item_master_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getItemDetails'
     *
     * @param  int $item_master_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getItemDetails'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function getItemDetailsRequest($item_master_id, string $contentType = self::contentTypes['getItemDetails'][0])
    {

        // verify the required parameter 'item_master_id' is set
        if ($item_master_id === null || (is_array($item_master_id) && count($item_master_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $item_master_id when calling getItemDetails'
            );
        }
        if ($item_master_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$item_master_id" when calling ItemDetailsApi.getItemDetails, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v1/ItemDetails/{itemMasterId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($item_master_id !== null) {
            $resourcePath = str_replace(
                '{' . 'itemMasterId' . '}',
                ObjectSerializer::toPathValue($item_master_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
