<?php
/**
 * ItemBinQuantitiesApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Opsuite2\ApiException;
use Opsuite2\Configuration;
use Opsuite2\FormDataProcessor;
use Opsuite2\HeaderSelector;
use Opsuite2\ObjectSerializer;

/**
 * ItemBinQuantitiesApi Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ItemBinQuantitiesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV1ItemBinQuantitiesGetItemBinQuantitiesGet' => [
            'application/json',
        ],
        'apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPost' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPost' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV1ItemBinQuantitiesGetItemBinQuantitiesGet
     *
     * Returns an array of ItemBinQuantities that match the specified search criteria  If the customer order number or inventory transfer search parameters aren&#39;t set  then the last updated date and location id are required parameters
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  int|null $location_id location_id (optional)
     * @param  \DateTime|null $last_updated last_updated (optional)
     * @param  int|null $order_id order_id (optional)
     * @param  string|null $order_number order_number (optional)
     * @param  int|null $transfer_id transfer_id (optional)
     * @param  string|null $transfer_number transfer_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemBinQuantitiesGetItemBinQuantitiesGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemBinQuantities[]|string
     */
    public function apiV1ItemBinQuantitiesGetItemBinQuantitiesGet($page_number = null, $page_size = null, $location_id = null, $last_updated = null, $order_id = null, $order_number = null, $transfer_id = null, $transfer_number = null, string $contentType = self::contentTypes['apiV1ItemBinQuantitiesGetItemBinQuantitiesGet'][0])
    {
        list($response) = $this->apiV1ItemBinQuantitiesGetItemBinQuantitiesGetWithHttpInfo($page_number, $page_size, $location_id, $last_updated, $order_id, $order_number, $transfer_id, $transfer_number, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ItemBinQuantitiesGetItemBinQuantitiesGetWithHttpInfo
     *
     * Returns an array of ItemBinQuantities that match the specified search criteria  If the customer order number or inventory transfer search parameters aren&#39;t set  then the last updated date and location id are required parameters
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $location_id (optional)
     * @param  \DateTime|null $last_updated (optional)
     * @param  int|null $order_id (optional)
     * @param  string|null $order_number (optional)
     * @param  int|null $transfer_id (optional)
     * @param  string|null $transfer_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemBinQuantitiesGetItemBinQuantitiesGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemBinQuantities[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ItemBinQuantitiesGetItemBinQuantitiesGetWithHttpInfo($page_number = null, $page_size = null, $location_id = null, $last_updated = null, $order_id = null, $order_number = null, $transfer_id = null, $transfer_number = null, string $contentType = self::contentTypes['apiV1ItemBinQuantitiesGetItemBinQuantitiesGet'][0])
    {
        $request = $this->apiV1ItemBinQuantitiesGetItemBinQuantitiesGetRequest($page_number, $page_size, $location_id, $last_updated, $order_id, $order_number, $transfer_id, $transfer_number, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemBinQuantities[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemBinQuantities[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemBinQuantities[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ItemBinQuantitiesGetItemBinQuantitiesGetAsync
     *
     * Returns an array of ItemBinQuantities that match the specified search criteria  If the customer order number or inventory transfer search parameters aren&#39;t set  then the last updated date and location id are required parameters
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $location_id (optional)
     * @param  \DateTime|null $last_updated (optional)
     * @param  int|null $order_id (optional)
     * @param  string|null $order_number (optional)
     * @param  int|null $transfer_id (optional)
     * @param  string|null $transfer_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemBinQuantitiesGetItemBinQuantitiesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemBinQuantitiesGetItemBinQuantitiesGetAsync($page_number = null, $page_size = null, $location_id = null, $last_updated = null, $order_id = null, $order_number = null, $transfer_id = null, $transfer_number = null, string $contentType = self::contentTypes['apiV1ItemBinQuantitiesGetItemBinQuantitiesGet'][0])
    {
        return $this->apiV1ItemBinQuantitiesGetItemBinQuantitiesGetAsyncWithHttpInfo($page_number, $page_size, $location_id, $last_updated, $order_id, $order_number, $transfer_id, $transfer_number, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ItemBinQuantitiesGetItemBinQuantitiesGetAsyncWithHttpInfo
     *
     * Returns an array of ItemBinQuantities that match the specified search criteria  If the customer order number or inventory transfer search parameters aren&#39;t set  then the last updated date and location id are required parameters
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $location_id (optional)
     * @param  \DateTime|null $last_updated (optional)
     * @param  int|null $order_id (optional)
     * @param  string|null $order_number (optional)
     * @param  int|null $transfer_id (optional)
     * @param  string|null $transfer_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemBinQuantitiesGetItemBinQuantitiesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemBinQuantitiesGetItemBinQuantitiesGetAsyncWithHttpInfo($page_number = null, $page_size = null, $location_id = null, $last_updated = null, $order_id = null, $order_number = null, $transfer_id = null, $transfer_number = null, string $contentType = self::contentTypes['apiV1ItemBinQuantitiesGetItemBinQuantitiesGet'][0])
    {
        $returnType = '\Opsuite2\Model\ItemBinQuantities[]';
        $request = $this->apiV1ItemBinQuantitiesGetItemBinQuantitiesGetRequest($page_number, $page_size, $location_id, $last_updated, $order_id, $order_number, $transfer_id, $transfer_number, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ItemBinQuantitiesGetItemBinQuantitiesGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $location_id (optional)
     * @param  \DateTime|null $last_updated (optional)
     * @param  int|null $order_id (optional)
     * @param  string|null $order_number (optional)
     * @param  int|null $transfer_id (optional)
     * @param  string|null $transfer_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemBinQuantitiesGetItemBinQuantitiesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ItemBinQuantitiesGetItemBinQuantitiesGetRequest($page_number = null, $page_size = null, $location_id = null, $last_updated = null, $order_id = null, $order_number = null, $transfer_id = null, $transfer_number = null, string $contentType = self::contentTypes['apiV1ItemBinQuantitiesGetItemBinQuantitiesGet'][0])
    {










        $resourcePath = '/api/v1/ItemBinQuantities/GetItemBinQuantities';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $location_id,
            'LocationId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $last_updated,
            'LastUpdated', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_id,
            'OrderId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_number,
            'OrderNumber', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $transfer_id,
            'TransferId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $transfer_number,
            'TransferNumber', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPost
     *
     * Posts an array of ItemBinQuantitiesUpdates
     *
     * @param  \Opsuite2\Model\ItemBinQuantitiesUpdate[]|null $item_bin_quantities_update item_bin_quantities_update (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemBinQuantitiesUpdate[]|string|string
     */
    public function apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPost($item_bin_quantities_update = null, string $contentType = self::contentTypes['apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPost'][0])
    {
        list($response) = $this->apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPostWithHttpInfo($item_bin_quantities_update, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPostWithHttpInfo
     *
     * Posts an array of ItemBinQuantitiesUpdates
     *
     * @param  \Opsuite2\Model\ItemBinQuantitiesUpdate[]|null $item_bin_quantities_update (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemBinQuantitiesUpdate[]|string|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPostWithHttpInfo($item_bin_quantities_update = null, string $contentType = self::contentTypes['apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPost'][0])
    {
        $request = $this->apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPostRequest($item_bin_quantities_update, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemBinQuantitiesUpdate[]',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemBinQuantitiesUpdate[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemBinQuantitiesUpdate[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPostAsync
     *
     * Posts an array of ItemBinQuantitiesUpdates
     *
     * @param  \Opsuite2\Model\ItemBinQuantitiesUpdate[]|null $item_bin_quantities_update (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPostAsync($item_bin_quantities_update = null, string $contentType = self::contentTypes['apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPost'][0])
    {
        return $this->apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPostAsyncWithHttpInfo($item_bin_quantities_update, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPostAsyncWithHttpInfo
     *
     * Posts an array of ItemBinQuantitiesUpdates
     *
     * @param  \Opsuite2\Model\ItemBinQuantitiesUpdate[]|null $item_bin_quantities_update (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPostAsyncWithHttpInfo($item_bin_quantities_update = null, string $contentType = self::contentTypes['apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPost'][0])
    {
        $returnType = '\Opsuite2\Model\ItemBinQuantitiesUpdate[]';
        $request = $this->apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPostRequest($item_bin_quantities_update, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPost'
     *
     * @param  \Opsuite2\Model\ItemBinQuantitiesUpdate[]|null $item_bin_quantities_update (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPostRequest($item_bin_quantities_update = null, string $contentType = self::contentTypes['apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPost'][0])
    {



        $resourcePath = '/api/v1/ItemBinQuantities/UpdateItemBinQuantitiesById';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($item_bin_quantities_update)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($item_bin_quantities_update));
            } else {
                $httpBody = $item_bin_quantities_update;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPost
     *
     * Posts an array of ItemBinQuantitiesUpdates
     *
     * @param  \Opsuite2\Model\ItemBinQuantitiesUpdateByName[]|null $item_bin_quantities_update_by_name item_bin_quantities_update_by_name (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\ItemBinQuantitiesUpdate[]|string|string
     */
    public function apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPost($item_bin_quantities_update_by_name = null, string $contentType = self::contentTypes['apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPost'][0])
    {
        list($response) = $this->apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPostWithHttpInfo($item_bin_quantities_update_by_name, $contentType);
        return $response;
    }

    /**
     * Operation apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPostWithHttpInfo
     *
     * Posts an array of ItemBinQuantitiesUpdates
     *
     * @param  \Opsuite2\Model\ItemBinQuantitiesUpdateByName[]|null $item_bin_quantities_update_by_name (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\ItemBinQuantitiesUpdate[]|string|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPostWithHttpInfo($item_bin_quantities_update_by_name = null, string $contentType = self::contentTypes['apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPost'][0])
    {
        $request = $this->apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPostRequest($item_bin_quantities_update_by_name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\ItemBinQuantitiesUpdate[]',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\ItemBinQuantitiesUpdate[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\ItemBinQuantitiesUpdate[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPostAsync
     *
     * Posts an array of ItemBinQuantitiesUpdates
     *
     * @param  \Opsuite2\Model\ItemBinQuantitiesUpdateByName[]|null $item_bin_quantities_update_by_name (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPostAsync($item_bin_quantities_update_by_name = null, string $contentType = self::contentTypes['apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPost'][0])
    {
        return $this->apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPostAsyncWithHttpInfo($item_bin_quantities_update_by_name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPostAsyncWithHttpInfo
     *
     * Posts an array of ItemBinQuantitiesUpdates
     *
     * @param  \Opsuite2\Model\ItemBinQuantitiesUpdateByName[]|null $item_bin_quantities_update_by_name (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPostAsyncWithHttpInfo($item_bin_quantities_update_by_name = null, string $contentType = self::contentTypes['apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPost'][0])
    {
        $returnType = '\Opsuite2\Model\ItemBinQuantitiesUpdate[]';
        $request = $this->apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPostRequest($item_bin_quantities_update_by_name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPost'
     *
     * @param  \Opsuite2\Model\ItemBinQuantitiesUpdateByName[]|null $item_bin_quantities_update_by_name (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPostRequest($item_bin_quantities_update_by_name = null, string $contentType = self::contentTypes['apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPost'][0])
    {



        $resourcePath = '/api/v1/ItemBinQuantities/UpdateItemBinQuantities';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($item_bin_quantities_update_by_name)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($item_bin_quantities_update_by_name));
            } else {
                $httpBody = $item_bin_quantities_update_by_name;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
