<?php
/**
 * InvoiceMatchingApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Opsuite2\ApiException;
use Opsuite2\Configuration;
use Opsuite2\FormDataProcessor;
use Opsuite2\HeaderSelector;
use Opsuite2\ObjectSerializer;

/**
 * InvoiceMatchingApi Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class InvoiceMatchingApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV1InvoiceMatchingGet' => [
            'application/json',
        ],
        'apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGet' => [
            'application/json',
        ],
        'apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGet' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV1InvoiceMatchingGet
     *
     * Returns an array of Invoices.
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  \DateTime|null $invoice_creation_start_date invoice_creation_start_date (optional)
     * @param  \DateTime|null $invoice_creation_end_date invoice_creation_end_date (optional)
     * @param  \Opsuite2\Model\InvoiceTypeEnum|null $invoice_type invoice_type (optional)
     * @param  string|null $status status (optional)
     * @param  string|null $invoice_number_start invoice_number_start (optional)
     * @param  string|null $invoice_number_end invoice_number_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1InvoiceMatchingGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\InvoiceMatching[]|string
     */
    public function apiV1InvoiceMatchingGet($page_number = null, $page_size = null, $invoice_creation_start_date = null, $invoice_creation_end_date = null, $invoice_type = null, $status = null, $invoice_number_start = null, $invoice_number_end = null, string $contentType = self::contentTypes['apiV1InvoiceMatchingGet'][0])
    {
        list($response) = $this->apiV1InvoiceMatchingGetWithHttpInfo($page_number, $page_size, $invoice_creation_start_date, $invoice_creation_end_date, $invoice_type, $status, $invoice_number_start, $invoice_number_end, $contentType);
        return $response;
    }

    /**
     * Operation apiV1InvoiceMatchingGetWithHttpInfo
     *
     * Returns an array of Invoices.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $invoice_creation_start_date (optional)
     * @param  \DateTime|null $invoice_creation_end_date (optional)
     * @param  \Opsuite2\Model\InvoiceTypeEnum|null $invoice_type (optional)
     * @param  string|null $status (optional)
     * @param  string|null $invoice_number_start (optional)
     * @param  string|null $invoice_number_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1InvoiceMatchingGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\InvoiceMatching[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1InvoiceMatchingGetWithHttpInfo($page_number = null, $page_size = null, $invoice_creation_start_date = null, $invoice_creation_end_date = null, $invoice_type = null, $status = null, $invoice_number_start = null, $invoice_number_end = null, string $contentType = self::contentTypes['apiV1InvoiceMatchingGet'][0])
    {
        $request = $this->apiV1InvoiceMatchingGetRequest($page_number, $page_size, $invoice_creation_start_date, $invoice_creation_end_date, $invoice_type, $status, $invoice_number_start, $invoice_number_end, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\InvoiceMatching[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\InvoiceMatching[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\InvoiceMatching[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1InvoiceMatchingGetAsync
     *
     * Returns an array of Invoices.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $invoice_creation_start_date (optional)
     * @param  \DateTime|null $invoice_creation_end_date (optional)
     * @param  \Opsuite2\Model\InvoiceTypeEnum|null $invoice_type (optional)
     * @param  string|null $status (optional)
     * @param  string|null $invoice_number_start (optional)
     * @param  string|null $invoice_number_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1InvoiceMatchingGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1InvoiceMatchingGetAsync($page_number = null, $page_size = null, $invoice_creation_start_date = null, $invoice_creation_end_date = null, $invoice_type = null, $status = null, $invoice_number_start = null, $invoice_number_end = null, string $contentType = self::contentTypes['apiV1InvoiceMatchingGet'][0])
    {
        return $this->apiV1InvoiceMatchingGetAsyncWithHttpInfo($page_number, $page_size, $invoice_creation_start_date, $invoice_creation_end_date, $invoice_type, $status, $invoice_number_start, $invoice_number_end, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1InvoiceMatchingGetAsyncWithHttpInfo
     *
     * Returns an array of Invoices.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $invoice_creation_start_date (optional)
     * @param  \DateTime|null $invoice_creation_end_date (optional)
     * @param  \Opsuite2\Model\InvoiceTypeEnum|null $invoice_type (optional)
     * @param  string|null $status (optional)
     * @param  string|null $invoice_number_start (optional)
     * @param  string|null $invoice_number_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1InvoiceMatchingGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1InvoiceMatchingGetAsyncWithHttpInfo($page_number = null, $page_size = null, $invoice_creation_start_date = null, $invoice_creation_end_date = null, $invoice_type = null, $status = null, $invoice_number_start = null, $invoice_number_end = null, string $contentType = self::contentTypes['apiV1InvoiceMatchingGet'][0])
    {
        $returnType = '\Opsuite2\Model\InvoiceMatching[]';
        $request = $this->apiV1InvoiceMatchingGetRequest($page_number, $page_size, $invoice_creation_start_date, $invoice_creation_end_date, $invoice_type, $status, $invoice_number_start, $invoice_number_end, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1InvoiceMatchingGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $invoice_creation_start_date (optional)
     * @param  \DateTime|null $invoice_creation_end_date (optional)
     * @param  \Opsuite2\Model\InvoiceTypeEnum|null $invoice_type (optional)
     * @param  string|null $status (optional)
     * @param  string|null $invoice_number_start (optional)
     * @param  string|null $invoice_number_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1InvoiceMatchingGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1InvoiceMatchingGetRequest($page_number = null, $page_size = null, $invoice_creation_start_date = null, $invoice_creation_end_date = null, $invoice_type = null, $status = null, $invoice_number_start = null, $invoice_number_end = null, string $contentType = self::contentTypes['apiV1InvoiceMatchingGet'][0])
    {










        $resourcePath = '/api/v1/InvoiceMatching';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $invoice_creation_start_date,
            'InvoiceCreationStartDate', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $invoice_creation_end_date,
            'InvoiceCreationEndDate', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $invoice_type,
            'InvoiceType', // param base name
            'InvoiceTypeEnum', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $status,
            'Status', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $invoice_number_start,
            'InvoiceNumberStart', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $invoice_number_end,
            'InvoiceNumberEnd', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGet
     *
     * Return a paged list of items on the specified invoice  Querystring parameters:      pageSize - specify how many records to be returned      pageNumber - specify page number based upon the page size
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  int|null $invoice_document_id invoice_document_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\InvoiceMatchingLine[]|string
     */
    public function apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGet($page_number = null, $page_size = null, $invoice_document_id = null, string $contentType = self::contentTypes['apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGet'][0])
    {
        list($response) = $this->apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGetWithHttpInfo($page_number, $page_size, $invoice_document_id, $contentType);
        return $response;
    }

    /**
     * Operation apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGetWithHttpInfo
     *
     * Return a paged list of items on the specified invoice  Querystring parameters:      pageSize - specify how many records to be returned      pageNumber - specify page number based upon the page size
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $invoice_document_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\InvoiceMatchingLine[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGetWithHttpInfo($page_number = null, $page_size = null, $invoice_document_id = null, string $contentType = self::contentTypes['apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGet'][0])
    {
        $request = $this->apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGetRequest($page_number, $page_size, $invoice_document_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\InvoiceMatchingLine[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\InvoiceMatchingLine[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\InvoiceMatchingLine[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGetAsync
     *
     * Return a paged list of items on the specified invoice  Querystring parameters:      pageSize - specify how many records to be returned      pageNumber - specify page number based upon the page size
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $invoice_document_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGetAsync($page_number = null, $page_size = null, $invoice_document_id = null, string $contentType = self::contentTypes['apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGet'][0])
    {
        return $this->apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGetAsyncWithHttpInfo($page_number, $page_size, $invoice_document_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGetAsyncWithHttpInfo
     *
     * Return a paged list of items on the specified invoice  Querystring parameters:      pageSize - specify how many records to be returned      pageNumber - specify page number based upon the page size
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $invoice_document_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGetAsyncWithHttpInfo($page_number = null, $page_size = null, $invoice_document_id = null, string $contentType = self::contentTypes['apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGet'][0])
    {
        $returnType = '\Opsuite2\Model\InvoiceMatchingLine[]';
        $request = $this->apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGetRequest($page_number, $page_size, $invoice_document_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $invoice_document_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGetRequest($page_number = null, $page_size = null, $invoice_document_id = null, string $contentType = self::contentTypes['apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGet'][0])
    {





        $resourcePath = '/api/v1/InvoiceMatching/GetInvoiceMatchingItemDetailsById';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $invoice_document_id,
            'invoiceDocumentId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGet
     *
     * Return a paged list of items on the specified invoice  Querystring parameters:      pageSize - specify how many records to be returned      pageNumber - specify page number based upon the page size
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  string|null $invoice_number invoice_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\InvoiceMatchingLine[]|string
     */
    public function apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGet($page_number = null, $page_size = null, $invoice_number = null, string $contentType = self::contentTypes['apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGet'][0])
    {
        list($response) = $this->apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGetWithHttpInfo($page_number, $page_size, $invoice_number, $contentType);
        return $response;
    }

    /**
     * Operation apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGetWithHttpInfo
     *
     * Return a paged list of items on the specified invoice  Querystring parameters:      pageSize - specify how many records to be returned      pageNumber - specify page number based upon the page size
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string|null $invoice_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\InvoiceMatchingLine[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGetWithHttpInfo($page_number = null, $page_size = null, $invoice_number = null, string $contentType = self::contentTypes['apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGet'][0])
    {
        $request = $this->apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGetRequest($page_number, $page_size, $invoice_number, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\InvoiceMatchingLine[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\InvoiceMatchingLine[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\InvoiceMatchingLine[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGetAsync
     *
     * Return a paged list of items on the specified invoice  Querystring parameters:      pageSize - specify how many records to be returned      pageNumber - specify page number based upon the page size
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string|null $invoice_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGetAsync($page_number = null, $page_size = null, $invoice_number = null, string $contentType = self::contentTypes['apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGet'][0])
    {
        return $this->apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGetAsyncWithHttpInfo($page_number, $page_size, $invoice_number, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGetAsyncWithHttpInfo
     *
     * Return a paged list of items on the specified invoice  Querystring parameters:      pageSize - specify how many records to be returned      pageNumber - specify page number based upon the page size
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string|null $invoice_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGetAsyncWithHttpInfo($page_number = null, $page_size = null, $invoice_number = null, string $contentType = self::contentTypes['apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGet'][0])
    {
        $returnType = '\Opsuite2\Model\InvoiceMatchingLine[]';
        $request = $this->apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGetRequest($page_number, $page_size, $invoice_number, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string|null $invoice_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGetRequest($page_number = null, $page_size = null, $invoice_number = null, string $contentType = self::contentTypes['apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGet'][0])
    {





        $resourcePath = '/api/v1/InvoiceMatching/GetInvoiceMatchingItemDetailsByNumber';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $invoice_number,
            'invoiceNumber', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
