<?php
/**
 * GRNDetailsApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Opsuite2\ApiException;
use Opsuite2\Configuration;
use Opsuite2\FormDataProcessor;
use Opsuite2\HeaderSelector;
use Opsuite2\ObjectSerializer;

/**
 * GRNDetailsApi Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class GRNDetailsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV1GRNDetailsGetGRNDetailsByOrderNumberGet' => [
            'application/json',
        ],
        'apiV1GRNDetailsGetGRNDetailsGet' => [
            'application/json',
        ],
        'apiV1GRNDetailsGetGRNLinesByGRNNumberGet' => [
            'application/json',
        ],
        'apiV1GRNDetailsGetGRNLinesByIdGet' => [
            'application/json',
        ],
        'getGRNDetailsById' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV1GRNDetailsGetGRNDetailsByOrderNumberGet
     *
     * Returns a GRNDetails for a given inventory control document order number.
     *
     * @param  string|null $order_number order_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1GRNDetailsGetGRNDetailsByOrderNumberGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\GRNDetails|string
     */
    public function apiV1GRNDetailsGetGRNDetailsByOrderNumberGet($order_number = null, string $contentType = self::contentTypes['apiV1GRNDetailsGetGRNDetailsByOrderNumberGet'][0])
    {
        list($response) = $this->apiV1GRNDetailsGetGRNDetailsByOrderNumberGetWithHttpInfo($order_number, $contentType);
        return $response;
    }

    /**
     * Operation apiV1GRNDetailsGetGRNDetailsByOrderNumberGetWithHttpInfo
     *
     * Returns a GRNDetails for a given inventory control document order number.
     *
     * @param  string|null $order_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1GRNDetailsGetGRNDetailsByOrderNumberGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\GRNDetails|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1GRNDetailsGetGRNDetailsByOrderNumberGetWithHttpInfo($order_number = null, string $contentType = self::contentTypes['apiV1GRNDetailsGetGRNDetailsByOrderNumberGet'][0])
    {
        $request = $this->apiV1GRNDetailsGetGRNDetailsByOrderNumberGetRequest($order_number, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\GRNDetails',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\GRNDetails',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\GRNDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1GRNDetailsGetGRNDetailsByOrderNumberGetAsync
     *
     * Returns a GRNDetails for a given inventory control document order number.
     *
     * @param  string|null $order_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1GRNDetailsGetGRNDetailsByOrderNumberGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1GRNDetailsGetGRNDetailsByOrderNumberGetAsync($order_number = null, string $contentType = self::contentTypes['apiV1GRNDetailsGetGRNDetailsByOrderNumberGet'][0])
    {
        return $this->apiV1GRNDetailsGetGRNDetailsByOrderNumberGetAsyncWithHttpInfo($order_number, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1GRNDetailsGetGRNDetailsByOrderNumberGetAsyncWithHttpInfo
     *
     * Returns a GRNDetails for a given inventory control document order number.
     *
     * @param  string|null $order_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1GRNDetailsGetGRNDetailsByOrderNumberGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1GRNDetailsGetGRNDetailsByOrderNumberGetAsyncWithHttpInfo($order_number = null, string $contentType = self::contentTypes['apiV1GRNDetailsGetGRNDetailsByOrderNumberGet'][0])
    {
        $returnType = '\Opsuite2\Model\GRNDetails';
        $request = $this->apiV1GRNDetailsGetGRNDetailsByOrderNumberGetRequest($order_number, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1GRNDetailsGetGRNDetailsByOrderNumberGet'
     *
     * @param  string|null $order_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1GRNDetailsGetGRNDetailsByOrderNumberGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1GRNDetailsGetGRNDetailsByOrderNumberGetRequest($order_number = null, string $contentType = self::contentTypes['apiV1GRNDetailsGetGRNDetailsByOrderNumberGet'][0])
    {



        $resourcePath = '/api/v1/GRNDetails/GetGRNDetailsByOrderNumber';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_number,
            'orderNumber', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1GRNDetailsGetGRNDetailsGet
     *
     * Returns an array of GRNDetails that match the specified search criteria.
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  \DateTime|null $date_created_date_range_start date_created_date_range_start (optional)
     * @param  \DateTime|null $date_created_date_range_end date_created_date_range_end (optional)
     * @param  \DateTime|null $date_committed_date_range_start date_committed_date_range_start (optional)
     * @param  \DateTime|null $date_committed_date_range_end date_committed_date_range_end (optional)
     * @param  \DateTime|null $last_updated_date_range_start last_updated_date_range_start (optional)
     * @param  \DateTime|null $last_updated_date_range_end last_updated_date_range_end (optional)
     * @param  int|null $location_id location_id (optional)
     * @param  int|null $source_location_id source_location_id (optional)
     * @param  int|null $destination_location_id destination_location_id (optional)
     * @param  \Opsuite2\Model\ReceivingDocumentTypeEnum|null $receiving_document_type receiving_document_type (optional)
     * @param  string|null $order_number order_number (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_number_search_operator order_number_search_operator (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1GRNDetailsGetGRNDetailsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\GRNDetails[]|string
     */
    public function apiV1GRNDetailsGetGRNDetailsGet($page_number = null, $page_size = null, $date_created_date_range_start = null, $date_created_date_range_end = null, $date_committed_date_range_start = null, $date_committed_date_range_end = null, $last_updated_date_range_start = null, $last_updated_date_range_end = null, $location_id = null, $source_location_id = null, $destination_location_id = null, $receiving_document_type = null, $order_number = null, $order_number_search_operator = null, string $contentType = self::contentTypes['apiV1GRNDetailsGetGRNDetailsGet'][0])
    {
        list($response) = $this->apiV1GRNDetailsGetGRNDetailsGetWithHttpInfo($page_number, $page_size, $date_created_date_range_start, $date_created_date_range_end, $date_committed_date_range_start, $date_committed_date_range_end, $last_updated_date_range_start, $last_updated_date_range_end, $location_id, $source_location_id, $destination_location_id, $receiving_document_type, $order_number, $order_number_search_operator, $contentType);
        return $response;
    }

    /**
     * Operation apiV1GRNDetailsGetGRNDetailsGetWithHttpInfo
     *
     * Returns an array of GRNDetails that match the specified search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $date_created_date_range_start (optional)
     * @param  \DateTime|null $date_created_date_range_end (optional)
     * @param  \DateTime|null $date_committed_date_range_start (optional)
     * @param  \DateTime|null $date_committed_date_range_end (optional)
     * @param  \DateTime|null $last_updated_date_range_start (optional)
     * @param  \DateTime|null $last_updated_date_range_end (optional)
     * @param  int|null $location_id (optional)
     * @param  int|null $source_location_id (optional)
     * @param  int|null $destination_location_id (optional)
     * @param  \Opsuite2\Model\ReceivingDocumentTypeEnum|null $receiving_document_type (optional)
     * @param  string|null $order_number (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_number_search_operator (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1GRNDetailsGetGRNDetailsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\GRNDetails[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1GRNDetailsGetGRNDetailsGetWithHttpInfo($page_number = null, $page_size = null, $date_created_date_range_start = null, $date_created_date_range_end = null, $date_committed_date_range_start = null, $date_committed_date_range_end = null, $last_updated_date_range_start = null, $last_updated_date_range_end = null, $location_id = null, $source_location_id = null, $destination_location_id = null, $receiving_document_type = null, $order_number = null, $order_number_search_operator = null, string $contentType = self::contentTypes['apiV1GRNDetailsGetGRNDetailsGet'][0])
    {
        $request = $this->apiV1GRNDetailsGetGRNDetailsGetRequest($page_number, $page_size, $date_created_date_range_start, $date_created_date_range_end, $date_committed_date_range_start, $date_committed_date_range_end, $last_updated_date_range_start, $last_updated_date_range_end, $location_id, $source_location_id, $destination_location_id, $receiving_document_type, $order_number, $order_number_search_operator, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\GRNDetails[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\GRNDetails[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\GRNDetails[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1GRNDetailsGetGRNDetailsGetAsync
     *
     * Returns an array of GRNDetails that match the specified search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $date_created_date_range_start (optional)
     * @param  \DateTime|null $date_created_date_range_end (optional)
     * @param  \DateTime|null $date_committed_date_range_start (optional)
     * @param  \DateTime|null $date_committed_date_range_end (optional)
     * @param  \DateTime|null $last_updated_date_range_start (optional)
     * @param  \DateTime|null $last_updated_date_range_end (optional)
     * @param  int|null $location_id (optional)
     * @param  int|null $source_location_id (optional)
     * @param  int|null $destination_location_id (optional)
     * @param  \Opsuite2\Model\ReceivingDocumentTypeEnum|null $receiving_document_type (optional)
     * @param  string|null $order_number (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_number_search_operator (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1GRNDetailsGetGRNDetailsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1GRNDetailsGetGRNDetailsGetAsync($page_number = null, $page_size = null, $date_created_date_range_start = null, $date_created_date_range_end = null, $date_committed_date_range_start = null, $date_committed_date_range_end = null, $last_updated_date_range_start = null, $last_updated_date_range_end = null, $location_id = null, $source_location_id = null, $destination_location_id = null, $receiving_document_type = null, $order_number = null, $order_number_search_operator = null, string $contentType = self::contentTypes['apiV1GRNDetailsGetGRNDetailsGet'][0])
    {
        return $this->apiV1GRNDetailsGetGRNDetailsGetAsyncWithHttpInfo($page_number, $page_size, $date_created_date_range_start, $date_created_date_range_end, $date_committed_date_range_start, $date_committed_date_range_end, $last_updated_date_range_start, $last_updated_date_range_end, $location_id, $source_location_id, $destination_location_id, $receiving_document_type, $order_number, $order_number_search_operator, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1GRNDetailsGetGRNDetailsGetAsyncWithHttpInfo
     *
     * Returns an array of GRNDetails that match the specified search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $date_created_date_range_start (optional)
     * @param  \DateTime|null $date_created_date_range_end (optional)
     * @param  \DateTime|null $date_committed_date_range_start (optional)
     * @param  \DateTime|null $date_committed_date_range_end (optional)
     * @param  \DateTime|null $last_updated_date_range_start (optional)
     * @param  \DateTime|null $last_updated_date_range_end (optional)
     * @param  int|null $location_id (optional)
     * @param  int|null $source_location_id (optional)
     * @param  int|null $destination_location_id (optional)
     * @param  \Opsuite2\Model\ReceivingDocumentTypeEnum|null $receiving_document_type (optional)
     * @param  string|null $order_number (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_number_search_operator (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1GRNDetailsGetGRNDetailsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1GRNDetailsGetGRNDetailsGetAsyncWithHttpInfo($page_number = null, $page_size = null, $date_created_date_range_start = null, $date_created_date_range_end = null, $date_committed_date_range_start = null, $date_committed_date_range_end = null, $last_updated_date_range_start = null, $last_updated_date_range_end = null, $location_id = null, $source_location_id = null, $destination_location_id = null, $receiving_document_type = null, $order_number = null, $order_number_search_operator = null, string $contentType = self::contentTypes['apiV1GRNDetailsGetGRNDetailsGet'][0])
    {
        $returnType = '\Opsuite2\Model\GRNDetails[]';
        $request = $this->apiV1GRNDetailsGetGRNDetailsGetRequest($page_number, $page_size, $date_created_date_range_start, $date_created_date_range_end, $date_committed_date_range_start, $date_committed_date_range_end, $last_updated_date_range_start, $last_updated_date_range_end, $location_id, $source_location_id, $destination_location_id, $receiving_document_type, $order_number, $order_number_search_operator, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1GRNDetailsGetGRNDetailsGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $date_created_date_range_start (optional)
     * @param  \DateTime|null $date_created_date_range_end (optional)
     * @param  \DateTime|null $date_committed_date_range_start (optional)
     * @param  \DateTime|null $date_committed_date_range_end (optional)
     * @param  \DateTime|null $last_updated_date_range_start (optional)
     * @param  \DateTime|null $last_updated_date_range_end (optional)
     * @param  int|null $location_id (optional)
     * @param  int|null $source_location_id (optional)
     * @param  int|null $destination_location_id (optional)
     * @param  \Opsuite2\Model\ReceivingDocumentTypeEnum|null $receiving_document_type (optional)
     * @param  string|null $order_number (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $order_number_search_operator (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1GRNDetailsGetGRNDetailsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1GRNDetailsGetGRNDetailsGetRequest($page_number = null, $page_size = null, $date_created_date_range_start = null, $date_created_date_range_end = null, $date_committed_date_range_start = null, $date_committed_date_range_end = null, $last_updated_date_range_start = null, $last_updated_date_range_end = null, $location_id = null, $source_location_id = null, $destination_location_id = null, $receiving_document_type = null, $order_number = null, $order_number_search_operator = null, string $contentType = self::contentTypes['apiV1GRNDetailsGetGRNDetailsGet'][0])
    {
















        $resourcePath = '/api/v1/GRNDetails/GetGRNDetails';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_created_date_range_start,
            'DateCreatedDateRangeStart', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_created_date_range_end,
            'DateCreatedDateRangeEnd', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_committed_date_range_start,
            'DateCommittedDateRangeStart', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_committed_date_range_end,
            'DateCommittedDateRangeEnd', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $last_updated_date_range_start,
            'LastUpdatedDateRangeStart', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $last_updated_date_range_end,
            'LastUpdatedDateRangeEnd', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $location_id,
            'LocationId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $source_location_id,
            'SourceLocationId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $destination_location_id,
            'DestinationLocationId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $receiving_document_type,
            'ReceivingDocumentType', // param base name
            'ReceivingDocumentTypeEnum', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_number,
            'OrderNumber', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_number_search_operator,
            'OrderNumberSearchOperator', // param base name
            'SimpleSearchOperatorEnum', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1GRNDetailsGetGRNLinesByGRNNumberGet
     *
     * Returns the lines on a GRN.
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  string|null $grn_number grn_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1GRNDetailsGetGRNLinesByGRNNumberGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function apiV1GRNDetailsGetGRNLinesByGRNNumberGet($page_number = null, $page_size = null, $grn_number = null, string $contentType = self::contentTypes['apiV1GRNDetailsGetGRNLinesByGRNNumberGet'][0])
    {
        $this->apiV1GRNDetailsGetGRNLinesByGRNNumberGetWithHttpInfo($page_number, $page_size, $grn_number, $contentType);
    }

    /**
     * Operation apiV1GRNDetailsGetGRNLinesByGRNNumberGetWithHttpInfo
     *
     * Returns the lines on a GRN.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string|null $grn_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1GRNDetailsGetGRNLinesByGRNNumberGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1GRNDetailsGetGRNLinesByGRNNumberGetWithHttpInfo($page_number = null, $page_size = null, $grn_number = null, string $contentType = self::contentTypes['apiV1GRNDetailsGetGRNLinesByGRNNumberGet'][0])
    {
        $request = $this->apiV1GRNDetailsGetGRNLinesByGRNNumberGetRequest($page_number, $page_size, $grn_number, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1GRNDetailsGetGRNLinesByGRNNumberGetAsync
     *
     * Returns the lines on a GRN.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string|null $grn_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1GRNDetailsGetGRNLinesByGRNNumberGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1GRNDetailsGetGRNLinesByGRNNumberGetAsync($page_number = null, $page_size = null, $grn_number = null, string $contentType = self::contentTypes['apiV1GRNDetailsGetGRNLinesByGRNNumberGet'][0])
    {
        return $this->apiV1GRNDetailsGetGRNLinesByGRNNumberGetAsyncWithHttpInfo($page_number, $page_size, $grn_number, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1GRNDetailsGetGRNLinesByGRNNumberGetAsyncWithHttpInfo
     *
     * Returns the lines on a GRN.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string|null $grn_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1GRNDetailsGetGRNLinesByGRNNumberGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1GRNDetailsGetGRNLinesByGRNNumberGetAsyncWithHttpInfo($page_number = null, $page_size = null, $grn_number = null, string $contentType = self::contentTypes['apiV1GRNDetailsGetGRNLinesByGRNNumberGet'][0])
    {
        $returnType = '';
        $request = $this->apiV1GRNDetailsGetGRNLinesByGRNNumberGetRequest($page_number, $page_size, $grn_number, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1GRNDetailsGetGRNLinesByGRNNumberGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string|null $grn_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1GRNDetailsGetGRNLinesByGRNNumberGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1GRNDetailsGetGRNLinesByGRNNumberGetRequest($page_number = null, $page_size = null, $grn_number = null, string $contentType = self::contentTypes['apiV1GRNDetailsGetGRNLinesByGRNNumberGet'][0])
    {





        $resourcePath = '/api/v1/GRNDetails/GetGRNLinesByGRNNumber';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $grn_number,
            'grnNumber', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1GRNDetailsGetGRNLinesByIdGet
     *
     * Returns the lines on a GRN.
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  int|null $inventory_control_document_id inventory_control_document_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1GRNDetailsGetGRNLinesByIdGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function apiV1GRNDetailsGetGRNLinesByIdGet($page_number = null, $page_size = null, $inventory_control_document_id = null, string $contentType = self::contentTypes['apiV1GRNDetailsGetGRNLinesByIdGet'][0])
    {
        $this->apiV1GRNDetailsGetGRNLinesByIdGetWithHttpInfo($page_number, $page_size, $inventory_control_document_id, $contentType);
    }

    /**
     * Operation apiV1GRNDetailsGetGRNLinesByIdGetWithHttpInfo
     *
     * Returns the lines on a GRN.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $inventory_control_document_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1GRNDetailsGetGRNLinesByIdGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1GRNDetailsGetGRNLinesByIdGetWithHttpInfo($page_number = null, $page_size = null, $inventory_control_document_id = null, string $contentType = self::contentTypes['apiV1GRNDetailsGetGRNLinesByIdGet'][0])
    {
        $request = $this->apiV1GRNDetailsGetGRNLinesByIdGetRequest($page_number, $page_size, $inventory_control_document_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1GRNDetailsGetGRNLinesByIdGetAsync
     *
     * Returns the lines on a GRN.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $inventory_control_document_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1GRNDetailsGetGRNLinesByIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1GRNDetailsGetGRNLinesByIdGetAsync($page_number = null, $page_size = null, $inventory_control_document_id = null, string $contentType = self::contentTypes['apiV1GRNDetailsGetGRNLinesByIdGet'][0])
    {
        return $this->apiV1GRNDetailsGetGRNLinesByIdGetAsyncWithHttpInfo($page_number, $page_size, $inventory_control_document_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1GRNDetailsGetGRNLinesByIdGetAsyncWithHttpInfo
     *
     * Returns the lines on a GRN.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $inventory_control_document_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1GRNDetailsGetGRNLinesByIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1GRNDetailsGetGRNLinesByIdGetAsyncWithHttpInfo($page_number = null, $page_size = null, $inventory_control_document_id = null, string $contentType = self::contentTypes['apiV1GRNDetailsGetGRNLinesByIdGet'][0])
    {
        $returnType = '';
        $request = $this->apiV1GRNDetailsGetGRNLinesByIdGetRequest($page_number, $page_size, $inventory_control_document_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1GRNDetailsGetGRNLinesByIdGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $inventory_control_document_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1GRNDetailsGetGRNLinesByIdGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1GRNDetailsGetGRNLinesByIdGetRequest($page_number = null, $page_size = null, $inventory_control_document_id = null, string $contentType = self::contentTypes['apiV1GRNDetailsGetGRNLinesByIdGet'][0])
    {





        $resourcePath = '/api/v1/GRNDetails/GetGRNLinesById';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $inventory_control_document_id,
            'inventoryControlDocumentId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGRNDetailsById
     *
     * Returns a GRNDetails for a given receiving document id.
     *
     * @param  int $receiving_document_id receiving_document_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGRNDetailsById'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\GRNDetails|string
     */
    public function getGRNDetailsById($receiving_document_id, string $contentType = self::contentTypes['getGRNDetailsById'][0])
    {
        list($response) = $this->getGRNDetailsByIdWithHttpInfo($receiving_document_id, $contentType);
        return $response;
    }

    /**
     * Operation getGRNDetailsByIdWithHttpInfo
     *
     * Returns a GRNDetails for a given receiving document id.
     *
     * @param  int $receiving_document_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGRNDetailsById'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\GRNDetails|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGRNDetailsByIdWithHttpInfo($receiving_document_id, string $contentType = self::contentTypes['getGRNDetailsById'][0])
    {
        $request = $this->getGRNDetailsByIdRequest($receiving_document_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\GRNDetails',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\GRNDetails',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\GRNDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getGRNDetailsByIdAsync
     *
     * Returns a GRNDetails for a given receiving document id.
     *
     * @param  int $receiving_document_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGRNDetailsById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGRNDetailsByIdAsync($receiving_document_id, string $contentType = self::contentTypes['getGRNDetailsById'][0])
    {
        return $this->getGRNDetailsByIdAsyncWithHttpInfo($receiving_document_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGRNDetailsByIdAsyncWithHttpInfo
     *
     * Returns a GRNDetails for a given receiving document id.
     *
     * @param  int $receiving_document_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGRNDetailsById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGRNDetailsByIdAsyncWithHttpInfo($receiving_document_id, string $contentType = self::contentTypes['getGRNDetailsById'][0])
    {
        $returnType = '\Opsuite2\Model\GRNDetails';
        $request = $this->getGRNDetailsByIdRequest($receiving_document_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGRNDetailsById'
     *
     * @param  int $receiving_document_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGRNDetailsById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGRNDetailsByIdRequest($receiving_document_id, string $contentType = self::contentTypes['getGRNDetailsById'][0])
    {

        // verify the required parameter 'receiving_document_id' is set
        if ($receiving_document_id === null || (is_array($receiving_document_id) && count($receiving_document_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $receiving_document_id when calling getGRNDetailsById'
            );
        }
        if ($receiving_document_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$receiving_document_id" when calling GRNDetailsApi.getGRNDetailsById, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v1/GRNDetails/{receivingDocumentId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($receiving_document_id !== null) {
            $resourcePath = str_replace(
                '{' . 'receivingDocumentId' . '}',
                ObjectSerializer::toPathValue($receiving_document_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
