<?php
/**
 * CustomersApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Opsuite2\ApiException;
use Opsuite2\Configuration;
use Opsuite2\FormDataProcessor;
use Opsuite2\HeaderSelector;
use Opsuite2\ObjectSerializer;

/**
 * CustomersApi Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class CustomersApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV1CustomersCustomerIdAllContactsGet' => [
            'application/json',
        ],
        'apiV1CustomersCustomerIdAlternativeShipToContactsGet' => [
            'application/json',
        ],
        'apiV1CustomersCustomerIdContactsGet' => [
            'application/json',
        ],
        'apiV1CustomersCustomerIdCustomerLoyaltyFieldsGet' => [
            'application/json',
        ],
        'apiV1CustomersCustomerIdDiscountCouponsGet' => [
            'application/json',
        ],
        'apiV1CustomersCustomerIdLoyaltyBalancesGet' => [
            'application/json',
        ],
        'apiV1CustomersCustomerIdLoyaltyCardsGet' => [
            'application/json',
        ],
        'apiV1CustomersCustomerIdLoyaltyTransactionsGet' => [
            'application/json',
        ],
        'apiV1CustomersCustomerIdPatch' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'apiV1CustomersCustomerIdPromotionCouponsGet' => [
            'application/json',
        ],
        'apiV1CustomersCustomerIdTransactionHeadersGet' => [
            'application/json',
        ],
        'apiV1CustomersExpiringLoyaltyTransactionsGet' => [
            'application/json',
        ],
        'apiV1CustomersExpiryingLoyaltyTransactionsGet' => [
            'application/json',
        ],
        'apiV1CustomersGet' => [
            'application/json',
        ],
        'apiV1CustomersGetCustomerByAccountNumberGet' => [
            'application/json',
        ],
        'apiV1CustomersGetCustomerByAddressGet' => [
            'application/json',
        ],
        'apiV1CustomersGetCustomerByEmailAddressGet' => [
            'application/json',
        ],
        'apiV1CustomersPost' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'apiV1CustomersPut' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'getCustomerById' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV1CustomersCustomerIdAllContactsGet
     *
     * Returns an array of all contacts for the specified customer.
     *
     * @param  int $customer_id customer_id (required)
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdAllContactsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\CustomerContact[]|string
     */
    public function apiV1CustomersCustomerIdAllContactsGet($customer_id, $page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdAllContactsGet'][0])
    {
        list($response) = $this->apiV1CustomersCustomerIdAllContactsGetWithHttpInfo($customer_id, $page_number, $page_size, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CustomersCustomerIdAllContactsGetWithHttpInfo
     *
     * Returns an array of all contacts for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdAllContactsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\CustomerContact[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersCustomerIdAllContactsGetWithHttpInfo($customer_id, $page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdAllContactsGet'][0])
    {
        $request = $this->apiV1CustomersCustomerIdAllContactsGetRequest($customer_id, $page_number, $page_size, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\CustomerContact[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\CustomerContact[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\CustomerContact[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersCustomerIdAllContactsGetAsync
     *
     * Returns an array of all contacts for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdAllContactsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersCustomerIdAllContactsGetAsync($customer_id, $page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdAllContactsGet'][0])
    {
        return $this->apiV1CustomersCustomerIdAllContactsGetAsyncWithHttpInfo($customer_id, $page_number, $page_size, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersCustomerIdAllContactsGetAsyncWithHttpInfo
     *
     * Returns an array of all contacts for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdAllContactsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersCustomerIdAllContactsGetAsyncWithHttpInfo($customer_id, $page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdAllContactsGet'][0])
    {
        $returnType = '\Opsuite2\Model\CustomerContact[]';
        $request = $this->apiV1CustomersCustomerIdAllContactsGetRequest($customer_id, $page_number, $page_size, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersCustomerIdAllContactsGet'
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdAllContactsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomersCustomerIdAllContactsGetRequest($customer_id, $page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdAllContactsGet'][0])
    {

        // verify the required parameter 'customer_id' is set
        if ($customer_id === null || (is_array($customer_id) && count($customer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_id when calling apiV1CustomersCustomerIdAllContactsGet'
            );
        }
        if ($customer_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$customer_id" when calling CustomersApi.apiV1CustomersCustomerIdAllContactsGet, must be bigger than or equal to 1.');
        }
        



        $resourcePath = '/api/v1/Customers/{customerId}/AllContacts';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($customer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customerId' . '}',
                ObjectSerializer::toPathValue($customer_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersCustomerIdAlternativeShipToContactsGet
     *
     * Returns an array of alternative ship to contacts for the specified customer.
     *
     * @param  int $customer_id customer_id (required)
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdAlternativeShipToContactsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\CustomerContact[]|string
     */
    public function apiV1CustomersCustomerIdAlternativeShipToContactsGet($customer_id, $page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdAlternativeShipToContactsGet'][0])
    {
        list($response) = $this->apiV1CustomersCustomerIdAlternativeShipToContactsGetWithHttpInfo($customer_id, $page_number, $page_size, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CustomersCustomerIdAlternativeShipToContactsGetWithHttpInfo
     *
     * Returns an array of alternative ship to contacts for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdAlternativeShipToContactsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\CustomerContact[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersCustomerIdAlternativeShipToContactsGetWithHttpInfo($customer_id, $page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdAlternativeShipToContactsGet'][0])
    {
        $request = $this->apiV1CustomersCustomerIdAlternativeShipToContactsGetRequest($customer_id, $page_number, $page_size, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\CustomerContact[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\CustomerContact[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\CustomerContact[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersCustomerIdAlternativeShipToContactsGetAsync
     *
     * Returns an array of alternative ship to contacts for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdAlternativeShipToContactsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersCustomerIdAlternativeShipToContactsGetAsync($customer_id, $page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdAlternativeShipToContactsGet'][0])
    {
        return $this->apiV1CustomersCustomerIdAlternativeShipToContactsGetAsyncWithHttpInfo($customer_id, $page_number, $page_size, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersCustomerIdAlternativeShipToContactsGetAsyncWithHttpInfo
     *
     * Returns an array of alternative ship to contacts for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdAlternativeShipToContactsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersCustomerIdAlternativeShipToContactsGetAsyncWithHttpInfo($customer_id, $page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdAlternativeShipToContactsGet'][0])
    {
        $returnType = '\Opsuite2\Model\CustomerContact[]';
        $request = $this->apiV1CustomersCustomerIdAlternativeShipToContactsGetRequest($customer_id, $page_number, $page_size, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersCustomerIdAlternativeShipToContactsGet'
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdAlternativeShipToContactsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomersCustomerIdAlternativeShipToContactsGetRequest($customer_id, $page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdAlternativeShipToContactsGet'][0])
    {

        // verify the required parameter 'customer_id' is set
        if ($customer_id === null || (is_array($customer_id) && count($customer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_id when calling apiV1CustomersCustomerIdAlternativeShipToContactsGet'
            );
        }
        if ($customer_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$customer_id" when calling CustomersApi.apiV1CustomersCustomerIdAlternativeShipToContactsGet, must be bigger than or equal to 1.');
        }
        



        $resourcePath = '/api/v1/Customers/{customerId}/AlternativeShipToContacts';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($customer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customerId' . '}',
                ObjectSerializer::toPathValue($customer_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersCustomerIdContactsGet
     *
     * Returns an array of other contacts for the specified customer.
     *
     * @param  int $customer_id customer_id (required)
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdContactsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\CustomerContact[]|string
     */
    public function apiV1CustomersCustomerIdContactsGet($customer_id, $page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdContactsGet'][0])
    {
        list($response) = $this->apiV1CustomersCustomerIdContactsGetWithHttpInfo($customer_id, $page_number, $page_size, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CustomersCustomerIdContactsGetWithHttpInfo
     *
     * Returns an array of other contacts for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdContactsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\CustomerContact[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersCustomerIdContactsGetWithHttpInfo($customer_id, $page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdContactsGet'][0])
    {
        $request = $this->apiV1CustomersCustomerIdContactsGetRequest($customer_id, $page_number, $page_size, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\CustomerContact[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\CustomerContact[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\CustomerContact[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersCustomerIdContactsGetAsync
     *
     * Returns an array of other contacts for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdContactsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersCustomerIdContactsGetAsync($customer_id, $page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdContactsGet'][0])
    {
        return $this->apiV1CustomersCustomerIdContactsGetAsyncWithHttpInfo($customer_id, $page_number, $page_size, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersCustomerIdContactsGetAsyncWithHttpInfo
     *
     * Returns an array of other contacts for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdContactsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersCustomerIdContactsGetAsyncWithHttpInfo($customer_id, $page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdContactsGet'][0])
    {
        $returnType = '\Opsuite2\Model\CustomerContact[]';
        $request = $this->apiV1CustomersCustomerIdContactsGetRequest($customer_id, $page_number, $page_size, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersCustomerIdContactsGet'
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdContactsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomersCustomerIdContactsGetRequest($customer_id, $page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdContactsGet'][0])
    {

        // verify the required parameter 'customer_id' is set
        if ($customer_id === null || (is_array($customer_id) && count($customer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_id when calling apiV1CustomersCustomerIdContactsGet'
            );
        }
        if ($customer_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$customer_id" when calling CustomersApi.apiV1CustomersCustomerIdContactsGet, must be bigger than or equal to 1.');
        }
        



        $resourcePath = '/api/v1/Customers/{customerId}/Contacts';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($customer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customerId' . '}',
                ObjectSerializer::toPathValue($customer_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersCustomerIdCustomerLoyaltyFieldsGet
     *
     * Returns the customer loyalty fields for the specified customer.
     *
     * @param  int $customer_id customer_id (required)
     * @param  string|null $loyalty_card_number loyalty_card_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdCustomerLoyaltyFieldsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\CustomerLoyaltyField|string
     */
    public function apiV1CustomersCustomerIdCustomerLoyaltyFieldsGet($customer_id, $loyalty_card_number = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdCustomerLoyaltyFieldsGet'][0])
    {
        list($response) = $this->apiV1CustomersCustomerIdCustomerLoyaltyFieldsGetWithHttpInfo($customer_id, $loyalty_card_number, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CustomersCustomerIdCustomerLoyaltyFieldsGetWithHttpInfo
     *
     * Returns the customer loyalty fields for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  string|null $loyalty_card_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdCustomerLoyaltyFieldsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\CustomerLoyaltyField|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersCustomerIdCustomerLoyaltyFieldsGetWithHttpInfo($customer_id, $loyalty_card_number = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdCustomerLoyaltyFieldsGet'][0])
    {
        $request = $this->apiV1CustomersCustomerIdCustomerLoyaltyFieldsGetRequest($customer_id, $loyalty_card_number, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\CustomerLoyaltyField',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\CustomerLoyaltyField',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\CustomerLoyaltyField',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersCustomerIdCustomerLoyaltyFieldsGetAsync
     *
     * Returns the customer loyalty fields for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  string|null $loyalty_card_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdCustomerLoyaltyFieldsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersCustomerIdCustomerLoyaltyFieldsGetAsync($customer_id, $loyalty_card_number = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdCustomerLoyaltyFieldsGet'][0])
    {
        return $this->apiV1CustomersCustomerIdCustomerLoyaltyFieldsGetAsyncWithHttpInfo($customer_id, $loyalty_card_number, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersCustomerIdCustomerLoyaltyFieldsGetAsyncWithHttpInfo
     *
     * Returns the customer loyalty fields for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  string|null $loyalty_card_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdCustomerLoyaltyFieldsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersCustomerIdCustomerLoyaltyFieldsGetAsyncWithHttpInfo($customer_id, $loyalty_card_number = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdCustomerLoyaltyFieldsGet'][0])
    {
        $returnType = '\Opsuite2\Model\CustomerLoyaltyField';
        $request = $this->apiV1CustomersCustomerIdCustomerLoyaltyFieldsGetRequest($customer_id, $loyalty_card_number, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersCustomerIdCustomerLoyaltyFieldsGet'
     *
     * @param  int $customer_id (required)
     * @param  string|null $loyalty_card_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdCustomerLoyaltyFieldsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomersCustomerIdCustomerLoyaltyFieldsGetRequest($customer_id, $loyalty_card_number = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdCustomerLoyaltyFieldsGet'][0])
    {

        // verify the required parameter 'customer_id' is set
        if ($customer_id === null || (is_array($customer_id) && count($customer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_id when calling apiV1CustomersCustomerIdCustomerLoyaltyFieldsGet'
            );
        }
        if ($customer_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$customer_id" when calling CustomersApi.apiV1CustomersCustomerIdCustomerLoyaltyFieldsGet, must be bigger than or equal to 1.');
        }
        


        $resourcePath = '/api/v1/Customers/{customerId}/CustomerLoyaltyFields';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $loyalty_card_number,
            'loyaltyCardNumber', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($customer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customerId' . '}',
                ObjectSerializer::toPathValue($customer_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersCustomerIdDiscountCouponsGet
     *
     * Returns an array of discount coupons for the specified customer.
     *
     * @param  int $customer_id customer_id (required)
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  bool|null $include_zero_valued_coupons include_zero_valued_coupons (optional)
     * @param  bool|null $include_expired include_expired (optional)
     * @param  int|null $expired_limit expired_limit (optional)
     * @param  bool|null $include_not_yet_valid include_not_yet_valid (optional)
     * @param  int|null $valid_limit valid_limit (optional)
     * @param  bool|null $include_redeemed include_redeemed (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdDiscountCouponsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\CustomerDiscountCoupon[]|string
     */
    public function apiV1CustomersCustomerIdDiscountCouponsGet($customer_id, $page_number = null, $page_size = null, $include_zero_valued_coupons = null, $include_expired = null, $expired_limit = null, $include_not_yet_valid = null, $valid_limit = null, $include_redeemed = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdDiscountCouponsGet'][0])
    {
        list($response) = $this->apiV1CustomersCustomerIdDiscountCouponsGetWithHttpInfo($customer_id, $page_number, $page_size, $include_zero_valued_coupons, $include_expired, $expired_limit, $include_not_yet_valid, $valid_limit, $include_redeemed, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CustomersCustomerIdDiscountCouponsGetWithHttpInfo
     *
     * Returns an array of discount coupons for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  bool|null $include_zero_valued_coupons (optional)
     * @param  bool|null $include_expired (optional)
     * @param  int|null $expired_limit (optional)
     * @param  bool|null $include_not_yet_valid (optional)
     * @param  int|null $valid_limit (optional)
     * @param  bool|null $include_redeemed (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdDiscountCouponsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\CustomerDiscountCoupon[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersCustomerIdDiscountCouponsGetWithHttpInfo($customer_id, $page_number = null, $page_size = null, $include_zero_valued_coupons = null, $include_expired = null, $expired_limit = null, $include_not_yet_valid = null, $valid_limit = null, $include_redeemed = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdDiscountCouponsGet'][0])
    {
        $request = $this->apiV1CustomersCustomerIdDiscountCouponsGetRequest($customer_id, $page_number, $page_size, $include_zero_valued_coupons, $include_expired, $expired_limit, $include_not_yet_valid, $valid_limit, $include_redeemed, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\CustomerDiscountCoupon[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\CustomerDiscountCoupon[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\CustomerDiscountCoupon[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersCustomerIdDiscountCouponsGetAsync
     *
     * Returns an array of discount coupons for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  bool|null $include_zero_valued_coupons (optional)
     * @param  bool|null $include_expired (optional)
     * @param  int|null $expired_limit (optional)
     * @param  bool|null $include_not_yet_valid (optional)
     * @param  int|null $valid_limit (optional)
     * @param  bool|null $include_redeemed (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdDiscountCouponsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersCustomerIdDiscountCouponsGetAsync($customer_id, $page_number = null, $page_size = null, $include_zero_valued_coupons = null, $include_expired = null, $expired_limit = null, $include_not_yet_valid = null, $valid_limit = null, $include_redeemed = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdDiscountCouponsGet'][0])
    {
        return $this->apiV1CustomersCustomerIdDiscountCouponsGetAsyncWithHttpInfo($customer_id, $page_number, $page_size, $include_zero_valued_coupons, $include_expired, $expired_limit, $include_not_yet_valid, $valid_limit, $include_redeemed, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersCustomerIdDiscountCouponsGetAsyncWithHttpInfo
     *
     * Returns an array of discount coupons for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  bool|null $include_zero_valued_coupons (optional)
     * @param  bool|null $include_expired (optional)
     * @param  int|null $expired_limit (optional)
     * @param  bool|null $include_not_yet_valid (optional)
     * @param  int|null $valid_limit (optional)
     * @param  bool|null $include_redeemed (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdDiscountCouponsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersCustomerIdDiscountCouponsGetAsyncWithHttpInfo($customer_id, $page_number = null, $page_size = null, $include_zero_valued_coupons = null, $include_expired = null, $expired_limit = null, $include_not_yet_valid = null, $valid_limit = null, $include_redeemed = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdDiscountCouponsGet'][0])
    {
        $returnType = '\Opsuite2\Model\CustomerDiscountCoupon[]';
        $request = $this->apiV1CustomersCustomerIdDiscountCouponsGetRequest($customer_id, $page_number, $page_size, $include_zero_valued_coupons, $include_expired, $expired_limit, $include_not_yet_valid, $valid_limit, $include_redeemed, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersCustomerIdDiscountCouponsGet'
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  bool|null $include_zero_valued_coupons (optional)
     * @param  bool|null $include_expired (optional)
     * @param  int|null $expired_limit (optional)
     * @param  bool|null $include_not_yet_valid (optional)
     * @param  int|null $valid_limit (optional)
     * @param  bool|null $include_redeemed (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdDiscountCouponsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomersCustomerIdDiscountCouponsGetRequest($customer_id, $page_number = null, $page_size = null, $include_zero_valued_coupons = null, $include_expired = null, $expired_limit = null, $include_not_yet_valid = null, $valid_limit = null, $include_redeemed = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdDiscountCouponsGet'][0])
    {

        // verify the required parameter 'customer_id' is set
        if ($customer_id === null || (is_array($customer_id) && count($customer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_id when calling apiV1CustomersCustomerIdDiscountCouponsGet'
            );
        }
        if ($customer_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$customer_id" when calling CustomersApi.apiV1CustomersCustomerIdDiscountCouponsGet, must be bigger than or equal to 1.');
        }
        









        $resourcePath = '/api/v1/Customers/{customerId}/DiscountCoupons';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_zero_valued_coupons,
            'IncludeZeroValuedCoupons', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_expired,
            'IncludeExpired', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $expired_limit,
            'ExpiredLimit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_not_yet_valid,
            'IncludeNotYetValid', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $valid_limit,
            'ValidLimit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_redeemed,
            'IncludeRedeemed', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($customer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customerId' . '}',
                ObjectSerializer::toPathValue($customer_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersCustomerIdLoyaltyBalancesGet
     *
     * Returns an array of loyalty point balances for the specified customer.
     *
     * @param  int $customer_id customer_id (required)
     * @param  int|null $loyalty_type_id loyalty_type_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdLoyaltyBalancesGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\LoyaltyBalance[]|string
     */
    public function apiV1CustomersCustomerIdLoyaltyBalancesGet($customer_id, $loyalty_type_id = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdLoyaltyBalancesGet'][0])
    {
        list($response) = $this->apiV1CustomersCustomerIdLoyaltyBalancesGetWithHttpInfo($customer_id, $loyalty_type_id, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CustomersCustomerIdLoyaltyBalancesGetWithHttpInfo
     *
     * Returns an array of loyalty point balances for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  int|null $loyalty_type_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdLoyaltyBalancesGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\LoyaltyBalance[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersCustomerIdLoyaltyBalancesGetWithHttpInfo($customer_id, $loyalty_type_id = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdLoyaltyBalancesGet'][0])
    {
        $request = $this->apiV1CustomersCustomerIdLoyaltyBalancesGetRequest($customer_id, $loyalty_type_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\LoyaltyBalance[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\LoyaltyBalance[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\LoyaltyBalance[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersCustomerIdLoyaltyBalancesGetAsync
     *
     * Returns an array of loyalty point balances for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  int|null $loyalty_type_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdLoyaltyBalancesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersCustomerIdLoyaltyBalancesGetAsync($customer_id, $loyalty_type_id = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdLoyaltyBalancesGet'][0])
    {
        return $this->apiV1CustomersCustomerIdLoyaltyBalancesGetAsyncWithHttpInfo($customer_id, $loyalty_type_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersCustomerIdLoyaltyBalancesGetAsyncWithHttpInfo
     *
     * Returns an array of loyalty point balances for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  int|null $loyalty_type_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdLoyaltyBalancesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersCustomerIdLoyaltyBalancesGetAsyncWithHttpInfo($customer_id, $loyalty_type_id = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdLoyaltyBalancesGet'][0])
    {
        $returnType = '\Opsuite2\Model\LoyaltyBalance[]';
        $request = $this->apiV1CustomersCustomerIdLoyaltyBalancesGetRequest($customer_id, $loyalty_type_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersCustomerIdLoyaltyBalancesGet'
     *
     * @param  int $customer_id (required)
     * @param  int|null $loyalty_type_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdLoyaltyBalancesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomersCustomerIdLoyaltyBalancesGetRequest($customer_id, $loyalty_type_id = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdLoyaltyBalancesGet'][0])
    {

        // verify the required parameter 'customer_id' is set
        if ($customer_id === null || (is_array($customer_id) && count($customer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_id when calling apiV1CustomersCustomerIdLoyaltyBalancesGet'
            );
        }
        if ($customer_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$customer_id" when calling CustomersApi.apiV1CustomersCustomerIdLoyaltyBalancesGet, must be bigger than or equal to 1.');
        }
        


        $resourcePath = '/api/v1/Customers/{customerId}/LoyaltyBalances';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $loyalty_type_id,
            'loyaltyTypeId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($customer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customerId' . '}',
                ObjectSerializer::toPathValue($customer_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersCustomerIdLoyaltyCardsGet
     *
     * Returns an array of loyalty cards for the specified customer.
     *
     * @param  int $customer_id customer_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdLoyaltyCardsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\LoyaltyCard[]|string
     */
    public function apiV1CustomersCustomerIdLoyaltyCardsGet($customer_id, string $contentType = self::contentTypes['apiV1CustomersCustomerIdLoyaltyCardsGet'][0])
    {
        list($response) = $this->apiV1CustomersCustomerIdLoyaltyCardsGetWithHttpInfo($customer_id, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CustomersCustomerIdLoyaltyCardsGetWithHttpInfo
     *
     * Returns an array of loyalty cards for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdLoyaltyCardsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\LoyaltyCard[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersCustomerIdLoyaltyCardsGetWithHttpInfo($customer_id, string $contentType = self::contentTypes['apiV1CustomersCustomerIdLoyaltyCardsGet'][0])
    {
        $request = $this->apiV1CustomersCustomerIdLoyaltyCardsGetRequest($customer_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\LoyaltyCard[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\LoyaltyCard[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\LoyaltyCard[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersCustomerIdLoyaltyCardsGetAsync
     *
     * Returns an array of loyalty cards for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdLoyaltyCardsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersCustomerIdLoyaltyCardsGetAsync($customer_id, string $contentType = self::contentTypes['apiV1CustomersCustomerIdLoyaltyCardsGet'][0])
    {
        return $this->apiV1CustomersCustomerIdLoyaltyCardsGetAsyncWithHttpInfo($customer_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersCustomerIdLoyaltyCardsGetAsyncWithHttpInfo
     *
     * Returns an array of loyalty cards for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdLoyaltyCardsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersCustomerIdLoyaltyCardsGetAsyncWithHttpInfo($customer_id, string $contentType = self::contentTypes['apiV1CustomersCustomerIdLoyaltyCardsGet'][0])
    {
        $returnType = '\Opsuite2\Model\LoyaltyCard[]';
        $request = $this->apiV1CustomersCustomerIdLoyaltyCardsGetRequest($customer_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersCustomerIdLoyaltyCardsGet'
     *
     * @param  int $customer_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdLoyaltyCardsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomersCustomerIdLoyaltyCardsGetRequest($customer_id, string $contentType = self::contentTypes['apiV1CustomersCustomerIdLoyaltyCardsGet'][0])
    {

        // verify the required parameter 'customer_id' is set
        if ($customer_id === null || (is_array($customer_id) && count($customer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_id when calling apiV1CustomersCustomerIdLoyaltyCardsGet'
            );
        }
        if ($customer_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$customer_id" when calling CustomersApi.apiV1CustomersCustomerIdLoyaltyCardsGet, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v1/Customers/{customerId}/LoyaltyCards';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($customer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customerId' . '}',
                ObjectSerializer::toPathValue($customer_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersCustomerIdLoyaltyTransactionsGet
     *
     * Returns an array of loyalty transactions for the specified customer.
     *
     * @param  int $customer_id customer_id (required)
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  \DateTime|null $date_range_start date_range_start (optional)
     * @param  \DateTime|null $date_range_end date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdLoyaltyTransactionsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\LoyaltyTransaction[]|string
     */
    public function apiV1CustomersCustomerIdLoyaltyTransactionsGet($customer_id, $page_number = null, $page_size = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdLoyaltyTransactionsGet'][0])
    {
        list($response) = $this->apiV1CustomersCustomerIdLoyaltyTransactionsGetWithHttpInfo($customer_id, $page_number, $page_size, $date_range_start, $date_range_end, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CustomersCustomerIdLoyaltyTransactionsGetWithHttpInfo
     *
     * Returns an array of loyalty transactions for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdLoyaltyTransactionsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\LoyaltyTransaction[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersCustomerIdLoyaltyTransactionsGetWithHttpInfo($customer_id, $page_number = null, $page_size = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdLoyaltyTransactionsGet'][0])
    {
        $request = $this->apiV1CustomersCustomerIdLoyaltyTransactionsGetRequest($customer_id, $page_number, $page_size, $date_range_start, $date_range_end, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\LoyaltyTransaction[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\LoyaltyTransaction[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\LoyaltyTransaction[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersCustomerIdLoyaltyTransactionsGetAsync
     *
     * Returns an array of loyalty transactions for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdLoyaltyTransactionsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersCustomerIdLoyaltyTransactionsGetAsync($customer_id, $page_number = null, $page_size = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdLoyaltyTransactionsGet'][0])
    {
        return $this->apiV1CustomersCustomerIdLoyaltyTransactionsGetAsyncWithHttpInfo($customer_id, $page_number, $page_size, $date_range_start, $date_range_end, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersCustomerIdLoyaltyTransactionsGetAsyncWithHttpInfo
     *
     * Returns an array of loyalty transactions for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdLoyaltyTransactionsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersCustomerIdLoyaltyTransactionsGetAsyncWithHttpInfo($customer_id, $page_number = null, $page_size = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdLoyaltyTransactionsGet'][0])
    {
        $returnType = '\Opsuite2\Model\LoyaltyTransaction[]';
        $request = $this->apiV1CustomersCustomerIdLoyaltyTransactionsGetRequest($customer_id, $page_number, $page_size, $date_range_start, $date_range_end, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersCustomerIdLoyaltyTransactionsGet'
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdLoyaltyTransactionsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomersCustomerIdLoyaltyTransactionsGetRequest($customer_id, $page_number = null, $page_size = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdLoyaltyTransactionsGet'][0])
    {

        // verify the required parameter 'customer_id' is set
        if ($customer_id === null || (is_array($customer_id) && count($customer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_id when calling apiV1CustomersCustomerIdLoyaltyTransactionsGet'
            );
        }
        if ($customer_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$customer_id" when calling CustomersApi.apiV1CustomersCustomerIdLoyaltyTransactionsGet, must be bigger than or equal to 1.');
        }
        





        $resourcePath = '/api/v1/Customers/{customerId}/LoyaltyTransactions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_range_start,
            'DateRangeStart', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_range_end,
            'DateRangeEnd', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($customer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customerId' . '}',
                ObjectSerializer::toPathValue($customer_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersCustomerIdPatch
     *
     * Updates specified properties of a customer.
     *
     * @param  int $customer_id customer_id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdPatch'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function apiV1CustomersCustomerIdPatch($customer_id, $patch = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdPatch'][0])
    {
        $this->apiV1CustomersCustomerIdPatchWithHttpInfo($customer_id, $patch, $contentType);
    }

    /**
     * Operation apiV1CustomersCustomerIdPatchWithHttpInfo
     *
     * Updates specified properties of a customer.
     *
     * @param  int $customer_id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdPatch'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersCustomerIdPatchWithHttpInfo($customer_id, $patch = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdPatch'][0])
    {
        $request = $this->apiV1CustomersCustomerIdPatchRequest($customer_id, $patch, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersCustomerIdPatchAsync
     *
     * Updates specified properties of a customer.
     *
     * @param  int $customer_id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersCustomerIdPatchAsync($customer_id, $patch = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdPatch'][0])
    {
        return $this->apiV1CustomersCustomerIdPatchAsyncWithHttpInfo($customer_id, $patch, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersCustomerIdPatchAsyncWithHttpInfo
     *
     * Updates specified properties of a customer.
     *
     * @param  int $customer_id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersCustomerIdPatchAsyncWithHttpInfo($customer_id, $patch = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdPatch'][0])
    {
        $returnType = '';
        $request = $this->apiV1CustomersCustomerIdPatchRequest($customer_id, $patch, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersCustomerIdPatch'
     *
     * @param  int $customer_id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomersCustomerIdPatchRequest($customer_id, $patch = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdPatch'][0])
    {

        // verify the required parameter 'customer_id' is set
        if ($customer_id === null || (is_array($customer_id) && count($customer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_id when calling apiV1CustomersCustomerIdPatch'
            );
        }
        if ($customer_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$customer_id" when calling CustomersApi.apiV1CustomersCustomerIdPatch, must be bigger than or equal to 1.');
        }
        


        $resourcePath = '/api/v1/Customers/{customerId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($customer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customerId' . '}',
                ObjectSerializer::toPathValue($customer_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($patch)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($patch));
            } else {
                $httpBody = $patch;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersCustomerIdPromotionCouponsGet
     *
     * Returns an array of promotion coupons for the specified customer.
     *
     * @param  int $customer_id customer_id (required)
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  bool|null $include_expired include_expired (optional)
     * @param  int|null $expired_limit expired_limit (optional)
     * @param  bool|null $include_not_yet_valid include_not_yet_valid (optional)
     * @param  int|null $valid_limit valid_limit (optional)
     * @param  bool|null $include_redeemed include_redeemed (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdPromotionCouponsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\CustomerPromotionCoupon[]|string
     */
    public function apiV1CustomersCustomerIdPromotionCouponsGet($customer_id, $page_number = null, $page_size = null, $include_expired = null, $expired_limit = null, $include_not_yet_valid = null, $valid_limit = null, $include_redeemed = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdPromotionCouponsGet'][0])
    {
        list($response) = $this->apiV1CustomersCustomerIdPromotionCouponsGetWithHttpInfo($customer_id, $page_number, $page_size, $include_expired, $expired_limit, $include_not_yet_valid, $valid_limit, $include_redeemed, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CustomersCustomerIdPromotionCouponsGetWithHttpInfo
     *
     * Returns an array of promotion coupons for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  bool|null $include_expired (optional)
     * @param  int|null $expired_limit (optional)
     * @param  bool|null $include_not_yet_valid (optional)
     * @param  int|null $valid_limit (optional)
     * @param  bool|null $include_redeemed (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdPromotionCouponsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\CustomerPromotionCoupon[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersCustomerIdPromotionCouponsGetWithHttpInfo($customer_id, $page_number = null, $page_size = null, $include_expired = null, $expired_limit = null, $include_not_yet_valid = null, $valid_limit = null, $include_redeemed = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdPromotionCouponsGet'][0])
    {
        $request = $this->apiV1CustomersCustomerIdPromotionCouponsGetRequest($customer_id, $page_number, $page_size, $include_expired, $expired_limit, $include_not_yet_valid, $valid_limit, $include_redeemed, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\CustomerPromotionCoupon[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\CustomerPromotionCoupon[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\CustomerPromotionCoupon[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersCustomerIdPromotionCouponsGetAsync
     *
     * Returns an array of promotion coupons for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  bool|null $include_expired (optional)
     * @param  int|null $expired_limit (optional)
     * @param  bool|null $include_not_yet_valid (optional)
     * @param  int|null $valid_limit (optional)
     * @param  bool|null $include_redeemed (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdPromotionCouponsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersCustomerIdPromotionCouponsGetAsync($customer_id, $page_number = null, $page_size = null, $include_expired = null, $expired_limit = null, $include_not_yet_valid = null, $valid_limit = null, $include_redeemed = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdPromotionCouponsGet'][0])
    {
        return $this->apiV1CustomersCustomerIdPromotionCouponsGetAsyncWithHttpInfo($customer_id, $page_number, $page_size, $include_expired, $expired_limit, $include_not_yet_valid, $valid_limit, $include_redeemed, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersCustomerIdPromotionCouponsGetAsyncWithHttpInfo
     *
     * Returns an array of promotion coupons for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  bool|null $include_expired (optional)
     * @param  int|null $expired_limit (optional)
     * @param  bool|null $include_not_yet_valid (optional)
     * @param  int|null $valid_limit (optional)
     * @param  bool|null $include_redeemed (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdPromotionCouponsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersCustomerIdPromotionCouponsGetAsyncWithHttpInfo($customer_id, $page_number = null, $page_size = null, $include_expired = null, $expired_limit = null, $include_not_yet_valid = null, $valid_limit = null, $include_redeemed = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdPromotionCouponsGet'][0])
    {
        $returnType = '\Opsuite2\Model\CustomerPromotionCoupon[]';
        $request = $this->apiV1CustomersCustomerIdPromotionCouponsGetRequest($customer_id, $page_number, $page_size, $include_expired, $expired_limit, $include_not_yet_valid, $valid_limit, $include_redeemed, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersCustomerIdPromotionCouponsGet'
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  bool|null $include_expired (optional)
     * @param  int|null $expired_limit (optional)
     * @param  bool|null $include_not_yet_valid (optional)
     * @param  int|null $valid_limit (optional)
     * @param  bool|null $include_redeemed (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdPromotionCouponsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomersCustomerIdPromotionCouponsGetRequest($customer_id, $page_number = null, $page_size = null, $include_expired = null, $expired_limit = null, $include_not_yet_valid = null, $valid_limit = null, $include_redeemed = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdPromotionCouponsGet'][0])
    {

        // verify the required parameter 'customer_id' is set
        if ($customer_id === null || (is_array($customer_id) && count($customer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_id when calling apiV1CustomersCustomerIdPromotionCouponsGet'
            );
        }
        if ($customer_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$customer_id" when calling CustomersApi.apiV1CustomersCustomerIdPromotionCouponsGet, must be bigger than or equal to 1.');
        }
        








        $resourcePath = '/api/v1/Customers/{customerId}/PromotionCoupons';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_expired,
            'IncludeExpired', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $expired_limit,
            'ExpiredLimit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_not_yet_valid,
            'IncludeNotYetValid', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $valid_limit,
            'ValidLimit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_redeemed,
            'IncludeRedeemed', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($customer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customerId' . '}',
                ObjectSerializer::toPathValue($customer_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersCustomerIdTransactionHeadersGet
     *
     * Returns an array of transaction headers for the specified customer.
     *
     * @param  int $customer_id customer_id (required)
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  \DateTime|null $date_range_start date_range_start (optional)
     * @param  \DateTime|null $date_range_end date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdTransactionHeadersGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\TransactionHeader[]|string
     */
    public function apiV1CustomersCustomerIdTransactionHeadersGet($customer_id, $page_number = null, $page_size = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdTransactionHeadersGet'][0])
    {
        list($response) = $this->apiV1CustomersCustomerIdTransactionHeadersGetWithHttpInfo($customer_id, $page_number, $page_size, $date_range_start, $date_range_end, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CustomersCustomerIdTransactionHeadersGetWithHttpInfo
     *
     * Returns an array of transaction headers for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdTransactionHeadersGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\TransactionHeader[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersCustomerIdTransactionHeadersGetWithHttpInfo($customer_id, $page_number = null, $page_size = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdTransactionHeadersGet'][0])
    {
        $request = $this->apiV1CustomersCustomerIdTransactionHeadersGetRequest($customer_id, $page_number, $page_size, $date_range_start, $date_range_end, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\TransactionHeader[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\TransactionHeader[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\TransactionHeader[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersCustomerIdTransactionHeadersGetAsync
     *
     * Returns an array of transaction headers for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdTransactionHeadersGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersCustomerIdTransactionHeadersGetAsync($customer_id, $page_number = null, $page_size = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdTransactionHeadersGet'][0])
    {
        return $this->apiV1CustomersCustomerIdTransactionHeadersGetAsyncWithHttpInfo($customer_id, $page_number, $page_size, $date_range_start, $date_range_end, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersCustomerIdTransactionHeadersGetAsyncWithHttpInfo
     *
     * Returns an array of transaction headers for the specified customer.
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdTransactionHeadersGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersCustomerIdTransactionHeadersGetAsyncWithHttpInfo($customer_id, $page_number = null, $page_size = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdTransactionHeadersGet'][0])
    {
        $returnType = '\Opsuite2\Model\TransactionHeader[]';
        $request = $this->apiV1CustomersCustomerIdTransactionHeadersGetRequest($customer_id, $page_number, $page_size, $date_range_start, $date_range_end, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersCustomerIdTransactionHeadersGet'
     *
     * @param  int $customer_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersCustomerIdTransactionHeadersGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomersCustomerIdTransactionHeadersGetRequest($customer_id, $page_number = null, $page_size = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV1CustomersCustomerIdTransactionHeadersGet'][0])
    {

        // verify the required parameter 'customer_id' is set
        if ($customer_id === null || (is_array($customer_id) && count($customer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_id when calling apiV1CustomersCustomerIdTransactionHeadersGet'
            );
        }
        if ($customer_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$customer_id" when calling CustomersApi.apiV1CustomersCustomerIdTransactionHeadersGet, must be bigger than or equal to 1.');
        }
        





        $resourcePath = '/api/v1/Customers/{customerId}/TransactionHeaders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_range_start,
            'DateRangeStart', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_range_end,
            'DateRangeEnd', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($customer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customerId' . '}',
                ObjectSerializer::toPathValue($customer_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersExpiringLoyaltyTransactionsGet
     *
     * Returns an array of expiring loyalty transactions for the specified customers.
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  int|null $customer_id customer_id (optional)
     * @param  int[]|null $customer_ids customer_ids (optional)
     * @param  int|null $loyalty_type_id loyalty_type_id (optional)
     * @param  \DateTime|null $date_range_start date_range_start (optional)
     * @param  \DateTime|null $date_range_end date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersExpiringLoyaltyTransactionsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\LoyaltyTransaction[]|string
     */
    public function apiV1CustomersExpiringLoyaltyTransactionsGet($page_number = null, $page_size = null, $customer_id = null, $customer_ids = null, $loyalty_type_id = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV1CustomersExpiringLoyaltyTransactionsGet'][0])
    {
        list($response) = $this->apiV1CustomersExpiringLoyaltyTransactionsGetWithHttpInfo($page_number, $page_size, $customer_id, $customer_ids, $loyalty_type_id, $date_range_start, $date_range_end, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CustomersExpiringLoyaltyTransactionsGetWithHttpInfo
     *
     * Returns an array of expiring loyalty transactions for the specified customers.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $customer_id (optional)
     * @param  int[]|null $customer_ids (optional)
     * @param  int|null $loyalty_type_id (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersExpiringLoyaltyTransactionsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\LoyaltyTransaction[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersExpiringLoyaltyTransactionsGetWithHttpInfo($page_number = null, $page_size = null, $customer_id = null, $customer_ids = null, $loyalty_type_id = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV1CustomersExpiringLoyaltyTransactionsGet'][0])
    {
        $request = $this->apiV1CustomersExpiringLoyaltyTransactionsGetRequest($page_number, $page_size, $customer_id, $customer_ids, $loyalty_type_id, $date_range_start, $date_range_end, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\LoyaltyTransaction[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\LoyaltyTransaction[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\LoyaltyTransaction[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersExpiringLoyaltyTransactionsGetAsync
     *
     * Returns an array of expiring loyalty transactions for the specified customers.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $customer_id (optional)
     * @param  int[]|null $customer_ids (optional)
     * @param  int|null $loyalty_type_id (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersExpiringLoyaltyTransactionsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersExpiringLoyaltyTransactionsGetAsync($page_number = null, $page_size = null, $customer_id = null, $customer_ids = null, $loyalty_type_id = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV1CustomersExpiringLoyaltyTransactionsGet'][0])
    {
        return $this->apiV1CustomersExpiringLoyaltyTransactionsGetAsyncWithHttpInfo($page_number, $page_size, $customer_id, $customer_ids, $loyalty_type_id, $date_range_start, $date_range_end, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersExpiringLoyaltyTransactionsGetAsyncWithHttpInfo
     *
     * Returns an array of expiring loyalty transactions for the specified customers.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $customer_id (optional)
     * @param  int[]|null $customer_ids (optional)
     * @param  int|null $loyalty_type_id (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersExpiringLoyaltyTransactionsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersExpiringLoyaltyTransactionsGetAsyncWithHttpInfo($page_number = null, $page_size = null, $customer_id = null, $customer_ids = null, $loyalty_type_id = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV1CustomersExpiringLoyaltyTransactionsGet'][0])
    {
        $returnType = '\Opsuite2\Model\LoyaltyTransaction[]';
        $request = $this->apiV1CustomersExpiringLoyaltyTransactionsGetRequest($page_number, $page_size, $customer_id, $customer_ids, $loyalty_type_id, $date_range_start, $date_range_end, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersExpiringLoyaltyTransactionsGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $customer_id (optional)
     * @param  int[]|null $customer_ids (optional)
     * @param  int|null $loyalty_type_id (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersExpiringLoyaltyTransactionsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomersExpiringLoyaltyTransactionsGetRequest($page_number = null, $page_size = null, $customer_id = null, $customer_ids = null, $loyalty_type_id = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV1CustomersExpiringLoyaltyTransactionsGet'][0])
    {









        $resourcePath = '/api/v1/Customers/ExpiringLoyaltyTransactions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $customer_id,
            'CustomerId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $customer_ids,
            'CustomerIds', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $loyalty_type_id,
            'LoyaltyTypeId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_range_start,
            'DateRangeStart', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_range_end,
            'DateRangeEnd', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersExpiryingLoyaltyTransactionsGet
     *
     * Returns an array of expiring loyalty transactions for the specified customers.
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  int|null $customer_id customer_id (optional)
     * @param  int[]|null $customer_ids customer_ids (optional)
     * @param  int|null $loyalty_type_id loyalty_type_id (optional)
     * @param  \DateTime|null $date_range_start date_range_start (optional)
     * @param  \DateTime|null $date_range_end date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersExpiryingLoyaltyTransactionsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\LoyaltyTransaction[]|string
     */
    public function apiV1CustomersExpiryingLoyaltyTransactionsGet($page_number = null, $page_size = null, $customer_id = null, $customer_ids = null, $loyalty_type_id = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV1CustomersExpiryingLoyaltyTransactionsGet'][0])
    {
        list($response) = $this->apiV1CustomersExpiryingLoyaltyTransactionsGetWithHttpInfo($page_number, $page_size, $customer_id, $customer_ids, $loyalty_type_id, $date_range_start, $date_range_end, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CustomersExpiryingLoyaltyTransactionsGetWithHttpInfo
     *
     * Returns an array of expiring loyalty transactions for the specified customers.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $customer_id (optional)
     * @param  int[]|null $customer_ids (optional)
     * @param  int|null $loyalty_type_id (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersExpiryingLoyaltyTransactionsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\LoyaltyTransaction[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersExpiryingLoyaltyTransactionsGetWithHttpInfo($page_number = null, $page_size = null, $customer_id = null, $customer_ids = null, $loyalty_type_id = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV1CustomersExpiryingLoyaltyTransactionsGet'][0])
    {
        $request = $this->apiV1CustomersExpiryingLoyaltyTransactionsGetRequest($page_number, $page_size, $customer_id, $customer_ids, $loyalty_type_id, $date_range_start, $date_range_end, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\LoyaltyTransaction[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\LoyaltyTransaction[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\LoyaltyTransaction[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersExpiryingLoyaltyTransactionsGetAsync
     *
     * Returns an array of expiring loyalty transactions for the specified customers.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $customer_id (optional)
     * @param  int[]|null $customer_ids (optional)
     * @param  int|null $loyalty_type_id (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersExpiryingLoyaltyTransactionsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersExpiryingLoyaltyTransactionsGetAsync($page_number = null, $page_size = null, $customer_id = null, $customer_ids = null, $loyalty_type_id = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV1CustomersExpiryingLoyaltyTransactionsGet'][0])
    {
        return $this->apiV1CustomersExpiryingLoyaltyTransactionsGetAsyncWithHttpInfo($page_number, $page_size, $customer_id, $customer_ids, $loyalty_type_id, $date_range_start, $date_range_end, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersExpiryingLoyaltyTransactionsGetAsyncWithHttpInfo
     *
     * Returns an array of expiring loyalty transactions for the specified customers.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $customer_id (optional)
     * @param  int[]|null $customer_ids (optional)
     * @param  int|null $loyalty_type_id (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersExpiryingLoyaltyTransactionsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersExpiryingLoyaltyTransactionsGetAsyncWithHttpInfo($page_number = null, $page_size = null, $customer_id = null, $customer_ids = null, $loyalty_type_id = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV1CustomersExpiryingLoyaltyTransactionsGet'][0])
    {
        $returnType = '\Opsuite2\Model\LoyaltyTransaction[]';
        $request = $this->apiV1CustomersExpiryingLoyaltyTransactionsGetRequest($page_number, $page_size, $customer_id, $customer_ids, $loyalty_type_id, $date_range_start, $date_range_end, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersExpiryingLoyaltyTransactionsGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $customer_id (optional)
     * @param  int[]|null $customer_ids (optional)
     * @param  int|null $loyalty_type_id (optional)
     * @param  \DateTime|null $date_range_start (optional)
     * @param  \DateTime|null $date_range_end (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersExpiryingLoyaltyTransactionsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomersExpiryingLoyaltyTransactionsGetRequest($page_number = null, $page_size = null, $customer_id = null, $customer_ids = null, $loyalty_type_id = null, $date_range_start = null, $date_range_end = null, string $contentType = self::contentTypes['apiV1CustomersExpiryingLoyaltyTransactionsGet'][0])
    {









        $resourcePath = '/api/v1/Customers/ExpiryingLoyaltyTransactions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $customer_id,
            'CustomerId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $customer_ids,
            'CustomerIds', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $loyalty_type_id,
            'LoyaltyTypeId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_range_start,
            'DateRangeStart', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_range_end,
            'DateRangeEnd', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersGet
     *
     * Returns an array of Customers that match the specified search criteria.
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  string|null $account_number account_number (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $account_number_search_operator account_number_search_operator (optional)
     * @param  int|null $account_type_id account_type_id (optional)
     * @param  string|null $loyalty_card_number loyalty_card_number (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $loyalty_card_number_search_operator loyalty_card_number_search_operator (optional)
     * @param  string|null $billing_first_name billing_first_name (optional)
     * @param  string|null $billing_last_name billing_last_name (optional)
     * @param  bool|null $has_billing_email has_billing_email (optional)
     * @param  string|null $billing_email billing_email (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $billing_email_search_operator billing_email_search_operator (optional)
     * @param  string|null $ship_to_first_name ship_to_first_name (optional)
     * @param  string|null $ship_to_last_name ship_to_last_name (optional)
     * @param  bool|null $has_ship_to_email has_ship_to_email (optional)
     * @param  string|null $ship_to_email ship_to_email (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $ship_to_email_search_operator ship_to_email_search_operator (optional)
     * @param  bool|null $include_inactive include_inactive (optional)
     * @param  \DateTime|null $last_updated_date_range_start last_updated_date_range_start (optional)
     * @param  \DateTime|null $last_updated_date_range_end last_updated_date_range_end (optional)
     * @param  \DateTime|null $account_opened_date_range_start account_opened_date_range_start (optional)
     * @param  \DateTime|null $account_opened_date_range_end account_opened_date_range_end (optional)
     * @param  \DateTime|null $last_visit_date_range_start last_visit_date_range_start (optional)
     * @param  \DateTime|null $last_visit_date_range_end last_visit_date_range_end (optional)
     * @param  bool|null $opt_in_email opt_in_email (optional)
     * @param  bool|null $opt_in_direct_mail opt_in_direct_mail (optional)
     * @param  bool|null $opt_in_telephone opt_in_telephone (optional)
     * @param  string|null $loyalty_field_search_field_name loyalty_field_search_field_name (optional)
     * @param  \Opsuite2\Model\SearchOperatorEnum|null $loyalty_field_search_operator loyalty_field_search_operator (optional)
     * @param  string|null $loyalty_field_search_search_value loyalty_field_search_search_value (optional)
     * @param  int|null $birthday_month birthday_month (optional)
     * @param  bool|null $is_referred is_referred (optional)
     * @param  int[]|null $customer_ids customer_ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\Customer[]|string
     */
    public function apiV1CustomersGet($page_number = null, $page_size = null, $account_number = null, $account_number_search_operator = null, $account_type_id = null, $loyalty_card_number = null, $loyalty_card_number_search_operator = null, $billing_first_name = null, $billing_last_name = null, $has_billing_email = null, $billing_email = null, $billing_email_search_operator = null, $ship_to_first_name = null, $ship_to_last_name = null, $has_ship_to_email = null, $ship_to_email = null, $ship_to_email_search_operator = null, $include_inactive = null, $last_updated_date_range_start = null, $last_updated_date_range_end = null, $account_opened_date_range_start = null, $account_opened_date_range_end = null, $last_visit_date_range_start = null, $last_visit_date_range_end = null, $opt_in_email = null, $opt_in_direct_mail = null, $opt_in_telephone = null, $loyalty_field_search_field_name = null, $loyalty_field_search_operator = null, $loyalty_field_search_search_value = null, $birthday_month = null, $is_referred = null, $customer_ids = null, string $contentType = self::contentTypes['apiV1CustomersGet'][0])
    {
        list($response) = $this->apiV1CustomersGetWithHttpInfo($page_number, $page_size, $account_number, $account_number_search_operator, $account_type_id, $loyalty_card_number, $loyalty_card_number_search_operator, $billing_first_name, $billing_last_name, $has_billing_email, $billing_email, $billing_email_search_operator, $ship_to_first_name, $ship_to_last_name, $has_ship_to_email, $ship_to_email, $ship_to_email_search_operator, $include_inactive, $last_updated_date_range_start, $last_updated_date_range_end, $account_opened_date_range_start, $account_opened_date_range_end, $last_visit_date_range_start, $last_visit_date_range_end, $opt_in_email, $opt_in_direct_mail, $opt_in_telephone, $loyalty_field_search_field_name, $loyalty_field_search_operator, $loyalty_field_search_search_value, $birthday_month, $is_referred, $customer_ids, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CustomersGetWithHttpInfo
     *
     * Returns an array of Customers that match the specified search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string|null $account_number (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $account_number_search_operator (optional)
     * @param  int|null $account_type_id (optional)
     * @param  string|null $loyalty_card_number (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $loyalty_card_number_search_operator (optional)
     * @param  string|null $billing_first_name (optional)
     * @param  string|null $billing_last_name (optional)
     * @param  bool|null $has_billing_email (optional)
     * @param  string|null $billing_email (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $billing_email_search_operator (optional)
     * @param  string|null $ship_to_first_name (optional)
     * @param  string|null $ship_to_last_name (optional)
     * @param  bool|null $has_ship_to_email (optional)
     * @param  string|null $ship_to_email (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $ship_to_email_search_operator (optional)
     * @param  bool|null $include_inactive (optional)
     * @param  \DateTime|null $last_updated_date_range_start (optional)
     * @param  \DateTime|null $last_updated_date_range_end (optional)
     * @param  \DateTime|null $account_opened_date_range_start (optional)
     * @param  \DateTime|null $account_opened_date_range_end (optional)
     * @param  \DateTime|null $last_visit_date_range_start (optional)
     * @param  \DateTime|null $last_visit_date_range_end (optional)
     * @param  bool|null $opt_in_email (optional)
     * @param  bool|null $opt_in_direct_mail (optional)
     * @param  bool|null $opt_in_telephone (optional)
     * @param  string|null $loyalty_field_search_field_name (optional)
     * @param  \Opsuite2\Model\SearchOperatorEnum|null $loyalty_field_search_operator (optional)
     * @param  string|null $loyalty_field_search_search_value (optional)
     * @param  int|null $birthday_month (optional)
     * @param  bool|null $is_referred (optional)
     * @param  int[]|null $customer_ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\Customer[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersGetWithHttpInfo($page_number = null, $page_size = null, $account_number = null, $account_number_search_operator = null, $account_type_id = null, $loyalty_card_number = null, $loyalty_card_number_search_operator = null, $billing_first_name = null, $billing_last_name = null, $has_billing_email = null, $billing_email = null, $billing_email_search_operator = null, $ship_to_first_name = null, $ship_to_last_name = null, $has_ship_to_email = null, $ship_to_email = null, $ship_to_email_search_operator = null, $include_inactive = null, $last_updated_date_range_start = null, $last_updated_date_range_end = null, $account_opened_date_range_start = null, $account_opened_date_range_end = null, $last_visit_date_range_start = null, $last_visit_date_range_end = null, $opt_in_email = null, $opt_in_direct_mail = null, $opt_in_telephone = null, $loyalty_field_search_field_name = null, $loyalty_field_search_operator = null, $loyalty_field_search_search_value = null, $birthday_month = null, $is_referred = null, $customer_ids = null, string $contentType = self::contentTypes['apiV1CustomersGet'][0])
    {
        $request = $this->apiV1CustomersGetRequest($page_number, $page_size, $account_number, $account_number_search_operator, $account_type_id, $loyalty_card_number, $loyalty_card_number_search_operator, $billing_first_name, $billing_last_name, $has_billing_email, $billing_email, $billing_email_search_operator, $ship_to_first_name, $ship_to_last_name, $has_ship_to_email, $ship_to_email, $ship_to_email_search_operator, $include_inactive, $last_updated_date_range_start, $last_updated_date_range_end, $account_opened_date_range_start, $account_opened_date_range_end, $last_visit_date_range_start, $last_visit_date_range_end, $opt_in_email, $opt_in_direct_mail, $opt_in_telephone, $loyalty_field_search_field_name, $loyalty_field_search_operator, $loyalty_field_search_search_value, $birthday_month, $is_referred, $customer_ids, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\Customer[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\Customer[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\Customer[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersGetAsync
     *
     * Returns an array of Customers that match the specified search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string|null $account_number (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $account_number_search_operator (optional)
     * @param  int|null $account_type_id (optional)
     * @param  string|null $loyalty_card_number (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $loyalty_card_number_search_operator (optional)
     * @param  string|null $billing_first_name (optional)
     * @param  string|null $billing_last_name (optional)
     * @param  bool|null $has_billing_email (optional)
     * @param  string|null $billing_email (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $billing_email_search_operator (optional)
     * @param  string|null $ship_to_first_name (optional)
     * @param  string|null $ship_to_last_name (optional)
     * @param  bool|null $has_ship_to_email (optional)
     * @param  string|null $ship_to_email (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $ship_to_email_search_operator (optional)
     * @param  bool|null $include_inactive (optional)
     * @param  \DateTime|null $last_updated_date_range_start (optional)
     * @param  \DateTime|null $last_updated_date_range_end (optional)
     * @param  \DateTime|null $account_opened_date_range_start (optional)
     * @param  \DateTime|null $account_opened_date_range_end (optional)
     * @param  \DateTime|null $last_visit_date_range_start (optional)
     * @param  \DateTime|null $last_visit_date_range_end (optional)
     * @param  bool|null $opt_in_email (optional)
     * @param  bool|null $opt_in_direct_mail (optional)
     * @param  bool|null $opt_in_telephone (optional)
     * @param  string|null $loyalty_field_search_field_name (optional)
     * @param  \Opsuite2\Model\SearchOperatorEnum|null $loyalty_field_search_operator (optional)
     * @param  string|null $loyalty_field_search_search_value (optional)
     * @param  int|null $birthday_month (optional)
     * @param  bool|null $is_referred (optional)
     * @param  int[]|null $customer_ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersGetAsync($page_number = null, $page_size = null, $account_number = null, $account_number_search_operator = null, $account_type_id = null, $loyalty_card_number = null, $loyalty_card_number_search_operator = null, $billing_first_name = null, $billing_last_name = null, $has_billing_email = null, $billing_email = null, $billing_email_search_operator = null, $ship_to_first_name = null, $ship_to_last_name = null, $has_ship_to_email = null, $ship_to_email = null, $ship_to_email_search_operator = null, $include_inactive = null, $last_updated_date_range_start = null, $last_updated_date_range_end = null, $account_opened_date_range_start = null, $account_opened_date_range_end = null, $last_visit_date_range_start = null, $last_visit_date_range_end = null, $opt_in_email = null, $opt_in_direct_mail = null, $opt_in_telephone = null, $loyalty_field_search_field_name = null, $loyalty_field_search_operator = null, $loyalty_field_search_search_value = null, $birthday_month = null, $is_referred = null, $customer_ids = null, string $contentType = self::contentTypes['apiV1CustomersGet'][0])
    {
        return $this->apiV1CustomersGetAsyncWithHttpInfo($page_number, $page_size, $account_number, $account_number_search_operator, $account_type_id, $loyalty_card_number, $loyalty_card_number_search_operator, $billing_first_name, $billing_last_name, $has_billing_email, $billing_email, $billing_email_search_operator, $ship_to_first_name, $ship_to_last_name, $has_ship_to_email, $ship_to_email, $ship_to_email_search_operator, $include_inactive, $last_updated_date_range_start, $last_updated_date_range_end, $account_opened_date_range_start, $account_opened_date_range_end, $last_visit_date_range_start, $last_visit_date_range_end, $opt_in_email, $opt_in_direct_mail, $opt_in_telephone, $loyalty_field_search_field_name, $loyalty_field_search_operator, $loyalty_field_search_search_value, $birthday_month, $is_referred, $customer_ids, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersGetAsyncWithHttpInfo
     *
     * Returns an array of Customers that match the specified search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string|null $account_number (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $account_number_search_operator (optional)
     * @param  int|null $account_type_id (optional)
     * @param  string|null $loyalty_card_number (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $loyalty_card_number_search_operator (optional)
     * @param  string|null $billing_first_name (optional)
     * @param  string|null $billing_last_name (optional)
     * @param  bool|null $has_billing_email (optional)
     * @param  string|null $billing_email (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $billing_email_search_operator (optional)
     * @param  string|null $ship_to_first_name (optional)
     * @param  string|null $ship_to_last_name (optional)
     * @param  bool|null $has_ship_to_email (optional)
     * @param  string|null $ship_to_email (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $ship_to_email_search_operator (optional)
     * @param  bool|null $include_inactive (optional)
     * @param  \DateTime|null $last_updated_date_range_start (optional)
     * @param  \DateTime|null $last_updated_date_range_end (optional)
     * @param  \DateTime|null $account_opened_date_range_start (optional)
     * @param  \DateTime|null $account_opened_date_range_end (optional)
     * @param  \DateTime|null $last_visit_date_range_start (optional)
     * @param  \DateTime|null $last_visit_date_range_end (optional)
     * @param  bool|null $opt_in_email (optional)
     * @param  bool|null $opt_in_direct_mail (optional)
     * @param  bool|null $opt_in_telephone (optional)
     * @param  string|null $loyalty_field_search_field_name (optional)
     * @param  \Opsuite2\Model\SearchOperatorEnum|null $loyalty_field_search_operator (optional)
     * @param  string|null $loyalty_field_search_search_value (optional)
     * @param  int|null $birthday_month (optional)
     * @param  bool|null $is_referred (optional)
     * @param  int[]|null $customer_ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersGetAsyncWithHttpInfo($page_number = null, $page_size = null, $account_number = null, $account_number_search_operator = null, $account_type_id = null, $loyalty_card_number = null, $loyalty_card_number_search_operator = null, $billing_first_name = null, $billing_last_name = null, $has_billing_email = null, $billing_email = null, $billing_email_search_operator = null, $ship_to_first_name = null, $ship_to_last_name = null, $has_ship_to_email = null, $ship_to_email = null, $ship_to_email_search_operator = null, $include_inactive = null, $last_updated_date_range_start = null, $last_updated_date_range_end = null, $account_opened_date_range_start = null, $account_opened_date_range_end = null, $last_visit_date_range_start = null, $last_visit_date_range_end = null, $opt_in_email = null, $opt_in_direct_mail = null, $opt_in_telephone = null, $loyalty_field_search_field_name = null, $loyalty_field_search_operator = null, $loyalty_field_search_search_value = null, $birthday_month = null, $is_referred = null, $customer_ids = null, string $contentType = self::contentTypes['apiV1CustomersGet'][0])
    {
        $returnType = '\Opsuite2\Model\Customer[]';
        $request = $this->apiV1CustomersGetRequest($page_number, $page_size, $account_number, $account_number_search_operator, $account_type_id, $loyalty_card_number, $loyalty_card_number_search_operator, $billing_first_name, $billing_last_name, $has_billing_email, $billing_email, $billing_email_search_operator, $ship_to_first_name, $ship_to_last_name, $has_ship_to_email, $ship_to_email, $ship_to_email_search_operator, $include_inactive, $last_updated_date_range_start, $last_updated_date_range_end, $account_opened_date_range_start, $account_opened_date_range_end, $last_visit_date_range_start, $last_visit_date_range_end, $opt_in_email, $opt_in_direct_mail, $opt_in_telephone, $loyalty_field_search_field_name, $loyalty_field_search_operator, $loyalty_field_search_search_value, $birthday_month, $is_referred, $customer_ids, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string|null $account_number (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $account_number_search_operator (optional)
     * @param  int|null $account_type_id (optional)
     * @param  string|null $loyalty_card_number (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $loyalty_card_number_search_operator (optional)
     * @param  string|null $billing_first_name (optional)
     * @param  string|null $billing_last_name (optional)
     * @param  bool|null $has_billing_email (optional)
     * @param  string|null $billing_email (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $billing_email_search_operator (optional)
     * @param  string|null $ship_to_first_name (optional)
     * @param  string|null $ship_to_last_name (optional)
     * @param  bool|null $has_ship_to_email (optional)
     * @param  string|null $ship_to_email (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $ship_to_email_search_operator (optional)
     * @param  bool|null $include_inactive (optional)
     * @param  \DateTime|null $last_updated_date_range_start (optional)
     * @param  \DateTime|null $last_updated_date_range_end (optional)
     * @param  \DateTime|null $account_opened_date_range_start (optional)
     * @param  \DateTime|null $account_opened_date_range_end (optional)
     * @param  \DateTime|null $last_visit_date_range_start (optional)
     * @param  \DateTime|null $last_visit_date_range_end (optional)
     * @param  bool|null $opt_in_email (optional)
     * @param  bool|null $opt_in_direct_mail (optional)
     * @param  bool|null $opt_in_telephone (optional)
     * @param  string|null $loyalty_field_search_field_name (optional)
     * @param  \Opsuite2\Model\SearchOperatorEnum|null $loyalty_field_search_operator (optional)
     * @param  string|null $loyalty_field_search_search_value (optional)
     * @param  int|null $birthday_month (optional)
     * @param  bool|null $is_referred (optional)
     * @param  int[]|null $customer_ids (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomersGetRequest($page_number = null, $page_size = null, $account_number = null, $account_number_search_operator = null, $account_type_id = null, $loyalty_card_number = null, $loyalty_card_number_search_operator = null, $billing_first_name = null, $billing_last_name = null, $has_billing_email = null, $billing_email = null, $billing_email_search_operator = null, $ship_to_first_name = null, $ship_to_last_name = null, $has_ship_to_email = null, $ship_to_email = null, $ship_to_email_search_operator = null, $include_inactive = null, $last_updated_date_range_start = null, $last_updated_date_range_end = null, $account_opened_date_range_start = null, $account_opened_date_range_end = null, $last_visit_date_range_start = null, $last_visit_date_range_end = null, $opt_in_email = null, $opt_in_direct_mail = null, $opt_in_telephone = null, $loyalty_field_search_field_name = null, $loyalty_field_search_operator = null, $loyalty_field_search_search_value = null, $birthday_month = null, $is_referred = null, $customer_ids = null, string $contentType = self::contentTypes['apiV1CustomersGet'][0])
    {



































        $resourcePath = '/api/v1/Customers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $account_number,
            'AccountNumber', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $account_number_search_operator,
            'AccountNumberSearchOperator', // param base name
            'SimpleSearchOperatorEnum', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $account_type_id,
            'AccountTypeId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $loyalty_card_number,
            'LoyaltyCardNumber', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $loyalty_card_number_search_operator,
            'LoyaltyCardNumberSearchOperator', // param base name
            'SimpleSearchOperatorEnum', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $billing_first_name,
            'BillingFirstName', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $billing_last_name,
            'BillingLastName', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $has_billing_email,
            'HasBillingEmail', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $billing_email,
            'BillingEmail', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $billing_email_search_operator,
            'BillingEmailSearchOperator', // param base name
            'SimpleSearchOperatorEnum', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $ship_to_first_name,
            'ShipToFirstName', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $ship_to_last_name,
            'ShipToLastName', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $has_ship_to_email,
            'HasShipToEmail', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $ship_to_email,
            'ShipToEmail', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $ship_to_email_search_operator,
            'ShipToEmailSearchOperator', // param base name
            'SimpleSearchOperatorEnum', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_inactive,
            'IncludeInactive', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $last_updated_date_range_start,
            'LastUpdatedDateRangeStart', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $last_updated_date_range_end,
            'LastUpdatedDateRangeEnd', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $account_opened_date_range_start,
            'AccountOpenedDateRangeStart', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $account_opened_date_range_end,
            'AccountOpenedDateRangeEnd', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $last_visit_date_range_start,
            'LastVisitDateRangeStart', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $last_visit_date_range_end,
            'LastVisitDateRangeEnd', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $opt_in_email,
            'OptInEmail', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $opt_in_direct_mail,
            'OptInDirectMail', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $opt_in_telephone,
            'OptInTelephone', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $loyalty_field_search_field_name,
            'LoyaltyFieldSearch.FieldName', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $loyalty_field_search_operator,
            'LoyaltyFieldSearch.Operator', // param base name
            'SearchOperatorEnum', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $loyalty_field_search_search_value,
            'LoyaltyFieldSearch.SearchValue', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $birthday_month,
            'BirthdayMonth', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $is_referred,
            'IsReferred', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $customer_ids,
            'CustomerIds', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersGetCustomerByAccountNumberGet
     *
     * Returns a single Customer with the specified account number or loyalty card number.
     *
     * @param  string|null $account_number account_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersGetCustomerByAccountNumberGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\Customer|string
     */
    public function apiV1CustomersGetCustomerByAccountNumberGet($account_number = null, string $contentType = self::contentTypes['apiV1CustomersGetCustomerByAccountNumberGet'][0])
    {
        list($response) = $this->apiV1CustomersGetCustomerByAccountNumberGetWithHttpInfo($account_number, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CustomersGetCustomerByAccountNumberGetWithHttpInfo
     *
     * Returns a single Customer with the specified account number or loyalty card number.
     *
     * @param  string|null $account_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersGetCustomerByAccountNumberGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\Customer|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersGetCustomerByAccountNumberGetWithHttpInfo($account_number = null, string $contentType = self::contentTypes['apiV1CustomersGetCustomerByAccountNumberGet'][0])
    {
        $request = $this->apiV1CustomersGetCustomerByAccountNumberGetRequest($account_number, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\Customer',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\Customer',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\Customer',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersGetCustomerByAccountNumberGetAsync
     *
     * Returns a single Customer with the specified account number or loyalty card number.
     *
     * @param  string|null $account_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersGetCustomerByAccountNumberGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersGetCustomerByAccountNumberGetAsync($account_number = null, string $contentType = self::contentTypes['apiV1CustomersGetCustomerByAccountNumberGet'][0])
    {
        return $this->apiV1CustomersGetCustomerByAccountNumberGetAsyncWithHttpInfo($account_number, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersGetCustomerByAccountNumberGetAsyncWithHttpInfo
     *
     * Returns a single Customer with the specified account number or loyalty card number.
     *
     * @param  string|null $account_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersGetCustomerByAccountNumberGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersGetCustomerByAccountNumberGetAsyncWithHttpInfo($account_number = null, string $contentType = self::contentTypes['apiV1CustomersGetCustomerByAccountNumberGet'][0])
    {
        $returnType = '\Opsuite2\Model\Customer';
        $request = $this->apiV1CustomersGetCustomerByAccountNumberGetRequest($account_number, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersGetCustomerByAccountNumberGet'
     *
     * @param  string|null $account_number (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersGetCustomerByAccountNumberGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomersGetCustomerByAccountNumberGetRequest($account_number = null, string $contentType = self::contentTypes['apiV1CustomersGetCustomerByAccountNumberGet'][0])
    {



        $resourcePath = '/api/v1/Customers/GetCustomerByAccountNumber';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $account_number,
            'accountNumber', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersGetCustomerByAddressGet
     *
     * Returns a single Customer with the specified physical address.
     *
     * @param  string|null $address_line1 address_line1 (optional)
     * @param  string|null $postcode postcode (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersGetCustomerByAddressGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\Customer|string
     */
    public function apiV1CustomersGetCustomerByAddressGet($address_line1 = null, $postcode = null, string $contentType = self::contentTypes['apiV1CustomersGetCustomerByAddressGet'][0])
    {
        list($response) = $this->apiV1CustomersGetCustomerByAddressGetWithHttpInfo($address_line1, $postcode, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CustomersGetCustomerByAddressGetWithHttpInfo
     *
     * Returns a single Customer with the specified physical address.
     *
     * @param  string|null $address_line1 (optional)
     * @param  string|null $postcode (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersGetCustomerByAddressGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\Customer|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersGetCustomerByAddressGetWithHttpInfo($address_line1 = null, $postcode = null, string $contentType = self::contentTypes['apiV1CustomersGetCustomerByAddressGet'][0])
    {
        $request = $this->apiV1CustomersGetCustomerByAddressGetRequest($address_line1, $postcode, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\Customer',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\Customer',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\Customer',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersGetCustomerByAddressGetAsync
     *
     * Returns a single Customer with the specified physical address.
     *
     * @param  string|null $address_line1 (optional)
     * @param  string|null $postcode (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersGetCustomerByAddressGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersGetCustomerByAddressGetAsync($address_line1 = null, $postcode = null, string $contentType = self::contentTypes['apiV1CustomersGetCustomerByAddressGet'][0])
    {
        return $this->apiV1CustomersGetCustomerByAddressGetAsyncWithHttpInfo($address_line1, $postcode, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersGetCustomerByAddressGetAsyncWithHttpInfo
     *
     * Returns a single Customer with the specified physical address.
     *
     * @param  string|null $address_line1 (optional)
     * @param  string|null $postcode (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersGetCustomerByAddressGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersGetCustomerByAddressGetAsyncWithHttpInfo($address_line1 = null, $postcode = null, string $contentType = self::contentTypes['apiV1CustomersGetCustomerByAddressGet'][0])
    {
        $returnType = '\Opsuite2\Model\Customer';
        $request = $this->apiV1CustomersGetCustomerByAddressGetRequest($address_line1, $postcode, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersGetCustomerByAddressGet'
     *
     * @param  string|null $address_line1 (optional)
     * @param  string|null $postcode (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersGetCustomerByAddressGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomersGetCustomerByAddressGetRequest($address_line1 = null, $postcode = null, string $contentType = self::contentTypes['apiV1CustomersGetCustomerByAddressGet'][0])
    {




        $resourcePath = '/api/v1/Customers/GetCustomerByAddress';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $address_line1,
            'addressLine1', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $postcode,
            'postcode', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersGetCustomerByEmailAddressGet
     *
     * Returns a single Customer with the specified email address.
     *
     * @param  string|null $email_address email_address (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersGetCustomerByEmailAddressGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\Customer|string
     */
    public function apiV1CustomersGetCustomerByEmailAddressGet($email_address = null, string $contentType = self::contentTypes['apiV1CustomersGetCustomerByEmailAddressGet'][0])
    {
        list($response) = $this->apiV1CustomersGetCustomerByEmailAddressGetWithHttpInfo($email_address, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CustomersGetCustomerByEmailAddressGetWithHttpInfo
     *
     * Returns a single Customer with the specified email address.
     *
     * @param  string|null $email_address (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersGetCustomerByEmailAddressGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\Customer|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersGetCustomerByEmailAddressGetWithHttpInfo($email_address = null, string $contentType = self::contentTypes['apiV1CustomersGetCustomerByEmailAddressGet'][0])
    {
        $request = $this->apiV1CustomersGetCustomerByEmailAddressGetRequest($email_address, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\Customer',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\Customer',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\Customer',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersGetCustomerByEmailAddressGetAsync
     *
     * Returns a single Customer with the specified email address.
     *
     * @param  string|null $email_address (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersGetCustomerByEmailAddressGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersGetCustomerByEmailAddressGetAsync($email_address = null, string $contentType = self::contentTypes['apiV1CustomersGetCustomerByEmailAddressGet'][0])
    {
        return $this->apiV1CustomersGetCustomerByEmailAddressGetAsyncWithHttpInfo($email_address, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersGetCustomerByEmailAddressGetAsyncWithHttpInfo
     *
     * Returns a single Customer with the specified email address.
     *
     * @param  string|null $email_address (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersGetCustomerByEmailAddressGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersGetCustomerByEmailAddressGetAsyncWithHttpInfo($email_address = null, string $contentType = self::contentTypes['apiV1CustomersGetCustomerByEmailAddressGet'][0])
    {
        $returnType = '\Opsuite2\Model\Customer';
        $request = $this->apiV1CustomersGetCustomerByEmailAddressGetRequest($email_address, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersGetCustomerByEmailAddressGet'
     *
     * @param  string|null $email_address (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersGetCustomerByEmailAddressGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomersGetCustomerByEmailAddressGetRequest($email_address = null, string $contentType = self::contentTypes['apiV1CustomersGetCustomerByEmailAddressGet'][0])
    {



        $resourcePath = '/api/v1/Customers/GetCustomerByEmailAddress';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $email_address,
            'emailAddress', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersPost
     *
     * Creates a new customer.
     *
     * @param  \Opsuite2\Model\Customer|null $customer customer (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\Customer|string|string
     */
    public function apiV1CustomersPost($customer = null, string $contentType = self::contentTypes['apiV1CustomersPost'][0])
    {
        list($response) = $this->apiV1CustomersPostWithHttpInfo($customer, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CustomersPostWithHttpInfo
     *
     * Creates a new customer.
     *
     * @param  \Opsuite2\Model\Customer|null $customer (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\Customer|string|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersPostWithHttpInfo($customer = null, string $contentType = self::contentTypes['apiV1CustomersPost'][0])
    {
        $request = $this->apiV1CustomersPostRequest($customer, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\Customer',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\Customer',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\Customer',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersPostAsync
     *
     * Creates a new customer.
     *
     * @param  \Opsuite2\Model\Customer|null $customer (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersPostAsync($customer = null, string $contentType = self::contentTypes['apiV1CustomersPost'][0])
    {
        return $this->apiV1CustomersPostAsyncWithHttpInfo($customer, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersPostAsyncWithHttpInfo
     *
     * Creates a new customer.
     *
     * @param  \Opsuite2\Model\Customer|null $customer (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersPostAsyncWithHttpInfo($customer = null, string $contentType = self::contentTypes['apiV1CustomersPost'][0])
    {
        $returnType = '\Opsuite2\Model\Customer';
        $request = $this->apiV1CustomersPostRequest($customer, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersPost'
     *
     * @param  \Opsuite2\Model\Customer|null $customer (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomersPostRequest($customer = null, string $contentType = self::contentTypes['apiV1CustomersPost'][0])
    {



        $resourcePath = '/api/v1/Customers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($customer)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($customer));
            } else {
                $httpBody = $customer;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomersPut
     *
     * Updates a batch of customers.
     *
     * @param  \Opsuite2\Model\Customer[]|null $customer customer (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersPut'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function apiV1CustomersPut($customer = null, string $contentType = self::contentTypes['apiV1CustomersPut'][0])
    {
        $this->apiV1CustomersPutWithHttpInfo($customer, $contentType);
    }

    /**
     * Operation apiV1CustomersPutWithHttpInfo
     *
     * Updates a batch of customers.
     *
     * @param  \Opsuite2\Model\Customer[]|null $customer (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersPut'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomersPutWithHttpInfo($customer = null, string $contentType = self::contentTypes['apiV1CustomersPut'][0])
    {
        $request = $this->apiV1CustomersPutRequest($customer, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomersPutAsync
     *
     * Updates a batch of customers.
     *
     * @param  \Opsuite2\Model\Customer[]|null $customer (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersPutAsync($customer = null, string $contentType = self::contentTypes['apiV1CustomersPut'][0])
    {
        return $this->apiV1CustomersPutAsyncWithHttpInfo($customer, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomersPutAsyncWithHttpInfo
     *
     * Updates a batch of customers.
     *
     * @param  \Opsuite2\Model\Customer[]|null $customer (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomersPutAsyncWithHttpInfo($customer = null, string $contentType = self::contentTypes['apiV1CustomersPut'][0])
    {
        $returnType = '';
        $request = $this->apiV1CustomersPutRequest($customer, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomersPut'
     *
     * @param  \Opsuite2\Model\Customer[]|null $customer (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomersPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomersPutRequest($customer = null, string $contentType = self::contentTypes['apiV1CustomersPut'][0])
    {



        $resourcePath = '/api/v1/Customers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($customer)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($customer));
            } else {
                $httpBody = $customer;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getCustomerById
     *
     * Returns a single Customer with the specified id.
     *
     * @param  int $customer_id customer_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerById'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\Customer|string
     */
    public function getCustomerById($customer_id, string $contentType = self::contentTypes['getCustomerById'][0])
    {
        list($response) = $this->getCustomerByIdWithHttpInfo($customer_id, $contentType);
        return $response;
    }

    /**
     * Operation getCustomerByIdWithHttpInfo
     *
     * Returns a single Customer with the specified id.
     *
     * @param  int $customer_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerById'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\Customer|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCustomerByIdWithHttpInfo($customer_id, string $contentType = self::contentTypes['getCustomerById'][0])
    {
        $request = $this->getCustomerByIdRequest($customer_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\Customer',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\Customer',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\Customer',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getCustomerByIdAsync
     *
     * Returns a single Customer with the specified id.
     *
     * @param  int $customer_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCustomerByIdAsync($customer_id, string $contentType = self::contentTypes['getCustomerById'][0])
    {
        return $this->getCustomerByIdAsyncWithHttpInfo($customer_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCustomerByIdAsyncWithHttpInfo
     *
     * Returns a single Customer with the specified id.
     *
     * @param  int $customer_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCustomerByIdAsyncWithHttpInfo($customer_id, string $contentType = self::contentTypes['getCustomerById'][0])
    {
        $returnType = '\Opsuite2\Model\Customer';
        $request = $this->getCustomerByIdRequest($customer_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCustomerById'
     *
     * @param  int $customer_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getCustomerByIdRequest($customer_id, string $contentType = self::contentTypes['getCustomerById'][0])
    {

        // verify the required parameter 'customer_id' is set
        if ($customer_id === null || (is_array($customer_id) && count($customer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_id when calling getCustomerById'
            );
        }
        if ($customer_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$customer_id" when calling CustomersApi.getCustomerById, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v1/Customers/{customerId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($customer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customerId' . '}',
                ObjectSerializer::toPathValue($customer_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
