<?php
/**
 * CustomerRewardsCampaignsApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Opsuite2\ApiException;
use Opsuite2\Configuration;
use Opsuite2\FormDataProcessor;
use Opsuite2\HeaderSelector;
use Opsuite2\ObjectSerializer;

/**
 * CustomerRewardsCampaignsApi Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class CustomerRewardsCampaignsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGet' => [
            'application/json',
        ],
        'apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGet' => [
            'application/json',
        ],
        'apiV1CustomerRewardsCampaignsGet' => [
            'application/json',
        ],
        'apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGet' => [
            'application/json',
        ],
        'getCustomerRewardsCampaignById' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGet
     *
     * Returns an array of discount coupons for the specified customer rewards campaign
     *
     * @param  int $campaign_id campaign_id (required)
     * @param  bool|null $include_zero_valued_coupons include_zero_valued_coupons (optional)
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\CustomerDiscountCoupon[]|string
     */
    public function apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGet($campaign_id, $include_zero_valued_coupons = null, $page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGet'][0])
    {
        list($response) = $this->apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGetWithHttpInfo($campaign_id, $include_zero_valued_coupons, $page_number, $page_size, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGetWithHttpInfo
     *
     * Returns an array of discount coupons for the specified customer rewards campaign
     *
     * @param  int $campaign_id (required)
     * @param  bool|null $include_zero_valued_coupons (optional)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\CustomerDiscountCoupon[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGetWithHttpInfo($campaign_id, $include_zero_valued_coupons = null, $page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGet'][0])
    {
        $request = $this->apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGetRequest($campaign_id, $include_zero_valued_coupons, $page_number, $page_size, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\CustomerDiscountCoupon[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\CustomerDiscountCoupon[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\CustomerDiscountCoupon[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGetAsync
     *
     * Returns an array of discount coupons for the specified customer rewards campaign
     *
     * @param  int $campaign_id (required)
     * @param  bool|null $include_zero_valued_coupons (optional)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGetAsync($campaign_id, $include_zero_valued_coupons = null, $page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGet'][0])
    {
        return $this->apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGetAsyncWithHttpInfo($campaign_id, $include_zero_valued_coupons, $page_number, $page_size, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGetAsyncWithHttpInfo
     *
     * Returns an array of discount coupons for the specified customer rewards campaign
     *
     * @param  int $campaign_id (required)
     * @param  bool|null $include_zero_valued_coupons (optional)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGetAsyncWithHttpInfo($campaign_id, $include_zero_valued_coupons = null, $page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGet'][0])
    {
        $returnType = '\Opsuite2\Model\CustomerDiscountCoupon[]';
        $request = $this->apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGetRequest($campaign_id, $include_zero_valued_coupons, $page_number, $page_size, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGet'
     *
     * @param  int $campaign_id (required)
     * @param  bool|null $include_zero_valued_coupons (optional)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGetRequest($campaign_id, $include_zero_valued_coupons = null, $page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGet'][0])
    {

        // verify the required parameter 'campaign_id' is set
        if ($campaign_id === null || (is_array($campaign_id) && count($campaign_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $campaign_id when calling apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGet'
            );
        }
        if ($campaign_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$campaign_id" when calling CustomerRewardsCampaignsApi.apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGet, must be bigger than or equal to 1.');
        }
        




        $resourcePath = '/api/v1/CustomerRewardsCampaigns/{campaignId}/DiscountCoupons';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_zero_valued_coupons,
            'includeZeroValuedCoupons', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($campaign_id !== null) {
            $resourcePath = str_replace(
                '{' . 'campaignId' . '}',
                ObjectSerializer::toPathValue($campaign_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGet
     *
     * Returns an array of promotion coupons for the specified customer rewards campaign
     *
     * @param  int $campaign_id campaign_id (required)
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\CustomerPromotionCoupon[]|string
     */
    public function apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGet($campaign_id, $page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGet'][0])
    {
        list($response) = $this->apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGetWithHttpInfo($campaign_id, $page_number, $page_size, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGetWithHttpInfo
     *
     * Returns an array of promotion coupons for the specified customer rewards campaign
     *
     * @param  int $campaign_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\CustomerPromotionCoupon[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGetWithHttpInfo($campaign_id, $page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGet'][0])
    {
        $request = $this->apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGetRequest($campaign_id, $page_number, $page_size, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\CustomerPromotionCoupon[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\CustomerPromotionCoupon[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\CustomerPromotionCoupon[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGetAsync
     *
     * Returns an array of promotion coupons for the specified customer rewards campaign
     *
     * @param  int $campaign_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGetAsync($campaign_id, $page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGet'][0])
    {
        return $this->apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGetAsyncWithHttpInfo($campaign_id, $page_number, $page_size, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGetAsyncWithHttpInfo
     *
     * Returns an array of promotion coupons for the specified customer rewards campaign
     *
     * @param  int $campaign_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGetAsyncWithHttpInfo($campaign_id, $page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGet'][0])
    {
        $returnType = '\Opsuite2\Model\CustomerPromotionCoupon[]';
        $request = $this->apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGetRequest($campaign_id, $page_number, $page_size, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGet'
     *
     * @param  int $campaign_id (required)
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGetRequest($campaign_id, $page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGet'][0])
    {

        // verify the required parameter 'campaign_id' is set
        if ($campaign_id === null || (is_array($campaign_id) && count($campaign_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $campaign_id when calling apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGet'
            );
        }
        if ($campaign_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$campaign_id" when calling CustomerRewardsCampaignsApi.apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGet, must be bigger than or equal to 1.');
        }
        



        $resourcePath = '/api/v1/CustomerRewardsCampaigns/{campaignId}/PromotionCoupons';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($campaign_id !== null) {
            $resourcePath = str_replace(
                '{' . 'campaignId' . '}',
                ObjectSerializer::toPathValue($campaign_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomerRewardsCampaignsGet
     *
     * Returns an array of Customer Rewards Campaigns.
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomerRewardsCampaignsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\CustomerRewardsCampaign[]|string
     */
    public function apiV1CustomerRewardsCampaignsGet($page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomerRewardsCampaignsGet'][0])
    {
        list($response) = $this->apiV1CustomerRewardsCampaignsGetWithHttpInfo($page_number, $page_size, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CustomerRewardsCampaignsGetWithHttpInfo
     *
     * Returns an array of Customer Rewards Campaigns.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomerRewardsCampaignsGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\CustomerRewardsCampaign[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomerRewardsCampaignsGetWithHttpInfo($page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomerRewardsCampaignsGet'][0])
    {
        $request = $this->apiV1CustomerRewardsCampaignsGetRequest($page_number, $page_size, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\CustomerRewardsCampaign[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\CustomerRewardsCampaign[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\CustomerRewardsCampaign[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomerRewardsCampaignsGetAsync
     *
     * Returns an array of Customer Rewards Campaigns.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomerRewardsCampaignsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomerRewardsCampaignsGetAsync($page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomerRewardsCampaignsGet'][0])
    {
        return $this->apiV1CustomerRewardsCampaignsGetAsyncWithHttpInfo($page_number, $page_size, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomerRewardsCampaignsGetAsyncWithHttpInfo
     *
     * Returns an array of Customer Rewards Campaigns.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomerRewardsCampaignsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomerRewardsCampaignsGetAsyncWithHttpInfo($page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomerRewardsCampaignsGet'][0])
    {
        $returnType = '\Opsuite2\Model\CustomerRewardsCampaign[]';
        $request = $this->apiV1CustomerRewardsCampaignsGetRequest($page_number, $page_size, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomerRewardsCampaignsGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomerRewardsCampaignsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomerRewardsCampaignsGetRequest($page_number = null, $page_size = null, string $contentType = self::contentTypes['apiV1CustomerRewardsCampaignsGet'][0])
    {




        $resourcePath = '/api/v1/CustomerRewardsCampaigns';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGet
     *
     * Returns a single Customer Rewards Campaign with the specified code.
     *
     * @param  string|null $campaign_code campaign_code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\CustomerRewardsCampaign|string
     */
    public function apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGet($campaign_code = null, string $contentType = self::contentTypes['apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGet'][0])
    {
        list($response) = $this->apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGetWithHttpInfo($campaign_code, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGetWithHttpInfo
     *
     * Returns a single Customer Rewards Campaign with the specified code.
     *
     * @param  string|null $campaign_code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\CustomerRewardsCampaign|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGetWithHttpInfo($campaign_code = null, string $contentType = self::contentTypes['apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGet'][0])
    {
        $request = $this->apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGetRequest($campaign_code, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\CustomerRewardsCampaign',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\CustomerRewardsCampaign',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\CustomerRewardsCampaign',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGetAsync
     *
     * Returns a single Customer Rewards Campaign with the specified code.
     *
     * @param  string|null $campaign_code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGetAsync($campaign_code = null, string $contentType = self::contentTypes['apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGet'][0])
    {
        return $this->apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGetAsyncWithHttpInfo($campaign_code, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGetAsyncWithHttpInfo
     *
     * Returns a single Customer Rewards Campaign with the specified code.
     *
     * @param  string|null $campaign_code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGetAsyncWithHttpInfo($campaign_code = null, string $contentType = self::contentTypes['apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGet'][0])
    {
        $returnType = '\Opsuite2\Model\CustomerRewardsCampaign';
        $request = $this->apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGetRequest($campaign_code, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGet'
     *
     * @param  string|null $campaign_code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGetRequest($campaign_code = null, string $contentType = self::contentTypes['apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGet'][0])
    {



        $resourcePath = '/api/v1/CustomerRewardsCampaigns/GetCustomerRewardsCampaignByCode';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $campaign_code,
            'campaignCode', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getCustomerRewardsCampaignById
     *
     * Returns a single Customer Rewards Campaign with the specified id.
     *
     * @param  int $campaign_id campaign_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerRewardsCampaignById'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\CustomerRewardsCampaign|string
     */
    public function getCustomerRewardsCampaignById($campaign_id, string $contentType = self::contentTypes['getCustomerRewardsCampaignById'][0])
    {
        list($response) = $this->getCustomerRewardsCampaignByIdWithHttpInfo($campaign_id, $contentType);
        return $response;
    }

    /**
     * Operation getCustomerRewardsCampaignByIdWithHttpInfo
     *
     * Returns a single Customer Rewards Campaign with the specified id.
     *
     * @param  int $campaign_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerRewardsCampaignById'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\CustomerRewardsCampaign|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCustomerRewardsCampaignByIdWithHttpInfo($campaign_id, string $contentType = self::contentTypes['getCustomerRewardsCampaignById'][0])
    {
        $request = $this->getCustomerRewardsCampaignByIdRequest($campaign_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\CustomerRewardsCampaign',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\CustomerRewardsCampaign',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\CustomerRewardsCampaign',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getCustomerRewardsCampaignByIdAsync
     *
     * Returns a single Customer Rewards Campaign with the specified id.
     *
     * @param  int $campaign_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerRewardsCampaignById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCustomerRewardsCampaignByIdAsync($campaign_id, string $contentType = self::contentTypes['getCustomerRewardsCampaignById'][0])
    {
        return $this->getCustomerRewardsCampaignByIdAsyncWithHttpInfo($campaign_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCustomerRewardsCampaignByIdAsyncWithHttpInfo
     *
     * Returns a single Customer Rewards Campaign with the specified id.
     *
     * @param  int $campaign_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerRewardsCampaignById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCustomerRewardsCampaignByIdAsyncWithHttpInfo($campaign_id, string $contentType = self::contentTypes['getCustomerRewardsCampaignById'][0])
    {
        $returnType = '\Opsuite2\Model\CustomerRewardsCampaign';
        $request = $this->getCustomerRewardsCampaignByIdRequest($campaign_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCustomerRewardsCampaignById'
     *
     * @param  int $campaign_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerRewardsCampaignById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getCustomerRewardsCampaignByIdRequest($campaign_id, string $contentType = self::contentTypes['getCustomerRewardsCampaignById'][0])
    {

        // verify the required parameter 'campaign_id' is set
        if ($campaign_id === null || (is_array($campaign_id) && count($campaign_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $campaign_id when calling getCustomerRewardsCampaignById'
            );
        }
        if ($campaign_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$campaign_id" when calling CustomerRewardsCampaignsApi.getCustomerRewardsCampaignById, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v1/CustomerRewardsCampaigns/{campaignId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($campaign_id !== null) {
            $resourcePath = str_replace(
                '{' . 'campaignId' . '}',
                ObjectSerializer::toPathValue($campaign_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
