<?php
/**
 * CategoriesApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpSuite API
 *
 * <p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>
 *
 * The version of the OpenAPI document: v2
 * Contact: opsuitesupport@davrich.co.uk
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Opsuite2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Opsuite2\ApiException;
use Opsuite2\Configuration;
use Opsuite2\FormDataProcessor;
use Opsuite2\HeaderSelector;
use Opsuite2\ObjectSerializer;

/**
 * CategoriesApi Class Doc Comment
 *
 * @category Class
 * @package  Opsuite2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class CategoriesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'apiV1CategoriesCategoryIdPatch' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'apiV1CategoriesGet' => [
            'application/json',
        ],
        'apiV1CategoriesGetCategoryByCodeGet' => [
            'application/json',
        ],
        'apiV1CategoriesPatchMultipleCategoriesPatch' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'apiV1CategoriesPost' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'apiV1CategoriesPostMultipleCategoriesPost' => [
            'application/json',
            'text/json',
            'application/*+json',
        ],
        'getCategoryById' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation apiV1CategoriesCategoryIdPatch
     *
     * Updates specified properties of a category.
     *
     * @param  int $category_id category_id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesCategoryIdPatch'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function apiV1CategoriesCategoryIdPatch($category_id, $patch = null, string $contentType = self::contentTypes['apiV1CategoriesCategoryIdPatch'][0])
    {
        $this->apiV1CategoriesCategoryIdPatchWithHttpInfo($category_id, $patch, $contentType);
    }

    /**
     * Operation apiV1CategoriesCategoryIdPatchWithHttpInfo
     *
     * Updates specified properties of a category.
     *
     * @param  int $category_id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesCategoryIdPatch'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CategoriesCategoryIdPatchWithHttpInfo($category_id, $patch = null, string $contentType = self::contentTypes['apiV1CategoriesCategoryIdPatch'][0])
    {
        $request = $this->apiV1CategoriesCategoryIdPatchRequest($category_id, $patch, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CategoriesCategoryIdPatchAsync
     *
     * Updates specified properties of a category.
     *
     * @param  int $category_id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesCategoryIdPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesCategoryIdPatchAsync($category_id, $patch = null, string $contentType = self::contentTypes['apiV1CategoriesCategoryIdPatch'][0])
    {
        return $this->apiV1CategoriesCategoryIdPatchAsyncWithHttpInfo($category_id, $patch, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CategoriesCategoryIdPatchAsyncWithHttpInfo
     *
     * Updates specified properties of a category.
     *
     * @param  int $category_id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesCategoryIdPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesCategoryIdPatchAsyncWithHttpInfo($category_id, $patch = null, string $contentType = self::contentTypes['apiV1CategoriesCategoryIdPatch'][0])
    {
        $returnType = '';
        $request = $this->apiV1CategoriesCategoryIdPatchRequest($category_id, $patch, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CategoriesCategoryIdPatch'
     *
     * @param  int $category_id (required)
     * @param  \Opsuite2\Model\Patch[]|null $patch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesCategoryIdPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CategoriesCategoryIdPatchRequest($category_id, $patch = null, string $contentType = self::contentTypes['apiV1CategoriesCategoryIdPatch'][0])
    {

        // verify the required parameter 'category_id' is set
        if ($category_id === null || (is_array($category_id) && count($category_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $category_id when calling apiV1CategoriesCategoryIdPatch'
            );
        }
        if ($category_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$category_id" when calling CategoriesApi.apiV1CategoriesCategoryIdPatch, must be bigger than or equal to 1.');
        }
        


        $resourcePath = '/api/v1/Categories/{categoryId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($category_id !== null) {
            $resourcePath = str_replace(
                '{' . 'categoryId' . '}',
                ObjectSerializer::toPathValue($category_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($patch)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($patch));
            } else {
                $httpBody = $patch;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CategoriesGet
     *
     * Returns an array of Categories that match the specified search criteria.
     *
     * @param  int|null $page_number page_number (optional)
     * @param  int|null $page_size page_size (optional)
     * @param  int|null $department_id department_id (optional)
     * @param  string|null $department_code department_code (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $department_code_search_operator department_code_search_operator (optional)
     * @param  string|null $department_name department_name (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $department_name_search_operator department_name_search_operator (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\Category[]|string
     */
    public function apiV1CategoriesGet($page_number = null, $page_size = null, $department_id = null, $department_code = null, $department_code_search_operator = null, $department_name = null, $department_name_search_operator = null, string $contentType = self::contentTypes['apiV1CategoriesGet'][0])
    {
        list($response) = $this->apiV1CategoriesGetWithHttpInfo($page_number, $page_size, $department_id, $department_code, $department_code_search_operator, $department_name, $department_name_search_operator, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CategoriesGetWithHttpInfo
     *
     * Returns an array of Categories that match the specified search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $department_id (optional)
     * @param  string|null $department_code (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $department_code_search_operator (optional)
     * @param  string|null $department_name (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $department_name_search_operator (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\Category[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CategoriesGetWithHttpInfo($page_number = null, $page_size = null, $department_id = null, $department_code = null, $department_code_search_operator = null, $department_name = null, $department_name_search_operator = null, string $contentType = self::contentTypes['apiV1CategoriesGet'][0])
    {
        $request = $this->apiV1CategoriesGetRequest($page_number, $page_size, $department_id, $department_code, $department_code_search_operator, $department_name, $department_name_search_operator, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\Category[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\Category[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\Category[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CategoriesGetAsync
     *
     * Returns an array of Categories that match the specified search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $department_id (optional)
     * @param  string|null $department_code (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $department_code_search_operator (optional)
     * @param  string|null $department_name (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $department_name_search_operator (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesGetAsync($page_number = null, $page_size = null, $department_id = null, $department_code = null, $department_code_search_operator = null, $department_name = null, $department_name_search_operator = null, string $contentType = self::contentTypes['apiV1CategoriesGet'][0])
    {
        return $this->apiV1CategoriesGetAsyncWithHttpInfo($page_number, $page_size, $department_id, $department_code, $department_code_search_operator, $department_name, $department_name_search_operator, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CategoriesGetAsyncWithHttpInfo
     *
     * Returns an array of Categories that match the specified search criteria.
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $department_id (optional)
     * @param  string|null $department_code (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $department_code_search_operator (optional)
     * @param  string|null $department_name (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $department_name_search_operator (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesGetAsyncWithHttpInfo($page_number = null, $page_size = null, $department_id = null, $department_code = null, $department_code_search_operator = null, $department_name = null, $department_name_search_operator = null, string $contentType = self::contentTypes['apiV1CategoriesGet'][0])
    {
        $returnType = '\Opsuite2\Model\Category[]';
        $request = $this->apiV1CategoriesGetRequest($page_number, $page_size, $department_id, $department_code, $department_code_search_operator, $department_name, $department_name_search_operator, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CategoriesGet'
     *
     * @param  int|null $page_number (optional)
     * @param  int|null $page_size (optional)
     * @param  int|null $department_id (optional)
     * @param  string|null $department_code (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $department_code_search_operator (optional)
     * @param  string|null $department_name (optional)
     * @param  \Opsuite2\Model\SimpleSearchOperatorEnum|null $department_name_search_operator (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CategoriesGetRequest($page_number = null, $page_size = null, $department_id = null, $department_code = null, $department_code_search_operator = null, $department_name = null, $department_name_search_operator = null, string $contentType = self::contentTypes['apiV1CategoriesGet'][0])
    {









        $resourcePath = '/api/v1/Categories';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'PageNumber', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'PageSize', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $department_id,
            'DepartmentId', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $department_code,
            'DepartmentCode', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $department_code_search_operator,
            'DepartmentCodeSearchOperator', // param base name
            'SimpleSearchOperatorEnum', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $department_name,
            'DepartmentName', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $department_name_search_operator,
            'DepartmentNameSearchOperator', // param base name
            'SimpleSearchOperatorEnum', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CategoriesGetCategoryByCodeGet
     *
     * Returns a single Category with the specified code.
     *
     * @param  string|null $category_code category_code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesGetCategoryByCodeGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\Category|string
     */
    public function apiV1CategoriesGetCategoryByCodeGet($category_code = null, string $contentType = self::contentTypes['apiV1CategoriesGetCategoryByCodeGet'][0])
    {
        list($response) = $this->apiV1CategoriesGetCategoryByCodeGetWithHttpInfo($category_code, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CategoriesGetCategoryByCodeGetWithHttpInfo
     *
     * Returns a single Category with the specified code.
     *
     * @param  string|null $category_code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesGetCategoryByCodeGet'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\Category|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CategoriesGetCategoryByCodeGetWithHttpInfo($category_code = null, string $contentType = self::contentTypes['apiV1CategoriesGetCategoryByCodeGet'][0])
    {
        $request = $this->apiV1CategoriesGetCategoryByCodeGetRequest($category_code, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\Category',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\Category',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\Category',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CategoriesGetCategoryByCodeGetAsync
     *
     * Returns a single Category with the specified code.
     *
     * @param  string|null $category_code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesGetCategoryByCodeGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesGetCategoryByCodeGetAsync($category_code = null, string $contentType = self::contentTypes['apiV1CategoriesGetCategoryByCodeGet'][0])
    {
        return $this->apiV1CategoriesGetCategoryByCodeGetAsyncWithHttpInfo($category_code, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CategoriesGetCategoryByCodeGetAsyncWithHttpInfo
     *
     * Returns a single Category with the specified code.
     *
     * @param  string|null $category_code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesGetCategoryByCodeGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesGetCategoryByCodeGetAsyncWithHttpInfo($category_code = null, string $contentType = self::contentTypes['apiV1CategoriesGetCategoryByCodeGet'][0])
    {
        $returnType = '\Opsuite2\Model\Category';
        $request = $this->apiV1CategoriesGetCategoryByCodeGetRequest($category_code, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CategoriesGetCategoryByCodeGet'
     *
     * @param  string|null $category_code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesGetCategoryByCodeGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CategoriesGetCategoryByCodeGetRequest($category_code = null, string $contentType = self::contentTypes['apiV1CategoriesGetCategoryByCodeGet'][0])
    {



        $resourcePath = '/api/v1/Categories/GetCategoryByCode';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $category_code,
            'categoryCode', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CategoriesPatchMultipleCategoriesPatch
     *
     * Updates specified properties of multiple categories.
     *
     * @param  \Opsuite2\Model\PatchCollection[]|null $patch_collection patch_collection (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesPatchMultipleCategoriesPatch'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\PatchResponse[]|string
     */
    public function apiV1CategoriesPatchMultipleCategoriesPatch($patch_collection = null, string $contentType = self::contentTypes['apiV1CategoriesPatchMultipleCategoriesPatch'][0])
    {
        list($response) = $this->apiV1CategoriesPatchMultipleCategoriesPatchWithHttpInfo($patch_collection, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CategoriesPatchMultipleCategoriesPatchWithHttpInfo
     *
     * Updates specified properties of multiple categories.
     *
     * @param  \Opsuite2\Model\PatchCollection[]|null $patch_collection (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesPatchMultipleCategoriesPatch'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\PatchResponse[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CategoriesPatchMultipleCategoriesPatchWithHttpInfo($patch_collection = null, string $contentType = self::contentTypes['apiV1CategoriesPatchMultipleCategoriesPatch'][0])
    {
        $request = $this->apiV1CategoriesPatchMultipleCategoriesPatchRequest($patch_collection, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 202:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\PatchResponse[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\PatchResponse[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 202:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\PatchResponse[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CategoriesPatchMultipleCategoriesPatchAsync
     *
     * Updates specified properties of multiple categories.
     *
     * @param  \Opsuite2\Model\PatchCollection[]|null $patch_collection (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesPatchMultipleCategoriesPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesPatchMultipleCategoriesPatchAsync($patch_collection = null, string $contentType = self::contentTypes['apiV1CategoriesPatchMultipleCategoriesPatch'][0])
    {
        return $this->apiV1CategoriesPatchMultipleCategoriesPatchAsyncWithHttpInfo($patch_collection, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CategoriesPatchMultipleCategoriesPatchAsyncWithHttpInfo
     *
     * Updates specified properties of multiple categories.
     *
     * @param  \Opsuite2\Model\PatchCollection[]|null $patch_collection (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesPatchMultipleCategoriesPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesPatchMultipleCategoriesPatchAsyncWithHttpInfo($patch_collection = null, string $contentType = self::contentTypes['apiV1CategoriesPatchMultipleCategoriesPatch'][0])
    {
        $returnType = '\Opsuite2\Model\PatchResponse[]';
        $request = $this->apiV1CategoriesPatchMultipleCategoriesPatchRequest($patch_collection, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CategoriesPatchMultipleCategoriesPatch'
     *
     * @param  \Opsuite2\Model\PatchCollection[]|null $patch_collection (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesPatchMultipleCategoriesPatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CategoriesPatchMultipleCategoriesPatchRequest($patch_collection = null, string $contentType = self::contentTypes['apiV1CategoriesPatchMultipleCategoriesPatch'][0])
    {



        $resourcePath = '/api/v1/Categories/PatchMultipleCategories';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($patch_collection)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($patch_collection));
            } else {
                $httpBody = $patch_collection;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CategoriesPost
     *
     * Creates a new category.
     *
     * @param  \Opsuite2\Model\Category|null $category category (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\Category|string|string
     */
    public function apiV1CategoriesPost($category = null, string $contentType = self::contentTypes['apiV1CategoriesPost'][0])
    {
        list($response) = $this->apiV1CategoriesPostWithHttpInfo($category, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CategoriesPostWithHttpInfo
     *
     * Creates a new category.
     *
     * @param  \Opsuite2\Model\Category|null $category (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\Category|string|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CategoriesPostWithHttpInfo($category = null, string $contentType = self::contentTypes['apiV1CategoriesPost'][0])
    {
        $request = $this->apiV1CategoriesPostRequest($category, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\Category',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\Category',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\Category',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CategoriesPostAsync
     *
     * Creates a new category.
     *
     * @param  \Opsuite2\Model\Category|null $category (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesPostAsync($category = null, string $contentType = self::contentTypes['apiV1CategoriesPost'][0])
    {
        return $this->apiV1CategoriesPostAsyncWithHttpInfo($category, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CategoriesPostAsyncWithHttpInfo
     *
     * Creates a new category.
     *
     * @param  \Opsuite2\Model\Category|null $category (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesPostAsyncWithHttpInfo($category = null, string $contentType = self::contentTypes['apiV1CategoriesPost'][0])
    {
        $returnType = '\Opsuite2\Model\Category';
        $request = $this->apiV1CategoriesPostRequest($category, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CategoriesPost'
     *
     * @param  \Opsuite2\Model\Category|null $category (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CategoriesPostRequest($category = null, string $contentType = self::contentTypes['apiV1CategoriesPost'][0])
    {



        $resourcePath = '/api/v1/Categories';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($category)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($category));
            } else {
                $httpBody = $category;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation apiV1CategoriesPostMultipleCategoriesPost
     *
     * Creates multiple new categories.
     *
     * @param  \Opsuite2\Model\Category[]|null $category category (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesPostMultipleCategoriesPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\PostResponseCategory[]|string
     */
    public function apiV1CategoriesPostMultipleCategoriesPost($category = null, string $contentType = self::contentTypes['apiV1CategoriesPostMultipleCategoriesPost'][0])
    {
        list($response) = $this->apiV1CategoriesPostMultipleCategoriesPostWithHttpInfo($category, $contentType);
        return $response;
    }

    /**
     * Operation apiV1CategoriesPostMultipleCategoriesPostWithHttpInfo
     *
     * Creates multiple new categories.
     *
     * @param  \Opsuite2\Model\Category[]|null $category (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesPostMultipleCategoriesPost'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\PostResponseCategory[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function apiV1CategoriesPostMultipleCategoriesPostWithHttpInfo($category = null, string $contentType = self::contentTypes['apiV1CategoriesPostMultipleCategoriesPost'][0])
    {
        $request = $this->apiV1CategoriesPostMultipleCategoriesPostRequest($category, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\PostResponseCategory[]',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\PostResponseCategory[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\PostResponseCategory[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation apiV1CategoriesPostMultipleCategoriesPostAsync
     *
     * Creates multiple new categories.
     *
     * @param  \Opsuite2\Model\Category[]|null $category (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesPostMultipleCategoriesPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesPostMultipleCategoriesPostAsync($category = null, string $contentType = self::contentTypes['apiV1CategoriesPostMultipleCategoriesPost'][0])
    {
        return $this->apiV1CategoriesPostMultipleCategoriesPostAsyncWithHttpInfo($category, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation apiV1CategoriesPostMultipleCategoriesPostAsyncWithHttpInfo
     *
     * Creates multiple new categories.
     *
     * @param  \Opsuite2\Model\Category[]|null $category (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesPostMultipleCategoriesPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function apiV1CategoriesPostMultipleCategoriesPostAsyncWithHttpInfo($category = null, string $contentType = self::contentTypes['apiV1CategoriesPostMultipleCategoriesPost'][0])
    {
        $returnType = '\Opsuite2\Model\PostResponseCategory[]';
        $request = $this->apiV1CategoriesPostMultipleCategoriesPostRequest($category, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'apiV1CategoriesPostMultipleCategoriesPost'
     *
     * @param  \Opsuite2\Model\Category[]|null $category (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['apiV1CategoriesPostMultipleCategoriesPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function apiV1CategoriesPostMultipleCategoriesPostRequest($category = null, string $contentType = self::contentTypes['apiV1CategoriesPostMultipleCategoriesPost'][0])
    {



        $resourcePath = '/api/v1/Categories/PostMultipleCategories';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($category)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($category));
            } else {
                $httpBody = $category;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getCategoryById
     *
     * Returns a single Category with the specified id.
     *
     * @param  int $category_id category_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategoryById'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Opsuite2\Model\Category|string
     */
    public function getCategoryById($category_id, string $contentType = self::contentTypes['getCategoryById'][0])
    {
        list($response) = $this->getCategoryByIdWithHttpInfo($category_id, $contentType);
        return $response;
    }

    /**
     * Operation getCategoryByIdWithHttpInfo
     *
     * Returns a single Category with the specified id.
     *
     * @param  int $category_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategoryById'] to see the possible values for this operation
     *
     * @throws \Opsuite2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Opsuite2\Model\Category|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCategoryByIdWithHttpInfo($category_id, string $contentType = self::contentTypes['getCategoryById'][0])
    {
        $request = $this->getCategoryByIdRequest($category_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Opsuite2\Model\Category',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Opsuite2\Model\Category',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Opsuite2\Model\Category',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getCategoryByIdAsync
     *
     * Returns a single Category with the specified id.
     *
     * @param  int $category_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategoryById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCategoryByIdAsync($category_id, string $contentType = self::contentTypes['getCategoryById'][0])
    {
        return $this->getCategoryByIdAsyncWithHttpInfo($category_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCategoryByIdAsyncWithHttpInfo
     *
     * Returns a single Category with the specified id.
     *
     * @param  int $category_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategoryById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCategoryByIdAsyncWithHttpInfo($category_id, string $contentType = self::contentTypes['getCategoryById'][0])
    {
        $returnType = '\Opsuite2\Model\Category';
        $request = $this->getCategoryByIdRequest($category_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCategoryById'
     *
     * @param  int $category_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategoryById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getCategoryByIdRequest($category_id, string $contentType = self::contentTypes['getCategoryById'][0])
    {

        // verify the required parameter 'category_id' is set
        if ($category_id === null || (is_array($category_id) && count($category_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $category_id when calling getCategoryById'
            );
        }
        if ($category_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$category_id" when calling CategoriesApi.getCategoryById, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v1/Categories/{categoryId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($category_id !== null) {
            $resourcePath = str_replace(
                '{' . 'categoryId' . '}',
                ObjectSerializer::toPathValue($category_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
