# # Voucher

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **int** | The id of the card. | [optional]
**number** | **string** | The voucher number, must be unique and less than 20 characters.  Leave blank to create a voucher with a random number | [optional]
**balance** | **float** | The voucher balance. Must be zero when creating a new voucher | [optional]
**date_created** | **\DateTime** | When the voucher was created. | [optional]
**date_sold** | **\DateTime** | When the voucher was sold. | [optional]
**last_used** | **\DateTime** | When the voucher was last used | [optional]
**expiration_date** | **\DateTime** | The expiration date of the voucher.  Can be null for voucher that never expires. | [optional]
**item_master_id** | **int** | The id of the item associated with the voucher.  Identifies the type of voucher - credit note, gift card, etc. | [optional]
**item_master_sku** | **string** | The sku of the item associated with the voucher.  Can specify either id or sku when creating a voucher.  If both set the sku takes precedence. | [optional]
**location_id** | **int** | The location at which the card was sold | [optional]
**is_incomplete** | **bool** | Whether the voucher has been fully created or not. Usually set to false.  Only set to false if creating a voucher to be sold on a transaction that can be cancelled.  In that scenario the voucher cannot be used and is marked for removal. | [optional] [default to false]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
