# # TransactionLine

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **int** | The transaction line id.  Read Only - not required when posting a new transaction. | [optional]
**transaction_id** | **int** | The id of the associated transaction.  Read Only - not required when posting a new transaction. | [optional]
**item_id** | **int** | The item id. | [optional]
**item_sku** | **string** | The sku of the item.  Read Only - not required when posting a new transaction. | [optional]
**department_id** | **int** | The department id of the item.  Read Only - not required when posting a new transaction. | [optional]
**category_id** | **int** | The category id of the item.  Read Only - not required when posting a new transaction. | [optional]
**supplier_id** | **int** | The supplier id of the item.  Read Only - not required when posting a new transaction. | [optional]
**item_description** | **string** | The description of the item.  Read Only - not required when posting a new transaction. | [optional]
**unit_cost** | **float** | The unit cost of the item.  Read Only - not required when posting a new transaction. | [optional]
**regular_unit_price** | **float** | The regular unit price of the item.  Read Only - not required when posting a new transaction. | [optional]
**actual_unit_price** | **float** | The actual unit price of the item in this transaction.  Read Only - not required when posting a new transaction. | [optional]
**profit** | **float** | The profit on the item  Read Only - not required when posting a new transaction. | [optional]
**profit_margin** | **float** | The profit margin on the item  Read Only - not required when posting a new transaction. | [optional]
**quantity** | **float** | The quantity of the item sold. | [optional]
**extended_cost** | **float** | The cost for the whole line.  Read Only - not required when posting a new transaction. | [optional]
**extended_price** | **float** | The price for the whole line. |
**sales_tax** | **float** | The sales tax for the whole line. |
**tax_group_id** | **int** | The tax group id for the line  Read Only - not required when posting a new transaction. | [optional]
**tax_group_name** | **string** | The tax group name for the line  Read Only - not required when posting a new transaction. | [optional]
**tax_percentage** | **float** | The tax percentage for the line  Read Only - not required when posting a new transaction. | [optional]
**discount_reason_code_id** | **int** | The id of the associated discount reason code, if any. | [optional]
**discount_reason_code** | **string** | The associated discount reason code, if any.  Read Only - not required when posting a new transaction. | [optional]
**discount_reason_description** | **string** | The description of the associated reason code.  Read Only - not required when posting a new transaction. | [optional]
**return_reason_code_id** | **int** | The id of the associated return reason code, if any. | [optional]
**return_reason_code** | **string** | The associated return reason code, if any.  Read Only - not required when posting a new transaction. | [optional]
**tax_change_reason_code_id** | **int** | The id of the associated tax change reason code, if any. | [optional]
**tax_change_reason_code** | **string** | The associated tax change reason code, if any.  Read Only - not required when posting a new transaction. | [optional]
**comment** | **string** | Any comment associated with this line. | [optional]
**serial_number** | **string** | Any serial number associated with this line - e.g. the gift card number | [optional]
**line_benefits** | [**\Opsuite2\Model\TransactionLineBenefit[]**](TransactionLineBenefit.md) | Any line benefits where promotions have been applied to the transaction. | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
