# # RetailTransaction

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**transaction_id** | **int** | The id of the transaction.  Read Only - not required when posting a new transaction. | [optional]
**location_id** | **int** | The id of the POS location. | [optional]
**external_batch_number** | **int** | The batch number of the client system, if applicable. | [optional]
**external_transaction_number** | **int** | The transaction number of the client system, required when creating a new transaction.  This must be unique within the location and register context. | [optional]
**receipt_number** | **string** | The receipt number generated when the transaction is created.  Read Only - not required when posting a new transaction. | [optional]
**receipt_date_time** | **\DateTime** | The date and time of the transaction. |
**transaction_comment** | **string** | The comment on the transaction | [optional]
**transaction_reference** | **string** | The transaction reference | [optional]
**customer_id** | **int** | The id of the customer, if an account sale. | [optional]
**customer_account_number** | **string** | The account number of the customer, if an account sale.  Read Only - not required when posting a new transaction. | [optional]
**cashier_id** | **int** | The id of the cashier. |
**cashier_number** | **string** | The number of the cashier.  Read Only - not required when posting a new transaction. | [optional]
**register_id** | **int** | The id of the register the sale was made on. | [optional]
**register_number** | **int** | The Register Number the sale was made on.  Read Only - not required when posting a new transaction. | [optional]
**is_tax_inclusive_prices** | **bool** | Whether item prices and transaction totals include the tax element. |
**tax_total** | **float** | Transaction total tax.  Read Only - not required when posting a new transaction as this will be calculated from the lines. | [optional]
**transaction_total** | **float** | Transaction total.  Read Only - not required when posting a new transaction as this will be calculated from the lines. | [optional]
**lines** | [**\Opsuite2\Model\TransactionLine[]**](TransactionLine.md) | The items in the transaction. |
**tender_lines** | [**\Opsuite2\Model\TenderLine[]**](TenderLine.md) | The tender lines for the transaction. |
**transaction_benefits** | [**\Opsuite2\Model\TransactionBenefit[]**](TransactionBenefit.md) | Any transaction benefits where promotions have been applied to the transaction. | [optional]
**redeemed_discount_coupon_serial_numbers** | **string[]** | Serial numbers of any discount coupons that have been redeemed with this transaction. | [optional]
**redeemed_promotion_coupon_serial_numbers** | **string[]** | Serial numbers of any promotion coupons that have been redeemed with this transaction. | [optional]
**redeemed_bounce_back_coupon_serial_numbers** | **string[]** | Serial numbers of any bounce back coupons that have been redeemed with this transaction. | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
