# # ItemLocationDetail

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **int** | The item location detail id | [optional]
**location_id** | **int** | The location id |
**item_master_id** | **int** | The item master id |
**item_master** | [**\Opsuite2\Model\ItemMaster**](ItemMaster.md) |  | [optional]
**store_sku** | **string** | The item SKU |
**store_description** | **string** | The item description |
**quantity_on_hand** | **float** | The current quantity on hand at the location | [optional]
**quantity_available** | **float** | The current quantity available at the location (on hand - committed - offline) | [optional]
**quantity_on_order** | **float** | The current quantity on order at the location | [optional]
**cost** | **float** | The item cost | [optional]
**price** | **float** | The item price ex vat - only used if the location is tax exclusive | [optional]
**price_a** | **float** | The item price A ex vat - only used if the location is tax exclusive | [optional]
**price_b** | **float** | The item price B ex vat - only used if the location is tax exclusive | [optional]
**price_c** | **float** | The item price C ex vat - only used if the location is tax exclusive | [optional]
**sale_price** | **float** | The item sale price ex vat - only used if the location is tax exclusive between the sale start and end dates | [optional]
**price_inc_tax** | **float** | The item price inc vat - only used if the location is tax inclusive | [optional]
**price_a_inc_tax** | **float** | The item price A inc vat - only used if the location is tax inclusive | [optional]
**price_b_inc_tax** | **float** | The item price B inc vat - only used if the location is tax inclusive | [optional]
**price_c_inc_tax** | **float** | The item price C inc vat - only used if the location is tax inclusive | [optional]
**sale_price_inc_tax** | **float** | The item sale price inc vat - only used if the location is tax inclusive between the sale start and end dates | [optional]
**sale_start_date** | **\DateTime** | If set, the date the item changes to the sale price | [optional]
**sale_end_date** | **\DateTime** | If set, the date the item changes back to the normal price | [optional]
**tax_rate_id** | **int** | The id of the tax applied to the item | [optional]
**active** | **bool** | Whether the item is active or not | [optional]
**web_item** | **bool** | Whether the item is available on the web or not | [optional]
**item_type_id** | **int** | The item type:&lt;br /&gt;  0 Standard&lt;br /&gt;  6 Weighed&lt;br /&gt;  7 Non-Inventory&lt;br /&gt;  9 Voucher&lt;br /&gt;  10 Scale&lt;br /&gt;  11 OpSuite Kit&lt;br /&gt;  12 Non-Inventory Scale&lt;br /&gt; | [optional]
**max_restock_level** | **float** | The maximum quantity of the item that can be stocked at this location | [optional]
**min_reorder_point** | **float** | The minimum quantity of the item that should be stocked at this location.  If stock falls below this level then it should be placed on a purchase order. | [optional]
**do_not_sell** | **bool** | Whether the item can be sold or not | [optional] [default to false]
**commission_percent_profit** | **float** | The commission percentage on an item (not used) | [optional]
**last_sold** | **\DateTime** | When the item was last sold at this location | [optional]
**last_received** | **\DateTime** | When the item was last received at this location | [optional]
**last_updated** | **\DateTime** | When the item was last updated at this location | [optional]
**last_in_stocktake** | **\DateTime** | When the item was last in a stock take at this location | [optional]
**last_counted** | **\DateTime** | When the item was last counted in a stock take at this location | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
