# Opsuite2\VouchersApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1VouchersGet()**](VouchersApi.md#apiV1VouchersGet) | **GET** /api/v1/Vouchers | Returns an array of Vouchers that match the specified search criteria. |
| [**apiV1VouchersPatchMultipleVouchersPatch()**](VouchersApi.md#apiV1VouchersPatchMultipleVouchersPatch) | **PATCH** /api/v1/Vouchers/PatchMultipleVouchers | Updates specified properties of multiple vouchers. |
| [**apiV1VouchersPost()**](VouchersApi.md#apiV1VouchersPost) | **POST** /api/v1/Vouchers | Creates a new voucher. |
| [**apiV1VouchersPostMultipleVouchersPost()**](VouchersApi.md#apiV1VouchersPostMultipleVouchersPost) | **POST** /api/v1/Vouchers/PostMultipleVouchers | Creates multiple new vouchers. |
| [**apiV1VouchersPostVoucherNumbersPost()**](VouchersApi.md#apiV1VouchersPostVoucherNumbersPost) | **POST** /api/v1/Vouchers/PostVoucherNumbers | Creates the specified number of new vouchers. |
| [**apiV1VouchersPostVouchersPost()**](VouchersApi.md#apiV1VouchersPostVouchersPost) | **POST** /api/v1/Vouchers/PostVouchers | Creates the specified number of new vouchers. |
| [**apiV1VouchersVoucherIdPatch()**](VouchersApi.md#apiV1VouchersVoucherIdPatch) | **PATCH** /api/v1/Vouchers/{voucherId} | Updates specified properties of a voucher. |
| [**getVoucherById()**](VouchersApi.md#getVoucherById) | **GET** /api/v1/Vouchers/{voucherId} | Returns a single Voucher with the specified id. |
| [**getVoucherByNumber()**](VouchersApi.md#getVoucherByNumber) | **GET** /api/v1/Vouchers/GetVoucherByNumber | Returns a single Voucher with the specified number. |


## `apiV1VouchersGet()`

```php
apiV1VouchersGet($page_number, $page_size, $item_master_id, $item_master_sku, $sku_search_operator, $location_id, $balance, $balance_search_operator, $date_created_date_range_start, $date_created_date_range_end, $sold, $date_sold_date_range_start, $date_sold_date_range_end, $last_used_date_range_start, $last_used_date_range_end, $expired, $expiration_date_date_range_start, $expiration_date_date_range_end): \Opsuite2\Model\Voucher[]
```

Returns an array of Vouchers that match the specified search criteria.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\VouchersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$item_master_id = 56; // int
$item_master_sku = 'item_master_sku_example'; // string
$sku_search_operator = new \Opsuite2\Model\\Opsuite2\Model\StringSearchOperatorEnum(); // \Opsuite2\Model\StringSearchOperatorEnum
$location_id = 56; // int
$balance = 3.4; // float
$balance_search_operator = new \Opsuite2\Model\\Opsuite2\Model\NumericSearchOperatorEnum(); // \Opsuite2\Model\NumericSearchOperatorEnum
$date_created_date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$date_created_date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$sold = True; // bool
$date_sold_date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$date_sold_date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$last_used_date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$last_used_date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$expired = True; // bool
$expiration_date_date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$expiration_date_date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime

try {
    $result = $apiInstance->apiV1VouchersGet($page_number, $page_size, $item_master_id, $item_master_sku, $sku_search_operator, $location_id, $balance, $balance_search_operator, $date_created_date_range_start, $date_created_date_range_end, $sold, $date_sold_date_range_start, $date_sold_date_range_end, $last_used_date_range_start, $last_used_date_range_end, $expired, $expiration_date_date_range_start, $expiration_date_date_range_end);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VouchersApi->apiV1VouchersGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **item_master_id** | **int**|  | [optional] |
| **item_master_sku** | **string**|  | [optional] |
| **sku_search_operator** | [**\Opsuite2\Model\StringSearchOperatorEnum**](../Model/.md)|  | [optional] |
| **location_id** | **int**|  | [optional] |
| **balance** | **float**|  | [optional] |
| **balance_search_operator** | [**\Opsuite2\Model\NumericSearchOperatorEnum**](../Model/.md)|  | [optional] |
| **date_created_date_range_start** | **\DateTime**|  | [optional] |
| **date_created_date_range_end** | **\DateTime**|  | [optional] |
| **sold** | **bool**|  | [optional] |
| **date_sold_date_range_start** | **\DateTime**|  | [optional] |
| **date_sold_date_range_end** | **\DateTime**|  | [optional] |
| **last_used_date_range_start** | **\DateTime**|  | [optional] |
| **last_used_date_range_end** | **\DateTime**|  | [optional] |
| **expired** | **bool**|  | [optional] |
| **expiration_date_date_range_start** | **\DateTime**|  | [optional] |
| **expiration_date_date_range_end** | **\DateTime**|  | [optional] |

### Return type

[**\Opsuite2\Model\Voucher[]**](../Model/Voucher.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1VouchersPatchMultipleVouchersPatch()`

```php
apiV1VouchersPatchMultipleVouchersPatch($patch_collection): \Opsuite2\Model\PatchResponse[]
```

Updates specified properties of multiple vouchers.

Returns an array of PatchResponse objects.  Each object contains the values that  would be returned from making a single patch.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\VouchersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$patch_collection = array(new \Opsuite2\Model\PatchCollection()); // \Opsuite2\Model\PatchCollection[]

try {
    $result = $apiInstance->apiV1VouchersPatchMultipleVouchersPatch($patch_collection);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VouchersApi->apiV1VouchersPatchMultipleVouchersPatch: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **patch_collection** | [**\Opsuite2\Model\PatchCollection[]**](../Model/PatchCollection.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\PatchResponse[]**](../Model/PatchResponse.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1VouchersPost()`

```php
apiV1VouchersPost($voucher): \Opsuite2\Model\Voucher
```

Creates a new voucher.

Returns the newly created Voucher.  Returns a 422 response code if a voucher already exists with the same voucher code.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\VouchersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$voucher = new \Opsuite2\Model\Voucher(); // \Opsuite2\Model\Voucher

try {
    $result = $apiInstance->apiV1VouchersPost($voucher);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VouchersApi->apiV1VouchersPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **voucher** | [**\Opsuite2\Model\Voucher**](../Model/Voucher.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\Voucher**](../Model/Voucher.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1VouchersPostMultipleVouchersPost()`

```php
apiV1VouchersPostMultipleVouchersPost($voucher): \Opsuite2\Model\PostResponseVoucher[]
```

Creates multiple new vouchers.

Returns an array of PostResponse objects.  Each object contains the values that  would be returned from making a single post.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\VouchersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$voucher = array(new \Opsuite2\Model\Voucher()); // \Opsuite2\Model\Voucher[]

try {
    $result = $apiInstance->apiV1VouchersPostMultipleVouchersPost($voucher);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VouchersApi->apiV1VouchersPostMultipleVouchersPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **voucher** | [**\Opsuite2\Model\Voucher[]**](../Model/Voucher.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\PostResponseVoucher[]**](../Model/PostResponseVoucher.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1VouchersPostVoucherNumbersPost()`

```php
apiV1VouchersPostVoucherNumbersPost($item_master_sku, $item_master_id, $location_id, $expiration_date, $request_body): \Opsuite2\Model\PostResponseVouchers
```

Creates the specified number of new vouchers.

Returns a PostResponse with an array of created vouchers

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\VouchersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$item_master_sku = 'item_master_sku_example'; // string
$item_master_id = 56; // int
$location_id = 56; // int
$expiration_date = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$request_body = array('request_body_example'); // string[]

try {
    $result = $apiInstance->apiV1VouchersPostVoucherNumbersPost($item_master_sku, $item_master_id, $location_id, $expiration_date, $request_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VouchersApi->apiV1VouchersPostVoucherNumbersPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **item_master_sku** | **string**|  | [optional] |
| **item_master_id** | **int**|  | [optional] |
| **location_id** | **int**|  | [optional] |
| **expiration_date** | **\DateTime**|  | [optional] |
| **request_body** | [**string[]**](../Model/string.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\PostResponseVouchers**](../Model/PostResponseVouchers.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1VouchersPostVouchersPost()`

```php
apiV1VouchersPostVouchersPost($number, $voucher): \Opsuite2\Model\PostResponseVouchers
```

Creates the specified number of new vouchers.

Returns a PostResponse with an array of created vouchers

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\VouchersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$number = 56; // int
$voucher = new \Opsuite2\Model\Voucher(); // \Opsuite2\Model\Voucher

try {
    $result = $apiInstance->apiV1VouchersPostVouchersPost($number, $voucher);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VouchersApi->apiV1VouchersPostVouchersPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **number** | **int**|  | [optional] |
| **voucher** | [**\Opsuite2\Model\Voucher**](../Model/Voucher.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\PostResponseVouchers**](../Model/PostResponseVouchers.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1VouchersVoucherIdPatch()`

```php
apiV1VouchersVoucherIdPatch($voucher_id, $patch)
```

Updates specified properties of a voucher.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\VouchersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$voucher_id = 56; // int
$patch = array(new \Opsuite2\Model\Patch()); // \Opsuite2\Model\Patch[]

try {
    $apiInstance->apiV1VouchersVoucherIdPatch($voucher_id, $patch);
} catch (Exception $e) {
    echo 'Exception when calling VouchersApi->apiV1VouchersVoucherIdPatch: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **voucher_id** | **int**|  | |
| **patch** | [**\Opsuite2\Model\Patch[]**](../Model/Patch.md)|  | [optional] |

### Return type

void (empty response body)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getVoucherById()`

```php
getVoucherById($voucher_id): \Opsuite2\Model\Voucher
```

Returns a single Voucher with the specified id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\VouchersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$voucher_id = 56; // int

try {
    $result = $apiInstance->getVoucherById($voucher_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VouchersApi->getVoucherById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **voucher_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\Voucher**](../Model/Voucher.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getVoucherByNumber()`

```php
getVoucherByNumber($number): \Opsuite2\Model\Voucher
```

Returns a single Voucher with the specified number.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\VouchersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$number = 'number_example'; // string

try {
    $result = $apiInstance->getVoucherByNumber($number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VouchersApi->getVoucherByNumber: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **number** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\Voucher**](../Model/Voucher.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
