# Opsuite2\UnitsOfMeasureApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1UnitsOfMeasureDefaultUomIdGet()**](UnitsOfMeasureApi.md#apiV1UnitsOfMeasureDefaultUomIdGet) | **GET** /api/v1/UnitsOfMeasure/DefaultUomId | Returns an integer which is the id of the default unit of measure. |
| [**apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGet()**](UnitsOfMeasureApi.md#apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGet) | **GET** /api/v1/UnitsOfMeasure/GetUnitOfMeasureByCode | Returns a single UnitOfMeasure with the specified code. |
| [**apiV1UnitsOfMeasureGetUomsByDescriptionGet()**](UnitsOfMeasureApi.md#apiV1UnitsOfMeasureGetUomsByDescriptionGet) | **GET** /api/v1/UnitsOfMeasure/GetUomsByDescription | Returns an array of UnitOfMeasure with the specified description. |
| [**apiV1UnitsOfMeasurePost()**](UnitsOfMeasureApi.md#apiV1UnitsOfMeasurePost) | **POST** /api/v1/UnitsOfMeasure | Creates a new UnitOfMeasure. |
| [**apiV1UnitsOfMeasureUnitOfMeasureIdPatch()**](UnitsOfMeasureApi.md#apiV1UnitsOfMeasureUnitOfMeasureIdPatch) | **PATCH** /api/v1/UnitsOfMeasure/{unitOfMeasureId} | Updates specified properties of a UnitOfMeasure. |
| [**getUnitOfMeasureById()**](UnitsOfMeasureApi.md#getUnitOfMeasureById) | **GET** /api/v1/UnitsOfMeasure/{unitOfMeasureId} | Returns a single UnitOfMeasure with the specified id. |


## `apiV1UnitsOfMeasureDefaultUomIdGet()`

```php
apiV1UnitsOfMeasureDefaultUomIdGet(): int
```

Returns an integer which is the id of the default unit of measure.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\UnitsOfMeasureApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->apiV1UnitsOfMeasureDefaultUomIdGet();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UnitsOfMeasureApi->apiV1UnitsOfMeasureDefaultUomIdGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

**int**

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGet()`

```php
apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGet($code): \Opsuite2\Model\UnitOfMeasure
```

Returns a single UnitOfMeasure with the specified code.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\UnitsOfMeasureApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$code = 'code_example'; // string

try {
    $result = $apiInstance->apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGet($code);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UnitsOfMeasureApi->apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **code** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\UnitOfMeasure**](../Model/UnitOfMeasure.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1UnitsOfMeasureGetUomsByDescriptionGet()`

```php
apiV1UnitsOfMeasureGetUomsByDescriptionGet($description): \Opsuite2\Model\UnitOfMeasure[]
```

Returns an array of UnitOfMeasure with the specified description.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\UnitsOfMeasureApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$description = 'description_example'; // string

try {
    $result = $apiInstance->apiV1UnitsOfMeasureGetUomsByDescriptionGet($description);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UnitsOfMeasureApi->apiV1UnitsOfMeasureGetUomsByDescriptionGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **description** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\UnitOfMeasure[]**](../Model/UnitOfMeasure.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1UnitsOfMeasurePost()`

```php
apiV1UnitsOfMeasurePost($unit_of_measure): \Opsuite2\Model\UnitOfMeasure
```

Creates a new UnitOfMeasure.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\UnitsOfMeasureApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$unit_of_measure = new \Opsuite2\Model\UnitOfMeasure(); // \Opsuite2\Model\UnitOfMeasure

try {
    $result = $apiInstance->apiV1UnitsOfMeasurePost($unit_of_measure);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UnitsOfMeasureApi->apiV1UnitsOfMeasurePost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **unit_of_measure** | [**\Opsuite2\Model\UnitOfMeasure**](../Model/UnitOfMeasure.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\UnitOfMeasure**](../Model/UnitOfMeasure.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1UnitsOfMeasureUnitOfMeasureIdPatch()`

```php
apiV1UnitsOfMeasureUnitOfMeasureIdPatch($unit_of_measure_id, $patch)
```

Updates specified properties of a UnitOfMeasure.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\UnitsOfMeasureApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$unit_of_measure_id = 56; // int
$patch = array(new \Opsuite2\Model\Patch()); // \Opsuite2\Model\Patch[]

try {
    $apiInstance->apiV1UnitsOfMeasureUnitOfMeasureIdPatch($unit_of_measure_id, $patch);
} catch (Exception $e) {
    echo 'Exception when calling UnitsOfMeasureApi->apiV1UnitsOfMeasureUnitOfMeasureIdPatch: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **unit_of_measure_id** | **int**|  | |
| **patch** | [**\Opsuite2\Model\Patch[]**](../Model/Patch.md)|  | [optional] |

### Return type

void (empty response body)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getUnitOfMeasureById()`

```php
getUnitOfMeasureById($unit_of_measure_id): \Opsuite2\Model\UnitOfMeasure
```

Returns a single UnitOfMeasure with the specified id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\UnitsOfMeasureApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$unit_of_measure_id = 56; // int

try {
    $result = $apiInstance->getUnitOfMeasureById($unit_of_measure_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UnitsOfMeasureApi->getUnitOfMeasureById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **unit_of_measure_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\UnitOfMeasure**](../Model/UnitOfMeasure.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
