# Opsuite2\TransferDetailsApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1TransferDetailsGetTransferDetailsByOrderNumberGet()**](TransferDetailsApi.md#apiV1TransferDetailsGetTransferDetailsByOrderNumberGet) | **GET** /api/v1/TransferDetails/GetTransferDetailsByOrderNumber | Returns a TransferDetails for a given inventory control document order number. |
| [**apiV1TransferDetailsGetTransferDetailsGet()**](TransferDetailsApi.md#apiV1TransferDetailsGetTransferDetailsGet) | **GET** /api/v1/TransferDetails/GetTransferDetails | Returns an array of TransferDetails that match the specified search criteria. |
| [**apiV1TransferDetailsIssueTransferPost()**](TransferDetailsApi.md#apiV1TransferDetailsIssueTransferPost) | **POST** /api/v1/TransferDetails/IssueTransfer | Issues a transfer |
| [**getTransferDetailsById()**](TransferDetailsApi.md#getTransferDetailsById) | **GET** /api/v1/TransferDetails/{inventoryControlDocumentId} | Returns a TransferDetails for a given inventory control document id. |


## `apiV1TransferDetailsGetTransferDetailsByOrderNumberGet()`

```php
apiV1TransferDetailsGetTransferDetailsByOrderNumberGet($order_number): \Opsuite2\Model\TransferDetails
```

Returns a TransferDetails for a given inventory control document order number.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\TransferDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_number = 'order_number_example'; // string

try {
    $result = $apiInstance->apiV1TransferDetailsGetTransferDetailsByOrderNumberGet($order_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TransferDetailsApi->apiV1TransferDetailsGetTransferDetailsByOrderNumberGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_number** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\TransferDetails**](../Model/TransferDetails.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1TransferDetailsGetTransferDetailsGet()`

```php
apiV1TransferDetailsGetTransferDetailsGet($page_number, $page_size, $date_created_date_range_start, $date_created_date_range_end, $date_placed_date_range_start, $date_placed_date_range_end, $last_updated_date_range_start, $last_updated_date_range_end, $transfer_type, $location_id, $transfer_status, $source_location_id, $destination_location_id, $order_number, $order_number_search_operator): \Opsuite2\Model\TransferDetails[]
```

Returns an array of TransferDetails that match the specified search criteria.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\TransferDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$date_created_date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$date_created_date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$date_placed_date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$date_placed_date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$last_updated_date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$last_updated_date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$transfer_type = 56; // int
$location_id = 56; // int
$transfer_status = 'transfer_status_example'; // string
$source_location_id = 56; // int
$destination_location_id = 56; // int
$order_number = 'order_number_example'; // string
$order_number_search_operator = new \Opsuite2\Model\\Opsuite2\Model\SimpleSearchOperatorEnum(); // \Opsuite2\Model\SimpleSearchOperatorEnum

try {
    $result = $apiInstance->apiV1TransferDetailsGetTransferDetailsGet($page_number, $page_size, $date_created_date_range_start, $date_created_date_range_end, $date_placed_date_range_start, $date_placed_date_range_end, $last_updated_date_range_start, $last_updated_date_range_end, $transfer_type, $location_id, $transfer_status, $source_location_id, $destination_location_id, $order_number, $order_number_search_operator);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TransferDetailsApi->apiV1TransferDetailsGetTransferDetailsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **date_created_date_range_start** | **\DateTime**|  | [optional] |
| **date_created_date_range_end** | **\DateTime**|  | [optional] |
| **date_placed_date_range_start** | **\DateTime**|  | [optional] |
| **date_placed_date_range_end** | **\DateTime**|  | [optional] |
| **last_updated_date_range_start** | **\DateTime**|  | [optional] |
| **last_updated_date_range_end** | **\DateTime**|  | [optional] |
| **transfer_type** | **int**|  | [optional] |
| **location_id** | **int**|  | [optional] |
| **transfer_status** | **string**|  | [optional] |
| **source_location_id** | **int**|  | [optional] |
| **destination_location_id** | **int**|  | [optional] |
| **order_number** | **string**|  | [optional] |
| **order_number_search_operator** | [**\Opsuite2\Model\SimpleSearchOperatorEnum**](../Model/.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\TransferDetails[]**](../Model/TransferDetails.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1TransferDetailsIssueTransferPost()`

```php
apiV1TransferDetailsIssueTransferPost($transfer_details_update): \Opsuite2\Model\TransferDetailsUpdate
```

Issues a transfer

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\TransferDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$transfer_details_update = new \Opsuite2\Model\TransferDetailsUpdate(); // \Opsuite2\Model\TransferDetailsUpdate

try {
    $result = $apiInstance->apiV1TransferDetailsIssueTransferPost($transfer_details_update);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TransferDetailsApi->apiV1TransferDetailsIssueTransferPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **transfer_details_update** | [**\Opsuite2\Model\TransferDetailsUpdate**](../Model/TransferDetailsUpdate.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\TransferDetailsUpdate**](../Model/TransferDetailsUpdate.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getTransferDetailsById()`

```php
getTransferDetailsById($inventory_control_document_id): \Opsuite2\Model\TransferDetails
```

Returns a TransferDetails for a given inventory control document id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\TransferDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_control_document_id = 56; // int

try {
    $result = $apiInstance->getTransferDetailsById($inventory_control_document_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TransferDetailsApi->getTransferDetailsById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_control_document_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\TransferDetails**](../Model/TransferDetails.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
