# Opsuite2\TransactionsApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1TransactionsGetTransactionsGet()**](TransactionsApi.md#apiV1TransactionsGetTransactionsGet) | **GET** /api/v1/Transactions/GetTransactions | Returns an array of Transactions based on the supplied search criteria. |
| [**apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGet()**](TransactionsApi.md#apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGet) | **GET** /api/v1/Transactions/GetTransactionsWithIdGreaterThanSpecifiedId | Returns an array of Transactions with an id greater than the specified id. |
| [**apiV1TransactionsPost()**](TransactionsApi.md#apiV1TransactionsPost) | **POST** /api/v1/Transactions | Creates a new transaction. |
| [**apiV1TransactionsRefundTransactionPost()**](TransactionsApi.md#apiV1TransactionsRefundTransactionPost) | **POST** /api/v1/Transactions/RefundTransaction | Refunds a transaction. |
| [**apiV2TransactionsGetTransactionsGet()**](TransactionsApi.md#apiV2TransactionsGetTransactionsGet) | **GET** /api/v2/Transactions/GetTransactions | Returns an array of Transactions based on the supplied search criteria. |
| [**getTransactionById()**](TransactionsApi.md#getTransactionById) | **GET** /api/v1/Transactions/{transactionId} | Returns a single Transaction with the specified id. |


## `apiV1TransactionsGetTransactionsGet()`

```php
apiV1TransactionsGetTransactionsGet($page_number, $page_size, $customer_id, $recall_id, $receipt_number, $order_reference, $transaction_reference, $date_range_start, $date_range_end): \Opsuite2\Model\RetailTransaction[]
```

Returns an array of Transactions based on the supplied search criteria.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\TransactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$customer_id = 56; // int
$recall_id = 56; // int
$receipt_number = 'receipt_number_example'; // string
$order_reference = 'order_reference_example'; // string
$transaction_reference = 'transaction_reference_example'; // string
$date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime

try {
    $result = $apiInstance->apiV1TransactionsGetTransactionsGet($page_number, $page_size, $customer_id, $recall_id, $receipt_number, $order_reference, $transaction_reference, $date_range_start, $date_range_end);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TransactionsApi->apiV1TransactionsGetTransactionsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **customer_id** | **int**|  | [optional] |
| **recall_id** | **int**|  | [optional] |
| **receipt_number** | **string**|  | [optional] |
| **order_reference** | **string**|  | [optional] |
| **transaction_reference** | **string**|  | [optional] |
| **date_range_start** | **\DateTime**|  | [optional] |
| **date_range_end** | **\DateTime**|  | [optional] |

### Return type

[**\Opsuite2\Model\RetailTransaction[]**](../Model/RetailTransaction.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGet()`

```php
apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGet($specified_id, $batch_size): \Opsuite2\Model\RetailTransaction[]
```

Returns an array of Transactions with an id greater than the specified id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\TransactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$specified_id = 56; // int
$batch_size = 56; // int

try {
    $result = $apiInstance->apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGet($specified_id, $batch_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TransactionsApi->apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **specified_id** | **int**|  | [optional] |
| **batch_size** | **int**|  | [optional] |

### Return type

[**\Opsuite2\Model\RetailTransaction[]**](../Model/RetailTransaction.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1TransactionsPost()`

```php
apiV1TransactionsPost($retail_transaction): \Opsuite2\Model\RetailTransaction
```

Creates a new transaction.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\TransactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$retail_transaction = new \Opsuite2\Model\RetailTransaction(); // \Opsuite2\Model\RetailTransaction

try {
    $result = $apiInstance->apiV1TransactionsPost($retail_transaction);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TransactionsApi->apiV1TransactionsPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **retail_transaction** | [**\Opsuite2\Model\RetailTransaction**](../Model/RetailTransaction.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\RetailTransaction**](../Model/RetailTransaction.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1TransactionsRefundTransactionPost()`

```php
apiV1TransactionsRefundTransactionPost($refund_transaction): \Opsuite2\Model\RetailTransaction
```

Refunds a transaction.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\TransactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$refund_transaction = new \Opsuite2\Model\RefundTransaction(); // \Opsuite2\Model\RefundTransaction

try {
    $result = $apiInstance->apiV1TransactionsRefundTransactionPost($refund_transaction);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TransactionsApi->apiV1TransactionsRefundTransactionPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **refund_transaction** | [**\Opsuite2\Model\RefundTransaction**](../Model/RefundTransaction.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\RetailTransaction**](../Model/RetailTransaction.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2TransactionsGetTransactionsGet()`

```php
apiV2TransactionsGetTransactionsGet($page_number, $page_size, $location_id, $customer_id, $recall_id, $receipt_number, $order_reference, $transaction_reference, $date_range_start, $date_range_end): \Opsuite2\Model\RetailTransaction[]
```

Returns an array of Transactions based on the supplied search criteria.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\TransactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$location_id = 56; // int
$customer_id = 56; // int
$recall_id = 56; // int
$receipt_number = 'receipt_number_example'; // string
$order_reference = 'order_reference_example'; // string
$transaction_reference = 'transaction_reference_example'; // string
$date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime

try {
    $result = $apiInstance->apiV2TransactionsGetTransactionsGet($page_number, $page_size, $location_id, $customer_id, $recall_id, $receipt_number, $order_reference, $transaction_reference, $date_range_start, $date_range_end);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TransactionsApi->apiV2TransactionsGetTransactionsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **location_id** | **int**|  | [optional] |
| **customer_id** | **int**|  | [optional] |
| **recall_id** | **int**|  | [optional] |
| **receipt_number** | **string**|  | [optional] |
| **order_reference** | **string**|  | [optional] |
| **transaction_reference** | **string**|  | [optional] |
| **date_range_start** | **\DateTime**|  | [optional] |
| **date_range_end** | **\DateTime**|  | [optional] |

### Return type

[**\Opsuite2\Model\RetailTransaction[]**](../Model/RetailTransaction.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getTransactionById()`

```php
getTransactionById($transaction_id): \Opsuite2\Model\RetailTransaction
```

Returns a single Transaction with the specified id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\TransactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$transaction_id = 56; // int

try {
    $result = $apiInstance->getTransactionById($transaction_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TransactionsApi->getTransactionById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **transaction_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\RetailTransaction**](../Model/RetailTransaction.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
