# Opsuite2\TransactionHeadersApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1TransactionHeadersGet()**](TransactionHeadersApi.md#apiV1TransactionHeadersGet) | **GET** /api/v1/TransactionHeaders | Returns an array of TransactionHeaders that match the specified search criteria. |
| [**apiV1TransactionHeadersTransactionIdLinesGet()**](TransactionHeadersApi.md#apiV1TransactionHeadersTransactionIdLinesGet) | **GET** /api/v1/TransactionHeaders/{transactionId}/Lines | Returns an array of transaction lines for the specified transaction header. |


## `apiV1TransactionHeadersGet()`

```php
apiV1TransactionHeadersGet($page_number, $page_size, $customer_id, $recall_id, $receipt_number, $order_reference, $transaction_reference, $date_range_start, $date_range_end): \Opsuite2\Model\TransactionHeader[]
```

Returns an array of TransactionHeaders that match the specified search criteria.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\TransactionHeadersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$customer_id = 56; // int
$recall_id = 56; // int
$receipt_number = 'receipt_number_example'; // string
$order_reference = 'order_reference_example'; // string
$transaction_reference = 'transaction_reference_example'; // string
$date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime

try {
    $result = $apiInstance->apiV1TransactionHeadersGet($page_number, $page_size, $customer_id, $recall_id, $receipt_number, $order_reference, $transaction_reference, $date_range_start, $date_range_end);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TransactionHeadersApi->apiV1TransactionHeadersGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **customer_id** | **int**|  | [optional] |
| **recall_id** | **int**|  | [optional] |
| **receipt_number** | **string**|  | [optional] |
| **order_reference** | **string**|  | [optional] |
| **transaction_reference** | **string**|  | [optional] |
| **date_range_start** | **\DateTime**|  | [optional] |
| **date_range_end** | **\DateTime**|  | [optional] |

### Return type

[**\Opsuite2\Model\TransactionHeader[]**](../Model/TransactionHeader.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1TransactionHeadersTransactionIdLinesGet()`

```php
apiV1TransactionHeadersTransactionIdLinesGet($transaction_id, $page_number, $page_size): \Opsuite2\Model\TransactionLine[]
```

Returns an array of transaction lines for the specified transaction header.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\TransactionHeadersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$transaction_id = 56; // int
$page_number = 56; // int
$page_size = 56; // int

try {
    $result = $apiInstance->apiV1TransactionHeadersTransactionIdLinesGet($transaction_id, $page_number, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TransactionHeadersApi->apiV1TransactionHeadersTransactionIdLinesGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **transaction_id** | **int**|  | |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |

### Return type

[**\Opsuite2\Model\TransactionLine[]**](../Model/TransactionLine.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
