# Opsuite2\TenderDefinitionsApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1TenderDefinitionsGetTenderDefinitionByCodeAndLocationIdGet()**](TenderDefinitionsApi.md#apiV1TenderDefinitionsGetTenderDefinitionByCodeAndLocationIdGet) | **GET** /api/v1/TenderDefinitions/GetTenderDefinitionByCodeAndLocationId | Returns a single TenderDefinition with the specified code and location id. |
| [**apiV1TenderDefinitionsGetTenderDefinitionsByLocationIdGet()**](TenderDefinitionsApi.md#apiV1TenderDefinitionsGetTenderDefinitionsByLocationIdGet) | **GET** /api/v1/TenderDefinitions/GetTenderDefinitionsByLocationId | Returns an array of TenderDefinitions that match the specified search criteria. |
| [**getTenderDefinitionById()**](TenderDefinitionsApi.md#getTenderDefinitionById) | **GET** /api/v1/TenderDefinitions/{tenderDefinitionId} | Returns a single TenderDefinition with the specified id. |


## `apiV1TenderDefinitionsGetTenderDefinitionByCodeAndLocationIdGet()`

```php
apiV1TenderDefinitionsGetTenderDefinitionByCodeAndLocationIdGet($code, $location_id): \Opsuite2\Model\TenderDefinition[]
```

Returns a single TenderDefinition with the specified code and location id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\TenderDefinitionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$code = 'code_example'; // string
$location_id = 56; // int

try {
    $result = $apiInstance->apiV1TenderDefinitionsGetTenderDefinitionByCodeAndLocationIdGet($code, $location_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TenderDefinitionsApi->apiV1TenderDefinitionsGetTenderDefinitionByCodeAndLocationIdGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **code** | **string**|  | [optional] |
| **location_id** | **int**|  | [optional] |

### Return type

[**\Opsuite2\Model\TenderDefinition[]**](../Model/TenderDefinition.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1TenderDefinitionsGetTenderDefinitionsByLocationIdGet()`

```php
apiV1TenderDefinitionsGetTenderDefinitionsByLocationIdGet($page_number, $page_size, $location_id): \Opsuite2\Model\TenderDefinition[]
```

Returns an array of TenderDefinitions that match the specified search criteria.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\TenderDefinitionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$location_id = 56; // int

try {
    $result = $apiInstance->apiV1TenderDefinitionsGetTenderDefinitionsByLocationIdGet($page_number, $page_size, $location_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TenderDefinitionsApi->apiV1TenderDefinitionsGetTenderDefinitionsByLocationIdGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **location_id** | **int**|  | [optional] |

### Return type

[**\Opsuite2\Model\TenderDefinition[]**](../Model/TenderDefinition.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getTenderDefinitionById()`

```php
getTenderDefinitionById($tender_definition_id): \Opsuite2\Model\TenderDefinition
```

Returns a single TenderDefinition with the specified id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\TenderDefinitionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$tender_definition_id = 56; // int

try {
    $result = $apiInstance->getTenderDefinitionById($tender_definition_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TenderDefinitionsApi->getTenderDefinitionById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **tender_definition_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\TenderDefinition**](../Model/TenderDefinition.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
